/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.beans.PropertyChangeSupport;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.wizard.WizardModel;
import oracle.dmt.dataminer.workflow.dialog.build.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.StoplistPanel;
import oracle.dmt.dataminer.workflow.dialog.build.TextSettingsThemePanel;
import oracle.dmt.dataminer.workflow.dialog.build.TextSettingsTokenPanel;
import oracle.dmt.dataminer.workflow.dialog.build.TextTransColumnSettingThemePanel;
import oracle.dmt.dataminer.workflow.dialog.build.TextTransColumnSettingTokenPanel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.ide.Context;

public class StoplistWizardModel
extends WizardModel {
    private static final Logger theLogger = Logger.getLogger(StoplistWizardModel.class.getName());
    private volatile boolean _wizardIsCancelled;
    private Context _context;
    private JPanel _parent;
    private AbstractBuildNode _node;
    private String _stoplistName;
    private StoplistType _stoplist;
    private Entry _selectStoplist;
    private boolean _emptyStoplist;
    private String _emptyStoplistLanguage;
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    private static final String DEFAULT_STOPLIST = DialogsLrb.get("BUILD_TEXT_DEFAULT_STOPLIST_NAME");
    private static final String STOPLIST_SUFFIX = "_SLTS";
    private static final int MAX_COLUMN_LEN = 30;

    public StoplistWizardModel(JPanel jPanel, PropertyModel propertyModel, Context context, AbstractBuildNode abstractBuildNode, String string) {
        this._context = context;
        this._parent = jPanel;
        this._node = abstractBuildNode;
        this._stoplistName = this.getUniqueName(string == null ? DEFAULT_STOPLIST : string + STOPLIST_SUFFIX);
    }

    public void setWizardCancelled(boolean bl) {
        boolean bl2 = this._wizardIsCancelled;
        this._wizardIsCancelled = bl;
        this._changeSupport.firePropertyChange("wizardCancelled", bl2, bl);
    }

    private String getUniqueName(String string) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        BuildNodeType.Stoplists stoplists = null;
        if (this._parent instanceof StoplistPanel) {
            stoplists = ((StoplistPanel)this._parent).getStoplists();
        } else if (this._parent instanceof TextTransColumnSettingThemePanel) {
            stoplists = ((TextTransColumnSettingThemePanel)this._parent).getStoplists();
        } else if (this._parent instanceof TextTransColumnSettingTokenPanel) {
            stoplists = ((TextTransColumnSettingTokenPanel)this._parent).getStoplists();
        } else if (this._parent instanceof TextSettingsTokenPanel) {
            stoplists = ((TextSettingsTokenPanel)this._parent).getStoplists();
        } else if (this._parent instanceof TextSettingsThemePanel) {
            stoplists = ((TextSettingsThemePanel)this._parent).getStoplists();
        }
        for (StoplistType stoplistType : stoplists.getStoplist()) {
            hashMap.put(stoplistType.getName(), Boolean.TRUE);
        }
        Object object = null;
        object = string;
        int n = 0;
        while (hashMap.containsKey(object)) {
            object = string + "_" + ++n;
            int n2 = ((String)object).length();
            if (n2 <= 30) continue;
            int n3 = n2 - 30;
            object = string.substring(0, string.length() - n3) + "_" + n;
        }
        return object;
    }

    public boolean isNameUnique(String string) {
        BuildNodeType.Stoplists stoplists = null;
        if (this._parent instanceof StoplistPanel) {
            stoplists = ((StoplistPanel)this._parent).getStoplists();
        } else if (this._parent instanceof TextTransColumnSettingThemePanel) {
            stoplists = ((TextTransColumnSettingThemePanel)this._parent).getStoplists();
        } else if (this._parent instanceof TextTransColumnSettingTokenPanel) {
            stoplists = ((TextTransColumnSettingTokenPanel)this._parent).getStoplists();
        } else if (this._parent instanceof TextSettingsTokenPanel) {
            stoplists = ((TextSettingsTokenPanel)this._parent).getStoplists();
        } else if (this._parent instanceof TextSettingsThemePanel) {
            stoplists = ((TextSettingsThemePanel)this._parent).getStoplists();
        }
        boolean bl = true;
        for (StoplistType stoplistType : stoplists.getStoplist()) {
            if (stoplistType.getName().compareTo(string) != 0) continue;
            bl = false;
            break;
        }
        return bl;
    }

    @Override
    public Context getContext() {
        return this._context;
    }

    public JPanel getParent() {
        return this._parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Entry> loadStoplists() {
        Object object;
        String string;
        Object object2;
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        Connection connection = null;
        SQLHelper sQLHelper = new SQLHelper();
        try {
            Object object4;
            connection = Connections.getSharedConnection(this._context);
            try {
                object2 = "SELECT DISTINCT LANGUAGE FROM ODMR_USER_DEFAULT_STOPLISTS ORDER BY LANGUAGE";
                sQLHelper.pstmt = connection.prepareStatement((String)object2);
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                object4 = null;
                while (sQLHelper.rs.next()) {
                    object4 = sQLHelper.rs.getString("LANGUAGE");
                    Entry object3 = new Entry();
                    object3.setSourceType("Default");
                    object3.setName((String)object4);
                    object3.setSource("Default");
                    object3.setLanguage((String)object4);
                    arrayList.add(object3);
                }
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
            finally {
                sQLHelper.close();
            }
            try {
                object2 = "select SPL_OWNER, SPL_NAME, SPL_TYPE from ctxsys.ctx_stoplists WHERE SPL_NAME NOT LIKE 'ODMR$%' ORDER BY SPL_TYPE";
                sQLHelper.pstmt = connection.prepareStatement((String)object2);
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                while (sQLHelper.rs.next()) {
                    object4 = sQLHelper.rs.getString("SPL_OWNER");
                    String string2 = sQLHelper.rs.getString("SPL_NAME");
                    string = sQLHelper.rs.getString("SPL_TYPE");
                    object = new Entry();
                    ((Entry)object).setSourceType("DB");
                    ((Entry)object).setName(string2);
                    ((Entry)object).setSource("DB." + (String)object4);
                    if ("BASIC_STOPLIST".equals(string)) {
                        ((Entry)object).setLanguage("Basic");
                    } else {
                        ((Entry)object).setLanguage("Multi");
                    }
                    arrayList.add((Entry)object);
                }
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
            finally {
                sQLHelper.close();
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        object2 = this._node.getModel().getAllStoplists();
        for (Map.Entry entry : object2.entrySet()) {
            string = (String)entry.getKey();
            object = (StoplistType)entry.getValue();
            Entry entry2 = new Entry();
            entry2.setSourceType("WF");
            entry2.setName(object.getName());
            entry2.setSource("WF." + string);
            if (object.getType().equals("Basic")) {
                entry2.setLanguage(object.getLanguage());
            } else {
                entry2.setLanguage("Multi");
            }
            entry2.setUserObject(object);
            arrayList.add(entry2);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDefaultStopwords(List<Entry> list, Map<String, TokenInfo> map) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Entry object : list) {
            if (!object.getSelected().booleanValue() || !"Default".equals(object.getSourceType())) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("'" + object.getLanguage() + "'");
        }
        if (stringBuffer.length() > 0) {
            Object object2 = null;
            SQLHelper sQLHelper = new SQLHelper();
            try {
                object2 = Connections.getSharedConnection(this._context);
                String exception = "SELECT DISTINCT WORD, LANGUAGE FROM ODMR_USER_DEFAULT_STOPLISTS WHERE LANGUAGE IN (" + stringBuffer.toString() + ")";
                sQLHelper.pstmt = object2.prepareStatement(exception);
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                while (sQLHelper.rs.next()) {
                    String string = sQLHelper.rs.getString("WORD");
                    String string2 = sQLHelper.rs.getString("LANGUAGE");
                    String string3 = "Word";
                    String string4 = string2 + ":" + string3 + ":" + string;
                    if (map.containsKey(string4)) continue;
                    map.put(string4, new TokenInfo(string2, string3, string));
                }
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
            finally {
                sQLHelper.close();
            }
        }
    }

    private void loadCustomStopwords(List<Entry> list, Map<String, TokenInfo> map) {
        for (Entry entry : list) {
            if (!entry.getSelected().booleanValue() || !"WF".equals(entry.getSourceType())) continue;
            StoplistType stoplistType = (StoplistType)entry.getUserObject();
            for (StoplistType.StopTokens.Token token : stoplistType.getStopTokens().getToken()) {
                String string = token.getItem();
                String string2 = token.getLanguage();
                String string3 = token.getType();
                String string4 = string2 + ":" + string3 + ":" + string;
                if (map.containsKey(string4)) continue;
                map.put(string4, new TokenInfo(string2, string3, string));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDBStopwords(List<Entry> list, Map<String, TokenInfo> map) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Entry object : list) {
            if (!object.getSelected().booleanValue() || object.getSourceType() != "DB") continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" or ");
            }
            stringBuffer.append("spw_owner = '" + object.getSource().substring(object.getSource().indexOf(".") + 1) + "' and spw_stoplist = '" + object.getName() + "'");
        }
        if (stringBuffer.length() > 0) {
            Object object2 = null;
            SQLHelper sQLHelper = new SQLHelper();
            try {
                object2 = Connections.getSharedConnection(this._context);
                String exception = "SELECT DISTINCT spw_language, spw_type, spw_word FROM ctxsys.ctx_stopwords WHERE " + stringBuffer.toString();
                sQLHelper.pstmt = object2.prepareStatement(exception);
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                while (sQLHelper.rs.next()) {
                    String string = sQLHelper.rs.getString("spw_language");
                    String string2 = sQLHelper.rs.getString("spw_type");
                    string2 = "STOP_WORD".equals(string2) ? "Word" : "Theme";
                    String string3 = sQLHelper.rs.getString("spw_word");
                    String string4 = string + ":" + string2 + ":" + string3;
                    if (map.containsKey(string4)) continue;
                    map.put(string4, new TokenInfo(string, string2, string3));
                }
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
            finally {
                sQLHelper.close();
            }
        }
    }

    public StoplistType generateEmptyStopwords(String string) {
        this._stoplist = new StoplistType();
        this._stoplist.setName(this._stoplistName);
        this._stoplist.setDBName("");
        String string2 = ServerConstants.StoplistLanguage.toSchema(string);
        this._stoplist.setLanguage(string2);
        if (string2.equals("Multi")) {
            this._stoplist.setType("Multi");
        } else {
            this._stoplist.setType("Basic");
        }
        StoplistType.StopTokens stopTokens = new StoplistType.StopTokens();
        this._stoplist.setStopTokens(stopTokens);
        return this._stoplist;
    }

    public StoplistType generateStopwords(List<Entry> list) {
        this._stoplist = new StoplistType();
        this._stoplist.setName(this._stoplistName);
        this._stoplist.setDBName("");
        StoplistType.StopTokens stopTokens = new StoplistType.StopTokens();
        TreeMap<String, TokenInfo> treeMap = new TreeMap<String, TokenInfo>();
        this.loadDefaultStopwords(list, treeMap);
        this.loadCustomStopwords(list, treeMap);
        this.loadDBStopwords(list, treeMap);
        String object = null;
        String string = "Basic";
        for (TokenInfo object2 : treeMap.values()) {
            String string3 = object2.getLanguage();
            string3 = string3 == null ? "ENGLISH" : string3;
            String string4 = object2.getToken();
            String string5 = object2.getType();
            if (object == null) {
                object = string3;
            } else if (!object.equals(string3)) {
                string = "Multi";
            }
            StoplistType.StopTokens.Token token = new StoplistType.StopTokens.Token();
            token.setItem(string4);
            token.setLanguage(string3);
            token.setType(string5);
            stopTokens.getToken().add(token);
        }
        if (object == null) {
            for (Entry entry : list) {
                if (entry.getLanguage() == null) continue;
                object = entry.getLanguage();
                break;
            }
        }
        this._stoplist.setStopTokens(stopTokens);
        this._stoplist.setType(string);
        this._stoplist.setLanguage(string == "Multi" ? string : object);
        return this._stoplist;
    }

    public StoplistType getStoplist() {
        return this._stoplist;
    }

    public String getStoplistName() {
        return this._stoplistName;
    }

    public void setStoplistName(String string) {
        this._stoplistName = string;
    }

    public void setStoplist(StoplistType stoplistType) {
        this._stoplist = stoplistType;
    }

    public void setSelectStoplist(Entry entry) {
        this._selectStoplist = entry;
    }

    public void setEmptyStoplist(boolean bl) {
        this._emptyStoplist = bl;
    }

    public boolean isEmptyStoplist() {
        return this._emptyStoplist;
    }

    public void setEmptyStoplistLanguage(String string) {
        this._emptyStoplistLanguage = string;
    }

    public String getEmptyStoplistLanguage() {
        return this._emptyStoplistLanguage;
    }

    public static class Entry {
        private Boolean selected = Boolean.FALSE;
        private String name;
        private String source;
        private String language;
        private Object userObject;
        private String sourceType;

        public void setSelected(Boolean bl) {
            this.selected = bl;
        }

        public Boolean getSelected() {
            return this.selected;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void setSource(String string) {
            this.source = string;
        }

        public String getSource() {
            return this.source;
        }

        public void setLanguage(String string) {
            this.language = string;
        }

        public String getLanguage() {
            return this.language;
        }

        public void setUserObject(Object object) {
            this.userObject = object;
        }

        public Object getUserObject() {
            return this.userObject;
        }

        public void setSourceType(String string) {
            this.sourceType = string;
        }

        public String getSourceType() {
            return this.sourceType;
        }
    }

    private class TokenInfo {
        private String _language;
        private String _type;
        private String _token;

        public TokenInfo(String string, String string2, String string3) {
            this._language = string;
            this._type = string2;
            this._token = string3;
        }

        public String getLanguage() {
            return this._language;
        }

        public String getType() {
            return this._type;
        }

        public String getToken() {
            return this._token;
        }
    }
}

