/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.workflow.dialog.build.AbstractEditPanel;
import oracle.dmt.dataminer.workflow.dialog.build.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.EditChangeListener;
import oracle.dmt.dataminer.workflow.dialog.build.SelectNodeDialog;
import oracle.dmt.dataminer.workflow.dialog.build.SelectNodePanel;
import oracle.dmt.dataminer.workflow.dialog.build.SelectNodeResultDialog;
import oracle.dmt.dataminer.workflow.dialog.build.SelectNodeResultPanel;
import oracle.dmt.dataminer.workflow.dialog.build.StoplistDialog;
import oracle.dmt.dataminer.workflow.dialog.build.TextSettingsThemePanel;
import oracle.dmt.dataminer.workflow.dialog.build.TextSettingsTokenPanel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationTokenType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributesType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class TextSettingsPanel
extends AbstractEditPanel {
    private BuildNodeType _metadataCopy = null;
    private BuildNodeType.TextSettings _textSettings = null;
    private BuildNodeType.Stoplists _existStoplists = null;
    private TransformedAttributesType _textAttributes = null;
    private MiningAttributes _textMiningAttributes = null;
    private Map<String, MiningAttributes> _modelMiningAttributesMap = null;
    private boolean _isAdjusting;
    private TextSettingsTokenPanel _tokenPanel;
    private TextSettingsThemePanel _themePanel;
    private boolean _dirty;
    private static String TOKENS_TAB = DialogsLrb.get("BUILD_TEXT_TOKENS_TAB");
    private static String THEMES_TAB = DialogsLrb.get("BUILD_TEXT_THEMES_TAB");
    private JButton btnStoplists;
    private JLabel jCategoricalCutoffValueLabel;
    private JSpinner jCategoricalCutoffValueSpinner;
    private JPanel jPanel1;
    private JTabbedPane jTabbedPane;
    private JComboBox jTransformTypeComboBox;
    private JLabel jTransformTypeLabel;

    public TextSettingsPanel(Context context, AbstractBuildNode abstractBuildNode, BuildNodeType buildNodeType) {
        super(context, abstractBuildNode);
        assert (context != null) : "Context must not be null.";
        assert (abstractBuildNode != null) : "node node must not be null.";
        assert (abstractBuildNode instanceof AbstractBuildNode) : "Must be an instance of AbstractBuildNode node.";
        this.init(buildNodeType);
    }

    private void init(BuildNodeType buildNodeType) {
        this._metadataCopy = buildNodeType;
        this._textSettings = this._metadataCopy.getTextSettings();
        this._existStoplists = this._metadataCopy.getStoplists();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resSpinner((JLabel)this.jCategoricalCutoffValueLabel, (JSpinner)this.jCategoricalCutoffValueSpinner, (String)DialogsLrb.get("TEXT_SETTINGS_CATEGORICAL_CUTOFF"));
        ResourceUtils.resLabel((JLabel)this.jTransformTypeLabel, (Component)this.jTransformTypeComboBox, (String)DialogsLrb.get("TEXT_SETTINGS_TRANSFORM_TYPE"));
        ResourceUtils.resButton((AbstractButton)this.btnStoplists, (String)DialogsLrb.get("TEXT_STOPLISTS_BUTTON"));
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)"text_settings");
        this._isAdjusting = true;
        this._tokenPanel = new TextSettingsTokenPanel(this.getContext(), (AbstractBuildNode)this.getData(), this._metadataCopy, this._textSettings.getToken(), this._existStoplists);
        this.jTabbedPane.add(TOKENS_TAB, this._tokenPanel);
        this._themePanel = new TextSettingsThemePanel(this.getContext(), (AbstractBuildNode)this.getData(), this._metadataCopy, this._textSettings.getTheme(), this._existStoplists);
        this.jTabbedPane.add(THEMES_TAB, this._themePanel);
        this.jCategoricalCutoffValueSpinner.setModel(new SpinnerNumberModel(this._textSettings.getCategoricalCutOffValue(), 1, 4000, 10));
        this.jCategoricalCutoffValueSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TextSettingsPanel.this._dirty = true;
            }
        });
        this.jTransformTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{ServerConstants.TextTransformType.toHuman("Token"), ServerConstants.TextTransformType.toHuman("Theme")}));
        this.jTransformTypeComboBox.setSelectedItem(ServerConstants.TextTransformType.toHuman(this._textSettings.getTransformType()));
        if (this._textSettings.getTransformType().equals("Token")) {
            this.jTabbedPane.setEnabledAt(0, true);
            this.jTabbedPane.setEnabledAt(1, false);
            this.jTabbedPane.setSelectedIndex(0);
        } else {
            this.jTabbedPane.setEnabledAt(0, false);
            this.jTabbedPane.setEnabledAt(1, true);
            this.jTabbedPane.setSelectedIndex(1);
        }
        this.jTransformTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextSettingsPanel.this._dirty = true;
                boolean bl = TextSettingsPanel.this.jTransformTypeComboBox.getSelectedItem().equals(ServerConstants.TextTransformType.toHuman("Token"));
                if (bl) {
                    TextSettingsPanel.this.jTabbedPane.setEnabledAt(0, true);
                    TextSettingsPanel.this.jTabbedPane.setEnabledAt(1, false);
                    TextSettingsPanel.this.jTabbedPane.setSelectedIndex(0);
                } else {
                    TextSettingsPanel.this.jTabbedPane.setEnabledAt(0, false);
                    TextSettingsPanel.this.jTabbedPane.setEnabledAt(1, true);
                    TextSettingsPanel.this.jTabbedPane.setSelectedIndex(1);
                }
            }
        });
        this._isAdjusting = false;
    }

    public boolean isDirty() {
        return this._dirty || this._tokenPanel.isDirty() || this._themePanel.isDirty();
    }

    private void handleEditNodeStoplistSettings() {
        StoplistDialog stoplistDialog = new StoplistDialog();
        if (stoplistDialog.invoke(this._context, (AbstractBuildNode)this.getData(), this._metadataCopy)) {
            BuildNodeType.Stoplists stoplists = stoplistDialog.getPanel().getStoplists();
            this._metadataCopy.setStoplists(stoplists);
            this._dirty = true;
        }
    }

    public void handleImportTextSettings() {
        SelectNodePanel selectNodePanel;
        SelectNodeDialog selectNodeDialog = new SelectNodeDialog();
        if (selectNodeDialog.invoke(this.getContext(), (AbstractBuildNode)this.getData()) && (selectNodePanel = selectNodeDialog.getPanel()).isDirty()) {
            BuildTextNodeType buildTextNodeType = selectNodePanel.getSelBuildTextNodeNode();
            SelectNodeResultDialog selectNodeResultDialog = new SelectNodeResultDialog();
            try {
                this._tokenPanel.copySettings(this._metadataCopy, this._textSettings.getToken(), this._existStoplists);
                this._themePanel.copySettings(this._metadataCopy, (TransformationTokenType)this._textSettings.getTheme(), this._existStoplists);
            }
            catch (ValidationException validationException) {
                // empty catch block
            }
            if (selectNodeResultDialog.invoke(this._context, buildTextNodeType, (AbstractBuildNode)this.getData(), this._metadataCopy)) {
                SelectNodeResultPanel selectNodeResultPanel = selectNodeResultDialog.getPanel();
                if (selectNodeResultPanel.isDirty()) {
                    this._existStoplists = selectNodeResultPanel.getStoplist();
                    this._tokenPanel.reload(this._metadataCopy, this._textSettings.getToken(), this._existStoplists);
                    this._themePanel.reload(this._metadataCopy, this._textSettings.getTheme(), this._existStoplists);
                    this._dirty = true;
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("TEXT_IMPORT_SUCCESS_MSG"), (String)DialogsLrb.get("TEXT_IMPORT_SUCCESS_TITLE"), null);
                    for (EditChangeListener editChangeListener : this.getChangeListeners()) {
                        editChangeListener.textSettingsImported();
                    }
                } else {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("TEXT_IMPORT_NO_SETTINGS_MSG"), (String)DialogsLrb.get("TEXT_IMPORT_SUCCESS_TITLE"), null);
                }
            }
        }
    }

    public boolean doWork() {
        boolean bl = true;
        try {
            Integer n = (Integer)this.jCategoricalCutoffValueSpinner.getValue();
            this._textSettings.setCategoricalCutOffValue(n.intValue());
            this._textSettings.setTransformType(ServerConstants.TextTransformType.toSchema((String)this.jTransformTypeComboBox.getSelectedItem()));
            this._tokenPanel.copySettings(this._metadataCopy, this._textSettings.getToken(), this._existStoplists);
            this._themePanel.copySettings(this._metadataCopy, (TransformationTokenType)this._textSettings.getTheme(), this._existStoplists);
        }
        catch (ValidationException validationException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)validationException.getLocalizedMessage(), (String)DialogsLrb.get("ERROR_TITLE"), null);
            bl = false;
        }
        return bl;
    }

    private void initComponents() {
        this.jCategoricalCutoffValueLabel = new JLabel();
        this.jCategoricalCutoffValueSpinner = new JSpinner();
        this.jTransformTypeLabel = new JLabel();
        this.jTransformTypeComboBox = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jTabbedPane = new JTabbedPane();
        this.btnStoplists = new JButton();
        this.jCategoricalCutoffValueLabel.setText("Categorical cutoff value:");
        this.jTransformTypeLabel.setText("Default Transform Type:");
        this.jTransformTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Default Settings"));
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane, -1, 428, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTabbedPane, -1, 173, Short.MAX_VALUE).addContainerGap()));
        this.btnStoplists.setText("Stoplists...");
        this.btnStoplists.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextSettingsPanel.this.btnStoplistsActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jTransformTypeLabel, -2, 136, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTransformTypeComboBox, -2, 160, -2)).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jCategoricalCutoffValueLabel, -2, 136, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCategoricalCutoffValueSpinner, -2, 155, -2)).addComponent(this.btnStoplists)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        groupLayout2.linkSize(0, this.jCategoricalCutoffValueSpinner, this.jTransformTypeComboBox);
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCategoricalCutoffValueLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jCategoricalCutoffValueSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTransformTypeLabel).addComponent(this.jTransformTypeComboBox, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnStoplists).addGap(6, 6, 6)));
    }

    private void btnStoplistsActionPerformed(ActionEvent actionEvent) {
        this.handleEditNodeStoplistSettings();
    }

    public BuildNodeType.TextSettings getTextSettings() {
        return this._textSettings;
    }

    public BuildNodeType.Stoplists getExistStoplists() {
        return this._existStoplists;
    }

    public TransformedAttributesType getTextAttributes() {
        return this._textAttributes;
    }

    public MiningAttributes getTextMiningAttributes() {
        return this._textMiningAttributes;
    }

    public Map<String, MiningAttributes> getModelMiningAttributesMap() {
        return this._modelMiningAttributesMap;
    }
}

