/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.build.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.StoplistDetailsDialog;
import oracle.dmt.dataminer.workflow.dialog.build.StoplistDetailsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.StoplistWizard;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractTextNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.LexerType;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationTokenType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.combo.CheckComboModel;
import oracle.javatools.ui.combo.JCheckCombo;

public class TextSettingsTokenPanel
extends AbstractDialogPanel {
    private BuildNodeType _buildNodeType = null;
    private TransformationTokenType _token;
    private BuildNodeType.Stoplists _stoplists;
    private boolean _isAdjusting = false;
    private boolean _isLoading = false;
    private boolean _isAllSelected = false;
    private boolean _isNoneSelected = false;
    private boolean _dirty = false;
    private static Icon _editIcon;
    private JButton jEditStoplistButton;
    private JButton jNewStoplistButton;
    private JCheckBox jStemmingCheckBox;
    private JCheckCombo jTokenLanguageComboBox;
    private JLabel jTokenLanguageLabel;
    private JLabel jTokenMaxAllDocsLabel;
    private JSpinner jTokenMaxAllDocsSpinner;
    private JComboBox jTokenStoplistComboBox;
    private JLabel jTokenStoplistLabel;
    private JLabel jTokenTokensLabel;

    public TextSettingsTokenPanel(Context context, AbstractBuildNode abstractBuildNode, BuildNodeType buildNodeType, TransformationTokenType transformationTokenType, BuildNodeType.Stoplists stoplists) {
        super(context, abstractBuildNode);
        assert (context != null) : "Context must not be null.";
        assert (abstractBuildNode != null) : "node node must not be null.";
        assert (abstractBuildNode instanceof AbstractBuildNode) : "Must be an instance of AbstractBuildNode node.";
        this.init(buildNodeType, transformationTokenType, stoplists);
    }

    private void init(BuildNodeType buildNodeType, TransformationTokenType transformationTokenType, BuildNodeType.Stoplists stoplists) {
        this._buildNodeType = buildNodeType;
        this._token = transformationTokenType;
        this._stoplists = stoplists;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void reload(BuildNodeType buildNodeType, TransformationTokenType transformationTokenType, BuildNodeType.Stoplists stoplists) {
        this._buildNodeType = buildNodeType;
        this._token = transformationTokenType;
        this._stoplists = stoplists;
        this.refreshUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jTokenLanguageLabel, (Component)this.jTokenLanguageComboBox, (String)DialogsLrb.get("BUILD_TEXT_LANGUAGES"));
        ResourceUtils.resButton((AbstractButton)this.jStemmingCheckBox, (String)DialogsLrb.get("BUILD_TEXT_STEMMING"));
        ResourceUtils.resLabel((JLabel)this.jTokenStoplistLabel, (Component)this.jTokenStoplistComboBox, (String)DialogsLrb.get("BUILD_TEXT_STOPLIST"));
        ResourceUtils.resLabel((JLabel)this.jTokenTokensLabel, null, (String)DialogsLrb.get("BUILD_TEXT_TOKENS"));
        ResourceUtils.resSpinner((JLabel)this.jTokenMaxAllDocsLabel, (JSpinner)this.jTokenMaxAllDocsSpinner, (String)DialogsLrb.get("BUILD_TEXT_MAX_NUM_ALL_DOCS"));
        _editIcon = InspectorArb.getIcon((int)24);
    }

    @Override
    public void initUI() {
        this._isLoading = true;
        this.jStemmingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextSettingsTokenPanel.this._dirty = true;
            }
        });
        this.jTokenMaxAllDocsSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TextSettingsTokenPanel.this._dirty = true;
            }
        });
        this.jEditStoplistButton.setText(null);
        this.jEditStoplistButton.setIcon(_editIcon);
        this.jEditStoplistButton.setToolTipText(DialogsLrb.get("BUILD_TEXT_EDIT_STOPLIST_TOOLTIP"));
        this.jNewStoplistButton.setText(null);
        this.jNewStoplistButton.setIcon(DataMinerIcons.get(Icons.ADD));
        this.jNewStoplistButton.setToolTipText(DialogsLrb.get("BUILD_TEXT_ADD_STOPLIST_TOOLTIP"));
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("All"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("None"));
        for (ServerConstants.StoplistLanguage.BASIC_LEXER_LANG bASIC_LEXER_LANG : ServerConstants.StoplistLanguage.BASIC_LEXER_LANG.values()) {
            defaultListModel.addElement(bASIC_LEXER_LANG.value());
        }
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        defaultListSelectionModel.addSelectionInterval(1, 1);
        CheckComboModel checkComboModel = new CheckComboModel(defaultListModel, (ListSelectionModel)defaultListSelectionModel);
        this.jTokenLanguageComboBox.setModel(checkComboModel);
        ListSelectionModel listSelectionModel = this.jTokenLanguageComboBox.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    TextSettingsTokenPanel.this.jSingleByteLanguageValueChanged(listSelectionEvent);
                }
            }
        });
        this.refreshUI();
        this._isLoading = false;
    }

    private void refreshUI() {
        this.initStoplists(this._token.getToken().getStoplistId());
        this.initLanguages(this._token);
        boolean bl = false;
        for (LexerType.Settings.Attribute attribute : this._token.getToken().getLexer().getSettings().getAttribute()) {
            if (!attribute.getName().equals("index_stems")) continue;
            bl = true;
            break;
        }
        this.jStemmingCheckBox.setSelected(bl);
        int n = this._token.getToken().getMaxNumberAllDocs().intValue();
        this.jTokenMaxAllDocsSpinner.setModel(new SpinnerNumberModel(n, 1, 100000, 1000));
        this.enableControls();
    }

    public boolean isDirty() {
        return this._dirty;
    }

    private void initStoplists(String string) {
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (StoplistType stoplistType : this._stoplists.getStoplist()) {
            arrayList.add(stoplistType.getName());
            if (string == null || !string.equals(stoplistType.getId())) continue;
            string2 = stoplistType.getName();
        }
        Collections.sort(arrayList);
        arrayList.add(0, ServerConstants.StoplistLanguage.toHuman("None"));
        this.jTokenStoplistComboBox.removeAllItems();
        this.jTokenStoplistComboBox.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        if (string2 != null) {
            this.jTokenStoplistComboBox.setSelectedItem(string2);
        }
    }

    public void initLanguages(TransformationTokenType transformationTokenType) {
        List list = null;
        list = transformationTokenType.getToken().getLanguages().getLanguage();
        this._isAdjusting = true;
        ListSelectionModel listSelectionModel = this.jTokenLanguageComboBox.getSelectionModel();
        listSelectionModel.clearSelection();
        CheckComboModel checkComboModel = this.jTokenLanguageComboBox.getCheckModel();
        boolean bl = false;
        for (TransformationTokenType.Token.Languages.Language language : list) {
            for (int i = 0; i < checkComboModel.getSize(); ++i) {
                String string = (String)checkComboModel.getElementAt(i);
                if (!string.equals(ServerConstants.StoplistLanguage.toHuman(language.getName()))) continue;
                listSelectionModel.addSelectionInterval(i, i);
                bl = true;
            }
        }
        if (!bl) {
            listSelectionModel.addSelectionInterval(1, 1);
        }
        this._isAdjusting = false;
    }

    private void enableControls() {
        if (this.jTokenStoplistComboBox.getItemCount() > 0) {
            String string = (String)this.jTokenStoplistComboBox.getSelectedItem();
            this.jEditStoplistButton.setEnabled(!ServerConstants.StoplistLanguage.isNone(ServerConstants.StoplistLanguage.toSchema(string)));
        } else {
            this.jEditStoplistButton.setEnabled(false);
        }
    }

    private void jSingleByteLanguageValueChanged(ListSelectionEvent listSelectionEvent) {
        Object[] objectArray;
        if (this._isAdjusting) {
            return;
        }
        this._isAdjusting = true;
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        CheckComboModel checkComboModel = this.jTokenLanguageComboBox.getCheckModel();
        for (Object object : objectArray = checkComboModel.getSelectedItem()) {
            String string = (String)object;
            if (!this._isNoneSelected && ServerConstants.StoplistLanguage.isNone(ServerConstants.StoplistLanguage.toSchema(string))) {
                listSelectionModel.clearSelection();
                listSelectionModel.addSelectionInterval(1, 1);
                this._isNoneSelected = true;
                this._isAllSelected = false;
                break;
            }
            if (!this._isAllSelected && ServerConstants.StoplistLanguage.isALL(ServerConstants.StoplistLanguage.toSchema(string))) {
                listSelectionModel.removeSelectionInterval(1, 1);
                listSelectionModel.addSelectionInterval(2, checkComboModel.getSize() - 1);
                this._isAllSelected = true;
                this._isNoneSelected = false;
                break;
            }
            listSelectionModel.removeSelectionInterval(0, 0);
            this._isAllSelected = false;
            listSelectionModel.removeSelectionInterval(1, 1);
            this._isNoneSelected = false;
        }
        this._isAdjusting = false;
    }

    public void copySettings(BuildNodeType buildNodeType, TransformationTokenType transformationTokenType, BuildNodeType.Stoplists stoplists) throws ValidationException {
        Object object;
        Object[] objectArray;
        StoplistType stoplistType = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        TransformationTokenType.Token.Languages languages = new TransformationTokenType.Token.Languages();
        TransformationTokenType.Token.Languages.Language language = null;
        CheckComboModel checkComboModel = this.jTokenLanguageComboBox.getCheckModel();
        for (Object object2 : objectArray = checkComboModel.getSelectedItem()) {
            object = (String)object2;
            if (ServerConstants.StoplistLanguage.isALL(ServerConstants.StoplistLanguage.toSchema((String)object)) || ServerConstants.StoplistLanguage.isNone(ServerConstants.StoplistLanguage.toSchema((String)object))) continue;
            language = new TransformationTokenType.Token.Languages.Language();
            language.setName(ServerConstants.StoplistLanguage.toSchema((String)object));
            if (ServerConstants.StoplistLanguage.isTraditionalChinese(ServerConstants.StoplistLanguage.toSchema((String)object)) || ServerConstants.StoplistLanguage.isSimplifiedChinese(ServerConstants.StoplistLanguage.toSchema((String)object)) || ServerConstants.StoplistLanguage.isJapanese(ServerConstants.StoplistLanguage.toSchema((String)object)) || ServerConstants.StoplistLanguage.isKorean(ServerConstants.StoplistLanguage.toSchema((String)object))) {
                language.setType("MultiByte");
            } else {
                language.setType("SingleByte");
            }
            languages.getLanguage().add(language);
            arrayList.add(ServerConstants.StoplistLanguage.toSchema((String)object));
        }
        if (arrayList.size() == 0) {
            throw new ValidationException(DialogsLrb.get("BUILD_TEXT_NO_LANGUAGE_ERROR"));
        }
        transformationTokenType.getToken().setLanguages(languages);
        if (languages.getLanguage().size() <= 1) {
            transformationTokenType.getToken().getLexer().setType("Basic");
        } else {
            transformationTokenType.getToken().getLexer().setType("Auto");
        }
        transformationTokenType.getToken().setStoplistId(null);
        String string = (String)this.jTokenStoplistComboBox.getSelectedItem();
        if (string != null) {
            if (ServerConstants.StoplistLanguage.isDefault(ServerConstants.StoplistLanguage.toSchema(string))) {
                String n = null;
                n = languages.getLanguage().size() <= 1 ? ((TransformationTokenType.Token.Languages.Language)languages.getLanguage().get(0)).getName() : "Multi";
                stoplistType = AbstractBuildNode.findDefaultStoplist(stoplists, n);
                String arrayList3 = stoplistType.getId();
                transformationTokenType.getToken().setStoplistId(arrayList3);
            } else {
                transformationTokenType.getToken().setStoplistId(AbstractBuildNode.findStoplistId(stoplists, string));
            }
        }
        Integer n = (Integer)this.jTokenMaxAllDocsSpinner.getValue();
        transformationTokenType.getToken().setMaxNumberAllDocs(BigInteger.valueOf(n.intValue()));
        if (stoplistType != null) {
            boolean bl;
            ArrayList<String> arrayList2 = AbstractTextNode.findStoplistLanguages(stoplistType, "Word");
            ArrayList<String> arrayList3 = new ArrayList<String>();
            object = new ArrayList();
            for (String string2 : arrayList) {
                bl = false;
                for (String string3 : arrayList2) {
                    if (!string2.equals(string3)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList3.add(string2);
            }
            for (String string4 : arrayList2) {
                bl = false;
                for (String string3 : arrayList) {
                    if (!string4.equals(string3)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                ((ArrayList)object).add(string4);
            }
            if (arrayList3.size() > 0) {
                AbstractTextNode.stoplistAddDefaultTokens(this._context, stoplistType, "Word", arrayList3);
                this._dirty = true;
            }
            if (((ArrayList)object).size() > 0) {
                ArrayList<String> arrayList4 = new ArrayList();
                arrayList4 = AbstractBuildNode.stoplistCheckLanguagesUsed(null, buildNodeType, stoplistType, "Word", (ArrayList<String>)object);
                if (arrayList4.size() == 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Object object3 = ((ArrayList)object).iterator();
                    while (object3.hasNext()) {
                        String string5 = (String)object3.next();
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(ServerConstants.StoplistLanguage.toHuman(string5));
                    }
                    object3 = MessageFormat.format(DialogsLrb.get("BUILD_TEXT_REMOVE_WORDS_FOR_LANG"), stringBuffer.toString());
                    if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)object3, (String)DialogsLrb.get("BUILD_TEXT_DIALOG_TITLE"), null, (boolean)true)) {
                        AbstractTextNode.stoplistRemoveTokens(stoplistType, "Word", (ArrayList<String>)object);
                    }
                }
                this._dirty = true;
            }
        }
    }

    private void initComponents() {
        this.jTokenLanguageLabel = new JLabel();
        this.jTokenLanguageComboBox = new JCheckCombo();
        this.jStemmingCheckBox = new JCheckBox();
        this.jTokenStoplistLabel = new JLabel();
        this.jTokenStoplistComboBox = new JComboBox();
        this.jEditStoplistButton = new JButton();
        this.jNewStoplistButton = new JButton();
        this.jTokenTokensLabel = new JLabel();
        this.jTokenMaxAllDocsLabel = new JLabel();
        this.jTokenMaxAllDocsSpinner = new JSpinner();
        this.jTokenLanguageLabel.setText("Languages:");
        this.jTokenLanguageComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jTokenLanguageComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextSettingsTokenPanel.this.jTokenLanguageComboBoxActionPerformed(actionEvent);
            }
        });
        this.jStemmingCheckBox.setText("Stemming");
        this.jStemmingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextSettingsTokenPanel.this.jStemmingCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jTokenStoplistLabel.setText("Stoplists:");
        this.jTokenStoplistComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jTokenStoplistComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextSettingsTokenPanel.this.jTokenStoplistComboBoxActionPerformed(actionEvent);
            }
        });
        this.jEditStoplistButton.setText("---");
        this.jEditStoplistButton.setMargin(new Insets(2, 2, 2, 2));
        this.jEditStoplistButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextSettingsTokenPanel.this.jEditStoplistButtonActionPerformed(actionEvent);
            }
        });
        this.jNewStoplistButton.setText("+");
        this.jNewStoplistButton.setMargin(new Insets(2, 2, 2, 2));
        this.jNewStoplistButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextSettingsTokenPanel.this.jNewStoplistButtonActionPerformed(actionEvent);
            }
        });
        this.jTokenTokensLabel.setText("Tokens:");
        this.jTokenMaxAllDocsLabel.setText("Max number across all documents");
        this.jTokenMaxAllDocsSpinner.setModel(new SpinnerNumberModel(3000, 0, 3000, 1));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jTokenMaxAllDocsLabel, -2, 183, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTokenMaxAllDocsSpinner, -2, 70, -2)).addComponent(this.jTokenTokensLabel, -2, 104, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jEditStoplistButton, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jNewStoplistButton, -2, 26, -2)).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jStemmingCheckBox, -2, 94, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTokenLanguageLabel, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jTokenLanguageComboBox, -2, 160, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTokenStoplistLabel, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTokenStoplistComboBox, -2, 160, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTokenLanguageLabel).addComponent((Component)this.jTokenLanguageComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jStemmingCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTokenStoplistLabel).addComponent(this.jTokenStoplistComboBox, -2, -1, -2).addComponent(this.jNewStoplistButton).addComponent(this.jEditStoplistButton)).addGap(11, 11, 11).addComponent(this.jTokenTokensLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTokenMaxAllDocsLabel).addComponent(this.jTokenMaxAllDocsSpinner, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jStemmingCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jStemmingCheckBox.isSelected();
        LexerType.Settings.Attribute attribute = null;
        for (LexerType.Settings.Attribute attribute2 : this._token.getToken().getLexer().getSettings().getAttribute()) {
            if (!attribute2.getName().equals("index_stems")) continue;
            attribute = attribute2;
            break;
        }
        if (bl && attribute == null) {
            LexerType.Settings.Attribute attribute3 = null;
            if (this._token.getToken().getLanguages().getLanguage().size() <= 1) {
                attribute3 = new LexerType.Settings.Attribute();
                attribute3.setName("index_stems");
                attribute3.setType("String");
                attribute3.setValueString(((TransformationTokenType.Token.Languages.Language)this._token.getToken().getLanguages().getLanguage().get(0)).getName());
            } else {
                attribute3 = new LexerType.Settings.Attribute();
                attribute3.setName("index_stems");
                attribute3.setType("String");
                attribute3.setValueString("TRUE");
            }
            this._token.getToken().getLexer().getSettings().getAttribute().add(attribute3);
        } else if (!bl && attribute != null) {
            this._token.getToken().getLexer().getSettings().getAttribute().remove(attribute);
        }
        this._dirty = true;
    }

    private void jTokenStoplistComboBoxActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
        if (!this._isLoading) {
            this._dirty = true;
        }
    }

    private void jEditStoplistButtonActionPerformed(ActionEvent actionEvent) {
        Object object2;
        String string = (String)this.jTokenStoplistComboBox.getSelectedItem();
        StoplistType stoplistType = null;
        boolean bl = false;
        for (Object object2 : this._stoplists.getStoplist()) {
            if (!object2.getName().equals(string)) continue;
            stoplistType = object2;
            break;
        }
        bl = true;
        StoplistDetailsDialog stoplistDetailsDialog = new StoplistDetailsDialog();
        if (stoplistDetailsDialog.invoke(this._context, (AbstractBuildNode)this.getData(), this._buildNodeType, this, stoplistType) && ((StoplistDetailsPanel)(object2 = stoplistDetailsDialog.getPanel())).isDirty()) {
            StoplistType stoplistType2 = ((StoplistDetailsPanel)object2).getStoplist();
            for (int i = 0; i < this._stoplists.getStoplist().size(); ++i) {
                if (!((StoplistType)this._stoplists.getStoplist().get(i)).getId().equals(stoplistType2.getId())) continue;
                this._stoplists.getStoplist().set(i, stoplistType2);
                break;
            }
            this.initStoplists(stoplistType2.getId());
            this._dirty = true;
        }
    }

    private void jNewStoplistButtonActionPerformed(ActionEvent actionEvent) {
        StoplistWizard stoplistWizard = new StoplistWizard();
        if (stoplistWizard.runWizard(this, null, this._context, (AbstractBuildNode)this.getData(), DialogsLrb.get("BUILD_TEXT_DEFAULT_STOPLIST_NAME"))) {
            StoplistType stoplistType = stoplistWizard.getModel().getStoplist();
            String string = AbstractBuildNode.getStoplistNextId(this._stoplists) + "";
            stoplistType.setId(string);
            this._stoplists.getStoplist().add(stoplistType);
            this.initStoplists(stoplistType.getId());
            this._dirty = true;
        }
    }

    private void jTokenLanguageComboBoxActionPerformed(ActionEvent actionEvent) {
        this._dirty = true;
    }

    public BuildNodeType.Stoplists getStoplists() {
        return this._stoplists;
    }
}

