/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.build.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.TextTransColumnSettingThemePanel;
import oracle.dmt.dataminer.workflow.dialog.build.TextTransColumnSettingTokenPanel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.LexerType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTextTransformedSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationOutputAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationTokenType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributesType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class TextTransColumnSettingPanel
extends AbstractDialogPanel {
    private BuildNodeType _buildNodeType = null;
    private BuildNodeType.Stoplists _existStoplists = null;
    private TransformedAttributesType _textAttributes = null;
    private TransformationTokenType _token = null;
    private TransformationTokenType _theme = null;
    private boolean _bShowTokenSettings;
    private String _sourceAttributeName = null;
    private TextTransColumnSettingTokenPanel _tokenPanel;
    private TextTransColumnSettingThemePanel _themePanel;
    private boolean _dirty;
    private boolean _isAdjusting;
    private static String TRANSFORM_TOKEN = DialogsLrb.get("BUILD_TEXT_TRANSFORM_TYPE_TOKEN");
    private static String TRANSFORM_THEME = DialogsLrb.get("BUILD_TEXT_TRANSFORM_TYPE_THEME");
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private ButtonGroup buttonGroup4;
    private JPanel jSettingPanel;
    private JComboBox jTransformTypeComboBox;
    private JLabel jTransformTypeLabel;

    public TextTransColumnSettingPanel(Context context, AbstractBuildNode abstractBuildNode, BuildNodeType buildNodeType, String string) {
        super(context, abstractBuildNode);
        assert (context != null) : "Context must not be null.";
        assert (abstractBuildNode != null) : "node node must not be null.";
        assert (abstractBuildNode instanceof AbstractBuildNode) : "Must be an instance of AbstractBuildNode node.";
        BuildNodeType buildNodeType2 = (BuildNodeType)MetaDataHelper.copyMetadataObject(buildNodeType);
        this.init(buildNodeType2, string);
    }

    private void init(BuildNodeType buildNodeType, String string) {
        TextTransformationOutputAttributeType textTransformationOutputAttributeType;
        Object object;
        MapTextTransformedSourceType mapTextTransformedSourceType2;
        this._buildNodeType = buildNodeType;
        this._sourceAttributeName = string;
        this._textAttributes = this._buildNodeType.getTextAttributes();
        boolean bl = false;
        for (MapTextTransformedSourceType mapTextTransformedSourceType2 : this._textAttributes.getMapTextTransformedSource()) {
            if (!mapTextTransformedSourceType2.getKey().getName().equals(string)) continue;
            object = mapTextTransformedSourceType2.getKey();
            bl = true;
            this._theme = object.getTransformationElement().getTheme();
            this._token = object.getTransformationElement().getToken();
            this._bShowTokenSettings = this._token != null;
            break;
        }
        if (!bl) {
            textTransformationOutputAttributeType = new TextTransformationOutputAttributeType();
            mapTextTransformedSourceType2 = new MapTextTransformedSourceType();
            object = new TextTransformationType();
            textTransformationOutputAttributeType.setName(string);
            textTransformationOutputAttributeType.setSource(string);
            textTransformationOutputAttributeType.setDataType("DM_NESTED_NUMERICALS");
            textTransformationOutputAttributeType.setIsOutput(true);
            textTransformationOutputAttributeType.setModified(true);
            textTransformationOutputAttributeType.setStatus(AttributeStatus.VALID);
            textTransformationOutputAttributeType.setTransformationElement((TextTransformationType)object);
            mapTextTransformedSourceType2.setKey(textTransformationOutputAttributeType);
            this._textAttributes.getMapTextTransformedSource().add(mapTextTransformedSourceType2);
            this._bShowTokenSettings = this._buildNodeType.getTextSettings().getTransformType().equals("Token");
        }
        if (this._token == null) {
            this._token = (TransformationTokenType)MetaDataHelper.copyMetadataObject(this._buildNodeType.getTextSettings().getToken());
        }
        if (this._theme == null) {
            textTransformationOutputAttributeType = new TransformationTokenType.Token();
            textTransformationOutputAttributeType.setPolicy("");
            mapTextTransformedSourceType2 = new TransformationTokenType.Token.Languages();
            for (TransformationTokenType.Token.Languages.Language language : this._buildNodeType.getTextSettings().getTheme().getToken().getLanguages().getLanguage()) {
                TransformationTokenType.Token.Languages.Language language2 = new TransformationTokenType.Token.Languages.Language();
                language2.setName(language.getName());
                language2.setType(language.getType());
                mapTextTransformedSourceType2.getLanguage().add(language2);
            }
            textTransformationOutputAttributeType.setLanguages((TransformationTokenType.Token.Languages)mapTextTransformedSourceType2);
            textTransformationOutputAttributeType.setLexer((LexerType)MetaDataHelper.copyMetadataObject(this._buildNodeType.getTextSettings().getTheme().getToken().getLexer()));
            textTransformationOutputAttributeType.setFrequency(this._buildNodeType.getTextSettings().getTheme().getToken().getFrequency());
            textTransformationOutputAttributeType.setMaxNumberAllDocs(this._buildNodeType.getTextSettings().getTheme().getToken().getMaxNumberAllDocs());
            textTransformationOutputAttributeType.setMaxNumberPerDoc(this._buildNodeType.getTextSettings().getTheme().getToken().getMaxNumberPerDoc());
            textTransformationOutputAttributeType.setStoplistId(this._buildNodeType.getTextSettings().getTheme().getToken().getStoplistId());
            this._theme = new TextTransformationType.Theme();
            ((TextTransformationType.Theme)this._theme).setType("Single");
            this._theme.setToken((TransformationTokenType.Token)textTransformationOutputAttributeType);
        }
        this._existStoplists = this._buildNodeType.getStoplists();
        this._dirty = false;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jTransformTypeLabel, (Component)this.jTransformTypeComboBox, (String)DialogsLrb.get("TEXT_SETTINGS_COLUMN_TRANSFORM_TYPE"));
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)"text_custom_settings");
        this._isAdjusting = true;
        this.jTransformTypeComboBox.removeAllItems();
        this.jTransformTypeComboBox.addItem(TRANSFORM_TOKEN);
        this.jTransformTypeComboBox.addItem(TRANSFORM_THEME);
        if (this._bShowTokenSettings) {
            this.jTransformTypeComboBox.setSelectedItem(TRANSFORM_TOKEN);
        } else {
            this.jTransformTypeComboBox.setSelectedItem(TRANSFORM_THEME);
        }
        this._tokenPanel = new TextTransColumnSettingTokenPanel(this._context, (AbstractBuildNode)this._data, this._buildNodeType, this._sourceAttributeName, this._token, this._existStoplists);
        this._themePanel = new TextTransColumnSettingThemePanel(this._context, (AbstractBuildNode)this._data, this._buildNodeType, this._sourceAttributeName, this._theme, this._existStoplists);
        this.jSettingPanel.removeAll();
        if (this._bShowTokenSettings) {
            this.jSettingPanel.add(this._tokenPanel);
        } else {
            this.jSettingPanel.add(this._themePanel);
        }
        this._isAdjusting = false;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public boolean doWork() {
        boolean bl = true;
        try {
            TextTransformationType textTransformationType = null;
            for (MapTextTransformedSourceType mapTextTransformedSourceType : this._textAttributes.getMapTextTransformedSource()) {
                if (!mapTextTransformedSourceType.getKey().getName().equals(this._sourceAttributeName)) continue;
                TextTransformationOutputAttributeType textTransformationOutputAttributeType = mapTextTransformedSourceType.getKey();
                textTransformationType = textTransformationOutputAttributeType.getTransformationElement();
                break;
            }
            if (this._bShowTokenSettings) {
                this._dirty = this._tokenPanel.copySettings(this._buildNodeType, this._token, this._existStoplists);
                textTransformationType.setToken(this._token);
                textTransformationType.setTheme(null);
            } else {
                this._dirty = this._themePanel.copySettings(this._buildNodeType, this._theme, this._existStoplists);
                textTransformationType.setToken(null);
                textTransformationType.setTheme((TextTransformationType.Theme)this._theme);
            }
        }
        catch (ValidationException validationException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)validationException.getLocalizedMessage(), (String)DialogsLrb.get("ERROR_TITLE"), null);
            bl = false;
        }
        return bl;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.buttonGroup4 = new ButtonGroup();
        this.jTransformTypeLabel = new JLabel();
        this.jTransformTypeComboBox = new JComboBox();
        this.jSettingPanel = new JPanel();
        this.jTransformTypeLabel.setLabelFor(this.jTransformTypeComboBox);
        this.jTransformTypeLabel.setText("Transform Type:");
        this.jTransformTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Token", "Theme"}));
        this.jTransformTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingPanel.this.jTransformTypeComboBoxActionPerformed(actionEvent);
            }
        });
        this.jSettingPanel.setBorder(BorderFactory.createTitledBorder("Settings"));
        this.jSettingPanel.setLayout(new BorderLayout());
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTransformTypeLabel, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTransformTypeComboBox, -2, 112, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jSettingPanel, GroupLayout.Alignment.TRAILING, -1, 374, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTransformTypeLabel).addComponent(this.jTransformTypeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSettingPanel, -1, 305, Short.MAX_VALUE).addContainerGap()));
    }

    private void jTransformTypeComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this._isAdjusting) {
            return;
        }
        this._isAdjusting = true;
        String string = (String)this.jTransformTypeComboBox.getSelectedItem();
        this.jSettingPanel.removeAll();
        if (string.equals(TRANSFORM_TOKEN)) {
            this._bShowTokenSettings = true;
            this._tokenPanel.refreshUI(this._token);
            this.jSettingPanel.add(this._tokenPanel);
        } else {
            this._bShowTokenSettings = false;
            this._themePanel.refreshUI(this._theme);
            this.jSettingPanel.add(this._themePanel);
        }
        this.jSettingPanel.updateUI();
        this._isAdjusting = false;
    }

    public BuildNodeType.Stoplists getStoplists() {
        return this._existStoplists;
    }

    public TransformedAttributesType getTextAttributes() {
        return this._textAttributes;
    }
}

