/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AbstractPropertiesPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public abstract class AbstractAlgorithmSettingsPanel
extends AbstractPropertiesPanel {
    private static final Logger theLogger = Logger.getLogger(AbstractAlgorithmSettingsPanel.class.getName());
    private AbstractPropertiesPanel contentPanel;
    private JScrollPane scrollPane = null;

    public AbstractAlgorithmSettingsPanel(AdvancedSettingsPanel advancedSettingsPanel) {
        super(advancedSettingsPanel);
        this.setLayout(new BorderLayout());
    }

    public abstract void initializeFromState(CommonSettingDataObject var1);

    protected abstract void addClientPanel();

    public String getTitle() {
        return AlgSettingsLrb.get("ALGORITHM_SETTINGS_ERROR_TITLE");
    }

    public void loadAlgorithm(Context context, ModelType modelType, BuildNodeType buildNodeType, AbstractDataNode abstractDataNode) {
        this.setModelType(modelType);
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        if (commonSettingDataObject == null) {
            commonSettingDataObject = new CommonSettingDataObject(context, this.parentPanel, this.getModelType(), buildNodeType, abstractDataNode, Locale.getDefault());
            this.setState(commonSettingDataObject);
            this.addClientPanel();
            LoadUI loadUI = new LoadUI(AlgSettingsLrb.get("MODEL_SETTINGS_VIEWER_FAILURE_TITLE"), AlgSettingsLrb.get("MODEL_SETTINGS_VIEWER_FAILURE_MESG"));
            loadUI.execute();
        } else if (commonSettingDataObject.isLoaded()) {
            this.addClientPanel();
            this.initializeFromState(commonSettingDataObject);
        } else {
            this.addClientPanel();
            this.showLoadingStatus();
        }
    }

    public boolean isValidState() {
        boolean bl = true;
        Exception exception = null;
        if (this.isContentAvailable()) {
            block4: {
                try {
                    this.getPanelState().validate();
                }
                catch (Exception exception2) {
                    if (!this.getPanelState().isLoaded()) break block4;
                    bl = false;
                    exception = exception2;
                }
            }
            if (exception != null && exception instanceof ValidationException) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)exception.getMessage(), (String)this.getTitle(), null);
            }
        }
        return bl;
    }

    public boolean apply() {
        boolean bl = this.isContentAvailable();
        if (bl && this.getPanelState().isLoaded()) {
            try {
                bl = this.getPanelState().isModified();
                if (bl) {
                    this.getPanelState().finish();
                    this.getPanelState().apply();
                }
            }
            catch (ValidationException validationException) {
                theLogger.log(Level.SEVERE, validationException.getMessage(), validationException);
            }
        }
        return bl;
    }

    private void showLoadingStatus() {
        this.replaceContent(this.createLoadingStatusPanel(this.parentPanel));
    }

    @Override
    public void processInput() {
        if (this.isContentAvailable()) {
            this.contentPanel.clearState();
            this.contentPanel.processInput();
        }
    }

    protected boolean isContentAvailable() {
        return this.contentPanel != null && !(this.contentPanel instanceof AbstractPropertiesPanel.ServicePanel);
    }

    protected void replaceContent(AbstractPropertiesPanel abstractPropertiesPanel) {
        boolean bl = this.parentPanel.isMultpleSelection();
        if (bl && this.contentPanel instanceof AbstractPropertiesPanel.ServicePanel && ((AbstractPropertiesPanel.ServicePanel)this.contentPanel).isMultipleSelectionPanel()) {
            return;
        }
        if (this.contentPanel != null) {
            if (this.contentPanel instanceof AbstractPropertiesPanel.ServicePanel) {
                this.remove(this.contentPanel);
            } else {
                this.remove(this.scrollPane);
            }
        }
        this.contentPanel = abstractPropertiesPanel;
        if (this.contentPanel instanceof AbstractPropertiesPanel.ServicePanel) {
            this.add((Component)this.contentPanel, "Center");
        } else {
            this.scrollPane = new JScrollPane(this.contentPanel);
            this.scrollPane.getVerticalScrollBar().setUnitIncrement(10);
            this.add((Component)this.scrollPane, "Center");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractAlgorithmSettingsPanel.this.validate();
            }
        });
    }

    public void loadUnderConstruction() {
        this.replaceContent(this.createModelUnderConstructionPanel());
    }

    public void loadMultipleSelection() {
        this.replaceContent(this.createMultipleSelection());
    }

    public void loadEmptySelection() {
        this.replaceContent(this.createEmptySelection());
    }

    protected class LoadUI
    extends SwingWorker {
        Exception ex = null;
        boolean success = false;
        private String errorLoadingTitle;
        private String errorLoadingMsg;

        public LoadUI(String string, String string2) {
            this.errorLoadingTitle = string;
            this.errorLoadingMsg = string2;
        }

        protected Object doInBackground() throws Exception {
            CommonSettingDataObject commonSettingDataObject = AbstractAlgorithmSettingsPanel.this.getPanelState();
            try {
                AbstractAlgorithmSettingsPanel.this.showLoadingStatus();
                commonSettingDataObject.load();
                commonSettingDataObject.setLoaded(true);
                this.success = true;
            }
            catch (Exception exception) {
                this.ex = exception;
                this.success = false;
            }
            return commonSettingDataObject;
        }

        @Override
        protected void done() {
            if (this.success && this.ex == null) {
                AbstractAlgorithmSettingsPanel.this.getPanelState().initializeClients();
            } else if (this.ex != null) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this.ex, (String)this.errorLoadingTitle, (String)this.errorLoadingMsg, null);
            } else {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)this.errorLoadingMsg, (String)this.errorLoadingTitle, null);
            }
        }
    }
}

