/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AbstractPropertiesPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.GLMTargetValuesPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.ModelGLMBuildFeatureSelectPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.ModelGLMBuildRideRegressPanel;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseBuildNodeType;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.Version;

public class ModelGLMBuildSettingsPanel
extends AbstractPropertiesPanel {
    private static final Logger theLogger = Logger.getLogger(ModelGLMBuildSettingsPanel.class.getName());
    private Version _dbVersion = null;
    private HashMap<String, Object> _cacheSettings = new HashMap();
    private ButtonGroup buttonGroup1;
    private JLabel jApproxComputationLabel;
    private JButton jBtnEdit;
    private JCheckBox jChkDiagnosticTable;
    private JCheckBox jChkRowWeights;
    private JComboBox jCmbMissValueTreatment;
    private JComboBox jCmbRowWeights;
    private JCheckBox jFeatureGenerationCheckBox;
    private JComboBox jFeatureGenerationComboBox;
    private JComboBox jFeatureIdentificationComboBox;
    private JButton jFeatureSelectionButton;
    private JCheckBox jFeatureSelectionRadioButton;
    private JLabel jLabel1;
    private JLabel jLblConfLevel;
    private JLabel jLblMissigValueTreat;
    private JLabel jLblRefClassName;
    private JButton jRidgeRegressButton;
    private JComboBox jRidgeRegressComboBox;
    private JLabel jRidgeRegressLabel;
    private JScrollPane jScrollPaneTitle;
    private JTextField jTxtConfidenceLevel;
    private JMultiLineLabel _jDescription = new JMultiLineLabel();
    private static String _empty = AlgSettingsLrb.get("GLM_ROW_WEIGHT_COLUMN_NAME_EMPTY");
    private static String _meanMode = DialogsLrb.get("GLM_MISSING_VALUES_COLUMN_MEAN_MODE");
    private static String _deleteRow = DialogsLrb.get("GLM_MISSING_VALUES_COLUMN_DELETE_ROW");
    private static HashMap<String, String> _missingValTreatmentDef = new HashMap();
    private static HashMap<String, String> _missingValTreatmentHumanReadeable = new HashMap();
    private String _generatedRowDiagnosticTableName = null;

    public ModelGLMBuildSettingsPanel(AdvancedSettingsPanel advancedSettingsPanel, ModelType modelType) {
        super(advancedSettingsPanel, modelType);
        try {
            this._dbVersion = ConnectionFolder.getConnectionFolder(advancedSettingsPanel.getContext()).getDbVersion();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPaneTitle = new JScrollPane();
        this.jChkDiagnosticTable = new JCheckBox();
        this.jLblConfLevel = new JLabel();
        this.jTxtConfidenceLevel = new NumberTextField();
        this.jLblRefClassName = new JLabel();
        this.jLabel1 = new JLabel();
        this.jBtnEdit = new JButton();
        this.jLblMissigValueTreat = new JLabel();
        this.jCmbMissValueTreatment = new JComboBox();
        this.jChkRowWeights = new JCheckBox();
        this.jCmbRowWeights = new JComboBox();
        this.jFeatureSelectionRadioButton = new JCheckBox();
        this.jFeatureSelectionButton = new JButton();
        this.jFeatureGenerationCheckBox = new JCheckBox();
        this.jFeatureGenerationComboBox = new JComboBox();
        this.jRidgeRegressLabel = new JLabel();
        this.jRidgeRegressComboBox = new JComboBox();
        this.jRidgeRegressButton = new JButton();
        this.jApproxComputationLabel = new JLabel();
        this.jFeatureIdentificationComboBox = new JComboBox();
        this.jScrollPaneTitle.setBorder(null);
        this.jScrollPaneTitle.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneTitle.setVerticalScrollBarPolicy(21);
        this.jChkDiagnosticTable.setText("Row Diagnostics Table");
        this.jChkDiagnosticTable.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jChkDiagnosticTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelGLMBuildSettingsPanel.this.jChkDiagnosticTableActionPerformed(actionEvent);
            }
        });
        this.jLblConfLevel.setLabelFor(this.jTxtConfidenceLevel);
        this.jLblConfLevel.setText("Confidence Level:");
        this.jLblRefClassName.setText("Reference Class name:");
        this.jLabel1.setText("<System defined>");
        this.jBtnEdit.setText("Edit");
        this.jLblMissigValueTreat.setLabelFor(this.jCmbMissValueTreatment);
        this.jLblMissigValueTreat.setText("Missing Value Treatment:");
        this.jCmbMissValueTreatment.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jChkRowWeights.setText("Specify Row Weight");
        this.jChkRowWeights.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jCmbRowWeights.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1"}));
        this.jFeatureSelectionRadioButton.setText("Feature Selection:");
        this.jFeatureSelectionRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelGLMBuildSettingsPanel.this.jFeatureSelectionRadioButtonActionPerformed(actionEvent);
            }
        });
        this.jFeatureSelectionButton.setText("Option...");
        this.jFeatureSelectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelGLMBuildSettingsPanel.this.jFeatureSelectionButtonActionPerformed(actionEvent);
            }
        });
        this.jFeatureGenerationCheckBox.setText("Feature Generation");
        this.jFeatureGenerationCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelGLMBuildSettingsPanel.this.jFeatureGenerationCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jFeatureGenerationComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"System Determined"}));
        this.jRidgeRegressLabel.setText("Ridge Regression:");
        this.jRidgeRegressComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"System Determined"}));
        this.jRidgeRegressComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelGLMBuildSettingsPanel.this.jRidgeRegressComboBoxActionPerformed(actionEvent);
            }
        });
        this.jRidgeRegressButton.setText("Option...");
        this.jRidgeRegressButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelGLMBuildSettingsPanel.this.jRidgeRegressButtonActionPerformed(actionEvent);
            }
        });
        this.jApproxComputationLabel.setLabelFor(this.jFeatureIdentificationComboBox);
        this.jApproxComputationLabel.setText("Approximate Computation:");
        this.jFeatureIdentificationComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"System Determined"}));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jChkDiagnosticTable).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.jFeatureGenerationCheckBox, -2, 126, -2).addGap(37, 37, 37)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jApproxComputationLabel, -2, 163, -2).addComponent(this.jLblRefClassName).addComponent(this.jLblMissigValueTreat).addComponent(this.jChkRowWeights).addGroup(groupLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.jLblConfLevel)).addComponent(this.jRidgeRegressLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jFeatureIdentificationComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.jFeatureGenerationComboBox, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(this.jTxtConfidenceLevel, GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jCmbMissValueTreatment, 0, -1, Short.MAX_VALUE).addComponent(this.jCmbRowWeights, 0, 182, Short.MAX_VALUE).addComponent(this.jRidgeRegressComboBox, 0, -1, Short.MAX_VALUE))).addComponent(this.jFeatureSelectionRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRidgeRegressButton).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jFeatureSelectionButton, -1, -1, Short.MAX_VALUE).addComponent(this.jBtnEdit, -1, -1, Short.MAX_VALUE))))).addGap(0, 0, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jScrollPaneTitle))).addContainerGap()));
        groupLayout.linkSize(0, this.jCmbMissValueTreatment, this.jCmbRowWeights, this.jFeatureGenerationComboBox, this.jFeatureIdentificationComboBox, this.jLabel1, this.jRidgeRegressComboBox, this.jTxtConfidenceLevel);
        groupLayout.linkSize(0, this.jChkDiagnosticTable, this.jChkRowWeights, this.jLblConfLevel, this.jLblMissigValueTreat, this.jLblRefClassName);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneTitle, -2, 44, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jChkDiagnosticTable).addGap(9, 9, 9).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblConfLevel).addComponent(this.jTxtConfidenceLevel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblRefClassName).addComponent(this.jLabel1).addComponent(this.jBtnEdit)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblMissigValueTreat).addComponent(this.jCmbMissValueTreatment, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jChkRowWeights).addComponent(this.jCmbRowWeights, -2, -1, -2)).addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFeatureSelectionButton).addComponent(this.jFeatureSelectionRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jFeatureGenerationComboBox, -2, -1, -2).addComponent(this.jFeatureGenerationCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRidgeRegressComboBox, -2, -1, -2).addComponent(this.jRidgeRegressButton).addComponent(this.jRidgeRegressLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFeatureIdentificationComboBox, -2, -1, -2).addComponent(this.jApproxComputationLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(1, this.jChkDiagnosticTable, this.jChkRowWeights, this.jLblConfLevel, this.jLblMissigValueTreat, this.jLblRefClassName);
    }

    private void jFeatureSelectionButtonActionPerformed(ActionEvent actionEvent) {
        FeatureSelectionDialog featureSelectionDialog = new FeatureSelectionDialog(this);
        featureSelectionDialog.invoke();
    }

    private void jRidgeRegressButtonActionPerformed(ActionEvent actionEvent) {
        RideRegressDialog rideRegressDialog = new RideRegressDialog(this);
        rideRegressDialog.invoke();
    }

    private void jFeatureSelectionRadioButtonActionPerformed(ActionEvent actionEvent) {
        if (this.jFeatureSelectionRadioButton.isSelected()) {
            this.jRidgeRegressComboBox.setSelectedItem(ServerConstants.GLMSettings.toHuman("GLMS_RIDGE_REG_DISABLE"));
        }
        this.enableControls();
    }

    private void jFeatureGenerationCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (this.jFeatureGenerationCheckBox.isSelected()) {
            this._cacheSettings.put("GLMS_SELECT_BLOCK", "GLMS_SELECT_BLOCK_DISABLE");
        } else {
            this._cacheSettings.put("GLMS_SELECT_BLOCK", null);
        }
        this.enableControls();
    }

    private void jRidgeRegressComboBoxActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.jRidgeRegressComboBox.getSelectedItem();
        if (string.compareTo(CommonSettingDataObject.SYSTEM_DETERMINED) == 0 || string.compareTo(ServerConstants.GLMSettings.toHuman("GLMS_RIDGE_REG_ENABLE")) == 0) {
            this.jFeatureSelectionRadioButton.setSelected(false);
        }
        this.enableControls();
    }

    private void jChkDiagnosticTableActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    private void initUI() {
        Object object;
        Serializable serializable;
        final CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        this.loadDescription(this._jDescription, this.jScrollPaneTitle);
        this._cacheSettings.clear();
        ResourceUtils.resButton((AbstractButton)this.jChkDiagnosticTable, (String)AlgSettingsLrb.get("GLM_DIAGNOSTIC_TABLE_NAME"));
        ResourceUtils.resLabel((JLabel)this.jLblConfLevel, (Component)this.jTxtConfidenceLevel, (String)AlgSettingsLrb.get("GLM_CONFIDENCE_LEVEL"));
        ResourceUtils.resLabel((JLabel)this.jLblRefClassName, (Component)this.jLabel1, (String)AlgSettingsLrb.get("GLM_REFERENCE_CLASS_NAME"));
        ResourceUtils.resLabel((JLabel)this.jLblMissigValueTreat, (Component)this.jCmbMissValueTreatment, (String)AlgSettingsLrb.get("GLM_MISSING_VALUES_COLUMN_LABEL"));
        ResourceUtils.resButton((AbstractButton)this.jChkRowWeights, (String)AlgSettingsLrb.get("GLM_ROW_WIGHTS_COLUMN_LABEL"));
        ResourceUtils.resLabel((JLabel)this.jRidgeRegressLabel, (Component)this.jRidgeRegressComboBox, (String)AlgSettingsLrb.get("GLM_RIDGE_REGRESSION"));
        ResourceUtils.resButton((AbstractButton)this.jRidgeRegressButton, (String)AlgSettingsLrb.get("GLM_ADV_OPTION"));
        ResourceUtils.resButton((AbstractButton)this.jFeatureSelectionRadioButton, (String)AlgSettingsLrb.get("GLM_FEATURE_SELECTION"));
        ResourceUtils.resButton((AbstractButton)this.jFeatureGenerationCheckBox, (String)AlgSettingsLrb.get("GLM_FEATURE_GENERATION"));
        ResourceUtils.resButton((AbstractButton)this.jFeatureSelectionButton, (String)AlgSettingsLrb.get("GLM_ADV_OPTION"));
        ResourceUtils.resLabel((JLabel)this.jApproxComputationLabel, (Component)this.jFeatureIdentificationComboBox, (String)AlgSettingsLrb.get("GLMS_APPROXIMATE_COMPUTATION"));
        if (this.getModelType() instanceof RGeneralizedLinearModelType) {
            this.jLabel1.setVisible(false);
            this.jBtnEdit.setVisible(false);
            this.jLblRefClassName.setVisible(false);
        } else {
            this.jBtnEdit.setText(AlgSettingsLrb.get("GLM_REFERENCE_CLASS_NAME_EDIT"));
            this.jBtnEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ReferenceClassDialog referenceClassDialog = new ReferenceClassDialog();
                    if (referenceClassDialog.invoke()) {
                        ModelGLMBuildSettingsPanel.this.jLabel1.setText(commonSettingDataObject.getCurClassRefValue());
                    }
                }
            });
        }
        this.jCmbMissValueTreatment.setModel(new DefaultComboBoxModel<String>(new String[]{_meanMode, _deleteRow}));
        String string = commonSettingDataObject.getModelSettingStringValue("ODMS_MISSING_VALUE_TREATMENT");
        this.jCmbMissValueTreatment.setSelectedItem(_missingValTreatmentHumanReadeable.get(string));
        commonSettingDataObject.setBackupValue("ODMS_MISSING_VALUE_TREATMENT", string);
        List<AttributeType> list = commonSettingDataObject.getAttributes();
        if (list != null && list.size() > 0) {
            boolean bl;
            serializable = new Vector<String>();
            for (int i = 0; i < list.size(); ++i) {
                AttributeType attributeType = list.get(i);
                try {
                    if (!DatabaseMetadataUtils.isNumericTypeSupported(this.getPanelState().getContext(), attributeType.getDataType())) continue;
                    ((Vector)serializable).add(attributeType.getName());
                    continue;
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
            Collections.sort(serializable);
            this.jCmbRowWeights.setModel(new DefaultComboBoxModel(serializable));
            object = commonSettingDataObject.getModelSettingStringValue("ODMS_ROW_WEIGHT_COLUMN_NAME");
            boolean bl2 = bl = object == null || ((String)object).isEmpty() || CommonSettingDataObject.isValueNull(object);
            if (bl) {
                commonSettingDataObject.setBackupNullValue("ODMS_ROW_WEIGHT_COLUMN_NAME");
            } else {
                commonSettingDataObject.setBackupValue("ODMS_ROW_WEIGHT_COLUMN_NAME", object);
                this.jCmbRowWeights.setSelectedItem(object);
            }
            this.jCmbRowWeights.setEnabled(!bl);
            this.jChkRowWeights.setSelected(!bl);
            this.jChkRowWeights.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ModelGLMBuildSettingsPanel.this.jCmbRowWeights.setEnabled(ModelGLMBuildSettingsPanel.this.jChkRowWeights.isSelected());
                }
            });
        } else {
            this.jChkRowWeights.setEnabled(false);
            this.jCmbRowWeights.setModel(new DefaultComboBoxModel<String>(new String[]{_empty}));
            this.jCmbRowWeights.setEnabled(false);
            commonSettingDataObject.setBackupNullValue("ODMS_ROW_WEIGHT_COLUMN_NAME");
        }
        this.jLblConfLevel.setLabelFor(this.jTxtConfidenceLevel);
        this.jTxtConfidenceLevel.setToolTipText(AlgSettingsLrb.get("GLM_CONFIDENCE_LEVEL_TOOLTIP"));
        this.setDataType(this.jTxtConfidenceLevel, Double.class);
        ((NumberTextField)this.jTxtConfidenceLevel).setDecimal(true, 4);
        this.setSigned(this.jTxtConfidenceLevel, true);
        this.setLocale(this.jTxtConfidenceLevel, Locale.getDefault());
        serializable = commonSettingDataObject.getModelSettingNumValue("GLMS_CONF_LEVEL");
        if (serializable == null) {
            serializable = new BigDecimal(0.95);
        }
        object = ((BigDecimal)serializable).doubleValue();
        commonSettingDataObject.setBackupValue("GLMS_CONF_LEVEL", object);
        this.setNumber(this.jTxtConfidenceLevel, (Number)object);
        String string2 = commonSettingDataObject.getModelSettingStringValue("GLMS_DIAGNOSTICS_TABLE_NAME");
        if (CommonSettingDataObject.isValueNull(string2) || string2.length() == 0) {
            commonSettingDataObject.setBackupNullValue("GLMS_DIAGNOSTICS_TABLE_NAME");
            this.jChkDiagnosticTable.setSelected(false);
            this._generatedRowDiagnosticTableName = null;
        } else {
            this.jChkDiagnosticTable.setSelected(true);
            commonSettingDataObject.setBackupValue("GLMS_DIAGNOSTICS_TABLE_NAME", string2);
            this._generatedRowDiagnosticTableName = string2;
        }
        if (commonSettingDataObject.isCaseIdSelected()) {
            this.jChkDiagnosticTable.setEnabled(true);
        } else {
            this.jChkDiagnosticTable.setEnabled(false);
        }
        this.jChkDiagnosticTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ModelGLMBuildSettingsPanel.this.jChkDiagnosticTable.isSelected()) {
                    RowDiagnosticTableNameGen rowDiagnosticTableNameGen = new RowDiagnosticTableNameGen();
                    rowDiagnosticTableNameGen.setTitle(AlgSettingsLrb.get("GLMS_ROW_DIAGNOSTIC_TABLE_GEN_TITLE"));
                    rowDiagnosticTableNameGen.setMessage(AlgSettingsLrb.get("GLMS_ROW_DIAGNOSTIC_TABLE_GEN_DESC"));
                    rowDiagnosticTableNameGen.setCancelable(true);
                    try {
                        rowDiagnosticTableNameGen.start(true);
                        if (!rowDiagnosticTableNameGen.isCanceled()) {
                            ModelGLMBuildSettingsPanel.this._generatedRowDiagnosticTableName = rowDiagnosticTableNameGen.getTableName();
                        }
                    }
                    catch (ProgressException progressException) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)progressException, (String)AlgSettingsLrb.get("GLMS_ROW_DIAGNOSTIC_TABLE_UNEXPECTED_ERROR_TITLE"), (String)AlgSettingsLrb.get("GLMS_ROW_DIAGNOSTIC_TABLE_UNEXPECTED_ERROR_MSG"), null);
                    }
                } else {
                    ModelGLMBuildSettingsPanel.this._generatedRowDiagnosticTableName = null;
                }
            }
        });
        String string3 = commonSettingDataObject.getModelSettingStringValue("GLMS_REFERENCE_CLASS_NAME");
        if (string3 != null && !string3.isEmpty()) {
            commonSettingDataObject.setBackupValue("GLMS_REFERENCE_CLASS_NAME", string3);
            this.jLabel1.setText(string3);
        } else {
            commonSettingDataObject.setBackupNullValue("GLMS_REFERENCE_CLASS_NAME");
            this.jLabel1.setText(CommonSettingDataObject.SYSTEM_DETERMINED);
        }
        BigDecimal bigDecimal = commonSettingDataObject.getModelSettingNumValue("GLMS_RIDGE_VALUE");
        this._cacheSettings.put("GLMS_RIDGE_VALUE", bigDecimal);
        commonSettingDataObject.setBackupValue("GLMS_RIDGE_VALUE", bigDecimal);
        if (commonSettingDataObject.getModelType() instanceof RGeneralizedLinearModelType) {
            string2 = commonSettingDataObject.getModelSettingStringValue("GLMS_VIF_FOR_RIDGE");
            this._cacheSettings.put("GLMS_VIF_FOR_RIDGE", string2);
            commonSettingDataObject.setBackupValue("GLMS_VIF_FOR_RIDGE", string2);
        }
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(new String[]{CommonSettingDataObject.SYSTEM_DETERMINED, ServerConstants.GLMSettings.toHuman("GLMS_RIDGE_REG_ENABLE"), ServerConstants.GLMSettings.toHuman("GLMS_RIDGE_REG_DISABLE")});
        this.jRidgeRegressComboBox.setModel(defaultComboBoxModel);
        String string4 = commonSettingDataObject.getModelSettingStringValue("GLMS_RIDGE_REGRESSION");
        if (CommonSettingDataObject.isValueNull(string4) || string4.length() == 0) {
            commonSettingDataObject.setBackupNullValue("GLMS_RIDGE_REGRESSION");
            this.jRidgeRegressComboBox.setSelectedItem(CommonSettingDataObject.SYSTEM_DETERMINED);
        } else {
            commonSettingDataObject.setBackupValue("GLMS_RIDGE_REGRESSION", string4);
            this.jRidgeRegressComboBox.setSelectedItem(ServerConstants.GLMSettings.toHuman(string4));
        }
        if (ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, this._dbVersion, true)) {
            string2 = commonSettingDataObject.getModelSettingStringValue("GLMS_FTR_SELECTION");
            if (string2 == null || string2.isEmpty()) {
                this.jFeatureSelectionRadioButton.setSelected(false);
            } else if (string2.equals("GLMS_FTR_SELECTION_ENABLE")) {
                this.jFeatureSelectionRadioButton.setSelected(true);
            }
            commonSettingDataObject.setBackupValue("GLMS_FTR_SELECTION", string2);
            DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>(new String[]{CommonSettingDataObject.SYSTEM_DETERMINED, ServerConstants.GLMSettings.toHuman("GLMS_FTR_GEN_QUADRATIC"), ServerConstants.GLMSettings.toHuman("GLMS_FTR_GEN_CUBIC")});
            this.jFeatureGenerationComboBox.setModel(defaultComboBoxModel2);
            string2 = commonSettingDataObject.getModelSettingStringValue("GLMS_FTR_GEN_METHOD");
            if (CommonSettingDataObject.isValueNull(string2) || string2.length() == 0) {
                commonSettingDataObject.setBackupNullValue("GLMS_FTR_GEN_METHOD");
                this.jFeatureGenerationComboBox.setSelectedItem(CommonSettingDataObject.SYSTEM_DETERMINED);
            } else {
                commonSettingDataObject.setBackupValue("GLMS_FTR_GEN_METHOD", string2);
                this.jFeatureGenerationComboBox.setSelectedItem(ServerConstants.GLMSettings.toHuman(string2));
            }
            string2 = commonSettingDataObject.getModelSettingStringValue("GLMS_FTR_GENERATION");
            if (string2 == null || string2.isEmpty()) {
                this.jFeatureGenerationCheckBox.setSelected(false);
            } else if (string2.equals("GLMS_FTR_GENERATION_ENABLE")) {
                this.jFeatureGenerationCheckBox.setSelected(true);
            }
            commonSettingDataObject.setBackupValue("GLMS_FTR_GENERATION", string2);
            string2 = commonSettingDataObject.getModelSettingStringValue("GLMS_FTR_SEL_CRIT");
            this._cacheSettings.put("GLMS_FTR_SEL_CRIT", string2);
            commonSettingDataObject.setBackupValue("GLMS_FTR_SEL_CRIT", string2);
            bigDecimal = commonSettingDataObject.getModelSettingNumValue("GLMS_MAX_FEATURES");
            this._cacheSettings.put("GLMS_MAX_FEATURES", bigDecimal);
            commonSettingDataObject.setBackupValue("GLMS_MAX_FEATURES", bigDecimal);
            DefaultComboBoxModel<String> defaultComboBoxModel3 = new DefaultComboBoxModel<String>(new String[]{CommonSettingDataObject.SYSTEM_DETERMINED, ServerConstants.GLMSettings.toHuman("ODMS_APPR_COMP_ENABLE"), ServerConstants.GLMSettings.toHuman("ODMS_APPR_COMP_DISABLE")});
            this.jFeatureIdentificationComboBox.setModel(defaultComboBoxModel3);
            string2 = commonSettingDataObject.getModelSettingStringValue("ODMS_APPROXIMATE_COMPUTATION");
            if (CommonSettingDataObject.isValueNull(string2) || string2.length() == 0) {
                this.jFeatureIdentificationComboBox.setSelectedItem(CommonSettingDataObject.SYSTEM_DETERMINED);
                commonSettingDataObject.setBackupNullValue("ODMS_APPROXIMATE_COMPUTATION");
            } else {
                this.jFeatureIdentificationComboBox.setSelectedItem(ServerConstants.GLMSettings.toHuman(string2));
                commonSettingDataObject.setBackupValue("ODMS_APPROXIMATE_COMPUTATION", string2);
            }
            string2 = commonSettingDataObject.getModelSettingStringValue("GLMS_FTR_ACCEPTANCE");
            this._cacheSettings.put("GLMS_FTR_ACCEPTANCE", string2);
            commonSettingDataObject.setBackupValue("GLMS_FTR_ACCEPTANCE", string2);
            string2 = commonSettingDataObject.getModelSettingStringValue("GLMS_PRUNE_MODEL");
            this._cacheSettings.put("GLMS_PRUNE_MODEL", string2);
            commonSettingDataObject.setBackupValue("GLMS_PRUNE_MODEL", string2);
            string2 = commonSettingDataObject.getModelSettingStringValue("GLMS_FTR_GENERATION");
            this._cacheSettings.put("GLMS_FTR_GENERATION", string2);
            string2 = commonSettingDataObject.getModelSettingStringValue("GLMS_SELECT_BLOCK");
            this._cacheSettings.put("GLMS_SELECT_BLOCK", string2);
            commonSettingDataObject.setBackupValue("GLMS_SELECT_BLOCK", string2);
        } else {
            this.jFeatureSelectionRadioButton.setVisible(false);
            this.jFeatureSelectionButton.setVisible(false);
            this.jFeatureGenerationCheckBox.setVisible(false);
            this.jFeatureGenerationComboBox.setVisible(false);
            this.jApproxComputationLabel.setVisible(false);
            this.jFeatureIdentificationComboBox.setVisible(false);
        }
        this.enableControls();
    }

    private void enableControls() {
        String string = (String)this.jRidgeRegressComboBox.getSelectedItem();
        this.jRidgeRegressButton.setEnabled(string.compareTo(ServerConstants.GLMSettings.toHuman("GLMS_RIDGE_REG_ENABLE")) == 0);
        this.jFeatureSelectionButton.setEnabled(this.jFeatureSelectionRadioButton.isSelected());
        if (!this.jFeatureSelectionRadioButton.isSelected()) {
            this.jFeatureGenerationCheckBox.setSelected(false);
        }
        this.jFeatureGenerationCheckBox.setEnabled(this.jFeatureSelectionRadioButton.isSelected());
        this.jFeatureGenerationComboBox.setEnabled(this.jFeatureGenerationCheckBox.isSelected());
        this.jCmbRowWeights.setEnabled(this.jChkRowWeights.isSelected());
        this.jTxtConfidenceLevel.setEnabled(this.jChkDiagnosticTable.isSelected());
    }

    @Override
    public void processInput() {
        Object object;
        Object object2;
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        commonSettingDataObject.setCommonPerformanceOption();
        Number number = this.getNumber(this.jTxtConfidenceLevel);
        if (null == number || number.doubleValue() <= 0.0 || number.doubleValue() > 1.0) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("GLM_CONFIDENCE_LEVEL_INVALID"));
            return;
        }
        this.setObjectValue("GLMS_CONF_LEVEL", number);
        if (this.jChkDiagnosticTable.isSelected()) {
            this.setObjectValue("GLMS_DIAGNOSTICS_TABLE_NAME", this._generatedRowDiagnosticTableName);
        } else {
            this.setNullObjectValue("GLMS_DIAGNOSTICS_TABLE_NAME");
        }
        String string = this.jLabel1.getText();
        if (string.equals(CommonSettingDataObject.SYSTEM_DETERMINED)) {
            this.setNullObjectValue("GLMS_REFERENCE_CLASS_NAME");
        } else {
            this.setObjectValue("GLMS_REFERENCE_CLASS_NAME", string);
        }
        String string2 = (String)this.jCmbMissValueTreatment.getSelectedItem();
        if (_missingValTreatmentDef.get(string2).equals("ODMS_MISSING_VALUE_DELETE_ROW")) {
            object2 = commonSettingDataObject.getModelType().getInputMiningData().getMiningAttributes();
            for (Object object3 : object2.getMiningAttribute()) {
                String string3 = object3.getDataType();
                String string4 = object3.getInput();
                if (!string4.equals("Yes") || !string3.startsWith("DM_NESTED")) continue;
                this.setValidationErrorObjectValue(AlgSettingsLrb.get("GLMS_MISSING_VALUE_DELETE_ROW_INVALID"));
                return;
            }
        }
        this.setObjectValue("ODMS_MISSING_VALUE_TREATMENT", _missingValTreatmentDef.get(string2));
        if (this.jChkRowWeights.isSelected()) {
            Object object3;
            string2 = (String)this.jCmbRowWeights.getSelectedItem();
            object2 = this.getParentPanel().getMetadataCopy();
            object = ((SuperviseBuildNodeType)object2).getTargetAttribute();
            if (object != null && string2.equals(object3 = object.getName())) {
                this.setValidationErrorObjectValue(AlgSettingsLrb.get("GLMS_ROW_WEIGHT_COLUMN_INVALID"));
                return;
            }
            this.setObjectValue("ODMS_ROW_WEIGHT_COLUMN_NAME", string2);
        } else {
            this.setNullObjectValue("ODMS_ROW_WEIGHT_COLUMN_NAME");
        }
        string2 = (String)this.jRidgeRegressComboBox.getSelectedItem();
        if (string2.equals(CommonSettingDataObject.SYSTEM_DETERMINED)) {
            this.setObjectValue("GLMS_RIDGE_REGRESSION", null);
            this.setObjectValue("GLMS_RIDGE_VALUE", null);
            this.setObjectValue("GLMS_VIF_FOR_RIDGE", null);
        } else if (string2.compareTo(ServerConstants.GLMSettings.toHuman("GLMS_RIDGE_REG_ENABLE")) == 0) {
            this.setObjectValue("GLMS_RIDGE_REGRESSION", "GLMS_RIDGE_REG_ENABLE");
            object2 = (Number)this._cacheSettings.get("GLMS_RIDGE_VALUE");
            this.setObjectValue("GLMS_RIDGE_VALUE", object2);
            if (commonSettingDataObject.getModelType() instanceof RGeneralizedLinearModelType) {
                object = (String)this._cacheSettings.get("GLMS_VIF_FOR_RIDGE");
                this.setObjectValue("GLMS_VIF_FOR_RIDGE", object);
            } else {
                this.setObjectValue("GLMS_VIF_FOR_RIDGE", null);
            }
        } else {
            this.setObjectValue("GLMS_RIDGE_REGRESSION", "GLMS_RIDGE_REG_DISABLE");
            this.setObjectValue("GLMS_RIDGE_VALUE", null);
            this.setObjectValue("GLMS_VIF_FOR_RIDGE", null);
        }
        if (ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, this._dbVersion, true)) {
            this.setObjectValue("GLMS_FTR_SELECTION", null);
            this.setObjectValue("GLMS_FTR_SEL_CRIT", null);
            this.setObjectValue("GLMS_MAX_FEATURES", null);
            this.setObjectValue("GLMS_SELECT_BLOCK", null);
            this.setObjectValue("GLMS_PRUNE_MODEL", null);
            this.setObjectValue("GLMS_FTR_ACCEPTANCE", null);
            this.setObjectValue("GLMS_FTR_GENERATION", null);
            this.setObjectValue("GLMS_FTR_GEN_METHOD", null);
            if (this.jFeatureSelectionRadioButton.isSelected()) {
                this.setObjectValue("GLMS_FTR_SELECTION", "GLMS_FTR_SELECTION_ENABLE");
                string2 = (String)this._cacheSettings.get("GLMS_PRUNE_MODEL");
                if (string2 == null || string2.isEmpty()) {
                    string2 = "GLMS_PRUNE_MODEL_ENABLE";
                }
                this.setObjectValue("GLMS_PRUNE_MODEL", string2);
                object2 = (Number)this._cacheSettings.get("GLMS_MAX_FEATURES");
                this.setObjectValue("GLMS_MAX_FEATURES", object2);
                string2 = (String)this._cacheSettings.get("GLMS_SELECT_BLOCK");
                this.setObjectValue("GLMS_SELECT_BLOCK", string2);
                string2 = (String)this._cacheSettings.get("GLMS_FTR_SEL_CRIT");
                this.setObjectValue("GLMS_FTR_SEL_CRIT", string2);
                string2 = (String)this._cacheSettings.get("GLMS_FTR_ACCEPTANCE");
                this.setObjectValue("GLMS_FTR_ACCEPTANCE", string2);
            }
            if (this.jFeatureGenerationCheckBox.isSelected()) {
                this.setObjectValue("GLMS_FTR_GENERATION", "GLMS_FTR_GENERATION_ENABLE");
                string2 = (String)this.jFeatureGenerationComboBox.getSelectedItem();
                if (string2.equals(CommonSettingDataObject.SYSTEM_DETERMINED)) {
                    this.setObjectValue("GLMS_FTR_GEN_METHOD", null);
                } else {
                    this.setObjectValue("GLMS_FTR_GEN_METHOD", ServerConstants.GLMSettings.toAlgorithm(string2));
                }
            } else {
                this.setObjectValue("GLMS_FTR_GEN_METHOD", null);
            }
            string2 = (String)this.jFeatureIdentificationComboBox.getSelectedItem();
            if (string2.equals(CommonSettingDataObject.SYSTEM_DETERMINED)) {
                this.setObjectValue("ODMS_APPROXIMATE_COMPUTATION", null);
            } else {
                this.setObjectValue("ODMS_APPROXIMATE_COMPUTATION", ServerConstants.GLMSettings.toAlgorithm(string2));
            }
        }
    }

    public HashMap<String, Object> getCacheSettings() {
        return this._cacheSettings;
    }

    boolean isFeatureGenerationSelected() {
        return this.jFeatureGenerationCheckBox.isSelected();
    }

    static {
        _missingValTreatmentDef.put(_meanMode, "ODMS_MISSING_VALUE_MEAN_MODE");
        _missingValTreatmentDef.put(_deleteRow, "ODMS_MISSING_VALUE_DELETE_ROW");
        _missingValTreatmentHumanReadeable.put("ODMS_MISSING_VALUE_MEAN_MODE", _meanMode);
        _missingValTreatmentHumanReadeable.put("ODMS_MISSING_VALUE_DELETE_ROW", _deleteRow);
    }

    class RowDiagnosticTableNameGen
    extends ProgressRunnable {
        private boolean _canceled;
        private String _tableName;
        private String ROW_DIAG_SUFFIX = "_RD";

        RowDiagnosticTableNameGen() {
        }

        public String getTableName() {
            return this._tableName;
        }

        protected Object doWork() throws Exception {
            this._tableName = WorkflowUtils.getNewTableName(ModelGLMBuildSettingsPanel.this.getPanelState().getContext(), "ODMR$" + ModelGLMBuildSettingsPanel.this.getModelType().getName() + this.ROW_DIAG_SUFFIX);
            return this._tableName;
        }

        protected void finish(Object object) {
        }

        protected void doCancel() {
            super.doCancel();
            this._canceled = true;
        }

        public boolean isCanceled() {
            return this._canceled;
        }
    }

    class FeatureSelectionDialog {
        protected String wizName = "Define Feature Selection/Generation Settings";
        protected ModelGLMBuildSettingsPanel _parent;

        public FeatureSelectionDialog(ModelGLMBuildSettingsPanel modelGLMBuildSettingsPanel2) {
            this._parent = modelGLMBuildSettingsPanel2;
        }

        protected JEWTDialog buildDialog() {
            ModelGLMBuildFeatureSelectPanel modelGLMBuildFeatureSelectPanel = new ModelGLMBuildFeatureSelectPanel(this._parent);
            IdeMainWindow ideMainWindow = Ide.getMainWindow();
            int n = 7;
            JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, this.wizName, n);
            jEWTDialog.setContent((Component)modelGLMBuildFeatureSelectPanel);
            jEWTDialog.setTitle(this.getDialogTitle());
            return jEWTDialog;
        }

        private String getDialogTitle() {
            return AlgSettingsLrb.get("GLMS_FEATURE_SELECTION_OPTION_DIALOG_TITLE");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean invoke() {
            boolean bl = false;
            try {
                JEWTDialog jEWTDialog = this.buildDialog();
                jEWTDialog.setResizable(true);
                final ModelGLMBuildFeatureSelectPanel modelGLMBuildFeatureSelectPanel = (ModelGLMBuildFeatureSelectPanel)jEWTDialog.getContent();
                jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                    @Override
                    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                        String string = propertyChangeEvent.getPropertyName();
                        Object object = propertyChangeEvent.getNewValue();
                        if (string.equals("closed") && Boolean.TRUE.equals(object) && !modelGLMBuildFeatureSelectPanel.doWork()) {
                            throw new PropertyVetoException("panel", propertyChangeEvent);
                        }
                    }
                });
                if (jEWTDialog != null) {
                    bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)AlgSettingsLrb.get("GLMS_FEATURE_SELECTION_OPTION_DIALOG_TITLE"), (String)AlgSettingsLrb.get("GLMS_FEATURE_SELECTION_OPTION_DIALOG_FAIL_MSG"), null);
            }
            finally {
                if (!bl) {
                    this.cancel();
                }
            }
            return bl;
        }

        protected void cancel() {
        }
    }

    class RideRegressDialog {
        protected String wizName = "Define Ridge Regression Settings";
        protected ModelGLMBuildSettingsPanel _parent;

        public RideRegressDialog(ModelGLMBuildSettingsPanel modelGLMBuildSettingsPanel2) {
            this._parent = modelGLMBuildSettingsPanel2;
        }

        protected JEWTDialog buildDialog() {
            ModelGLMBuildRideRegressPanel modelGLMBuildRideRegressPanel = new ModelGLMBuildRideRegressPanel(this._parent);
            IdeMainWindow ideMainWindow = Ide.getMainWindow();
            int n = 7;
            JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, this.wizName, n);
            jEWTDialog.setContent((Component)modelGLMBuildRideRegressPanel);
            jEWTDialog.setTitle(this.getDialogTitle());
            return jEWTDialog;
        }

        private String getDialogTitle() {
            return AlgSettingsLrb.get("GLM_RIDGE_REGRESSION_OPTION_DIALOG_TITLE");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean invoke() {
            boolean bl = false;
            try {
                JEWTDialog jEWTDialog = this.buildDialog();
                jEWTDialog.setResizable(true);
                final ModelGLMBuildRideRegressPanel modelGLMBuildRideRegressPanel = (ModelGLMBuildRideRegressPanel)jEWTDialog.getContent();
                jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                    @Override
                    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                        String string = propertyChangeEvent.getPropertyName();
                        Object object = propertyChangeEvent.getNewValue();
                        if (string.equals("closed") && Boolean.TRUE.equals(object) && !modelGLMBuildRideRegressPanel.doWork()) {
                            throw new PropertyVetoException("panel", propertyChangeEvent);
                        }
                    }
                });
                if (jEWTDialog != null) {
                    bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)AlgSettingsLrb.get("GLM_RIDGE_REGRESSION_OPTION_DIALOG_TITLE"), (String)AlgSettingsLrb.get("GLM_RIDGE_REGRESSION_OPTION_DIALOG_FAIL_MSG"), null);
            }
            finally {
                if (!bl) {
                    this.cancel();
                }
            }
            return bl;
        }

        protected void cancel() {
        }
    }

    class ReferenceClassDialog {
        protected String wizName = "Reference value in a logistic regression model";

        protected JEWTDialog buildDialog() {
            GLMTargetValuesPanel gLMTargetValuesPanel = new GLMTargetValuesPanel(ModelGLMBuildSettingsPanel.this.getPanelState());
            IdeMainWindow ideMainWindow = Ide.getMainWindow();
            int n = 7;
            JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, this.wizName, n);
            jEWTDialog.setContent((Component)gLMTargetValuesPanel);
            jEWTDialog.setTitle(this.getDialogTitle());
            return jEWTDialog;
        }

        private String getDialogTitle() {
            return AlgSettingsLrb.get("GLMS_REFERENCE_CLASS_NAME_DIALOG_TITLE");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean invoke() {
            boolean bl = false;
            try {
                JEWTDialog jEWTDialog = this.buildDialog();
                jEWTDialog.setResizable(true);
                final GLMTargetValuesPanel gLMTargetValuesPanel = (GLMTargetValuesPanel)jEWTDialog.getContent();
                jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                    @Override
                    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                        String string = propertyChangeEvent.getPropertyName();
                        Object object = propertyChangeEvent.getNewValue();
                        if (string.equals("closed") && Boolean.TRUE.equals(object) && !gLMTargetValuesPanel.doWork()) {
                            throw new PropertyVetoException("panel", propertyChangeEvent);
                        }
                    }
                });
                if (jEWTDialog != null) {
                    bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)AlgSettingsLrb.get("GLMS_REFERENCE_CLASS_NAME_DIALOG_FAIL_TITLE"), (String)AlgSettingsLrb.get("GLMS_REFERENCE_CLASS_NAME_DIALOG_FAIL_MSG"), null);
            }
            finally {
                if (!bl) {
                    this.cancel();
                }
            }
            return bl;
        }

        protected void cancel() {
        }
    }
}

