/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AbstractPropertiesPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.Version;

public class ModelKMBuildSettingsPanel
extends AbstractPropertiesPanel {
    private JLabel jAttributeSupportLabel;
    private JTextField jAttributeSupportTextField;
    private JLabel jConvergenceLabel;
    private JTextField jConvergenceTextField;
    private JComboBox jDistanceComboBox;
    private JLabel jDistanceLabel;
    private JLabel jGrowthFactorLabel;
    private JTextField jGrowthFactorTextField;
    private JLabel jHistogramBinsLabel;
    private JTextField jHistogramBinsTextField;
    private JLabel jIterationsLabel;
    private JTextField jIterationsTextField;
    private JLabel jNumClustersLabel;
    private JTextField jNumClustersTextField;
    private JScrollPane jScrollPaneTitle;
    private JComboBox jSplitCriterionComboBox;
    private JLabel jSplitCriterionLabel;
    private JMultiLineLabel _jDescription = new JMultiLineLabel();
    private DefaultComboBoxModel _distanceModel;
    private String _currentDistanceValue;
    private DefaultComboBoxModel _criterionModel;
    private String _currentCriterionValue;

    public ModelKMBuildSettingsPanel(AdvancedSettingsPanel advancedSettingsPanel, ModelType modelType) {
        super(advancedSettingsPanel, modelType);
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        this.jScrollPaneTitle = new JScrollPane();
        this.jNumClustersLabel = new JLabel();
        this.jNumClustersTextField = new NumberTextField();
        this.jGrowthFactorLabel = new JLabel();
        this.jGrowthFactorTextField = new NumberTextField();
        this.jConvergenceLabel = new JLabel();
        this.jConvergenceTextField = new NumberTextField();
        this.jDistanceLabel = new JLabel();
        this.jDistanceComboBox = new JComboBox();
        this.jIterationsLabel = new JLabel();
        this.jIterationsTextField = new NumberTextField();
        this.jAttributeSupportLabel = new JLabel();
        this.jAttributeSupportTextField = new NumberTextField();
        this.jHistogramBinsLabel = new JLabel();
        this.jHistogramBinsTextField = new NumberTextField();
        this.jSplitCriterionLabel = new JLabel();
        this.jSplitCriterionComboBox = new JComboBox();
        this.jScrollPaneTitle.setBorder(null);
        this.jScrollPaneTitle.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneTitle.setVerticalScrollBarPolicy(21);
        this.jScrollPaneTitle.setName("jScrollPaneTitle");
        this.jNumClustersLabel.setLabelFor(this.jNumClustersTextField);
        this.jNumClustersLabel.setText("Number of Clusters:");
        this.jNumClustersLabel.setName("jNumClustersLabel");
        this.jNumClustersTextField.setName("jNumClustersTextField");
        this.jGrowthFactorLabel.setLabelFor(this.jGrowthFactorTextField);
        this.jGrowthFactorLabel.setText("Growth Factor:");
        this.jGrowthFactorLabel.setName("jGrowthFactorLabel");
        this.jGrowthFactorTextField.setName("jGrowthFactorTextField");
        this.jConvergenceLabel.setLabelFor(this.jConvergenceTextField);
        this.jConvergenceLabel.setText("Convergence Tolerance:");
        this.jConvergenceLabel.setName("jConvergenceLabel");
        this.jConvergenceTextField.setName("jConvergenceTextField");
        this.jDistanceLabel.setLabelFor(this.jDistanceComboBox);
        this.jDistanceLabel.setText("Distance Function:");
        this.jDistanceLabel.setName("jDistanceLabel");
        this.jDistanceComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"FAST COSINE", "EUCLIDEAN", "COSINE"}));
        this.jDistanceComboBox.setName("jDistanceComboBox");
        this.jIterationsLabel.setLabelFor(this.jIterationsTextField);
        this.jIterationsLabel.setText("Number of Iterations:");
        this.jIterationsLabel.setName("jIterationsLabel");
        this.jIterationsTextField.setName("jIterationsTextField");
        this.jAttributeSupportLabel.setLabelFor(this.jAttributeSupportTextField);
        this.jAttributeSupportLabel.setText("Min Percent Attribute Support:");
        this.jAttributeSupportLabel.setName("jAttributeSupportLabel");
        this.jAttributeSupportTextField.setName("jAttributeSupportTextField");
        this.jHistogramBinsLabel.setLabelFor(this.jHistogramBinsTextField);
        this.jHistogramBinsLabel.setText("Number of Histogram Bins:");
        this.jHistogramBinsLabel.setName("jHistogramBinsLabel");
        this.jHistogramBinsTextField.setName("jHistogramBinsTextField");
        this.jSplitCriterionLabel.setLabelFor(this.jSplitCriterionComboBox);
        this.jSplitCriterionLabel.setText("Split Criterion:");
        this.jSplitCriterionLabel.setName("jSplitCriterionLabel");
        this.jSplitCriterionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"VARIANCE", "SIZE"}));
        this.jSplitCriterionComboBox.setName("jSplitCriterionComboBox");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneTitle, -1, 446, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jAttributeSupportLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jGrowthFactorLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jNumClustersLabel, GroupLayout.Alignment.LEADING, -1, 147, Short.MAX_VALUE).addComponent(this.jConvergenceLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jDistanceLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jIterationsLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jHistogramBinsLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jSplitCriterionLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jAttributeSupportTextField).addComponent(this.jIterationsTextField).addComponent(this.jDistanceComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.jConvergenceTextField).addComponent(this.jGrowthFactorTextField).addComponent(this.jNumClustersTextField, -1, 129, Short.MAX_VALUE).addComponent(this.jHistogramBinsTextField).addComponent(this.jSplitCriterionComboBox, 0, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 166, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneTitle, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jNumClustersLabel).addComponent(this.jNumClustersTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jGrowthFactorLabel).addComponent(this.jGrowthFactorTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jConvergenceLabel).addComponent(this.jConvergenceTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jDistanceLabel).addComponent(this.jDistanceComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jIterationsLabel).addComponent(this.jIterationsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jAttributeSupportLabel).addComponent(this.jAttributeSupportTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jHistogramBinsLabel).addComponent(this.jHistogramBinsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSplitCriterionLabel).addComponent(this.jSplitCriterionComboBox, -2, -1, -2)).addContainerGap(86, Short.MAX_VALUE)));
    }

    private void initUI() {
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        this.loadDescription(this._jDescription, this.jScrollPaneTitle);
        ResourceUtils.resLabel((JLabel)this.jNumClustersLabel, (Component)this.jNumClustersTextField, (String)AlgSettingsLrb.get("CLUS_NUM_CLUSTERS"));
        ResourceUtils.resLabel((JLabel)this.jGrowthFactorLabel, (Component)this.jGrowthFactorTextField, (String)AlgSettingsLrb.get("KMNS_BLOCK_GROWTH"));
        ResourceUtils.resLabel((JLabel)this.jConvergenceLabel, (Component)this.jConvergenceTextField, (String)AlgSettingsLrb.get("KMNS_CONV_TOLERANCE"));
        ResourceUtils.resLabel((JLabel)this.jDistanceLabel, (Component)this.jDistanceComboBox, (String)AlgSettingsLrb.get("KMNS_DISTANCE"));
        ResourceUtils.resLabel((JLabel)this.jIterationsLabel, (Component)this.jIterationsTextField, (String)AlgSettingsLrb.get("KMNS_ITERATIONS"));
        ResourceUtils.resLabel((JLabel)this.jAttributeSupportLabel, (Component)this.jAttributeSupportTextField, (String)AlgSettingsLrb.get("KMNS_MIN_PCT_ATTR_SUPPORT"));
        ResourceUtils.resLabel((JLabel)this.jHistogramBinsLabel, (Component)this.jHistogramBinsTextField, (String)AlgSettingsLrb.get("KMNS_NUM_BINS"));
        ResourceUtils.resLabel((JLabel)this.jSplitCriterionLabel, (Component)this.jSplitCriterionComboBox, (String)AlgSettingsLrb.get("KMNS_SPLIT_CRITERION"));
        this.jNumClustersTextField.setToolTipText(AlgSettingsLrb.get("CLUS_NUM_CLUSTERS_TOOLTIP"));
        this.setDataType(this.jNumClustersTextField, Integer.class);
        this.setSigned(this.jNumClustersTextField, false);
        this.setLocale(this.jNumClustersTextField, commonSettingDataObject.getLocale());
        BigDecimal bigDecimal = commonSettingDataObject.getModelSettingNumValue("CLUS_NUM_CLUSTERS");
        commonSettingDataObject.setBackupValue("CLUS_NUM_CLUSTERS", bigDecimal);
        this.setNumber(this.jNumClustersTextField, bigDecimal);
        this.jGrowthFactorTextField.setToolTipText(AlgSettingsLrb.get("KMNS_BLOCK_GROWTH_TIP"));
        this.setDataType(this.jGrowthFactorTextField, Integer.class);
        this.setSigned(this.jGrowthFactorTextField, false);
        this.setLocale(this.jGrowthFactorTextField, commonSettingDataObject.getLocale());
        BigDecimal bigDecimal2 = commonSettingDataObject.getModelSettingNumValue("KMNS_BLOCK_GROWTH");
        commonSettingDataObject.setBackupValue("KMNS_BLOCK_GROWTH", bigDecimal2);
        this.setNumber(this.jGrowthFactorTextField, bigDecimal2);
        this.jConvergenceTextField.setToolTipText(AlgSettingsLrb.get("KMNS_CONV_TOLERANCE_TIP"));
        this.setDataType(this.jConvergenceTextField, Double.class);
        ((NumberTextField)this.jConvergenceTextField).setDecimal(true, 4);
        this.setSigned(this.jConvergenceTextField, false);
        this.setLocale(this.jConvergenceTextField, commonSettingDataObject.getLocale());
        BigDecimal bigDecimal3 = commonSettingDataObject.getModelSettingNumValue("KMNS_CONV_TOLERANCE");
        commonSettingDataObject.setBackupValue("KMNS_CONV_TOLERANCE", bigDecimal3);
        this.setNumber(this.jConvergenceTextField, bigDecimal3);
        this._distanceModel = new DefaultComboBoxModel<String>(new String[]{ServerConstants.ClusteringSetings.toHuman("KMNS_EUCLIDEAN"), ServerConstants.ClusteringSetings.toHuman("KMNS_COSINE"), ServerConstants.ClusteringSetings.toHuman("KMNS_FAST_COSINE")});
        this.jDistanceComboBox.setModel(this._distanceModel);
        this._currentDistanceValue = commonSettingDataObject.getModelSettingStringValue("KMNS_DISTANCE");
        this.jDistanceComboBox.setSelectedItem(ServerConstants.ClusteringSetings.toHuman(this._currentDistanceValue));
        commonSettingDataObject.setBackupValue("KMNS_DISTANCE", this._currentDistanceValue);
        this.jDistanceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelKMBuildSettingsPanel.this._currentDistanceValue = ServerConstants.ClusteringSetings.toAlgorithm((String)ModelKMBuildSettingsPanel.this.jDistanceComboBox.getSelectedItem());
            }
        });
        this.jAttributeSupportTextField.setToolTipText(AlgSettingsLrb.get("KMNS_MIN_PCT_ATTR_SUPPORT_TIP"));
        this.setDataType(this.jAttributeSupportTextField, Double.class);
        ((NumberTextField)this.jAttributeSupportTextField).setDecimal(true, 4);
        this.setSigned(this.jAttributeSupportTextField, false);
        this.setLocale(this.jAttributeSupportTextField, commonSettingDataObject.getLocale());
        BigDecimal bigDecimal4 = commonSettingDataObject.getModelSettingNumValue("KMNS_MIN_PCT_ATTR_SUPPORT");
        commonSettingDataObject.setBackupValue("KMNS_MIN_PCT_ATTR_SUPPORT", bigDecimal4);
        this.setNumber(this.jAttributeSupportTextField, bigDecimal4);
        this.jIterationsTextField.setToolTipText(AlgSettingsLrb.get("KMNS_ITERATIONS_TIP"));
        this.setDataType(this.jIterationsTextField, Integer.class);
        this.setSigned(this.jIterationsTextField, false);
        this.setLocale(this.jIterationsTextField, commonSettingDataObject.getLocale());
        BigDecimal bigDecimal5 = commonSettingDataObject.getModelSettingNumValue("KMNS_ITERATIONS");
        commonSettingDataObject.setBackupValue("KMNS_ITERATIONS", bigDecimal5);
        this.setNumber(this.jIterationsTextField, bigDecimal5);
        this.jHistogramBinsTextField.setToolTipText(AlgSettingsLrb.get("KMNS_NUM_BINS_TIP"));
        this.setDataType(this.jHistogramBinsTextField, Integer.class);
        this.setSigned(this.jHistogramBinsTextField, false);
        this.setLocale(this.jHistogramBinsTextField, commonSettingDataObject.getLocale());
        BigDecimal bigDecimal6 = commonSettingDataObject.getModelSettingNumValue("KMNS_NUM_BINS");
        commonSettingDataObject.setBackupValue("KMNS_NUM_BINS", bigDecimal6);
        this.setNumber(this.jHistogramBinsTextField, bigDecimal6);
        this._criterionModel = new DefaultComboBoxModel<String>(new String[]{ServerConstants.ClusteringSetings.toHuman("KMNS_SIZE"), ServerConstants.ClusteringSetings.toHuman("KMNS_VARIANCE")});
        this.jSplitCriterionComboBox.setModel(this._criterionModel);
        this._currentCriterionValue = commonSettingDataObject.getModelSettingStringValue("KMNS_SPLIT_CRITERION");
        this.jSplitCriterionComboBox.setSelectedItem(ServerConstants.ClusteringSetings.toHuman(this._currentCriterionValue));
        commonSettingDataObject.setBackupValue("KMNS_SPLIT_CRITERION", this._currentCriterionValue);
        this.jSplitCriterionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelKMBuildSettingsPanel.this._currentCriterionValue = ServerConstants.ClusteringSetings.toAlgorithm((String)ModelKMBuildSettingsPanel.this.jSplitCriterionComboBox.getSelectedItem());
            }
        });
    }

    @Override
    public void processInput() {
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        this.setObjectValue("KMNS_DISTANCE", this._currentDistanceValue);
        this.setObjectValue("KMNS_SPLIT_CRITERION", this._currentCriterionValue);
        Number number = this.getNumber(this.jNumClustersTextField);
        if (null == number || 1 > number.intValue()) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("CLUS_NUM_CLUSTERS_INVALID"));
            return;
        }
        this.setObjectValue("CLUS_NUM_CLUSTERS", number);
        number = this.getNumber(this.jGrowthFactorTextField);
        if (null == number || 1 >= number.intValue() || number.intValue() > 5) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("KMNS_BLOCK_GROWTH_INVALID"));
            return;
        }
        this.setObjectValue("KMNS_BLOCK_GROWTH", number);
        number = this.getNumber(this.jConvergenceTextField);
        if (null == number || !(0.0 < number.doubleValue()) || !(number.doubleValue() <= 0.5)) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("KMNS_CONV_TOLERANCE_INVALID"));
            return;
        }
        this.setObjectValue("KMNS_CONV_TOLERANCE", number);
        number = this.getNumber(this.jAttributeSupportTextField);
        if (null == number || !(0.0 <= number.doubleValue()) || !(number.doubleValue() <= 1.0)) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("KMNS_MIN_PCT_ATTR_SUPPORT_INVALID"));
            return;
        }
        this.setObjectValue("KMNS_MIN_PCT_ATTR_SUPPORT", number);
        number = this.getNumber(this.jIterationsTextField);
        int n = 20;
        String string = "KMNS_ITERATIONS_INVALID";
        try {
            Version version = ConfigUtils.getDatabaseVersion(this.getParentPanel().getContext());
            if (ConfigUtils.isDatabaseVersion(DBVersions.V11_2_0_4, version, true)) {
                n = Integer.MAX_VALUE;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
        if (null == number || 0 >= number.intValue() || number.intValue() > n) {
            string = StringUtils.getReplacedString(string, "<INTEGER_MAX_VALUE>", String.valueOf(n));
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("KMNS_ITERATIONS_INVALID"));
            return;
        }
        this.setObjectValue("KMNS_ITERATIONS", number);
        number = this.getNumber(this.jHistogramBinsTextField);
        if (null == number || 0 >= number.intValue()) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("KMNS_NUM_BINS_INVALID"));
            return;
        }
        this.setObjectValue("KMNS_NUM_BINS", number);
    }
}

