/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.controls.NameValuePair;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AbstractPropertiesPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.CSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.util.ResourceUtils;

public class ModelSVCBuildSettingsPanel
extends AbstractPropertiesPanel {
    private JCheckBox jCheckBoxActiveLearning;
    private JCheckBox jCheckBoxComplexityFactors;
    private JCheckBox jCheckBoxEpsilonFactors;
    private JCheckBox jCheckBoxStdDev;
    private JComboBox jComboBoxKernerFunction;
    private JLabel jLabelCacheSize;
    private JLabel jLabelKernelFunction;
    private JLabel jLabelToleranceValue;
    private JScrollPane jScrollPaneTitle;
    private JTextField jTextFieldCacheSize;
    private JTextField jTextFieldComplexityFactors;
    private JTextField jTextFieldEpsilonFactors;
    private JTextField jTextFieldStdDev;
    private JTextField jTextFieldToleranceValue;
    private JMultiLineLabel _jDescription = new JMultiLineLabel();
    private DefaultComboBoxModel _kernelFunctionsModel;
    private String _currentKernelFunctionName;
    private static final String CLIENT_SVM_LINEAR = AlgSettingsLrb.get("SVMS_LINEAR");
    private static final String CLIENT_SVM_GAUSSIAN = AlgSettingsLrb.get("SVMS_GAUSSIAN");
    private static final String CLIENT_SVMS_SYSTEM_DEFAULT = AlgSettingsLrb.get("SVMS_SYSTEM_DEFAULT");

    public ModelSVCBuildSettingsPanel(AdvancedSettingsPanel advancedSettingsPanel, ModelType modelType) {
        super(advancedSettingsPanel, modelType);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jCheckBoxComplexityFactors = new JCheckBox();
        this.jLabelToleranceValue = new JLabel();
        this.jCheckBoxStdDev = new JCheckBox();
        this.jTextFieldToleranceValue = new NumberTextField();
        this.jTextFieldStdDev = new NumberTextField();
        this.jLabelKernelFunction = new JLabel();
        this.jLabelCacheSize = new JLabel();
        this.jComboBoxKernerFunction = new JComboBox();
        this.jTextFieldCacheSize = new NumberTextField();
        this.jScrollPaneTitle = new JScrollPane();
        this.jCheckBoxEpsilonFactors = new JCheckBox();
        this.jTextFieldEpsilonFactors = new NumberTextField();
        this.jCheckBoxActiveLearning = new JCheckBox();
        this.jTextFieldComplexityFactors = new NumberTextField();
        this.jCheckBoxComplexityFactors.setText("Specify the complexity factors");
        this.jCheckBoxComplexityFactors.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxComplexityFactors.setMargin(new Insets(0, 0, 0, 0));
        this.jLabelToleranceValue.setText("Tolerance Value:");
        this.jCheckBoxStdDev.setText("Specify the standard deviation for gaussian kernel");
        this.jCheckBoxStdDev.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxStdDev.setMargin(new Insets(0, 0, 0, 0));
        this.jTextFieldToleranceValue.setToolTipText("Range: > 0 and <= 0.01");
        this.jTextFieldStdDev.setToolTipText("Range: > 0");
        this.jLabelKernelFunction.setText("Kernel Function");
        this.jLabelCacheSize.setText("Cache Size:");
        this.jComboBoxKernerFunction.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxKernerFunction.setInheritsPopupMenu(true);
        this.jComboBoxKernerFunction.setMinimumSize(new Dimension(58, 18));
        this.jComboBoxKernerFunction.setOpaque(false);
        this.jComboBoxKernerFunction.setPreferredSize(new Dimension(62, 22));
        this.jTextFieldCacheSize.setToolTipText("Range: > 0");
        this.jScrollPaneTitle.setBorder(null);
        this.jScrollPaneTitle.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneTitle.setVerticalScrollBarPolicy(21);
        this.jCheckBoxEpsilonFactors.setText("Specify epsilon factor ");
        this.jCheckBoxEpsilonFactors.setToolTipText("Value of epsilon factor for SVM regression. Default value estimated from the data by the algorithm.SVMS_EPSILON =  TO_CHAR(numeric_expr >0)");
        this.jCheckBoxEpsilonFactors.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxEpsilonFactors.setMargin(new Insets(0, 0, 0, 0));
        this.jTextFieldEpsilonFactors.setToolTipText("Range: > 0");
        this.jCheckBoxActiveLearning.setText("Active Learning");
        this.jCheckBoxActiveLearning.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxActiveLearning.setMargin(new Insets(0, 0, 0, 0));
        this.jTextFieldComplexityFactors.setToolTipText("Range: > 0");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(19, 19, 19).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelKernelFunction, -2, 98, -2).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelToleranceValue, -2, 106, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldToleranceValue, -2, 80, -2).addComponent(this.jComboBoxKernerFunction, -2, 160, -2))).addComponent(this.jCheckBoxComplexityFactors, -2, 181, -2).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.jTextFieldComplexityFactors, -2, 83, -2)).addComponent(this.jCheckBoxActiveLearning).addComponent(this.jLabelCacheSize, -2, 78, -2).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldCacheSize, -2, 80, -2).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.jTextFieldStdDev, -2, 74, -2))).addComponent(this.jCheckBoxStdDev).addComponent(this.jCheckBoxEpsilonFactors, -2, 181, -2).addComponent(this.jTextFieldEpsilonFactors, -2, 83, -2)))).addGap(198, 198, 198)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneTitle).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneTitle, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelKernelFunction).addComponent(this.jComboBoxKernerFunction, -2, -1, -2)).addGap(13, 13, 13).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelToleranceValue).addComponent(this.jTextFieldToleranceValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxComplexityFactors).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldComplexityFactors, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jCheckBoxEpsilonFactors).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldEpsilonFactors, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxActiveLearning).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxStdDev).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldStdDev, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelCacheSize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldCacheSize, -2, -1, -2).addContainerGap(37, Short.MAX_VALUE)));
    }

    private static String convertToServerKernelFunctionName(String string) {
        assert (string != null);
        if (0 == string.compareTo(CLIENT_SVM_GAUSSIAN)) {
            return "SVMS_GAUSSIAN";
        }
        if (0 == string.compareTo(CLIENT_SVM_LINEAR)) {
            return "SVMS_LINEAR";
        }
        return "SVMS_SYSTEM_DETERMINED";
    }

    private void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLabelKernelFunction, (Component)this.jComboBoxKernerFunction, (String)AlgSettingsLrb.get("MODEL_SETTINGS_KERNEL_FUNCTION"));
        ResourceUtils.resLabel((JLabel)this.jLabelToleranceValue, (Component)this.jTextFieldToleranceValue, (String)AlgSettingsLrb.get("MODEL_SETTINGS_TOLERANCE_VALUE"));
        ResourceUtils.resButton((AbstractButton)this.jCheckBoxComplexityFactors, (String)AlgSettingsLrb.get("MODEL_SETTINGS_COMPLEXITY_FACTOR"));
        ResourceUtils.resButton((AbstractButton)this.jCheckBoxEpsilonFactors, (String)AlgSettingsLrb.get("MODEL_SETTINGS_EPSILON_FACTOR"));
        ResourceUtils.resButton((AbstractButton)this.jCheckBoxActiveLearning, (String)AlgSettingsLrb.get("MODEL_SETTINGS_ACTIVE_LEARNING"));
        ResourceUtils.resButton((AbstractButton)this.jCheckBoxStdDev, (String)AlgSettingsLrb.get("MODEL_SETTINGS_CHK_BOX_STDEV"));
        ResourceUtils.resLabel((JLabel)this.jLabelCacheSize, (Component)this.jTextFieldCacheSize, (String)AlgSettingsLrb.get("MODEL_SETTINGS_CACHE_SIZE"));
        this.jTextFieldComplexityFactors.setToolTipText(AlgSettingsLrb.get("SVMS_CONV_POSITIVE_VALUE_TOOLTIP"));
        this.jTextFieldStdDev.setToolTipText(AlgSettingsLrb.get("SVMS_CONV_POSITIVE_VALUE_TOOLTIP"));
        this.jTextFieldCacheSize.setToolTipText(AlgSettingsLrb.get("SVMS_CONV_POSITIVE_VALUE_TOOLTIP"));
    }

    private void initUI() {
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        this.loadDescription(this._jDescription, this.jScrollPaneTitle);
        this.setDataType(this.jTextFieldToleranceValue, Double.class);
        ((NumberTextField)this.jTextFieldToleranceValue).setDecimal(true, 4);
        this.setDataType(this.jTextFieldComplexityFactors, Double.class);
        ((NumberTextField)this.jTextFieldComplexityFactors).setDecimal(true, 4);
        this.setDataType(this.jTextFieldEpsilonFactors, Double.class);
        ((NumberTextField)this.jTextFieldEpsilonFactors).setDecimal(true, 4);
        this.setDataType(this.jTextFieldStdDev, Double.class);
        ((NumberTextField)this.jTextFieldStdDev).setDecimal(true, 4);
        this.setDataType(this.jTextFieldCacheSize, Long.class);
        this.setSigned(this.jTextFieldToleranceValue, false);
        this.setSigned(this.jTextFieldComplexityFactors, false);
        this.setSigned(this.jTextFieldEpsilonFactors, false);
        this.setSigned(this.jTextFieldStdDev, false);
        this.setSigned(this.jTextFieldCacheSize, false);
        this.setLocale(this.jTextFieldToleranceValue, commonSettingDataObject.getLocale());
        this.setLocale(this.jTextFieldComplexityFactors, commonSettingDataObject.getLocale());
        this.setSigned(this.jTextFieldEpsilonFactors, false);
        this.setLocale(this.jTextFieldStdDev, commonSettingDataObject.getLocale());
        this.setLocale(this.jTextFieldCacheSize, commonSettingDataObject.getLocale());
        this._kernelFunctionsModel = new DefaultComboBoxModel<String>(new String[]{CLIENT_SVMS_SYSTEM_DEFAULT, CLIENT_SVM_GAUSSIAN, CLIENT_SVM_LINEAR});
        this.jComboBoxKernerFunction.setModel(this._kernelFunctionsModel);
        String string = commonSettingDataObject.getModelSettingStringValue("SVMS_KERNEL_FUNCTION");
        if (string == null) {
            string = "SVMS_SYSTEM_DETERMINED";
        }
        this._currentKernelFunctionName = this.convertToClientKernelFunctionName(string);
        commonSettingDataObject.setBackupValue("SVMS_KERNEL_FUNCTION", ModelSVCBuildSettingsPanel.convertToServerKernelFunctionName(this._currentKernelFunctionName));
        this.jComboBoxKernerFunction.setSelectedItem(this._currentKernelFunctionName);
        this.jComboBoxKernerFunction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)ModelSVCBuildSettingsPanel.this.jComboBoxKernerFunction.getSelectedItem();
                if (string.equals(ModelSVCBuildSettingsPanel.this._currentKernelFunctionName)) {
                    return;
                }
                ModelSVCBuildSettingsPanel.this._currentKernelFunctionName = string;
                ModelSVCBuildSettingsPanel.this.updatePanel();
            }
        });
        BigDecimal bigDecimal = commonSettingDataObject.getModelSettingNumValue("SVMS_CONV_TOLERANCE");
        if (bigDecimal != null) {
            commonSettingDataObject.setBackupValue("SVMS_CONV_TOLERANCE", bigDecimal.doubleValue());
        } else {
            commonSettingDataObject.setBackupNullValue("SVMS_CONV_TOLERANCE");
        }
        this.setNumber(this.jTextFieldToleranceValue, bigDecimal);
        this.jTextFieldToleranceValue.setToolTipText(AlgSettingsLrb.get("SVMS_CONV_TOLERANCE_TOOLTIP"));
        BigDecimal bigDecimal2 = commonSettingDataObject.getModelSettingNumValue("SVMS_COMPLEXITY_FACTOR");
        if (bigDecimal2 == null || 0 == bigDecimal2.compareTo(BigDecimal.ZERO)) {
            this.jCheckBoxComplexityFactors.setSelected(false);
            this.jTextFieldComplexityFactors.setEnabled(false);
            commonSettingDataObject.setBackupNullValue("SVMS_COMPLEXITY_FACTOR");
        } else {
            commonSettingDataObject.setBackupValue("SVMS_COMPLEXITY_FACTOR", bigDecimal2);
            this.jCheckBoxComplexityFactors.setSelected(true);
            this.setNumber(this.jTextFieldComplexityFactors, bigDecimal2);
            this.jTextFieldComplexityFactors.setToolTipText(AlgSettingsLrb.get("SVMS_CONV_POSITIVE_VALUE_TOOLTIP"));
        }
        this.jCheckBoxComplexityFactors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object instanceof JCheckBox) {
                    JCheckBox jCheckBox = (JCheckBox)object;
                    ModelSVCBuildSettingsPanel.this.jTextFieldComplexityFactors.setEnabled(jCheckBox.isSelected());
                }
            }
        });
        BigDecimal bigDecimal3 = commonSettingDataObject.getModelSettingNumValue("SVMS_EPSILON");
        if (bigDecimal3 == null || 0 == bigDecimal3.compareTo(BigDecimal.ZERO)) {
            this.jCheckBoxEpsilonFactors.setSelected(false);
            this.jTextFieldEpsilonFactors.setEnabled(false);
            commonSettingDataObject.setBackupNullValue("SVMS_EPSILON");
        } else {
            commonSettingDataObject.setBackupValue("SVMS_EPSILON", bigDecimal3);
            this.jCheckBoxEpsilonFactors.setSelected(true);
            this.setNumber(this.jTextFieldEpsilonFactors, bigDecimal3);
            this.jTextFieldEpsilonFactors.setToolTipText(DialogsLrb.get("SVMS_CONV_POSITIVE_VALUE_TOOLTIP"));
        }
        this.jCheckBoxEpsilonFactors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object instanceof JCheckBox) {
                    JCheckBox jCheckBox = (JCheckBox)object;
                    ModelSVCBuildSettingsPanel.this.jTextFieldEpsilonFactors.setEnabled(jCheckBox.isSelected());
                }
            }
        });
        String string2 = commonSettingDataObject.getModelSettingStringValue("SVMS_ACTIVE_LEARNING");
        string2 = string2 != null ? string2 : "SVMS_AL_DISABLE";
        commonSettingDataObject.setBackupValue("SVMS_ACTIVE_LEARNING", string2);
        this.jCheckBoxActiveLearning.setSelected(string2.equals("SVMS_AL_ENABLE"));
        BigDecimal bigDecimal4 = commonSettingDataObject.getModelSettingNumValue("SVMS_STD_DEV");
        if (bigDecimal4 == null || 0 == bigDecimal4.compareTo(BigDecimal.ZERO)) {
            commonSettingDataObject.setBackupNullValue("SVMS_STD_DEV");
            this.jCheckBoxStdDev.setSelected(false);
            this.jTextFieldStdDev.setEnabled(false);
        } else {
            commonSettingDataObject.setBackupValue("SVMS_STD_DEV", bigDecimal4);
            this.jCheckBoxStdDev.setSelected(true);
            this.setNumber(this.jTextFieldStdDev, bigDecimal4);
            this.jTextFieldStdDev.setToolTipText(AlgSettingsLrb.get("SVMS_CONV_POSITIVE_VALUE_TOOLTIP"));
        }
        this.jCheckBoxStdDev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object instanceof JCheckBox) {
                    JCheckBox jCheckBox = (JCheckBox)object;
                    ModelSVCBuildSettingsPanel.this.jTextFieldStdDev.setEnabled(jCheckBox.isSelected());
                }
            }
        });
        Number number = commonSettingDataObject.getModelSettingNumValue("SVMS_KERNEL_CACHE_SIZE");
        if (null == number || ((Number)number).longValue() == 0L) {
            number = ServerConstants.SVMSettings.SVMS_KERNEL_CACHE_SIZE_DEFAULT;
        }
        commonSettingDataObject.setBackupValue("SVMS_KERNEL_CACHE_SIZE", number);
        this.setNumber(this.jTextFieldCacheSize, number);
        this.jTextFieldCacheSize.setToolTipText(AlgSettingsLrb.get("SVMS_CONV_POSITIVE_VALUE_TOOLTIP"));
        this.updatePanel();
    }

    private String convertToClientKernelFunctionName(String string) {
        if (string != null) {
            if (0 == string.compareTo("SVMS_GAUSSIAN")) {
                return CLIENT_SVM_GAUSSIAN;
            }
            if (0 == string.compareTo("SVMS_LINEAR")) {
                return CLIENT_SVM_LINEAR;
            }
        }
        return CLIENT_SVMS_SYSTEM_DEFAULT;
    }

    private void updatePanel() {
        boolean bl = this.isGaussian();
        this.jCheckBoxStdDev.setVisible(bl);
        this.jTextFieldStdDev.setVisible(bl);
        this.jLabelCacheSize.setVisible(bl);
        this.jTextFieldCacheSize.setVisible(bl);
        ModelType modelType = this.getModelType();
        if (modelType instanceof CSupportVectorMachineModelType) {
            this.jTextFieldEpsilonFactors.setVisible(false);
            this.jCheckBoxEpsilonFactors.setVisible(false);
        }
        this.repaint();
    }

    private boolean isGaussian() {
        boolean bl = false;
        if (this._currentKernelFunctionName != null) {
            bl = this._currentKernelFunctionName.equals(CLIENT_SVM_GAUSSIAN);
        }
        return bl;
    }

    @Override
    public void processInput() {
        Number number;
        Number number2;
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        commonSettingDataObject.setCommonPerformanceOption();
        this.setObjectValue("SVMS_KERNEL_FUNCTION", ModelSVCBuildSettingsPanel.convertToServerKernelFunctionName(this._currentKernelFunctionName));
        Number number3 = this.getNumber(this.jTextFieldToleranceValue);
        if (null == number3 || number3.doubleValue() <= 0.0 || number3.doubleValue() > 0.01) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("SVMS_CONV_TOLERANCE_OUT_OF_RANGE"));
            return;
        }
        this.setObjectValue("SVMS_CONV_TOLERANCE", new Double(number3.toString()));
        if (this.jCheckBoxComplexityFactors.isSelected()) {
            number2 = this.getNumber(this.jTextFieldComplexityFactors);
            if (null == number2 || number2.doubleValue() <= 0.0) {
                this.setValidationErrorObjectValue(AlgSettingsLrb.get("SVMS_COMPLEXITY_FACTOR_NULL"));
                return;
            }
            this.setObjectValue("SVMS_COMPLEXITY_FACTOR", number2);
        } else {
            this.setNullObjectValue("SVMS_COMPLEXITY_FACTOR");
        }
        if (this.jCheckBoxEpsilonFactors.isSelected()) {
            number2 = this.getNumber(this.jTextFieldEpsilonFactors);
            if (null == number2 || number2.doubleValue() <= 0.0) {
                this.setValidationErrorObjectValue(DialogsLrb.get("SVMS_EPSILON_FACTOR_NULL"));
                return;
            }
            this.setObjectValue("SVMS_EPSILON", number2);
        } else {
            this.setNullObjectValue("SVMS_EPSILON");
        }
        this.setObjectValue("SVMS_ACTIVE_LEARNING", this.jCheckBoxActiveLearning.isSelected() ? "SVMS_AL_ENABLE" : "SVMS_AL_DISABLE");
        boolean bl = this.isGaussian();
        if (!bl) {
            commonSettingDataObject.removeValue("SVMS_STD_DEV");
            commonSettingDataObject.removeValue("SVMS_KERNEL_CACHE_SIZE");
            return;
        }
        if (this.jCheckBoxStdDev.isSelected()) {
            number = this.getNumber(this.jTextFieldStdDev);
            if (null == number || number.doubleValue() <= 0.0) {
                this.setValidationErrorObjectValue(AlgSettingsLrb.get("SVMS_COMPLEXITY_STD_DEV_NULL"));
                return;
            }
            this.setObjectValue("SVMS_STD_DEV", number);
        } else {
            this.setNullObjectValue("SVMS_STD_DEV");
        }
        number = this.getNumber(this.jTextFieldCacheSize);
        if (null == number || number.doubleValue() <= 0.0) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("SVMS_COMPLEXITY_CACHE_SIZE_NULL"));
            return;
        }
        this.setObjectValue("SVMS_KERNEL_CACHE_SIZE", number);
    }

    public void getIgnoredSettingsList() {
    }

    public boolean isNewDataInput(boolean bl) throws ValidationException {
        String string;
        Number number = this.getNumber(this.jTextFieldToleranceValue);
        if (null == number || number.doubleValue() < 0.0 || number.doubleValue() > 0.01) {
            throw new ValidationException(AlgSettingsLrb.get("SVMS_CONV_TOLERANCE_OUT_OF_RANGE"));
        }
        Number number2 = null;
        if (this.jCheckBoxComplexityFactors.isSelected() && null == (number2 = this.getNumber(this.jTextFieldComplexityFactors))) {
            throw new ValidationException(AlgSettingsLrb.get("SVMS_COMPLEXITY_FACTOR_NULL"));
        }
        Number number3 = null;
        if (this.jCheckBoxEpsilonFactors.isSelected() && null == (number3 = this.getNumber(this.jTextFieldEpsilonFactors))) {
            throw new ValidationException(DialogsLrb.get("SVMS_EPSILON_FACTOR_NULL"));
        }
        Number number4 = null;
        Number number5 = null;
        String string2 = null;
        if (this.jCheckBoxActiveLearning.isSelected()) {
            if (this.jCheckBoxStdDev.isSelected() && null == (number4 = this.getNumber(this.jTextFieldStdDev))) {
                throw new ValidationException(AlgSettingsLrb.get("SVMS_COMPLEXITY_STD_DEV_NULL"));
            }
            number5 = this.getNumber(this.jTextFieldCacheSize);
            if (null == number5) {
                throw new ValidationException(AlgSettingsLrb.get("SVMS_COMPLEXITY_CACHE_SIZE_NULL"));
            }
            string2 = "SVMS_AL_ENABLE";
        } else {
            string2 = "SVMS_AL_DISABLE";
        }
        if (!bl) {
            return bl;
        }
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        String string3 = (String)commonSettingDataObject.getBackupValue("SVMS_KERNEL_FUNCTION");
        if (0 != string3.compareTo(string = ModelSVCBuildSettingsPanel.convertToServerKernelFunctionName(this._currentKernelFunctionName))) {
            return true;
        }
        Double d = (Double)commonSettingDataObject.getBackupValue("SVMS_CONV_TOLERANCE");
        if (!NameValuePair.areEqual(number.doubleValue(), d)) {
            return true;
        }
        Object object = commonSettingDataObject.getBackupValue("SVMS_COMPLEXITY_FACTOR");
        if (!this.areEqual(object, number2)) {
            return true;
        }
        String string4 = (String)commonSettingDataObject.getBackupValue("SVMS_ACTIVE_LEARNING");
        if (0 != string2.compareTo(string4)) {
            return true;
        }
        Object object2 = null;
        Object object3 = null;
        if (string4.equals("SVMS_AL_ENABLE")) {
            object2 = commonSettingDataObject.getBackupValue("SVMS_STD_DEV");
            if (!this.areEqual(object2, number4)) {
                return true;
            }
            object3 = commonSettingDataObject.getBackupValue("SVMS_KERNEL_CACHE_SIZE");
            if (!this.areEqual(object3, number5)) {
                return true;
            }
        }
        return false;
    }

    private boolean areEqual(Object object, Number number) {
        return !(object instanceof BigDecimal ? !NameValuePair.areEqual(number.doubleValue(), ((BigDecimal)object).doubleValue()) : object instanceof String && number != null);
    }
}

