/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.buildText;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.applyText.ApplyTextPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.BuildTextPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.text.TextPanel;
import oracle.dmt.dataminer.workflow.model.AbstractTextNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNode;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.dmt.dataminer.workflow.xmlschema.TextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationOutputAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationTokenType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class BuildTextOutputPanel
extends JPanel {
    private static final Logger theLogger = Logger.getLogger(BuildTextOutputPanel.class.getName());
    private Context _context;
    private AbstractDialogPanel _parent;
    private StoplistType _stoplist;
    private List<AbstractTextNode.Statistics> _data;
    private TextNodeType _textNodeType;
    private Map<String, TokenInfo> _allTokens = new TreeMap<String, TokenInfo>();
    private TextTransformationOutputAttributeType _outputAttribute = null;
    private AttrsTableModel _models;
    private JButton _addBtn;
    private boolean _isReadOnly;
    private boolean _dirty;
    private DataMinerTablePanel dataMinerTablePanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private String[] _columnNames = new String[]{DialogsLrb.get("BUILDTEXT_COLUMN_ATTRIBUTE"), DialogsLrb.get("BUILDTEXT_COLUMN_DOC_FREQUENCY")};
    private static final int ATTRIBUTE = 0;
    private static final int FREQUENCY = 1;

    public BuildTextOutputPanel(Context context, AbstractTextNode abstractTextNode, TextNodeType textNodeType) {
        this._context = context;
        this._isReadOnly = !(abstractTextNode instanceof BuildTextNode);
        this._dirty = false;
        this._textNodeType = textNodeType;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void initUI() {
        if (!this._isReadOnly) {
            this.installItemFilterActions();
        }
        this._models = new AttrsTableModel(null);
        this.dataMinerTablePanel.setup((TableModel)((Object)this._models), null, 0, true);
        this.dataMinerTablePanel.getTable().setAutoResizeMode(4);
        this.dataMinerTablePanel.getTable().setSelectionMode(2);
        this.dataMinerTablePanel.getTable().setColumnSelectorAvailable(true);
        this.dataMinerTablePanel.getTable().setShowToolTips(true);
        this.dataMinerTablePanel.getTable().setUpdateSelectionOnSort(true);
        this.dataMinerTablePanel.getTable().setRowSelectionAllowed(true);
        this.dataMinerTablePanel.getTable().setSortColumn(1, false);
        this.dataMinerTablePanel.getTable().autoSizeColumnsToFit();
        this.dataMinerTablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                if (defaultListSelectionModel != null && defaultListSelectionModel.getValueIsAdjusting()) {
                    return;
                }
                BuildTextOutputPanel.this.enableControls();
            }
        });
        LoadUI loadUI = new LoadUI(this._outputAttribute);
        loadUI.execute();
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLabel1, (Component)this.jLabel2, (String)DialogsLrb.get("BUILDTEXT_STOPLIST"));
    }

    public synchronized void refreshUI(AbstractDialogPanel abstractDialogPanel, TextTransformationOutputAttributeType textTransformationOutputAttributeType) {
        this._parent = abstractDialogPanel;
        if (this._outputAttribute != null && this._outputAttribute.equals(textTransformationOutputAttributeType)) {
            return;
        }
        this._outputAttribute = textTransformationOutputAttributeType;
        this._data.add(new AbstractTextNode.Statistics(DialogsLrb.get("BUILDTEXT_LOADING"), null));
        this._models = new AttrsTableModel(this._data);
        this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)this._models));
        LoadUI loadUI = new LoadUI(this._outputAttribute);
        loadUI.execute();
    }

    private void enableControls() {
        if (!this._isReadOnly) {
            int n = this.dataMinerTablePanel.getTable().getSelectedRowCount();
            this._addBtn.setEnabled(n > 0 && this._stoplist != null);
        }
    }

    private void installItemFilterActions() {
        this._addBtn = new JButton(DialogsLrb.get("BUILDTEXT_ADD_TO_STOP_LIST"));
        this._addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = BuildTextOutputPanel.this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
                boolean bl = false;
                for (int n : nArray) {
                    AbstractTextNode.Statistics statistics = (AbstractTextNode.Statistics)BuildTextOutputPanel.this._data.get(n);
                    String string = BuildTextOutputPanel.this._stoplist.getLanguage();
                    string = "Multi".equals(string) ? "All" : string;
                    String string2 = BuildTextOutputPanel.this.isTokenTransformType() ? "Word" : "Theme";
                    String string3 = statistics.getToken();
                    String string4 = string + ":" + string2 + ":" + string3;
                    if (BuildTextOutputPanel.this._allTokens.containsKey(string4)) continue;
                    StoplistType.StopTokens.Token token = new StoplistType.StopTokens.Token();
                    token.setLanguage(string);
                    token.setType(string2);
                    token.setItem(string3);
                    BuildTextOutputPanel.this._stoplist.getStopTokens().getToken().add(token);
                    BuildTextOutputPanel.this._allTokens.put(string4, new TokenInfo(string, string2, string3));
                    bl = true;
                    BuildTextOutputPanel.this._dirty = true;
                }
                if (bl) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("BUILDTEXT_TOKENS_ADDED_TO_STOP_LIST"), (String)DialogsLrb.get("BUILD_TEXT_DIALOG_TITLE"), null);
                } else {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("BUILDTEXT_TOKENS_EXIST_IN_STOP_LIST"), (String)DialogsLrb.get("BUILD_TEXT_DIALOG_TITLE"), null);
                }
            }
        });
        this.dataMinerTablePanel.addControlBarComponents(this._addBtn);
    }

    private boolean isTokenTransformType() {
        TransformationTokenType transformationTokenType = this._outputAttribute.getTransformationElement().getToken();
        return transformationTokenType != null;
    }

    private boolean isThemeTransformType() {
        TextTransformationType.Theme theme = this._outputAttribute.getTransformationElement().getTheme();
        return theme != null;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.dataMinerTablePanel = new DataMinerTablePanel();
        this.setPreferredSize(new Dimension(620, 230));
        this.jLabel1.setText("Stoplist:");
        this.jLabel2.setText("English");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2, -2, 283, -2).addGap(0, 272, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataMinerTablePanel, -1, 188, Short.MAX_VALUE).addContainerGap()));
    }

    private class AttrsTableModel
    extends GenericBaseTableModel {
        private List<AbstractTextNode.Statistics> _data = null;

        public AttrsTableModel(List<AbstractTextNode.Statistics> list) {
            this._data = list;
            this.setColumnIdentifiers(BuildTextOutputPanel.this._columnNames);
            this.setRowCount(this.getRowCount());
        }

        public int getRowCount() {
            return this._data == null ? 0 : this._data.size();
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return String.class;
            }
            if (n == 1) {
                return Integer.class;
            }
            return null;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            if (this._data == null || this._data.size() == 0) {
                return null;
            }
            AbstractTextNode.Statistics statistics = this._data.get(n);
            Object object = null;
            switch (n2) {
                case 0: {
                    object = statistics.getToken();
                    break;
                }
                case 1: {
                    object = statistics.getValue();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }
    }

    private class TokenInfo {
        private String _language;
        private String _type;
        private String _token;

        public TokenInfo(String string, String string2, String string3) {
            this._language = string;
            this._type = string2;
            this._token = string3;
        }

        public String getLanguage() {
            return this._language;
        }

        public String getType() {
            return this._type;
        }

        public String getToken() {
            return this._token;
        }
    }

    private class LoadUI
    extends SwingWorker {
        private TextTransformationOutputAttributeType _outputAttribute;
        private String _sourceColumnName;
        private String _stoplistName;
        private Exception _ex = null;
        private boolean _success = false;

        public LoadUI(TextTransformationOutputAttributeType textTransformationOutputAttributeType) {
            BuildTextOutputPanel.this._data = null;
            this._outputAttribute = textTransformationOutputAttributeType;
            this._stoplistName = DialogsLrb.get("BUILDTEXT_STOPLIST_NONE");
            this._sourceColumnName = null;
            BuildTextOutputPanel.this._stoplist = null;
            BuildTextOutputPanel.this._allTokens.clear();
        }

        protected Object doInBackground() throws Exception {
            block17: {
                BuildTextOutputPanel.this._data = new ArrayList();
                try {
                    if (this._outputAttribute != null) {
                        TransformationTokenType transformationTokenType = this._outputAttribute.getTransformationElement().getToken();
                        TextTransformationType.Theme theme = this._outputAttribute.getTransformationElement().getTheme();
                        String string = null;
                        boolean bl = false;
                        if (transformationTokenType != null) {
                            string = transformationTokenType.getToken().getStoplistId();
                            bl = transformationTokenType.getToken().getStatisticTable().getCreationDate() != null;
                        } else if (theme != null) {
                            string = theme.getToken().getStoplistId();
                            boolean bl2 = bl = theme.getToken().getStatisticTable().getCreationDate() != null;
                        }
                        if (string != null) {
                            StoplistType stoplistType = null;
                            stoplistType = AbstractTextNode.findStoplistWithIdUsingInputType(string, BuildTextOutputPanel.this._textNodeType.getStoplists());
                            if (stoplistType != null) {
                                BuildTextOutputPanel.this._stoplist = stoplistType;
                                this._stoplistName = BuildTextOutputPanel.this._stoplist.getName() + " - " + ServerConstants.StoplistLanguage.toHuman(BuildTextOutputPanel.this._stoplist.getLanguage());
                                for (StoplistType.StopTokens.Token token : BuildTextOutputPanel.this._stoplist.getStopTokens().getToken()) {
                                    String string2 = token.getLanguage();
                                    String string3 = token.getItem();
                                    String string4 = token.getType();
                                    String string5 = string2 + ":" + string4 + ":" + string3;
                                    BuildTextOutputPanel.this._allTokens.put(string5, new TokenInfo(string2, string4, string3));
                                }
                            }
                        }
                        if (bl) {
                            try {
                                BuildTextOutputPanel.this._data = BuildTextNode.loadStatistics(BuildTextOutputPanel.this._context, this._outputAttribute);
                            }
                            catch (Exception exception) {
                                BuildTextOutputPanel.this._data.clear();
                                BuildTextOutputPanel.this._data.add(new AbstractTextNode.Statistics(DialogsLrb.get("BUILDTEXT_NODE_TABLE_NO_DATA"), null));
                            }
                            if (BuildTextOutputPanel.this._data.isEmpty()) {
                                if (theme != null) {
                                    BuildTextOutputPanel.this._data.add(new AbstractTextNode.Statistics(DialogsLrb.get("BUILDTEXT_NODE_NO_THEME_GENERATED"), null));
                                } else {
                                    BuildTextOutputPanel.this._data.add(new AbstractTextNode.Statistics(DialogsLrb.get("BUILDTEXT_NODE_NO_TOKEN_GENERATED"), null));
                                }
                            }
                        } else {
                            BuildTextOutputPanel.this._data.add(new AbstractTextNode.Statistics(DialogsLrb.get("BUILDTEXT_NODE_TABLE_NO_DATA"), null));
                        }
                        this._sourceColumnName = this._outputAttribute.getName();
                    } else {
                        BuildTextOutputPanel.this._data.add(new AbstractTextNode.Statistics(DialogsLrb.get("BUILDTEXT_NOT_XFORMED_COLUMN"), null));
                    }
                    this._success = true;
                }
                catch (Exception exception) {
                    this._ex = exception;
                    this._success = false;
                    if (BuildTextOutputPanel.this._data == null) break block17;
                    BuildTextOutputPanel.this._data.clear();
                    BuildTextOutputPanel.this._data.add(new AbstractTextNode.Statistics(DialogsLrb.get("BUILDTEXT_NODE_TABLE_LOAD_FAILED"), null));
                }
            }
            return BuildTextOutputPanel.this._data;
        }

        @Override
        protected void done() {
            Object object;
            Object object2;
            super.done();
            if (BuildTextOutputPanel.this._parent != null) {
                if (BuildTextOutputPanel.this._parent instanceof BuildTextPanel && (object2 = ((BuildTextPanel)(object = (BuildTextPanel)BuildTextOutputPanel.this._parent)).getSelectedTextTransformationOutputAttribute()) != null && !object2.getName().equals(this._outputAttribute.getName())) {
                    return;
                }
                if (BuildTextOutputPanel.this._parent instanceof ApplyTextPanel && (object2 = ((ApplyTextPanel)(object = (ApplyTextPanel)BuildTextOutputPanel.this._parent)).getSelectedTextTransformationOutputAttribute()) != null && !object2.getName().equals(this._outputAttribute.getName())) {
                    return;
                }
                if (BuildTextOutputPanel.this._parent instanceof TextPanel && (object2 = ((TextPanel)(object = (TextPanel)BuildTextOutputPanel.this._parent)).getSelectedTextTransformationOutputAttribute()) != null && !object2.getName().equals(this._outputAttribute.getName())) {
                    return;
                }
            }
            if (this._success && this._ex == null) {
                BuildTextOutputPanel.this.dataMinerTablePanel.setTitle(this._sourceColumnName);
                BuildTextOutputPanel.this.jLabel2.setText(this._stoplistName);
                try {
                    object = (List)this.get();
                    if (object != null) {
                        BuildTextOutputPanel.this._models = new AttrsTableModel((List<AbstractTextNode.Statistics>)object);
                    } else {
                        BuildTextOutputPanel.this._models = new AttrsTableModel(null);
                    }
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
                BuildTextOutputPanel.this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)BuildTextOutputPanel.this._models));
                BuildTextOutputPanel.this.dataMinerTablePanel.getTable().setSortColumn(1, false);
            } else {
                boolean bl = false;
                if (this._ex instanceof SQLException && ((SQLException)this._ex).getErrorCode() == 942) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("BUILDTEXT_NODE_MISSING_TABLE"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                    bl = true;
                }
                if (!bl) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("BUILDTEXT_NODE_EDIT_ERROR_MESG"), null);
                }
                try {
                    object2 = (List)this.get();
                    if (object2 != null) {
                        BuildTextOutputPanel.this._models = new AttrsTableModel((List<AbstractTextNode.Statistics>)object2);
                    } else {
                        BuildTextOutputPanel.this._models = new AttrsTableModel(null);
                    }
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
                BuildTextOutputPanel.this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)BuildTextOutputPanel.this._models));
                BuildTextOutputPanel.this.dataMinerTablePanel.getTable().setSortColumn(1, false);
            }
            BuildTextOutputPanel.this.enableControls();
        }
    }
}

