/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.columnFilter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.controls.renderers.HistogramBarRenderer;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.controls.renderers.NumberCellRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.utils.PIAncestorListener;
import oracle.dmt.dataminer.utils.comparator.AttributeTypeComparator;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.columnFilter.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.columnFilter.OutputColumnDialog;
import oracle.dmt.dataminer.workflow.dialog.columnFilter.SettingsDialog;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.columnFilter.ColumnFilterNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.columnFilter.ColumnFilterPIPropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.columnFilter.WorkflowColumnFilterNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ColumnFilterNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Element;
import oracle.ide.nulls.NullIcon;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;

public class OutputColumnPanel
extends AbstractDialogPanel {
    private OutputColumnPanel _parent;
    private JEWTDialog _parentDlg;
    private WorkflowColumnFilterNodePropertyProxyModel _propertyModel;
    private AttrsTableModel _models;
    private static NullIcon _nullIcon;
    private static Icon _editIcon;
    private JButton _editBtn;
    private JButton _applyBtn;
    private ColumnFilterAttributeType _columnFilterAttribute;
    private ColumnFilterSettingsType _columnFilterSettings;
    private String _generatedAITableName;
    private boolean _dirty;
    private boolean _DQResultGen = false;
    private boolean _AIResultGen = false;
    private TableColumn _rankTableColumn;
    private TableColumn _importanceTableColumn;
    private TableColumn _nullPercentTableColumn;
    private TableColumn _uniquePercentTableColumn;
    private TableColumn _constantPercentTableColumn;
    private boolean _expandedDialog;
    private String ATTRIBUTE_MAYBE_GOOD = DialogsLrb.get("COLUMN_FILTER_GOOD_ATTRIBUTE_INFO");
    private String[] _columnFilters = new String[]{DialogsLrb.get("COLUMN_FILTER_COLUMN_ATTRIBUTE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_DATA_TYPE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_HINTS")};
    private String[] _columnNamesEx = new String[]{DialogsLrb.get("COLUMN_FILTER_COLUMN_ATTRIBUTE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_DATA_TYPE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_OUTPUT"), DialogsLrb.get("COLUMN_FILTER_COLUMN_RANK"), DialogsLrb.get("COLUMN_FILTER_COLUMN_IMPORTANCE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_NULL_PERCENT"), DialogsLrb.get("COLUMN_FILTER_COLUMN_UNIQUE_PERCENT"), DialogsLrb.get("COLUMN_FILTER_COLUMN_CONSTANT_PERCENT"), DialogsLrb.get("COLUMN_FILTER_COLUMN_HINTS")};
    private String[] _columnFiltersEx = new String[]{DialogsLrb.get("COLUMN_FILTER_COLUMN_ATTRIBUTE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_DATA_TYPE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_RANK"), DialogsLrb.get("COLUMN_FILTER_COLUMN_IMPORTANCE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_NULL_PERCENT"), DialogsLrb.get("COLUMN_FILTER_COLUMN_UNIQUE_PERCENT"), DialogsLrb.get("COLUMN_FILTER_COLUMN_CONSTANT_PERCENT"), DialogsLrb.get("COLUMN_FILTER_COLUMN_HINTS")};
    private int[] _columnWidthsEx = new int[]{180, 80, 60, 50, 80, 60, 80, 90, 200};
    private static final int ATTRIBUTE = 0;
    private static final int DATA_TYPE = 1;
    private static final int OUTPUT = 2;
    private static final int REASON_HINT = 3;
    private static final int RANK = 3;
    private static final int IMPORTANCE = 4;
    private static final int NULLS_PERCENT = 5;
    private static final int UNIQUE_PERCENT = 6;
    private static final int CONSTANT_PERCENT = 7;
    private static final int REASON_HINT_EX = 8;
    private static final int ATTR_STATUS = 99;
    private DataMinerTablePanel dataMinerTablePanel;
    private JButton jSettingsButton;
    private JCheckBox jShowAICheckBox;
    private JCheckBox jShowDQCheckBox;

    public OutputColumnPanel(JEWTDialog jEWTDialog, Context context, ColumnFilterNode columnFilterNode, PropertyModel propertyModel) {
        super(context, columnFilterNode);
        this._parentDlg = jEWTDialog;
        assert (propertyModel != null) : "PropertyModel for ColumnFilter node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this.setMinimumSize(new Dimension(200, 400));
        this._expandedDialog = true;
        this.init((ColumnFilterNode)this._data, propertyModel);
    }

    public OutputColumnPanel(JEWTDialog jEWTDialog, Context context, ColumnFilterNode columnFilterNode, OutputColumnPanel outputColumnPanel) {
        super(context, columnFilterNode);
        this._parentDlg = jEWTDialog;
        assert (context != null) : "Context must not be null.";
        assert (columnFilterNode != null) : "ColumnFilter node must not be null.";
        this._parent = outputColumnPanel;
        this._expandedDialog = outputColumnPanel != null;
        this.init(columnFilterNode, null);
    }

    public OutputColumnPanel(PropertyModel propertyModel) {
        super(null, null);
        assert (propertyModel != null) : "PropertyModel for ColumnFilter node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this._expandedDialog = false;
        this.addAncestorListener(new PIAncestorListener(this));
        this.init((ColumnFilterNode)this._data, propertyModel);
    }

    private boolean isPIMode() {
        return this._propertyModel != null && this._parentDlg == null;
    }

    private boolean isPIDialogMode() {
        return this._propertyModel != null && this._parentDlg != null;
    }

    private void init(ColumnFilterNode columnFilterNode, PropertyModel propertyModel) {
        this._propertyModel = (WorkflowColumnFilterNodePropertyProxyModel)propertyModel;
        this._dirty = false;
        if (this._parent == null) {
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)columnFilterNode.getData();
            this._columnFilterAttribute = (ColumnFilterAttributeType)MetaDataHelper.copyMetadataObject(columnFilterNodeType.getColumnFilterAttributes());
            this._columnFilterSettings = (ColumnFilterSettingsType)MetaDataHelper.copyMetadataObject(columnFilterNodeType.getColumnFilterSettings());
            this._generatedAITableName = columnFilterNodeType.getColumnFilterResults().getAttrImportanceOutput();
        } else {
            this._columnFilterAttribute = this._parent.getColumnFilterAttribute();
            this._columnFilterSettings = this._parent.getColumnFilterSettings();
            this._generatedAITableName = this._parent.getAIResultTable();
        }
        this.initComponents();
        this.initRes();
        if (this._expandedDialog) {
            this.initUIEx();
        } else {
            this.initUI();
        }
    }

    public void updatePI(PropertyModel propertyModel) {
        WorkflowColumnFilterNodePropertyProxyModel workflowColumnFilterNodePropertyProxyModel = (WorkflowColumnFilterNodePropertyProxyModel)propertyModel;
        Context context = workflowColumnFilterNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        ColumnFilterNode columnFilterNode = (ColumnFilterNode)workflowNodeInspectorElement.getNode();
        if (columnFilterNode == null) {
            return;
        }
        this._propertyModel = (WorkflowColumnFilterNodePropertyProxyModel)propertyModel;
        this._context = context;
        this._data = columnFilterNode;
        this._dirty = false;
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)columnFilterNode.getData();
        this._columnFilterAttribute = (ColumnFilterAttributeType)MetaDataHelper.copyMetadataObject(columnFilterNodeType.getColumnFilterAttributes());
        this.refreshUI();
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowColumnFilterNodePropertyProxyModel)) {
            return null;
        }
        WorkflowColumnFilterNodePropertyProxyModel workflowColumnFilterNodePropertyProxyModel = (WorkflowColumnFilterNodePropertyProxyModel)propertyModel;
        Context context = workflowColumnFilterNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    private ColumnFilterNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowColumnFilterNodePropertyProxyModel)) {
            return null;
        }
        WorkflowColumnFilterNodePropertyProxyModel workflowColumnFilterNodePropertyProxyModel = (WorkflowColumnFilterNodePropertyProxyModel)propertyModel;
        Context context = workflowColumnFilterNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof ColumnFilterNodeType) {
            return (ColumnFilterNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNode() {
        try {
            CommandProcessor.getInstance().beginTrans(DialogsLrb.get("COLUMN_FILTER_NODE_EDIT_TRANSACTION_NAME"));
            ColumnFilterNode columnFilterNode = (ColumnFilterNode)this.getData();
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)columnFilterNode.getData();
            ArrayList<ComplexProperty> arrayList = new ArrayList<ComplexProperty>();
            ComplexProperty complexProperty = new ComplexProperty("ColumnFilterAttributes", this._columnFilterAttribute);
            complexProperty.setOldData(columnFilterNodeType.getColumnFilterAttributes());
            arrayList.add(complexProperty);
            complexProperty = new ComplexProperty("ColumnFilterSettings", this._columnFilterSettings);
            complexProperty.setOldData(columnFilterNodeType.getColumnFilterSettings());
            arrayList.add(complexProperty);
            complexProperty = new ComplexProperty("AttrImportanceTable", this._generatedAITableName);
            complexProperty.setOldData(columnFilterNodeType.getColumnFilterResults().getAttrImportanceOutput());
            arrayList.add(complexProperty);
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getData().getUndoFilter();
            odmrSDMUndoFilter.prepareUndoComplexPropertyList(columnFilterNode, this.getContext(), arrayList);
            columnFilterNode.validate(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("COLUMN_FILTER_NODE_EDIT_ERROR_MESG"), null);
            CommandProcessor.getInstance().abortTrans();
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
    }

    public boolean doWork() {
        boolean bl = true;
        if (this.isDirty() && !this.isPIMode()) {
            if (this.isPIDialogMode()) {
                this.updateNode();
            } else if (this._parent != null) {
                this._parent.setOutputColumns(this._columnFilterAttribute);
                this._parent.setColumnFilterSettings(this._columnFilterSettings);
                this._parent.setAIResultTable(this._generatedAITableName);
                this._parent.setDirty(true);
                this._parent.refreshUI();
            } else {
                this.updateNode();
            }
        }
        return bl;
    }

    @Override
    public void initRes() {
        ResourceUtils.resButton((AbstractButton)this.jSettingsButton, (String)DialogsLrb.get("COLUMN_FILTER_COLUMN_SETTINGS"));
        ResourceUtils.resButton((AbstractButton)this.jShowDQCheckBox, (String)DialogsLrb.get("COLUMN_FILTER_COLUMN_SHOW_DQ"));
        ResourceUtils.resButton((AbstractButton)this.jShowAICheckBox, (String)DialogsLrb.get("COLUMN_FILTER_COLUMN_SHOW_AI"));
        if (_nullIcon == null) {
            _nullIcon = new NullIcon(DataMinerIcons.get(Icons.PI_BUILD_GROUP_MODEL_BUILT).getIconWidth(), DataMinerIcons.get(Icons.PI_BUILD_GROUP_MODEL_BUILT).getIconHeight());
        }
        _editIcon = InspectorArb.getIcon((int)24);
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)"columnfilter_columns");
        List list = this._columnFilterAttribute.getAttribute();
        Collections.sort(list, AttributeTypeComparator.getComparator());
        this._models = new AttrsTableModel(list);
        this._editBtn = new JButton(_editIcon);
        this._editBtn.setEnabled(false);
        this._editBtn.setToolTipText(DialogsLrb.get("COLUMN_FILTER_DETAILS"));
        this._editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputColumnPanel.this.processEdit();
            }
        });
        this._applyBtn = new JButton(DataMinerIcons.get(Icons.PI_ATTR_GROUP_PROP_COMPARE_TESTS));
        this._applyBtn.setToolTipText(DialogsLrb.get("COLUMN_FILTER_APPLY_RECOMM"));
        this._applyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputColumnPanel.this.processApply();
            }
        });
        this.dataMinerTablePanel.setup((TableModel)((Object)this._models), DialogsLrb.get("COLUMN_FILTER_COLUMN_TABLE_TITLE"), this._columnFilters, 0);
        this.dataMinerTablePanel.addControlBarComponents(this._editBtn, this._applyBtn);
        TableColumn tableColumn = this.dataMinerTablePanel.getTable().getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new NameCellRenderer());
        tableColumn = this.dataMinerTablePanel.getTable().getColumnModel().getColumn(2);
        tableColumn.setCellEditor(new OutputCellEditor());
        IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string;
                if (object instanceof String && (string = (String)object).length() > 0) {
                    return DataMinerIcons.get(Icons.WARNING_STATUS);
                }
                return _nullIcon;
            }
        });
        tableColumn = this.dataMinerTablePanel.getTable().getColumnModel().getColumn(3);
        tableColumn.setCellRenderer(iconCellRenderer);
        this.dataMinerTablePanel.getTable().setSelectionMode(2);
        this.dataMinerTablePanel.getTable().setColumnSelectorAvailable(true);
        this.dataMinerTablePanel.getTable().setShowToolTips(true);
        this.dataMinerTablePanel.getTable().setUpdateSelectionOnSort(true);
        this.dataMinerTablePanel.getTable().setRowSelectionAllowed(true);
        this.dataMinerTablePanel.getTable().autoSizeColumnsToFit();
        this.dataMinerTablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                if (defaultListSelectionModel != null && defaultListSelectionModel.getValueIsAdjusting()) {
                    return;
                }
                OutputColumnPanel.this.handleModelSelectionChanged();
            }
        });
        this.enableControls();
    }

    public void initUIEx() {
        HelpUtils.setHelpID((JComponent)this, (String)"columnfilter_columns_ex");
        this._models = new AttrsTableModelEx();
        this._applyBtn = new JButton(DataMinerIcons.get(Icons.PI_ATTR_GROUP_PROP_COMPARE_TESTS));
        this._applyBtn.setToolTipText(DialogsLrb.get("COLUMN_FILTER_APPLY_RECOMM"));
        this._applyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputColumnPanel.this.processApply();
            }
        });
        this.dataMinerTablePanel.addControlBarComponents(this._applyBtn);
        this.dataMinerTablePanel.setup((TableModel)((Object)this._models), DialogsLrb.get("COLUMN_FILTER_COLUMN_TABLE_TITLE"), this._columnFiltersEx, 0);
        TableColumn tableColumn = this.dataMinerTablePanel.getTable().getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new NameCellRenderer());
        tableColumn = this.dataMinerTablePanel.getTable().getColumnModel().getColumn(2);
        tableColumn.setCellEditor(new OutputCellEditor());
        this._rankTableColumn = this.dataMinerTablePanel.getTable().getColumnModel().getColumn(3);
        this._rankTableColumn.setCellRenderer(new NumberCellRenderer());
        this._importanceTableColumn = this.dataMinerTablePanel.getTable().getColumnModel().getColumn(4);
        Preferences preferences = Preferences.getPreferences();
        ModelViewerPreferenceSettings modelViewerPreferenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)preferences);
        NumberFormat numberFormat = NumericFormat.getInstance(true, modelViewerPreferenceSettings.getPercentagePrecisionLevel(), 0, 0);
        numberFormat.setMaximumFractionDigits(modelViewerPreferenceSettings.getPercentagePrecisionLevel());
        numberFormat.setMinimumIntegerDigits(1);
        this._importanceTableColumn.setCellRenderer(new HistogramBarRenderer(1L, true, numberFormat));
        this._nullPercentTableColumn = this.dataMinerTablePanel.getTable().getColumnModel().getColumn(5);
        this._nullPercentTableColumn.setCellRenderer(new HistogramBarRenderer(100L, true, numberFormat));
        this._uniquePercentTableColumn = this.dataMinerTablePanel.getTable().getColumnModel().getColumn(6);
        this._uniquePercentTableColumn.setCellRenderer(new HistogramBarRenderer(100L, true, numberFormat));
        this._constantPercentTableColumn = this.dataMinerTablePanel.getTable().getColumnModel().getColumn(7);
        this._constantPercentTableColumn.setCellRenderer(new HistogramBarRenderer(100L, true, numberFormat));
        IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string;
                if (object instanceof String && (string = (String)object).length() > 0) {
                    return DataMinerIcons.get(Icons.WARNING_STATUS);
                }
                return _nullIcon;
            }
        });
        tableColumn = this.dataMinerTablePanel.getTable().getColumnModel().getColumn(8);
        tableColumn.setCellRenderer(iconCellRenderer);
        this.dataMinerTablePanel.getTable().setAutoResizeMode(0);
        this.dataMinerTablePanel.getTable().setSelectionMode(2);
        this.dataMinerTablePanel.getTable().setColumnSelectorAvailable(true);
        this.dataMinerTablePanel.getTable().setShowToolTips(true);
        this.dataMinerTablePanel.getTable().setUpdateSelectionOnSort(true);
        this.dataMinerTablePanel.getTable().setRowSelectionAllowed(true);
        int n = 0;
        for (int n2 : this._columnWidthsEx) {
            this.dataMinerTablePanel.getTable().getColumnModel().getColumn(n++).setPreferredWidth(n2);
        }
        this.dataMinerTablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                if (defaultListSelectionModel != null && defaultListSelectionModel.getValueIsAdjusting()) {
                    return;
                }
                OutputColumnPanel.this.handleModelSelectionChanged();
            }
        });
        this._AIResultGen = false;
        this._DQResultGen = false;
        Object object = (ColumnFilterNode)this.getData();
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)((AbstractNode)object).getData();
        this._AIResultGen = columnFilterNodeType.getColumnFilterResults().getAttrImportanceOutput() != null && !((ColumnFilterNode)object).isNew();
        this._DQResultGen = columnFilterNodeType.getColumnFilterResults().getDataQualityOutput() != null && !((ColumnFilterNode)object).isNew();
        this.jShowAICheckBox.setSelected(this._AIResultGen);
        this.jShowAICheckBox.setEnabled(this._AIResultGen);
        if (!this._AIResultGen) {
            this.dataMinerTablePanel.getTable().removeColumn(this._rankTableColumn);
            this.dataMinerTablePanel.getTable().removeColumn(this._importanceTableColumn);
        }
        this.jShowDQCheckBox.setSelected(this._DQResultGen);
        this.jShowDQCheckBox.setEnabled(this._DQResultGen);
        if (!this._DQResultGen) {
            this.dataMinerTablePanel.getTable().removeColumn(this._nullPercentTableColumn);
            this.dataMinerTablePanel.getTable().removeColumn(this._uniquePercentTableColumn);
            this.dataMinerTablePanel.getTable().removeColumn(this._constantPercentTableColumn);
        }
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    public ColumnFilterAttributeType getColumnFilterAttribute() {
        return this._columnFilterAttribute;
    }

    public ColumnFilterSettingsType getColumnFilterSettings() {
        return this._columnFilterSettings;
    }

    public void refreshUI() {
        List list = this._columnFilterAttribute.getAttribute();
        Collections.sort(list, AttributeTypeComparator.getComparator());
        this._models.setSrcData(list);
        this.enableControls();
    }

    private void enableControls() {
        this.jSettingsButton.setVisible(!this.isPIMode() && !this.isPIDialogMode());
        if (!this._expandedDialog) {
            this.jShowAICheckBox.setVisible(false);
            this.jShowDQCheckBox.setVisible(false);
        }
        ColumnFilterNode columnFilterNode = (ColumnFilterNode)this.getData();
        if (this._editBtn != null) {
            this._editBtn.setEnabled(this.isWritable() && !columnFilterNode.isNew());
        }
        int n = this.dataMinerTablePanel.getTable().getSelectedRowCount();
        this._applyBtn.setEnabled(this.isWritable() && n > 0 && !columnFilterNode.isNew());
    }

    private void processEdit() {
        if (this.isPIMode()) {
            OutputColumnDialog outputColumnDialog = new OutputColumnDialog(this._context, (ColumnFilterNode)this._data, (PropertyModel)this._propertyModel);
            outputColumnDialog.invoke(this);
        } else {
            OutputColumnDialog outputColumnDialog = new OutputColumnDialog(this._context, (ColumnFilterNode)this._data, this);
            outputColumnDialog.invoke(this);
        }
    }

    private void processApply() {
        int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            ColumnFilterNode columnFilterNode = (ColumnFilterNode)this.getData();
            ColumnFilterAttributeType.Attribute attribute = (ColumnFilterAttributeType.Attribute)this._columnFilterAttribute.getAttribute().get(n);
            String string = columnFilterNode.getReasonHintsLookupMap().get(attribute.getName());
            if (attribute.getOutput().compareTo("Yes") == 0 && string != null) {
                attribute.setOutput("No");
            }
            if (attribute.getOutput().compareTo("No") != 0 || string != null) continue;
            attribute.setOutput("Yes");
        }
        this.dataMinerTablePanel.getTable().updateUI();
        this._dirty = true;
        if (this.isPIMode()) {
            this.updateNode();
        }
    }

    private void handleModelSelectionChanged() {
        this.enableControls();
    }

    private void initComponents() {
        this.jShowAICheckBox = new JCheckBox();
        this.jShowDQCheckBox = new JCheckBox();
        this.jSettingsButton = new JButton();
        this.dataMinerTablePanel = new DataMinerTablePanel();
        this.jShowAICheckBox.setText("Show Attribute Importance");
        this.jShowAICheckBox.setName("jShowAICheckBox");
        this.jShowAICheckBox.setOpaque(false);
        this.jShowAICheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputColumnPanel.this.jShowAICheckBoxActionPerformed(actionEvent);
            }
        });
        this.jShowDQCheckBox.setText("Show Data Quality");
        this.jShowDQCheckBox.setName("jShowDQCheckBox");
        this.jShowDQCheckBox.setOpaque(false);
        this.jShowDQCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputColumnPanel.this.jShowDQCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jSettingsButton.setText("Settings");
        this.jSettingsButton.setName("jSettingsButton");
        this.jSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputColumnPanel.this.jSettingsButtonActionPerformed(actionEvent);
            }
        });
        this.dataMinerTablePanel.setName("dataMinerTablePanel");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jShowAICheckBox, -2, 210, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSettingsButton)).addComponent(this.jShowDQCheckBox, -2, 210, -2).addComponent(this.dataMinerTablePanel, -1, 679, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(4, 4, 4).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jShowAICheckBox).addComponent(this.jSettingsButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jShowDQCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataMinerTablePanel, -1, 285, Short.MAX_VALUE)));
    }

    private void jShowAICheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jShowAICheckBox.isSelected();
        if (bl) {
            this.dataMinerTablePanel.getTable().addColumn(this._rankTableColumn);
            this.dataMinerTablePanel.getTable().moveColumn(this.dataMinerTablePanel.getTable().getColumnCount() - 1, 3);
            this.dataMinerTablePanel.getTable().addColumn(this._importanceTableColumn);
            this.dataMinerTablePanel.getTable().moveColumn(this.dataMinerTablePanel.getTable().getColumnCount() - 1, 4);
        } else {
            this.dataMinerTablePanel.getTable().removeColumn(this._rankTableColumn);
            this.dataMinerTablePanel.getTable().removeColumn(this._importanceTableColumn);
        }
        this.enableControls();
    }

    private void jShowDQCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jShowDQCheckBox.isSelected();
        if (bl) {
            this.dataMinerTablePanel.getTable().addColumn(this._nullPercentTableColumn);
            int n = this.jShowAICheckBox.isSelected() ? 0 : 2;
            this.dataMinerTablePanel.getTable().moveColumn(this.dataMinerTablePanel.getTable().getColumnCount() - 1, 5 - n);
            this.dataMinerTablePanel.getTable().addColumn(this._uniquePercentTableColumn);
            this.dataMinerTablePanel.getTable().moveColumn(this.dataMinerTablePanel.getTable().getColumnCount() - 1, 6 - n);
            this.dataMinerTablePanel.getTable().addColumn(this._constantPercentTableColumn);
            this.dataMinerTablePanel.getTable().moveColumn(this.dataMinerTablePanel.getTable().getColumnCount() - 1, 7 - n);
        } else {
            this.dataMinerTablePanel.getTable().removeColumn(this._nullPercentTableColumn);
            this.dataMinerTablePanel.getTable().removeColumn(this._uniquePercentTableColumn);
            this.dataMinerTablePanel.getTable().removeColumn(this._constantPercentTableColumn);
        }
        this.enableControls();
    }

    private void jSettingsButtonActionPerformed(ActionEvent actionEvent) {
        SettingsDialog settingsDialog = new SettingsDialog(this._context, (ColumnFilterNode)this._data, this);
        settingsDialog.invoke(this);
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    public void setOutputColumns(ColumnFilterAttributeType columnFilterAttributeType) {
        this._columnFilterAttribute = columnFilterAttributeType;
    }

    public void setColumnFilterSettings(ColumnFilterSettingsType columnFilterSettingsType) {
        this._columnFilterSettings = columnFilterSettingsType;
    }

    public void setAIResultTable(String string) {
        this._generatedAITableName = string;
    }

    public String getAIResultTable() {
        return this._generatedAITableName;
    }

    private class NameCellRenderer
    extends DefaultTableCellRenderer {
        private NameCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = OutputColumnPanel.this.dataMinerTablePanel.getTable().convertRowIndexToModel(n);
            TableModel tableModel = OutputColumnPanel.this.dataMinerTablePanel.getTable().getModel();
            AttributeStatus attributeStatus = AttributeStatus.VALID;
            if (tableModel instanceof AttrsTableModel && (object2 = tableModel.getValueAt(n3, 99)) instanceof AttributeStatus) {
                attributeStatus = (AttributeStatus)object2;
            }
            if (attributeStatus.equals((Object)AttributeStatus.VALID)) {
                this.setIcon(DataMinerIcons.get(Icons.ATTRIBUTE));
            } else {
                this.setIcon(DataMinerIcons.get(Icons.USAGE_ATTR_INVALID));
            }
            return component;
        }
    }

    private class OutputCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        Icon _icon;
        private JButton _btn = new JButton((Icon)OutputColumnPanel.access$300());
        protected static final String EDIT = "edit";

        public OutputCellEditor() {
            this._btn.setActionCommand(EDIT);
            this._btn.addActionListener(this);
            this._btn.setBorderPainted(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EDIT.equals(actionEvent.getActionCommand())) {
                this.fireEditingStopped();
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            int n3 = OutputColumnPanel.this.dataMinerTablePanel.getTable().convertRowIndexToModel(n);
            TableModel tableModel = OutputColumnPanel.this.dataMinerTablePanel.getTable().getModel();
            this._icon = (Icon)tableModel.getValueAt(n3, 2);
            this._btn.setIcon(this._icon);
            return this._btn;
        }

        @Override
        public Object getCellEditorValue() {
            if (this._icon == DataMinerIcons.get(Icons.ATTR_OUTPUT)) {
                this._icon = DataMinerIcons.get(Icons.ATTR_IGNORE);
            } else if (this._icon.equals(DataMinerIcons.get(Icons.ATTR_IGNORE))) {
                this._icon = DataMinerIcons.get(Icons.ATTR_OUTPUT);
            }
            return this._icon;
        }

        @Override
        public boolean stopCellEditing() {
            return super.stopCellEditing();
        }
    }

    private class AttrsTableModelEx
    extends AttrsTableModel {
        HashMap<String, ColumnFilterNode.Statistics> _statisticLookupMap;

        public AttrsTableModelEx() {
            this(null, null);
        }

        public AttrsTableModelEx(List<ColumnFilterAttributeType.Attribute> list, HashMap<String, ColumnFilterNode.Statistics> hashMap) {
            super(list);
            this._statisticLookupMap = hashMap;
            this.setColumnIdentifiers(OutputColumnPanel.this._columnNamesEx);
        }

        @Override
        public Class getColumnClass(int n) {
            switch (n) {
                case 3: {
                    return Integer.class;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return Double.class;
                }
                case 8: {
                    return String.class;
                }
            }
            return super.getColumnClass(n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.srcData == null) {
                return DialogsLrb.get("COLUMN_FILTER_LOADING_MESSAGE");
            }
            ColumnFilterAttributeType.Attribute attribute = (ColumnFilterAttributeType.Attribute)this.srcData.get(n);
            ColumnFilterNode columnFilterNode = (ColumnFilterNode)OutputColumnPanel.this.getData();
            ColumnFilterNode.Statistics statistics = columnFilterNode.getStatisticLookupMap().get(attribute.getName());
            Object object = null;
            switch (n2) {
                case 3: {
                    if (statistics == null) break;
                    object = statistics.getRank();
                    break;
                }
                case 4: {
                    if (statistics == null) break;
                    object = statistics.getImportance();
                    break;
                }
                case 5: {
                    if (statistics == null) break;
                    object = statistics.getNulls();
                    break;
                }
                case 6: {
                    if (statistics == null) break;
                    object = statistics.getUnique();
                    break;
                }
                case 7: {
                    if (statistics == null) break;
                    object = statistics.getConstant();
                    break;
                }
                case 8: {
                    object = super.getValueAt(n, 3);
                    break;
                }
                default: {
                    object = super.getValueAt(n, n2);
                }
            }
            return object;
        }

        public void setStatisticLookupMap(HashMap<String, ColumnFilterNode.Statistics> hashMap) {
            this._statisticLookupMap = hashMap;
        }
    }

    private class AttrsTableModel
    extends ODMrTableModel<ColumnFilterAttributeType.Attribute> {
        private final String[] _columnNames;

        public AttrsTableModel(List<ColumnFilterAttributeType.Attribute> list) {
            super(list);
            this._columnNames = new String[]{DialogsLrb.get("COLUMN_FILTER_COLUMN_ATTRIBUTE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_DATA_TYPE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_OUTPUT"), DialogsLrb.get("COLUMN_FILTER_COLUMN_HINTS")};
            this.setColumnIdentifiers(this._columnNames);
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 2) {
                return OutputColumnPanel.this.isWritable();
            }
            return false;
        }

        public Object getValueAt(int n, int n2) {
            if (this.srcData == null || this.srcData.isEmpty()) {
                return DialogsLrb.get("COLUMN_FILTER_LOADING_MESSAGE");
            }
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            ColumnFilterAttributeType.Attribute attribute = (ColumnFilterAttributeType.Attribute)this.srcData.get(n);
            Object object = null;
            switch (n2) {
                case 0: {
                    object = attribute.getName();
                    break;
                }
                case 1: {
                    object = attribute.getDataType();
                    break;
                }
                case 2: {
                    if (attribute.getOutput().compareTo("System") == 0) {
                        object = DataMinerIcons.get(Icons.FILTER_ATTR_UNKNOWN);
                        break;
                    }
                    if (attribute.getOutput().compareTo("Yes") == 0) {
                        object = DataMinerIcons.get(Icons.ATTR_OUTPUT);
                        break;
                    }
                    if (attribute.getOutput().compareTo("No") != 0) break;
                    object = DataMinerIcons.get(Icons.ATTR_IGNORE);
                    break;
                }
                case 3: {
                    object = "";
                    ColumnFilterNode columnFilterNode = (ColumnFilterNode)OutputColumnPanel.this.getData();
                    String string = columnFilterNode.getReasonHintsLookupMap().get(attribute.getName());
                    if (string != null) {
                        object = string;
                    }
                    if (attribute.getOutput().compareTo("Yes") == 0 && string != null) {
                        object = string;
                    }
                    if (columnFilterNode.isNew() || attribute.getOutput().compareTo("No") != 0 || string != null) break;
                    object = OutputColumnPanel.this.ATTRIBUTE_MAYBE_GOOD;
                    break;
                }
                case 99: {
                    object = attribute.getStatus();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public void setValueAt(Object object, int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            ColumnFilterAttributeType.Attribute attribute = (ColumnFilterAttributeType.Attribute)this.srcData.get(n);
            switch (n2) {
                case 2: {
                    OutputColumnPanel.this._dirty = true;
                    Icon icon = (Icon)object;
                    int[] nArray = OutputColumnPanel.this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
                    if (!OutputColumnPanel.this.isPIMode()) {
                        if (icon.equals(DataMinerIcons.get(Icons.ATTR_OUTPUT))) {
                            attribute.setOutput("Yes");
                        } else if (icon.equals(DataMinerIcons.get(Icons.ATTR_IGNORE))) {
                            attribute.setOutput("No");
                        }
                        for (int i = 0; i < nArray.length; ++i) {
                            int n3 = nArray[i];
                            ColumnFilterAttributeType.Attribute attribute2 = (ColumnFilterAttributeType.Attribute)this.srcData.get(n3);
                            if (icon.equals(DataMinerIcons.get(Icons.ATTR_OUTPUT))) {
                                attribute2.setOutput("Yes");
                                continue;
                            }
                            if (!icon.equals(DataMinerIcons.get(Icons.ATTR_IGNORE))) continue;
                            attribute2.setOutput("No");
                        }
                        break;
                    }
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    HashMap<String, String> hashMap2 = new HashMap<String, String>();
                    String string = attribute.getOutput();
                    if (icon.equals(DataMinerIcons.get(Icons.ATTR_OUTPUT))) {
                        hashMap.put(attribute.getName(), "Yes");
                        hashMap2.put(attribute.getName(), string);
                    } else if (icon.equals(DataMinerIcons.get(Icons.ATTR_IGNORE))) {
                        hashMap.put(attribute.getName(), "No");
                        hashMap2.put(attribute.getName(), string);
                    }
                    for (int i = 0; i < nArray.length; ++i) {
                        int n4 = nArray[i];
                        ColumnFilterAttributeType.Attribute attribute3 = (ColumnFilterAttributeType.Attribute)this.srcData.get(n4);
                        string = attribute3.getOutput();
                        if (icon.equals(DataMinerIcons.get(Icons.ATTR_OUTPUT))) {
                            hashMap.put(attribute3.getName(), "Yes");
                            hashMap2.put(attribute3.getName(), string);
                            continue;
                        }
                        if (!icon.equals(DataMinerIcons.get(Icons.ATTR_IGNORE))) continue;
                        hashMap.put(attribute3.getName(), "No");
                        hashMap2.put(attribute3.getName(), string);
                    }
                    ArrayList<Property> arrayList = new ArrayList<Property>();
                    ComplexProperty complexProperty = new ComplexProperty("attrOutputs", hashMap);
                    complexProperty.setOldData(hashMap2);
                    arrayList.add(new Property(String.valueOf(ColumnFilterNodePropertyModel.RowIndex.ATTR_OUTPUTS), null, complexProperty, null, null));
                    OutputColumnPanel.this._propertyModel.setValueAt(ColumnFilterPIPropertyLrb.get("PI_COLUMN_FILTER_GROUP_COLUMNS_ATTRIBUTE_OUTPUT_COLUMN_CHANGED"), OutputColumnPanel.this.getData(), arrayList);
                }
            }
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;

        protected Object doInBackground() throws Exception {
            try {
                ColumnFilterNode columnFilterNode = (ColumnFilterNode)OutputColumnPanel.this.getData();
                columnFilterNode.loadResults();
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return null;
        }

        @Override
        protected void done() {
            super.done();
            try {
                if (this._success && this._ex == null) {
                    List list = OutputColumnPanel.this._columnFilterAttribute.getAttribute();
                    Collections.sort(list, AttributeTypeComparator.getComparator());
                    ColumnFilterNode columnFilterNode = (ColumnFilterNode)OutputColumnPanel.this.getData();
                    ((AttrsTableModelEx)OutputColumnPanel.this._models).setStatisticLookupMap(columnFilterNode.getStatisticLookupMap());
                    OutputColumnPanel.this._models.setSrcData(list);
                } else {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("COLUMN_FILTER_NODE_EDIT_ERROR_MESG"), null);
                }
                OutputColumnPanel.this.enableControls();
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("COLUMN_FILTER_NODE_EDIT_ERROR_MESG"), null);
            }
        }
    }
}

