/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.controls.DBObjectNameEditor;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeNameValidator;
import oracle.dmt.dataminer.utils.TableNameValidator;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.data.CreateTableAttributesDialog;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.table.TablePIPropertyLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.CreateTableNode;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.CreateTableNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DBAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.DBColumnType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.util.SwingUtils;

public class CreateTableNodeAttributesPanel
extends AbstractDialogPanel
implements DataConsumerPanel,
ActionListener {
    private static final Logger theLogger = Logger.getLogger(AbstractDialogPanel.class.getName());
    private Vector<AttributeType> dataProviderAttributes = new Vector();
    private JButton _removeBtn;
    private JButton _editBtn;
    private DBAttributes cachedDBAttributesObj = new DBAttributes();
    private String _originalTableName;
    private static Icon _editIcon;
    private static final int COLUMN_COUNT_TABLE = 5;
    private static final int NAME = 0;
    private static final int DATA_TYPE = 1;
    private static final int ISKEY = 2;
    private static final int ISINDEX = 3;
    private static final int ALIAS_TABLE = 4;
    private static final int COLUMN_COUNT_VIEW = 3;
    private static final int ALIAS_VIEW = 2;
    private String[] _columnNames_table = new String[]{TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_NAME_COLUMN"), TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_TYPE_COLUMN"), TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_KEY_COLUMN"), TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_INDEX_COLUMN"), TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_ALIAS_COLUMN")};
    private String[] _columnNames_view = new String[]{TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_NAME_COLUMN"), TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_TYPE_COLUMN"), TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_ALIAS_COLUMN")};
    private GenericTable _jAttributesTable = new GenericTableTooltipCustom();
    private ComponentWithTitlebar<JComponent> jAttributesComponent;
    private JCheckBox jChkBoxAuto;
    private JLabel jLabelName;
    private JLabel jLabelType;
    private JRadioButton jRadioButtonTable;
    private JRadioButton jRadioButtonView;
    private JTextField jTextFieldName;
    private ButtonGroup buttonGroup1 = new ButtonGroup();

    public CreateTableNodeAttributesPanel(Context context, AbstractNode abstractNode, List<AttributeType> list) {
        super(context, abstractNode);
        if (list != null) {
            this.dataProviderAttributes.addAll(list);
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jAttributesComponent = new ComponentWithTitlebar();
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabelType = new JLabel();
        this.jRadioButtonTable = new JRadioButton();
        this.jRadioButtonView = new JRadioButton();
        this.jChkBoxAuto = new JCheckBox();
        this.jLabelName.setText("Name:");
        this.jLabelType.setText("Type:");
        this.jRadioButtonTable.setText("Table");
        this.jRadioButtonView.setText("View");
        this.jChkBoxAuto.setText("Auto Input Columns Selection");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jChkBoxAuto, -2, 287, -2).addContainerGap()).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent((Component)this.jAttributesComponent, -1, 504, Short.MAX_VALUE).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelName).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jRadioButtonTable).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonView)).addComponent(this.jTextFieldName, -2, 185, -2))).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelType, -1, 141, Short.MAX_VALUE).addGap(195, 195, 195))).addGap(180, 180, 180))))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelName).addComponent(this.jTextFieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelType).addComponent(this.jRadioButtonTable).addComponent(this.jRadioButtonView)).addGap(3, 3, 3).addComponent(this.jChkBoxAuto).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.jAttributesComponent, -1, 200, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLabelName, (Component)this.jTextFieldName, (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_NAME"));
        ResourceUtils.resLabel((JLabel)this.jLabelType, null, (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_TYPE"));
        ResourceUtils.resButton((AbstractButton)this.jRadioButtonTable, (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_TABLE"));
        ResourceUtils.resButton((AbstractButton)this.jRadioButtonView, (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_VIEW"));
        ResourceUtils.resButton((AbstractButton)this.jChkBoxAuto, (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_AUTO"));
        this.jChkBoxAuto.setOpaque(false);
        this.jRadioButtonTable.setOpaque(false);
        this.jRadioButtonView.setOpaque(false);
        this.buttonGroup1.add(this.jRadioButtonTable);
        this.buttonGroup1.add(this.jRadioButtonView);
        this.jTextFieldName.setDocument(new TextFieldLimit(32));
        if (_editIcon == null) {
            _editIcon = InspectorArb.getIcon((int)24);
        }
    }

    @Override
    public void initUI() {
        DBColumnType dBColumnType;
        Object object3;
        Object object2;
        CreateTableNode createTableNode = (CreateTableNode)this.getData();
        CreateTableNodeType createTableNodeType = (CreateTableNodeType)createTableNode.getData();
        boolean bl = 0 == createTableNodeType.getAutoSpec().value().compareTo("Yes");
        this.jChkBoxAuto.setSelected(bl);
        this.jChkBoxAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = CreateTableNodeAttributesPanel.this.jChkBoxAuto.isSelected();
                CreateTableNodeAttributesPanel.this._editBtn.setEnabled(!bl);
                CreateTableNodeAttributesPanel.this._removeBtn.setEnabled(!bl);
                if (bl) {
                    CreateTableNodeAttributesPanel.this.refreshAttributesFromDS();
                    CreateTableNode createTableNode = (CreateTableNode)CreateTableNodeAttributesPanel.this.getData();
                    CreateTableNodeType createTableNodeType = (CreateTableNodeType)createTableNode.getData();
                    GeneralAttributesTableModel generalAttributesTableModel = createTableNodeType.isTable() ? new TableAttributes(CreateTableNodeAttributesPanel.this.cachedDBAttributesObj.getDBAttribute()) : new ViewAttributes(CreateTableNodeAttributesPanel.this.cachedDBAttributesObj.getDBAttribute());
                    CreateTableNodeAttributesPanel.this.setupItemsTable(generalAttributesTableModel);
                }
            }
        });
        DBAttributes dBAttributes = createTableNodeType.getDBAttributes();
        if (dBAttributes != null && (object2 = dBAttributes.getDBAttribute()) != null && !object2.isEmpty()) {
            for (Object object3 : object2) {
                dBColumnType = new DBColumnType();
                dBColumnType.setAlias(object3.getAlias());
                dBColumnType.setAnnotation(object3.getAnnotation());
                dBColumnType.setDataType(object3.getDataType());
                dBColumnType.setName(object3.getName());
                dBColumnType.setStatus(object3.getStatus());
                dBColumnType.setKey(object3.getKey());
                dBColumnType.setIndex(object3.getIndex());
                this.cachedDBAttributesObj.getDBAttribute().add(dBColumnType);
            }
        }
        if (bl) {
            this.refreshAttributesFromDS();
        }
        object2 = createTableNodeType.isTable() ? new TableAttributes(this.cachedDBAttributesObj.getDBAttribute()) : new ViewAttributes(this.cachedDBAttributesObj.getDBAttribute());
        boolean bl2 = createTableNodeType.isTable();
        this.jRadioButtonTable.setSelected(bl2);
        this.jRadioButtonView.setSelected(!bl2);
        this.setupItemsTable((GeneralAttributesTableModel)((Object)object2));
        object3 = new JScrollPane((Component)this._jAttributesTable);
        this.jAttributesComponent.setComponent((JComponent)object3);
        this.jAttributesComponent.setLabel(new JLabel(PreferencesLrb.get("PI_ATTRUBUTES_GROUP_TITLE")));
        dBColumnType = new ControlBar();
        this.installItemFilterActions((ControlBar)dBColumnType);
        this._editBtn.setEnabled(!bl);
        this._removeBtn.setEnabled(!bl);
        this.jAttributesComponent.setControlBar((ControlBar)dBColumnType);
        this._jAttributesTable.setFillsViewportHeight(true);
        this._originalTableName = createTableNodeType.getTableName();
        if (!StringUtils.isValidNonQuotedDBObjectName(this._originalTableName)) {
            this._originalTableName = StringUtils.addDoubleQuotes(this._originalTableName);
        }
        this.jTextFieldName.setText(this._originalTableName);
        this.jRadioButtonTable.addActionListener(this);
        this.jRadioButtonView.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.jRadioButtonTable) || actionEvent.getSource().equals(this.jRadioButtonView)) {
            boolean bl = this.jRadioButtonTable.isSelected();
            this.reloadAttributes(bl);
        }
    }

    private void reloadAttributes(boolean bl) {
        DBColumnType dBColumnType;
        GeneralAttributesTableModel generalAttributesTableModel;
        int[] nArray = this._jAttributesTable.getSelectedRowsInModel();
        HashMap<String, DBColumnType> hashMap = null;
        if (nArray != null && nArray.length > 0) {
            generalAttributesTableModel = (GeneralAttributesTableModel)((Object)this._jAttributesTable.getModel());
            hashMap = new HashMap<String, DBColumnType>(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                dBColumnType = generalAttributesTableModel.getDataVector().get(nArray[i]);
                hashMap.put(dBColumnType.getName(), dBColumnType);
            }
        }
        generalAttributesTableModel = bl ? new TableAttributes(this.cachedDBAttributesObj.getDBAttribute()) : new ViewAttributes(this.cachedDBAttributesObj.getDBAttribute());
        this.setupItemsTable(generalAttributesTableModel);
        if (hashMap != null) {
            Object object;
            Vector<Integer> vector = new Vector<Integer>();
            dBColumnType = generalAttributesTableModel.getDataVector();
            for (int i = 0; i < dBColumnType.size(); ++i) {
                object = (DBColumnType)dBColumnType.get(i);
                if (null == hashMap.get(object.getName())) continue;
                vector.add(i);
            }
            if (!vector.isEmpty()) {
                Integer[] integerArray = vector.toArray(new Integer[vector.size()]);
                object = new int[integerArray.length];
                for (int i = 0; i < integerArray.length; ++i) {
                    object[i] = (DBColumnType)integerArray[i];
                }
                this._jAttributesTable.setSelectedRowsInModel((int[])object);
            }
        }
    }

    private void installItemFilterActions(ControlBar controlBar) {
        this._editBtn = new JButton(_editIcon);
        String string = InspectorArb.getString((int)25);
        this._editBtn.setToolTipText(string);
        this._editBtn.getAccessibleContext().setAccessibleName(InspectorArb.getString((int)23));
        this._editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    boolean bl;
                    CreateTableNode createTableNode = (CreateTableNode)CreateTableNodeAttributesPanel.this.getData();
                    Dialog dialog = SwingUtils.getAncestorDialog((Component)CreateTableNodeAttributesPanel.this);
                    CreateTableAttributesDialog createTableAttributesDialog = new CreateTableAttributesDialog(CreateTableNodeAttributesPanel.this.cachedDBAttributesObj);
                    createTableAttributesDialog.setParentDialog(dialog);
                    AbstractNode abstractNode = createTableNode.findParentNode();
                    if (abstractNode != null && abstractNode instanceof AbstractDataNode && (bl = createTableAttributesDialog.invoke(CreateTableNodeAttributesPanel.this._context, createTableNode, (AbstractDataNode)abstractNode))) {
                        GeneralAttributesTableModel generalAttributesTableModel = (GeneralAttributesTableModel)((Object)CreateTableNodeAttributesPanel.this._jAttributesTable.getModel());
                        generalAttributesTableModel.fireTableDataChanged();
                    }
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        });
        controlBar.add((Component)this._editBtn);
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.setToolTipText(DataDialogsLrb.get("ATTRIBUTES_TOOLBAR_REMOVE_TOOLTIP"));
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = CreateTableNodeAttributesPanel.this._jAttributesTable.getSelectedRowsInModel();
                if (nArray.length > 0) {
                    GeneralAttributesTableModel generalAttributesTableModel = (GeneralAttributesTableModel)((Object)CreateTableNodeAttributesPanel.this._jAttributesTable.getModel());
                    ArrayList<DBColumnType> arrayList = new ArrayList<DBColumnType>();
                    for (int i = 0; i < nArray.length; ++i) {
                        DBColumnType dBColumnType = generalAttributesTableModel.getDataVector().get(nArray[i]);
                        if (!CreateTableNodeAttributesPanel.this.cachedDBAttributesObj.getDBAttribute().contains(dBColumnType)) continue;
                        arrayList.add(dBColumnType);
                    }
                    if (!arrayList.isEmpty()) {
                        CreateTableNodeAttributesPanel.this.cachedDBAttributesObj.getDBAttribute().removeAll(arrayList);
                        generalAttributesTableModel.fireTableDataChanged();
                    }
                }
            }
        });
        controlBar.add((Component)this._removeBtn);
    }

    private void setupItemsTable(GeneralAttributesTableModel generalAttributesTableModel) {
        this._jAttributesTable.setModel((TableModel)((Object)generalAttributesTableModel));
        this._jAttributesTable.setSorted(true);
        this._jAttributesTable.setSortColumn(0, true);
        this._jAttributesTable.getSelectionModel().addListSelectionListener(new SelectedItemSelectionHandler());
        IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                return IconCellRenderer.getIconForAttrStatus(CreateTableNodeAttributesPanel.this.cachedDBAttributesObj.getDBAttribute(), object);
            }
        });
        TableColumn tableColumn = this._jAttributesTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(iconCellRenderer);
        DBObjectNameEditor dBObjectNameEditor = new DBObjectNameEditor(this._context);
        TableColumn tableColumn2 = null;
        tableColumn2 = this.jRadioButtonTable.isSelected() ? this._jAttributesTable.getColumnModel().getColumn(4) : this._jAttributesTable.getColumnModel().getColumn(2);
        tableColumn2.setCellEditor(dBObjectNameEditor);
        this._jAttributesTable.setAutoResizeMode(0);
        this._jAttributesTable.autoSizeColumnsToFit();
    }

    private void refreshAttributesFromDS() {
        ArrayList<DBColumnType> arrayList = new ArrayList<DBColumnType>();
        HashMap<String, DBColumnType> hashMap = new HashMap<String, DBColumnType>();
        for (DBColumnType dBColumnType : this.cachedDBAttributesObj.getDBAttribute()) {
            hashMap.put(dBColumnType.getName(), dBColumnType);
        }
        if (this.dataProviderAttributes != null) {
            for (AttributeType attributeType : this.dataProviderAttributes) {
                DBColumnType dBColumnType = (DBColumnType)hashMap.get(attributeType.getName());
                if (null != dBColumnType) {
                    arrayList.add(dBColumnType);
                    continue;
                }
                dBColumnType = new DBColumnType();
                dBColumnType.setAlias(attributeType.getAlias());
                dBColumnType.setAnnotation(attributeType.getAnnotation());
                dBColumnType.setDataType(attributeType.getDataType());
                dBColumnType.setName(attributeType.getName());
                dBColumnType.setStatus(attributeType.getStatus());
                dBColumnType.setKey("No");
                dBColumnType.setIndex("No");
                arrayList.add(dBColumnType);
            }
            if (!this.cachedDBAttributesObj.getDBAttribute().isEmpty()) {
                this.cachedDBAttributesObj.getDBAttribute().clear();
            }
            this.cachedDBAttributesObj.getDBAttribute().addAll(arrayList);
        }
    }

    @Override
    public boolean doWork() {
        String string = this.jTextFieldName.getText().trim();
        if (string.length() == 0) {
            MessageDialog.error((Component)this, (Object)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_NAME_MISSING"), (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_ERROR_TITLE"), null);
            return false;
        }
        if (!StringUtils.isDoubleQuotedString(string)) {
            string = string.toUpperCase();
        }
        if (StringUtils.checkDataLossWithMsg(this._context, string, PropertyLrb.get("PI_COMMON_GROUP_NODE_SETTING_ERROR_TITLE"))) {
            return false;
        }
        if (!this._originalTableName.equals(string)) {
            if (!TableNameValidator.isTableNameUnique(this._context, string)) {
                String string2 = MessageFormat.format(DataDialogsLrb.get("TABLE_VALIDATION_ERROR_DUPLICATE"), string);
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)DataDialogsLrb.get("TABLE_VALIDATION_ERROR_TITLE"), null);
                return false;
            }
            if (!TableNameValidator.validateTableName(string, null, this._context, true)) {
                return false;
            }
        }
        string = StringUtils.trimDoubleQuotes(string);
        boolean bl = true;
        CreateTableNode createTableNode = (CreateTableNode)this.getData();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string3 = this.jChkBoxAuto.isSelected() ? "Yes" : "No";
        AutoSpecType autoSpecType = AutoSpecType.fromValue((String)string3);
        hashMap.put("autoSpec", autoSpecType);
        boolean bl2 = this.jRadioButtonTable.isSelected();
        hashMap.put("isTable", bl2);
        hashMap.put("tableName", string);
        DBAttributes dBAttributes = new DBAttributes();
        List list = dBAttributes.getDBAttribute();
        list.addAll(this.cachedDBAttributesObj.getDBAttribute());
        hashMap.put(CreateTableNode.INPUT_COLUMNS, dBAttributes);
        try {
            CommandProcessor.getInstance().beginTrans(NodeMessagesLrb.get("CREATE_TABLE_PROPERTIES"));
            createTableNode.setState(NodeStatusType.READY);
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property("createTableProperties", null, hashMap, null, null));
            arrayList.add(new Property("SQL_EXPRESSION", null, "SQL_EXPRESSION_GENERATE", null, null));
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getData().getUndoFilter();
            odmrSDMUndoFilter.prepareUndoPropertyList(createTableNode, this.getContext(), arrayList);
            createTableNode.validate(true);
            CommandProcessor.getInstance().endTrans();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            CommandProcessor.getInstance().abortTrans();
            bl = false;
        }
        return bl;
    }

    class SelectedItemSelectionHandler
    implements ListSelectionListener {
        SelectedItemSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            CreateTableNodeAttributesPanel.this._removeBtn.setEnabled(!CreateTableNodeAttributesPanel.this.jChkBoxAuto.isSelected() && !listSelectionModel.isSelectionEmpty());
        }
    }

    private class ViewAttributes
    extends GeneralAttributesTableModel {
        ViewAttributes(List<DBColumnType> list) {
            super(list);
            this.setColumnIdentifiers(CreateTableNodeAttributesPanel.this._columnNames_view);
            this.setColumnCount(3);
        }

        @Override
        protected int getAliasColumn() {
            return 2;
        }
    }

    private class TableAttributes
    extends GeneralAttributesTableModel {
        TableAttributes(List<DBColumnType> list) {
            super(list);
            this.setColumnIdentifiers(CreateTableNodeAttributesPanel.this._columnNames_table);
            this.setColumnCount(5);
        }

        @Override
        protected int getAliasColumn() {
            return 4;
        }
    }

    private abstract class GeneralAttributesTableModel
    extends GenericBaseTableModel {
        protected List<DBColumnType> _srcData;

        protected abstract int getAliasColumn();

        GeneralAttributesTableModel(List<DBColumnType> list) {
            this._srcData = list;
            this.setRowCount(this._srcData.size());
        }

        public String getMaxString() {
            String string = "";
            for (int i = 0; i < this._srcData.size(); ++i) {
                DBColumnType dBColumnType = this._srcData.get(i);
                String string2 = dBColumnType.getName();
                if (string2.length() <= string.length()) continue;
                string = string2;
            }
            return string;
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.size() : 0;
        }

        public Vector<DBColumnType> getDataVector() {
            Vector<DBColumnType> vector = new Vector<DBColumnType>();
            vector.addAll(this._srcData);
            return vector;
        }

        public void clearRows() {
            this._srcData.clear();
            this.setRowCount(0);
            this.fireTableDataChanged();
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 != this.getAliasColumn() && n2 != 3 && n2 != 2) {
                return;
            }
            DBColumnType dBColumnType = this._srcData.get(n);
            if (n2 == this.getAliasColumn()) {
                Vector<DBColumnType> vector = new Vector<DBColumnType>();
                vector.addAll(this._srcData);
                vector.remove(dBColumnType);
                String string = null;
                String string2 = dBColumnType.getAlias();
                String string3 = dBColumnType.getName();
                if (object != null) {
                    string = ((String)object).trim();
                }
                if (string2 != null && StringUtils.isDoubleQuotedString(string)) {
                    string2 = StringUtils.addDoubleQuotes(string2);
                }
                if (string.length() != 0) {
                    if (!StringUtils.isDoubleQuotedString(string)) {
                        string = string.toUpperCase();
                    }
                    if (!AttributeNameValidator.validateAttributeName(string, vector, CreateTableNodeAttributesPanel.this._context, true)) {
                        return;
                    }
                } else if (string2 != null && string2.length() != 0 && !AttributeNameValidator.validateAttributeName(string3, vector, CreateTableNodeAttributesPanel.this._context, true)) {
                    return;
                }
                if (string2 != null && string2.compareTo(string) == 0) {
                    return;
                }
                if ((string = StringUtils.trimDoubleQuotes(string)).equals("")) {
                    string = null;
                }
                dBColumnType.setAlias(string);
            } else if (n2 == 2) {
                dBColumnType.setKey(object.equals(true) ? "Yes" : "No");
                if (object.equals(true) && dBColumnType.getIndex().equals("Yes")) {
                    dBColumnType.setIndex("No");
                }
            } else if (n2 == 3) {
                dBColumnType.setIndex(object.equals(true) ? "Yes" : "No");
                if (object.equals(true) && dBColumnType.getKey().equals("Yes")) {
                    dBColumnType.setKey("No");
                }
            }
        }

        public Object getValueAt(int n, int n2) {
            if (this._srcData.isEmpty()) {
                return "";
            }
            DBColumnType dBColumnType = this._srcData.get(n);
            Object object = null;
            if (n2 == 0) {
                object = dBColumnType.getName();
            } else if (n2 == this.getAliasColumn()) {
                object = dBColumnType.getAlias();
            } else if (n2 == 1) {
                object = dBColumnType.getDataType();
            } else if (n2 == 3) {
                boolean bl = CreateTableNodeAttributesPanel.this.jRadioButtonTable.isSelected();
                String string = dBColumnType.getIndex();
                object = string != null && bl ? Boolean.valueOf("Yes".equals(string)) : Boolean.FALSE;
            } else if (n2 == 2) {
                boolean bl = CreateTableNodeAttributesPanel.this.jRadioButtonTable.isSelected();
                String string = dBColumnType.getKey();
                object = string != null && bl ? Boolean.valueOf("Yes".equals(string)) : Boolean.FALSE;
            } else assert (false) : "Out of bounds column when accessing items";
            return object != null ? object : "";
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public void removeSelectedRows(int[] nArray) {
            Vector<DBColumnType> vector = new Vector<DBColumnType>();
            DBColumnType dBColumnType = null;
            for (int i = 0; i < nArray.length; ++i) {
                dBColumnType = this._srcData.get(nArray[i]);
                vector.add(dBColumnType);
            }
            this._srcData.removeAll(vector);
            this.setRowCount(this._srcData.size());
            this.fireTableDataChanged();
        }

        public TableModel getModel() {
            return this;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == this.getAliasColumn()) {
                return true;
            }
            if (n2 == 3 || n2 == 2) {
                if (CreateTableNodeAttributesPanel.this.jChkBoxAuto.isSelected()) {
                    return false;
                }
                DBColumnType dBColumnType = this._srcData.get(n);
                if (!DatabaseMetadataUtils.isTypeSupportedAsTableKey(dBColumnType.getDataType())) {
                    return false;
                }
                boolean bl = CreateTableNodeAttributesPanel.this.jRadioButtonTable.isSelected();
                return bl;
            }
            return false;
        }
    }

    class GenericTableTooltipCustom
    extends DataMinerTable {
        GenericTableTooltipCustom() {
            this.setTooltipEnable(true);
        }

        public void setValueAt(Object object, int n, int n2) {
            super.setValueAt(object, n, n2);
            this.repaint();
        }
    }
}

