/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.CreateTableNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.CreateTableNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DBColumnType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.dialogs.WizardLauncher;
import oracle.javatools.dialogs.ExceptionDialog;

public abstract class DataConsumerAttributesDialog<T extends AbstractDataNode> {
    private static final Logger theLogger = Logger.getLogger(DataConsumerAttributesDialog.class.getName());
    protected String wizName;
    protected Context context = null;
    protected String errorMessage;
    protected Dialog parentDialog;

    protected abstract JEWTDialog buildDialog(Context var1, T var2, AbstractDataNode var3);

    protected JEWTDialog buildDialog(Context context, JPanel jPanel) {
        JEWTDialog jEWTDialog = this.parentDialog != null ? new JEWTDialog(this.parentDialog, this.wizName, 7) : new JEWTDialog((Frame)Ide.getMainWindow(), this.wizName, 7);
        jEWTDialog.setContent((Component)jPanel);
        jEWTDialog.setTitle(this.getDialogTitle());
        this.registerHelp(jEWTDialog);
        return jEWTDialog;
    }

    protected String getDialogTitle() {
        return DataDialogsLrb.get("DIALOG_TITLE");
    }

    public void setParentDialog(Dialog dialog) {
        this.parentDialog = dialog;
    }

    protected abstract void registerHelp(JEWTDialog var1);

    protected List<AttributeType> getAvailableAttributes(final AbstractDataNode abstractDataNode) {
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        class GetAttrs
        extends ProgressRunnable {
            private List<AttributeType> cols;

            GetAttrs() {
            }

            public List<AttributeType> getColumns() {
                return this.cols;
            }

            protected Object doWork() throws Exception {
                if (abstractDataNode instanceof DataProvider) {
                    if (abstractDataNode instanceof CreateTableNode) {
                        CreateTableNodeType createTableNodeType = (CreateTableNodeType)abstractDataNode.getData();
                        if (null != createTableNodeType.getDBAttributes() && null != createTableNodeType.getDBAttributes().getDBAttribute()) {
                            this.cols = DataConsumerAttributesDialog.getCreateColumnDetails(createTableNodeType.getDBAttributes().getDBAttribute());
                        }
                    } else {
                        this.cols = DataConsumerAttributesDialog.getColumnDetails(abstractDataNode.getAttributes().getAttribute());
                    }
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        }
        GetAttrs getAttrs = new GetAttrs();
        getAttrs.setTitle(WorkflowEditorLrb.get("LOAD_AVAIL_ATTRS"));
        getAttrs.setMessage(WorkflowEditorLrb.get("LOAD_AVAIL_ATTRS_DESCR"));
        getAttrs.setCancelable(false);
        try {
            getAttrs.start(true);
            if (null != getAttrs.getColumns()) {
                arrayList.addAll(getAttrs.getColumns());
            }
        }
        catch (ProgressException progressException) {
            theLogger.log(Level.SEVERE, progressException.getMessage(), progressException);
        }
        return arrayList;
    }

    public static List<AttributeType> getColumnDetails(List<AttributeType> list) {
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>(list.size());
        for (AttributeType attributeType : list) {
            AttributeType attributeType2 = new AttributeType();
            attributeType2.setName(attributeType.getName());
            attributeType2.setDataType(attributeType.getDataType());
            attributeType2.setAlias(attributeType.getAlias());
            attributeType2.setAnnotation(attributeType.getAnnotation());
            attributeType2.setStatus(attributeType.getStatus());
            arrayList.add(attributeType2);
        }
        return arrayList;
    }

    public static List<AttributeType> getCreateColumnDetails(List<DBColumnType> list) {
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>(list.size());
        for (DBColumnType dBColumnType : list) {
            DBColumnType dBColumnType2 = new DBColumnType();
            dBColumnType2.setName(dBColumnType.getAlias() != null && !dBColumnType.getAlias().trim().isEmpty() ? dBColumnType.getAlias() : dBColumnType.getName());
            dBColumnType2.setAlias(dBColumnType.getAlias());
            dBColumnType2.setDataType(dBColumnType.getDataType());
            dBColumnType2.setStatus(dBColumnType.getStatus());
            dBColumnType2.setAnnotation(dBColumnType.getAnnotation());
            dBColumnType2.setIndex(dBColumnType.getIndex());
            dBColumnType2.setKey(dBColumnType.getKey());
            arrayList.add((AttributeType)dBColumnType2);
        }
        return arrayList;
    }

    public boolean invoke(Context context, T t) {
        if (t instanceof AbstractDataNode) {
            return this.invoke(context, t, (AbstractDataNode)t);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invoke(Context context, T t, AbstractDataNode abstractDataNode) {
        this.context = context;
        boolean bl = false;
        try {
            JEWTDialog jEWTDialog = this.buildDialog(context, t, abstractDataNode);
            if (jEWTDialog == null) {
                boolean bl2 = false;
                return bl2;
            }
            jEWTDialog.setResizable(true);
            final DataConsumerPanel dataConsumerPanel = (DataConsumerPanel)((Object)jEWTDialog.getContent());
            jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                    String string = propertyChangeEvent.getPropertyName();
                    Object object = propertyChangeEvent.getNewValue();
                    if (string.equals("closed") && Boolean.TRUE.equals(object)) {
                        Object object2 = propertyChangeEvent.getSource();
                        Cursor cursor = null;
                        if (object2 instanceof Container) {
                            cursor = ((Container)object2).getCursor();
                            ((Container)object2).setCursor(new Cursor(3));
                        }
                        boolean bl = dataConsumerPanel.doWork();
                        if (cursor != null) {
                            ((Container)object2).setCursor(cursor);
                        }
                        if (!bl) {
                            throw new PropertyVetoException("panel", propertyChangeEvent);
                        }
                    }
                }
            });
            if (jEWTDialog != null) {
                bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DataDialogsLrb.get("DIALOG_FAIL_TITLE"), (String)DataDialogsLrb.get("DIALOG_FAIL_MSG"), null);
        }
        finally {
            if (!bl) {
                this.cancel();
            }
        }
        return bl;
    }

    protected void cancel() {
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

