/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.comparator.AttributeTypeComparator;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.AttributeNameCellRenderer;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.table.TablePIPropertyLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProfileNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileInputType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;

public class DataProfileAttributesPanel
extends AbstractDialogPanel
implements DataConsumerPanel {
    protected List<AttributeType> availAttrsCache;
    protected List<AttributeType> selectedAttrsCache;
    private List<String> _allowedAttributes = new ArrayList<String>();
    private HashMap<String, AttributeType> _allAttributesMap = new HashMap();
    private static final String DEFAULT_GROUP_VALUE = DataDialogsLrb.get("PROFILE_GROUP_BY_DEFAULT_VALUE");
    private static final String GROUP_VALUE_NONE = DataDialogsLrb.get("PROFILE_GROUP_BY_NONE");
    private DataMinerTablePanel availAttrsPanel;
    private JCheckBox jChkBoxAuto;
    private JComboBox jCmblGroupBy;
    private JLabel jLblGroupBy;
    private JButton jRemoveAllBtn;
    private JButton jRemoveBtn;
    private JButton jSelectAllBtn;
    private JButton jSelectBtn;
    private DataMinerTablePanel selAttrsPanel;

    public DataProfileAttributesPanel(Context context, AbstractNode abstractNode, List<AttributeType> list) {
        super(context, abstractNode);
        this.availAttrsCache = list;
        this.selectedAttrsCache = new ArrayList<AttributeType>();
        for (AttributeType attributeType : this.availAttrsCache) {
            this._allAttributesMap.put(attributeType.getName(), attributeType);
            try {
                if (DatabaseMetadataUtils.isACustomDataType(this._context, attributeType.getDataType())) {
                    continue;
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
                return;
            }
            String string = DatabaseMetadataUtils.getDefaultMiningType(attributeType.getDataType());
            if (!string.equals("Numerical") && !string.equals("Categorical")) continue;
            this._allowedAttributes.add(attributeType.getName());
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jLblGroupBy = new JLabel();
        this.jCmblGroupBy = new JComboBox();
        this.jSelectBtn = new JButton();
        this.jSelectAllBtn = new JButton();
        this.jRemoveBtn = new JButton();
        this.jRemoveAllBtn = new JButton();
        this.jChkBoxAuto = new JCheckBox();
        this.availAttrsPanel = new DataMinerTablePanel();
        this.selAttrsPanel = new DataMinerTablePanel();
        this.jLblGroupBy.setText("Group By:");
        this.jCmblGroupBy.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jSelectBtn.setText(">");
        this.jSelectAllBtn.setText(">>");
        this.jRemoveBtn.setText("<");
        this.jRemoveAllBtn.setText("<<");
        this.jChkBoxAuto.setText("Auto Input Columns Selection");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.jLblGroupBy, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCmblGroupBy, 0, -1, Short.MAX_VALUE).addGap(56, 56, 56)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.availAttrsPanel, -1, 243, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRemoveBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jRemoveAllBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jSelectBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jSelectAllBtn, GroupLayout.Alignment.TRAILING))).addGroup(groupLayout.createSequentialGroup().addComponent(this.jChkBoxAuto, -1, -1, Short.MAX_VALUE).addGap(29, 29, 29))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selAttrsPanel, -1, 247, Short.MAX_VALUE).addContainerGap()));
        groupLayout.linkSize(0, this.jRemoveAllBtn, this.jRemoveBtn, this.jSelectAllBtn, this.jSelectBtn);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblGroupBy).addComponent(this.jCmblGroupBy, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jChkBoxAuto).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selAttrsPanel, -1, 264, Short.MAX_VALUE).addComponent(this.availAttrsPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(45, 45, 45).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(29, 29, 29).addComponent(this.jSelectAllBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveBtn)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jSelectBtn).addGap(64, 64, 64).addComponent(this.jRemoveAllBtn))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.linkSize(1, this.jRemoveAllBtn, this.jRemoveBtn, this.jSelectAllBtn, this.jSelectBtn);
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLblGroupBy, (Component)this.jCmblGroupBy, (String)DataDialogsLrb.get("PROFILE_GROUP_BY_LABEL"));
        ResourceUtils.resButton((AbstractButton)this.jChkBoxAuto, (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_AUTO"));
        this.jChkBoxAuto.setOpaque(false);
        this.initIcons();
    }

    private void initIcons() {
        this.jSelectBtn.setIcon(DataMinerIcons.get(Icons.SHUTTLE_RIGHT));
        this.jSelectAllBtn.setIcon(DataMinerIcons.get(Icons.SHUTTLE_RIGHTALL));
        this.jRemoveBtn.setIcon(DataMinerIcons.get(Icons.SHUTTLE_LEFT));
        this.jRemoveAllBtn.setIcon(DataMinerIcons.get(Icons.SHUTTLE_LEFTALL));
    }

    protected List<AttributeType> getSelectedAttributes() {
        AbstractNode abstractNode = this.getData();
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)abstractNode.getData();
        DataProfileInputType dataProfileInputType = dataProfileNodeType.getDataProfileInput();
        List<Object> list = new ArrayList<AttributeType>();
        if (null != dataProfileInputType.getAttributes()) {
            list = dataProfileInputType.getAttributes().getAttribute();
        }
        return list;
    }

    @Override
    public void initUI() {
        Object object;
        Object object22;
        List<AttributeType> list = this.getSelectedAttributes();
        this.jSelectBtn.setText("");
        this.jSelectAllBtn.setText("");
        this.jRemoveBtn.setText("");
        this.jRemoveAllBtn.setText("");
        for (Object object22 : list) {
            object = (AttributeType)MetaDataHelper.copyMetadataObject(object22);
            this.selectedAttrsCache.add((AttributeType)object);
        }
        String[] stringArray = new String[]{DataDialogsLrb.get("NAME_COLUMN"), DataDialogsLrb.get("DATATYPE_COLUMN")};
        this.removeSelectedAttrs(this.availAttrsCache, this.selectedAttrsCache);
        object22 = new AttrTableModel(this.availAttrsCache, stringArray);
        this.availAttrsPanel.setup((TableModel)object22, DataDialogsLrb.get("AVAILABLE_LABEL"), 0);
        object = this.availAttrsPanel.getTable().getColumnModel().getColumn(0);
        ((TableColumn)object).setModelIndex(100);
        AttributeNameCellRenderer attributeNameCellRenderer = new AttributeNameCellRenderer((Icon)DataMinerIcons.get(Icons.ATTRIBUTE), DataMinerIcons.get(Icons.USAGE_ATTR_INVALID));
        ((TableColumn)object).setCellRenderer(attributeNameCellRenderer);
        AttrTableModel attrTableModel = new AttrTableModel(this.selectedAttrsCache, stringArray);
        this.selAttrsPanel.setup((TableModel)((Object)attrTableModel), DataDialogsLrb.get("SELECTED_LABEL"), 0);
        object = this.selAttrsPanel.getTable().getColumnModel().getColumn(0);
        ((TableColumn)object).setModelIndex(100);
        attributeNameCellRenderer = new AttributeNameCellRenderer((Icon)DataMinerIcons.get(Icons.ATTRIBUTE), DataMinerIcons.get(Icons.USAGE_ATTR_INVALID));
        ((TableColumn)object).setCellRenderer(attributeNameCellRenderer);
        this.jSelectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataProfileAttributesPanel.this.moveItems(DataProfileAttributesPanel.this.availAttrsPanel.getTable(), DataProfileAttributesPanel.this.selAttrsPanel.getTable(), false);
            }
        });
        this.jSelectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataProfileAttributesPanel.this.moveItems(DataProfileAttributesPanel.this.availAttrsPanel.getTable(), DataProfileAttributesPanel.this.selAttrsPanel.getTable(), true);
            }
        });
        this.jRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataProfileAttributesPanel.this.moveItems(DataProfileAttributesPanel.this.selAttrsPanel.getTable(), DataProfileAttributesPanel.this.availAttrsPanel.getTable(), false);
            }
        });
        this.jRemoveAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataProfileAttributesPanel.this.moveItems(DataProfileAttributesPanel.this.selAttrsPanel.getTable(), DataProfileAttributesPanel.this.availAttrsPanel.getTable(), true);
            }
        });
        this.jLblGroupBy.setLabelFor(this.jCmblGroupBy);
        Collections.sort(this._allowedAttributes);
        Vector<String> vector = new Vector<String>(this._allowedAttributes);
        vector.add(0, DEFAULT_GROUP_VALUE);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(vector);
        String string = DEFAULT_GROUP_VALUE;
        AbstractDataNode abstractDataNode = (AbstractDataNode)this.getData();
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)abstractDataNode.getData();
        DataProfileInputType dataProfileInputType = dataProfileNodeType.getDataProfileInput();
        AttributeType attributeType = dataProfileInputType.getGroupByAttribute();
        if (null != attributeType) {
            string = attributeType.getName();
            if (-1 == this._allowedAttributes.indexOf(string)) {
                defaultComboBoxModel.addElement(string);
            }
            if (!attributeType.getStatus().equals((Object)AttributeStatus.VALID)) {
                this.jLblGroupBy.setIcon(DataMinerIcons.get(Icons.USAGE_ATTR_INVALID));
            }
            defaultComboBoxModel.removeElementAt(0);
            defaultComboBoxModel.insertElementAt(GROUP_VALUE_NONE, 0);
        } else {
            this.jLblGroupBy.setIcon(null);
        }
        this.jCmblGroupBy.setModel(defaultComboBoxModel);
        this.jCmblGroupBy.setSelectedItem(string);
        this.jCmblGroupBy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)DataProfileAttributesPanel.this.jCmblGroupBy.getSelectedItem();
                if (string.equals(GROUP_VALUE_NONE)) {
                    DataProfileAttributesPanel.this.jCmblGroupBy.removeItemAt(0);
                    DataProfileAttributesPanel.this.jCmblGroupBy.insertItemAt(DEFAULT_GROUP_VALUE, 0);
                    DataProfileAttributesPanel.this.jCmblGroupBy.setSelectedItem(DEFAULT_GROUP_VALUE);
                    DataProfileAttributesPanel.this.jLblGroupBy.setIcon(null);
                    return;
                }
                AttributeType attributeType = (AttributeType)DataProfileAttributesPanel.this._allAttributesMap.get(string);
                if (attributeType == null) {
                    DataProfileAttributesPanel.this.jLblGroupBy.setIcon(DataMinerIcons.get(Icons.USAGE_ATTR_INVALID));
                    return;
                }
                DataProfileAttributesPanel.this.jCmblGroupBy.removeItemAt(0);
                DataProfileAttributesPanel.this.jCmblGroupBy.insertItemAt(GROUP_VALUE_NONE, 0);
                boolean bl = attributeType.getStatus().equals((Object)AttributeStatus.VALID);
                DataProfileAttributesPanel.this.jLblGroupBy.setIcon(bl ? null : DataMinerIcons.get(Icons.USAGE_ATTR_INVALID));
            }
        });
        boolean bl = 0 == dataProfileNodeType.getAutoSpec().value().compareTo("Yes");
        this.jChkBoxAuto.setSelected(bl);
        this.jSelectBtn.setEnabled(!bl);
        this.jSelectAllBtn.setEnabled(!bl);
        this.jRemoveBtn.setEnabled(!bl);
        this.jRemoveAllBtn.setEnabled(!bl);
        this.jChkBoxAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = DataProfileAttributesPanel.this.jChkBoxAuto.isSelected();
                DataProfileAttributesPanel.this.jSelectBtn.setEnabled(!bl);
                DataProfileAttributesPanel.this.jSelectAllBtn.setEnabled(!bl);
                DataProfileAttributesPanel.this.jRemoveBtn.setEnabled(!bl);
                DataProfileAttributesPanel.this.jRemoveAllBtn.setEnabled(!bl);
                if (bl) {
                    DataProfileAttributesPanel.this.moveItems(DataProfileAttributesPanel.this.availAttrsPanel.getTable(), DataProfileAttributesPanel.this.selAttrsPanel.getTable(), true);
                    String string = (String)DataProfileAttributesPanel.this.jCmblGroupBy.getSelectedItem();
                    if (string.equals(DEFAULT_GROUP_VALUE)) {
                        DataProfileAttributesPanel.this.jLblGroupBy.setIcon(null);
                    } else {
                        AttributeType attributeType = (AttributeType)DataProfileAttributesPanel.this._allAttributesMap.get(string);
                        if (attributeType == null) {
                            DataProfileAttributesPanel.this.jCmblGroupBy.removeItemAt(0);
                            DataProfileAttributesPanel.this.jCmblGroupBy.insertItemAt(DEFAULT_GROUP_VALUE, 0);
                            DataProfileAttributesPanel.this.jCmblGroupBy.setSelectedItem(DEFAULT_GROUP_VALUE);
                            DataProfileAttributesPanel.this.jLblGroupBy.setIcon(null);
                        }
                    }
                }
            }
        });
    }

    private void moveItems(GenericTable genericTable, GenericTable genericTable2, boolean bl) {
        int n;
        Object object2;
        int n2;
        int[] nArray = genericTable.getSelectedRowsInModel();
        List<AttributeType> list = ((AttrTableModel)((Object)genericTable.getModel())).getDataList();
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        if (!bl) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                object2 = list.get(nArray[n2]);
                arrayList.add((AttributeType)object2);
            }
        } else {
            for (n2 = 0; n2 < list.size(); ++n2) {
                arrayList.add(list.get(n2));
            }
        }
        for (Object object2 : arrayList) {
            n = list.indexOf(object2);
            if (n == -1) continue;
            list.remove(n);
        }
        List<AttributeType> list2 = ((AttrTableModel)((Object)genericTable2.getModel())).getDataList();
        list2.addAll(arrayList);
        ((AttrTableModel)((Object)genericTable2.getModel())).setRowCount(list2.size());
        ((AttrTableModel)((Object)genericTable.getModel())).setRowCount(list.size());
        ((AbstractTableModel)genericTable.getModel()).fireTableDataChanged();
        ((AbstractTableModel)genericTable2.getModel()).fireTableDataChanged();
        object2 = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            int n3 = list2.indexOf(arrayList.get(n));
            object2[n] = (AttributeType)n3;
        }
        genericTable2.setSelectedRowsInModel((int[])object2);
    }

    private void removeSelectedAttrs(List<AttributeType> list, List<AttributeType> list2) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType : list2) {
            hashMap.put(attributeType.getName(), attributeType);
        }
        Iterator<AttributeType> iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeType attributeType;
            attributeType = iterator.next();
            AttributeType attributeType2 = (AttributeType)hashMap.get(attributeType.getName());
            if (attributeType2 == null || !attributeType2.getName().equals(attributeType.getName()) || !attributeType2.getDataType().equals(attributeType.getDataType())) continue;
            iterator.remove();
        }
    }

    @Override
    public boolean doWork() {
        boolean bl = true;
        return bl;
    }

    public List<Property> getResults() {
        DataProfileInputType dataProfileInputType = new DataProfileInputType();
        Attributes attributes = new Attributes();
        dataProfileInputType.setAttributes(attributes);
        String string = this.jCmblGroupBy.getSelectedItem().toString();
        AttributeType attributeType = this._allAttributesMap.get(string);
        dataProfileInputType.setGroupByAttribute(attributeType);
        List list = attributes.getAttribute();
        list.addAll(this.selectedAttrsCache);
        ArrayList<Property> arrayList = new ArrayList<Property>();
        arrayList.add(new Property(DataProfileNode.DATAPROFILE_INPUT, null, dataProfileInputType, null, null));
        String string2 = this.jChkBoxAuto.isSelected() ? "Yes" : "No";
        AutoSpecType autoSpecType = AutoSpecType.fromValue((String)string2);
        arrayList.add(new Property(String.valueOf("autoSpec"), null, autoSpecType, null, null));
        arrayList.add(new Property("SQL_EXPRESSION", null, "SQL_EXPRESSION_GENERATE", null, null));
        return arrayList;
    }

    class AttrTableModel
    extends GenericBaseTableModel {
        private List<AttributeType> _data;
        public static final int ATTRIBUTE = 100;
        public static final int ATTRIBUTE_NAME = 0;
        private static final int DATA_TYPE = 1;
        private static final int COLUMN_COUNT = 2;

        public AttrTableModel(List<AttributeType> list, String[] stringArray) {
            this._data = list;
            this.setColumnIdentifiers(stringArray);
            this.setRowCount(this._data.size());
            this.setColumnCount(2);
        }

        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Object getValueAt(int n, int n2) {
            Object object = null;
            AttributeType attributeType = this._data.get(n);
            if (100 == n2) {
                object = attributeType;
            } else if (1 == n2) {
                object = attributeType.getDataType();
            } else if (0 == n2) {
                object = attributeType.getName();
            }
            return object;
        }

        public List<AttributeType> getDataList() {
            return this._data;
        }

        public Comparator getColumnSortComparator(int n) {
            switch (n) {
                case 100: {
                    return AttributeTypeComparator.getComparator();
                }
            }
            return super.getColumnSortComparator(n);
        }
    }
}

