/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JTabbedPane;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.data.DataProfileAttributesPanel;
import oracle.dmt.dataminer.workflow.dialog.data.StatisticsSelectionObject;
import oracle.dmt.dataminer.workflow.dialog.data.StatisticsSelectionPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProfileNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.StatsSelection;
import oracle.ide.Context;
import oracle.ide.controller.CommandProcessor;

public class DataProfileMainPanel
extends AbstractDialogPanel
implements DataConsumerPanel {
    private static final String INPUT_TAB_NAME = DataDialogsLrb.get("DATA_EXPLORE_INPUT_TAB");
    private static final String DATA_EXPLORE_STATS_TAB = DataDialogsLrb.get("DATA_EXPLORE_STATS_TAB");
    private DataProfileAttributesPanel profilePanel;
    private StatisticsSelectionPanel statsPanel;
    private List<AttributeType> availableAttrs;
    private JTabbedPane jProfileTabbedPane;

    public DataProfileMainPanel(Context context, AbstractNode abstractNode, List<AttributeType> list) {
        super(context, abstractNode);
        this.availableAttrs = list;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jProfileTabbedPane = new JTabbedPane();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jProfileTabbedPane, GroupLayout.Alignment.TRAILING, -1, 513, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jProfileTabbedPane, GroupLayout.Alignment.TRAILING, -1, 427, Short.MAX_VALUE));
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        this.profilePanel = new DataProfileAttributesPanel(this.getContext(), this.getData(), this.availableAttrs);
        this.jProfileTabbedPane.addTab(INPUT_TAB_NAME, this.profilePanel);
        DataProfileNode dataProfileNode = (DataProfileNode)this.getData();
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)dataProfileNode.getData();
        StatsSelection statsSelection = dataProfileNodeType.getStatsSelection();
        if (statsSelection == null) {
            statsSelection = StatisticsSelectionObject.createDefaultStatsSelection();
        }
        this.statsPanel = new StatisticsSelectionPanel(this.getContext(), statsSelection);
        this.jProfileTabbedPane.addTab(DATA_EXPLORE_STATS_TAB, this.statsPanel);
    }

    @Override
    public boolean doWork() {
        boolean bl = this.profilePanel.doWork();
        if (bl && (bl = this.statsPanel.doWork())) {
            StatsSelection statsSelection = this.statsPanel.getResults();
            List<Property> list = this.profilePanel.getResults();
            list.add(new Property(DataProfileNode.STATS_SELECTION, null, statsSelection, null, null));
            DataProfileNode dataProfileNode = (DataProfileNode)this.getData();
            try {
                CommandProcessor.getInstance().beginTrans(DataProfileNode.DATAPROFILE_INPUT);
                dataProfileNode.setState(NodeStatusType.READY);
                OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getData().getUndoFilter();
                odmrSDMUndoFilter.prepareUndoPropertyList(dataProfileNode, this.getContext(), list);
                dataProfileNode.validate(true);
                CommandProcessor.getInstance().endTrans();
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getMessage(), exception);
                CommandProcessor.getInstance().abortTrans();
                bl = false;
            }
        }
        return bl;
    }
}

