/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerAttributesDialog;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceAttributesPanel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.DataSourceNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TableType;
import oracle.ide.Context;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.help.HelpSystem;

public class DataSourceAttributesDialog
extends DataConsumerAttributesDialog<DataSourceNode> {
    private static final Logger theLogger = Logger.getLogger(DataSourceAttributesDialog.class.getName());
    private boolean checkForUnderlyingTable = true;
    private boolean showChangeDs = false;

    public DataSourceAttributesDialog() {
        this.wizName = "Edit data source node";
    }

    @Override
    protected JEWTDialog buildDialog(Context context, DataSourceNode dataSourceNode, AbstractDataNode abstractDataNode) {
        List<AttributeType> list = this.getAvailableAttributes(abstractDataNode);
        if (this.checkForUnderlyingTable && list.isEmpty()) {
            DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)abstractDataNode.getData();
            TableType tableType = dataSourceNodeType.getSourceTable();
            String string = tableType.getSchema();
            String string2 = tableType.getName();
            this.errorMessage = MessageFormat.format(DataDialogsLrb.get("TABLE_VALIDATION_ERROR_MISSING"), string + "." + string2);
            return null;
        }
        DataSourceAttributesPanel dataSourceAttributesPanel = new DataSourceAttributesPanel(context, dataSourceNode, list);
        dataSourceAttributesPanel.setShowChangeDs(this.showChangeDs);
        JEWTDialog jEWTDialog = super.buildDialog(context, (JPanel)((Object)dataSourceAttributesPanel));
        dataSourceAttributesPanel.setDataSourceAttrsDialog(jEWTDialog);
        return jEWTDialog;
    }

    @Override
    protected String getDialogTitle() {
        return DataDialogsLrb.get("DATA_SOURCE_DIALOG_TITLE");
    }

    @Override
    protected List<AttributeType> getAvailableAttributes(final AbstractDataNode abstractDataNode) {
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        class GetAttrs
        extends ProgressRunnable {
            private Vector<Vector> cols;

            GetAttrs() {
            }

            public Vector<Vector> getColumns() {
                return this.cols;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doWork() throws Exception {
                Boolean bl = Boolean.FALSE;
                Connection connection = null;
                String string = null;
                String string2 = null;
                try {
                    connection = Connections.getUniqueConnection(DataSourceAttributesDialog.this.context);
                    DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)abstractDataNode.getData();
                    TableType tableType = dataSourceNodeType.getSourceTable();
                    string = tableType.getSchema();
                    string2 = tableType.getName();
                    this.cols = DatabaseMetadataUtils.getColumnDetails(connection, string, string2);
                    bl = Boolean.TRUE;
                }
                catch (Exception exception) {
                    try {
                        theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                    }
                    catch (Throwable throwable) {
                        SQLHelper.close(connection);
                        throw throwable;
                    }
                    SQLHelper.close(connection);
                }
                SQLHelper.close(connection);
                return bl;
            }
        }
        GetAttrs getAttrs = new GetAttrs();
        getAttrs.setTitle(WorkflowEditorLrb.get("LOAD_AVAIL_ATTRS"));
        getAttrs.setMessage(WorkflowEditorLrb.get("LOAD_AVAIL_ATTRS_DESCR"));
        getAttrs.setCancelable(false);
        try {
            getAttrs.start(true);
            Vector<Vector> vector = getAttrs.getColumns();
            if (vector != null && !vector.isEmpty()) {
                for (Vector vector2 : vector) {
                    AttributeType attributeType = new AttributeType();
                    attributeType.setName((String)vector2.get(0));
                    attributeType.setDataType((String)vector2.get(1));
                    attributeType.setStatus(AttributeStatus.VALID);
                    arrayList.add(attributeType);
                }
            }
        }
        catch (ProgressException progressException) {
            theLogger.log(Level.SEVERE, progressException.getMessage(), progressException);
        }
        return arrayList;
    }

    @Override
    protected void registerHelp(JEWTDialog jEWTDialog) {
        HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "dm_datasource_edit_columns");
    }

    public void setCheckForUnderlyingTable(boolean bl) {
        this.checkForUnderlyingTable = bl;
    }

    public void setShowChangeDs(boolean bl) {
        this.showChangeDs = bl;
    }
}

