/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.comparator.AttributeTypeComparator;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.AttributeNameCellRenderer;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceWizard;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceWizardModel;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceWizardPage;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataSourceNode;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericTable;

public class DataSourceAttributesPanel
extends DataSourceWizardPage
implements DataminerGUIPanel,
DataConsumerPanel {
    private static final Logger theLogger = Logger.getLogger(DataSourceAttributesPanel.class.getName());
    protected List<AttributeType> availAttrsTotal;
    protected List<AttributeType> availAttrsCache;
    protected Map<String, AttributeType> availAttrsCacheMap;
    protected List<AttributeType> selectedAttrsCache;
    private Context _context;
    private AbstractNode _node;
    private boolean _wizardMode = false;
    private boolean showChangeDS = false;
    private JEWTDialog dsDialog;
    private DataMinerTablePanel availAttrsPanel;
    private JButton jChangeDsBtn;
    private JLabel jChangeDsLbl;
    private JButton jRemoveAllBtn;
    private JButton jRemoveBtn;
    private JButton jSelectAllBtn;
    private JButton jSelectBtn;
    private JTextField jTableTxt;
    private DataMinerTablePanel selAttrsPanel;

    public DataSourceAttributesPanel(Context context, AbstractNode abstractNode, List<AttributeType> list, boolean bl) {
        assert (list != null) : "Available attribute collection must not be null";
        this.availAttrsCache = new ArrayList<AttributeType>();
        this.availAttrsCacheMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType : list) {
            AttributeType attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType);
            this.availAttrsCache.add(attributeType2);
            this.availAttrsCacheMap.put(attributeType2.getName(), attributeType2);
        }
        this.availAttrsTotal = new ArrayList<AttributeType>();
        this.availAttrsTotal.addAll(list);
        this.selectedAttrsCache = new ArrayList<AttributeType>();
        this._context = context;
        this._node = abstractNode;
        this.initComponents();
        this.initRes();
        if (!bl) {
            this.initUI();
        }
    }

    public DataSourceAttributesPanel(Context context, AbstractNode abstractNode, List<AttributeType> list) {
        this(context, abstractNode, list, false);
    }

    public DataSourceAttributesPanel() {
        this.availAttrsCache = new ArrayList<AttributeType>();
        this.availAttrsCacheMap = new HashMap<String, AttributeType>();
        this.availAttrsTotal = new ArrayList<AttributeType>();
        this.selectedAttrsCache = new ArrayList<AttributeType>();
        this._context = null;
        this._node = null;
        this._wizardMode = true;
        this.initComponents();
        this.initRes();
    }

    private void initComponents() {
        this.jSelectBtn = new JButton();
        this.jSelectAllBtn = new JButton();
        this.jRemoveBtn = new JButton();
        this.jRemoveAllBtn = new JButton();
        this.availAttrsPanel = new DataMinerTablePanel();
        this.selAttrsPanel = new DataMinerTablePanel();
        this.jChangeDsBtn = new JButton();
        this.jChangeDsLbl = new JLabel();
        this.jTableTxt = new JTextField();
        this.jSelectBtn.setText(">");
        this.jSelectAllBtn.setText(">>");
        this.jRemoveBtn.setText("<");
        this.jRemoveAllBtn.setText("<<");
        this.jChangeDsBtn.setText("...");
        this.jChangeDsLbl.setText("Data Source");
        this.jTableTxt.setEnabled(false);
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.availAttrsPanel, -1, 282, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSelectBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jSelectAllBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jRemoveBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jRemoveAllBtn, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.selAttrsPanel, -1, 282, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jChangeDsLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTableTxt).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jChangeDsBtn))).addGap(5, 5, 5)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(66, 66, 66).addComponent(this.jSelectBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSelectAllBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveAllBtn).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jChangeDsBtn).addComponent(this.jChangeDsLbl).addComponent(this.jTableTxt, -2, -1, -2)).addGap(8, 8, 8).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.availAttrsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.selAttrsPanel, -1, 264, Short.MAX_VALUE)).addGap(5, 5, 5)));
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jChangeDsLbl, (Component)this.jTableTxt, (String)DataDialogsLrb.get("DATA_SOURCE_LABEL"));
        ResourceUtils.resButton((AbstractButton)this.jChangeDsBtn, (String)DataDialogsLrb.get("EDIT_SOURCE_BTN"));
        if (this._node != null && this._node.getData() instanceof DataSourceNodeType) {
            DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)this._node.getData();
            AbstractDataNode.TablePropertyValue tablePropertyValue = new AbstractDataNode.TablePropertyValue(dataSourceNodeType.getSourceTable().getSchema(), dataSourceNodeType.getSourceTable().getName());
            this.jTableTxt.setText(tablePropertyValue.toString());
        }
        this.initIcons();
    }

    private void initIcons() {
        this.jSelectBtn.setIcon(DataMinerIcons.get(Icons.SHUTTLE_RIGHT));
        this.jSelectAllBtn.setIcon(DataMinerIcons.get(Icons.SHUTTLE_RIGHTALL));
        this.jRemoveBtn.setIcon(DataMinerIcons.get(Icons.SHUTTLE_LEFT));
        this.jRemoveAllBtn.setIcon(DataMinerIcons.get(Icons.SHUTTLE_LEFTALL));
    }

    protected List<AttributeType> getSelectedAttributes() {
        AbstractDataNode abstractDataNode = (AbstractDataNode)this.getData();
        DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)abstractDataNode.getData();
        List list = dataSourceNodeType.getAttributes().getAttribute();
        return list;
    }

    public void initUINonWizard() {
        List<AttributeType> list = this.getSelectedAttributes();
        Collections.sort(list, AttributeTypeComparator.getComparator());
        boolean bl = this.availAttrsCache.isEmpty();
        for (AttributeType attributeType : list) {
            AttributeType attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType);
            if (bl) {
                attributeType2.setStatus(AttributeStatus.MISSING);
            }
            if (null == this.availAttrsCacheMap.get(attributeType2.getName())) {
                attributeType2.setStatus(AttributeStatus.MISSING);
            } else if (attributeType2.getStatus().equals((Object)AttributeStatus.MISSING)) {
                attributeType2.setStatus(AttributeStatus.VALID);
            }
            this.selectedAttrsCache.add(attributeType2);
        }
        this.addInvalidAttributes();
        this.removeSelectedAttrs(this.availAttrsCache, this.selectedAttrsCache);
    }

    public void initUIWizard() {
        DataSourceWizardModel dataSourceWizardModel = this.getModel(this.getTraversableContext());
        this.availAttrsCache = dataSourceWizardModel.getAvailableColumns();
        for (AttributeType attributeType : this.availAttrsTotal) {
            this.availAttrsCacheMap.put(attributeType.getName(), attributeType);
        }
        this.availAttrsTotal.clear();
        this.availAttrsTotal.addAll(this.availAttrsCache);
        this.selectedAttrsCache = dataSourceWizardModel.getSelectedColumns();
        this.addInvalidAttributes();
    }

    private void addInvalidAttributes() {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>(this.availAttrsTotal.size());
        for (AttributeType attributeType : this.availAttrsTotal) {
            hashMap.put(attributeType.getName(), attributeType);
        }
        for (AttributeType attributeType : this.selectedAttrsCache) {
            if (null != hashMap.get(attributeType.getName())) continue;
            this.availAttrsTotal.add(attributeType);
            hashMap.put(attributeType.getName(), attributeType);
        }
    }

    protected void enableButtons(boolean bl) {
        this.jSelectBtn.setEnabled(bl);
        this.jSelectAllBtn.setEnabled(bl);
        this.jRemoveBtn.setEnabled(bl);
        this.jRemoveAllBtn.setEnabled(bl);
    }

    @Override
    public void initUI() {
        if (this._wizardMode) {
            this.initUIWizard();
        } else {
            this.initUINonWizard();
        }
        if (!this.isUiInitialized()) {
            this.jSelectBtn.setText("");
            this.jSelectAllBtn.setText("");
            this.jRemoveBtn.setText("");
            this.jRemoveAllBtn.setText("");
            this.jSelectBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DataSourceAttributesPanel.this.moveItems(DataSourceAttributesPanel.this.availAttrsPanel.getTable(), DataSourceAttributesPanel.this.selAttrsPanel.getTable(), false);
                }
            });
            this.jSelectAllBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DataSourceAttributesPanel.this.moveItems(DataSourceAttributesPanel.this.availAttrsPanel.getTable(), DataSourceAttributesPanel.this.selAttrsPanel.getTable(), true);
                }
            });
            this.jRemoveBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DataSourceAttributesPanel.this.moveItems(DataSourceAttributesPanel.this.selAttrsPanel.getTable(), DataSourceAttributesPanel.this.availAttrsPanel.getTable(), false);
                }
            });
            this.jRemoveAllBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DataSourceAttributesPanel.this.moveItems(DataSourceAttributesPanel.this.selAttrsPanel.getTable(), DataSourceAttributesPanel.this.availAttrsPanel.getTable(), true);
                }
            });
            this.initializeTables();
            this.jSelectBtn.setEnabled(false);
            this.jRemoveBtn.setEnabled(false);
            this.availAttrsPanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    boolean bl = !listSelectionModel.isSelectionEmpty() && !DataSourceAttributesPanel.this.isAutoSpec();
                    DataSourceAttributesPanel.this.jSelectBtn.setEnabled(bl);
                }
            });
            this.availAttrsPanel.getTable().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        DataSourceAttributesPanel.this.moveItems(DataSourceAttributesPanel.this.availAttrsPanel.getTable(), DataSourceAttributesPanel.this.selAttrsPanel.getTable(), false);
                    }
                }
            });
            this.selAttrsPanel.getTable().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        DataSourceAttributesPanel.this.moveItems(DataSourceAttributesPanel.this.selAttrsPanel.getTable(), DataSourceAttributesPanel.this.availAttrsPanel.getTable(), false);
                    }
                }
            });
            this.selAttrsPanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    boolean bl = !listSelectionModel.isSelectionEmpty() && !DataSourceAttributesPanel.this.isAutoSpec();
                    DataSourceAttributesPanel.this.jRemoveBtn.setEnabled(bl);
                }
            });
            this.jChangeDsBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DataSourceAttributesPanel.this.dsDialog.closeDialog(true);
                    DataSourceWizard dataSourceWizard = new DataSourceWizard();
                    dataSourceWizard.runWizard((Component)Ide.getMainWindow(), DataSourceAttributesPanel.this._context, (AbstractDataNode)DataSourceAttributesPanel.this._node);
                }
            });
        } else {
            this.initializeTables();
        }
        this.jChangeDsBtn.setVisible(this.showChangeDS);
        this.jChangeDsLbl.setVisible(this.showChangeDS);
        this.jTableTxt.setVisible(this.showChangeDS);
    }

    protected boolean isAutoSpec() {
        return false;
    }

    private void removeInvalidDataTypes(List<AttributeType> list) {
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        for (AttributeType attributeType : list) {
            if (DatabaseMetadataUtils.isDataTypeSupported(attributeType.getDataType())) continue;
            arrayList.add(attributeType);
        }
        list.removeAll(arrayList);
    }

    private void initializeTables() {
        this.removeInvalidDataTypes(this.availAttrsCache);
        AttrTableModel attrTableModel = new AttrTableModel(this.availAttrsCache);
        this.setupAvialableTable(attrTableModel);
        AttrTableModel attrTableModel2 = new AttrTableModel(this.selectedAttrsCache);
        this.setupSelectedTable(attrTableModel2);
    }

    private void setupSelectedTable(AttrTableModel attrTableModel) {
        this.selAttrsPanel.setup((TableModel)((Object)attrTableModel), DataDialogsLrb.get("SELECTED_LABEL"), 0);
        if (this.selAttrsPanel.getTable().getRowCount() == 0) {
            this.jRemoveAllBtn.setEnabled(false);
        }
        this.selAttrsPanel.getTable().getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (DataSourceAttributesPanel.this.selAttrsPanel.getTable().getRowCount() == 0) {
                    DataSourceAttributesPanel.this.jRemoveAllBtn.setEnabled(false);
                } else {
                    DataSourceAttributesPanel.this.jRemoveAllBtn.setEnabled(true);
                }
            }
        });
        TableColumn tableColumn = this.selAttrsPanel.getTable().getColumnModel().getColumn(0);
        tableColumn.setModelIndex(100);
        AttributeNameCellRenderer attributeNameCellRenderer = new AttributeNameCellRenderer(null, DataMinerIcons.get(Icons.USAGE_ATTR_INVALID));
        tableColumn.setCellRenderer(attributeNameCellRenderer);
    }

    private void setupAvialableTable(AttrTableModel attrTableModel) {
        this.availAttrsPanel.setup((TableModel)((Object)attrTableModel), DataDialogsLrb.get("AVAILABLE_LABEL"), 0);
        if (this.availAttrsPanel.getTable().getRowCount() == 0) {
            this.jSelectAllBtn.setEnabled(false);
        }
        this.availAttrsPanel.getTable().getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (DataSourceAttributesPanel.this.availAttrsPanel.getTable().getRowCount() == 0) {
                    DataSourceAttributesPanel.this.jSelectAllBtn.setEnabled(false);
                } else {
                    DataSourceAttributesPanel.this.jSelectAllBtn.setEnabled(true);
                }
            }
        });
        TableColumn tableColumn = this.availAttrsPanel.getTable().getColumnModel().getColumn(0);
        tableColumn.setModelIndex(100);
        AttributeNameCellRenderer attributeNameCellRenderer = new AttributeNameCellRenderer(null, DataMinerIcons.get(Icons.USAGE_ATTR_INVALID));
        tableColumn.setCellRenderer(attributeNameCellRenderer);
    }

    private void moveItems(GenericTable genericTable, GenericTable genericTable2, boolean bl) {
        Object object;
        int n;
        int[] nArray = genericTable.getSelectedRowsInModel();
        List list = ((AttrTableModel)((Object)genericTable.getModel())).getSrcData();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (!bl) {
            for (n = 0; n < nArray.length; ++n) {
                object = (AttributeType)list.get(nArray[n]);
                arrayList.add(object);
            }
        } else {
            for (n = 0; n < list.size(); ++n) {
                arrayList.add(list.get(n));
            }
        }
        ((AttrTableModel)((Object)genericTable.getModel())).removeRows(arrayList);
        ((AttrTableModel)((Object)genericTable2.getModel())).addRows(arrayList);
        List list2 = ((AttrTableModel)((Object)genericTable2.getModel())).getSrcData();
        object = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            int n2 = list2.indexOf(arrayList.get(i));
            assert (n2 != -1) : "Unexpected state - added item should be present and must have an index";
            object[i] = (AttributeType)n2;
        }
        genericTable2.setSelectedRowsInModel((int[])object);
    }

    private void removeSelectedAttrs(List<AttributeType> list, List<AttributeType> list2) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType : list2) {
            hashMap.put(attributeType.getName(), attributeType);
        }
        Iterator<AttributeType> iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeType attributeType;
            attributeType = iterator.next();
            AttributeType attributeType2 = (AttributeType)hashMap.get(attributeType.getName());
            if (attributeType2 == null || !attributeType2.getName().equals(attributeType.getName()) || !attributeType2.getDataType().equals(attributeType.getDataType())) continue;
            iterator.remove();
        }
    }

    @Override
    public String getPageDirtyKey() {
        return "columnsDirty";
    }

    @Override
    protected boolean doValidation(TraversableContext traversableContext) {
        boolean bl = true;
        if (traversableContext.getDirection() == 2) {
            this.selectedAttrsCache.clear();
            this.availAttrsCache.clear();
            this.availAttrsCacheMap.clear();
            return true;
        }
        if (this.selectedAttrsCache.isEmpty()) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataDialogsLrb.get("COLUMN_CHOOSER_ERROR_MSG_NO_COLUMNS"), (String)DataDialogsLrb.get("COLUMN_CHOOSER_FAILURE_TITLE"), null);
            bl = false;
            return bl;
        }
        for (AttributeType attributeType : this.selectedAttrsCache) {
            if (!attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) continue;
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataDialogsLrb.get("COLUMN_CHOOSER_ERROR_MSG_INVALID_COLUMNS"), (String)DataDialogsLrb.get("COLUMN_CHOOSER_FAILURE_TITLE"), null);
            bl = false;
            return bl;
        }
        return bl;
    }

    public AbstractNode getData() {
        return this._node;
    }

    public Context getContext() {
        return this._context;
    }

    public void setShowChangeDs(boolean bl) {
        this.showChangeDS = bl;
        this.jChangeDsBtn.setVisible(this.showChangeDS);
        this.jChangeDsLbl.setVisible(this.showChangeDS);
        this.jTableTxt.setVisible(this.showChangeDS);
    }

    public void setDataSourceAttrsDialog(JEWTDialog jEWTDialog) {
        this.dsDialog = jEWTDialog;
    }

    @Override
    public boolean doWork() {
        boolean bl = true;
        DataSourceNode dataSourceNode = (DataSourceNode)this.getData();
        Attributes attributes = new Attributes();
        List list = attributes.getAttribute();
        list.addAll(this.selectedAttrsCache);
        try {
            CommandProcessor.getInstance().beginTrans(NodeMessagesLrb.get("DATASRC_INPUT"));
            ArrayList<ComplexProperty> arrayList = new ArrayList<ComplexProperty>();
            ComplexProperty complexProperty = new ComplexProperty("dataSourceAttributes", attributes);
            complexProperty.setOldData(dataSourceNode.getAttributes());
            arrayList.add(complexProperty);
            ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
            complexProperty2.setOldData(dataSourceNode.getSQLExpression());
            arrayList.add(complexProperty2);
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getData().getUndoFilter();
            odmrSDMUndoFilter.prepareUndoComplexPropertyList(dataSourceNode, this.getContext(), arrayList);
            dataSourceNode.validate(true);
            CommandProcessor.getInstance().endTrans();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            CommandProcessor.getInstance().abortTrans();
            bl = false;
        }
        return bl;
    }

    class AttrTableModel
    extends ODMrTableModel<AttributeType> {
        private static final int NAME = 0;
        private static final int DATA_TYPE = 1;
        private static final int ATTRIBUTE = 100;
        private final String[] COL_NAMES;

        public AttrTableModel(List<AttributeType> list) {
            super(list);
            this.COL_NAMES = new String[]{DataDialogsLrb.get("NAME_COLUMN"), DataDialogsLrb.get("DATATYPE_COLUMN")};
            this.setColumnIdentifiers(this.COL_NAMES);
        }

        public Object getValueAt(int n, int n2) {
            Object object = null;
            AttributeType attributeType = (AttributeType)this.srcData.get(n);
            if (100 == n2) {
                object = attributeType;
            } else if (1 == n2) {
                object = attributeType.getDataType();
            } else if (0 == n2) {
                object = attributeType.getName();
            }
            return object;
        }

        public Comparator getColumnSortComparator(int n) {
            switch (n) {
                case 100: {
                    return AttributeTypeComparator.getComparator();
                }
            }
            return super.getColumnSortComparator(n);
        }
    }
}

