/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.utils.HTMLStringUtils;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataProfileModeSelectionDialog;
import oracle.dmt.dataminer.workflow.dialog.data.DataProfileStatisticsTableModel;
import oracle.dmt.dataminer.workflow.dialog.data.StatisticsSelectionObject;
import oracle.dmt.dataminer.workflow.dialog.data.StatsisticSelection;
import oracle.dmt.dataminer.workflow.xmlschema.StatsSelection;
import oracle.ide.Context;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.SwingUtils;

public class StatisticsSelectionPanel
extends DataMinerTablePanel
implements DataConsumerPanel,
StatsisticSelection {
    protected Context _context;
    protected StatsSelection _statsSelection;
    private StatisticsSelectionObject _statsDescriptionObj;
    private Map<String, Boolean> _statsSelectionMap = new HashMap<String, Boolean>();
    private JLabel _restoreDefaults;

    public StatsSelection getStatsSelection() {
        return this._statsSelection;
    }

    public Context getContext() {
        return this._context;
    }

    public StatisticsSelectionPanel(Context context, StatsSelection statsSelection) {
        this._context = context;
        this._statsSelection = statsSelection;
        this._statsDescriptionObj = new StatisticsSelectionObject(this);
        this.initializeStatsFromMetadata(statsSelection);
        this.initUI();
    }

    public void initializeStatsFromMetadata(StatsSelection statsSelection) {
        if (statsSelection == null) {
            this.getDefaults();
        } else {
            this._statsSelectionMap.put(StatisticsSelectionObject.HISTOGRAM, statsSelection.isHistogram());
            this._statsSelectionMap.put(StatisticsSelectionObject.PERCENT_DISTINCT, statsSelection.isPercentdistinct());
            this._statsSelectionMap.put(StatisticsSelectionObject.PERCENT_NULL, statsSelection.isPercentnull());
            this._statsSelectionMap.put(StatisticsSelectionObject.MAX, statsSelection.isMax());
            this._statsSelectionMap.put(StatisticsSelectionObject.MIN, statsSelection.isMin());
            this._statsSelectionMap.put(StatisticsSelectionObject.AVG, statsSelection.isAvg());
            this._statsSelectionMap.put(StatisticsSelectionObject.STDDEV, statsSelection.isStd());
            this._statsSelectionMap.put(StatisticsSelectionObject.VARIANCE, statsSelection.isVar());
            this._statsSelectionMap.put(StatisticsSelectionObject.KURTOSIS, statsSelection.isKurtosis());
            this._statsSelectionMap.put(StatisticsSelectionObject.MEDIAN, statsSelection.isMedian());
            this._statsSelectionMap.put(StatisticsSelectionObject.MODE_SAMPLED, statsSelection.isModesampled());
            this._statsSelectionMap.put(StatisticsSelectionObject.MODE_ALL, statsSelection.isModeall());
            this._statsSelectionMap.put("MODE_FUNCTION", statsSelection.isMode());
            this._statsSelectionMap.put(StatisticsSelectionObject.SKEWNESS, statsSelection.isSkewness());
            this._statsSelectionMap.put(StatisticsSelectionObject.PERCENT_NULL, statsSelection.isPercentnull());
        }
        this._statsDescriptionObj.createStatsDescriptionMap();
    }

    private void getDefaults() {
        this._statsSelectionMap.put(StatisticsSelectionObject.HISTOGRAM, StatisticsSelectionObject.getDefaultStatsValue(StatisticsSelectionObject.HISTOGRAM));
        this._statsSelectionMap.put(StatisticsSelectionObject.PERCENT_DISTINCT, StatisticsSelectionObject.getDefaultStatsValue(StatisticsSelectionObject.PERCENT_DISTINCT));
        this._statsSelectionMap.put(StatisticsSelectionObject.PERCENT_NULL, StatisticsSelectionObject.getDefaultStatsValue(StatisticsSelectionObject.PERCENT_NULL));
        this._statsSelectionMap.put(StatisticsSelectionObject.MAX, StatisticsSelectionObject.getDefaultStatsValue(StatisticsSelectionObject.MAX));
        this._statsSelectionMap.put(StatisticsSelectionObject.MIN, StatisticsSelectionObject.getDefaultStatsValue(StatisticsSelectionObject.MIN));
        this._statsSelectionMap.put(StatisticsSelectionObject.AVG, StatisticsSelectionObject.getDefaultStatsValue(StatisticsSelectionObject.AVG));
        this._statsSelectionMap.put(StatisticsSelectionObject.STDDEV, StatisticsSelectionObject.getDefaultStatsValue(StatisticsSelectionObject.STDDEV));
        this._statsSelectionMap.put(StatisticsSelectionObject.VARIANCE, StatisticsSelectionObject.getDefaultStatsValue(StatisticsSelectionObject.VARIANCE));
        this._statsSelectionMap.put(StatisticsSelectionObject.KURTOSIS, StatisticsSelectionObject.getDefaultStatsValue(StatisticsSelectionObject.KURTOSIS));
        this._statsSelectionMap.put(StatisticsSelectionObject.MEDIAN, StatisticsSelectionObject.getDefaultStatsValue(StatisticsSelectionObject.MEDIAN));
        this._statsSelectionMap.put(StatisticsSelectionObject.MODE_SAMPLED, StatisticsSelectionObject.getDefaultStatsValue(StatisticsSelectionObject.MODE_SAMPLED));
        this._statsSelectionMap.put(StatisticsSelectionObject.MODE_ALL, StatisticsSelectionObject.getDefaultStatsValue(StatisticsSelectionObject.MODE_ALL));
        this._statsSelectionMap.put("MODE_FUNCTION", StatisticsSelectionObject.getDefaultStatsValue("MODE_FUNCTION"));
        this._statsSelectionMap.put(StatisticsSelectionObject.SKEWNESS, StatisticsSelectionObject.getDefaultStatsValue(StatisticsSelectionObject.SKEWNESS));
    }

    public void restoreDefaultStats() {
        this._statsSelectionMap.clear();
        this.getDefaults();
        this._statsDescriptionObj.createStatsDescriptionMap();
    }

    @Override
    public void setSelectedStatistic(String string, Boolean bl) {
        if (!HTMLStringUtils.isHtmlHyperLink(string)) {
            this._statsSelectionMap.put(string, bl);
            if (string.equals(StatisticsSelectionObject.PERCENT_DISTINCT) && bl.booleanValue()) {
                this._statsSelectionMap.put(StatisticsSelectionObject.PERCENT_NULL, bl);
            }
            return;
        }
        if ((string = HTMLStringUtils.unWrapInHtml(string)).equals(StatisticsSelectionObject.MODE_SAMPLED) || string.equals(StatisticsSelectionObject.MODE_ALL)) {
            this._statsSelectionMap.put("MODE_FUNCTION", bl);
        } else assert (false);
    }

    @Override
    public boolean isStatsSelected(String string) {
        Boolean bl = this._statsSelectionMap.get(string);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public void initUI() {
        this._restoreDefaults = new JLabel(HTMLStringUtils.wrapInHtml(StatisticsSelectionObject.RESTORE_DEFAULTS_LINK));
        this._restoreDefaults.setToolTipText(StatisticsSelectionObject.RESTORE_DEFAULTS_LINK_TOOLTIP);
        this._restoreDefaults.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Dialog dialog;
                if (mouseEvent.getClickCount() == 1 && MessageDialog.confirm((Component)(dialog = SwingUtils.getAncestorDialog((Component)StatisticsSelectionPanel.this)), (Object)StatisticsSelectionObject.RESTORE_DEFAULT_SETTINGS_CONFIRM_MSG, (String)StatisticsSelectionObject.RESTORE_DEFAULT_SETTINGS_CONFIRM_TITLE, null)) {
                    StatisticsSelectionPanel.this.restoreDefaultStats();
                    StatisticsSelectionPanel.this._statsDescriptionObj.createFilteredStatisticsTableModel(StatisticsSelectionPanel.this.getSearchField().getText(), StatisticsSelectionPanel.this._statsDescriptionObj.getStatistics());
                }
            }
        });
        this.addControlBarComponents(this._restoreDefaults);
        DataProfileStatisticsTableModel dataProfileStatisticsTableModel = new DataProfileStatisticsTableModel(this._statsDescriptionObj.getStatistics(), StatisticsSelectionObject.getColNames(), this);
        this._statsDescriptionObj.setupStatisticsTable(dataProfileStatisticsTableModel);
        this.addMouseListener();
        this._statsDescriptionObj.setupSearchField();
    }

    private void addMouseListener() {
        this.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 1) {
                    boolean bl;
                    boolean bl2;
                    Dialog dialog;
                    DataProfileModeSelectionDialog dataProfileModeSelectionDialog;
                    String string;
                    JTable jTable = (JTable)mouseEvent.getSource();
                    int n = jTable.getSelectedRow();
                    int n2 = jTable.getSelectedColumn();
                    int n3 = jTable.convertColumnIndexToModel(n2);
                    int n4 = jTable.convertRowIndexToModel(n);
                    TableModel tableModel = jTable.getModel();
                    String string2 = tableModel.getColumnName(n3);
                    if (string2.equals(StatisticsSelectionObject.getColNames().elementAt(1)) && ((string = (String)tableModel.getValueAt(n4, n3)).equals(HTMLStringUtils.wrapInHtml(StatisticsSelectionObject.MODE_SAMPLED)) || string.equals(HTMLStringUtils.wrapInHtml(StatisticsSelectionObject.MODE_ALL))) && (dataProfileModeSelectionDialog = new DataProfileModeSelectionDialog(dialog = SwingUtils.getAncestorDialog((Component)StatisticsSelectionPanel.this))).invoke(bl2 = StatisticsSelectionPanel.this.isStatsSelected(StatisticsSelectionObject.MODE_SAMPLED)) && bl2 != (bl = dataProfileModeSelectionDialog.isSampledMode())) {
                        if (bl) {
                            StatisticsSelectionPanel.this.setSelectedStatistic(StatisticsSelectionObject.MODE_ALL, false);
                            StatisticsSelectionPanel.this.setSelectedStatistic(StatisticsSelectionObject.MODE_SAMPLED, true);
                        } else {
                            StatisticsSelectionPanel.this.setSelectedStatistic(StatisticsSelectionObject.MODE_ALL, true);
                            StatisticsSelectionPanel.this.setSelectedStatistic(StatisticsSelectionObject.MODE_SAMPLED, false);
                        }
                        StatisticsSelectionPanel.this._statsDescriptionObj.createStatsDescriptionMap();
                        StatisticsSelectionPanel.this._statsDescriptionObj.createFilteredStatisticsTableModel(StatisticsSelectionPanel.this.getSearchField().getText(), StatisticsSelectionPanel.this._statsDescriptionObj.getStatistics());
                    }
                }
            }
        });
    }

    public StatsSelection getResults() {
        StatsSelection statsSelection = new StatsSelection();
        statsSelection.setHistogram(Boolean.valueOf(this.isStatsSelected(StatisticsSelectionObject.HISTOGRAM)));
        statsSelection.setPercentdistinct(Boolean.valueOf(this.isStatsSelected(StatisticsSelectionObject.PERCENT_DISTINCT)));
        statsSelection.setPercentnull(Boolean.valueOf(this.isStatsSelected(StatisticsSelectionObject.PERCENT_NULL)));
        statsSelection.setMax(Boolean.valueOf(this.isStatsSelected(StatisticsSelectionObject.MAX)));
        statsSelection.setMin(Boolean.valueOf(this.isStatsSelected(StatisticsSelectionObject.MIN)));
        statsSelection.setAvg(Boolean.valueOf(this.isStatsSelected(StatisticsSelectionObject.AVG)));
        statsSelection.setStd(Boolean.valueOf(this.isStatsSelected(StatisticsSelectionObject.STDDEV)));
        statsSelection.setVar(Boolean.valueOf(this.isStatsSelected(StatisticsSelectionObject.VARIANCE)));
        statsSelection.setKurtosis(Boolean.valueOf(this.isStatsSelected(StatisticsSelectionObject.KURTOSIS)));
        statsSelection.setMedian(Boolean.valueOf(this.isStatsSelected(StatisticsSelectionObject.MEDIAN)));
        statsSelection.setModesampled(Boolean.valueOf(this.isStatsSelected(StatisticsSelectionObject.MODE_SAMPLED)));
        statsSelection.setModeall(Boolean.valueOf(this.isStatsSelected(StatisticsSelectionObject.MODE_ALL)));
        statsSelection.setMode(Boolean.valueOf(this.isStatsSelected("MODE_FUNCTION")));
        statsSelection.setSkewness(Boolean.valueOf(this.isStatsSelected(StatisticsSelectionObject.SKEWNESS)));
        return statsSelection;
    }

    @Override
    public boolean doWork() {
        return true;
    }

    @Override
    public DataMinerTablePanel getDataMinerTablePanel() {
        return this;
    }
}

