/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.awt.Component;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceWizardModel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableColumnType;
import oracle.ide.Context;

public class UpdateTableWizardModel
extends DataSourceWizardModel {
    private static final Logger theLogger = Logger.getLogger(UpdateTableWizardModel.class.getName());

    public UpdateTableWizardModel(Component component, Context context, AbstractDataNode abstractDataNode, boolean bl) {
        super(component, context, abstractDataNode);
        this.tableExists = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadDefaultSelectedColumns() {
        String string;
        this._selectedColumns.clear();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = null;
        try {
            connection = Connections.getUniqueConnection(this.getContext());
            List<String> list = DatabaseMetadataUtils.getRequiredColumns(connection, StringUtils.escapeSingleQuotesForSQL(this._selectedTable.getSchema()), StringUtils.escapeSingleQuotesForSQL(this._selectedTable.getTableName()));
            AttributeType attributeType = list.iterator();
            while (attributeType.hasNext()) {
                string = attributeType.next();
                hashMap.put(string, string);
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        finally {
            SQLHelper.close(connection);
        }
        for (AttributeType attributeType : this._availableColumns) {
            string = new UpdateTableColumnType();
            if (DatabaseMetadataUtils.isDataTypeSupported(attributeType.getDataType())) {
                string.setRequiredColumn(null != hashMap.get(attributeType.getName()));
                string.setName(attributeType.getName());
                string.setAlias(attributeType.getAlias());
                string.setDataType(attributeType.getDataType());
                string.setStatus(attributeType.getStatus());
                string.setAnnotation(attributeType.getAnnotation());
                this._selectedColumns.add(string);
                continue;
            }
            attributeType.setStatus(AttributeStatus.INVALID);
        }
        this.removeSelectedAttrs(this._availableColumns, this._selectedColumns);
    }
}

