/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.dynamic;

import java.util.List;
import java.util.Vector;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.workflow.dialog.dynamic.PredictionFunctionsHelper;
import oracle.dmt.dataminer.workflow.dialog.dynamic.prediction.PredictionLrb;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusterDetailsType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusterDistanceType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusterIdType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusterProbabilityType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusterSetType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicApplyOutputColumnType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicNodeBaseSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureDetailsType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureIdType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureSetType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureValueType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.dmt.dataminer.workflow.xmlschema.PredictionDetailsType;
import oracle.dmt.dataminer.workflow.xmlschema.PredictionProbabilityType;
import oracle.dmt.dataminer.workflow.xmlschema.PredictionSetType;
import oracle.dmt.dataminer.workflow.xmlschema.PredictionType;

public class DynamicApplyHelper {
    public static final String TYPICAL_STR = CoefficientsLrb.get("TARGET_VALUE_TYPICAL");
    public static final String OUTLIER_STR = CoefficientsLrb.get("TARGET_VALUE_OUTLIER");
    public static final Integer TYPICAL = 1;
    public static final Integer OUTLIER = 0;
    private static String[] mining_types = new String[]{PredictionLrb.get("PREDICTION_TABLE_MODEL_COLUMN_NUMERIC_TYPE"), PredictionLrb.get("PREDICTION_TABLE_MODEL_COLUMN_CATEGORICAL_TYPE")};

    public static String[] getMiningTypes() {
        return mining_types;
    }

    public static String getPredictionFunction(DynamicApplyOutputColumnType dynamicApplyOutputColumnType) {
        String string = null;
        if (dynamicApplyOutputColumnType.getPrediction() != null) {
            string = "PREDICTION";
        } else if (dynamicApplyOutputColumnType.getPredictionDetails() != null) {
            string = "PREDICTION_DETAILS";
        } else if (dynamicApplyOutputColumnType.getPredictionProbability() != null) {
            string = "PREDICTION_PROBABILITY";
        } else if (dynamicApplyOutputColumnType.getPredictionSet() != null) {
            string = "PREDICTION_SET";
        } else if (dynamicApplyOutputColumnType.getClusterId() != null) {
            string = "CLUSTER_ID";
        } else if (dynamicApplyOutputColumnType.getClusterProbability() != null) {
            string = "CLUSTER_PROBABILITY";
        } else if (dynamicApplyOutputColumnType.getClusterSet() != null) {
            string = "CLUSTER_SET";
        } else if (dynamicApplyOutputColumnType.getClusterDetails() != null) {
            string = "CLUSTER_DETAILS";
        } else if (dynamicApplyOutputColumnType.getClusterDistance() != null) {
            string = "CLUSTER_DISTANCE";
        } else if (dynamicApplyOutputColumnType.getFeatureId() != null) {
            string = "FEATURE_ID";
        } else if (dynamicApplyOutputColumnType.getFeatureValue() != null) {
            string = "FEATURE_VALUE";
        } else if (dynamicApplyOutputColumnType.getFeatureSet() != null) {
            string = "FEATURE_SET";
        } else if (dynamicApplyOutputColumnType.getFeatureDetails() != null) {
            string = "FEATURE_DETAILS";
        }
        return string;
    }

    public static String getUIFunctionName(String string) {
        return DynamicApplyHelper.toHuman(string);
    }

    public static String toHuman(String string) {
        if (string != null) {
            if (string.equals("PREDICTION")) {
                return ServerConstants.ApplyPredictionFunctions.PREDICTION_FUNCTION_OPTION.PREDICTION.value();
            }
            if (string.equals("PREDICTION_DETAILS")) {
                return ServerConstants.ApplyPredictionFunctions.PREDICTION_FUNCTION_OPTION.PREDICTION_DETAILS.value();
            }
            if (string.equals("PREDICTION_PROBABILITY")) {
                return ServerConstants.ApplyPredictionFunctions.PREDICTION_FUNCTION_OPTION.PREDICTION_PROBABILITY.value();
            }
            if (string.equals("PREDICTION_SET")) {
                return ServerConstants.ApplyPredictionFunctions.PREDICTION_FUNCTION_OPTION.PREDICTION_SET.value();
            }
            if (string.equals("CLUSTER_ID")) {
                return ServerConstants.ApplyPredictionFunctions.PREDICTION_FUNCTION_OPTION.CLUSTER_ID.value();
            }
            if (string.equals("CLUSTER_PROBABILITY")) {
                return ServerConstants.ApplyPredictionFunctions.PREDICTION_FUNCTION_OPTION.CLUSTER_PROBABILITY.value();
            }
            if (string.equals("CLUSTER_SET")) {
                return ServerConstants.ApplyPredictionFunctions.PREDICTION_FUNCTION_OPTION.CLUSTER_SET.value();
            }
            if (string.equals("CLUSTER_DETAILS")) {
                return ServerConstants.ApplyPredictionFunctions.PREDICTION_FUNCTION_OPTION.CLUSTER_DETAILS.value();
            }
            if (string.equals("CLUSTER_DISTANCE")) {
                return ServerConstants.ApplyPredictionFunctions.PREDICTION_FUNCTION_OPTION.CLUSTER_DISTANCE.value();
            }
            if (string.equals("FEATURE_ID")) {
                return ServerConstants.ApplyPredictionFunctions.PREDICTION_FUNCTION_OPTION.FEATURE_ID.value();
            }
            if (string.equals("FEATURE_VALUE")) {
                return ServerConstants.ApplyPredictionFunctions.PREDICTION_FUNCTION_OPTION.FEATURE_VALUE.value();
            }
            if (string.equals("FEATURE_SET")) {
                return ServerConstants.ApplyPredictionFunctions.PREDICTION_FUNCTION_OPTION.FEATURE_SET.value();
            }
            if (string.equals("FEATURE_DETAILS")) {
                return ServerConstants.ApplyPredictionFunctions.PREDICTION_FUNCTION_OPTION.FEATURE_DETAILS.value();
            }
        }
        return null;
    }

    public static PredictionFunctionsHelper.Parameters getPredictionFunctionParameters(DynamicApplyOutputColumnType dynamicApplyOutputColumnType, String string, String string2, Vector<Object> vector) {
        PredictionFunctionsHelper.Parameters parameters = null;
        String string3 = "None";
        if (dynamicApplyOutputColumnType.getPrediction() != null) {
            if (dynamicApplyOutputColumnType.getPrediction().getCostOption().getModel() != null) {
                string3 = "Model";
            }
            parameters = new PredictionFunctionsHelper.Prediction(dynamicApplyOutputColumnType.getPrediction().getColumn().getName(), string3, null);
        } else if (dynamicApplyOutputColumnType.getPredictionDetails() != null) {
            parameters = string2 == null || string2.equals("Categorical") ? new PredictionFunctionsHelper.PredictionDetails(false, dynamicApplyOutputColumnType.getPredictionDetails().getColumn().getTargetValue(), vector, dynamicApplyOutputColumnType.getPredictionDetails().getColumn().getTopNValue() != null, dynamicApplyOutputColumnType.getPredictionDetails().getColumn().getTopNValue(), ServerConstants.ApplyPredictionDetailsSort.toHuman(dynamicApplyOutputColumnType.getPredictionDetails().getColumn().getSort()), dynamicApplyOutputColumnType.getPredictionDetails().getColumn().getName()) : new PredictionFunctionsHelper.PredictionDetails(true, dynamicApplyOutputColumnType.getPredictionDetails().getColumn().getTargetValue(), vector, dynamicApplyOutputColumnType.getPredictionDetails().getColumn().getTopNValue() != null, dynamicApplyOutputColumnType.getPredictionDetails().getColumn().getTopNValue(), ServerConstants.ApplyPredictionDetailsSort.toHuman(dynamicApplyOutputColumnType.getPredictionDetails().getColumn().getSort()), dynamicApplyOutputColumnType.getPredictionDetails().getColumn().getName());
        } else if (dynamicApplyOutputColumnType.getPredictionProbability() != null) {
            parameters = new PredictionFunctionsHelper.PredictionProbability(dynamicApplyOutputColumnType.getPredictionProbability().getColumn().getTargetValue(), vector, dynamicApplyOutputColumnType.getPredictionProbability().getColumn().getName());
        } else if (dynamicApplyOutputColumnType.getPredictionSet() != null) {
            if (dynamicApplyOutputColumnType.getPredictionSet().getCostOption() != null && dynamicApplyOutputColumnType.getPredictionSet().getCostOption().getModel() != null) {
                string3 = "Model";
            }
            parameters = new PredictionFunctionsHelper.PredictionSet(string, string2, dynamicApplyOutputColumnType.getPredictionSet().getColumn().getTopNValue() != null, dynamicApplyOutputColumnType.getPredictionSet().getColumn().getTopNValue(), 2, dynamicApplyOutputColumnType.getPredictionSet().getColumn().getProbCutOff() != null, dynamicApplyOutputColumnType.getPredictionSet().getColumn().getProbCutOff(), dynamicApplyOutputColumnType.getPredictionSet().getColumn().getCostCutOff() != null, dynamicApplyOutputColumnType.getPredictionSet().getColumn().getCostCutOff(), dynamicApplyOutputColumnType.getPredictionSet().getColumn().getName(), string3, null);
        } else if (dynamicApplyOutputColumnType.getClusterId() != null) {
            parameters = new PredictionFunctionsHelper.ClusterId(dynamicApplyOutputColumnType.getClusterId().getColumn().getName());
        } else if (dynamicApplyOutputColumnType.getClusterProbability() != null) {
            parameters = new PredictionFunctionsHelper.ClusterProbability(dynamicApplyOutputColumnType.getClusterProbability().getColumn().getClusterId(), vector, dynamicApplyOutputColumnType.getClusterProbability().getColumn().getName());
        } else if (dynamicApplyOutputColumnType.getClusterSet() != null) {
            parameters = new PredictionFunctionsHelper.ClusterSet(dynamicApplyOutputColumnType.getClusterSet().getColumn().getTopNValue() != null, dynamicApplyOutputColumnType.getClusterSet().getColumn().getTopNValue(), 2, dynamicApplyOutputColumnType.getClusterSet().getColumn().getCutOffValue() != null, dynamicApplyOutputColumnType.getClusterSet().getColumn().getCutOffValue(), dynamicApplyOutputColumnType.getClusterSet().getColumn().getName());
        } else if (dynamicApplyOutputColumnType.getClusterDetails() != null) {
            parameters = new PredictionFunctionsHelper.ClusterDetails(dynamicApplyOutputColumnType.getClusterDetails().getColumn().getClusterId(), vector, dynamicApplyOutputColumnType.getClusterDetails().getColumn().getTopNValue() != null, dynamicApplyOutputColumnType.getClusterDetails().getColumn().getTopNValue(), ServerConstants.ApplyPredictionDetailsSort.toHuman(dynamicApplyOutputColumnType.getClusterDetails().getColumn().getSort()), dynamicApplyOutputColumnType.getClusterDetails().getColumn().getName());
        } else if (dynamicApplyOutputColumnType.getClusterDistance() != null) {
            parameters = new PredictionFunctionsHelper.ClusterDistance(dynamicApplyOutputColumnType.getClusterDistance().getColumn().getClusterId(), null, dynamicApplyOutputColumnType.getClusterDistance().getColumn().getName());
        } else if (dynamicApplyOutputColumnType.getFeatureId() != null) {
            parameters = new PredictionFunctionsHelper.FeatureId(dynamicApplyOutputColumnType.getFeatureId().getColumn().getName());
        } else if (dynamicApplyOutputColumnType.getFeatureValue() != null) {
            parameters = new PredictionFunctionsHelper.FeatureValue(dynamicApplyOutputColumnType.getFeatureValue().getColumn().getFeatureId(), vector, dynamicApplyOutputColumnType.getFeatureValue().getColumn().getName());
        } else if (dynamicApplyOutputColumnType.getFeatureSet() != null) {
            parameters = new PredictionFunctionsHelper.FeatureSet(dynamicApplyOutputColumnType.getFeatureSet().getColumn().getTopNValue() != null, dynamicApplyOutputColumnType.getFeatureSet().getColumn().getTopNValue(), 2, dynamicApplyOutputColumnType.getFeatureSet().getColumn().getCutOffValue() != null, dynamicApplyOutputColumnType.getFeatureSet().getColumn().getCutOffValue(), dynamicApplyOutputColumnType.getFeatureSet().getColumn().getName());
        } else if (dynamicApplyOutputColumnType.getFeatureDetails() != null) {
            parameters = new PredictionFunctionsHelper.FeatureDetails(dynamicApplyOutputColumnType.getFeatureDetails().getColumn().getFeatureId(), vector, dynamicApplyOutputColumnType.getFeatureDetails().getColumn().getTopNValue() != null, dynamicApplyOutputColumnType.getFeatureDetails().getColumn().getTopNValue(), ServerConstants.ApplyPredictionDetailsSort.toHuman(dynamicApplyOutputColumnType.getFeatureDetails().getColumn().getSort()), dynamicApplyOutputColumnType.getFeatureDetails().getColumn().getName());
        }
        return parameters;
    }

    public static PredictionFunctionsHelper.Parameters getAnomalyFunctionParameters(DynamicApplyOutputColumnType dynamicApplyOutputColumnType) {
        PredictionFunctionsHelper.Parameters parameters = null;
        if (dynamicApplyOutputColumnType.getPrediction() != null) {
            parameters = new PredictionFunctionsHelper.AnomalyPrediction(dynamicApplyOutputColumnType.getPrediction().getColumn().getName());
        } else if (dynamicApplyOutputColumnType.getPredictionDetails() != null) {
            parameters = new PredictionFunctionsHelper.AnomalyPredictionDetails(null != dynamicApplyOutputColumnType.getPredictionDetails().getColumn().getTargetValue(), dynamicApplyOutputColumnType.getPredictionDetails().getColumn().getTargetValue(), dynamicApplyOutputColumnType.getPredictionDetails().getColumn().getTopNValue() != null, dynamicApplyOutputColumnType.getPredictionDetails().getColumn().getTopNValue(), ServerConstants.ApplyPredictionDetailsSort.toHuman(dynamicApplyOutputColumnType.getPredictionDetails().getColumn().getSort()), dynamicApplyOutputColumnType.getPredictionDetails().getColumn().getName());
        } else if (dynamicApplyOutputColumnType.getPredictionProbability() != null) {
            parameters = new PredictionFunctionsHelper.AnomalyPredictionProbability(dynamicApplyOutputColumnType.getPredictionProbability().getColumn().getTargetValue(), dynamicApplyOutputColumnType.getPredictionProbability().getColumn().getName());
        } else if (dynamicApplyOutputColumnType.getPredictionSet() != null) {
            parameters = new PredictionFunctionsHelper.AnomalyPredictionSet(dynamicApplyOutputColumnType.getPredictionSet().getColumn().getTopNValue() != null, dynamicApplyOutputColumnType.getPredictionSet().getColumn().getTopNValue(), 1, dynamicApplyOutputColumnType.getPredictionSet().getColumn().getProbCutOff() != null, dynamicApplyOutputColumnType.getPredictionSet().getColumn().getProbCutOff(), dynamicApplyOutputColumnType.getPredictionSet().getColumn().getCostCutOff() != null, dynamicApplyOutputColumnType.getPredictionSet().getColumn().getCostCutOff(), dynamicApplyOutputColumnType.getPredictionSet().getColumn().getName());
        }
        return parameters;
    }

    public static String getPredictionFunctionOutput(DynamicApplyOutputColumnType dynamicApplyOutputColumnType) {
        String string = null;
        if (dynamicApplyOutputColumnType.getPrediction() != null) {
            string = dynamicApplyOutputColumnType.getPrediction().getColumn().getName();
        } else if (dynamicApplyOutputColumnType.getPredictionDetails() != null) {
            string = dynamicApplyOutputColumnType.getPredictionDetails().getColumn().getName();
        } else if (dynamicApplyOutputColumnType.getPredictionProbability() != null) {
            string = dynamicApplyOutputColumnType.getPredictionProbability().getColumn().getName();
        } else if (dynamicApplyOutputColumnType.getPredictionSet() != null) {
            string = dynamicApplyOutputColumnType.getPredictionSet().getColumn().getName();
        } else if (dynamicApplyOutputColumnType.getClusterId() != null) {
            string = dynamicApplyOutputColumnType.getClusterId().getColumn().getName();
        } else if (dynamicApplyOutputColumnType.getClusterProbability() != null) {
            string = dynamicApplyOutputColumnType.getClusterProbability().getColumn().getName();
        } else if (dynamicApplyOutputColumnType.getClusterSet() != null) {
            string = dynamicApplyOutputColumnType.getClusterSet().getColumn().getName();
        } else if (dynamicApplyOutputColumnType.getClusterDetails() != null) {
            string = dynamicApplyOutputColumnType.getClusterDetails().getColumn().getName();
        } else if (dynamicApplyOutputColumnType.getClusterDistance() != null) {
            string = dynamicApplyOutputColumnType.getClusterDistance().getColumn().getName();
        } else if (dynamicApplyOutputColumnType.getFeatureId() != null) {
            string = dynamicApplyOutputColumnType.getFeatureId().getColumn().getName();
        } else if (dynamicApplyOutputColumnType.getFeatureValue() != null) {
            string = dynamicApplyOutputColumnType.getFeatureValue().getColumn().getName();
        } else if (dynamicApplyOutputColumnType.getFeatureSet() != null) {
            string = dynamicApplyOutputColumnType.getFeatureSet().getColumn().getName();
        } else if (dynamicApplyOutputColumnType.getFeatureDetails() != null) {
            string = dynamicApplyOutputColumnType.getFeatureDetails().getColumn().getName();
        }
        return string;
    }

    public static void setPredictionFunctionOutput(DynamicApplyOutputColumnType dynamicApplyOutputColumnType, String string) {
        if (dynamicApplyOutputColumnType.getPrediction() != null) {
            dynamicApplyOutputColumnType.getPrediction().getColumn().setName(string);
        } else if (dynamicApplyOutputColumnType.getPredictionDetails() != null) {
            dynamicApplyOutputColumnType.getPredictionDetails().getColumn().setName(string);
        } else if (dynamicApplyOutputColumnType.getPredictionProbability() != null) {
            dynamicApplyOutputColumnType.getPredictionProbability().getColumn().setName(string);
        } else if (dynamicApplyOutputColumnType.getPredictionSet() != null) {
            dynamicApplyOutputColumnType.getPredictionSet().getColumn().setName(string);
        } else if (dynamicApplyOutputColumnType.getClusterId() != null) {
            dynamicApplyOutputColumnType.getClusterId().getColumn().setName(string);
        } else if (dynamicApplyOutputColumnType.getClusterProbability() != null) {
            dynamicApplyOutputColumnType.getClusterProbability().getColumn().setName(string);
        } else if (dynamicApplyOutputColumnType.getClusterSet() != null) {
            dynamicApplyOutputColumnType.getClusterSet().getColumn().setName(string);
        } else if (dynamicApplyOutputColumnType.getClusterDetails() != null) {
            dynamicApplyOutputColumnType.getClusterDetails().getColumn().setName(string);
        } else if (dynamicApplyOutputColumnType.getClusterDistance() != null) {
            dynamicApplyOutputColumnType.getClusterDistance().getColumn().setName(string);
        } else if (dynamicApplyOutputColumnType.getFeatureId() != null) {
            dynamicApplyOutputColumnType.getFeatureId().getColumn().setName(string);
        } else if (dynamicApplyOutputColumnType.getFeatureValue() != null) {
            dynamicApplyOutputColumnType.getFeatureValue().getColumn().setName(string);
        } else if (dynamicApplyOutputColumnType.getFeatureSet() != null) {
            dynamicApplyOutputColumnType.getFeatureSet().getColumn().setName(string);
        } else if (dynamicApplyOutputColumnType.getFeatureDetails() != null) {
            dynamicApplyOutputColumnType.getFeatureDetails().getColumn().setName(string);
        }
    }

    public static String getColumnName(DynamicApplyOutputColumnType dynamicApplyOutputColumnType) {
        String string = null;
        if (null != dynamicApplyOutputColumnType.getPrediction()) {
            string = dynamicApplyOutputColumnType.getPrediction().getColumn().getName();
        } else if (null != dynamicApplyOutputColumnType.getPredictionProbability()) {
            string = dynamicApplyOutputColumnType.getPredictionProbability().getColumn().getName();
        } else if (null != dynamicApplyOutputColumnType.getPredictionSet()) {
            string = dynamicApplyOutputColumnType.getPredictionSet().getColumn().getName();
        } else if (null != dynamicApplyOutputColumnType.getPredictionDetails()) {
            string = dynamicApplyOutputColumnType.getPredictionDetails().getColumn().getName();
        } else if (null != dynamicApplyOutputColumnType.getClusterId()) {
            string = dynamicApplyOutputColumnType.getClusterId().getColumn().getName();
        } else if (null != dynamicApplyOutputColumnType.getClusterProbability()) {
            string = dynamicApplyOutputColumnType.getClusterProbability().getColumn().getName();
        } else if (null != dynamicApplyOutputColumnType.getClusterDistance()) {
            string = dynamicApplyOutputColumnType.getClusterDistance().getColumn().getName();
        } else if (null != dynamicApplyOutputColumnType.getClusterDetails()) {
            string = dynamicApplyOutputColumnType.getClusterDetails().getColumn().getName();
        } else if (null != dynamicApplyOutputColumnType.getClusterSet()) {
            string = dynamicApplyOutputColumnType.getClusterSet().getColumn().getName();
        } else if (null != dynamicApplyOutputColumnType.getFeatureId()) {
            string = dynamicApplyOutputColumnType.getFeatureId().getColumn().getName();
        } else if (null != dynamicApplyOutputColumnType.getFeatureSet()) {
            string = dynamicApplyOutputColumnType.getFeatureSet().getColumn().getName();
        } else if (null != dynamicApplyOutputColumnType.getFeatureValue()) {
            string = dynamicApplyOutputColumnType.getFeatureValue().getColumn().getName();
        } else if (null != dynamicApplyOutputColumnType.getFeatureDetails()) {
            string = dynamicApplyOutputColumnType.getFeatureDetails().getColumn().getName();
        }
        return string;
    }

    public static void setPredictionFunctionParameters(DynamicApplyOutputColumnType dynamicApplyOutputColumnType, PredictionFunctionsHelper.Parameters parameters) {
        dynamicApplyOutputColumnType.setClusterId(null);
        dynamicApplyOutputColumnType.setClusterProbability(null);
        dynamicApplyOutputColumnType.setClusterSet(null);
        dynamicApplyOutputColumnType.setFeatureId(null);
        dynamicApplyOutputColumnType.setFeatureSet(null);
        dynamicApplyOutputColumnType.setFeatureValue(null);
        dynamicApplyOutputColumnType.setPrediction(null);
        dynamicApplyOutputColumnType.setPredictionBounds(null);
        dynamicApplyOutputColumnType.setPredictionCost(null);
        dynamicApplyOutputColumnType.setPredictionDetails(null);
        dynamicApplyOutputColumnType.setPredictionProbability(null);
        dynamicApplyOutputColumnType.setPredictionSet(null);
        if (parameters instanceof PredictionFunctionsHelper.Prediction) {
            PredictionFunctionsHelper.Prediction prediction = (PredictionFunctionsHelper.Prediction)parameters;
            PredictionType predictionType = new PredictionType();
            PredictionType.CostOption costOption = new PredictionType.CostOption();
            costOption.setNone(new PredictionType.CostOption.None());
            predictionType.setCostOption(costOption);
            PredictionType.Column column = new PredictionType.Column();
            column.setName(prediction.getColumn());
            predictionType.setColumn(column);
            dynamicApplyOutputColumnType.setPrediction(predictionType);
        } else if (parameters instanceof PredictionFunctionsHelper.PredictionDetails) {
            PredictionFunctionsHelper.PredictionDetails predictionDetails = (PredictionFunctionsHelper.PredictionDetails)parameters;
            PredictionDetailsType predictionDetailsType = new PredictionDetailsType();
            PredictionDetailsType.Column column = new PredictionDetailsType.Column();
            column.setName(predictionDetails.getColumn());
            column.setSort(ServerConstants.ApplyPredictionDetailsSort.toAlgorithm(predictionDetails.getSort()));
            column.setTopNValue(predictionDetails.getTopN());
            Object object = predictionDetails.getSelectedTarget();
            if (TYPICAL_STR.equals(object)) {
                object = TYPICAL;
            }
            if (OUTLIER_STR.equals(object)) {
                object = OUTLIER;
            }
            column.setTargetValue(object == null ? null : object.toString());
            predictionDetailsType.setColumn(column);
            dynamicApplyOutputColumnType.setPredictionDetails(predictionDetailsType);
        } else if (parameters instanceof PredictionFunctionsHelper.AnomalyPredictionDetails) {
            PredictionFunctionsHelper.AnomalyPredictionDetails anomalyPredictionDetails = (PredictionFunctionsHelper.AnomalyPredictionDetails)parameters;
            PredictionDetailsType predictionDetailsType = new PredictionDetailsType();
            PredictionDetailsType.Column column = new PredictionDetailsType.Column();
            column.setName(anomalyPredictionDetails.getColumn());
            column.setSort(ServerConstants.ApplyPredictionDetailsSort.toAlgorithm(anomalyPredictionDetails.getSort()));
            column.setTopNValue(anomalyPredictionDetails.getTopN());
            Object object = anomalyPredictionDetails.getSelectedTarget();
            if (TYPICAL_STR.equals(object)) {
                object = TYPICAL;
            }
            if (OUTLIER_STR.equals(object)) {
                object = OUTLIER;
            }
            column.setTargetValue(object == null ? null : object.toString());
            predictionDetailsType.setColumn(column);
            dynamicApplyOutputColumnType.setPredictionDetails(predictionDetailsType);
        } else if (parameters instanceof PredictionFunctionsHelper.ClusterId) {
            PredictionFunctionsHelper.ClusterId clusterId = (PredictionFunctionsHelper.ClusterId)parameters;
            ClusterIdType clusterIdType = new ClusterIdType();
            ClusterIdType.Column column = new ClusterIdType.Column();
            column.setName(clusterId.getColumn());
            clusterIdType.setColumn(column);
            dynamicApplyOutputColumnType.setClusterId(clusterIdType);
        } else if (parameters instanceof PredictionFunctionsHelper.FeatureId) {
            PredictionFunctionsHelper.FeatureId featureId = (PredictionFunctionsHelper.FeatureId)parameters;
            FeatureIdType featureIdType = new FeatureIdType();
            FeatureIdType.Column column = new FeatureIdType.Column();
            column.setName(featureId.getColumn());
            featureIdType.setColumn(column);
            dynamicApplyOutputColumnType.setFeatureId(featureIdType);
        } else if (parameters instanceof PredictionFunctionsHelper.DefaultPredictionProbability) {
            PredictionFunctionsHelper.DefaultPredictionProbability defaultPredictionProbability = (PredictionFunctionsHelper.DefaultPredictionProbability)parameters;
            PredictionProbabilityType predictionProbabilityType = new PredictionProbabilityType();
            PredictionProbabilityType.Column column = new PredictionProbabilityType.Column();
            column.setName(defaultPredictionProbability.getColumn());
            Object object = defaultPredictionProbability.getSelectedTarget();
            if (TYPICAL_STR.equals(object)) {
                object = TYPICAL;
            }
            if (OUTLIER_STR.equals(object)) {
                object = OUTLIER;
            }
            column.setTargetValue(object == null ? null : object.toString());
            predictionProbabilityType.setColumn(column);
            dynamicApplyOutputColumnType.setPredictionProbability(predictionProbabilityType);
        } else if (parameters instanceof PredictionFunctionsHelper.PredictionSet) {
            PredictionFunctionsHelper.PredictionSet predictionSet = (PredictionFunctionsHelper.PredictionSet)parameters;
            PredictionSetType predictionSetType = new PredictionSetType();
            PredictionSetType.CostOption costOption = new PredictionSetType.CostOption();
            if (predictionSet.getUseCostType().compareTo("Model") == 0) {
                costOption.setModel(new PredictionSetType.CostOption.Model());
            } else {
                costOption.setNone(new PredictionSetType.CostOption.None());
            }
            predictionSetType.setCostOption(costOption);
            PredictionSetType.Column column = new PredictionSetType.Column();
            column.setName(predictionSet.getColumn());
            column.setTopNValue(predictionSet.getTopN());
            column.setProbCutOff(predictionSet.getCutOff());
            column.setCostCutOff(predictionSet.getCostCutOff());
            predictionSetType.setColumn(column);
            dynamicApplyOutputColumnType.setPredictionSet(predictionSetType);
        } else if (parameters instanceof PredictionFunctionsHelper.AnomalyPredictionSet) {
            PredictionFunctionsHelper.AnomalyPredictionSet anomalyPredictionSet = (PredictionFunctionsHelper.AnomalyPredictionSet)parameters;
            PredictionSetType predictionSetType = new PredictionSetType();
            PredictionSetType.CostOption costOption = new PredictionSetType.CostOption();
            if (anomalyPredictionSet.getUseCostType().compareTo("Model") == 0) {
                costOption.setModel(new PredictionSetType.CostOption.Model());
            } else {
                costOption.setNone(new PredictionSetType.CostOption.None());
            }
            predictionSetType.setCostOption(costOption);
            PredictionSetType.Column column = new PredictionSetType.Column();
            column.setName(anomalyPredictionSet.getColumn());
            column.setTopNValue(anomalyPredictionSet.getTopN());
            column.setProbCutOff(anomalyPredictionSet.getCutOff());
            column.setCostCutOff(anomalyPredictionSet.getCostCutOff());
            predictionSetType.setColumn(column);
            dynamicApplyOutputColumnType.setPredictionSet(predictionSetType);
        } else if (parameters instanceof PredictionFunctionsHelper.ClusterProbability) {
            PredictionFunctionsHelper.ClusterProbability clusterProbability = (PredictionFunctionsHelper.ClusterProbability)parameters;
            ClusterProbabilityType clusterProbabilityType = new ClusterProbabilityType();
            ClusterProbabilityType.Column column = new ClusterProbabilityType.Column();
            column.setName(clusterProbability.getColumn());
            column.setClusterId(clusterProbability.getClusterId() == null ? null : clusterProbability.getClusterId().toString());
            clusterProbabilityType.setColumn(column);
            dynamicApplyOutputColumnType.setClusterProbability(clusterProbabilityType);
        } else if (parameters instanceof PredictionFunctionsHelper.ClusterSet) {
            PredictionFunctionsHelper.ClusterSet clusterSet = (PredictionFunctionsHelper.ClusterSet)parameters;
            ClusterSetType clusterSetType = new ClusterSetType();
            ClusterSetType.Column column = new ClusterSetType.Column();
            column.setName(clusterSet.getColumn());
            column.setTopNValue(clusterSet.getTopN());
            column.setCutOffValue(clusterSet.getCutOff());
            clusterSetType.setColumn(column);
            dynamicApplyOutputColumnType.setClusterSet(clusterSetType);
        } else if (parameters instanceof PredictionFunctionsHelper.ClusterDetails) {
            PredictionFunctionsHelper.ClusterDetails clusterDetails = (PredictionFunctionsHelper.ClusterDetails)parameters;
            ClusterDetailsType clusterDetailsType = new ClusterDetailsType();
            ClusterDetailsType.Column column = new ClusterDetailsType.Column();
            column.setName(clusterDetails.getColumn());
            column.setSort(ServerConstants.ApplyPredictionDetailsSort.toAlgorithm(clusterDetails.getSort()));
            column.setTopNValue(clusterDetails.getTopN());
            Object object = clusterDetails.getSelectedTarget();
            column.setClusterId(object == null ? null : object.toString());
            clusterDetailsType.setColumn(column);
            dynamicApplyOutputColumnType.setClusterDetails(clusterDetailsType);
        } else if (parameters instanceof PredictionFunctionsHelper.ClusterDistance) {
            PredictionFunctionsHelper.ClusterDistance clusterDistance = (PredictionFunctionsHelper.ClusterDistance)parameters;
            ClusterDistanceType clusterDistanceType = new ClusterDistanceType();
            ClusterDistanceType.Column column = new ClusterDistanceType.Column();
            column.setName(clusterDistance.getColumn());
            Object object = clusterDistance.getClusterId();
            column.setClusterId(object == null ? null : object.toString());
            clusterDistanceType.setColumn(column);
            dynamicApplyOutputColumnType.setClusterDistance(clusterDistanceType);
        } else if (parameters instanceof PredictionFunctionsHelper.FeatureValue) {
            PredictionFunctionsHelper.FeatureValue featureValue = (PredictionFunctionsHelper.FeatureValue)parameters;
            FeatureValueType featureValueType = new FeatureValueType();
            FeatureValueType.Column column = new FeatureValueType.Column();
            column.setName(featureValue.getColumn());
            column.setFeatureId(featureValue.getFeatureId() == null ? null : featureValue.getFeatureId().toString());
            featureValueType.setColumn(column);
            dynamicApplyOutputColumnType.setFeatureValue(featureValueType);
        } else if (parameters instanceof PredictionFunctionsHelper.FeatureSet) {
            PredictionFunctionsHelper.FeatureSet featureSet = (PredictionFunctionsHelper.FeatureSet)parameters;
            FeatureSetType featureSetType = new FeatureSetType();
            FeatureSetType.Column column = new FeatureSetType.Column();
            column.setName(featureSet.getColumn());
            column.setTopNValue(featureSet.getTopN());
            column.setCutOffValue(featureSet.getCutOff());
            featureSetType.setColumn(column);
            dynamicApplyOutputColumnType.setFeatureSet(featureSetType);
        } else if (parameters instanceof PredictionFunctionsHelper.FeatureDetails) {
            PredictionFunctionsHelper.FeatureDetails featureDetails = (PredictionFunctionsHelper.FeatureDetails)parameters;
            FeatureDetailsType featureDetailsType = new FeatureDetailsType();
            FeatureDetailsType.Column column = new FeatureDetailsType.Column();
            column.setName(featureDetails.getColumn());
            column.setSort(ServerConstants.ApplyPredictionDetailsSort.toAlgorithm(featureDetails.getSort()));
            column.setTopNValue(featureDetails.getTopN());
            Object object = featureDetails.getSelectedTarget();
            column.setFeatureId(object == null ? null : object.toString());
            featureDetailsType.setColumn(column);
            dynamicApplyOutputColumnType.setFeatureDetails(featureDetailsType);
        }
    }

    public static PartitionExpressionType getPartitionExpression(DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType, String string) {
        PartitionExpressionType partitionExpressionType = null;
        for (PartitionExpressionType partitionExpressionType2 : dynamicNodeBaseSettingsType.getPartitionExpressions().getPartitionExpression()) {
            if (!string.equals(partitionExpressionType2.getPartitionAttribute().getName())) continue;
            partitionExpressionType = partitionExpressionType2;
            break;
        }
        return partitionExpressionType;
    }

    public static String generatePartitionsExpression(DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        List list = dynamicNodeBaseSettingsType.getPartitionExpressions().getPartitionExpression();
        for (PartitionExpressionType partitionExpressionType : list) {
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(",\n\t");
            }
            if (null != partitionExpressionType.getSQLExpression()) {
                stringBuilder2.append("(");
                stringBuilder2.append(partitionExpressionType.getSQLExpression());
                stringBuilder2.append(")");
                continue;
            }
            stringBuilder2.append("\"");
            stringBuilder2.append(partitionExpressionType.getPartitionAttribute().getName());
            stringBuilder2.append("\"");
        }
        if (!list.isEmpty()) {
            stringBuilder.append("PARTITION BY ");
            stringBuilder.append(stringBuilder2.toString());
        }
        if (!dynamicNodeBaseSettingsType.getCaseAttributes().getAttribute().isEmpty()) {
            stringBuilder.append("\n\t");
            stringBuilder.append("ORDER BY \"");
            stringBuilder.append(((AttributeType)dynamicNodeBaseSettingsType.getCaseAttributes().getAttribute().get(0)).getName());
            stringBuilder.append("\"");
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }
}

