/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.dynamic;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.apply.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicAnomalyApplyHelper;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicApplyHelper;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicApplyOutputDialog;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicNodesLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicState;
import oracle.dmt.dataminer.workflow.dialog.dynamic.PredictionFunctionsHelper;
import oracle.dmt.dataminer.workflow.inspect.table.TablePIPropertyLrb;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicAnomalyNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicApplyOutputColumnType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicClusterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicFeatureNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicPredictionNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class DynamicApplyOutputPanel
extends AbstractDialogPanel {
    private static final Logger theLogger = Logger.getLogger(DynamicApplyOutputPanel.class.getName());
    private static final String SELECT_A_FUNCTION = DialogsLrb.get("APPLY_SELECT_FUNCTION");
    private static final String MOST_LIKELY = DialogsLrb.get("APPLY_OPTION_MOST_LIKELY");
    private MiningAttributeType selectedTarget;
    private DynamicApplyOutputColumnType applyOutputColumn;
    private DynamicState state;
    private DynamicApplyOutputDialog.MODE mode;
    private boolean dirty = false;
    private String selectPredictionFunc;
    private PredictionFunctionsHelper.Parameters selectFuncParameters;
    private boolean loading = false;
    private JCheckBox jAutoGenCheckBox;
    private JCheckBox jBestNCheckBox;
    private JLabel jColumnLabel;
    private JTextField jColumnTextField;
    private NumberTextField jConfidenceField;
    private JLabel jConfidenceLabel;
    private JCheckBox jCutOffCheckBox;
    private JLabel jCutOffLabel;
    private NumberTextField jCutOffTextField;
    private JComboBox jFunctionComboBox;
    private JLabel jFunctionLabel;
    private JComboBox jNValueComboBox;
    private JLabel jNValueLabel;
    private JPanel jParamsPanel;
    private JComboBox jPredictionComboBox;
    private JLabel jPredictionLabel;
    private JComboBox jSortComboBox;
    private JLabel jSortLabel;

    public DynamicApplyOutputPanel(Context context, DynamicState dynamicState, MiningAttributeType miningAttributeType) {
        super(context, dynamicState.getNode());
        this.state = dynamicState;
        this.selectedTarget = miningAttributeType;
        this.mode = DynamicApplyOutputDialog.MODE.ADD_TARGET;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public DynamicApplyOutputPanel(Context context, DynamicState dynamicState, DynamicApplyOutputColumnType dynamicApplyOutputColumnType, MiningAttributeType miningAttributeType) {
        super(context, dynamicState.getNode());
        assert (context != null) : "Context must not be null.";
        this.state = dynamicState;
        this.applyOutputColumn = (DynamicApplyOutputColumnType)MetaDataHelper.copyMetadataObject(dynamicApplyOutputColumnType);
        this.selectedTarget = miningAttributeType;
        this.mode = DynamicApplyOutputDialog.MODE.EDIT_TARGET;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jColumnLabel, (Component)this.jColumnTextField, (String)DialogsLrb.get("APPLY_OUTPUT_COLUMN"));
        ResourceUtils.resButton((AbstractButton)this.jAutoGenCheckBox, (String)DialogsLrb.get("APPLY_OUTPUT_AUTO"));
        ResourceUtils.resLabel((JLabel)this.jFunctionLabel, (Component)this.jFunctionComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_FUNCTION"));
        ResourceUtils.resLabel((JLabel)this.jConfidenceLabel, (Component)this.jConfidenceField, (String)DynamicNodesLrb.get("DYNAMIC_APPLY_OUTPUT_PANEL_CONFIDENCE"));
        this.jParamsPanel.setBorder(BorderFactory.createTitledBorder(DynamicNodesLrb.get("DYNAMIC_APPLY_OUTPUT_PANEL_PARAMETERS")));
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)"dynamic_prediction_node_add_output_function");
        this.loading = true;
        this.jAutoGenCheckBox.setSelected(true);
        this.jColumnTextField.setEnabled(!this.jAutoGenCheckBox.isSelected());
        if (this.mode.equals((Object)DynamicApplyOutputDialog.MODE.ADD_TARGET)) {
            Vector<String> vector = this.getPredictionFunctions(this.selectedTarget);
            vector.insertElementAt(SELECT_A_FUNCTION, 0);
            this.jFunctionComboBox.setModel(new DefaultComboBoxModel<String>(vector));
            this.jFunctionComboBox.setSelectedItem(SELECT_A_FUNCTION);
            this.jColumnTextField.setText(this.selectedTarget != null ? this.selectedTarget.getName() : "");
            this.populateParamUI(this.selectFuncParameters);
            this.jAutoGenCheckBox.setEnabled(false);
        } else {
            String[] stringArray = new String[]{ServerConstants.ApplyPredictionFunctions.toHuman(DynamicApplyHelper.getPredictionFunction(this.applyOutputColumn))};
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(stringArray);
            this.jFunctionComboBox.setModel(defaultComboBoxModel);
            this.selectPredictionFunc = stringArray[0];
            this.jFunctionComboBox.setEnabled(false);
            String string = this.selectedTarget != null ? this.selectedTarget.getName() : null;
            Vector<Object> vector = this.state.getNodeSpecificTargetValues(string);
            String string2 = this.selectedTarget != null ? this.selectedTarget.getMiningType() : null;
            String string3 = this.selectedTarget != null ? this.selectedTarget.getDataType() : null;
            this.selectFuncParameters = DynamicApplyHelper.getPredictionFunctionParameters(this.applyOutputColumn, string3, string2, vector);
            if (this.jAutoGenCheckBox.isSelected()) {
                String string4 = DynamicApplyHelper.getColumnName(this.applyOutputColumn);
                this.jColumnTextField.setText(string4);
            }
            this.populateParamUI(this.selectFuncParameters);
            this.jAutoGenCheckBox.setEnabled(true);
            this.revalidate();
        }
        this.loading = false;
    }

    private Vector<String> getPredictionFunctions(MiningAttributeType miningAttributeType) {
        Vector<String> vector = new Vector<String>();
        if (this.getData().getData() instanceof DynamicPredictionNodeType) {
            vector.add(ServerConstants.ApplyPredictionFunctions.toHuman("PREDICTION"));
            if (miningAttributeType.getMiningType().equals("Categorical")) {
                vector.add(ServerConstants.ApplyPredictionFunctions.toHuman("PREDICTION_PROBABILITY"));
            }
            vector.add(ServerConstants.ApplyPredictionFunctions.toHuman("PREDICTION_DETAILS"));
            if (miningAttributeType.getMiningType().equals("Categorical")) {
                vector.add(ServerConstants.ApplyPredictionFunctions.toHuman("PREDICTION_SET"));
            }
        } else if (this.getData().getData() instanceof DynamicClusterNodeType) {
            vector.add(ServerConstants.ApplyPredictionFunctions.toHuman("CLUSTER_ID"));
            vector.add(ServerConstants.ApplyPredictionFunctions.toHuman("CLUSTER_PROBABILITY"));
            vector.add(ServerConstants.ApplyPredictionFunctions.toHuman("CLUSTER_DETAILS"));
            vector.add(ServerConstants.ApplyPredictionFunctions.toHuman("CLUSTER_DISTANCE"));
            vector.add(ServerConstants.ApplyPredictionFunctions.toHuman("CLUSTER_SET"));
        } else if (this.getData().getData() instanceof DynamicAnomalyNodeType) {
            vector.add(ServerConstants.ApplyPredictionFunctions.toHuman("PREDICTION"));
            vector.add(ServerConstants.ApplyPredictionFunctions.toHuman("PREDICTION_PROBABILITY"));
            vector.add(ServerConstants.ApplyPredictionFunctions.toHuman("PREDICTION_DETAILS"));
            vector.add(ServerConstants.ApplyPredictionFunctions.toHuman("PREDICTION_SET"));
        } else if (this.getData().getData() instanceof DynamicFeatureNodeType) {
            vector.add(ServerConstants.ApplyPredictionFunctions.toHuman("FEATURE_ID"));
            vector.add(ServerConstants.ApplyPredictionFunctions.toHuman("FEATURE_VALUE"));
            vector.add(ServerConstants.ApplyPredictionFunctions.toHuman("FEATURE_DETAILS"));
            vector.add(ServerConstants.ApplyPredictionFunctions.toHuman("FEATURE_SET"));
        }
        return vector;
    }

    private void populateParamUI(PredictionFunctionsHelper.Parameters parameters) {
        this.loading = true;
        boolean bl = true;
        this.jPredictionLabel.setVisible(false);
        this.jPredictionComboBox.setVisible(false);
        this.jConfidenceLabel.setVisible(false);
        this.jConfidenceField.setVisible(false);
        this.jBestNCheckBox.setVisible(false);
        this.jNValueLabel.setVisible(false);
        this.jNValueComboBox.setVisible(false);
        this.jCutOffCheckBox.setVisible(false);
        this.jCutOffLabel.setVisible(false);
        this.jCutOffTextField.setVisible(false);
        this.jSortLabel.setVisible(false);
        this.jSortComboBox.setVisible(false);
        if (parameters instanceof PredictionFunctionsHelper.DefaultPredictionProbability) {
            this.jPredictionLabel.setVisible(true);
            this.jPredictionComboBox.setVisible(true);
            if (parameters instanceof PredictionFunctionsHelper.PredictionProbability) {
                ResourceUtils.resLabel((JLabel)this.jPredictionLabel, (Component)this.jPredictionComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_TARGET"));
                this.jPredictionLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_TARGET");
            } else {
                ResourceUtils.resLabel((JLabel)this.jPredictionLabel, (Component)this.jPredictionComboBox, (String)DynamicNodesLrb.get("APPLY_OUTPUT_ANOMALY_VALUE"));
                this.jPredictionLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_ANOMALY_VALUE");
            }
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel();
            Vector<Object> vector = ((PredictionFunctionsHelper.DefaultPredictionProbability)parameters).getTargetValues();
            if (vector != null) {
                defaultComboBoxModel = new DefaultComboBoxModel<Object>(vector);
            } else {
                vector = new Vector();
            }
            if (!vector.contains(MOST_LIKELY)) {
                defaultComboBoxModel.insertElementAt(MOST_LIKELY, 0);
            }
            this.jPredictionComboBox.setModel(defaultComboBoxModel);
            this.jPredictionComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (DynamicApplyOutputPanel.this.loading) {
                        return;
                    }
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    Object object = jComboBox.getSelectedItem();
                    if (DynamicApplyHelper.TYPICAL_STR.equals(object)) {
                        object = DynamicApplyHelper.TYPICAL;
                    }
                    if (DynamicApplyHelper.OUTLIER_STR.equals(object)) {
                        object = DynamicApplyHelper.OUTLIER;
                    }
                    if (MOST_LIKELY.equals(object)) {
                        object = null;
                    }
                    if (DynamicApplyOutputPanel.this.jAutoGenCheckBox.isSelected()) {
                        String string = DynamicApplyOutputPanel.this.state.createUniqueName(object != null ? object.toString() : null, "PROB", false);
                        DynamicApplyOutputPanel.this.jColumnTextField.setText(string);
                    }
                }
            });
            Object object = ((PredictionFunctionsHelper.DefaultPredictionProbability)parameters).getSelectedTarget();
            if (object == null) {
                this.jPredictionComboBox.setSelectedItem(MOST_LIKELY);
            } else {
                ComboBoxModel comboBoxModel = this.jPredictionComboBox.getModel();
                for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                    Object e = comboBoxModel.getElementAt(i);
                    if (e == null || !e.toString().equals(object)) continue;
                    this.jPredictionComboBox.setSelectedItem(e);
                    break;
                }
            }
        } else if (parameters instanceof PredictionFunctionsHelper.AnomalyPredictionDetails) {
            Object object;
            ComboBoxModel comboBoxModel;
            this.jPredictionLabel.setVisible(true);
            this.jPredictionComboBox.setVisible(true);
            ResourceUtils.resLabel((JLabel)this.jPredictionLabel, (Component)this.jPredictionComboBox, (String)DynamicNodesLrb.get("APPLY_OUTPUT_ANOMALY_VALUE"));
            this.jPredictionLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_ANOMALY_VALUE");
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel();
            Vector<Object> vector = ((PredictionFunctionsHelper.DefaultPredictionDetails)parameters).getTargetValues();
            if (vector != null) {
                defaultComboBoxModel = new DefaultComboBoxModel<Object>(vector);
            } else {
                vector = new Vector();
            }
            if (!vector.contains(MOST_LIKELY)) {
                defaultComboBoxModel.insertElementAt(MOST_LIKELY, 0);
            }
            this.jPredictionComboBox.setModel(defaultComboBoxModel);
            this.jPredictionComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (DynamicApplyOutputPanel.this.loading) {
                        return;
                    }
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    Object object = jComboBox.getSelectedItem();
                    if (DynamicApplyHelper.TYPICAL_STR.equals(object)) {
                        object = DynamicApplyHelper.TYPICAL;
                    }
                    if (DynamicApplyHelper.OUTLIER_STR.equals(object)) {
                        object = DynamicApplyHelper.OUTLIER;
                    }
                    if (MOST_LIKELY.equals(object)) {
                        object = null;
                    }
                    if (DynamicApplyOutputPanel.this.jAutoGenCheckBox.isSelected()) {
                        String string = "PDET";
                        String string2 = DynamicApplyOutputPanel.this.state.createUniqueName(object != null ? object.toString() : null, string, false);
                        DynamicApplyOutputPanel.this.jColumnTextField.setText(string2);
                    }
                }
            });
            Object object2 = ((PredictionFunctionsHelper.DefaultPredictionDetails)parameters).getSelectedTarget();
            if (object2 == null) {
                this.jPredictionComboBox.setSelectedItem(MOST_LIKELY);
            } else {
                comboBoxModel = this.jPredictionComboBox.getModel();
                for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                    object = comboBoxModel.getElementAt(i);
                    if (object == null || !object.toString().equals(object2)) continue;
                    this.jPredictionComboBox.setSelectedItem(object);
                    break;
                }
            }
            this.jSortLabel.setVisible(true);
            this.jSortComboBox.setVisible(true);
            ResourceUtils.resLabel((JLabel)this.jSortLabel, (Component)this.jSortComboBox, (String)DynamicNodesLrb.get("APPLY_SORT_BY"));
            this.jPredictionLabel.getAccessibleContext().setAccessibleName("APPLY_SORT_BY");
            comboBoxModel = new DefaultComboBoxModel();
            Vector<String> vector2 = ((PredictionFunctionsHelper.DefaultPredictionDetails)parameters).getSortValues();
            if (vector2 != null) {
                comboBoxModel = new DefaultComboBoxModel<String>(vector2);
            }
            this.jSortComboBox.setModel(comboBoxModel);
            object = ((PredictionFunctionsHelper.DefaultPredictionDetails)parameters).getSort();
            if (object == null) {
                this.jSortComboBox.setSelectedItem(ServerConstants.ApplyPredictionDetailsSort.toHuman("ABS"));
            } else {
                this.jSortComboBox.setSelectedItem(object);
            }
            this.jCutOffCheckBox.setVisible(true);
            this.jCutOffLabel.setVisible(true);
            this.jCutOffTextField.setVisible(true);
            BigInteger bigInteger = ((PredictionFunctionsHelper.DefaultPredictionDetails)parameters).getTopN();
            this.jCutOffCheckBox.setSelected(bigInteger != null && bigInteger.intValue() > 0);
            this.jCutOffCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DynamicApplyOutputPanel.this.jCutOffTextField.setEnabled(DynamicApplyOutputPanel.this.jCutOffCheckBox.isSelected());
                }
            });
            ResourceUtils.resButton((AbstractButton)this.jCutOffCheckBox, (String)DialogsLrb.get("APPLY_OUTPUT_MAX_ATTRS"));
            this.jCutOffCheckBox.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_MAX_ATTRS");
            ResourceUtils.resLabel((JLabel)this.jCutOffLabel, (Component)this.jCutOffTextField, (String)DialogsLrb.get("APPLY_OUTPUT_MAX_ATTRS_VALUE"));
            this.jCutOffLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_MAX_ATTRS_VALUE");
            this.jCutOffTextField.setDataType(Integer.class);
            this.jCutOffTextField.setSigned(false);
            this.jCutOffTextField.setNumber((Number)bigInteger);
            this.jCutOffTextField.setEnabled(this.jCutOffCheckBox.isSelected());
            this.jCutOffTextField.setToolTipText(DialogsLrb.get("APPLY_OUTPUT_MAX_ATTRS_TIP"));
        } else if (parameters instanceof PredictionFunctionsHelper.DefaultPredictionDetails) {
            Object object;
            ComboBoxModel comboBoxModel;
            if (this.selectedTarget != null) {
                if (parameters instanceof PredictionFunctionsHelper.PredictionDetails) {
                    this.jPredictionLabel.setVisible(true);
                    this.jPredictionComboBox.setVisible(true);
                    ResourceUtils.resLabel((JLabel)this.jPredictionLabel, (Component)this.jPredictionComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_TARGET"));
                    this.jPredictionLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_TARGET");
                }
            } else if (parameters instanceof PredictionFunctionsHelper.ClusterDetails) {
                this.jPredictionLabel.setVisible(true);
                this.jPredictionComboBox.setVisible(true);
                ResourceUtils.resLabel((JLabel)this.jPredictionLabel, (Component)this.jPredictionComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_CLUSTER"));
                this.jPredictionLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_CLUSTER");
            } else if (parameters instanceof PredictionFunctionsHelper.FeatureDetails) {
                this.jPredictionLabel.setVisible(true);
                this.jPredictionComboBox.setVisible(true);
                ResourceUtils.resLabel((JLabel)this.jPredictionLabel, (Component)this.jPredictionComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_FEATURE"));
                this.jPredictionLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_FEATURE");
            }
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel();
            Vector<Object> vector = ((PredictionFunctionsHelper.DefaultPredictionDetails)parameters).getTargetValues();
            if (vector != null) {
                defaultComboBoxModel = new DefaultComboBoxModel<Object>(vector);
            } else {
                vector = new Vector();
            }
            if (!vector.contains(MOST_LIKELY)) {
                defaultComboBoxModel.insertElementAt(MOST_LIKELY, 0);
            }
            this.jPredictionComboBox.setModel(defaultComboBoxModel);
            this.jPredictionComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (DynamicApplyOutputPanel.this.loading) {
                        return;
                    }
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    Object object = jComboBox.getSelectedItem();
                    if (DynamicApplyHelper.TYPICAL_STR.equals(object)) {
                        object = DynamicApplyHelper.TYPICAL;
                    }
                    if (DynamicApplyHelper.OUTLIER_STR.equals(object)) {
                        object = DynamicApplyHelper.OUTLIER;
                    }
                    if (MOST_LIKELY.equals(object)) {
                        object = null;
                    }
                    if (DynamicApplyOutputPanel.this.jAutoGenCheckBox.isSelected()) {
                        String string = DynamicApplyOutputPanel.this.jPredictionLabel.getAccessibleContext().getAccessibleName();
                        String string2 = null;
                        string2 = string.equals("APPLY_OUTPUT_TARGET") ? "PDET" : (string.equals("APPLY_OUTPUT_TARGET") ? "CDET" : "FDET");
                        String string3 = DynamicApplyOutputPanel.this.state.createUniqueName(object != null ? object.toString() : null, string2, false);
                        DynamicApplyOutputPanel.this.jColumnTextField.setText(string3);
                    }
                }
            });
            Object object3 = ((PredictionFunctionsHelper.DefaultPredictionDetails)parameters).getSelectedTarget();
            if (object3 == null) {
                this.jPredictionComboBox.setSelectedItem(MOST_LIKELY);
            } else {
                comboBoxModel = this.jPredictionComboBox.getModel();
                for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                    object = comboBoxModel.getElementAt(i);
                    if (object == null || !object.toString().equals(object3)) continue;
                    this.jPredictionComboBox.setSelectedItem(object);
                    break;
                }
            }
            this.jSortLabel.setVisible(true);
            this.jSortComboBox.setVisible(true);
            ResourceUtils.resLabel((JLabel)this.jSortLabel, (Component)this.jSortComboBox, (String)DynamicNodesLrb.get("APPLY_SORT_BY"));
            this.jSortLabel.getAccessibleContext().setAccessibleName("APPLY_SORT_BY");
            comboBoxModel = new DefaultComboBoxModel();
            Vector<String> vector3 = ((PredictionFunctionsHelper.DefaultPredictionDetails)parameters).getSortValues();
            if (vector3 != null) {
                comboBoxModel = new DefaultComboBoxModel<String>(vector3);
            }
            this.jSortComboBox.setModel(comboBoxModel);
            object = ((PredictionFunctionsHelper.DefaultPredictionDetails)parameters).getSort();
            if (object == null) {
                this.jSortComboBox.setSelectedItem(ServerConstants.ApplyPredictionDetailsSort.toHuman("ABS"));
            } else {
                this.jSortComboBox.setSelectedItem(object);
            }
            this.jCutOffCheckBox.setVisible(true);
            this.jCutOffLabel.setVisible(true);
            this.jCutOffTextField.setVisible(true);
            BigInteger bigInteger = ((PredictionFunctionsHelper.DefaultPredictionDetails)parameters).getTopN();
            this.jCutOffCheckBox.setSelected(bigInteger != null && bigInteger.intValue() > 0);
            this.jCutOffCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DynamicApplyOutputPanel.this.jCutOffTextField.setEnabled(DynamicApplyOutputPanel.this.jCutOffCheckBox.isSelected());
                }
            });
            ResourceUtils.resButton((AbstractButton)this.jCutOffCheckBox, (String)DialogsLrb.get("APPLY_OUTPUT_MAX_ATTRS"));
            this.jCutOffCheckBox.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_MAX_ATTRS");
            ResourceUtils.resLabel((JLabel)this.jCutOffLabel, (Component)this.jCutOffTextField, (String)DialogsLrb.get("APPLY_OUTPUT_MAX_ATTRS_VALUE"));
            this.jCutOffLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_MAX_ATTRS_VALUE");
            this.jCutOffTextField.setDataType(Integer.class);
            this.jCutOffTextField.setSigned(false);
            this.jCutOffTextField.setNumber((Number)bigInteger);
            this.jCutOffTextField.setEnabled(this.jCutOffCheckBox.isSelected());
            this.jCutOffTextField.setToolTipText(DialogsLrb.get("APPLY_OUTPUT_MAX_ATTRS_TIP"));
        } else if (parameters instanceof PredictionFunctionsHelper.DefaultPredictionSet) {
            this.jBestNCheckBox.setVisible(true);
            this.jNValueLabel.setVisible(true);
            this.jNValueComboBox.setVisible(true);
            this.jCutOffCheckBox.setVisible(true);
            this.jCutOffLabel.setVisible(true);
            this.jCutOffTextField.setVisible(true);
            BigInteger bigInteger = ((PredictionFunctionsHelper.DefaultPredictionSet)parameters).getTopN();
            this.jBestNCheckBox.setSelected(bigInteger != null && bigInteger.intValue() >= 0);
            this.jBestNCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DynamicApplyOutputPanel.this.jNValueComboBox.setEnabled(DynamicApplyOutputPanel.this.jBestNCheckBox.isSelected());
                }
            });
            ResourceUtils.resButton((AbstractButton)this.jBestNCheckBox, (String)DialogsLrb.get("APPLY_OUTPUT_USE_BEST_N"));
            this.jBestNCheckBox.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_USE_BEST_N");
            ResourceUtils.resLabel((JLabel)this.jNValueLabel, (Component)this.jNValueComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_N_VALUE"));
            this.jNValueLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_N_VALUE");
            int n = ((PredictionFunctionsHelper.DefaultPredictionSet)parameters).getMaxN();
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            defaultComboBoxModel.addElement(PredictionFunctionsHelper.ALL);
            for (int i = 1; i <= n; ++i) {
                defaultComboBoxModel.addElement(String.valueOf(i));
            }
            this.jNValueComboBox.setModel(defaultComboBoxModel);
            this.jNValueComboBox.setEnabled(this.jBestNCheckBox.isSelected());
            if (bigInteger != null && bigInteger != PredictionFunctionsHelper.TOPN_VALUE) {
                this.jNValueComboBox.setSelectedItem(bigInteger.toString());
            } else {
                this.jNValueComboBox.setSelectedItem(PredictionFunctionsHelper.ALL);
            }
            Double d = null;
            String string = null;
            String string2 = null;
            if (((PredictionFunctionsHelper.DefaultPredictionSet)parameters).getUseCostType().compareTo("Model") == 0) {
                d = ((PredictionFunctionsHelper.PredictionSet)parameters).getCostCutOff();
                string = DialogsLrb.get("APPLY_OUTPUT_COST_VALUE");
                string2 = DialogsLrb.get("APPLY_OUTPUT_COST_VALUE_TIP");
            } else {
                d = ((PredictionFunctionsHelper.DefaultPredictionSet)parameters).getCutOff();
                string = DialogsLrb.get("APPLY_OUTPUT_PROB_VALUE");
                string2 = DialogsLrb.get("APPLY_OUTPUT_PROB_VALUE_TIP");
            }
            boolean bl2 = d != null && d > 0.0;
            this.jCutOffCheckBox.setSelected(bl2);
            this.jCutOffCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DynamicApplyOutputPanel.this.jCutOffTextField.setEnabled(DynamicApplyOutputPanel.this.jCutOffCheckBox.isSelected());
                }
            });
            ResourceUtils.resButton((AbstractButton)this.jCutOffCheckBox, (String)DialogsLrb.get("APPLY_OUTPUT_USE_CUTOFF"));
            this.jCutOffCheckBox.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_USE_CUTOFF");
            ResourceUtils.resLabel((JLabel)this.jCutOffLabel, (Component)this.jCutOffTextField, (String)string);
            this.jCutOffLabel.getAccessibleContext().setAccessibleName(string);
            this.jCutOffTextField.setDataType(Double.class);
            this.jCutOffTextField.setSigned(false);
            this.jCutOffTextField.setNumber((Number)d);
            this.jCutOffTextField.setEnabled(this.jCutOffCheckBox.isSelected());
            this.jCutOffTextField.setToolTipText(string2);
        } else if (parameters instanceof PredictionFunctionsHelper.ClusterProbability) {
            this.jPredictionLabel.setVisible(true);
            this.jPredictionComboBox.setVisible(true);
            ResourceUtils.resLabel((JLabel)this.jPredictionLabel, (Component)this.jPredictionComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_CLUSTER"));
            this.jPredictionLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_CLUSTER");
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel();
            Vector<Object> vector = this.state.getNodeSpecificTargetValues(null);
            if (vector != null) {
                defaultComboBoxModel = new DefaultComboBoxModel<Object>(vector);
            }
            if (!vector.contains(MOST_LIKELY)) {
                defaultComboBoxModel.insertElementAt(MOST_LIKELY, 0);
            }
            this.jPredictionComboBox.setModel(defaultComboBoxModel);
            this.jPredictionComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (DynamicApplyOutputPanel.this.loading) {
                        return;
                    }
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    Object object = jComboBox.getSelectedItem();
                    if (MOST_LIKELY.equals(object)) {
                        object = null;
                    }
                    if (DynamicApplyOutputPanel.this.jAutoGenCheckBox.isSelected()) {
                        String string = DynamicApplyOutputPanel.this.state.createUniqueName(object != null ? object.toString() : null, "PROB", false);
                        DynamicApplyOutputPanel.this.jColumnTextField.setText(string);
                    }
                }
            });
            Object object = ((PredictionFunctionsHelper.ClusterProbability)parameters).getClusterId();
            if (object == null) {
                this.jPredictionComboBox.setSelectedItem(MOST_LIKELY);
            } else {
                ComboBoxModel comboBoxModel = this.jPredictionComboBox.getModel();
                for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                    Object e = comboBoxModel.getElementAt(i);
                    if (e == null || !e.toString().equals(object)) continue;
                    this.jPredictionComboBox.setSelectedItem(e);
                    break;
                }
            }
        } else if (parameters instanceof PredictionFunctionsHelper.ClusterDistance) {
            this.jPredictionLabel.setVisible(true);
            this.jPredictionComboBox.setVisible(true);
            ResourceUtils.resLabel((JLabel)this.jPredictionLabel, (Component)this.jPredictionComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_CLUSTER"));
            this.jPredictionLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_CLUSTER");
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel();
            Vector<Object> vector = this.state.getNodeSpecificTargetValues(null);
            if (vector != null) {
                defaultComboBoxModel = new DefaultComboBoxModel<Object>(vector);
            }
            if (!vector.contains(MOST_LIKELY)) {
                defaultComboBoxModel.insertElementAt(MOST_LIKELY, 0);
            }
            this.jPredictionComboBox.setModel(defaultComboBoxModel);
            this.jPredictionComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (DynamicApplyOutputPanel.this.loading) {
                        return;
                    }
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    Object object = jComboBox.getSelectedItem();
                    if (MOST_LIKELY.equals(object)) {
                        object = null;
                    }
                    if (DynamicApplyOutputPanel.this.jAutoGenCheckBox.isSelected()) {
                        String string = DynamicApplyOutputPanel.this.state.createUniqueName(object != null ? object.toString() : null, "CDST", false);
                        DynamicApplyOutputPanel.this.jColumnTextField.setText(string);
                    }
                }
            });
            Object object = ((PredictionFunctionsHelper.ClusterDistance)parameters).getClusterId();
            if (object == null) {
                this.jPredictionComboBox.setSelectedItem(MOST_LIKELY);
            } else {
                ComboBoxModel comboBoxModel = this.jPredictionComboBox.getModel();
                for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                    Object e = comboBoxModel.getElementAt(i);
                    if (e == null || !e.toString().equals(object)) continue;
                    this.jPredictionComboBox.setSelectedItem(e);
                    break;
                }
            }
        } else if (parameters instanceof PredictionFunctionsHelper.ClusterSet) {
            this.jBestNCheckBox.setVisible(true);
            this.jNValueLabel.setVisible(true);
            this.jNValueComboBox.setVisible(true);
            this.jCutOffCheckBox.setVisible(true);
            this.jCutOffLabel.setVisible(true);
            this.jCutOffTextField.setVisible(true);
            int n = ((PredictionFunctionsHelper.ClusterSet)parameters).getMaxN();
            BigInteger bigInteger = ((PredictionFunctionsHelper.ClusterSet)parameters).getTopN();
            this.jBestNCheckBox.setSelected(bigInteger != null && bigInteger.intValue() >= 0);
            this.jBestNCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DynamicApplyOutputPanel.this.jNValueComboBox.setEnabled(DynamicApplyOutputPanel.this.jBestNCheckBox.isSelected());
                }
            });
            ResourceUtils.resButton((AbstractButton)this.jBestNCheckBox, (String)DialogsLrb.get("APPLY_OUTPUT_USE_BEST_N"));
            this.jBestNCheckBox.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_USE_BEST_N");
            ResourceUtils.resLabel((JLabel)this.jNValueLabel, (Component)this.jNValueComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_N_VALUE"));
            this.jNValueLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_N_VALUE");
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            defaultComboBoxModel.addElement(PredictionFunctionsHelper.ALL);
            for (int i = 1; i <= n; ++i) {
                defaultComboBoxModel.addElement(String.valueOf(i));
            }
            this.jNValueComboBox.setModel(defaultComboBoxModel);
            this.jNValueComboBox.setEnabled(this.jBestNCheckBox.isSelected());
            if (bigInteger != null && bigInteger != PredictionFunctionsHelper.TOPN_VALUE) {
                this.jNValueComboBox.setSelectedItem(bigInteger.toString());
            } else {
                this.jNValueComboBox.setSelectedItem(PredictionFunctionsHelper.ALL);
            }
            Double d = ((PredictionFunctionsHelper.ClusterSet)parameters).getCutOff();
            this.jCutOffCheckBox.setSelected(d != null && d > 0.0);
            this.jCutOffCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DynamicApplyOutputPanel.this.jCutOffTextField.setEnabled(DynamicApplyOutputPanel.this.jCutOffCheckBox.isSelected());
                }
            });
            ResourceUtils.resButton((AbstractButton)this.jCutOffCheckBox, (String)DialogsLrb.get("APPLY_OUTPUT_USE_CUTOFF"));
            this.jCutOffCheckBox.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_USE_CUTOFF");
            ResourceUtils.resLabel((JLabel)this.jCutOffLabel, (Component)this.jCutOffTextField, (String)DialogsLrb.get("APPLY_OUTPUT_PROB_VALUE"));
            this.jCutOffLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_PROB_VALUE");
            this.jCutOffTextField.setDataType(Double.class);
            this.jCutOffTextField.setSigned(false);
            this.jCutOffTextField.setNumber((Number)d);
            this.jCutOffTextField.setEnabled(this.jCutOffCheckBox.isSelected());
            this.jCutOffTextField.setToolTipText(DialogsLrb.get("PAGE_OUTPUT_TOPN_CUTOFF_VALUE_TIP"));
        } else if (parameters instanceof PredictionFunctionsHelper.FeatureValue) {
            this.jPredictionLabel.setVisible(true);
            this.jPredictionComboBox.setVisible(true);
            ResourceUtils.resLabel((JLabel)this.jPredictionLabel, (Component)this.jPredictionComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_FEATURE"));
            this.jPredictionLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_FEATURE");
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel();
            Vector<Object> vector = ((PredictionFunctionsHelper.FeatureValue)parameters).getFeatureIds();
            if (vector != null) {
                defaultComboBoxModel = new DefaultComboBoxModel<Object>(vector);
            }
            if (!vector.contains(MOST_LIKELY)) {
                defaultComboBoxModel.insertElementAt(MOST_LIKELY, 0);
            }
            this.jPredictionComboBox.setModel(defaultComboBoxModel);
            this.jPredictionComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (DynamicApplyOutputPanel.this.loading) {
                        return;
                    }
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    Object object = jComboBox.getSelectedItem();
                    if (MOST_LIKELY.equals(object)) {
                        object = null;
                    }
                    if (DynamicApplyOutputPanel.this.jAutoGenCheckBox.isSelected()) {
                        String string = DynamicApplyOutputPanel.this.state.createUniqueName(object != null ? object.toString() : null, "FVAL", false);
                        DynamicApplyOutputPanel.this.jColumnTextField.setText(string);
                    }
                }
            });
            Object object = ((PredictionFunctionsHelper.FeatureValue)parameters).getFeatureId();
            if (object == null) {
                this.jPredictionComboBox.setSelectedItem(MOST_LIKELY);
            } else {
                ComboBoxModel comboBoxModel = this.jPredictionComboBox.getModel();
                for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                    Object e = comboBoxModel.getElementAt(i);
                    if (e == null || !e.toString().equals(object)) continue;
                    this.jPredictionComboBox.setSelectedItem(e);
                    break;
                }
            }
        } else if (parameters instanceof PredictionFunctionsHelper.FeatureSet) {
            this.jBestNCheckBox.setVisible(true);
            this.jNValueLabel.setVisible(true);
            this.jNValueComboBox.setVisible(true);
            this.jCutOffCheckBox.setVisible(true);
            this.jCutOffLabel.setVisible(true);
            this.jCutOffTextField.setVisible(true);
            BigInteger bigInteger = ((PredictionFunctionsHelper.FeatureSet)parameters).getTopN();
            this.jBestNCheckBox.setSelected(bigInteger != null && bigInteger.intValue() >= 0);
            this.jBestNCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DynamicApplyOutputPanel.this.jNValueComboBox.setEnabled(DynamicApplyOutputPanel.this.jBestNCheckBox.isSelected());
                }
            });
            ResourceUtils.resButton((AbstractButton)this.jBestNCheckBox, (String)DialogsLrb.get("APPLY_OUTPUT_USE_BEST_N"));
            this.jBestNCheckBox.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_USE_BEST_N");
            ResourceUtils.resLabel((JLabel)this.jNValueLabel, (Component)this.jNValueComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_N_VALUE"));
            this.jNValueLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_N_VALUE");
            int n = ((PredictionFunctionsHelper.FeatureSet)parameters).getMaxN();
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            defaultComboBoxModel.addElement(PredictionFunctionsHelper.ALL);
            for (int i = 1; i <= n; ++i) {
                defaultComboBoxModel.addElement(String.valueOf(i));
            }
            this.jNValueComboBox.setModel(defaultComboBoxModel);
            this.jNValueComboBox.setEnabled(this.jBestNCheckBox.isSelected());
            if (bigInteger != null && bigInteger != PredictionFunctionsHelper.TOPN_VALUE) {
                this.jNValueComboBox.setSelectedItem(bigInteger.toString());
            } else {
                this.jNValueComboBox.setSelectedItem(PredictionFunctionsHelper.ALL);
            }
            Double d = ((PredictionFunctionsHelper.FeatureSet)parameters).getCutOff();
            this.jCutOffCheckBox.setSelected(d != null && d > 0.0);
            this.jCutOffCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DynamicApplyOutputPanel.this.jCutOffTextField.setEnabled(DynamicApplyOutputPanel.this.jCutOffCheckBox.isSelected());
                }
            });
            ResourceUtils.resButton((AbstractButton)this.jCutOffCheckBox, (String)DialogsLrb.get("APPLY_OUTPUT_USE_CUTOFF"));
            this.jCutOffCheckBox.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_USE_CUTOFF");
            ResourceUtils.resLabel((JLabel)this.jCutOffLabel, (Component)this.jCutOffTextField, (String)DialogsLrb.get("APPLY_OUTPUT_PROB_VALUE"));
            this.jCutOffLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_PROB_VALUE");
            this.jCutOffTextField.setDataType(Double.class);
            this.jCutOffTextField.setSigned(false);
            this.jCutOffTextField.setNumber((Number)d);
            this.jCutOffTextField.setEnabled(this.jCutOffCheckBox.isSelected());
            this.jCutOffTextField.setToolTipText(DialogsLrb.get("PAGE_OUTPUT_TOPN_CUTOFF_VALUE_TIP"));
        } else {
            bl = false;
        }
        this.jParamsPanel.setVisible(bl);
        this.revalidate();
        this.loading = false;
    }

    private PredictionFunctionsHelper.Parameters getUserParameters(PredictionFunctionsHelper.Parameters parameters) throws ValidationException {
        String string = this.jColumnTextField.getText();
        if (parameters instanceof PredictionFunctionsHelper.Prediction) {
            parameters.setColumn(string);
            return parameters;
        }
        if (parameters instanceof PredictionFunctionsHelper.DefaultPredictionDetails) {
            Object object;
            PredictionFunctionsHelper.DefaultPredictionDetails defaultPredictionDetails = (PredictionFunctionsHelper.DefaultPredictionDetails)parameters;
            if (this.jPredictionComboBox != null) {
                object = this.jPredictionComboBox.getSelectedItem();
                if (MOST_LIKELY.equals(object)) {
                    object = null;
                }
                defaultPredictionDetails.setSelectedTarget(object);
            }
            object = (String)this.jSortComboBox.getSelectedItem();
            defaultPredictionDetails.setSort((String)object);
            defaultPredictionDetails.setColumn(string);
            Number number = null;
            boolean bl = this.jCutOffCheckBox.isSelected();
            if (bl) {
                number = this.jCutOffTextField.getNumber();
            }
            defaultPredictionDetails.setUseTopN(bl);
            defaultPredictionDetails.setTopN(bl && number != null ? BigInteger.valueOf(number.longValue()) : null);
            defaultPredictionDetails.validate();
            return defaultPredictionDetails;
        }
        if (parameters instanceof PredictionFunctionsHelper.DefaultPredictionProbability) {
            PredictionFunctionsHelper.DefaultPredictionProbability defaultPredictionProbability = (PredictionFunctionsHelper.DefaultPredictionProbability)parameters;
            Object object = this.jPredictionComboBox.getSelectedItem();
            if (MOST_LIKELY.equals(object)) {
                object = null;
            }
            defaultPredictionProbability.setColumn(string);
            defaultPredictionProbability.setSelectedTarget(object);
            return defaultPredictionProbability;
        }
        if (parameters instanceof PredictionFunctionsHelper.DefaultPredictionSet) {
            PredictionFunctionsHelper.DefaultPredictionSet defaultPredictionSet = (PredictionFunctionsHelper.DefaultPredictionSet)parameters;
            String string2 = null;
            boolean bl = this.jBestNCheckBox.isSelected();
            if (bl) {
                string2 = (String)this.jNValueComboBox.getSelectedItem();
            }
            Double d = null;
            boolean bl2 = this.jCutOffCheckBox.isSelected();
            if (bl2) {
                d = (Double)this.jCutOffTextField.getNumber();
            }
            defaultPredictionSet.setColumn(string);
            defaultPredictionSet.setUseTopN(bl);
            defaultPredictionSet.setTopN(bl ? (!string2.equals(PredictionFunctionsHelper.ALL) ? new BigInteger(string2) : PredictionFunctionsHelper.TOPN_VALUE) : null);
            if (defaultPredictionSet.getUseCostType().compareTo("None") == 0) {
                defaultPredictionSet.setUseCutOff(bl2);
                defaultPredictionSet.setCutOff(bl2 ? d : null);
            } else {
                defaultPredictionSet.setUseCostCutOff(bl2);
                defaultPredictionSet.setCostCutOff(bl2 ? d : null);
            }
            defaultPredictionSet.validate();
            return defaultPredictionSet;
        }
        if (parameters instanceof PredictionFunctionsHelper.ClusterId) {
            PredictionFunctionsHelper.ClusterId clusterId = (PredictionFunctionsHelper.ClusterId)parameters;
            clusterId.setColumn(string);
            return clusterId;
        }
        if (parameters instanceof PredictionFunctionsHelper.ClusterProbability) {
            PredictionFunctionsHelper.ClusterProbability clusterProbability = (PredictionFunctionsHelper.ClusterProbability)parameters;
            Object object = this.jPredictionComboBox.getSelectedItem();
            if (MOST_LIKELY.equals(object)) {
                object = null;
            }
            clusterProbability.setColumn(string);
            clusterProbability.setClusterId(object);
            return clusterProbability;
        }
        if (parameters instanceof PredictionFunctionsHelper.ClusterDistance) {
            PredictionFunctionsHelper.ClusterDistance clusterDistance = (PredictionFunctionsHelper.ClusterDistance)parameters;
            Object object = this.jPredictionComboBox.getSelectedItem();
            if (MOST_LIKELY.equals(object)) {
                object = null;
            }
            clusterDistance.setColumn(string);
            clusterDistance.setClusterId(object);
            return clusterDistance;
        }
        if (parameters instanceof PredictionFunctionsHelper.ClusterSet) {
            PredictionFunctionsHelper.ClusterSet clusterSet = (PredictionFunctionsHelper.ClusterSet)parameters;
            String string3 = null;
            boolean bl = this.jBestNCheckBox.isSelected();
            if (bl) {
                string3 = (String)this.jNValueComboBox.getSelectedItem();
            }
            Double d = null;
            boolean bl3 = this.jCutOffCheckBox.isSelected();
            if (bl3) {
                d = (Double)this.jCutOffTextField.getNumber();
            }
            clusterSet.setColumn(string);
            clusterSet.setUseTopN(bl);
            clusterSet.setTopN(bl ? (!string3.equals(PredictionFunctionsHelper.ALL) ? new BigInteger(string3) : PredictionFunctionsHelper.TOPN_VALUE) : null);
            clusterSet.setUseCutOff(bl3);
            clusterSet.setCutOff(bl3 ? d : null);
            clusterSet.validate();
            return clusterSet;
        }
        if (parameters instanceof PredictionFunctionsHelper.FeatureId) {
            PredictionFunctionsHelper.FeatureId featureId = (PredictionFunctionsHelper.FeatureId)parameters;
            featureId.setColumn(string);
            return featureId;
        }
        if (parameters instanceof PredictionFunctionsHelper.FeatureValue) {
            PredictionFunctionsHelper.FeatureValue featureValue = (PredictionFunctionsHelper.FeatureValue)parameters;
            Object object = this.jPredictionComboBox.getSelectedItem();
            if (MOST_LIKELY.equals(object)) {
                object = null;
            }
            featureValue.setColumn(string);
            featureValue.setFeatureId(object);
            return featureValue;
        }
        if (parameters instanceof PredictionFunctionsHelper.FeatureSet) {
            PredictionFunctionsHelper.FeatureSet featureSet = (PredictionFunctionsHelper.FeatureSet)parameters;
            String string4 = null;
            boolean bl = this.jBestNCheckBox.isSelected();
            if (bl) {
                string4 = (String)this.jNValueComboBox.getSelectedItem();
            }
            Double d = null;
            boolean bl4 = this.jCutOffCheckBox.isSelected();
            if (bl4) {
                d = (Double)this.jCutOffTextField.getNumber();
            }
            featureSet.setColumn(string);
            featureSet.setUseTopN(bl);
            featureSet.setTopN(bl ? (!string4.equals(PredictionFunctionsHelper.ALL) ? new BigInteger(string4) : PredictionFunctionsHelper.TOPN_VALUE) : null);
            featureSet.setUseCutOff(bl4);
            featureSet.setCutOff(bl4 ? d : null);
            featureSet.validate();
            return featureSet;
        }
        return null;
    }

    private void initComponents() {
        this.jColumnLabel = new JLabel();
        this.jColumnTextField = new JTextField();
        this.jAutoGenCheckBox = new JCheckBox();
        this.jFunctionLabel = new JLabel();
        this.jFunctionComboBox = new JComboBox();
        this.jParamsPanel = new JPanel();
        this.jPredictionLabel = new JLabel();
        this.jPredictionComboBox = new JComboBox();
        this.jConfidenceLabel = new JLabel();
        this.jConfidenceField = new NumberTextField();
        this.jSortLabel = new JLabel();
        this.jSortComboBox = new JComboBox();
        this.jBestNCheckBox = new JCheckBox();
        this.jNValueLabel = new JLabel();
        this.jNValueComboBox = new JComboBox();
        this.jCutOffCheckBox = new JCheckBox();
        this.jCutOffLabel = new JLabel();
        this.jCutOffTextField = new NumberTextField();
        this.jColumnLabel.setLabelFor(this.jColumnTextField);
        this.jColumnLabel.setText("Column:");
        this.jColumnLabel.setName("jColumnLabel");
        this.jColumnTextField.setName("jColumnTextField");
        this.jAutoGenCheckBox.setText("Auto");
        this.jAutoGenCheckBox.setName("jAutoGenCheckBox");
        this.jAutoGenCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicApplyOutputPanel.this.jAutoGenCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jFunctionLabel.setLabelFor(this.jFunctionComboBox);
        this.jFunctionLabel.setText("Function:");
        this.jFunctionLabel.setName("jFunctionLabel");
        this.jFunctionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jFunctionComboBox.setName("jFunctionComboBox");
        this.jFunctionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicApplyOutputPanel.this.jFunctionComboBoxActionPerformed(actionEvent);
            }
        });
        this.jParamsPanel.setBorder(BorderFactory.createTitledBorder("Parameters"));
        this.jParamsPanel.setName("jParamsPanel");
        this.jPredictionLabel.setLabelFor(this.jPredictionComboBox);
        this.jPredictionLabel.setText("Prediction:");
        this.jPredictionLabel.setName("jPredictionLabel");
        this.jPredictionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jPredictionComboBox.setName("jPredictionComboBox");
        this.jConfidenceLabel.setLabelFor((Component)this.jConfidenceField);
        this.jConfidenceLabel.setText("Confidence (%):");
        this.jConfidenceLabel.setName("jConfidenceLabel");
        this.jConfidenceField.setName("jConfidenceField");
        this.jSortLabel.setLabelFor(this.jSortComboBox);
        this.jSortLabel.setText("Sort By:");
        this.jSortLabel.setName("jSortLabel");
        this.jSortComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jSortComboBox.setName("jSortComboBox");
        this.jBestNCheckBox.setText("Best N");
        this.jBestNCheckBox.setName("jBestNCheckBox");
        this.jNValueLabel.setLabelFor(this.jNValueComboBox);
        this.jNValueLabel.setText("N Value:");
        this.jNValueLabel.setName("jNValueLabel");
        this.jNValueComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jNValueComboBox.setName("jNValueComboBox");
        this.jCutOffCheckBox.setText("CutOff");
        this.jCutOffCheckBox.setName("jCutOffCheckBox");
        this.jCutOffLabel.setLabelFor((Component)this.jCutOffTextField);
        this.jCutOffLabel.setText("Prob Value:");
        this.jCutOffLabel.setName("jCutOffLabel");
        this.jCutOffTextField.setName("jCutOffTextField");
        GroupLayout groupLayout = new GroupLayout(this.jParamsPanel);
        this.jParamsPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPredictionLabel).addComponent(this.jConfidenceLabel).addComponent(this.jSortLabel, -2, 82, -2).addGroup(groupLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jNValueLabel).addComponent(this.jCutOffLabel, -1, -1, Short.MAX_VALUE)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPredictionComboBox, 0, 164, Short.MAX_VALUE).addComponent((Component)this.jConfidenceField, -1, 164, Short.MAX_VALUE).addComponent(this.jSortComboBox, 0, 164, Short.MAX_VALUE).addComponent(this.jNValueComboBox, 0, 164, Short.MAX_VALUE).addComponent((Component)this.jCutOffTextField, -1, 164, Short.MAX_VALUE))).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jCutOffCheckBox, -1, 250, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jBestNCheckBox, -1, 250, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.linkSize(0, this.jConfidenceLabel, this.jPredictionLabel, this.jSortLabel);
        groupLayout.linkSize(0, this.jCutOffLabel, this.jNValueLabel);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jPredictionLabel).addComponent(this.jPredictionComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jConfidenceLabel).addComponent((Component)this.jConfidenceField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSortLabel).addComponent(this.jSortComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jBestNCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jNValueLabel).addComponent(this.jNValueComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCutOffCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCutOffLabel).addComponent((Component)this.jCutOffTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jColumnLabel, -2, 55, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jColumnTextField, -1, 282, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jAutoGenCheckBox).addContainerGap()).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jFunctionLabel, -2, 54, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jParamsPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jFunctionComboBox, GroupLayout.Alignment.TRAILING, 0, 282, Short.MAX_VALUE)).addGap(57, 57, 57)))));
        groupLayout2.linkSize(0, this.jColumnLabel, this.jFunctionLabel);
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jColumnLabel).addComponent(this.jAutoGenCheckBox).addComponent(this.jColumnTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFunctionLabel).addComponent(this.jFunctionComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jParamsPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jAutoGenCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (this.jAutoGenCheckBox.isSelected()) {
            String string = DynamicApplyHelper.getColumnName(this.applyOutputColumn);
            this.jColumnTextField.setText(string);
        }
        this.jColumnTextField.setEnabled(!this.jAutoGenCheckBox.isSelected());
    }

    private void jFunctionComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this.loading) {
            return;
        }
        String string = (String)this.jFunctionComboBox.getSelectedItem();
        if (!SELECT_A_FUNCTION.equals(string)) {
            this.jAutoGenCheckBox.setEnabled(true);
            this.jFunctionComboBox.removeItem(SELECT_A_FUNCTION);
            this.selectPredictionFunc = string;
            String string2 = this.selectedTarget != null ? this.selectedTarget.getName() : null;
            this.applyOutputColumn = this.state.generateDynamicApplyOutputColumn(string2, string);
            String string3 = DynamicApplyHelper.getColumnName(this.applyOutputColumn);
            this.jColumnTextField.setText(string3);
            Vector<Object> vector = this.state.getNodeSpecificTargetValues(string2);
            String string4 = this.selectedTarget != null ? this.selectedTarget.getMiningType() : null;
            String string5 = this.selectedTarget != null ? this.selectedTarget.getDataType() : null;
            this.selectFuncParameters = this.getData().getData() instanceof DynamicAnomalyNodeType ? DynamicAnomalyApplyHelper.getAnomalyFunctionParameters(this.applyOutputColumn) : DynamicApplyHelper.getPredictionFunctionParameters(this.applyOutputColumn, string5, string4, vector);
            if (this.jAutoGenCheckBox.isSelected()) {
                string3 = DynamicApplyHelper.getColumnName(this.applyOutputColumn);
                this.jColumnTextField.setText(string3);
            }
            this.populateParamUI(this.selectFuncParameters);
        }
    }

    public boolean doWork() {
        boolean bl = true;
        try {
            if (this.selectFuncParameters == null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("APPLY_OUTPUT_FUNCTION_NOT_SELECTED"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
            PredictionFunctionsHelper.Parameters parameters = this.getUserParameters(this.selectFuncParameters);
            String string = parameters.getColumn();
            if (string.length() > 30) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("APPLY_OUTPUT_COLUMN_TOO_LONG"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
            String string2 = this.checkDataLoss(string);
            if (string2 != null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
            if (this.mode.equals((Object)DynamicApplyOutputDialog.MODE.EDIT_TARGET)) {
                String string3 = DynamicApplyHelper.getPredictionFunctionOutput(this.applyOutputColumn);
                if (!string3.equals(string)) {
                    if (this.state.doesNameExist(string)) {
                        throw new ValidationException(DialogsLrb.get("APPLY_OPTION_DUPLICATE_COLUMN_ERROR"));
                    }
                    this.state.removeUniqueName(string3);
                    this.state.addUniqueName(string);
                    DynamicApplyHelper.setPredictionFunctionOutput(this.applyOutputColumn, string);
                }
            } else {
                if (this.state.doesNameExist(string)) {
                    throw new ValidationException(DialogsLrb.get("APPLY_OPTION_DUPLICATE_COLUMN_ERROR"));
                }
                this.state.addUniqueName(string);
            }
            DynamicApplyHelper.setPredictionFunctionParameters(this.applyOutputColumn, parameters);
            this.dirty = true;
        }
        catch (ValidationException validationException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)validationException.getLocalizedMessage(), (String)DialogsLrb.get("ERROR_TITLE"), null);
            bl = false;
        }
        return bl;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public DynamicApplyOutputColumnType getApplyOutputColumn() {
        return this.applyOutputColumn;
    }

    private String checkDataLoss(String string) {
        class DataLossDetector
        extends ProgressRunnable {
            private String errorMesg;
            private String column;

            public String checkDataLoss() {
                return this.errorMesg;
            }

            DataLossDetector(String string) {
                this.column = string;
            }

            protected Object doWork() throws Exception {
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = StringUtils.checkDataLoss(Connections.getUniqueConnection(DynamicApplyOutputPanel.this.getContext()), this.column, stringBuffer);
                if (bl) {
                    this.errorMesg = MessageFormat.format(TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_NAME_CONTAINS_SUPPORTED_CHARS"), stringBuffer);
                }
                return bl;
            }
        }
        DataLossDetector dataLossDetector = new DataLossDetector(string);
        dataLossDetector.setTitle(DynamicNodesLrb.get("VALIDATE_COLUMNS"));
        dataLossDetector.setMessage(DynamicNodesLrb.get("VALIDATE_COLUMNS_DESCR"));
        dataLossDetector.setCancelable(false);
        try {
            dataLossDetector.start(true);
        }
        catch (ProgressException progressException) {
            theLogger.log(Level.SEVERE, progressException.getMessage(), progressException);
        }
        return dataLossDetector.checkDataLoss();
    }
}

