/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.join;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.expressionbuilder.AbstractExpressionBuilderContext;
import oracle.dmt.dataminer.expressionbuilder.ExpressionBuilderDialog;
import oracle.dmt.dataminer.expressionbuilder.FilterJoinContext;
import oracle.dmt.dataminer.utils.PIAncestorListener;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.join.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.join.JoinColumnPanel;
import oracle.dmt.dataminer.workflow.dialog.join.JoinEditorPanel;
import oracle.dmt.dataminer.workflow.dialog.join.OutputColumnPanel;
import oracle.dmt.dataminer.workflow.inspect.JoinNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowJoinNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.JoinNode;
import oracle.dmt.dataminer.workflow.xmlschema.JoinKeyColumnsType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinOutputColumnsType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinSourceNodesType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.TransparentPanel;

public class FilterPanel
extends AbstractDialogPanel {
    private static final Logger theLogger = Logger.getLogger(FilterPanel.class.getName());
    private WorkflowJoinNodePropertyProxyModel _propertyModel;
    private JoinEditorPanel _parent;
    private String _filter;
    private JButton _removeBtn;
    private JButton _addBtn;
    private boolean _dirty;
    private ComponentWithTitlebar filterComponentWithTitlebar;
    private TransparentPanel filterTransparentPanel;
    JTextArea _filterTextArea = new JTextArea();

    public FilterPanel(PropertyModel propertyModel) {
        super(null, null);
        assert (propertyModel != null) : "PropertyModel for join node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this.addAncestorListener(new PIAncestorListener(this));
        this.init((JoinNode)this._data, propertyModel);
    }

    public FilterPanel(Context context, JoinNode joinNode, JoinEditorPanel joinEditorPanel) {
        super(context, joinNode);
        assert (context != null) : "Context must not be null.";
        assert (joinNode != null) : "Join node must not be null.";
        assert (joinNode instanceof JoinNode) : "Must be an instance of join node.";
        this._parent = joinEditorPanel;
        this.init(joinNode, this._parent.getModel());
    }

    private void init(JoinNode joinNode, PropertyModel propertyModel) {
        this._propertyModel = (WorkflowJoinNodePropertyProxyModel)propertyModel;
        this._dirty = false;
        JoinNodeType joinNodeType = (JoinNodeType)joinNode.getData();
        this._filter = this._propertyModel != null ? joinNodeType.getFilter() : this._parent.getFilter();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void updateNode() {
        JoinNode joinNode = (JoinNode)this.getData();
        JoinNodeType joinNodeType = (JoinNodeType)joinNode.getData();
        ComplexProperty complexProperty = new ComplexProperty("joinFilter", this._filter);
        complexProperty.setOldData(joinNodeType.getFilter());
        ArrayList<Property> arrayList = new ArrayList<Property>();
        arrayList.add(new Property(String.valueOf(JoinNodePropertyModel.RowIndex.JOIN_FILTER), null, complexProperty, null, null));
        this._propertyModel.setValueAt(PropertyLrb.get("PI_JOIN_GROUP_FILTER_CHANGED"), this.getData(), arrayList);
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        ControlBar controlBar = new ControlBar();
        this._addBtn = new JButton(InspectorArb.getIcon((int)24));
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.setEnabled(false);
        controlBar.add((Component)this._addBtn);
        controlBar.add((Component)this._removeBtn);
        this._filterTextArea.setText(this._filter);
        this._filterTextArea.setEditable(false);
        this._filterTextArea.setColumns(20);
        this._filterTextArea.setRows(5);
        JScrollPane jScrollPane = new JScrollPane(this._filterTextArea);
        this.filterComponentWithTitlebar.setComponent((JComponent)jScrollPane);
        this.filterComponentWithTitlebar.setControlBar(controlBar);
        if (this._propertyModel != null) {
            this.filterComponentWithTitlebar.setLabel(new JLabel(DialogsLrb.get("JOIN_FILTER_DEFINITION_PI")));
        } else {
            this.filterComponentWithTitlebar.setLabel(new JLabel(DialogsLrb.get("JOIN_FILTER_DEFINITION")));
        }
        this._addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FilterPanel.this.processAdd();
            }
        });
        this._addBtn.setToolTipText(DialogsLrb.get("JOIN_FILTER_EXPRESSION_BUILDER"));
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("JOIN_FILTER_REMOVE_WHERE"), (String)DialogsLrb.get("WARNING_TITLE"), null, (boolean)true)) {
                    return;
                }
                FilterPanel.this.processRemove();
            }
        });
        this._removeBtn.setToolTipText(DialogsLrb.get("JOIN_FILTER_REMOVE_EXPRESSION"));
        this.enableControls();
    }

    private void enableControls() {
        this._addBtn.setEnabled(this.isWritable());
        this._removeBtn.setEnabled(this.isWritable() && this._filterTextArea.getText() != null && this._filterTextArea.getText().length() > 0);
    }

    private void processAdd() {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        Serializable serializable2;
        JoinNode joinNode = (JoinNode)this.getData();
        JoinNodeType joinNodeType = (JoinNodeType)joinNode.getData();
        JoinSourceNodesType joinSourceNodesType = joinNodeType.getSourceNodes();
        JoinKeyColumnsType joinKeyColumnsType = joinNodeType.getKeyColumns();
        JoinOutputColumnsType joinOutputColumnsType = joinNodeType.getOutputColumns();
        String string = joinNodeType.getFilter();
        String string2 = joinNode.getInputSQL();
        if (this._parent != null) {
            serializable2 = this._parent.getDataPanel();
            serializable = this._parent.getKeyPanel();
            object3 = ((OutputColumnPanel)serializable2).getOutputColumns();
            object2 = ((JoinColumnPanel)serializable).getKeyColumns();
            object = ((JoinColumnPanel)serializable).getKeyNodes();
            joinNodeType.setSourceNodes((JoinSourceNodesType)object);
            joinNodeType.setKeyColumns((JoinKeyColumnsType)object2);
            joinNodeType.setOutputColumns((JoinOutputColumnsType)object3);
            joinNodeType.setSQLExpression(joinNode.generateSQLExpression());
            try {
                string2 = joinNode.getInputSQL();
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
            }
        }
        serializable2 = new ArrayList();
        serializable = new ArrayList();
        object3 = null;
        object3 = this._propertyModel != null ? (joinNodeType.isUseCartesian().booleanValue() ? JoinNode.findDataNodesUsedInJoins(joinNode, joinNodeType.getSourceNodes()) : JoinNode.findDataNodesUsedInJoins(joinNode, joinNodeType.getKeyColumns())) : (this._parent.getKeyPanel().isCartesianJoin() ? JoinNode.findDataNodesUsedInJoins(joinNode, this._parent.getKeyPanel().getKeyNodes()) : JoinNode.findDataNodesUsedInJoins(joinNode, this._parent.getKeyPanel().getKeyColumns()));
        if (object3.size() == 0) {
            object3 = joinNode.findJoinDataNode();
        }
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (AbstractNode)object2.next();
            if (!(object instanceof AbstractDataNode)) continue;
            AbstractDataNode abstractDataNode = (AbstractDataNode)object;
            ((ArrayList)serializable2).add(object);
            ((ArrayList)serializable).add(abstractDataNode.getInputSQL());
        }
        object2 = new FilterJoinContext(((ArrayList)serializable2).toArray(new AbstractNode[((ArrayList)serializable2).size()]), ((ArrayList)serializable).toArray(new String[((ArrayList)serializable).size()]), joinNode, string2, this._filter);
        object = new ExpressionBuilderDialog();
        if (((ExpressionBuilderDialog)object).invoke(this.getContext(), (AbstractExpressionBuilderContext)object2)) {
            this._filter = ((ExpressionBuilderDialog)object).getExpression();
            this._filterTextArea.setText(this._filter);
            this._dirty = true;
        }
        if (this._parent != null) {
            joinNodeType.setSourceNodes(joinSourceNodesType);
            joinNodeType.setKeyColumns(joinKeyColumnsType);
            joinNodeType.setOutputColumns(joinOutputColumnsType);
            joinNodeType.setFilter(string);
        }
        if (this._dirty && this._propertyModel != null) {
            this.updateNode();
        }
        this.enableControls();
    }

    private void processRemove() {
        this._filter = null;
        this._filterTextArea.setText(this._filter);
        this._dirty = true;
        if (this._propertyModel != null) {
            this.updateNode();
        }
        this.enableControls();
    }

    public void updatePI(PropertyModel propertyModel) {
        WorkflowJoinNodePropertyProxyModel workflowJoinNodePropertyProxyModel = (WorkflowJoinNodePropertyProxyModel)propertyModel;
        Context context = workflowJoinNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        JoinNode joinNode = (JoinNode)workflowNodeInspectorElement.getNode();
        if (joinNode == null) {
            return;
        }
        this._propertyModel = (WorkflowJoinNodePropertyProxyModel)propertyModel;
        this._context = context;
        this._data = joinNode;
        this._dirty = false;
        JoinNodeType joinNodeType = (JoinNodeType)joinNode.getData();
        this._filter = joinNodeType.getFilter();
        this.initUI();
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowJoinNodePropertyProxyModel)) {
            return null;
        }
        WorkflowJoinNodePropertyProxyModel workflowJoinNodePropertyProxyModel = (WorkflowJoinNodePropertyProxyModel)propertyModel;
        Context context = workflowJoinNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    private JoinNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowJoinNodePropertyProxyModel)) {
            return null;
        }
        WorkflowJoinNodePropertyProxyModel workflowJoinNodePropertyProxyModel = (WorkflowJoinNodePropertyProxyModel)propertyModel;
        Context context = workflowJoinNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof JoinNodeType) {
            return (JoinNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    private void initComponents() {
        this.filterTransparentPanel = new TransparentPanel();
        this.filterComponentWithTitlebar = new ComponentWithTitlebar();
        this.filterTransparentPanel.setName("filterTransparentPanel");
        this.filterComponentWithTitlebar.setName("filterComponentWithTitlebar");
        GroupLayout groupLayout = new GroupLayout((Container)this.filterTransparentPanel);
        this.filterTransparentPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.filterComponentWithTitlebar, -1, 616, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.filterComponentWithTitlebar, GroupLayout.Alignment.TRAILING, -1, 337, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 636, Short.MAX_VALUE).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent((Component)this.filterTransparentPanel, -1, -1, Short.MAX_VALUE).addContainerGap())));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 359, Short.MAX_VALUE).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent((Component)this.filterTransparentPanel, -1, -1, Short.MAX_VALUE).addContainerGap())));
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    public String getFilter() {
        return this._filter;
    }
}

