/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.model;

import java.awt.Component;
import java.awt.Dimension;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.utils.SimpleSearchListener;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.TargetValues;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;

public class TargetValuesPanel
extends JPanel
implements DataminerGUIPanel {
    private String _targetName;
    private String _targetDataType;
    private TargetValueTableModel _targetTableModel = null;
    private static final String[] _colNames = new String[]{DialogsLrb.get("TARGET_VALUES_DIALOG_TARGET_VALUES")};
    private JLabel _jTargetDataTypeLabel;
    private JLabel _jTargetDataTypeValue;
    private JLabel _jTargetNameLabel;
    private JLabel _jTargetNameValue;
    private ComponentWithTitlebar<JComponent> _jTargetValueComponent;
    private SearchField _searchField;
    private ControlBar controlBar;
    private JLabel jTargetLabel;
    private DataMinerTable jtargetValuesGenericTable;
    private JScrollPane tscrollerAvail;

    public TargetValuesPanel(String string, String string2, TargetValues targetValues) {
        this._targetName = string;
        this._targetDataType = string2;
        this._targetTableModel = targetValues.getTargetValueNumber() != null && targetValues.getTargetValueNumber().size() > 0 ? new TargetValueTableModel(targetValues, false) : (targetValues.getTargetValueString() != null && targetValues.getTargetValueString().size() > 0 ? new TargetValueTableModel(targetValues, true) : new TargetValueTableModel(new TargetValues(), true));
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.tscrollerAvail = new JScrollPane();
        this.jtargetValuesGenericTable = new DataMinerTable();
        this._searchField = new SearchField();
        this.controlBar = new ControlBar();
        this.controlBar.add((Component)this._searchField);
        this.jTargetLabel = new JLabel();
        this._jTargetValueComponent = new ComponentWithTitlebar();
        this._jTargetNameLabel = new JLabel();
        this._jTargetNameValue = new JLabel();
        this._jTargetDataTypeLabel = new JLabel();
        this._jTargetDataTypeValue = new JLabel();
        this.jtargetValuesGenericTable.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.tscrollerAvail.setViewportView((Component)((Object)this.jtargetValuesGenericTable));
        this._searchField.setAutoFind(true);
        this._searchField.setNotifyOnEmptySearch(true);
        this._searchField.setPreferredSize(new Dimension(160, 21));
        this._searchField.setPrompt(DialogsLrb.get("TARGET_VALUES_DIALOG_TARGET_VALUES"));
        this.controlBar.setPreferredSize(new Dimension(160, 25));
        this.jTargetLabel.setText(DialogsLrb.get("TARGET_VALUES_DIALOG_TARGET_VALUES_TABLE"));
        this._jTargetValueComponent.setComponent((JComponent)this.tscrollerAvail);
        this._jTargetValueComponent.setControlBar(this.controlBar);
        this._jTargetValueComponent.setLabel(this.jTargetLabel);
        this._jTargetNameLabel.setText("Target:");
        this._jTargetNameValue.setText("Churn");
        this._jTargetDataTypeLabel.setText("Data Type:");
        this._jTargetDataTypeValue.setText("VARCHAR2");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._jTargetValueComponent, -1, 397, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this._jTargetNameLabel, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jTargetNameValue, -2, 134, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this._jTargetDataTypeLabel, -2, 74, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jTargetDataTypeValue, -2, 80, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jTargetNameLabel).addComponent(this._jTargetNameValue).addComponent(this._jTargetDataTypeLabel).addComponent(this._jTargetDataTypeValue)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this._jTargetValueComponent, -1, 253, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initUI() {
        this.jtargetValuesGenericTable.setFillsViewportHeight(true);
        this.setupTable(this._targetTableModel);
        this._searchField.addSearchListener((SearchListener)new SimpleSearchListener((GenericTable)this.jtargetValuesGenericTable, 0));
        this._jTargetNameValue.setText(this._targetName);
        this._jTargetDataTypeValue.setText(this._targetDataType);
        if (this._targetName.length() == 0) {
            this._jTargetNameValue.setVisible(false);
            this._jTargetNameLabel.setVisible(false);
            this._jTargetDataTypeLabel.setVisible(false);
            this._jTargetDataTypeValue.setVisible(false);
        }
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this._jTargetNameLabel, (Component)this._jTargetNameValue, (String)(DialogsLrb.get("TARGET_VALUES_DIALOG_TARGET") + ":"));
        ResourceUtils.resLabel((JLabel)this._jTargetDataTypeLabel, (Component)this._jTargetDataTypeValue, (String)(DialogsLrb.get("TARGET_VALUES_DIALOG_TARGET_DATA_TYPE") + ":"));
    }

    private void setupTable(TargetValueTableModel targetValueTableModel) {
        this.jtargetValuesGenericTable.setModel((TableModel)((Object)targetValueTableModel));
        this.jtargetValuesGenericTable.setSorted(true);
        this.jtargetValuesGenericTable.setSortColumn(0, true);
        this.jtargetValuesGenericTable.setSelectionMode(2);
    }

    class TargetValueTableModel
    extends GenericBaseTableModel {
        private List<String> _stringData;
        private List<Double> _numberData;
        private boolean _isStringTargetValues = true;
        private NumberFormat _labelNumericalFormat = NumericFormat.getInstance(true, 8, 0, 0);
        public static final int VALUE = 0;
        private static final int COLUMN_COUNT = 1;

        public TargetValueTableModel(TargetValues targetValues, boolean bl) {
            this._isStringTargetValues = bl;
            if (this._isStringTargetValues) {
                this._stringData = targetValues.getTargetValueString();
                this.setRowCount(this._stringData.size());
            } else {
                this._numberData = targetValues.getTargetValueNumber();
                this.setRowCount(this._numberData.size());
            }
            this.setColumnIdentifiers(_colNames);
            this.setColumnCount(1);
        }

        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Object getValueAt(int n, int n2) {
            String string = null;
            if (0 == n2) {
                string = this._isStringTargetValues ? this._stringData.get(n) : this._labelNumericalFormat.format(this._numberData.get(n)) + "";
            }
            return string;
        }

        public List<String> getStringData() {
            return this._stringData;
        }

        public List<Double> getNumberData() {
            return this._numberData;
        }
    }
}

