/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.modeldetails;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.OutputAttributeType;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.server.model.MiningAlgorithmOptions;
import oracle.dmt.dataminer.server.model.MiningDetailsOutputType;
import oracle.dmt.dataminer.server.model.MiningFunctions;
import oracle.dmt.dataminer.server.model.ModelDetailsExtract;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.AvailableRefModelType;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.ModelDetailsLrb;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.ModelOutputColumnsListPanel;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.ModelsTableModel;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowModelDetailsNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.model.ModelDetailsDataNode;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailsDataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailsOutputType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.model.Element;
import oracle.ide.nulls.NullIcon;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.util.Version;

public class EditModelDetailsPanel
extends AbstractDialogPanel {
    private static final Logger theLogger = Logger.getLogger(EditModelDetailsPanel.class.getName());
    private Connection _dbConn;
    private String _ownerName;
    private boolean _dirty = false;
    private final String UNDEFINED = ModelDetailsLrb.get("UNDEFINED_SELECTION");
    private ModelDetailsOutputType _modelOutputType;
    private ModelDetailsOutputType _updatedModelOutputType = null;
    private List<RefModelType> _models;
    private ModelDetailsDataNode _node;
    private ModelsTableModel _selectedModelsTableModel;
    private ModelsTableModel _availableModelsTableModel;
    private GenericTable _selectedModelsGenericTable = new DataMinerTable();
    private GenericTable _availableModelsGenericTable = new DataMinerTable();
    private Component _findPane;
    private SearchField _searchField;
    private int _currentSearchCategory = 1;
    private SearchCategory _defaultSearchCategory = new SearchCategory(PropertyLrb.get("PI_MODEL_DETAILS_MODEL_COLUMN_MODEL"));
    private MiningFunctions _currentMiningFunction;
    private MiningAlgorithmOptions _currentAlgorithmOption;
    private MiningDetailsOutputType _currentMiningDetailOutputType;
    private List<OutputAttributeType> _currentOutputColumns;
    private ModelDetailType _modelDetailType;
    private static NullIcon _nullIcon;
    private Version _dbVersion = null;
    private ComponentWithTitlebar<JComponent> componentWithTitlebar1;
    private ComponentWithTitlebar<JComponent> componentWithTitlebar2;
    private JButton jDisplayColumnsButton;
    private JLabel jMiningAlgorithmSelectedLabel;
    private JLabel jMiningAlgorithmValue;
    private JLabel jMiningFunctionLabel;
    private JLabel jMiningFunctionSelectedLabel;
    private JLabel jMiningFunctionSelectedValue;
    private JLabel jMiningFunctionValue;
    private JComboBox jModelAlgorithmCombo;
    private JLabel jModelAlgorithmLabel;
    private JComboBox jOutputTypeCombo;
    private JLabel jOutputTypeLabel;
    private JLabel jOutputTypeSelectedLabel;
    private JLabel jOutputTypeSelectedValue;
    private JButton jRemoveAllBtn;
    private JButton jRemoveBtn;
    private JButton jSelectAllBtn;
    private JButton jSelectBtn;

    public EditModelDetailsPanel(Context context, ModelDetailsDataNode modelDetailsDataNode, ModelDetailsOutputType modelDetailsOutputType) {
        super(context, modelDetailsDataNode);
        assert (context != null) : "Context must not be null.";
        assert (modelDetailsDataNode != null) : "Model details data node must not be null.";
        assert (modelDetailsDataNode instanceof ModelDetailsDataNode) : "Must be an instance of model details data node.";
        this._context = context;
        this._node = modelDetailsDataNode;
        this._modelOutputType = modelDetailsOutputType;
        try {
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
            this._dbVersion = connectionFolder.getDbVersion();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jModelAlgorithmLabel = new JLabel();
        this.jModelAlgorithmCombo = new JComboBox();
        this.jOutputTypeLabel = new JLabel();
        this.jOutputTypeCombo = new JComboBox();
        this.componentWithTitlebar1 = new ComponentWithTitlebar();
        this.jMiningFunctionLabel = new JLabel();
        this.jSelectBtn = new JButton();
        this.jSelectAllBtn = new JButton();
        this.jRemoveBtn = new JButton();
        this.jRemoveAllBtn = new JButton();
        this.componentWithTitlebar2 = new ComponentWithTitlebar();
        this.jMiningFunctionSelectedLabel = new JLabel();
        this.jMiningFunctionSelectedValue = new JLabel();
        this.jMiningAlgorithmSelectedLabel = new JLabel();
        this.jMiningAlgorithmValue = new JLabel();
        this.jOutputTypeSelectedLabel = new JLabel();
        this.jOutputTypeSelectedValue = new JLabel();
        this.jMiningFunctionValue = new JLabel();
        this.jDisplayColumnsButton = new JButton();
        this.jModelAlgorithmLabel.setText("Model Type:");
        this.jModelAlgorithmCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Decision Tree", "Clustering", "Scoring Model", "Associatin Rules"}));
        this.jOutputTypeLabel.setText("Output Type:");
        this.jOutputTypeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Full Tree", "Item 2", "Item 3", "Item 4"}));
        this.jMiningFunctionLabel.setText("Model Function:");
        this.jSelectBtn.setText(">");
        this.jSelectAllBtn.setText(">>");
        this.jRemoveBtn.setText("<");
        this.jRemoveAllBtn.setText("<<");
        this.jMiningFunctionSelectedLabel.setText("Function:");
        this.jMiningFunctionSelectedValue.setText("Classification");
        this.jMiningAlgorithmSelectedLabel.setText("Algorithm:");
        this.jMiningAlgorithmValue.setText("Decision Tree");
        this.jOutputTypeSelectedLabel.setText("Output:");
        this.jOutputTypeSelectedValue.setText("Full Tree");
        this.jMiningFunctionValue.setText("Classification");
        this.jDisplayColumnsButton.setText("Columns...");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jMiningFunctionLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jOutputTypeLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jModelAlgorithmLabel, GroupLayout.Alignment.LEADING, -1, 81, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jMiningFunctionValue, -1, -1, Short.MAX_VALUE).addComponent(this.jModelAlgorithmCombo, 0, -1, Short.MAX_VALUE).addComponent(this.jOutputTypeCombo, -2, 279, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jDisplayColumnsButton, -2, 101, -2).addGap(28, 28, 28).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jMiningFunctionSelectedLabel, -1, 78, Short.MAX_VALUE).addComponent(this.jMiningAlgorithmSelectedLabel, -1, 78, Short.MAX_VALUE).addComponent(this.jOutputTypeSelectedLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jMiningFunctionSelectedValue, -1, -1, Short.MAX_VALUE).addComponent(this.jMiningAlgorithmValue, -1, -1, Short.MAX_VALUE).addComponent(this.jOutputTypeSelectedValue, -1, 144, Short.MAX_VALUE))).addGroup(groupLayout.createSequentialGroup().addComponent((Component)this.componentWithTitlebar1, -1, 352, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSelectBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jSelectAllBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jRemoveBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jRemoveAllBtn, -2, 49, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.componentWithTitlebar2, -1, 352, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.linkSize(0, this.jMiningAlgorithmSelectedLabel, this.jMiningFunctionSelectedLabel, this.jOutputTypeSelectedLabel);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMiningFunctionLabel).addComponent(this.jMiningFunctionValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jModelAlgorithmLabel).addComponent(this.jModelAlgorithmCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jOutputTypeCombo, -2, -1, -2).addComponent(this.jOutputTypeLabel).addComponent(this.jDisplayColumnsButton, GroupLayout.Alignment.TRAILING))).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMiningFunctionSelectedLabel).addComponent(this.jMiningFunctionSelectedValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMiningAlgorithmSelectedLabel).addComponent(this.jMiningAlgorithmValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jOutputTypeSelectedLabel).addComponent(this.jOutputTypeSelectedValue)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.componentWithTitlebar2, -1, -1, Short.MAX_VALUE).addComponent((Component)this.componentWithTitlebar1, -1, -1, Short.MAX_VALUE)).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addGap(122, 122, 122).addComponent(this.jSelectBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSelectAllBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveAllBtn).addGap(99, 99, 99)))));
        groupLayout.linkSize(1, this.jMiningFunctionLabel, this.jMiningFunctionSelectedLabel, this.jMiningFunctionSelectedValue, this.jMiningFunctionValue);
        groupLayout.linkSize(1, this.jMiningAlgorithmSelectedLabel, this.jMiningAlgorithmValue, this.jModelAlgorithmCombo, this.jModelAlgorithmLabel);
        groupLayout.linkSize(1, this.jOutputTypeCombo, this.jOutputTypeLabel, this.jOutputTypeSelectedLabel, this.jOutputTypeSelectedValue);
    }

    @Override
    public void initRes() {
        this.initIcons();
        ResourceUtils.resLabel((JLabel)this.jMiningFunctionLabel, (Component)this.jMiningFunctionValue, (String)PropertyLrb.get("PI_MODEL_DETAILS_MODEL_FUNCTION"));
        ResourceUtils.resLabel((JLabel)this.jModelAlgorithmLabel, (Component)this.jModelAlgorithmCombo, (String)PropertyLrb.get("PI_MODEL_DETAILS_GROUP_MODEL_TYPE"));
        this.jModelAlgorithmCombo.getAccessibleContext().setAccessibleDescription(PropertyLrb.get("PI_MODEL_DETAILS_GROUP_MODEL_TYPE_ADA"));
        this.jModelAlgorithmCombo.setToolTipText(PropertyLrb.get("PI_MODEL_DETAILS_GROUP_MODEL_TYPE_ADA"));
        ResourceUtils.resLabel((JLabel)this.jOutputTypeLabel, (Component)this.jOutputTypeCombo, (String)PropertyLrb.get("PI_MODEL_DETAILS_GROUP_OUTPUT_TYPE"));
        this.jOutputTypeCombo.getAccessibleContext().setAccessibleDescription(PropertyLrb.get("PI_MODEL_DETAILS_GROUP_OUTPUT_TYPE_ADA"));
        this.jOutputTypeCombo.setToolTipText(PropertyLrb.get("PI_MODEL_DETAILS_GROUP_OUTPUT_TYPE_ADA"));
        ResourceUtils.resLabel((JLabel)this.jMiningFunctionSelectedLabel, (Component)this.jMiningFunctionSelectedValue, (String)PropertyLrb.get("PI_MODEL_DETAILS_MODEL_FUNCTION"));
        this.jMiningFunctionSelectedValue.setText(this.UNDEFINED);
        ResourceUtils.resLabel((JLabel)this.jMiningAlgorithmSelectedLabel, (Component)this.jMiningAlgorithmValue, (String)PropertyLrb.get("PI_MODEL_DETAILS_MODEL_ALGORITHM"));
        this.jMiningAlgorithmValue.setText(this.UNDEFINED);
        ResourceUtils.resLabel((JLabel)this.jOutputTypeSelectedLabel, (Component)this.jOutputTypeSelectedValue, (String)PropertyLrb.get("PI_MODEL_DETAILS_GROUP_OUTPUT_TYPE"));
        this.jOutputTypeSelectedValue.setText(this.UNDEFINED);
        this.jMiningAlgorithmSelectedLabel.setVisible(false);
        this.jMiningAlgorithmValue.setVisible(false);
        this.jMiningFunctionSelectedLabel.setVisible(false);
        this.jMiningFunctionSelectedValue.setVisible(false);
        this.jOutputTypeSelectedLabel.setVisible(false);
        this.jOutputTypeSelectedValue.setVisible(false);
        ResourceUtils.resButton((AbstractButton)this.jDisplayColumnsButton, (String)ModelDetailsLrb.get("COLUMNS_DISPLAY_BUTTON"));
        this.jDisplayColumnsButton.getAccessibleContext().setAccessibleDescription(ModelDetailsLrb.get("COLUMNS_DISPLAY_BUTTON_ADA"));
        this.jDisplayColumnsButton.setToolTipText(ModelDetailsLrb.get("COLUMNS_DISPLAY_BUTTON_ADA"));
        HelpUtils.setHelpID((JComponent)this, (String)"edit_selection_details");
    }

    public boolean doWork() {
        boolean bl = true;
        if (!this._dirty) {
            return true;
        }
        ModelDetailsOutputType modelDetailsOutputType = this.generateModelOutputType();
        try {
            this._updatedModelOutputType = bl ? modelDetailsOutputType : null;
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_MESG"), null);
        }
        return bl;
    }

    private ModelDetailsOutputType generateModelOutputType() {
        ModelDetailsOutputType modelDetailsOutputType = new ModelDetailsOutputType();
        Attributes attributes = new Attributes();
        ModelDetailsOutputType.Models models = this._selectedModelsTableModel.getRowCount() == 0 ? new ModelDetailsOutputType.Models() : this._selectedModelsTableModel.generateModelsCollection();
        modelDetailsOutputType.setModels(models);
        modelDetailsOutputType.setAttributes(attributes);
        MiningDetailsOutputType miningDetailsOutputType = MiningDetailsOutputType.fromString(this._currentMiningDetailOutputType.toString());
        MiningAlgorithmOptions miningAlgorithmOptions = MiningAlgorithmOptions.fromString(this._currentAlgorithmOption.toString());
        MiningFunctions miningFunctions = MiningFunctions.fromString(this._currentMiningFunction.toString());
        modelDetailsOutputType.setMiningAlgorithm(MiningAlgorithmOptions.getMiningAlgorithmType(miningAlgorithmOptions));
        modelDetailsOutputType.setMiningFunction(MiningFunctions.getMiningFunctionType(miningFunctions));
        modelDetailsOutputType.setMiningFunction(MiningFunctions.getMiningFunctionType(miningFunctions));
        modelDetailsOutputType.setMiningAlgorithm(MiningAlgorithmOptions.getMiningAlgorithmType(miningAlgorithmOptions));
        modelDetailsOutputType.setType(MiningDetailsOutputType.getMiningDetailType(miningDetailsOutputType, miningAlgorithmOptions, miningFunctions));
        modelDetailsOutputType.setAutoSpec(AutoSpecType.fromValue((String)"No"));
        modelDetailsOutputType.setAttributes(OutputAttributeType.convertAttributes(this._currentOutputColumns));
        return modelDetailsOutputType;
    }

    private void initIcons() {
        _nullIcon = new NullIcon(DataMinerIcons.get(Icons.PI_BUILD_GROUP_MODEL_BUILT).getIconWidth(), DataMinerIcons.get(Icons.PI_BUILD_GROUP_MODEL_BUILT).getIconHeight());
        this.jSelectBtn.setText("");
        this.jSelectAllBtn.setText("");
        this.jRemoveBtn.setText("");
        this.jRemoveAllBtn.setText("");
        this.jSelectBtn.setIcon(DataMinerIcons.get(Icons.SHUTTLE_RIGHT));
        this.jSelectAllBtn.setIcon(DataMinerIcons.get(Icons.SHUTTLE_RIGHTALL));
        this.jRemoveBtn.setIcon(DataMinerIcons.get(Icons.SHUTTLE_LEFT));
        this.jRemoveAllBtn.setIcon(DataMinerIcons.get(Icons.SHUTTLE_LEFTALL));
    }

    @Override
    public void initUI() {
        Object object;
        ModelDetailsDataNode modelDetailsDataNode = this._node;
        if (modelDetailsDataNode == null) {
            return;
        }
        try {
            this._dbConn = Connections.getSharedConnection(this._context);
            this._ownerName = this._dbConn.getMetaData().getUserName();
            this._ownerName = StringUtils.isDoubleQuotedString(this._ownerName) ? StringUtils.trimDoubleQuotes(this._ownerName) : this._ownerName.toUpperCase();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)PropertyLrb.get("PI_MODEL_DETAILS_MODEL_PI_ERROR_TITLE"), (String)PropertyLrb.get("PI_MODEL_DETAILS_MODEL_PI_CONNECTION_ERROR_MESG"), null);
            return;
        }
        try {
            object = ConnectionFolder.getConnectionFolder(this._context);
            this._dbVersion = ((ConnectionFolder)object).getDbVersion();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ModelDetailsLrb.get("MODEL_DETAILS_ERROR_TITLE"), (String)ModelDetailsLrb.get("ERROR_INITIALIZING_UNEXPECTED"), null);
            return;
        }
        this.loadData();
        this.loadTables();
        object = new JScrollPane((Component)this._availableModelsGenericTable);
        this.componentWithTitlebar1.setComponent((JComponent)object);
        this.componentWithTitlebar1.setLabel(new JLabel(ModelDetailsLrb.get("AVAILABLE_MODELS")));
        ControlBar controlBar = new ControlBar();
        this._findPane = this.createFindPane();
        controlBar.add(this._findPane);
        this.componentWithTitlebar1.setControlBar(controlBar);
        JScrollPane jScrollPane = new JScrollPane((Component)this._selectedModelsGenericTable);
        this.componentWithTitlebar2.setComponent((JComponent)jScrollPane);
        this.componentWithTitlebar2.setLabel(new JLabel(ModelDetailsLrb.get("SELECTED_MODELS")));
        this.initComboBoxes();
        this.initOutputColumns();
        this.jDisplayColumnsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelOutputColumnsListPanel modelOutputColumnsListPanel = new ModelOutputColumnsListPanel(EditModelDetailsPanel.this.getContext(), EditModelDetailsPanel.this._currentOutputColumns, (ModelDetailsDataNode)EditModelDetailsPanel.this.getData());
                modelOutputColumnsListPanel.invokeDialog(null);
            }
        });
        this.jModelAlgorithmCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelDetailsPanel.this.processAlgorithmComboAction();
            }
        });
        this.jOutputTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelDetailsPanel.this.processOutputTypeComboAction();
            }
        });
        this.jSelectBtn.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_CHOOSER_SELECT_ADA"));
        this.jSelectAllBtn.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_CHOOSER_SELECT_ALL_ADA"));
        this.jRemoveBtn.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_CHOOSER_REMOVE_ADA"));
        this.jRemoveAllBtn.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_CHOOSER_REMOVE.ALL_ADA"));
        this.jSelectBtn.setToolTipText(DialogsLrb.get("MODEL_NODE_CHOOSER_SELECT_ADA"));
        this.jSelectAllBtn.setToolTipText(DialogsLrb.get("MODEL_NODE_CHOOSER_SELECT_ALL_ADA"));
        this.jRemoveBtn.setToolTipText(DialogsLrb.get("MODEL_NODE_CHOOSER_REMOVE_ADA"));
        this.jRemoveAllBtn.setToolTipText(DialogsLrb.get("MODEL_NODE_CHOOSER_REMOVE.ALL_ADA"));
        this.jSelectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelDetailsPanel.this._dirty = true;
                EditModelDetailsPanel.this.moveAvailableRows(actionEvent);
            }
        });
        this.jSelectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelDetailsPanel.this._dirty = true;
                EditModelDetailsPanel.this._availableModelsGenericTable.selectAll();
                EditModelDetailsPanel.this.moveAvailableRows(actionEvent);
            }
        });
        this.jRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelDetailsPanel.this._dirty = true;
                EditModelDetailsPanel.this.moveSelectedRows();
            }
        });
        this.jRemoveAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelDetailsPanel.this._dirty = true;
                EditModelDetailsPanel.this._selectedModelsGenericTable.selectAll();
                EditModelDetailsPanel.this.moveSelectedRows();
            }
        });
    }

    private void moveSelectedRows() {
        int[] nArray = this._selectedModelsGenericTable.getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        this.moveItems(this._selectedModelsGenericTable, this._availableModelsGenericTable);
        ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this._selectedModelsGenericTable.getModel());
        modelsTableModel.setOwnerOnly(!modelsTableModel.isModelsFromOtherSchemas());
        this.filterAvailableBasedOnSelected();
    }

    private void moveAvailableRows(ActionEvent actionEvent) {
        int[] nArray = this._availableModelsGenericTable.getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = this._availableModelsGenericTable.getSelectedRowsInModel();
        this.moveItems(this._availableModelsGenericTable, this._selectedModelsGenericTable);
        ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this._selectedModelsGenericTable.getModel());
        modelsTableModel.setOwnerOnly(!modelsTableModel.isModelsFromOtherSchemas());
        this.setSelectionOnInsertedRows(this._selectedModelsGenericTable, nArray2.length);
        this.filterAvailableBasedOnSelected();
    }

    private void filterAvailableBasedOnSelected() {
        ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this._selectedModelsGenericTable.getModel());
        if (modelsTableModel.getRowCount() > 0) {
            this.jMiningFunctionSelectedValue.setText(this._currentMiningFunction.toString());
            this.jMiningAlgorithmValue.setText(this._currentAlgorithmOption.toString());
            this.jModelAlgorithmCombo.setEnabled(false);
            this.jOutputTypeSelectedValue.setText(this._currentMiningDetailOutputType.toString());
        } else {
            this.jMiningFunctionSelectedValue.setText(this.UNDEFINED);
            this.jMiningAlgorithmValue.setText(this.UNDEFINED);
            this.jModelAlgorithmCombo.setEnabled(true);
            this.jOutputTypeSelectedValue.setText(this.UNDEFINED);
        }
    }

    private void setSelectionOnInsertedRows(GenericTable genericTable, int n) {
        genericTable.setRowSelectionInterval(genericTable.getModel().getRowCount() - n, genericTable.getModel().getRowCount() - 1);
        genericTable.scrollToSelection();
    }

    private void moveItems(GenericTable genericTable, GenericTable genericTable2) {
        int[] nArray = genericTable.getSelectedRowsInModel();
        ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)genericTable.getModel());
        ModelsTableModel modelsTableModel2 = (ModelsTableModel)((Object)genericTable2.getModel());
        modelsTableModel2.addSelection(modelsTableModel, nArray);
        if (modelsTableModel2.isFilteredTableModel()) {
            this._availableModelsTableModel.addSelection(modelsTableModel, nArray);
        }
        if (genericTable2.equals(this._selectedModelsGenericTable)) {
            this.setSelectionOnInsertedRows(genericTable2, nArray.length);
        }
        if (modelsTableModel.isFilteredTableModel()) {
            this._availableModelsTableModel.removeDuplicateRows(modelsTableModel.getDataVector(), nArray);
        }
        modelsTableModel.removeSelectedRows(nArray);
    }

    private void processOutputTypeComboAction() {
        MiningDetailsOutputType miningDetailsOutputType = (MiningDetailsOutputType)((Object)this.jOutputTypeCombo.getSelectedItem());
        if (this._currentMiningDetailOutputType != miningDetailsOutputType) {
            this._currentMiningDetailOutputType = miningDetailsOutputType;
            this.jOutputTypeCombo.setSelectedItem((Object)this._currentMiningDetailOutputType);
            if (this._selectedModelsGenericTable.getRowCount() > 0) {
                this.jOutputTypeSelectedValue.setText(this._currentMiningDetailOutputType.toString());
            }
            this.initOutputColumns();
            this.processFilter(this._searchField.getText());
        }
    }

    private void processAlgorithmComboAction() {
        MiningAlgorithmOptions miningAlgorithmOptions = (MiningAlgorithmOptions)((Object)this.jModelAlgorithmCombo.getSelectedItem());
        if (this._currentAlgorithmOption != miningAlgorithmOptions) {
            this._currentAlgorithmOption = miningAlgorithmOptions;
            this.setupOutputTypeCombo(this._currentMiningFunction, this._currentAlgorithmOption);
            this.processFilter(this._searchField.getText());
        }
    }

    private void setupOutputTypeCombo(MiningFunctions miningFunctions, MiningAlgorithmOptions miningAlgorithmOptions) {
        this.jOutputTypeCombo.setModel(new DefaultComboBoxModel<MiningDetailsOutputType>(MiningDetailsOutputType.getMiningDetailsOutputType(miningFunctions, miningAlgorithmOptions)));
        this._currentMiningDetailOutputType = MiningDetailsOutputType.getPreferredOutputTypeForModelDetailsNode(miningFunctions, miningAlgorithmOptions);
        this.jOutputTypeCombo.setSelectedItem((Object)this._currentMiningDetailOutputType);
        this.initOutputColumns();
    }

    private void loadTables() {
        try {
            this._selectedModelsTableModel = new ModelsTableModel(this._models, this._ownerName, this._node);
            this.setupModelsTable(this._selectedModelsGenericTable, this._selectedModelsTableModel);
            this._availableModelsTableModel = new ModelsTableModel(this._ownerName, this._node);
            Vector<AvailableRefModelType> vector = this._availableModelsTableModel.createMissingRowsBasedOnMatch(this._selectedModelsTableModel.getDataVector());
            this._availableModelsTableModel.removeDuplicateRowsBasedOnMatch(this._selectedModelsTableModel.getDataVector());
            this.processFilter("");
            this.setupModelsTable(this._selectedModelsGenericTable, this._selectedModelsTableModel);
            if (this._availableModelsGenericTable.getRowCount() > 0) {
                this._availableModelsGenericTable.setSelectedRowsInModel(new int[]{0});
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ModelDetailsLrb.get("ERROR_TITLE"), (String)ModelDetailsLrb.get("ERROR_MODEL_LOADING_UNEXPECTED"), null);
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private synchronized int translateSearchCategoryToConstant(SearchCategory searchCategory) {
        int n = -1;
        if (searchCategory.getLabel().equals(PropertyLrb.get("PI_MODEL_GROUP_FILTER_MODEL_NAME"))) {
            this._currentSearchCategory = 1;
        } else if (searchCategory.getLabel().equals(PropertyLrb.get("PI_MODEL_DETAILS_MODEL_COLUMN_ALGORITHM"))) {
            this._currentSearchCategory = 3;
        } else if (searchCategory.getLabel().equals(PropertyLrb.get("PI_MODEL_DETAILS_MODEL_COLUMN_NODE"))) {
            this._currentSearchCategory = 2;
        } else assert (false) : "Invalid Search Category Code";
        return n;
    }

    private SearchField searchField() {
        final SearchField searchField = new SearchField();
        searchField.setStyle(SearchField.Style.FILTER);
        searchField.setAutoFind(true);
        searchField.setPrompt(InspectorArb.getString((int)34));
        searchField.setNotifyOnEmptySearch(true);
        searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                EditModelDetailsPanel.this.translateSearchCategoryToConstant(searchField.getSelectedCategory());
                EditModelDetailsPanel.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                EditModelDetailsPanel.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
                EditModelDetailsPanel.this.processFilter(string);
            }
        });
        return searchField;
    }

    private void setupModelsTable(GenericTable genericTable, ModelsTableModel modelsTableModel) {
        genericTable.setModel((TableModel)((Object)modelsTableModel));
        if (genericTable.equals(this._availableModelsGenericTable)) {
            genericTable.setSorted(true);
            genericTable.setSortColumn(0, true);
            genericTable.setUpdateSelectionOnSort(true);
        }
        genericTable.getTableHeader().setReorderingAllowed(false);
        IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                GenericTable genericTable = (GenericTable)jTable;
                int n3 = genericTable.convertRowIndexToModel(n);
                ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)genericTable.getModel());
                AvailableRefModelType availableRefModelType = modelsTableModel.getDataVector().get(n3);
                if (availableRefModelType.getStatus() == RefModelStatusType.VALID && modelsTableModel.isModelBuilt(n3)) {
                    return DataMinerIcons.get(Icons.PI_BUILD_GROUP_MODEL_BUILT);
                }
                if (availableRefModelType.getStatus() == RefModelStatusType.VALID && !modelsTableModel.isModelBuilt(n3)) {
                    return _nullIcon;
                }
                return DataMinerIcons.get(Icons.PI_BUILD_GROUP_MODEL_INVALID);
            }
        });
        TableColumn tableColumn = genericTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(iconCellRenderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFilter(String string) {
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        try {
            ideMainWindow.setCursor(new Cursor(3));
            ModelsTableModel modelsTableModel = this._availableModelsTableModel.getfilteredCopy(string, this._currentSearchCategory, this._currentMiningFunction, this._currentAlgorithmOption, this._currentMiningDetailOutputType);
            this.setupModelsTable(this._availableModelsGenericTable, modelsTableModel);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)PropertyLrb.get("PI_MODEL_DETAILS_MODEL_PI_ERROR_TITLE"), (String)PropertyLrb.get("PI_MODEL_DETAILS_MODEL_PI_NODE_LOAD_ERROR_MESG"), null);
        }
        finally {
            ideMainWindow.setCursor(new Cursor(0));
        }
    }

    private void setupFilterCtl() {
        this._currentSearchCategory = 1;
        this._searchField.addCategory(this._defaultSearchCategory);
        this._searchField.addCategory(new SearchCategory(PropertyLrb.get("PI_MODEL_DETAILS_MODEL_COLUMN_NODE")));
        this._searchField.addCategory(new SearchCategory(PropertyLrb.get("PI_MODEL_DETAILS_MODEL_COLUMN_ALGORITHM")));
        this._searchField.setSelectedCategory(this._defaultSearchCategory);
    }

    protected Component createFindPane() {
        Box box = new Box(2);
        this._searchField = this.searchField();
        this.setupFilterCtl();
        box.setName("Find");
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        box.add((Component)this._searchField);
        Dimension dimension = box.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 200);
        Dimension dimension3 = this.derive(dimension, 120);
        box.setPreferredSize(dimension2);
        box.setMaximumSize(dimension2);
        box.setMinimumSize(dimension3);
        return box;
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    private void initOutputColumns() {
        if (this._currentMiningDetailOutputType != null && this._currentAlgorithmOption != null && this._currentMiningFunction != null) {
            this._currentOutputColumns = ModelDetailsExtract.getOutputColumnList(MiningDetailsOutputType.getMiningDetailType(this._currentMiningDetailOutputType, this._currentAlgorithmOption, this._currentMiningFunction), this._dbVersion);
        }
    }

    private void initComboBoxes() {
        this.jMiningFunctionValue.setText(this._currentMiningFunction.toString());
        this.jMiningFunctionSelectedValue.setText(this._currentMiningFunction.toString());
        this.jModelAlgorithmCombo.setModel(new DefaultComboBoxModel<MiningAlgorithmOptions>(MiningAlgorithmOptions.getMiningAlgorithmOptions(this._dbVersion, this._currentMiningFunction)));
        if (this._models.size() > 0) {
            this.jModelAlgorithmCombo.setEnabled(false);
        } else {
            this.jModelAlgorithmCombo.setEnabled(true);
        }
        this.jModelAlgorithmCombo.setSelectedItem((Object)this._currentAlgorithmOption);
        this.jMiningAlgorithmValue.setText(this._currentAlgorithmOption.toString());
        this.jOutputTypeCombo.setModel(new DefaultComboBoxModel<MiningDetailsOutputType>(MiningDetailsOutputType.getMiningDetailsOutputType(this._currentMiningFunction, this._currentAlgorithmOption)));
        this.jOutputTypeCombo.setEnabled(true);
        this.jOutputTypeCombo.setSelectedItem((Object)this._currentMiningDetailOutputType);
        this.jOutputTypeSelectedValue.setText(this._currentMiningDetailOutputType.toString());
    }

    private void loadData() {
        if (this._modelOutputType != null) {
            this._models = this._modelOutputType.getModels().getModel();
            this._modelDetailType = this._modelOutputType.getType();
            this._currentMiningDetailOutputType = MiningDetailsOutputType.getMiningDetailsOutputType(this._modelDetailType);
            this._currentMiningFunction = MiningFunctions.getMiningFunctionsFromType(this._modelOutputType.getMiningFunction());
            this._currentAlgorithmOption = MiningAlgorithmOptions.getMiningAlgorithmOption(this._modelOutputType.getMiningAlgorithm());
            this._currentOutputColumns = OutputAttributeType.convertAttributes(this._modelOutputType.getAttributes());
        } else {
            this._models = null;
            this._currentMiningDetailOutputType = null;
            this._currentMiningFunction = null;
            this._currentAlgorithmOption = null;
            this._currentOutputColumns = null;
        }
    }

    protected ModelDetailsDataNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowModelDetailsNodePropertyProxyModel)) {
            return null;
        }
        WorkflowModelDetailsNodePropertyProxyModel workflowModelDetailsNodePropertyProxyModel = (WorkflowModelDetailsNodePropertyProxyModel)propertyModel;
        Context context = workflowModelDetailsNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof ModelDetailsDataNodeType) {
            return (ModelDetailsDataNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    public void setUpdatedModelOutputType(ModelDetailsOutputType modelDetailsOutputType) {
        this._updatedModelOutputType = modelDetailsOutputType;
    }

    public ModelDetailsOutputType getUpdatedModelOutputType() {
        return this._updatedModelOutputType;
    }
}

