/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.modeldetails;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.dmt.dataminer.server.model.MiningAlgorithmOptions;
import oracle.dmt.dataminer.server.model.MiningDetailsOutputType;
import oracle.dmt.dataminer.server.model.MiningFunctions;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.AvailableRefModelType;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ModelDetailsDataNode;
import oracle.dmt.dataminer.workflow.model.ModelProvider;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailsOutputType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.javatools.ui.search.SearchMatcher;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class ModelsTableModel
extends GenericBaseTableModel {
    private Vector<AvailableRefModelType> _srcData = new Vector();
    private HashMap<String, AvailableRefModelType> _svmLinearModels = new HashMap();
    private boolean _ownerOnly = true;
    private String _ownerName;
    private boolean _filteredTableModel = false;
    private ModelDetailsDataNode _nodeData = null;
    private static String[] _columnNames = new String[]{PropertyLrb.get("PI_MODEL_DETAILS_MODEL_COLUMN_MODEL"), PropertyLrb.get("PI_MODEL_DETAILS_MODEL_COLUMN_NODE"), PropertyLrb.get("PI_MODEL_DETAILS_MODEL_COLUMN_ALGORITHM")};
    public static final int MODEL_NAME = 0;
    public static final int NODE_NAME = 1;
    public static final int ALGORITHM = 2;
    public static final int COLUMN_COUNT = 3;
    public static final int FILTER_MODEL_NAME = 1;
    public static final int FILTER_NODE_NAME = 2;
    public static final int FILTER_MODEL_ALGORITHM = 3;

    public ModelsTableModel() {
        this.setColumnIdentifiers(_columnNames);
        this.setRowCount(this._srcData.size());
        this.setColumnCount(3);
    }

    public ModelsTableModel(String string, ModelDetailsDataNode modelDetailsDataNode) throws Exception {
        this._nodeData = modelDetailsDataNode;
        this.addParentRefModels(modelDetailsDataNode);
        this._ownerName = string;
        this.setColumnIdentifiers(_columnNames);
        this.setRowCount(this._srcData.size());
        this.setColumnCount(3);
        this.isModelsFromOtherSchemas();
    }

    public ModelsTableModel(List<RefModelType> list, String string, ModelDetailsDataNode modelDetailsDataNode) {
        this.addRefModels(true, list);
        this._nodeData = modelDetailsDataNode;
        this._ownerName = string;
        this.setColumnIdentifiers(_columnNames);
        this.setRowCount(this._srcData.size());
        this.setColumnCount(3);
        this.isModelsFromOtherSchemas();
    }

    public ModelsTableModel(List<AvailableRefModelType> list, String string, ModelDetailsDataNode modelDetailsDataNode, boolean bl) {
        this._nodeData = modelDetailsDataNode;
        this._srcData.addAll(list);
        this._ownerName = string;
        this.setColumnIdentifiers(_columnNames);
        this.setRowCount(this._srcData.size());
        this.setColumnCount(3);
        this.isModelsFromOtherSchemas();
    }

    private void addParentRefModels(ModelDetailsDataNode modelDetailsDataNode) throws Exception {
        AvailableRefModelType availableRefModelType;
        List<RefModelType> list;
        ModelProvider modelProvider;
        List<AbstractNode> list2 = modelDetailsDataNode.findParentNodes();
        for (AbstractNode abstractNode : list2) {
            modelProvider = (ModelProvider)((Object)abstractNode);
            list = modelProvider.getOutputModels();
            for (RefModelType refModelType : list) {
                availableRefModelType = new AvailableRefModelType();
                availableRefModelType.setRefModelType(refModelType, null);
                this._srcData.add(availableRefModelType);
            }
        }
        for (AbstractNode abstractNode : list2) {
            modelProvider = (ModelProvider)((Object)abstractNode);
            list = modelProvider.getSVMLinearModels();
            if (list == null) continue;
            for (RefModelType refModelType : list) {
                availableRefModelType = new AvailableRefModelType();
                availableRefModelType.setRefModelType(refModelType, null);
                this._svmLinearModels.put(refModelType.getSchema() + "." + refModelType.getName(), availableRefModelType);
            }
        }
    }

    public void reload(List<RefModelType> list) {
        this._srcData.clear();
        this.addRefModels(true, list);
        this.fireTableDataChanged();
    }

    private void addRefModels(boolean bl, List<RefModelType> list) {
        for (RefModelType refModelType : list) {
            AvailableRefModelType availableRefModelType = new AvailableRefModelType();
            availableRefModelType.setRefModelType(refModelType, null);
            this._srcData.add(availableRefModelType);
        }
    }

    public boolean containsModelsWithAlgorithm(MiningAlgorithmType miningAlgorithmType) {
        boolean bl = false;
        for (RefModelType refModelType : this._srcData) {
            if (!refModelType.getMiningAlgorithm().equals((Object)miningAlgorithmType)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean containsModelsWithMortThanOneAlgorithm() {
        boolean bl = false;
        MiningAlgorithmType miningAlgorithmType = null;
        for (RefModelType refModelType : this._srcData) {
            if (miningAlgorithmType == null) {
                miningAlgorithmType = refModelType.getMiningAlgorithm();
            }
            if (refModelType.getMiningAlgorithm().equals((Object)miningAlgorithmType)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public MiningAlgorithmType getCommonAlgorithm() {
        MiningAlgorithmType miningAlgorithmType = null;
        boolean bl = true;
        for (RefModelType refModelType : this._srcData) {
            if (miningAlgorithmType == null) {
                miningAlgorithmType = refModelType.getMiningAlgorithm();
            }
            if (refModelType.getMiningAlgorithm().equals((Object)miningAlgorithmType)) continue;
            bl = false;
            break;
        }
        if (bl) {
            return miningAlgorithmType;
        }
        return null;
    }

    public void refreshModelStatus(Vector<AvailableRefModelType> vector) {
        HashMap<String, AvailableRefModelType> hashMap = new HashMap<String, AvailableRefModelType>();
        for (AvailableRefModelType availableRefModelType : vector) {
            hashMap.put(availableRefModelType.getFullModelName(), availableRefModelType);
        }
        for (AvailableRefModelType availableRefModelType : this._srcData) {
            AvailableRefModelType availableRefModelType2 = (AvailableRefModelType)((Object)hashMap.get(availableRefModelType.getFullModelName()));
            if (this.doModelsMatch(availableRefModelType2, availableRefModelType)) {
                availableRefModelType.setStatus(RefModelStatusType.INVALID);
                continue;
            }
            availableRefModelType.setStatus(RefModelStatusType.VALID);
        }
    }

    public void removeDuplicateRowsBasedOnMatch(Vector<AvailableRefModelType> vector) {
        HashMap<String, AvailableRefModelType> hashMap = new HashMap<String, AvailableRefModelType>();
        for (AvailableRefModelType availableRefModelType : vector) {
            hashMap.put(availableRefModelType.getFullModelName(), availableRefModelType);
        }
        Iterator<AvailableRefModelType> iterator = this._srcData.iterator();
        while (iterator.hasNext()) {
            AvailableRefModelType availableRefModelType;
            availableRefModelType = iterator.next();
            AvailableRefModelType availableRefModelType2 = (AvailableRefModelType)((Object)hashMap.get(availableRefModelType.getFullModelName()));
            if (!this.doModelsMatch(availableRefModelType2, availableRefModelType)) continue;
            iterator.remove();
        }
        this.setRowCount(this._srcData.size());
        this.fireTableDataChanged();
    }

    public Vector<AvailableRefModelType> createMissingRowsBasedOnMatch(Vector<AvailableRefModelType> vector) {
        HashMap<String, AvailableRefModelType> hashMap = new HashMap<String, AvailableRefModelType>();
        Vector<AvailableRefModelType> vector2 = new Vector<AvailableRefModelType>();
        for (AvailableRefModelType availableRefModelType : this._srcData) {
            hashMap.put(availableRefModelType.getFullModelName(), availableRefModelType);
        }
        for (AvailableRefModelType availableRefModelType : vector) {
            AvailableRefModelType availableRefModelType2;
            if (this.doModelsMatch(availableRefModelType, availableRefModelType2 = (AvailableRefModelType)((Object)hashMap.get(availableRefModelType.getFullModelName())))) continue;
            vector2.add(availableRefModelType);
        }
        return vector2;
    }

    private boolean doModelsMatch(AvailableRefModelType availableRefModelType, AvailableRefModelType availableRefModelType2) {
        return availableRefModelType != null && availableRefModelType2 != null && availableRefModelType.getMiningAlgorithm().equals((Object)availableRefModelType2.getMiningAlgorithm()) && availableRefModelType.getMiningFunction().equals((Object)availableRefModelType2.getMiningFunction());
    }

    public MiningFunctionType getCommonFunction() {
        MiningFunctionType miningFunctionType = null;
        boolean bl = true;
        for (RefModelType refModelType : this._srcData) {
            if (miningFunctionType == null) {
                miningFunctionType = refModelType.getMiningFunction();
            }
            if (refModelType.getMiningFunction().equals((Object)miningFunctionType)) continue;
            bl = false;
            break;
        }
        if (bl) {
            return miningFunctionType;
        }
        return null;
    }

    public int getRowCount() {
        return this._srcData != null ? this._srcData.size() : 0;
    }

    public Vector<AvailableRefModelType> getDataVector() {
        return this._srcData;
    }

    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    public boolean isModelBuilt(int n) {
        AvailableRefModelType availableRefModelType = this._srcData.get(n);
        return availableRefModelType.isIsModelBuilt();
    }

    public Object getValueAt(int n, int n2) {
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
        AvailableRefModelType availableRefModelType = this._srcData.get(n);
        String string = null;
        switch (n2) {
            case 0: {
                if (this._ownerOnly) {
                    string = availableRefModelType.getName();
                    break;
                }
                string = availableRefModelType.getSchema() + "." + availableRefModelType.getName();
                break;
            }
            case 1: {
                string = this.getNodeName(availableRefModelType.getNodeId());
                break;
            }
            case 2: {
                string = MetaDataHelper.getAlgorithmName(availableRefModelType.getMiningAlgorithm());
                break;
            }
            default: {
                assert (false) : "Out of bounds column";
                break;
            }
        }
        return string;
    }

    public String getNodeName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        List<AbstractNode> list = this._nodeData.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (abstractNode.getMetadataId().compareTo(string) != 0) continue;
            string2 = abstractNode.getData().getName();
        }
        return string2;
    }

    public ModelsTableModel getfilteredCopy(String string, int n, MiningFunctions miningFunctions, MiningAlgorithmOptions miningAlgorithmOptions, MiningDetailsOutputType miningDetailsOutputType) throws Exception {
        Vector<AvailableRefModelType> vector = null;
        assert (string != null) : "name filter must be non null";
        SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
        Object object = this.getDataVector();
        vector = new Vector<AvailableRefModelType>(1000, 500);
        Iterator<AvailableRefModelType> iterator = ((Vector)object).iterator();
        AvailableRefModelType availableRefModelType = null;
        boolean bl = string.length() <= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        boolean bl6 = false;
        if (miningAlgorithmOptions != null && miningDetailsOutputType != null && miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.SUPPORT_VECTOR_MACHINE) && miningDetailsOutputType.equals((Object)MiningDetailsOutputType.COEFFICIENTS)) {
            bl6 = true;
        }
        while (iterator.hasNext()) {
            availableRefModelType = iterator.next();
            bl3 = miningFunctions != null ? availableRefModelType.getMiningFunction().equals((Object)MiningFunctions.getMiningFunctionType(miningFunctions)) : true;
            if (miningAlgorithmOptions != null) {
                if (miningAlgorithmOptions == MiningAlgorithmOptions.ALL) {
                    bl4 = true;
                } else if (availableRefModelType.getMiningAlgorithm().equals((Object)MiningAlgorithmOptions.getMiningAlgorithmType(miningAlgorithmOptions))) {
                    bl4 = true;
                    if (bl6) {
                        bl5 = this._svmLinearModels.get(availableRefModelType.getSchema() + "." + availableRefModelType.getName()) != null;
                    }
                } else {
                    bl4 = false;
                }
            } else {
                bl4 = true;
            }
            if (bl) {
                bl2 = true;
            } else {
                String string2;
                switch (n) {
                    case 1: {
                        string2 = availableRefModelType.getName();
                        break;
                    }
                    case 2: {
                        string2 = this.getNodeName(availableRefModelType.getNodeId());
                        break;
                    }
                    case 3: {
                        string2 = MetaDataHelper.getAlgorithmName(availableRefModelType.getMiningAlgorithm());
                        break;
                    }
                    default: {
                        string2 = availableRefModelType.getName();
                    }
                }
                bl2 = searchMatcher.matches((CharSequence)string2);
            }
            if (!bl2 || !bl3 || !bl4 || !bl5) continue;
            vector.add(availableRefModelType);
        }
        object = new ModelsTableModel(vector, this._ownerName, this._nodeData, true);
        ((ModelsTableModel)((Object)object)).setFilteredTableModel(true);
        return object;
    }

    public void removeDuplicateRows(Vector<AvailableRefModelType> vector, int[] nArray) {
        AvailableRefModelType availableRefModelType = null;
        for (int i = 0; i < nArray.length; ++i) {
            availableRefModelType = vector.elementAt(nArray[i]);
            this._srcData.remove((Object)availableRefModelType);
        }
        this.setRowCount(this._srcData.size());
        this.isModelsFromOtherSchemas();
        this.fireTableDataChanged();
    }

    public boolean isModelsFromOtherSchemas() {
        boolean bl = false;
        for (AvailableRefModelType availableRefModelType : this._srcData) {
            if (availableRefModelType.getSchema().compareTo(this._ownerName) == 0) continue;
            bl = true;
            break;
        }
        this._ownerOnly = !bl;
        return bl;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void addSelection(ModelsTableModel modelsTableModel, int[] nArray) {
        Vector<AvailableRefModelType> vector = modelsTableModel.getDataVector();
        AvailableRefModelType availableRefModelType = null;
        for (int i = 0; i < nArray.length; ++i) {
            availableRefModelType = vector.elementAt(nArray[i]);
            this._srcData.add(availableRefModelType);
        }
        this.setRowCount(this._srcData.size());
        this.isModelsFromOtherSchemas();
        this.fireTableDataChanged();
    }

    public boolean isFilteredTableModel() {
        return this._filteredTableModel;
    }

    public void setFilteredTableModel(boolean bl) {
        this._filteredTableModel = bl;
    }

    public void setOwnerOnly(boolean bl) {
        if (bl != this._ownerOnly) {
            this._ownerOnly = bl;
            this.fireTableDataChanged();
        }
    }

    public void removeSelectedRows(int[] nArray) {
        Vector<AvailableRefModelType> vector = new Vector<AvailableRefModelType>();
        AvailableRefModelType availableRefModelType = null;
        for (int i = 0; i < nArray.length; ++i) {
            availableRefModelType = this._srcData.elementAt(nArray[i]);
            vector.add(availableRefModelType);
        }
        this._srcData.removeAll(vector);
        this.setRowCount(this._srcData.size());
        this.isModelsFromOtherSchemas();
        this.fireTableDataChanged();
    }

    public boolean isModelInvalid(int n) {
        AvailableRefModelType availableRefModelType = this._srcData.get(n);
        return availableRefModelType.getStatus().equals((Object)RefModelStatusType.INVALID);
    }

    public String getInvalidMessage(int n) {
        AvailableRefModelType availableRefModelType = this._srcData.get(n);
        if (availableRefModelType.getStatus().equals((Object)RefModelStatusType.INVALID)) {
            return availableRefModelType.getError() != null ? availableRefModelType.getError().toString() : "Unknown Error Type";
        }
        return "";
    }

    public ModelDetailsOutputType.Models generateModelsCollection() {
        ModelDetailsOutputType.Models models = new ModelDetailsOutputType.Models();
        List list = models.getModel();
        list.clear();
        for (AvailableRefModelType availableRefModelType : this._srcData) {
            RefModelType refModelType = new RefModelType();
            refModelType.setSchema(availableRefModelType.getSchema());
            refModelType.setName(availableRefModelType.getName());
            refModelType.setMiningAlgorithm(availableRefModelType.getMiningAlgorithm());
            refModelType.setMiningFunction(availableRefModelType.getMiningFunction());
            refModelType.setModelId(availableRefModelType.getModelId());
            refModelType.setNodeId(availableRefModelType.getNodeId());
            refModelType.setStatus(availableRefModelType.getStatus());
            refModelType.setIsModelBuilt(availableRefModelType.isIsModelBuilt());
            refModelType.setUseForOutput(availableRefModelType.isUseForOutput());
            list.add(refModelType);
        }
        return models;
    }
}

