/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.rowFilter;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DBObjectNameEditor;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.AttributeNameValidator;
import oracle.dmt.dataminer.utils.PIAncestorListener;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.rowFilter.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.rowFilter.RowFilterEditorPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.rowFilter.RowFilterNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.rowFilter.RowFilterPIPropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.rowFilter.WorkflowRowFilterNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.RowFilterNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RowFilterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RowFilterOutputColumnsType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.TransparentPanel;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class OutputColumnPanel
extends AbstractDialogPanel {
    private WorkflowRowFilterNodePropertyProxyModel _propertyModel;
    private RowFilterEditorPanel _parent;
    private RowFilterOutputColumnsType _outputColumns;
    private AttrsTableModel _models;
    private boolean _dirty;
    private RowFilterNode.RowFilterOutputColumnNameGenerator _outputColumnNameGenerator;
    private ComponentWithTitlebar<JComponent> columnComponentWithTitlebar;
    private TransparentPanel columnTransparentPanel;
    private DataMinerTablePanel tablePanel;

    public OutputColumnPanel(PropertyModel propertyModel) {
        super(null, null);
        assert (propertyModel != null) : "PropertyModel for row filter node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this.addAncestorListener(new PIAncestorListener(this));
        this.init((RowFilterNode)this._data, propertyModel);
    }

    public OutputColumnPanel(Context context, RowFilterNode rowFilterNode, RowFilterEditorPanel rowFilterEditorPanel) {
        super(context, rowFilterNode);
        assert (context != null) : "Context must not be null.";
        assert (rowFilterNode != null) : "Join node must not be null.";
        assert (rowFilterNode instanceof RowFilterNode) : "Must be an instance of join node.";
        this._parent = rowFilterEditorPanel;
        this.init(rowFilterNode, this._parent.getModel());
    }

    private void init(RowFilterNode rowFilterNode, PropertyModel propertyModel) {
        this._propertyModel = (WorkflowRowFilterNodePropertyProxyModel)propertyModel;
        this._dirty = false;
        if (this._propertyModel != null) {
            this._outputColumns = (RowFilterOutputColumnsType)MetaDataHelper.copyMetadataObject(((RowFilterNodeType)rowFilterNode.getData()).getOutputColumns());
            this._outputColumnNameGenerator = new RowFilterNode.RowFilterOutputColumnNameGenerator(this._outputColumns);
        } else {
            this._outputColumns = this._parent.getOutputColumns();
            this._outputColumnNameGenerator = this._parent.getOutputColumnNameGenerator();
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void updateNode() {
        RowFilterNode rowFilterNode = (RowFilterNode)this.getData();
        RowFilterNodeType rowFilterNodeType = (RowFilterNodeType)rowFilterNode.getData();
        ComplexProperty complexProperty = new ComplexProperty("RowFilterAttributes", this._outputColumns);
        complexProperty.setOldData(rowFilterNodeType.getOutputColumns());
        ArrayList<Property> arrayList = new ArrayList<Property>();
        arrayList.add(new Property(String.valueOf(RowFilterNodePropertyModel.RowIndex.ROWFILTER_OUTPUT_COLUMNS), null, complexProperty, null, null));
        this._propertyModel.setValueAt(RowFilterPIPropertyLrb.get("PI_ROW_FILTER_GROUP_COLUMNS_ATTRIBUTE_OUTPUT_COLUMN_CHANGED"), this.getData(), arrayList);
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        this._models = new AttrsTableModel(this, this._outputColumns, this._context);
        this.tablePanel.setup((TableModel)((Object)this._models), DialogsLrb.get("ROWFILTER_DATA_TABLE_TITLE"), 0, true);
        this.tablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                OutputColumnPanel.this.handleModelSelectionChanged();
            }
        });
        IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                AttributeType attributeType = (AttributeType)OutputColumnPanel.this._outputColumns.getAttribute().get(n);
                AttributeStatus attributeStatus = attributeType.getStatus();
                return attributeStatus == AttributeStatus.VALID ? DataMinerIcons.get(Icons.ATTRIBUTE) : DataMinerIcons.get(Icons.USAGE_ATTR_INVALID);
            }
        });
        TableColumn tableColumn = this.tablePanel.getTable().getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(iconCellRenderer);
        tableColumn = this.tablePanel.getTable().getColumnModel().getColumn(1);
        DBObjectNameEditor dBObjectNameEditor = new DBObjectNameEditor(this._context);
        tableColumn.setCellEditor(dBObjectNameEditor);
        this.enableControls();
    }

    private void enableControls() {
    }

    private void handleModelSelectionChanged() {
        this.enableControls();
    }

    public void updatePI(PropertyModel propertyModel) {
        WorkflowRowFilterNodePropertyProxyModel workflowRowFilterNodePropertyProxyModel = (WorkflowRowFilterNodePropertyProxyModel)propertyModel;
        Context context = workflowRowFilterNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        RowFilterNode rowFilterNode = (RowFilterNode)workflowNodeInspectorElement.getNode();
        if (rowFilterNode == null) {
            return;
        }
        this._propertyModel = (WorkflowRowFilterNodePropertyProxyModel)propertyModel;
        this._context = context;
        this._data = rowFilterNode;
        this._dirty = false;
        RowFilterNodeType rowFilterNodeType = (RowFilterNodeType)rowFilterNode.getData();
        this._outputColumns = (RowFilterOutputColumnsType)MetaDataHelper.copyMetadataObject(rowFilterNodeType.getOutputColumns());
        this._outputColumnNameGenerator = new RowFilterNode.RowFilterOutputColumnNameGenerator(this._outputColumns);
        this.initUI();
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowRowFilterNodePropertyProxyModel)) {
            return null;
        }
        WorkflowRowFilterNodePropertyProxyModel workflowRowFilterNodePropertyProxyModel = (WorkflowRowFilterNodePropertyProxyModel)propertyModel;
        Context context = workflowRowFilterNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    private RowFilterNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowRowFilterNodePropertyProxyModel)) {
            return null;
        }
        WorkflowRowFilterNodePropertyProxyModel workflowRowFilterNodePropertyProxyModel = (WorkflowRowFilterNodePropertyProxyModel)propertyModel;
        Context context = workflowRowFilterNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof RowFilterNodeType) {
            return (RowFilterNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    private void initComponents() {
        this.columnTransparentPanel = new TransparentPanel();
        this.columnComponentWithTitlebar = new ComponentWithTitlebar();
        this.tablePanel = new DataMinerTablePanel();
        this.columnTransparentPanel.setName("columnTransparentPanel");
        this.columnComponentWithTitlebar.setAutoscrolls(true);
        this.columnComponentWithTitlebar.setMinimumSize(new Dimension(500, 1000));
        this.columnComponentWithTitlebar.setName("columnComponentWithTitlebar");
        GroupLayout groupLayout = new GroupLayout((Container)this.columnTransparentPanel);
        this.columnTransparentPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.columnComponentWithTitlebar, -1, 788, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.columnComponentWithTitlebar, -2, 329, Short.MAX_VALUE));
        this.tablePanel.setName("tablePanel");
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.tablePanel, -1, 475, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.tablePanel, -1, 248, Short.MAX_VALUE).addContainerGap()));
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    public RowFilterOutputColumnsType getOutputColumns() {
        return this._outputColumns;
    }

    public WorkflowRowFilterNodePropertyProxyModel getPropertyModel() {
        return this._propertyModel;
    }

    public void setOutputColumns(RowFilterOutputColumnsType rowFilterOutputColumnsType) {
        this._outputColumns = rowFilterOutputColumnsType;
    }

    private class CustomCellEditor
    extends DefaultCellEditor {
        private String _alias;

        public CustomCellEditor() {
            super(new JTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object != null) {
                this._alias = object.toString();
            }
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }

        @Override
        public boolean stopCellEditing() {
            String string = (String)this.getCellEditorValue();
            if (string.length() > 30) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("ROWFILTER_DATA_ALIAS_TOO_LONG"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
            if (string.length() > 0) {
                if (this._alias != null) {
                    OutputColumnPanel.this._outputColumnNameGenerator.removeUniqueName(this._alias);
                }
                if (OutputColumnPanel.this._outputColumnNameGenerator.doesNameExist(string)) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("ROWFILTER_DATA_ALIAS_DUPLICATE"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                    return false;
                }
                OutputColumnPanel.this._outputColumnNameGenerator.addUniqueName(string);
            }
            return super.stopCellEditing();
        }
    }

    private static class AttrsTableModel
    extends GenericBaseTableModel {
        public static String[] _columnNames = new String[]{DialogsLrb.get("ROWFILTER_ATTR_NAME"), DialogsLrb.get("ROWFILTER_ATTR_ALIAS"), DialogsLrb.get("ROWFILTER_DATA_TYPE")};
        public static final int ATTR_NAME = 0;
        public static final int ATTR_ALIAS = 1;
        public static final int DATA_TYPE = 2;
        public static final int COLUMN_COUNT = 3;
        private OutputColumnPanel _parent;
        private RowFilterOutputColumnsType _srcData;
        private Context _context;

        public AttrsTableModel(OutputColumnPanel outputColumnPanel, RowFilterOutputColumnsType rowFilterOutputColumnsType, Context context) {
            this._parent = outputColumnPanel;
            this._srcData = rowFilterOutputColumnsType;
            this._context = context;
            this.setColumnIdentifiers(_columnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(3);
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.getAttribute().size() : 0;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1 ? this._parent.isWritable() : false;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            AttributeType attributeType = (AttributeType)this._srcData.getAttribute().get(n);
            String string = null;
            switch (n2) {
                case 0: {
                    string = attributeType.getName();
                    break;
                }
                case 1: {
                    string = attributeType.getAlias();
                    break;
                }
                case 2: {
                    string = attributeType.getDataType();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 != 1) {
                return;
            }
            AttributeType attributeType = (AttributeType)this._srcData.getAttribute().get(n);
            Vector vector = new Vector();
            vector.addAll(this._srcData.getAttribute());
            vector.remove(attributeType);
            String string = null;
            String string2 = attributeType.getAlias();
            String string3 = attributeType.getName();
            if (object != null) {
                string = ((String)object).trim();
            }
            if (string2 != null && StringUtils.isDoubleQuotedString(string)) {
                string2 = StringUtils.addDoubleQuotes(string2);
            }
            if (string2 != null && string2.compareTo(string) == 0) {
                return;
            }
            if (string.length() != 0) {
                if (!StringUtils.isDoubleQuotedString(string)) {
                    string = string.toUpperCase();
                }
                if (!AttributeNameValidator.validateAttributeName(string, vector, this._context, true)) {
                    return;
                }
            } else if (string2 != null && string2.length() != 0 && !AttributeNameValidator.validateAttributeName(string3, vector, this._context, true)) {
                return;
            }
            string = string != null && string.length() == 0 ? null : StringUtils.trimDoubleQuotes(string);
            attributeType.setAlias(string);
            this._parent.setDirty(true);
            if (this._parent.getPropertyModel() != null) {
                this._parent.updateNode();
            }
        }

        public void setSrcData(RowFilterOutputColumnsType rowFilterOutputColumnsType) {
            this._srcData = rowFilterOutputColumnsType;
            this.setRowCount(this._srcData != null ? this._srcData.getAttribute().size() : 0);
        }
    }
}

