/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.sample;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.controls.GraphPanel;
import oracle.dmt.dataminer.controls.GraphicalPreferencesSettings;
import oracle.dmt.dataminer.controls.renderers.NumberCellRenderer;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.sample.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.sample.SettingsPanel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.sample.WorkflowSampleNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.SampleNode;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SampleNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SamplingSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.StratifiedType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Element;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class CustomPanel
extends AbstractDialogPanel {
    private SettingsPanel _parent;
    private WorkflowSampleNodePropertyProxyModel _propertyModel;
    private TreeMap<String, Integer> _sourceStatistic;
    private TreeMap<String, Integer> _stratifiedSampledDistribution;
    private DistribTableModel _models;
    private GraphPanel _graphPanel;
    private GraphPanel _graphPanel2;
    private int _totalRows;
    private static Icon _editIcon;
    private JButton _editBtn;
    private SamplingSettingsType _samplingSettings;
    private boolean _dirty;
    private static Preferences _p;
    private GraphicalPreferencesSettings graphPanelSettings = GraphicalPreferencesSettings.getInstance((PropertyStorage)_p);
    private String styleSelection = DefaultGraphDataModel.DEFAULT_GRAPH_STYLE;
    private int depthRadius = _DEPTH_RADIUS;
    private static int _DEPTH_RADIUS;
    private JLabel jColumnLabel;
    private JLabel jColumnValueLabel;
    private JButton jEqualButton;
    private JButton jOriginalButton;
    private JPanel jOutputPanel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JButton jResetButton;
    private JPanel jSourcePanel;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private DataMinerTablePanel tablePanel;

    public CustomPanel(PropertyModel propertyModel, SettingsPanel settingsPanel) {
        super(null, null);
        assert (propertyModel != null) : "PropertyModel for SampleNode node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this._parent = settingsPanel;
        this.init((SampleNode)this._data, propertyModel);
    }

    public CustomPanel(Context context, SampleNode sampleNode, SettingsPanel settingsPanel) {
        super(context, sampleNode);
        assert (context != null) : "Context must not be null.";
        assert (sampleNode != null) : "SampleNode node must not be null.";
        assert (sampleNode instanceof SampleNode) : "Must be an instance of SampleNode node.";
        this._parent = settingsPanel;
        this.init(sampleNode, null);
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jColumnLabel, (Component)this.jColumnValueLabel, (String)DialogsLrb.get("SAMPLE_CUSTOM_COLUMN"));
        ResourceUtils.resButton((AbstractButton)this.jEqualButton, (String)DialogsLrb.get("SAMPLE_CUSTOM_BALANCED"));
        ResourceUtils.resButton((AbstractButton)this.jOriginalButton, (String)DialogsLrb.get("SAMPLE_CUSTOM_ORIGINAL"));
        ResourceUtils.resButton((AbstractButton)this.jResetButton, (String)DialogsLrb.get("SAMPLE_CUSTOM_RESET"));
        _editIcon = InspectorArb.getIcon((int)24);
    }

    @Override
    public void initUI() {
        Object object;
        Object object2;
        Object object3;
        HelpUtils.setHelpID((JComponent)this, (String)"sample_custom");
        String string = this._samplingSettings.getMethod().getStratified().getTargetAttr();
        this.jColumnValueLabel.setText(string);
        SampleNode sampleNode = (SampleNode)this.getData();
        this._sourceStatistic = sampleNode.getStatisticLookupMap();
        this._stratifiedSampledDistribution = null;
        boolean bl = false;
        if (this._parent.getStratifiedType() == StratifiedType.ORIGINAL) {
            this._stratifiedSampledDistribution = sampleNode.getStratifiedSampledDistribution(this._parent.getNumberOfRows(), this._parent.getPercentOfTotal(), false, null);
        } else if (this._parent.getStratifiedType() == StratifiedType.BALANCED) {
            this._stratifiedSampledDistribution = sampleNode.getStratifiedSampledDistribution(this._parent.getNumberOfRows(), this._parent.getPercentOfTotal(), true, null);
        } else {
            object3 = this._samplingSettings.getMethod().getStratified().getDistributions();
            this._stratifiedSampledDistribution = object3 == null || object3.getDistribution().size() == 0 ? sampleNode.getStratifiedSampledDistribution(this._parent.getNumberOfRows(), this._parent.getPercentOfTotal(), false, null) : sampleNode.getStratifiedSampledDistribution(this._parent.getNumberOfRows(), this._parent.getPercentOfTotal(), false, (SamplingSettingsType.Method.Stratified.Distributions)object3);
            bl = true;
        }
        this._models = new DistribTableModel(this, this._sourceStatistic, this._stratifiedSampledDistribution, bl);
        if (this._parent.getStratifiedType() == StratifiedType.CUSTOM) {
            this._editBtn = new JButton(_editIcon);
            this._editBtn.setToolTipText(DialogsLrb.get("SAMPLE_CUSTOM_EDIT_SAMPLE_COUNT"));
            this._editBtn.setEnabled(false);
            this.tablePanel.addControlBarComponents(this._editBtn);
            this._editBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = CustomPanel.this.tablePanel.getTable().getSelectedRow();
                    CustomPanel.this.tablePanel.getTable().editCellAt(n, 4);
                    TableColumn tableColumn = CustomPanel.this.tablePanel.getTable().getColumnModel().getColumn(4);
                    CustomCellEditor customCellEditor = (CustomCellEditor)tableColumn.getCellEditor();
                    customCellEditor.getComponent().requestFocusInWindow();
                }
            });
        }
        this.tablePanel.setup((TableModel)((Object)this._models), DialogsLrb.get("SAMPLE_CUSTOM_TABLE"), 0);
        this.tablePanel.getTable().setSelectionMode(2);
        this.tablePanel.getTable().setColumnSelectorAvailable(true);
        this.tablePanel.getTable().setShowToolTips(true);
        this.tablePanel.getTable().setUpdateSelectionOnSort(true);
        this.tablePanel.getTable().setRowSelectionAllowed(true);
        this.tablePanel.getTable().setSortColumn(0, true);
        this.tablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                if (defaultListSelectionModel != null && defaultListSelectionModel.getValueIsAdjusting()) {
                    return;
                }
                CustomPanel.this.enableControls();
            }
        });
        object3 = this.tablePanel.getTable().getColumnModel().getColumn(2);
        ((TableColumn)object3).setCellRenderer(new NumberCellRenderer());
        object3 = this.tablePanel.getTable().getColumnModel().getColumn(3);
        ((TableColumn)object3).setCellRenderer(new NumberCellRenderer());
        if (this._parent.getStratifiedType() == StratifiedType.CUSTOM) {
            object3 = this.tablePanel.getTable().getColumnModel().getColumn(4);
            object2 = new CustomCellEditor();
            ((TableColumn)object3).setCellEditor((TableCellEditor)object2);
        }
        this.jSourcePanel.removeAll();
        this.jSourcePanel.setLayout(new BorderLayout(0, 0));
        object2 = new DefaultGraphDataModel(null, 17, null, null, null);
        object2.setDepthRadius(this.depthRadius);
        object2.setStyleSelection(this.styleSelection);
        Set<String> set = this._sourceStatistic.keySet();
        Iterator<String> iterator = set.iterator();
        Object[] objectArray = new Object[this._sourceStatistic.size()];
        Object[] objectArray2 = null;
        Object[][] objectArray3 = null;
        object2.clear();
        object2.setGraphType(17);
        objectArray3 = new Object[this._sourceStatistic.size()][1];
        objectArray2 = new Object[1];
        this._totalRows = 0;
        int n = 0;
        double d = 0.0;
        while (iterator.hasNext()) {
            objectArray[n] = object = iterator.next();
            Integer n2 = this._sourceStatistic.get(object);
            if (n2.doubleValue() > d) {
                d = n2.doubleValue();
            }
            objectArray2[0] = DialogsLrb.get("SAMPLE_SETTING_GRAPH_COLUMN_VALUES");
            objectArray3[n][0] = n2;
            object2.setTitle(DialogsLrb.get("SAMPLE_SETTING_GRAPH_SOURCE"));
            ++n;
            this._totalRows += n2.intValue();
        }
        object2.addRowLabels(objectArray2);
        object2.addColumnLabels(objectArray);
        object2.addGraphData(objectArray3);
        object2.setY1(DialogsLrb.get("SAMPLE_SETTING_GRAPH_COUNT"), d);
        this._graphPanel = new GraphPanel((GraphDataModel)object2);
        this._graphPanel.initGraph();
        this.jSourcePanel.add((Component)this._graphPanel, "Center");
        object = new JPanel();
        ((Container)object).add(new JLabel(DialogsLrb.get("SAMPLE_TOTAL_ROWS") + this._totalRows));
        this.jSourcePanel.add((Component)object, "South");
        this.jSourcePanel.updateUI();
        this.refreshOutputGraph();
        this.enableControls();
    }

    private void enableControls() {
        int n = this.tablePanel.getTable().getSelectedRowCount();
        if (this._editBtn != null) {
            this._editBtn.setEnabled(n > 0);
        }
        this.jEqualButton.setVisible(this._parent.getStratifiedType() == StratifiedType.CUSTOM);
        this.jOriginalButton.setVisible(this._parent.getStratifiedType() == StratifiedType.CUSTOM);
        this.jResetButton.setVisible(this._parent.getStratifiedType() == StratifiedType.CUSTOM);
    }

    private boolean isPIMode() {
        return this._propertyModel != null;
    }

    private void init(SampleNode sampleNode, PropertyModel propertyModel) {
        this._propertyModel = (WorkflowSampleNodePropertyProxyModel)propertyModel;
        this._samplingSettings = (SamplingSettingsType)MetaDataHelper.copyMetadataObject(this._parent.getSamplingSettings());
        this._dirty = this._samplingSettings.getMethod().getStratified().getDistributions().getDistribution().size() == 0;
        this.styleSelection = this.graphPanelSettings.getGraphStyle();
        this.depthRadius = this.graphPanelSettings.getRadiusDepthValue();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowSampleNodePropertyProxyModel)) {
            return null;
        }
        WorkflowSampleNodePropertyProxyModel workflowSampleNodePropertyProxyModel = (WorkflowSampleNodePropertyProxyModel)propertyModel;
        Context context = workflowSampleNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    private SampleNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowSampleNodePropertyProxyModel)) {
            return null;
        }
        WorkflowSampleNodePropertyProxyModel workflowSampleNodePropertyProxyModel = (WorkflowSampleNodePropertyProxyModel)propertyModel;
        Context context = workflowSampleNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof SampleNodeType) {
            return (SampleNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNode() {
        try {
            CommandProcessor.getInstance().beginTrans(DialogsLrb.get("SAMPLE_NODE_EDIT_TRANSACTION_NAME"));
            SampleNode sampleNode = (SampleNode)this.getData();
            SampleNodeType sampleNodeType = (SampleNodeType)sampleNode.getData();
            ArrayList<ComplexProperty> arrayList = new ArrayList<ComplexProperty>();
            ComplexProperty complexProperty = new ComplexProperty("SamplingSettings", this._samplingSettings);
            complexProperty.setOldData(sampleNodeType.getSamplingSettings());
            arrayList.add(complexProperty);
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getData().getUndoFilter();
            odmrSDMUndoFilter.prepareUndoComplexPropertyList(sampleNode, this.getContext(), arrayList);
            sampleNode.validate(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("SAMPLE_NODE_EDIT_ERROR_MESG"), null);
            CommandProcessor.getInstance().abortTrans();
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    public void refreshOutputGraph() {
        Object object;
        this.jOutputPanel.removeAll();
        this.jOutputPanel.setLayout(new BorderLayout(0, 0));
        this.jOutputPanel.removeAll();
        this.jOutputPanel.setLayout(new BorderLayout());
        DefaultGraphDataModel defaultGraphDataModel = new DefaultGraphDataModel(null, 17, null, null, null);
        defaultGraphDataModel.setDepthRadius(this.depthRadius);
        defaultGraphDataModel.setStyleSelection(this.styleSelection);
        Set<String> set = this._stratifiedSampledDistribution.keySet();
        Iterator<String> iterator = set.iterator();
        Object[] objectArray = new Object[this._stratifiedSampledDistribution.size()];
        Object[] objectArray2 = null;
        Object[][] objectArray3 = null;
        defaultGraphDataModel.clear();
        defaultGraphDataModel.setGraphType(17);
        objectArray3 = new Object[this._stratifiedSampledDistribution.size()][1];
        objectArray2 = new Object[1];
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        while (iterator.hasNext()) {
            objectArray[n] = object = iterator.next();
            Integer n3 = this._stratifiedSampledDistribution.get(object);
            if (n3.doubleValue() > d) {
                d = n3.doubleValue();
            }
            objectArray2[0] = DialogsLrb.get("SAMPLE_SETTING_GRAPH_COLUMN_VALUES");
            objectArray3[n][0] = n3;
            defaultGraphDataModel.setTitle(DialogsLrb.get("SAMPLE_SETTING_GRAPH_OUTPUT"));
            ++n;
            n2 += n3.intValue();
        }
        defaultGraphDataModel.addRowLabels(objectArray2);
        defaultGraphDataModel.addColumnLabels(objectArray);
        defaultGraphDataModel.addGraphData(objectArray3);
        defaultGraphDataModel.setY1(DialogsLrb.get("SAMPLE_SETTING_GRAPH_COUNT"), d);
        this._graphPanel2 = new GraphPanel(defaultGraphDataModel);
        this._graphPanel2.initGraph();
        this.jOutputPanel.add((Component)this._graphPanel2, "Center");
        object = new JPanel();
        double d2 = 0.0;
        if (this._totalRows > 0) {
            d2 = (double)n2 / (double)this._totalRows;
        }
        ((Container)object).add(new JLabel(DialogsLrb.get("SAMPLE_TOTAL_SAMPLE") + n2 + " (" + NumericFormat.format(d2 * 100.0, true, 2) + DialogsLrb.get("SAMPLE_PERCENT_OF_ORIGINAL") + ")"));
        this.jOutputPanel.add((Component)object, "South");
        this.jOutputPanel.updateUI();
    }

    public boolean doWork() {
        boolean bl = true;
        if (this.isDirty() || this._models.isDirty()) {
            SamplingSettingsType.Method.Stratified.Distributions distributions = new SamplingSettingsType.Method.Stratified.Distributions();
            Set<String> set = this._stratifiedSampledDistribution.keySet();
            for (String string : set) {
                Integer n = this._stratifiedSampledDistribution.get(string);
                SamplingSettingsType.Method.Stratified.Distributions.Distribution distribution = new SamplingSettingsType.Method.Stratified.Distributions.Distribution();
                distribution.setTargetValue(string);
                distribution.setCount(BigInteger.valueOf(n.intValue()));
                distributions.getDistribution().add(distribution);
            }
            this._samplingSettings.getMethod().getStratified().setDistributions(distributions);
            if (this.isPIMode()) {
                this.updateNode();
            } else if (this._parent != null) {
                this._parent.setSamplingSettings(this._samplingSettings);
                this._parent.setDirty(true);
            }
        }
        return bl;
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jColumnLabel = new JLabel();
        this.jColumnValueLabel = new JLabel();
        this.jEqualButton = new JButton();
        this.jOriginalButton = new JButton();
        this.jResetButton = new JButton();
        this.tablePanel = new DataMinerTablePanel();
        this.jPanel2 = new JPanel();
        this.jSplitPane2 = new JSplitPane();
        this.jSourcePanel = new JPanel();
        this.jOutputPanel = new JPanel();
        this.setPreferredSize(new Dimension(650, 400));
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jSplitPane1.setName("jSplitPane1");
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jPanel1.setName("jPanel1");
        this.jColumnLabel.setText("Column:");
        this.jColumnLabel.setName("jColumnLabel");
        this.jColumnValueLabel.setText("CLASS");
        this.jColumnValueLabel.setName("jColumnValueLabel");
        this.jEqualButton.setText("Equal");
        this.jEqualButton.setName("jEqualButton");
        this.jEqualButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomPanel.this.jEqualButtonActionPerformed(actionEvent);
            }
        });
        this.jOriginalButton.setText("Original");
        this.jOriginalButton.setName("jOriginalButton");
        this.jOriginalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomPanel.this.jOriginalButtonActionPerformed(actionEvent);
            }
        });
        this.jResetButton.setText("Reset");
        this.jResetButton.setName("jResetButton");
        this.jResetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomPanel.this.jResetButtonActionPerformed(actionEvent);
            }
        });
        this.tablePanel.setName("tablePanel");
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(0, 429, Short.MAX_VALUE).addComponent(this.jEqualButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jOriginalButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jResetButton)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jColumnLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jColumnValueLabel, -2, 189, -2)).addComponent(this.tablePanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jColumnLabel).addComponent(this.jColumnValueLabel)).addGap(15, 15, 15).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jResetButton).addComponent(this.jOriginalButton).addComponent(this.jEqualButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tablePanel, -1, 120, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane1.setTopComponent(this.jPanel1);
        this.jPanel2.setName("jPanel2");
        this.jSplitPane2.setBorder(null);
        this.jSplitPane2.setDividerLocation(325);
        this.jSplitPane2.setDividerSize(0);
        this.jSplitPane2.setResizeWeight(0.5);
        this.jSplitPane2.setName("jSplitPane2");
        this.jSourcePanel.setName("jSourcePanel");
        GroupLayout groupLayout2 = new GroupLayout(this.jSourcePanel);
        this.jSourcePanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 325, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 195, Short.MAX_VALUE));
        this.jSplitPane2.setLeftComponent(this.jSourcePanel);
        this.jOutputPanel.setName("jOutputPanel");
        GroupLayout groupLayout3 = new GroupLayout(this.jOutputPanel);
        this.jOutputPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 325, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 195, Short.MAX_VALUE));
        this.jSplitPane2.setRightComponent(this.jOutputPanel);
        GroupLayout groupLayout4 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane2));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane2));
        this.jSplitPane1.setRightComponent(this.jPanel2);
        GroupLayout groupLayout5 = new GroupLayout(this);
        this.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1));
    }

    private void jEqualButtonActionPerformed(ActionEvent actionEvent) {
        SampleNode sampleNode = (SampleNode)this.getData();
        this._stratifiedSampledDistribution = sampleNode.getStratifiedSampledDistribution(this._parent.getNumberOfRows(), this._parent.getPercentOfTotal(), true, null);
        this._models = new DistribTableModel(this, this._sourceStatistic, this._stratifiedSampledDistribution, true);
        this.tablePanel.getTable().setModel((TableModel)((Object)this._models));
        this.refreshOutputGraph();
        this._dirty = true;
    }

    private void jOriginalButtonActionPerformed(ActionEvent actionEvent) {
        SampleNode sampleNode = (SampleNode)this.getData();
        this._stratifiedSampledDistribution = sampleNode.getStratifiedSampledDistribution(this._parent.getNumberOfRows(), this._parent.getPercentOfTotal(), false, null);
        this._models = new DistribTableModel(this, this._sourceStatistic, this._stratifiedSampledDistribution, true);
        this.tablePanel.getTable().setModel((TableModel)((Object)this._models));
        this.refreshOutputGraph();
        this._dirty = true;
    }

    private void jResetButtonActionPerformed(ActionEvent actionEvent) {
        SampleNode sampleNode = (SampleNode)this.getData();
        SamplingSettingsType.Method.Stratified.Distributions distributions = this._samplingSettings.getMethod().getStratified().getDistributions();
        this._stratifiedSampledDistribution = distributions == null || distributions.getDistribution().size() == 0 ? sampleNode.getStratifiedSampledDistribution(this._parent.getNumberOfRows(), this._parent.getPercentOfTotal(), false, null) : sampleNode.getStratifiedSampledDistribution(this._parent.getNumberOfRows(), this._parent.getPercentOfTotal(), false, distributions);
        this._models = new DistribTableModel(this, this._sourceStatistic, this._stratifiedSampledDistribution, true);
        this.tablePanel.getTable().setModel((TableModel)((Object)this._models));
        this.refreshOutputGraph();
        this._dirty = true;
    }

    static {
        _p = Preferences.getPreferences();
        _DEPTH_RADIUS = 50;
    }

    private class CustomCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private NumberTextField _textField = new NumberTextField();
        private String _targetValue;

        public CustomCellEditor() {
            this._textField.setDataType(Integer.class);
            this._textField.setSigned(false);
            this._textField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CustomCellEditor.this.fireEditingStopped();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object != null) {
                Object[] objectArray = CustomPanel.this._sourceStatistic.keySet().toArray();
                this._targetValue = (String)objectArray[n];
                Integer n3 = (Integer)object;
                this._textField.setNumber((Number)n3);
            } else {
                this._textField.setText("");
            }
            return this._textField;
        }

        @Override
        public Object getCellEditorValue() {
            NumberTextField numberTextField = this._textField;
            Number number = numberTextField.getNumber();
            Integer n = number.intValue();
            return n;
        }

        public NumberTextField getComponent() {
            return this._textField;
        }
    }

    private static class DistribTableModel
    extends GenericBaseTableModel {
        public static String[] _columnNames = new String[]{DialogsLrb.get("SAMPLE_CUSTOM_STRATIFY_VALUE"), DialogsLrb.get("SAMPLE_CUSTOM_TOTAL_COUNT"), DialogsLrb.get("SAMPLE_CUSTOM_ORGINAL_DISTRIBUTION"), DialogsLrb.get("SAMPLE_CUSTOM_SAMPLE_DISTRIBUTION"), DialogsLrb.get("SAMPLE_CUSTOM_SAMPLE_COUNT")};
        public static final int STRATIFY_VALUE = 0;
        public static final int TOTAL_COUNT = 1;
        public static final int ORGINAL_DISTRIBUTION = 2;
        public static final int SAMPLE_DISTRIBUTION = 3;
        public static final int SAMPLE_COUNT = 4;
        public static final int COLUMN_COUNT = 5;
        private CustomPanel _parent;
        private boolean _isEditable = false;
        private TreeMap<String, Integer> _originalStatistics;
        private TreeMap<String, Integer> _sampleStatistics;
        private int _originalTotal;
        private int _sampleTotal;
        private boolean _isDirty = false;

        public DistribTableModel(CustomPanel customPanel, TreeMap<String, Integer> treeMap, TreeMap<String, Integer> treeMap2, boolean bl) {
            this._parent = customPanel;
            this._isEditable = bl;
            this._originalStatistics = treeMap;
            this._sampleStatistics = treeMap2;
            Iterator<Integer> iterator = this._originalStatistics.values().iterator();
            this._originalTotal = 0;
            while (iterator.hasNext()) {
                this._originalTotal += iterator.next().intValue();
            }
            iterator = this._sampleStatistics.values().iterator();
            this._sampleTotal = 0;
            while (iterator.hasNext()) {
                this._sampleTotal += iterator.next().intValue();
            }
            this.setColumnIdentifiers(_columnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(5);
        }

        public int getRowCount() {
            return this._originalStatistics != null ? this._originalStatistics.size() : 0;
        }

        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Integer.class;
                }
                case 2: {
                    return Double.class;
                }
                case 3: {
                    return Double.class;
                }
                case 4: {
                    return Integer.class;
                }
            }
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return this._isEditable && n2 == 4;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            Object[] objectArray = this._originalStatistics.keySet().toArray();
            Object object = null;
            switch (n2) {
                case 0: {
                    object = objectArray[n];
                    break;
                }
                case 1: {
                    object = this._originalStatistics.get(objectArray[n]);
                    break;
                }
                case 2: {
                    if (this._originalTotal == 0) {
                        object = 0.0;
                        break;
                    }
                    object = (double)this._originalStatistics.get(objectArray[n]).intValue() / (double)this._originalTotal;
                    break;
                }
                case 3: {
                    if (this._sampleTotal == 0) {
                        object = 0.0;
                        break;
                    }
                    object = (double)this._sampleStatistics.get(objectArray[n]).intValue() / (double)this._sampleTotal;
                    break;
                }
                case 4: {
                    object = this._sampleStatistics.get(objectArray[n]);
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        private void refreshSampleTotal() {
            Iterator<Integer> iterator = this._sampleStatistics.values().iterator();
            this._sampleTotal = 0;
            while (iterator.hasNext()) {
                this._sampleTotal += iterator.next().intValue();
            }
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 4) {
                Object[] objectArray = this._sampleStatistics.keySet().toArray();
                Object object2 = objectArray[n];
                String string = (String)objectArray[n];
                Integer n3 = this._originalStatistics.get(string);
                Integer n4 = (Integer)object;
                if (n4 > n3) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("SAMPLE_CUSTOM_SAMPLE_COUNT_INVALID"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                    return;
                }
                this._sampleStatistics.put((String)object2, (Integer)object);
                this.refreshSampleTotal();
                this._parent.tablePanel.getTable().setModel((TableModel)((Object)this));
                this._parent.refreshOutputGraph();
                this._isDirty = true;
            }
        }

        public boolean isDirty() {
            return this._isDirty;
        }
    }
}

