/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.sqlQuery;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dialogs.Messages;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.dbtools.raptor.phighlight.HighlightEditorPlugin;
import oracle.dbtools.raptor.utils.oerr.Oerr;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.teditor.data.DataViewerPanel;
import oracle.dmt.dataminer.teditor.data.ODMrGraphOutputPanel;
import oracle.dmt.dataminer.teditor.data.ODMrXMLOutputPanel;
import oracle.dmt.dataminer.teditor.structure.ColumnDataRow;
import oracle.dmt.dataminer.teditor.structure.StructureViewPanel;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.sqlQuery.CreateViewDialog;
import oracle.dmt.dataminer.workflow.dialog.sqlQuery.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.sqlQuery.MySnippetPanel;
import oracle.dmt.dataminer.workflow.dialog.sqlQuery.PLSQLFunctionsPanel;
import oracle.dmt.dataminer.workflow.dialog.sqlQuery.RScriptsPanel;
import oracle.dmt.dataminer.workflow.dialog.sqlQuery.SQLContext;
import oracle.dmt.dataminer.workflow.dialog.sqlQuery.SourcesPanel;
import oracle.dmt.dataminer.workflow.model.SQLQueryNode;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.SQLQueryNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SQLQueryOutputColumnsType;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.gutter.Gutter;
import oracle.javatools.editor.gutter.GutterClickListener;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.BraceMatchingPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.icons.OracleIcons;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SQLQueryEditorPanel
extends AbstractDialogPanel {
    private static final Logger theLogger = Logger.getLogger(SQLQueryEditorPanel.class.getName());
    private transient SQLContext _context;
    private PropertyModel _model;
    private String _sqlExpression;
    private SQLQueryOutputColumnsType _outputColumns;
    private boolean _hasWithClause = false;
    private boolean _generateView = false;
    private String _viewName = null;
    private SourcesPanel _sourcesPanel;
    private PLSQLFunctionsPanel _functionsPanel;
    private MySnippetPanel _snippetPanel;
    private RScriptsPanel _RScriptsPanel;
    private BasicEditorPane _sqlEditor = EditorFactory.createIdeEditorPane();
    private JTextArea _validationResults = new JTextArea();
    private JTabbedPane _viewerTabPane = new JTabbedPane();
    private DataViewerPanel _dataViewerPane;
    private StructureViewPanel _structureViewPane;
    private ArrayList<ODMrXMLOutputPanel> _xmlPanels = new ArrayList();
    private ArrayList<ODMrGraphOutputPanel> _GraphOutputPanels = new ArrayList();
    private boolean _isRScriptsAvailable = false;
    private boolean _bNeedValidate = false;
    private boolean _expressionDirty = false;
    private boolean _validateExpression = true;
    private boolean _outputColumnsDirty = false;
    private boolean _previewColumnsLoaded = false;
    private boolean _previewDataLoaded = false;
    private transient Vector<ColumnDataRow> _columnMetaData = new Vector();
    private UndoManager _undoManager = new UndoManager();
    private static String SOURCES_TAB = DialogsLrb.get("SQLQUERY_SOURCE_TAB");
    private static String SNIPPETS_TAB = DialogsLrb.get("SQLQUERY_SNIPPETS_TAB");
    private static String FUNCTIONS_TAB = DialogsLrb.get("SQLQUERY_PLSQL_TAB");
    private static String RSCRIPTS_TAB = DialogsLrb.get("SQLQUERY_RSCRIPTS_TAB");
    private static String COLUMN_TAB = DialogsLrb.get("SQLQUERY_DATA_COLUMN");
    private static String DATA_TAB = DialogsLrb.get("SQLQUERY_DATA_DATA");
    private static String GRAPH_TAB = DialogsLrb.get("SQLQUERY_DATA_GRAPH");
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPreviewPanel;
    private JToolBar jPreviewToolBar;
    private JProgressBar jProgressBar;
    private JButton jRedoButton;
    private JButton jRefreshButton;
    private JPanel jSQLPanel;
    private JScrollPane jSQLScrollPane;
    private JPanel jSQLStatusPanel;
    private JToolBar jSQLTextToolBar;
    private JTabbedPane jSourceTabbedPane;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JButton jUndoButton;
    private JButton jValidateButton;
    private JLabel locationLabel;

    public SQLQueryEditorPanel(SQLContext sQLContext, PropertyModel propertyModel) {
        super(sQLContext.getContext(), sQLContext.getNode());
        assert (sQLContext != null) : "Context must not be null.";
        assert (sQLContext.getNode() != null) : "SQLQuery node must not be null.";
        assert (sQLContext.getNode() instanceof SQLQueryNode) : "Must be an instance of SQLQuery node.";
        this._context = sQLContext;
        this._model = propertyModel;
        SQLQueryNodeType sQLQueryNodeType = (SQLQueryNodeType)sQLContext.getNode().getData();
        this._bNeedValidate = sQLQueryNodeType.getStatus() == NodeStatusType.INVALID || sQLQueryNodeType.getStatus() == NodeStatusType.FAILURE;
        this._sqlExpression = sQLQueryNodeType.getSQLQueryExpression();
        this._outputColumns = (SQLQueryOutputColumnsType)MetaDataHelper.copyMetadataObject(sQLQueryNodeType.getSQLQueryOutputColumns());
        this._hasWithClause = sQLQueryNodeType.isHasWithClause();
        this._generateView = sQLQueryNodeType.isGenerateView();
        this._viewName = sQLQueryNodeType.getViewName();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        this.jValidateButton.setIcon(OracleIcons.getIcon((String)"validator.png"));
        this.jValidateButton.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("SQLQUERY_QUERY_RUN_ADA"));
        this.jValidateButton.setToolTipText(DialogsLrb.get("SQLQUERY_QUERY_RUN_ADA"));
        this.jUndoButton.setIcon(OracleIcons.getIcon((String)"undo.png"));
        this.jUndoButton.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("SQLQUERY_QUERY_UNDO_ADA"));
        this.jUndoButton.setToolTipText(DialogsLrb.get("SQLQUERY_QUERY_UNDO_ADA"));
        this.jRedoButton.setIcon(OracleIcons.getIcon((String)"redo.png"));
        this.jRedoButton.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("SQLQUERY_QUERY_REDO_ADA"));
        this.jRedoButton.setToolTipText(DialogsLrb.get("SQLQUERY_QUERY_REDO_ADA"));
        this.jRefreshButton.setIcon(DataMinerIcons.get(Icons.REFRESH_ICON));
        this.jRefreshButton.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("SQLQUERY_QUERY_REFRESH_ADA"));
        this.jRefreshButton.setToolTipText(DialogsLrb.get("SQLQUERY_QUERY_REFRESH_ADA"));
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)"sql_query_editor");
        this._sourcesPanel = new SourcesPanel(this, this._context);
        this.jSourceTabbedPane.add(SOURCES_TAB, this._sourcesPanel);
        this._snippetPanel = new MySnippetPanel(this, this._context);
        this.jSourceTabbedPane.add(SNIPPETS_TAB, (Component)((Object)this._snippetPanel));
        this._functionsPanel = new PLSQLFunctionsPanel(this, this._context);
        this.jSourceTabbedPane.add(FUNCTIONS_TAB, this._functionsPanel);
        this._isRScriptsAvailable = this.isRScriptsAvailable();
        if (this._isRScriptsAvailable) {
            this._RScriptsPanel = new RScriptsPanel(this, this._context);
            this.jSourceTabbedPane.add(RSCRIPTS_TAB, this._RScriptsPanel);
        }
        this.jSourceTabbedPane.setSelectedIndex(0);
        this.jSQLScrollPane.setViewportView((Component)this._sqlEditor);
        this._sqlEditor.setDocument((Document)new BasicDocument("foo.plsql"));
        this._sqlEditor.setText(this._sqlExpression);
        final LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
        this._sqlEditor.installPlugin((EditorPlugin)lineGutterPlugin);
        this._sqlEditor.installPlugin((EditorPlugin)new HighlightEditorPlugin());
        this._sqlEditor.installPlugin((EditorPlugin)new BraceMatchingPlugin());
        this._sqlEditor.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                SQLQueryEditorPanel.this.setLineCol();
            }
        });
        this.setLineCol();
        lineGutterPlugin.setShowLineNumbers(3);
        this.jSQLScrollPane.setRowHeaderView((Component)lineGutterPlugin);
        final JPopupMenu jPopupMenu = new JPopupMenu(oracle.dbtools.raptor.Messages.getString((String)"DisplayCodeEditor.3"));
        JMenuItem jMenuItem = new JMenuItem(oracle.dbtools.raptor.Messages.getString((String)"DisplayCodeEditor.4"));
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditorProperties editorProperties = EditorProperties.getProperties();
                boolean bl = !editorProperties.getBooleanProperty("show-line-numbers");
                editorProperties.putBooleanProperty("show-line-numbers", bl);
            }
        });
        lineGutterPlugin.addGutterClickListener(new GutterClickListener(){

            public void lineClicked(Gutter gutter, int n, MouseEvent mouseEvent) {
                gutter.hashCode();
                jPopupMenu.show((Component)lineGutterPlugin, mouseEvent.getX(), mouseEvent.getY());
            }
        });
        this.jSQLScrollPane.getRowHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = mouseEvent.getModifiers();
                if ((n & 8) != 0 || (n & 4) != 0) {
                    jPopupMenu.show((Component)lineGutterPlugin, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        Document document = this._sqlEditor.getDocument();
        document.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                SQLQueryEditorPanel.this.setExpressionDirty();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SQLQueryEditorPanel.this.setExpressionDirty();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SQLQueryEditorPanel.this.setExpressionDirty();
            }
        });
        this._sqlEditor.setDragEnabled(true);
        document.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                SQLQueryEditorPanel.this._undoManager.addEdit(undoableEditEvent.getEdit());
            }
        });
        this._sqlEditor.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (SQLQueryEditorPanel.this._undoManager.canUndo()) {
                        SQLQueryEditorPanel.this._undoManager.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    theLogger.log(Level.SEVERE, cannotUndoException.getLocalizedMessage(), cannotUndoException);
                }
            }
        });
        this._sqlEditor.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        this._sqlEditor.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (SQLQueryEditorPanel.this._undoManager.canRedo()) {
                        SQLQueryEditorPanel.this._undoManager.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    theLogger.log(Level.SEVERE, cannotRedoException.getLocalizedMessage(), cannotRedoException);
                }
            }
        });
        this._sqlEditor.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
        this.enableControls(true);
        try {
            this._structureViewPane = new StructureViewPanel(this.getContext(), null);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
        }
        this._viewerTabPane.addTab(COLUMN_TAB, this._structureViewPane);
        this._viewerTabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (changeEvent.getSource() instanceof JTabbedPane) {
                    Component component = SQLQueryEditorPanel.this._viewerTabPane.getSelectedComponent();
                    if (component instanceof StructureViewPanel) {
                        SQLQueryEditorPanel.this.showSQLExpressionColumns();
                    } else if (component instanceof DataViewerPanel) {
                        SQLQueryEditorPanel.this.showSQLExpressionResult();
                    }
                }
            }
        });
        this.jProgressBar.setVisible(false);
        this.jSplitPane2.setRightComponent(null);
    }

    private void enableControls(boolean bl) {
        this.jValidateButton.setEnabled(bl && this._sqlExpression != null && this._sqlExpression.length() > 0);
        this.jUndoButton.setEnabled(bl && this._undoManager.canUndo());
        this.jRedoButton.setEnabled(bl && this._undoManager.canRedo());
        this.jRefreshButton.setEnabled(bl && this._sqlExpression != null && this._sqlExpression.length() > 0);
        this._sqlEditor.setEditable(bl);
    }

    private void setExpressionDirty() {
        String string = this._sqlEditor.getText().trim();
        if (!string.isEmpty()) {
            while (!string.isEmpty() && string.endsWith(";")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        if (this._sqlExpression != null && this._sqlExpression.compareToIgnoreCase(string) != 0 || this._sqlExpression == null && !string.isEmpty()) {
            this._expressionDirty = true;
            this._validateExpression = true;
            this._sqlExpression = string;
        }
        this.enableControls(true);
    }

    public boolean isExpressionDirty() {
        return this._expressionDirty;
    }

    public boolean isOutputColumnsDirty() {
        return this._outputColumnsDirty;
    }

    public void insertSQLExpression(String string) {
        int n;
        int n2 = this._sqlEditor.getCaretPosition();
        int n3 = this._sqlEditor.getSelectionStart();
        if (n3 < (n = this._sqlEditor.getSelectionEnd())) {
            this._sqlEditor.replaceSelection(string);
            this._sqlEditor.setCaretPosition(n3 + string.length());
        } else {
            try {
                this._sqlEditor.insertString(n2, string, null);
            }
            catch (BadLocationException badLocationException) {
                theLogger.log(Level.SEVERE, badLocationException.getLocalizedMessage(), badLocationException);
            }
            this._sqlEditor.setCaretPosition(n2 + string.length());
        }
        this._sqlEditor.requestFocusInWindow();
    }

    private void showSQLExpressionColumns() {
        this.jPreviewPanel.removeAll();
        this.jPreviewPanel.add((Component)this._viewerTabPane, "Center");
        this._viewerTabPane.setSelectedComponent(this._structureViewPane);
        if (!this._previewColumnsLoaded) {
            try {
                SQLQueryNode sQLQueryNode = (SQLQueryNode)this.getData();
                String string = null;
                string = this._hasWithClause ? this._sqlExpression : sQLQueryNode.getStackedSQL(this._sqlExpression);
                this._structureViewPane.loadTable(string);
                this._previewColumnsLoaded = true;
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("UNEXPECTED_ERROR_MSG"), null);
            }
        }
    }

    private void showSQLExpressionResult() {
        this._viewerTabPane.setSelectedComponent(this._dataViewerPane);
        if (!this._previewDataLoaded) {
            try {
                SQLQueryNode sQLQueryNode = (SQLQueryNode)this.getData();
                String string = null;
                string = this._hasWithClause ? this._sqlExpression : sQLQueryNode.getStackedSQL(this._sqlExpression);
                this._dataViewerPane.loadTable(string);
                this._previewDataLoaded = true;
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("UNEXPECTED_ERROR_MSG"), null);
            }
        }
    }

    private void showSQLExpressionError(String string) {
        this._validationResults.setEditable(false);
        this._validationResults.setLineWrap(true);
        this._validationResults.setWrapStyleWord(true);
        this._validationResults.setText(string);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this._validationResults);
        this.jPreviewPanel.removeAll();
        this.jPreviewPanel.add((Component)jScrollPane, "Center");
        if (this.jSplitPane2.getRightComponent() == null) {
            this.jSplitPane2.setRightComponent(this.jPanel2);
            int n = (int)this.jSplitPane2.getSize().getHeight() * 1 / 2;
            this.jSplitPane2.setDividerLocation(n);
        }
        this.jPreviewPanel.updateUI();
    }

    private void validateSQLExpression() throws Exception {
        this.jPreviewPanel.removeAll();
        this.jPreviewPanel.add((Component)new JPanel(), "Center");
        if (this.jSplitPane2.getRightComponent() == null) {
            this.jSplitPane2.setRightComponent(this.jPanel2);
            int n = (int)this.jSplitPane2.getSize().getHeight() * 1 / 2;
            this.jSplitPane2.setDividerLocation(n);
        }
        SQLQueryNode sQLQueryNode = (SQLQueryNode)this.getData();
        ValidateSQL validateSQL = new ValidateSQL(sQLQueryNode);
        validateSQL.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doWork() {
        if (this.isExpressionDirty() || this._bNeedValidate) {
            Object object;
            Object object2;
            Object object3;
            if (this._validateExpression) {
                boolean bl = true;
                object3 = null;
                try {
                    object2 = (SQLQueryNode)this.getData();
                    class ValidateSQLThread
                    extends ProgressRunnable {
                        SQLQueryNode _node;
                        boolean _validated = true;
                        Exception _ex = null;

                        public boolean getValidation() {
                            return this._validated;
                        }

                        public Exception getException() {
                            return this._ex;
                        }

                        public ValidateSQLThread(SQLQueryNode sQLQueryNode) {
                            this._node = sQLQueryNode;
                        }

                        protected Object doWork() throws Exception {
                            try {
                                this._node.validateSQLExpression(SQLQueryEditorPanel.this._sqlExpression, SQLQueryEditorPanel.this._columnMetaData);
                            }
                            catch (Exception exception) {
                                this._validated = false;
                                this._ex = exception;
                            }
                            return true;
                        }
                    }
                    object = new ValidateSQLThread((SQLQueryNode)object2);
                    object.setTitle(DialogsLrb.get("SQLQUERY_VALIDATE"));
                    object.setMessage(DialogsLrb.get("SQLQUERY_VALIDATE_DESC"));
                    object.setCancelable(false);
                    object.start(true);
                    bl = ((ValidateSQLThread)((Object)object)).getValidation();
                    object3 = ((ValidateSQLThread)((Object)object)).getException();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                }
                if (!bl) {
                    if (object3 instanceof SQLQueryNode.WithClauseViewOutputException) {
                        this._hasWithClause = true;
                        object2 = new CreateViewDialog(this.getContext(), this._viewName);
                        if (((CreateViewDialog)object2).invoke()) {
                            this._generateView = true;
                            this._viewName = ((CreateViewDialog)object2).getViewName();
                            bl = true;
                        } else {
                            this._generateView = false;
                            bl = true;
                        }
                    } else if (object3 instanceof SQLQueryNode.WithClauseNoInputException) {
                        this._hasWithClause = true;
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("SQLQUERY_VALIDATE_USE_OF_WITH_CLAUSE_NO_INPUT"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                    } else {
                        this._hasWithClause = false;
                        this._generateView = false;
                        if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("SQLQUERY_VALIDATE_FAILED_CONFIRM"), (String)DialogsLrb.get("WARNING_TITLE"), null)) {
                            bl = true;
                        }
                    }
                }
                if (bl) {
                    if (StringUtils.checkDataLossWithMsg(this._context.getContext(), this._sqlExpression, oracle.dmt.dataminer.workflow.dialog.build.DialogsLrb.get("ERROR_TITLE"))) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            SQLQueryNode sQLQueryNode = (SQLQueryNode)this.getData();
            object3 = (SQLQueryNodeType)sQLQueryNode.getData();
            CommandProcessor.getInstance().beginTrans(DialogsLrb.get("SQLQUERY_NODE_EDIT_TRANSACTION_NAME"));
            try {
                object2 = new ArrayList();
                object = new ComplexProperty("SQLQueryExpression", this._sqlExpression);
                ((ComplexProperty)object).setOldData(object3.getSQLQueryExpression());
                object2.add(object);
                this._outputColumnsDirty = true;
                object = new ComplexProperty("HasWithClause", this._hasWithClause);
                ((ComplexProperty)object).setOldData(object3.isHasWithClause());
                object2.add(object);
                if (!this._hasWithClause && this._generateView) {
                    this._generateView = false;
                }
                object = new ComplexProperty("GenerateView", this._generateView);
                ((ComplexProperty)object).setOldData(object3.isGenerateView());
                object2.add(object);
                object = new ComplexProperty("viewName", this._viewName);
                ((ComplexProperty)object).setOldData(object3.getViewName());
                object2.add(object);
                OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getData().getUndoFilter();
                odmrSDMUndoFilter.prepareUndoComplexPropertyList(sQLQueryNode, this.getContext(), (List<ComplexProperty>)object2);
                sQLQueryNode.validate(true);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("UNEXPECTED_ERROR_MSG"), null);
                CommandProcessor.getInstance().abortTrans();
            }
            finally {
                CommandProcessor.getInstance().endTrans();
            }
        }
        return true;
    }

    public String getSqlExpression() {
        return this._sqlExpression;
    }

    public SQLQueryOutputColumnsType getOutputColumns() {
        return this._outputColumns;
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jSourceTabbedPane = new JTabbedPane();
        this.jSplitPane2 = new JSplitPane();
        this.jSQLPanel = new JPanel();
        this.jSQLTextToolBar = new JToolBar();
        this.jValidateButton = new JButton();
        this.jUndoButton = new JButton();
        this.jRedoButton = new JButton();
        this.jSQLScrollPane = new JScrollPane();
        this.jSQLStatusPanel = new JPanel();
        this.locationLabel = new JLabel();
        this.jPanel2 = new JPanel();
        this.jPreviewToolBar = new JToolBar();
        this.jRefreshButton = new JButton();
        this.jProgressBar = new JProgressBar();
        this.jPreviewPanel = new JPanel();
        this.setPreferredSize(new Dimension(800, 600));
        this.jSplitPane1.setDividerLocation(300);
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSourceTabbedPane, -1, 300, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSourceTabbedPane, -1, 576, Short.MAX_VALUE));
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.jSplitPane2.setDividerLocation(250);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.setResizeWeight(0.5);
        this.jSplitPane2.setOneTouchExpandable(true);
        this.jSQLPanel.setLayout(new BorderLayout());
        this.jSQLTextToolBar.setRollover(true);
        this.jValidateButton.setFocusable(false);
        this.jValidateButton.setHorizontalTextPosition(0);
        this.jValidateButton.setVerticalTextPosition(3);
        this.jValidateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SQLQueryEditorPanel.this.jValidateButtonActionPerformed(actionEvent);
            }
        });
        this.jSQLTextToolBar.add(this.jValidateButton);
        this.jUndoButton.setFocusable(false);
        this.jUndoButton.setHorizontalTextPosition(0);
        this.jUndoButton.setVerticalTextPosition(3);
        this.jUndoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SQLQueryEditorPanel.this.jUndoButtonActionPerformed(actionEvent);
            }
        });
        this.jSQLTextToolBar.add(this.jUndoButton);
        this.jRedoButton.setFocusable(false);
        this.jRedoButton.setHorizontalTextPosition(0);
        this.jRedoButton.setVerticalTextPosition(3);
        this.jRedoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SQLQueryEditorPanel.this.jRedoButtonActionPerformed(actionEvent);
            }
        });
        this.jSQLTextToolBar.add(this.jRedoButton);
        this.jSQLPanel.add((Component)this.jSQLTextToolBar, "North");
        this.jSQLPanel.add((Component)this.jSQLScrollPane, "Center");
        this.jSQLStatusPanel.setLayout(new BorderLayout());
        this.locationLabel.setText("1:1");
        this.jSQLStatusPanel.add((Component)this.locationLabel, "East");
        this.jSQLPanel.add((Component)this.jSQLStatusPanel, "South");
        this.jSplitPane2.setTopComponent(this.jSQLPanel);
        this.jPanel2.setLayout(new BorderLayout());
        this.jPreviewToolBar.setRollover(true);
        this.jRefreshButton.setFocusable(false);
        this.jRefreshButton.setHorizontalTextPosition(0);
        this.jRefreshButton.setVerticalTextPosition(3);
        this.jRefreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SQLQueryEditorPanel.this.jRefreshButtonActionPerformed(actionEvent);
            }
        });
        this.jPreviewToolBar.add(this.jRefreshButton);
        this.jProgressBar.setMaximumSize(new Dimension(100, 14));
        this.jProgressBar.setPreferredSize(new Dimension(100, 14));
        this.jPreviewToolBar.add(this.jProgressBar);
        this.jPanel2.add((Component)this.jPreviewToolBar, "North");
        this.jPreviewPanel.setLayout(new BorderLayout());
        this.jPanel2.add((Component)this.jPreviewPanel, "Center");
        this.jSplitPane2.setRightComponent(this.jPanel2);
        this.jSplitPane1.setRightComponent(this.jSplitPane2);
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -1, 776, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1).addContainerGap()));
    }

    private void jValidateButtonActionPerformed(ActionEvent actionEvent) {
        try {
            this.validateSQLExpression();
        }
        catch (SQLQueryNode.WithClauseViewOutputException withClauseViewOutputException) {
            this.showSQLExpressionError(DialogsLrb.get("SQLQUERY_VALIDATE_USE_OF_WITH_CLAUSE_NO_VIEW"));
        }
        catch (SQLQueryNode.WithClauseNoInputException withClauseNoInputException) {
            this.showSQLExpressionError(DialogsLrb.get("SQLQUERY_VALIDATE_USE_OF_WITH_CLAUSE_NO_INPUT"));
        }
        catch (Exception exception) {
            this.showSQLExpressionError(exception.getLocalizedMessage());
        }
    }

    private void jUndoButtonActionPerformed(ActionEvent actionEvent) {
        try {
            this._undoManager.undo();
        }
        catch (CannotUndoException cannotUndoException) {
            theLogger.log(Level.SEVERE, cannotUndoException.getLocalizedMessage(), cannotUndoException);
        }
        this.enableControls(true);
    }

    private void jRedoButtonActionPerformed(ActionEvent actionEvent) {
        try {
            this._undoManager.redo();
        }
        catch (CannotUndoException cannotUndoException) {
            theLogger.log(Level.SEVERE, cannotUndoException.getLocalizedMessage(), cannotUndoException);
        }
        this.enableControls(true);
    }

    private void jRefreshButtonActionPerformed(ActionEvent actionEvent) {
        try {
            this.validateSQLExpression();
        }
        catch (SQLQueryNode.WithClauseViewOutputException withClauseViewOutputException) {
            this.showSQLExpressionError(DialogsLrb.get("SQLQUERY_VALIDATE_USE_OF_WITH_CLAUSE_NO_VIEW"));
        }
        catch (SQLQueryNode.WithClauseNoInputException withClauseNoInputException) {
            this.showSQLExpressionError(DialogsLrb.get("SQLQUERY_VALIDATE_USE_OF_WITH_CLAUSE_NO_INPUT"));
        }
        catch (Exception exception) {
            this.showSQLExpressionError(exception.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRScriptsAvailable() {
        String string = "select count(*) from sys.rq_scripts";
        boolean bl = false;
        Connection connection = null;
        SQLHelper sQLHelper = new SQLHelper();
        try {
            connection = Connections.getSharedConnection(this._context.getContext());
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                bl = true;
            }
        }
        catch (Exception exception) {
        }
        finally {
            sQLHelper.close();
        }
        return bl;
    }

    private String createErrorComp(Throwable throwable) {
        String string = null;
        String string2 = null;
        int n = -1;
        SQLException sQLException = null;
        if (throwable != null) {
            if (throwable instanceof SQLException) {
                sQLException = (SQLException)throwable;
            } else if (throwable.getCause() instanceof SQLException) {
                sQLException = (SQLException)throwable.getCause();
            }
            if (sQLException != null && (string2 = sQLException.getLocalizedMessage()) != null && string2.indexOf("ORA") > -1) {
                Oerr oerr = new Oerr();
                try {
                    string2 = string2 + oerr.oerr(string2);
                    Connection connection = Connections.getSharedConnection(this._context.getContext());
                    n = DBUtil.getInstance((Connection)connection).getErrorOffset(this._sqlExpression);
                }
                catch (Exception exception) {
                    theLogger.log(Level.FINEST, exception.getLocalizedMessage(), exception);
                }
            }
            if (string2 == null) {
                string2 = throwable.getLocalizedMessage();
            }
        }
        string = n < 1 ? string2 : string2 + "\n" + this.getCommandDetails(n);
        return string;
    }

    private String getCommandDetails(int n) {
        Object[] objectArray = null;
        if (n != -1) {
            int n2 = 1;
            objectArray = SQLErrorDialog.getLineAndColumn((String)this._sqlExpression, (int)n, (int)n2, (int)1);
        }
        return MessageFormat.format(Messages.getString((String)"SQLErrorDialog.10"), objectArray);
    }

    private void setLineCol() {
        int n = this._sqlEditor.getCaretPosition();
        int n2 = 1;
        int n3 = 0;
        int n4 = -1;
        String string = this._sqlEditor.getText().replaceAll("\r", "");
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != '\n') continue;
            ++n2;
            n4 = i;
        }
        n3 = n - n4;
        String string2 = DialogsLrb.get("SQLQUERY_QUERY_LINE_COL");
        String string3 = MessageFormat.format(string2, n2, n3);
        this.locationLabel.setText(string3);
    }

    private class ValidateSQL
    extends SwingWorker {
        SQLQueryNode _node;
        ArrayList<String> _textData = new ArrayList();
        ArrayList<String> _imageData = new ArrayList();
        boolean _otherData = false;
        Exception _ex;
        Boolean _success = false;

        public ValidateSQL(SQLQueryNode sQLQueryNode) {
            SQLQueryEditorPanel.this.enableControls(false);
            SQLQueryEditorPanel.this.jProgressBar.setVisible(true);
            SQLQueryEditorPanel.this.jProgressBar.setIndeterminate(true);
            SQLQueryEditorPanel.this._previewColumnsLoaded = false;
            SQLQueryEditorPanel.this._previewDataLoaded = false;
            this._node = sQLQueryNode;
        }

        private boolean getRData(String string) {
            boolean bl = false;
            try {
                InputSource inputSource = new InputSource(new StringReader(string));
                org.w3c.dom.Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputSource);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                if (document.getElementsByTagName("root") != null) {
                    Object object;
                    Object object2;
                    Object object3;
                    NodeList nodeList = document.getElementsByTagName("img");
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Element element = (Element)nodeList.item(i);
                        object3 = new DOMSource(element);
                        object2 = new StreamResult(new StringWriter());
                        transformer.transform((Source)object3, (Result)object2);
                        object = ((StreamResult)object2).getWriter().toString();
                        this._imageData.add((String)object);
                    }
                    nodeList = document.getElementsByTagName("root");
                    Element element = (Element)nodeList.item(0);
                    nodeList = element.getChildNodes();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        object3 = nodeList.item(i);
                        if (!(object3 instanceof Element) || (element = (Element)nodeList.item(i)).getTagName().equals("images") || !element.hasChildNodes()) continue;
                        object2 = new DOMSource(element);
                        object = new StreamResult(new StringWriter());
                        transformer.transform((Source)object2, (Result)object);
                        String string2 = ((StreamResult)object).getWriter().toString();
                        this._textData.add(string2);
                    }
                    bl = true;
                }
            }
            catch (Exception exception) {
                bl = false;
            }
            return bl;
        }

        private void getData(ColumnDataRow columnDataRow) throws Exception {
            Connection connection = null;
            SQLHelper sQLHelper = new SQLHelper();
            try {
                connection = Connections.getSharedConnection(SQLQueryEditorPanel.this._context.getContext());
                String string = null;
                string = SQLQueryEditorPanel.this._hasWithClause ? SQLQueryEditorPanel.this._sqlExpression : this._node.getStackedSQL(SQLQueryEditorPanel.this._sqlExpression);
                sQLHelper.pstmt = connection.prepareStatement(string);
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                while (sQLHelper.rs.next()) {
                    long l;
                    Clob clob = sQLHelper.rs.getClob(columnDataRow.getName());
                    String string2 = clob.getSubString(1L, (int)(l = clob.length()));
                    boolean bl = this.getRData(string2);
                    if (bl) continue;
                    this._otherData = true;
                }
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                sQLHelper.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doInBackground() throws Exception {
            try {
                Object object;
                SQLQueryEditorPanel.this._sqlExpression = SQLQueryEditorPanel.this._sqlExpression.trim();
                try {
                    this._node.validateSQLExpression(SQLQueryEditorPanel.this._sqlExpression, SQLQueryEditorPanel.this._columnMetaData);
                }
                catch (Exception exception) {
                    if (exception instanceof SQLQueryNode.WithClauseViewOutputException) {
                        SQLQueryEditorPanel.this._hasWithClause = true;
                        object = new CreateViewDialog(SQLQueryEditorPanel.this.getContext(), SQLQueryEditorPanel.this._viewName);
                        if (((CreateViewDialog)object).invoke()) {
                            SQLQueryEditorPanel.this._generateView = true;
                            SQLQueryEditorPanel.this._viewName = ((CreateViewDialog)object).getViewName();
                            SQLQueryEditorPanel.this._expressionDirty = true;
                        }
                        SQLQueryEditorPanel.this._generateView = false;
                        throw exception;
                    }
                    if (exception instanceof SQLQueryNode.WithClauseNoInputException) {
                        SQLQueryEditorPanel.this._hasWithClause = true;
                        throw exception;
                    }
                    throw exception;
                }
                boolean bl = false;
                if (SQLQueryEditorPanel.this._isRScriptsAvailable) {
                    for (Object object2 : object = SQLQueryEditorPanel.this._RScriptsPanel.getRQFunctions()) {
                        if (!SQLQueryEditorPanel.this._sqlExpression.toUpperCase().contains(((String)object2).toUpperCase())) continue;
                        bl = true;
                    }
                }
                for (Object object3 : SQLQueryEditorPanel.this._columnMetaData) {
                    if (((ColumnDataRow)object3).getDataType().equals("CLOB") && bl) {
                        this.getData((ColumnDataRow)object3);
                        continue;
                    }
                    this._otherData = true;
                }
                this._success = true;
            }
            catch (SQLException sQLException) {
                int n = sQLException.getLocalizedMessage().indexOf("ORA", 3);
                String string = sQLException.getLocalizedMessage();
                if (n > 0) {
                    string = sQLException.getLocalizedMessage().substring(0, n);
                }
                this._ex = new SQLException(string);
                this._success = false;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return this._success;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            super.done();
            SQLQueryEditorPanel.this._validateExpression = false;
            SQLQueryEditorPanel.this.jProgressBar.setVisible(false);
            SQLQueryEditorPanel.this.enableControls(true);
            if (!this._success.booleanValue()) {
                String string = null;
                string = this._ex instanceof SQLQueryNode.WithClauseNoInputException ? DialogsLrb.get("SQLQUERY_VALIDATE_USE_OF_WITH_CLAUSE_NO_INPUT") : (this._ex instanceof SQLQueryNode.WithClauseViewOutputException ? DialogsLrb.get("SQLQUERY_VALIDATE_USE_OF_WITH_CLAUSE_NO_VIEW") : SQLQueryEditorPanel.this.createErrorComp(this._ex));
                SQLQueryEditorPanel.this.showSQLExpressionError(string);
            } else {
                try {
                    JPanel jPanel;
                    SQLQueryEditorPanel.this._viewerTabPane.remove(SQLQueryEditorPanel.this._dataViewerPane);
                    for (ODMrXMLOutputPanel object : SQLQueryEditorPanel.this._xmlPanels) {
                        SQLQueryEditorPanel.this._viewerTabPane.remove(object);
                    }
                    SQLQueryEditorPanel.this._xmlPanels.clear();
                    for (ODMrGraphOutputPanel oDMrGraphOutputPanel : SQLQueryEditorPanel.this._GraphOutputPanels) {
                        SQLQueryEditorPanel.this._viewerTabPane.remove(oDMrGraphOutputPanel);
                    }
                    SQLQueryEditorPanel.this._GraphOutputPanels.clear();
                    if (this._otherData) {
                        SQLQueryEditorPanel.this._dataViewerPane = new DataViewerPanel(SQLQueryEditorPanel.this.getContext(), null);
                        SQLQueryEditorPanel.this._viewerTabPane.addTab(DATA_TAB, SQLQueryEditorPanel.this._dataViewerPane);
                    }
                    for (String string : this._textData) {
                        jPanel = new ODMrXMLOutputPanel(string);
                        SQLQueryEditorPanel.this._xmlPanels.add(jPanel);
                        SQLQueryEditorPanel.this._viewerTabPane.addTab(DATA_TAB, jPanel);
                    }
                    for (String string : this._imageData) {
                        jPanel = new ODMrGraphOutputPanel(string);
                        SQLQueryEditorPanel.this._GraphOutputPanels.add(jPanel);
                        SQLQueryEditorPanel.this._viewerTabPane.addTab(GRAPH_TAB, jPanel);
                    }
                    SQLQueryEditorPanel.this.showSQLExpressionColumns();
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("UNEXPECTED_ERROR_MSG"), null);
                }
            }
        }

        public Exception getException() {
            return this._ex;
        }

        public Boolean getSuccess() {
            return this._success;
        }
    }
}

