/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.test;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.share.nls.StringUtils;
import oracle.dmt.dataminer.controls.BaseCostMatrixDataProvider;
import oracle.dmt.dataminer.controls.BaseCostMatrixTable;
import oracle.dmt.dataminer.controls.BaseCostMatrixTableModel;
import oracle.dmt.dataminer.controls.CostMatrixInfo;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.renderers.ColorCellRenderer;
import oracle.dmt.dataminer.controls.renderers.DateCellRenderer2;
import oracle.dmt.dataminer.controls.renderers.NumberCellRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.workflow.dialog.AbstractPropertiesDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.model.ModelPropertiesState;
import oracle.dmt.dataminer.workflow.dialog.test.CostBenefitDetailDialog;
import oracle.dmt.dataminer.workflow.dialog.test.CostBenefitTabState;
import oracle.dmt.dataminer.workflow.dialog.test.CostMatrixDetailDialog;
import oracle.dmt.dataminer.workflow.dialog.test.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.test.TuneState;
import oracle.dmt.dataminer.workflow.xmlschema.CostMatrixType;
import oracle.dmt.dataminer.workflow.xmlschema.ROCAccuracyType;
import oracle.dmt.dataminer.workflow.xmlschema.TuningType;
import oracle.dmt.dataminer.workflow.xmlschema.WeightsType;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericTable;

public class CostBenefitTabPanel
extends AbstractPropertiesDialogPanel {
    private static Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private NumberFormat _percentageFormat = NumericFormat.getInstance(true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel(), 0, 0);
    private DataMinerTablePanel dataMinerTablePanel;
    private JButton jBtnApply;
    private JButton jClearButton;
    private JComboBox jCmbBoxTarget;
    private JButton jCostMatrixBtn;
    private JPanel jCostMatrixPanel;
    private JLabel jLabel7;
    private JLabel jLabelTitle;
    private JLabel jLblTable;
    private JLabel jLblTarget;
    private JLabel jLblWeight;
    private JLabel jMatrixLbl1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPaneDescription;
    private JScrollPane jScrollPaneTable;
    private JSeparator jSeparator1;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JButton jTuneBtn;
    private JLabel jTuneCriteriaLabel;
    private JLabel jTuneCriteriaValue;
    private GenericTable jTuneMatrixTable;
    private JLabel jTuneMethodLabel;
    private JLabel jTuneMethodValue;
    private JLabel jTuneSettingsLabel;
    private JLabel jTuneTargetLabel;
    private JLabel jTuneTargetValue;
    private JLabel jTuneThresholdLabel;
    private JLabel jTuneThresholdValue;
    private JTextField jTxtFldWeight;
    private GenericTable niceTableCosts;
    private JMultiLineLabel _jDescription = new JMultiLineLabel();

    public CostBenefitTabPanel(TraversableContext traversableContext) {
        super(traversableContext);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void initRes() {
        this.jLabelTitle.setText(oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb.get("COST_BENEFIT_DIALOG_DETAILED_DESCRIPTION"));
        this._jDescription.setText(oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb.get("COST_BENEFIT_WEIGHTING_DESCRIPTION"));
        this.jScrollPaneDescription.getViewport().add((Component)this._jDescription);
        ResourceUtils.resLabel((JLabel)this.jLblTable, (Component)this.niceTableCosts, (String)oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb.get("COST_BENEFIT_MATRIX_TARGET_TABLE_TITLE"));
        ResourceUtils.resLabel((JLabel)this.jLblTarget, (Component)this.jCmbBoxTarget, (String)oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb.get("COST_MATRIX_MATRIX_TARGET"));
        ResourceUtils.resLabel((JLabel)this.jLblWeight, (Component)this.jTxtFldWeight, (String)oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb.get("COST_BENEFIT_DIALOG_BENEFIT_LBL"));
        this.setDataType(this.jTxtFldWeight, Double.class);
        this.setSigned(this.jTxtFldWeight, true);
        this.setNumber(this.jTxtFldWeight, ModelPropertiesState.DEFAULT_BENEFIT);
        this.jBtnApply.setText(oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb.get("COST_MATRIX_WEIGHT_APPLY"));
        ResourceUtils.resButton((AbstractButton)this.jTuneBtn, (String)DialogsLrb.get("TUNE_COMMON_TUNE"));
        this.jTuneBtn.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_TUNE")));
        this.jTuneBtn.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_TUNE_ADA"));
        this.jTuneSettingsLabel.setText(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_TUNE_SETTINGS")));
        this.jTuneSettingsLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_TUNE_SETTINGS")));
        ResourceUtils.resButton((AbstractButton)this.jClearButton, (String)DialogsLrb.get("TUNE_COMMON_CLEAR"));
        this.jClearButton.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_CLEAR")));
        this.jClearButton.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_CLEAR_ADA"));
        ResourceUtils.resLabel((JLabel)this.jTuneMethodLabel, (Component)this.jTuneMethodValue, (String)StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_METHOD")));
        this.jTuneMethodLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_METHOD")));
        this.jTuneMethodLabel.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_METHOD_ADA"));
        ResourceUtils.resLabel((JLabel)this.jTuneTargetLabel, (Component)this.jTuneTargetValue, (String)StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_TARGET")));
        this.jTuneTargetLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_TARGET")));
        this.jTuneTargetLabel.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_TARGET_ADA"));
        ResourceUtils.resLabel((JLabel)this.jTuneCriteriaLabel, (Component)this.jTuneCriteriaValue, (String)StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_CRITERIA")));
        this.jTuneCriteriaLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_CRITERIA")));
        this.jTuneCriteriaLabel.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_CRITERIA_ADA"));
        ResourceUtils.resLabel((JLabel)this.jTuneThresholdLabel, (Component)this.jTuneThresholdValue, (String)StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_THRESHOLD")));
        this.jTuneThresholdLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_THRESHOLD")));
        this.jTuneThresholdLabel.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_THRESHOLD_ADA"));
        ResourceUtils.resLabel((JLabel)this.jMatrixLbl1, (Component)this.jTuneMatrixTable, (String)StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_DERIVED_COST_MATRIX")));
        this.jMatrixLbl1.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DialogsLrb.get("TUNE_COMMON_DERIVED_COST_MATRIX")));
        this.jMatrixLbl1.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_DERIVED_COST_MATRIX")));
        this.jMatrixLbl1.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_DERIVED_COST_MATRIX_ADA"));
    }

    public void initUI() {
        this.jTuneMethodValue.setText(TuneState.TUNE_OPTION_NONE);
        this.initializeControls();
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    private void enableControls(boolean bl) {
        boolean bl2;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = bl2 = this.dataMinerTablePanel.getTable().getSelectedRowCount() > 0;
        if (bl2) {
            String string = this.getPanelState().getShareState().getSelectTestResult();
            bl3 = this.getPanelState().isTuningCustom(string);
            bl5 = this.getPanelState().isTuningBenefit(string);
            bl4 = this.getPanelState().isTuningCost(string);
        }
        this.jClearButton.setEnabled(bl && bl2 && (bl3 || bl4 || bl5));
        this.jTuneBtn.setEnabled(bl && bl2);
        this.jTuneTargetLabel.setVisible(bl && bl3);
        this.jTuneTargetValue.setVisible(bl && bl3);
        this.jTuneThresholdLabel.setVisible(bl && bl3);
        this.jTuneThresholdValue.setVisible(bl && bl3);
        this.jTuneCriteriaLabel.setVisible(bl && bl3);
        this.jTuneCriteriaValue.setVisible(bl && bl3);
        this.jMatrixLbl1.setVisible(bl && (bl3 || bl4 || bl5));
        this.jCostMatrixBtn.setVisible(bl && (bl4 || bl5));
        this.jScrollPane2.setVisible(bl && bl3);
        this.jTuneMatrixTable.setVisible(bl && bl3);
        this.jLabel7.setVisible(bl && bl3);
    }

    private void initializeControls() {
        this.dataMinerTablePanel.removeSearchField();
        this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)this.getPanelState().getBenefitState().getLoadingBenefitTableModel()));
        this.dataMinerTablePanel.getTable().setSelectionMode(0);
        this.jCmbBoxTarget.setModel(new DefaultComboBoxModel<String>(new String[]{"Loading..."}));
        ListSelectionModel listSelectionModel = this.dataMinerTablePanel.getTable().getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CostBenefitTabPanel.this.jResultTableValueChanged(listSelectionEvent);
            }
        });
        this.enableControls(false);
    }

    public void jResultTableValueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (!listSelectionModel.isSelectionEmpty()) {
            int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
            String string = (String)this.getPanelState().getBenefitState().getBenefitTuneTableModel().getValueAt(nArray[0], 0);
            this.getPanelState().getShareState().setSelectTestResult(string);
            this.loadTuneMatrix();
            this.enableControls(true);
        }
    }

    protected final TuneState getPanelState() {
        return (TuneState)super.getDialogState();
    }

    @Override
    public void tabSelected() {
        if (this.getPanelState().getBenefitState().getBenefitTuneTableModel() == null) {
            return;
        }
        String string = this.getPanelState().getShareState().getSelectTestResult();
        if (string != null) {
            int n = 0;
            for (int i = 0; i < this.dataMinerTablePanel.getTable().getRowCount(); ++i) {
                Object object = this.getPanelState().getBenefitState().getBenefitTuneTableModel().getValueAt(i, 0);
                if (!string.equals(object)) continue;
                n = i;
                break;
            }
            this.dataMinerTablePanel.getTable().setRowSelectionInterval(n, n);
        }
        this.loadTuneMatrix();
        this.enableControls(true);
    }

    @Override
    public void processInput() {
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane2 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jLabelTitle = new JLabel();
        this.jLblTarget = new JLabel();
        this.jCmbBoxTarget = new JComboBox();
        this.jScrollPaneDescription = new JScrollPane();
        this.jLblTable = new JLabel();
        this.jScrollPaneTable = new JScrollPane();
        this.niceTableCosts = new BaseCostMatrixTable();
        this.jLblWeight = new JLabel();
        this.jTxtFldWeight = new NumberTextField();
        this.jBtnApply = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jCostMatrixPanel = new JPanel();
        this.jTuneBtn = new JButton();
        this.jTuneSettingsLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jClearButton = new JButton();
        this.jTuneMethodLabel = new JLabel();
        this.jTuneMethodValue = new JLabel();
        this.jTuneTargetLabel = new JLabel();
        this.jTuneTargetValue = new JLabel();
        this.jTuneCriteriaLabel = new JLabel();
        this.jTuneCriteriaValue = new JLabel();
        this.jTuneThresholdLabel = new JLabel();
        this.jTuneThresholdValue = new JLabel();
        this.jMatrixLbl1 = new JLabel();
        this.jCostMatrixBtn = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTuneMatrixTable = new BaseCostMatrixTable();
        this.jLabel7 = new JLabel();
        this.dataMinerTablePanel = new DataMinerTablePanel();
        this.setMinimumSize(new Dimension(750, 490));
        this.setPreferredSize(new Dimension(750, 490));
        this.jSplitPane1.setDividerLocation(380);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setName("jSplitPane1");
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jSplitPane2.setDividerLocation(450);
        this.jSplitPane2.setName("jSplitPane2");
        this.jSplitPane2.setOneTouchExpandable(true);
        this.jPanel1.setName("jPanel1");
        this.jLabelTitle.setText("Use this screen to define costs for your target values for scoring purposes.");
        this.jLabelTitle.setName("jLabelTitle");
        this.jLblTarget.setText("Target:");
        this.jLblTarget.setName("jLblTarget");
        this.jCmbBoxTarget.setName("jCmbBoxTarget");
        this.jCmbBoxTarget.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CostBenefitTabPanel.this.jCmbBoxTargetActionPerformed(actionEvent);
            }
        });
        this.jScrollPaneDescription.setBorder(null);
        this.jScrollPaneDescription.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneDescription.setVerticalScrollBarPolicy(21);
        this.jScrollPaneDescription.setName("jScrollPaneDescription");
        this.jLblTable.setText("Cost Benefit  Weights:");
        this.jLblTable.setName("jLblTable");
        this.jScrollPaneTable.setName("jScrollPaneTable");
        this.niceTableCosts.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[0]));
        this.niceTableCosts.setName("niceTableCosts");
        this.jScrollPaneTable.setViewportView((Component)this.niceTableCosts);
        this.jLblWeight.setText("Weight:");
        this.jLblWeight.setName("jLblWeight");
        this.jTxtFldWeight.setName("jTxtFldWeight");
        this.jBtnApply.setText("Apply");
        this.jBtnApply.setName("jBtnApply");
        this.jBtnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CostBenefitTabPanel.this.jBtnApplyActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneDescription, -1, 429, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLblTable, -2, 123, -2).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLblWeight).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTxtFldWeight, -2, 82, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jBtnApply)).addComponent(this.jLabelTitle, -1, 429, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLblTarget).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCmbBoxTarget, 0, 389, Short.MAX_VALUE)))).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneTable, -1, 429, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelTitle).addGap(9, 9, 9).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblTarget).addComponent(this.jCmbBoxTarget, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneDescription, -2, 42, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblWeight).addComponent(this.jTxtFldWeight, -2, -1, -2).addComponent(this.jBtnApply)).addGap(20, 20, 20).addComponent(this.jLblTable).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneTable, -1, 190, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane2.setLeftComponent(this.jPanel1);
        this.jScrollPane1.setName("jScrollPane1");
        this.jCostMatrixPanel.setName("jCostMatrixPanel");
        this.jTuneBtn.setText("Tune");
        this.jTuneBtn.setName("jTuneBtn");
        this.jTuneBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CostBenefitTabPanel.this.jTuneBtnActionPerformed(actionEvent);
            }
        });
        this.jTuneSettingsLabel.setText("Tune Settings");
        this.jTuneSettingsLabel.setName("jTuneSettingsLabel");
        this.jSeparator1.setName("jSeparator1");
        this.jClearButton.setText("Clear");
        this.jClearButton.setName("jClearButton");
        this.jClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CostBenefitTabPanel.this.jClearButtonActionPerformed(actionEvent);
            }
        });
        this.jTuneMethodLabel.setText("Method:");
        this.jTuneMethodLabel.setName("jTuneMethodLabel");
        this.jTuneMethodValue.setText("ROC");
        this.jTuneMethodValue.setName("jTuneMethodValue");
        this.jTuneTargetLabel.setText("Target Value:");
        this.jTuneTargetLabel.setName("jTuneTargetLabel");
        this.jTuneTargetValue.setText("1");
        this.jTuneTargetValue.setName("jTuneTargetValue");
        this.jTuneCriteriaLabel.setText("Criteria:");
        this.jTuneCriteriaLabel.setName("jTuneCriteriaLabel");
        this.jTuneCriteriaValue.setText("Average Accuracy");
        this.jTuneCriteriaValue.setName("jTuneCriteriaValue");
        this.jTuneThresholdLabel.setText("Threshold:");
        this.jTuneThresholdLabel.setName("jTuneThresholdLabel");
        this.jTuneThresholdValue.setText("0.56789");
        this.jTuneThresholdValue.setName("jTuneThresholdValue");
        this.jMatrixLbl1.setText("Derived Cost Matrix:");
        this.jMatrixLbl1.setName("jMatrixLbl1");
        this.jCostMatrixBtn.setText("View...");
        this.jCostMatrixBtn.setName("jCostMatrixBtn");
        this.jCostMatrixBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CostBenefitTabPanel.this.jCostMatrixBtnActionPerformed(actionEvent);
            }
        });
        this.jScrollPane2.setName("jScrollPane2");
        this.jTuneMatrixTable.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3"}));
        this.jTuneMatrixTable.setName("jTuneMatrixTable");
        this.jTuneMatrixTable.setRowSelectionAllowed(false);
        this.jScrollPane2.setViewportView((Component)this.jTuneMatrixTable);
        this.jLabel7.setText("Rows: Actual; Columns: Predicted");
        this.jLabel7.setName("jLabel7");
        GroupLayout groupLayout2 = new GroupLayout(this.jCostMatrixPanel);
        this.jCostMatrixPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE).addContainerGap()).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSeparator1, GroupLayout.Alignment.LEADING, -1, 235, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jClearButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTuneBtn)).addComponent(this.jTuneSettingsLabel, GroupLayout.Alignment.LEADING).addComponent(this.jTuneMethodLabel, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, groupLayout2.createSequentialGroup().addGap(71, 71, 71).addComponent(this.jTuneMethodValue)).addGroup(GroupLayout.Alignment.LEADING, groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTuneThresholdLabel).addComponent(this.jTuneTargetLabel).addComponent(this.jTuneCriteriaLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTuneTargetValue).addComponent(this.jTuneCriteriaValue).addComponent(this.jTuneThresholdValue))).addComponent(this.jLabel7, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, groupLayout2.createSequentialGroup().addComponent(this.jMatrixLbl1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCostMatrixBtn))).addContainerGap(45, Short.MAX_VALUE)))));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(43, 43, 43).addComponent(this.jTuneSettingsLabel)).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneBtn).addComponent(this.jClearButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneMethodLabel).addComponent(this.jTuneMethodValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneTargetLabel).addComponent(this.jTuneTargetValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneCriteriaLabel).addComponent(this.jTuneCriteriaValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneThresholdLabel).addComponent(this.jTuneThresholdValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMatrixLbl1).addComponent(this.jCostMatrixBtn)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 64, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addContainerGap(92, Short.MAX_VALUE)));
        this.jScrollPane1.setViewportView(this.jCostMatrixPanel);
        this.jSplitPane2.setRightComponent(this.jScrollPane1);
        this.jSplitPane1.setTopComponent(this.jSplitPane2);
        this.dataMinerTablePanel.setName("dataMinerTablePanel");
        this.jSplitPane1.setRightComponent(this.dataMinerTablePanel);
        GroupLayout groupLayout3 = new GroupLayout(this);
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 490, Short.MAX_VALUE));
    }

    private void jTuneBtnActionPerformed(ActionEvent actionEvent) {
        String string = this.getPanelState().getShareState().getSelectTestResult();
        WeightsType weightsType = this.getPanelState().getBenefitState().setTuneBenefitWeight(string);
        this.getPanelState().setTuningBenefit(string, weightsType);
        int n = this.dataMinerTablePanel.getTable().getSelectedRow();
        this.dataMinerTablePanel.getTable().tableChanged(new TableModelEvent(this.dataMinerTablePanel.getTable().getModel()));
        this.dataMinerTablePanel.getTable().setRowSelectionInterval(n, n);
        this.loadTuneMatrix();
        this.enableControls(true);
    }

    private void jClearButtonActionPerformed(ActionEvent actionEvent) {
        String string = this.getPanelState().getShareState().getSelectTestResult();
        this.getPanelState().setTuningNone(string);
        int n = this.dataMinerTablePanel.getTable().getSelectedRow();
        this.dataMinerTablePanel.getTable().tableChanged(new TableModelEvent(this.dataMinerTablePanel.getTable().getModel()));
        this.dataMinerTablePanel.getTable().setRowSelectionInterval(n, n);
        this.loadTuneMatrix();
        this.enableControls(true);
    }

    private void jCmbBoxTargetActionPerformed(ActionEvent actionEvent) {
        Object object = this.jCmbBoxTarget.getSelectedItem();
        this.getPanelState().getBenefitState().setSelectedTargetValue(object);
    }

    private void jBtnApplyActionPerformed(ActionEvent actionEvent) {
        String string = this.getPanelState().getBenefitState().getSelectedTargetValue().toString();
        this.getPanelState().getBenefitState().setBenefitWeight(string, Double.parseDouble(this.getNumber(this.jTxtFldWeight).toString()));
        this.niceTableCosts.tableChanged(new TableModelEvent(this.niceTableCosts.getModel()));
    }

    private void jCostMatrixBtnActionPerformed(ActionEvent actionEvent) {
        boolean bl;
        String string = this.getPanelState().getShareState().getSelectTestResult();
        boolean bl2 = this.getPanelState().getBenefitState().getTuneBenefitWeight(string) != null;
        boolean bl3 = bl = this.getPanelState().getCostState().getTuneCostMatrix(string) != null;
        if (bl2) {
            WeightsType weightsType = this.getPanelState().getBenefitState().getTuneBenefitWeight(string);
            CostBenefitDetailDialog costBenefitDetailDialog = new CostBenefitDetailDialog(weightsType);
            costBenefitDetailDialog.invoke();
        } else if (bl) {
            CostMatrixInfo costMatrixInfo = this.getPanelState().getCostState().getTuneCostMatrixInfo(string);
            CostMatrixDetailDialog costMatrixDetailDialog = new CostMatrixDetailDialog(costMatrixInfo);
            costMatrixDetailDialog.invoke();
        }
    }

    private void loadTuneMatrix() {
        String string = this.getPanelState().getShareState().getSelectTestResult();
        if (this.getPanelState().isTuningNone(string)) {
            this.jTuneMethodValue.setText(TuneState.TUNE_OPTION_NONE);
        } else if (this.getPanelState().isTuningBenefit(string)) {
            this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_BENEFIT);
        } else if (this.getPanelState().isTuningCost(string)) {
            this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_COST);
        } else if (this.getPanelState().isTuningCustom(string)) {
            String string2 = null;
            TuneState.TuningCustomData tuningCustomData = this.getPanelState().getTuningCustomData(string);
            String string3 = tuningCustomData.getTargetValue();
            Vector<Object> vector = this.getPanelState().getModelTargetValues();
            this.jTuneTargetValue.setText(string3);
            Object object = tuningCustomData.getTuneType();
            CostMatrixType costMatrixType = tuningCustomData.getCostMatrix();
            if (object instanceof TuningType.Custom.Settings.ROC) {
                TuningType.Custom.Settings.ROC rOC = (TuningType.Custom.Settings.ROC)object;
                this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_ROC);
                ROCAccuracyType rOCAccuracyType = rOC.getAccuracy();
                if (rOCAccuracyType == ROCAccuracyType.CUSTOM_ACCURACY) {
                    TuningType.Custom.Settings.ROC.CustomThreshold customThreshold = rOC.getCustomThreshold();
                    String string4 = customThreshold.getType().value();
                    this.jTuneCriteriaValue.setText(rOCAccuracyType.value() + ", " + string4 + ": " + this._percentageFormat.format(customThreshold.getValue()));
                } else {
                    this.jTuneCriteriaValue.setText(rOCAccuracyType.value());
                }
                this.jTuneThresholdValue.setText(this._percentageFormat.format(rOC.getThreshold()));
            } else if (object instanceof TuningType.Custom.Settings.Lift) {
                TuningType.Custom.Settings.Lift lift = (TuningType.Custom.Settings.Lift)object;
                this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_LIFT);
                String string5 = lift.getType().value();
                this.jTuneCriteriaValue.setText("Quantile: " + lift.getQuantile() + " (" + string5 + ")");
                this.jTuneThresholdValue.setText(this._percentageFormat.format(lift.getThreshold()));
            } else if (object instanceof TuningType.Custom.Settings.Profit) {
                TuningType.Custom.Settings.Profit profit = (TuningType.Custom.Settings.Profit)object;
                this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_PROFIT);
                this.jTuneCriteriaValue.setText("Population: " + this._percentageFormat.format(profit.getPopulation()) + "%, ROI: " + this._percentageFormat.format(profit.getROI()) + "%");
                this.jTuneThresholdValue.setText(this._percentageFormat.format(profit.getProfit()));
            }
            string2 = vector.size() == 2 ? (string3.compareTo(vector.firstElement().toString()) == 0 ? vector.lastElement().toString() : vector.firstElement().toString()) : TestViewerLrb.get("OTHER_TARGETS");
            ((BaseCostMatrixTable)this.jTuneMatrixTable).setModel(new TuneState.MatrixModel(new TuneState.TuneMatrixDataProvider(string3, string2, costMatrixType, this._percentageFormat)));
        }
    }

    class MatrixModel
    extends BaseCostMatrixTableModel {
        public MatrixModel(BaseCostMatrixDataProvider baseCostMatrixDataProvider) {
            super(baseCostMatrixDataProvider);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return super.getValueAt(n, n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }
    }

    private class TuneMatrixDataProvider
    implements BaseCostMatrixDataProvider {
        private String _positiveTarget;
        private String _otherTarget;
        private double _truePositiveCost = 0.0;
        private double _falseNegativeCost;
        private double _falsePositiveCost = 1.0;
        private double _trueNegativeCost = 0.0;

        TuneMatrixDataProvider(String string, String string2, CostMatrixType costMatrixType) {
            this._positiveTarget = string;
            this._otherTarget = string2;
            List list = costMatrixType.getItem();
            for (CostMatrixType.Item item : list) {
                String string3 = item.getActual();
                String string4 = item.getPredict();
                double d = item.getCost();
                if (string3.compareTo(string) != 0 || string4.compareTo(string) == 0) continue;
                this._falseNegativeCost = d;
                break;
            }
        }

        @Override
        public Object[] getTargetValues() {
            return new Object[]{this._positiveTarget, this._otherTarget};
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n == 0 && n2 == 0) {
                return CostBenefitTabPanel.this._percentageFormat.format(this._truePositiveCost);
            }
            if (n == 0 && n2 == 1) {
                return CostBenefitTabPanel.this._percentageFormat.format(this._falseNegativeCost);
            }
            if (n == 1 && n2 == 0) {
                return CostBenefitTabPanel.this._percentageFormat.format(this._falsePositiveCost);
            }
            if (n == 1 && n2 == 1) {
                return CostBenefitTabPanel.this._percentageFormat.format(this._trueNegativeCost);
            }
            return "Undefined";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;

        protected Object doInBackground() throws Exception {
            try {
                CostBenefitTabPanel.this.getPanelState().getBenefitState().load();
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return CostBenefitTabPanel.this.getPanelState().getBenefitState();
        }

        @Override
        protected void done() {
            super.done();
            try {
                if (this._success && this._ex == null) {
                    String string = CostBenefitTabPanel.this.getPanelState().getShareState().getSelectTestResult();
                    CostBenefitTabPanel.this.niceTableCosts.setModel((TableModel)((Object)new CostBenefitTabState.WeightSettingsModel(CostBenefitTabPanel.this.getPanelState().getBenefitState().getBenefitWeight())));
                    CostBenefitTabPanel.this.niceTableCosts.setShowToolTips(true);
                    CostBenefitTabPanel.this.niceTableCosts.setSorted(true);
                    CostBenefitTabPanel.this.niceTableCosts.setUpdateSelectionOnSort(true);
                    CostBenefitTabPanel.this.niceTableCosts.setRowSelectionAllowed(true);
                    CostBenefitTabPanel.this.niceTableCosts.setColumnSelectionAllowed(false);
                    CostBenefitTabPanel.this.niceTableCosts.setAutoResizeMode(0);
                    CostBenefitTabPanel.this.niceTableCosts.autoSizeColumnsToFit();
                    NumberCellRenderer numberCellRenderer = new NumberCellRenderer();
                    TableColumn tableColumn = CostBenefitTabPanel.this.niceTableCosts.getColumnModel().getColumn(1);
                    tableColumn.setCellRenderer(numberCellRenderer);
                    CostBenefitTabPanel.this.dataMinerTablePanel.getTable().setFixedColumns(1, 175);
                    CostBenefitTabPanel.this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)CostBenefitTabPanel.this.getPanelState().getBenefitState().getBenefitTuneTableModel()));
                    CostBenefitTabPanel.this.dataMinerTablePanel.getTable().setColumnSelectorAvailable(true);
                    CostBenefitTabPanel.this.dataMinerTablePanel.getTable().setSorted(true);
                    TableColumnModel tableColumnModel = CostBenefitTabPanel.this.dataMinerTablePanel.getTable().getFullColumnModel();
                    ColorCellRenderer colorCellRenderer = new ColorCellRenderer(new ColorCellRenderer.ColorChooser(){

                        @Override
                        public Color getColorFor(Object object) {
                            String string = (String)object;
                            return CostBenefitTabPanel.this.getPanelState().getBenefitState().getParentTestViewerState().getTestResultGraphColor(string);
                        }
                    });
                    tableColumnModel.getColumn(0).setCellRenderer(colorCellRenderer);
                    tableColumnModel.getColumn(3).setCellRenderer(new DateCellRenderer2());
                    tableColumnModel.getColumn(1).setPreferredWidth(90);
                    tableColumnModel.getColumn(2).setPreferredWidth(150);
                    tableColumnModel.getColumn(3).setPreferredWidth(200);
                    int n = 0;
                    if (string != null) {
                        for (int i = 0; i < CostBenefitTabPanel.this.dataMinerTablePanel.getTable().getRowCount(); ++i) {
                            Object object = CostBenefitTabPanel.this.getPanelState().getBenefitState().getBenefitTuneTableModel().getValueAt(i, 0);
                            if (!string.equals(object)) continue;
                            n = i;
                            break;
                        }
                        CostBenefitTabPanel.this.dataMinerTablePanel.getTable().setRowSelectionInterval(n, n);
                    }
                    CostBenefitTabPanel.this.jCmbBoxTarget.setModel(new DefaultComboBoxModel<Object>(CostBenefitTabPanel.this.getPanelState().getBenefitState().getTargetValues()));
                } else if (this._ex != null) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
                } else {
                    MessageDialog.error((Component)Ide.getMainWindow(), null, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"));
                }
                CostBenefitTabPanel.this.enableControls(true);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
            }
        }
    }
}

