/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.test;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.test.TuneState;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.xmlschema.CostMatrixType;
import oracle.dmt.dataminer.workflow.xmlschema.WeightsType;
import oracle.ide.Context;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class CostBenefitTabState {
    private SharedTestEditorState _parentTestViewerState;
    private Context _context;
    private List<TestResult> _testResults;
    private Vector<Object> _targetValues;
    private Object _selectedTargetValue;
    private String _selectedTestResult;
    private WeightsType _weights;
    private TreeMap<String, BenefitData> _benefitdata;
    private BenefitTuneTableModel _benefitTableModel;

    public SharedTestEditorState getParentTestViewerState() {
        return this._parentTestViewerState;
    }

    public CostBenefitTabState(SharedTestEditorState sharedTestEditorState, Context context) {
        this._parentTestViewerState = sharedTestEditorState;
        this._context = context;
        this._targetValues = new Vector();
        this._benefitdata = new TreeMap();
        this._benefitTableModel = null;
        this._testResults = this._parentTestViewerState.getTestResults();
    }

    public void load() throws Exception {
        TuneState tuneState = (TuneState)this._context.getProperty("TUNE_STATE");
        this._targetValues.clear();
        this._testResults = this._parentTestViewerState.getTestResults();
        for (TestResult testResult : this._testResults) {
            Vector<String> vector = ((ClassTestResult)testResult).getTargetValues();
            for (String string : vector) {
                if (this._targetValues.contains(string)) continue;
                this._targetValues.add(string);
            }
        }
        if (this._targetValues == null || this._targetValues.size() == 0) {
            this._targetValues = tuneState.getModelTargetValues();
        }
        if (this._targetValues == null || this._targetValues.size() == 0) {
            this._targetValues = tuneState.getInputDataTargetValues();
        }
        this.setSelectedTargetValue(this._targetValues.get(0));
        this._weights = tuneState.getDefaultTuningBenefit();
        this.loadBenefitData();
    }

    private void loadBenefitData() throws Exception {
        TuneState tuneState = (TuneState)this._context.getProperty("TUNE_STATE");
        for (TestResult testResult : this._testResults) {
            String string = testResult.getName();
            WeightsType weightsType = tuneState.getTuningBenefit(string);
            BenefitData benefitData = new BenefitData(testResult.getMiningAlgorithm(), testResult.getCreationTime(), weightsType);
            this._benefitdata.put(string, benefitData);
        }
        this._benefitTableModel = new BenefitTuneTableModel(tuneState, this._benefitdata);
    }

    public void setSelectedTargetValue(Object object) {
        this._selectedTargetValue = object;
    }

    public Object getSelectedTargetValue() {
        return this._selectedTargetValue;
    }

    public BenefitTuneTableModel getLoadingBenefitTableModel() {
        return new BenefitTuneTableModel();
    }

    public BenefitTuneTableModel getBenefitTuneTableModel() {
        return this._benefitTableModel;
    }

    public Vector<Object> getTargetValues() {
        return this._targetValues;
    }

    public void setSelectedTestResult(String string) {
        this._selectedTestResult = string;
    }

    public String getSelectedTestResult() {
        return this._selectedTestResult;
    }

    public Context getContext() {
        return this._context;
    }

    public TestResult getSelectedTestResultObj() {
        for (TestResult testResult : this._testResults) {
            if (!testResult.getName().equals(this.getSelectedTestResult())) continue;
            return testResult;
        }
        return null;
    }

    public void setBenefitWeight(String string, double d) {
        for (WeightsType.Item item : this._weights.getItem()) {
            if (item.getTargetValue().compareTo(string) != 0) continue;
            item.setWeight(d);
            break;
        }
    }

    public WeightsType getBenefitWeight() {
        return this._weights;
    }

    public WeightsType setTuneBenefitWeight(String string) {
        WeightsType weightsType = (WeightsType)MetaDataHelper.copyMetadataObject(this._weights);
        BenefitData benefitData = this._benefitdata.get(string);
        benefitData.setWeights(weightsType);
        benefitData.setModified(true);
        return weightsType;
    }

    public WeightsType getTuneBenefitWeight(String string) {
        BenefitData benefitData = this._benefitdata.get(string);
        WeightsType weightsType = benefitData.getWeights();
        return weightsType;
    }

    public CostMatrixType getTuneCostMatrix(String string) {
        CostMatrixType costMatrixType = new CostMatrixType();
        BenefitData benefitData = this._benefitdata.get(string);
        WeightsType weightsType = benefitData.getWeights();
        int n = this._targetValues.size();
        for (int i = 0; i < n; ++i) {
            String string2 = this._targetValues.get(i).toString();
            for (int j = 0; j < n; ++j) {
                String string3 = this._targetValues.get(j).toString();
                CostMatrixType.Item item = new CostMatrixType.Item();
                item.setActual(string2);
                item.setPredict(string3);
                if (i == j) {
                    for (WeightsType.Item item2 : weightsType.getItem()) {
                        if (item2.getTargetValue().compareTo(string2) != 0) continue;
                        item.setCost(item2.getWeight());
                        break;
                    }
                } else {
                    item.setCost(0.0);
                }
                costMatrixType.getItem().add(item);
            }
        }
        return costMatrixType;
    }

    public class BenefitTuneTableModel
    extends GenericBaseTableModel {
        public static final int RESULT_NAME = 0;
        public static final int TUNE = 1;
        public static final int ALGORITHM = 2;
        public static final int CREATION_DATE = 3;
        protected Vector<String> _colNames;
        protected Map<String, BenefitData> _benefitdata = null;
        private TuneState _tuneState;
        private final String LOADING = TestViewerLrb.get("LOADING");
        private String TUNE_NONE = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_NONE");
        private String TUNE_BENEFIT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_BENEFIT");
        private String TUNE_COST = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_COST");
        private String TUNE_ROC = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_ROC");
        private String TUNE_LIFT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_LIFT");
        private String TUNE_PROFIT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_PROFIT");

        public BenefitTuneTableModel() {
            this(null, null);
        }

        public BenefitTuneTableModel(TuneState tuneState, Map<String, BenefitData> map) {
            this._colNames = new Vector();
            this._colNames.add(TestViewerLrb.get("RESULT_NAME"));
            this._colNames.add(PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE"));
            this._colNames.add(TestViewerLrb.get("ALGORITHM"));
            this._colNames.add(TestViewerLrb.get("CREATION_DATE"));
            this.setColumnIdentifiers(this._colNames);
            this._benefitdata = map;
            this.setRowCount(this._benefitdata == null ? 1 : map.size());
            this.setColumnCount(this._colNames.size());
            this._tuneState = tuneState;
        }

        public String getColumnName(int n) {
            return this._colNames.get(n);
        }

        public Class getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return this.getValueAt(0, n).getClass();
            }
            return String.class;
        }

        public Object getValueAt(int n, int n2) {
            if (this._benefitdata == null) {
                if (n2 == 0) {
                    return this.LOADING;
                }
                return null;
            }
            Object[] objectArray = this._benefitdata.keySet().toArray();
            String string = (String)objectArray[n];
            BenefitData benefitData = this._benefitdata.get(objectArray[n]);
            if (n2 == 0) {
                return string;
            }
            if (n2 == 2) {
                return benefitData._algorithm;
            }
            if (n2 == 3) {
                return benefitData._creation_date;
            }
            if (n2 == 1) {
                if (this._tuneState.isTuningNone(string)) {
                    return this.TUNE_NONE;
                }
                if (this._tuneState.isTuningBenefit(string)) {
                    return this.TUNE_BENEFIT;
                }
                if (this._tuneState.isTuningCost(string)) {
                    return this.TUNE_COST;
                }
                if (this._tuneState.isTuningCustomROC(string)) {
                    return this.TUNE_ROC;
                }
                if (this._tuneState.isTuningCustomLift(string)) {
                    return this.TUNE_LIFT;
                }
                if (this._tuneState.isTuningCustomProfit(string)) {
                    return this.TUNE_PROFIT;
                }
            }
            return null;
        }
    }

    public class BenefitData
    implements Element {
        private String _algorithm;
        private Date _creation_date;
        private WeightsType _weights = null;
        private boolean _modified = false;
        private String _label;

        public BenefitData(String string, Date date, WeightsType weightsType) {
            this._algorithm = string;
            this._creation_date = date;
            this._weights = weightsType;
        }

        public void setLabel(String string) {
            this._label = string;
        }

        public boolean mayHaveChildren() {
            return false;
        }

        public Iterator<Element> getChildren() {
            return null;
        }

        public Attributes getAttributes() {
            return null;
        }

        public Object getData() {
            return null;
        }

        public String getShortLabel() {
            return this._label;
        }

        public String getLongLabel() {
            return "";
        }

        public Icon getIcon() {
            return null;
        }

        public String getToolTipText() {
            return "";
        }

        public String toString() {
            return "";
        }

        public String getAlgorithm() {
            return this._algorithm;
        }

        public Date getCreationDate() {
            return this._creation_date;
        }

        public WeightsType getWeights() {
            return this._weights;
        }

        public void setWeights(WeightsType weightsType) {
            this._weights = weightsType;
        }

        public void setModified(boolean bl) {
            this._modified = bl;
        }

        public boolean isModified() {
            return this._modified;
        }
    }

    public static class WeightSettingsModel
    extends GenericBaseTableModel {
        private static final int COLUMN_COUNT = 2;
        public static final int TARGET_VALUE = 0;
        public static final int BENEFIT_VALUE = 1;
        private static String[] _benefits_columnNames = new String[]{DialogsLrb.get("COST_BENEFIT_TARGET_TABLE_FIRST_COLUMN"), DialogsLrb.get("COST_BENEFIT_TARGET_TABLE_SECOND_COLUMN")};
        private WeightsType _weights = null;

        public WeightSettingsModel(WeightsType weightsType) {
            this._weights = weightsType;
            this.setColumnIdentifiers(_benefits_columnNames);
            this.setColumnCount(2);
        }

        public int getRowCount() {
            return this._weights != null ? this._weights.getItem().size() : 0;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            WeightsType.Item item = (WeightsType.Item)this._weights.getItem().get(n);
            Object object = null;
            switch (n2) {
                case 0: {
                    object = item.getTargetValue();
                    break;
                }
                case 1: {
                    object = item.getWeight();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public Class<?> getColumnClass(int n) {
            if (n == 1) {
                return Double.class;
            }
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        public void setValueAt(Object object, int n, int n2) {
            WeightsType.Item item = (WeightsType.Item)this._weights.getItem().get(n);
            if (n2 == 1) {
                item.setWeight(((Double)object).doubleValue());
            }
        }
    }
}

