/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.tests;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNodeUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.server.model.MiningModelSettings;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.tviewer.TestCompareNode;
import oracle.dmt.dataminer.utils.PIAncestorListener;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.tests.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.tests.TestModelPickerDialog;
import oracle.dmt.dataminer.workflow.dialog.tests.TestModelPickerPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.TestNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowTestNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ModelProvider;
import oracle.dmt.dataminer.workflow.model.TestNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationResultType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionResultType;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.nulls.NullIcon;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.jdeveloper.db.ConnectionException;

public class TestModelPanel
extends AbstractDialogPanel {
    private static final Logger LOGGER = Logger.getLogger(TestModelPanel.class.getName());
    private static final String TEST_NONE = DialogsLrb.get("TEST_NONE");
    private static final String UNKNOWN = DialogsLrb.get("TEST_UNKNOWN");
    private static final String NOT_TESTED = BuildEditorLrb.get("BUILD_MODEL_NOT_TESTED");
    private PropertyModel _propertyModel;
    private ModelTableModel _tableModels;
    private TestModelType _models;
    private List<? extends MiningResultType> _results;
    private MiningFunctionType _miningFunction;
    private AttributeType _targetAttr;
    private AttributeType _caseAttr;
    private static NullIcon _nullIcon;
    private AutoSpecType _autoSetting;
    private boolean _autoDirty;
    private boolean _targetDirty;
    private boolean _caseIdDirty;
    private boolean _modelsDirty;
    private boolean _loading = false;
    private boolean _showModelDetails = true;
    private String _ownerName = null;
    private HashMap<String, AttributeType> _caseIdLookupMap = new HashMap();
    private JButton _addBtn;
    private JButton _removeBtn;
    private JCheckBox jAutoSpecificationCheckBox;
    private JComboBox jCaseIdComboBox;
    private JLabel jCaseIdLabel;
    private JLabel jMiningFunctionLabel;
    private JLabel jMiningFunctionValue;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel jTargetLabel;
    private JLabel jTargetTypeLabel;
    private JLabel jTargetTypeValue;
    private JLabel jTargetValue;
    private JLabel jWarnIcon;
    private ComponentWithTitlebar<JComponent> modelsToolbar;
    private DataMinerTablePanel tablePanel;

    public TestModelPanel(PropertyModel propertyModel, boolean bl) {
        super(null, null);
        assert (propertyModel != null) : "PropertyModel for test node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this._showModelDetails = bl;
        this.addAncestorListener(new PIAncestorListener(this));
        this.init((TestNode)this._data, propertyModel);
    }

    public TestModelPanel(Context context, TestNode testNode, PropertyModel propertyModel) {
        super(context, testNode);
        assert (context != null) : "Context must not be null.";
        assert (testNode != null) : "test node must not be null.";
        this.init(testNode, propertyModel);
    }

    private void init(TestNode testNode, PropertyModel propertyModel) {
        this._propertyModel = propertyModel;
        this._autoDirty = false;
        this._caseIdDirty = false;
        this._modelsDirty = false;
        TestNodeType testNodeType = (TestNodeType)testNode.getData();
        this._models = (TestModelType)MetaDataHelper.copyMetadataObject(testNodeType.getTestModels());
        this._results = MetaDataHelper.getResultsCollection(testNode);
        this._autoSetting = this._models.getAutoSpec();
        if (testNodeType.getCaseAttributes().getAttribute().size() > 0) {
            this._caseAttr = (AttributeType)MetaDataHelper.copyMetadataObject(testNodeType.getCaseAttributes().getAttribute().get(0));
        }
        try {
            this._ownerName = Connections.getUserAccountName(this._context);
            this._ownerName = StringUtils.isDoubleQuotedString(this._ownerName) ? StringUtils.trimDoubleQuotes(this._ownerName) : this._ownerName.toUpperCase();
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public boolean isShowSchema() {
        boolean bl = false;
        for (TestModelType.Model model : this._models.getModel()) {
            String string = model.getSchema();
            if (string == null || string.compareTo(this._ownerName) == 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void updatePI(PropertyModel propertyModel) {
        WorkflowTestNodePropertyProxyModel workflowTestNodePropertyProxyModel = (WorkflowTestNodePropertyProxyModel)propertyModel;
        Context context = workflowTestNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        TestNode testNode = (TestNode)workflowNodeInspectorElement.getNode();
        if (testNode == null) {
            return;
        }
        this._propertyModel = propertyModel;
        this._context = context;
        this._data = testNode;
        this._autoDirty = false;
        this._caseIdDirty = false;
        this._modelsDirty = false;
        TestNodeType testNodeType = (TestNodeType)testNode.getData();
        if (this._showModelDetails) {
            this._models = (TestModelType)MetaDataHelper.copyMetadataObject(testNodeType.getTestModels());
            this._results = MetaDataHelper.getResultsCollection(testNode);
            this._autoSetting = this._models.getAutoSpec();
        }
        if (testNodeType.getCaseAttributes().getAttribute().size() > 0) {
            this._caseAttr = (AttributeType)MetaDataHelper.copyMetadataObject(testNodeType.getCaseAttributes().getAttribute().get(0));
        }
        this.reload();
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowTestNodePropertyProxyModel)) {
            return null;
        }
        WorkflowTestNodePropertyProxyModel workflowTestNodePropertyProxyModel = (WorkflowTestNodePropertyProxyModel)propertyModel;
        Context context = workflowTestNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    private TestNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowTestNodePropertyProxyModel)) {
            return null;
        }
        WorkflowTestNodePropertyProxyModel workflowTestNodePropertyProxyModel = (WorkflowTestNodePropertyProxyModel)propertyModel;
        Context context = workflowTestNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof TestNodeType) {
            return (TestNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNode() {
        if (this._targetDirty || this._caseIdDirty || this._autoDirty || this._modelsDirty) {
            TestNode testNode = (TestNode)this.getData();
            TestNodeType testNodeType = (TestNodeType)testNode.getData();
            if (this._propertyModel != null) {
                AttributeType attributeType;
                ComplexProperty complexProperty;
                ArrayList<Property> arrayList = new ArrayList<Property>();
                if (this._targetDirty) {
                    complexProperty = new ComplexProperty("TargetAttribute", this._targetAttr);
                    attributeType = (AttributeType)MetaDataHelper.copyMetadataObject(testNodeType.getTargetAttribute());
                    complexProperty.setOldData(attributeType);
                    arrayList.add(new Property(String.valueOf(TestNodePropertyModel.RowIndex.TARGET_ATTRIBUTE), null, complexProperty, null, null));
                }
                if (this._caseIdDirty) {
                    complexProperty = new ComplexProperty("CaseAttributes", this._caseAttr);
                    attributeType = new CaseAttributes();
                    for (AttributeType attributeType2 : testNodeType.getCaseAttributes().getAttribute()) {
                        attributeType.getAttribute().add((AttributeType)MetaDataHelper.copyMetadataObject(attributeType2));
                    }
                    complexProperty.setOldData(attributeType);
                    arrayList.add(new Property(String.valueOf(TestNodePropertyModel.RowIndex.CASE_ATTRIBUTES), null, complexProperty, null, null));
                }
                if (this._modelsDirty) {
                    complexProperty = new ComplexProperty("TestModels", this._models);
                    attributeType = (TestModelType)MetaDataHelper.copyMetadataObject(testNodeType.getTestModels());
                    complexProperty.setOldData(attributeType);
                    arrayList.add(new Property(String.valueOf(TestNodePropertyModel.RowIndex.TEST_MODELS), null, complexProperty, null, null));
                }
                if (this._autoDirty) {
                    complexProperty = new ComplexProperty("AutoSetting", this._autoSetting);
                    attributeType = testNodeType.getTestModels().getAutoSpec();
                    complexProperty.setOldData(attributeType);
                    arrayList.add(new Property(String.valueOf(TestNodePropertyModel.RowIndex.AUTO_SETTING), null, complexProperty, null, null));
                }
                ((WorkflowTestNodePropertyProxyModel)this._propertyModel).setValueAt(PropertyLrb.get("PI_TEST_NODE_EDIT_SETTING"), testNode, arrayList);
            } else {
                try {
                    CommandProcessor.getInstance().beginTrans(DialogsLrb.get("TEST_NODE_EDIT_TRANSACTION_NAME"));
                    ArrayList<Property> arrayList = new ArrayList<Property>();
                    if (this._targetDirty) {
                        arrayList.add(new Property("TargetAttribute", null, this._targetAttr, null, null));
                    }
                    if (this._caseIdDirty) {
                        arrayList.add(new Property("CaseAttributes", null, this._caseAttr, null, null));
                    }
                    if (this._modelsDirty) {
                        arrayList.add(new Property("TestModels", null, this._models, null, null));
                    }
                    if (this._autoDirty) {
                        arrayList.add(new Property("AutoSetting", null, this._autoSetting, null, null));
                    }
                    OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getData().getUndoFilter();
                    odmrSDMUndoFilter.prepareUndoPropertyList(testNode, this.getContext(), arrayList);
                    if (this._targetDirty || this._modelsDirty || this._caseIdDirty || this._autoDirty) {
                        testNode.validate(true);
                    }
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
                    CommandProcessor.getInstance().abortTrans();
                }
                finally {
                    CommandProcessor.getInstance().endTrans();
                }
            }
        }
    }

    public boolean doWork() {
        boolean bl = true;
        this.updateNode();
        return bl;
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jMiningFunctionLabel, (Component)this.jMiningFunctionValue, (String)DialogsLrb.get("TEST_MODEL_FUNCTION"));
        ResourceUtils.resLabel((JLabel)this.jTargetLabel, (Component)this.jTargetValue, (String)DialogsLrb.get("TEST_MODEL_TARGET"));
        ResourceUtils.resLabel((JLabel)this.jTargetTypeLabel, (Component)this.jTargetTypeValue, (String)DialogsLrb.get("TEST_MODEL_TARGET_TYPE"));
        ResourceUtils.resLabel((JLabel)this.jCaseIdLabel, (Component)this.jCaseIdComboBox, (String)DialogsLrb.get("TEST_MODEL_CASE_ID"));
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("TEST_AUTO_SETTING"), this.jAutoSpecificationCheckBox);
        UIResourceHelper.setComponentText(hashMap);
        if (_nullIcon == null) {
            _nullIcon = new NullIcon(DataMinerIcons.get(Icons.PI_BUILD_GROUP_MODEL_BUILT).getIconWidth(), DataMinerIcons.get(Icons.PI_BUILD_GROUP_MODEL_BUILT).getIconHeight());
        }
    }

    @Override
    public void initUI() {
        Object object;
        HelpUtils.setHelpID((JComponent)this, (String)"test_models");
        this._loading = true;
        this.jWarnIcon.setIcon(DataMinerIcons.get(Icons.WARNING_STATUS));
        this.jWarnIcon.setText(DialogsLrb.get("TEST_MODEL_CASE_ID_WARN"));
        TestNode testNode = (TestNode)this.getData();
        TestNodeType testNodeType = (TestNodeType)testNode.getData();
        AttributeType attributeType = null;
        if (testNodeType.getCaseAttributes().getAttribute().size() > 0) {
            attributeType = (AttributeType)testNodeType.getCaseAttributes().getAttribute().get(0);
        }
        this._targetAttr = testNodeType.getTargetAttribute();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement(TEST_NONE);
        List<AttributeType> list = testNode.findCaseIds();
        this._caseIdLookupMap.clear();
        for (AttributeType object22 : list) {
            defaultComboBoxModel.addElement(object22.getName());
            this._caseIdLookupMap.put(object22.getName(), object22);
        }
        this.jCaseIdComboBox.setModel(defaultComboBoxModel);
        if (attributeType == null) {
            this.jWarnIcon.setVisible(true);
            this.jCaseIdComboBox.setSelectedItem(TEST_NONE);
        } else {
            this.jWarnIcon.setVisible(false);
            this.jCaseIdComboBox.setSelectedItem(attributeType.getName());
        }
        if (this._models.getMiningFunction() == null) {
            object = testNode.findTestModelNodes();
            if (object.size() > 0) {
                ModelProvider modelProvider = (ModelProvider)object.get(0);
                this._miningFunction = modelProvider.getMiningFunctionTypeSupported();
                this._targetAttr = modelProvider.getTargetAttribute();
            } else {
                this._miningFunction = null;
                this._targetAttr = null;
            }
        } else {
            this._miningFunction = this._models.getMiningFunction();
        }
        if (this._showModelDetails) {
            this._tableModels = new ModelTableModel(this, this._models);
            this._addBtn.setEnabled(true);
            this._removeBtn.setEnabled(false);
            this.tablePanel.addControlBarComponents(this._addBtn, this._removeBtn);
            this.tablePanel.setup((TableModel)((Object)this._tableModels), DialogsLrb.get("TEST_MODEL_TABLE_TITLE"), 0, true);
            object = this.tablePanel.getTable();
            this._addBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TestModelPanel.this.processAdd();
                }
            });
            this._removeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("TEST_MODEL_REMOVE_CONFIRMATION"), (String)DialogsLrb.get("WARNING_TITLE"), null, (boolean)true)) {
                        return;
                    }
                    TestModelPanel.this.processRemove();
                }
            });
            object.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    TestModelPanel.this.handleModelSelectionChanged();
                }
            });
            IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

                @Override
                public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    RefModelType refModelType = (RefModelType)TestModelPanel.this._models.getModel().get(n);
                    RefModelStatusType refModelStatusType = refModelType.getStatus();
                    return refModelStatusType == RefModelStatusType.VALID ? _nullIcon : DataMinerIcons.get(Icons.USAGE_ATTR_INVALID);
                }
            });
            TableColumn tableColumn = object.getColumnModel().getColumn(0);
            tableColumn.setCellRenderer(iconCellRenderer);
            IconCellRenderer iconCellRenderer2 = new IconCellRenderer(new IconCellRenderer.IconChooser(){

                @Override
                public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    RefModelType refModelType = (RefModelType)TestModelPanel.this._models.getModel().get(n);
                    ClassificationResultType classificationResultType = null;
                    if (TestModelPanel.this._models.getMiningFunction().equals((Object)MiningFunctionType.CLASSIFICATION)) {
                        List<ClassificationResultType> list = MetaDataHelper.getClassResultsCollection((TestNode)TestModelPanel.this._data);
                        for (ClassificationResultType classificationResultType2 : list) {
                            if (!classificationResultType2.getModelId().equals(refModelType.getModelId())) continue;
                            classificationResultType = classificationResultType2;
                            break;
                        }
                    } else if (TestModelPanel.this._models.getMiningFunction().equals((Object)MiningFunctionType.REGRESSION)) {
                        List<RegressionResultType> list = MetaDataHelper.getRegressResultsCollection((TestNode)TestModelPanel.this._data);
                        for (RegressionResultType regressionResultType : list) {
                            if (!regressionResultType.getModelId().equals(refModelType.getModelId())) continue;
                            classificationResultType = regressionResultType;
                            break;
                        }
                    }
                    if (classificationResultType != null) {
                        return IconCellRenderer.getIconForPIStatus(classificationResultType.getStatus());
                    }
                    return DataMinerIcons.get(Icons.INCOMPLETE);
                }
            });
            tableColumn = object.getColumnModel().getColumn(2);
            tableColumn.setCellRenderer(iconCellRenderer2);
            object.setAutoResizeMode(2);
            object.setSelectionMode(2);
            object.setColumnSelectorAvailable(true);
            object.setShowToolTips(true);
            object.setUpdateSelectionOnSort(true);
            object.setRowSelectionAllowed(true);
            int n = 0;
            for (int n2 : ModelTableModel._columnWidths) {
                object.getColumnModel().getColumn(n++).setPreferredWidth(n2);
            }
        }
        this.enableControls();
        this._loading = false;
    }

    public void reload() {
        this._loading = true;
        TestNode testNode = (TestNode)this.getData();
        TestNodeType testNodeType = (TestNodeType)testNode.getData();
        AttributeType attributeType = null;
        if (testNodeType.getCaseAttributes().getAttribute().size() > 0) {
            attributeType = (AttributeType)testNodeType.getCaseAttributes().getAttribute().get(0);
        }
        this._targetAttr = testNodeType.getTargetAttribute();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement(TEST_NONE);
        List<AttributeType> list = testNode.findCaseIds();
        this._caseIdLookupMap.clear();
        for (AttributeType object : list) {
            defaultComboBoxModel.addElement(object.getName());
            this._caseIdLookupMap.put(object.getName(), object);
        }
        this.jCaseIdComboBox.setModel(defaultComboBoxModel);
        if (attributeType == null) {
            this.jWarnIcon.setVisible(true);
            this.jCaseIdComboBox.setSelectedItem(TEST_NONE);
        } else {
            this.jWarnIcon.setVisible(false);
            this.jCaseIdComboBox.setSelectedItem(attributeType.getName());
        }
        if (this._models.getMiningFunction() == null) {
            List<AbstractNode> list2 = testNode.findTestModelNodes();
            if (list2.size() > 0) {
                ModelProvider modelProvider = (ModelProvider)list2.get(0);
                this._miningFunction = modelProvider.getMiningFunctionTypeSupported();
                this._targetAttr = modelProvider.getTargetAttribute();
            } else {
                this._miningFunction = null;
                this._targetAttr = null;
            }
        } else {
            this._miningFunction = this._models.getMiningFunction();
        }
        if (this._showModelDetails) {
            this._tableModels = new ModelTableModel(this, this._models);
            this._addBtn.setEnabled(true);
            this._removeBtn.setEnabled(false);
            this.tablePanel.getTable().setModel((TableModel)((Object)this._tableModels));
        }
        this.enableControls();
        this._loading = false;
    }

    private void processAdd() {
        TestModelPickerPanel testModelPickerPanel;
        TestModelPickerDialog testModelPickerDialog = new TestModelPickerDialog(this.getContext(), this, this._models);
        if (testModelPickerDialog.invoke(this) && (testModelPickerPanel = (TestModelPickerPanel)testModelPickerDialog.getPanel()).isDirty()) {
            List<TestModelType.Model> list = testModelPickerPanel.getSelectedModelsCache();
            TestNode.removeModel(this._models, this._models.getModel());
            TestNode.addModels2(this._models, list);
            this._targetDirty = true;
            this._tableModels = new ModelTableModel(this, this._models);
            this.tablePanel.getTable().setModel((TableModel)((Object)this._tableModels));
            this._modelsDirty = true;
            if (this._propertyModel != null) {
                this.updateNode();
            }
            this.enableControls();
        }
    }

    private void processRemove() {
        int[] nArray = this.tablePanel.getTable().getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        ArrayList<TestModelType.Model> arrayList = new ArrayList<TestModelType.Model>();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            TestModelType.Model model = (TestModelType.Model)this._models.getModel().get(n);
            arrayList.add(model);
        }
        TestNode.removeModel(this._models, arrayList);
        if (this._models.getModel().size() == 0) {
            this._targetDirty = true;
        }
        this._tableModels = new ModelTableModel(this, this._models);
        this.tablePanel.getTable().setModel((TableModel)((Object)this._tableModels));
        this._modelsDirty = true;
        if (this._propertyModel != null) {
            this.updateNode();
        }
        this.enableControls();
    }

    private void viewModel() {
        int[] nArray = this.tablePanel.getTable().getSelectedRowsInModel();
        if (nArray.length != 1) {
            return;
        }
        int n = nArray[0];
        TestModelType.Model model = (TestModelType.Model)this._models.getModel().get(n);
        if (model.getMiningAlgorithm().equals((Object)MiningAlgorithmType.SUPPORT_VECTOR_MACHINES)) {
            LoadSVMModelViewer loadSVMModelViewer = new LoadSVMModelViewer(model);
            loadSVMModelViewer.execute();
        } else {
            String string = model.getName();
            String string2 = this._data.getData().getName();
            WorkflowNode workflowNode = (WorkflowNode)this._context.getNode();
            BaseTreeNode baseTreeNode = ModelNodeUtils.findModelNode(workflowNode, string2, string);
            EditorUtil.openDefaultEditorInFrame((Node)baseTreeNode);
        }
    }

    public AttributeType getTargetAttr() {
        return this._targetAttr;
    }

    public MiningFunctionType getMiningFunction() {
        return this._miningFunction;
    }

    private void viewCompare(List<? extends MiningResultType> list) {
        Context context = this._context;
        WorkflowNode workflowNode = (WorkflowNode)context.getNode();
        try {
            Element[] elementArray = context.getSelection();
            WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
            TestNodeType testNodeType = (TestNodeType)workflowNodeInspectorElement.getNode().getData();
            TestCompareNode testCompareNode = null;
            if (testNodeType.getTestModels().getMiningFunction().equals((Object)MiningFunctionType.CLASSIFICATION)) {
                testCompareNode = WorkflowEditor.createClassTestCompareNode(context, workflowNode, testNodeType, list);
            } else if (testNodeType.getTestModels().getMiningFunction().equals((Object)MiningFunctionType.REGRESSION)) {
                testCompareNode = WorkflowEditor.createRegressTestCompareNode(context, workflowNode, testNodeType, list);
            }
            if (testCompareNode == null) {
                MessageDialog.error((Component)this, (Object)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_GENERATE_NODE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), null);
                return;
            }
            EditorUtil.openDefaultEditorInFrame((Node)testCompareNode);
        }
        catch (ConnectionException connectionException) {
            LOGGER.log(Level.SEVERE, connectionException.getMessage(), connectionException);
        }
        catch (DBException dBException) {
            LOGGER.log(Level.SEVERE, dBException.getMessage(), dBException);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private void handleModelSelectionChanged() {
        this.enableControls();
    }

    private boolean compareEnabled() {
        boolean bl = false;
        for (MiningResultType miningResultType : this._results) {
            XMLGregorianCalendar xMLGregorianCalendar = miningResultType.getCreationDate();
            if (xMLGregorianCalendar == null) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void enableControls() {
        boolean bl = this._autoSetting.equals((Object)AutoSpecType.YES);
        this.jAutoSpecificationCheckBox.setSelected(bl);
        this.jAutoSpecificationCheckBox.setEnabled(this.isWritable());
        boolean bl2 = MiningFunctionType.REGRESSION.equals((Object)this._models.getMiningFunction()) || MiningFunctionType.CLASSIFICATION.equals((Object)this._models.getMiningFunction());
        this.jCaseIdLabel.setVisible(bl2);
        this.jCaseIdComboBox.setVisible(bl2);
        if (this._showModelDetails) {
            int n = this.tablePanel.getTable().getSelectedRowCount();
            this._addBtn.setEnabled(this.isWritable() && !bl);
            this._removeBtn.setEnabled(this.isWritable() && !bl && n > 0);
            boolean bl3 = false;
            if (n == 1) {
                int[] nArray = this.tablePanel.getTable().getSelectedRowsInModel();
                TestModelType.Model model = (TestModelType.Model)this._models.getModel().get(nArray[0]);
                boolean bl4 = bl3 = model.getStatus() == RefModelStatusType.VALID;
            }
            if (this._propertyModel != null) {
                this.jPanel1.setVisible(false);
            }
        } else {
            this.jPanel2.setVisible(false);
        }
        String string = UNKNOWN;
        if (this._miningFunction != null) {
            if (this._miningFunction == MiningFunctionType.CLASSIFICATION) {
                string = DialogsLrb.get("TEST_NODE_CLASSIFICATION_TYPE");
            } else if (this._miningFunction == MiningFunctionType.REGRESSION) {
                string = DialogsLrb.get("TEST_NODE_REGRESSSION_TYPE");
            }
        }
        this.jMiningFunctionValue.setText(string);
        this.jTargetValue.setText(this._targetAttr != null ? this._targetAttr.getName() : UNKNOWN);
        this.jTargetTypeValue.setText(this._targetAttr != null ? this._targetAttr.getDataType() : UNKNOWN);
    }

    private void initComponents() {
        this.modelsToolbar = new ComponentWithTitlebar();
        this._removeBtn = new JButton();
        this._addBtn = new JButton();
        this.jPanel1 = new JPanel();
        this.jMiningFunctionLabel = new JLabel();
        this.jMiningFunctionValue = new JLabel();
        this.jTargetLabel = new JLabel();
        this.jTargetValue = new JLabel();
        this.jTargetTypeLabel = new JLabel();
        this.jTargetTypeValue = new JLabel();
        this.jCaseIdLabel = new JLabel();
        this.jCaseIdComboBox = new JComboBox();
        this.jWarnIcon = new JLabel();
        this.jPanel2 = new JPanel();
        this.jAutoSpecificationCheckBox = new JCheckBox();
        this.tablePanel = new DataMinerTablePanel();
        this.modelsToolbar.setAutoscrolls(true);
        this.modelsToolbar.setName("modelsToolbar");
        this._removeBtn.setIcon(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.setToolTipText(DialogsLrb.get("TEST_MODEL_REMOVE"));
        this._removeBtn.setName("_removeBtn");
        this._addBtn.setIcon(OracleIcons.getIcon((String)"add.png"));
        this._addBtn.setToolTipText(DialogsLrb.get("TEST_MODEL_ADD"));
        this._addBtn.setName("_addBtn");
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setOpaque(false);
        this.jMiningFunctionLabel.setText("Function:");
        this.jMiningFunctionLabel.setName("jMiningFunctionLabel");
        this.jMiningFunctionValue.setText("Classification");
        this.jMiningFunctionValue.setName("jMiningFunctionValue");
        this.jTargetLabel.setText("Target:");
        this.jTargetLabel.setName("jTargetLabel");
        this.jTargetValue.setText("AFFINITY_CARD");
        this.jTargetValue.setName("jTargetValue");
        this.jTargetTypeLabel.setText("Target Type:");
        this.jTargetTypeLabel.setName("jTargetTypeLabel");
        this.jTargetTypeValue.setText("DM_NESTED_CATEGORICAL");
        this.jTargetTypeValue.setName("jTargetTypeValue");
        this.jCaseIdLabel.setText("Case Id:");
        this.jCaseIdLabel.setName("jCaseIdLabel");
        this.jCaseIdComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item56789012345678901234567890", "Item 2", "Item 3", "Item 4"}));
        this.jCaseIdComboBox.setName("jCaseIdComboBox");
        this.jCaseIdComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestModelPanel.this.jCaseIdComboBoxActionPerformed(actionEvent);
            }
        });
        this.jWarnIcon.setText("warningIcon");
        this.jWarnIcon.setHorizontalTextPosition(4);
        this.jWarnIcon.setName("jWarnIcon");
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jCaseIdLabel, GroupLayout.Alignment.LEADING).addComponent(this.jTargetLabel, GroupLayout.Alignment.LEADING).addComponent(this.jMiningFunctionLabel, GroupLayout.Alignment.LEADING, -2, 54, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTargetValue, -2, 203, -2).addGap(31, 31, 31).addComponent(this.jTargetTypeLabel, -2, 113, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTargetTypeValue, -2, 147, -2)).addComponent(this.jMiningFunctionValue, -2, 203, -2).addGroup(groupLayout.createSequentialGroup().addComponent(this.jCaseIdComboBox, -2, 216, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jWarnIcon))).addContainerGap(41, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMiningFunctionLabel).addComponent(this.jMiningFunctionValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTargetLabel).addComponent(this.jTargetValue).addComponent(this.jTargetTypeLabel).addComponent(this.jTargetTypeValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCaseIdLabel).addComponent(this.jCaseIdComboBox, -2, -1, -2).addComponent(this.jWarnIcon)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setName("jPanel2");
        this.jPanel2.setOpaque(false);
        this.jAutoSpecificationCheckBox.setText("Automatic Specification");
        this.jAutoSpecificationCheckBox.setName("jAutoSpecificationCheckBox");
        this.jAutoSpecificationCheckBox.setOpaque(false);
        this.jAutoSpecificationCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestModelPanel.this.jAutoSpecificationCheckBoxActionPerformed(actionEvent);
            }
        });
        this.tablePanel.setName("tablePanel");
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jAutoSpecificationCheckBox).addContainerGap(464, Short.MAX_VALUE)).addComponent(this.tablePanel, -1, -1, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jAutoSpecificationCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tablePanel, -1, 265, Short.MAX_VALUE)));
        GroupLayout groupLayout3 = new GroupLayout(this);
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void jCaseIdComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this._loading) {
            return;
        }
        String string = (String)this.jCaseIdComboBox.getSelectedItem();
        if (!TEST_NONE.equals(string)) {
            AttributeType attributeType = this._caseIdLookupMap.get(string);
            if (this._caseAttr == null || !this._caseAttr.equals(attributeType)) {
                this.jWarnIcon.setVisible(false);
                this._caseAttr = attributeType;
                this._caseIdDirty = true;
                if (this._propertyModel != null) {
                    this.updateNode();
                }
            }
        } else if (this._caseAttr != null) {
            this.jWarnIcon.setVisible(true);
            this._caseAttr = null;
            this._caseIdDirty = true;
            if (this._propertyModel != null) {
                this.updateNode();
            }
        }
    }

    private void jAutoSpecificationCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jAutoSpecificationCheckBox.isSelected();
        if (bl) {
            this._autoSetting = AutoSpecType.YES;
            this._autoDirty = true;
            if (this._propertyModel != null) {
                this.updateNode();
            }
        } else {
            this._autoSetting = AutoSpecType.NO;
            this._autoDirty = true;
            if (this._propertyModel != null) {
                this.updateNode();
            }
        }
        this.enableControls();
    }

    static class ModelTableModel
    extends GenericBaseTableModel {
        static String[] _columnNames = new String[]{DialogsLrb.get("TEST_MODEL_NAME"), DialogsLrb.get("TEST_MODEL_NODE"), DialogsLrb.get("TEST_DATE_TESTED"), DialogsLrb.get("TEST_MODEL_ALGORITHM")};
        static int[] _columnWidths = new int[]{180, 80, 180, 150};
        public static final int TEST_MODEL_NAME = 0;
        public static final int TEST_MODEL_NODE = 1;
        public static final int TEST_DATE_TESTED = 2;
        public static final int TEST_MODEL_ALGORITHM = 3;
        public static final int COLUMN_COUNT = 4;
        private TestModelType _srcData;
        private TestModelPanel _parent;

        public ModelTableModel(TestModelPanel testModelPanel, TestModelType testModelType) {
            this._parent = testModelPanel;
            this._srcData = testModelType;
            this.setColumnIdentifiers(_columnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(4);
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.getModel().size() : 0;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            TestModelType.Model model = (TestModelType.Model)this._srcData.getModel().get(n);
            String string = null;
            switch (n2) {
                case 0: {
                    if (this._parent.isShowSchema()) {
                        string = model.getSchema() + "." + model.getName();
                        break;
                    }
                    string = model.getName();
                    break;
                }
                case 1: {
                    string = ((TestNode)this._parent.getData()).getModelNodeName(model.getNodeId());
                    break;
                }
                case 2: {
                    string = NOT_TESTED;
                    MiningResultType miningResultType = ((TestNode)this._parent.getData()).getModelResult(model.getModelId());
                    if (miningResultType == null) break;
                    XMLGregorianCalendar xMLGregorianCalendar = miningResultType.getCreationDate();
                    string = TimeUtils.formatDate(xMLGregorianCalendar);
                    break;
                }
                case 3: {
                    string = MetaDataHelper.getAlgorithmName(model.getMiningAlgorithm());
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }
    }

    private class LoadSVMModelViewer
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        TestModelType.Model _modelType;
        boolean _isLinear = false;

        public LoadSVMModelViewer(TestModelType.Model model) {
            this._modelType = model;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doInBackground() throws Exception {
            Connection connection = null;
            try {
                connection = Connections.getUniqueConnection(TestModelPanel.this._context);
                Model model = new Model();
                Context context = TestModelPanel.this._context;
                ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
                String string = connectionFolder.getUserAccountName();
                Vector<MiningModelSettings> vector = model.getModelSetting(connection, string, this._modelType.getName());
                MiningModelSettings miningModelSettings = MiningModelSettings.findSetting("SVMS_KERNEL_FUNCTION", vector);
                if (miningModelSettings != null) {
                    this._isLinear = miningModelSettings.getSettingValue().equals("SVMS_LINEAR");
                }
                this._success = true;
            }
            catch (Exception exception) {
                try {
                    this._ex = exception;
                    LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
                }
                catch (Throwable throwable) {
                    SQLHelper.close(connection);
                    throw throwable;
                }
                SQLHelper.close(connection);
            }
            SQLHelper.close(connection);
            return this._isLinear;
        }

        @Override
        protected void done() {
            super.done();
            if (this._success && this._ex == null) {
                Context context = TestModelPanel.this._context;
                BaseTreeNode baseTreeNode = null;
                String string = this._modelType.getName();
                if (string != null) {
                    WorkflowNode workflowNode = (WorkflowNode)context.getNode();
                    String string2 = TestModelPanel.this._data.getData().getName();
                    baseTreeNode = ModelNodeUtils.findModelNode(workflowNode, string2, string);
                    EditorUtil.openDefaultEditorInFrame((Node)baseTreeNode);
                }
            } else if (this._ex != null) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_VIEWER_ERROR_TITLE"), (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_VIEWER_ERROR_MESG"), null);
            } else {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_VIEWER_ERROR_MESG"), (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_VIEWER_ERROR_TITLE"), null);
            }
        }
    }
}

