/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Component;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import oracle.dmt.dataminer.controls.GraphicalPreferencesSettings;
import oracle.dmt.dataminer.controls.TransformationPreferencesSettings;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.wizard.WizardModel;
import oracle.dmt.dataminer.workflow.dialog.transformations.AbstractAttributesTableModel;
import oracle.dmt.dataminer.workflow.dialog.transformations.AddAttributesTableModel;
import oracle.dmt.dataminer.workflow.dialog.transformations.BinningPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.EditAttributesTableModel;
import oracle.dmt.dataminer.workflow.dialog.transformations.MissingValuesPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.NormalizationPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.OutlierPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationTypes;
import oracle.dmt.dataminer.workflow.dialog.transformations.UseExistingColumnPanel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.TransformationNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.BinLabels;
import oracle.dmt.dataminer.workflow.xmlschema.MapTransformedSource;
import oracle.dmt.dataminer.workflow.xmlschema.StringCollection;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationOutputAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributes;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public class ApplyTransformWizardModel
extends WizardModel {
    private static Preferences _p = Preferences.getPreferences();
    private GraphicalPreferencesSettings graphPanelSettings = GraphicalPreferencesSettings.getInstance((PropertyStorage)_p);
    private TransformationPreferencesSettings transformSettings = TransformationPreferencesSettings.getInstance((PropertyStorage)_p);
    private Context _context;
    private Component _parent;
    private TransformationNodeType _cachedTransformationNodeType;
    private AbstractDataNode _parentNode;
    private TransformationStatisticsState _state;
    private List<TransformationSourceAttribute> _selectedSourceColumns;
    private List<TransformationSourceAttribute> _combinedAttrList = new ArrayList<TransformationSourceAttribute>();
    private volatile boolean _wizardIsCancelled;
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    private String _selectedTransformation;
    private BinningPanel binningPanel;
    private MissingValuesPanel missValuesPanel;
    private OutlierPanel outlierPanel;
    private NormalizationPanel normalizationPanel;
    private UseExistingColumnPanel useExistingColumnPanel;
    private boolean checkBoxVisible = true;
    private TransformationType resultTransformationType;
    private List<MapTransformedSource> nonEditedXformedColumns = new ArrayList<MapTransformedSource>();
    private List<MapTransformedSource> editedXformedColumns = new ArrayList<MapTransformedSource>();

    public ApplyTransformWizardModel(Component component, Context context, TransformationNode transformationNode, TransformationNodeType transformationNodeType, AbstractDataNode abstractDataNode, List<TransformationSourceAttribute> list, boolean bl) {
        this._context = context;
        this._parent = component;
        this._parentNode = abstractDataNode;
        this._cachedTransformationNodeType = transformationNodeType;
        this.checkBoxVisible = bl ? false : null != this._cachedTransformationNodeType.getInputStatisticTable() && null != this._cachedTransformationNodeType.getInputStatisticTable().getName();
        this._selectedSourceColumns = list;
        this.determineTansformationCompatibility();
        this.prepareCreateModel();
        this._state = new TransformationStatisticsState(context, this.graphPanelSettings, transformationNode, this._cachedTransformationNodeType.getTransformedAttributes(), AttributeTypeHelper.toVector(this._combinedAttrList));
    }

    private void determineTansformationCompatibility() {
        String string = null;
        for (TransformationSourceAttribute transformationSourceAttribute : this._selectedSourceColumns) {
            if (!(transformationSourceAttribute instanceof TransformationOutputAttribute)) {
                return;
            }
            TransformationType transformationType = ((TransformationOutputAttribute)transformationSourceAttribute).getTransformationElementType();
            String string2 = TransformationTypes.transformationTypeToString(transformationType);
            if (string == null) {
                string = string2;
                continue;
            }
            if (string.equals(string2)) continue;
            string = null;
            break;
        }
        this._selectedTransformation = string != null ? string : TransformationTypes.getTRANSFORMATION_TYPE_BINNING();
    }

    public void setWizardCancelled(boolean bl) {
        boolean bl2 = this._wizardIsCancelled;
        this._wizardIsCancelled = bl;
        this._changeSupport.firePropertyChange("wizardCancelled", bl2, bl);
    }

    private void prepareCreateModel() {
        List list;
        this._combinedAttrList.clear();
        TransformationSourceAttributes transformationSourceAttributes = this._cachedTransformationNodeType.getTransformationSourceAttributes();
        TransformedAttributes transformedAttributes = this._cachedTransformationNodeType.getTransformedAttributes();
        if (transformationSourceAttributes != null && (list = transformationSourceAttributes.getTransformationSourceAttributeType()) != null && !list.isEmpty()) {
            this._combinedAttrList.addAll(list);
        }
        if (transformedAttributes != null && (list = transformedAttributes.getMapTransformedSourceType()) != null && !list.isEmpty()) {
            for (MapTransformedSource mapTransformedSource : list) {
                this._combinedAttrList.add((TransformationSourceAttribute)mapTransformedSource.getKey());
            }
        }
    }

    @Override
    public Context getContext() {
        return this._context;
    }

    public Component getParent() {
        return this._parent;
    }

    public TransformationNodeType getNodeType() {
        return this._cachedTransformationNodeType;
    }

    public void close() {
    }

    public void setSelectedSourceColumns(List<TransformationSourceAttribute> list) {
        this._selectedSourceColumns = list;
    }

    public List<TransformationSourceAttribute> getSelectedSourceColumns() {
        return this._selectedSourceColumns;
    }

    public void setSelectedTransformation(String string) {
        this._selectedTransformation = string;
    }

    public String getSelectedTransformation() {
        return this._selectedTransformation;
    }

    public void setBinningPanel(BinningPanel binningPanel) {
        this.binningPanel = binningPanel;
    }

    public BinningPanel getBinningPanel() {
        return this.binningPanel;
    }

    public TransformationStatisticsState getState() {
        return this._state;
    }

    public boolean isEditingMode() {
        boolean bl = false;
        if (this.getSelectedSourceColumns() != null && !this.getSelectedSourceColumns().isEmpty() && this.getSelectedSourceColumns().get(0) instanceof TransformationOutputAttribute) {
            bl = true;
        }
        return bl;
    }

    public String generateUniqueName(String string, List<String> list) {
        Object object;
        String string2 = null;
        if (this._selectedTransformation.equals(TransformationTypes.getTRANSFORMATION_TYPE_EXISTNG_COLUMN()) && this.useExistingColumnPanel != null) {
            object = this.useExistingColumnPanel.getSelectedTransformedColumn().getKey().getTransformationElementType();
            string2 = TransformationTypes.getXformAbbreviatedName(TransformationTypes.transformationTypeToString(object));
        }
        if (string2 == null) {
            string2 = TransformationTypes.getXformAbbreviatedName(this._selectedTransformation);
        }
        object = AttributeTypeHelper.createUniqueTransformationOutputNameWizard(string, string2, this._combinedAttrList, this._cachedTransformationNodeType.getTransformedAttributes().getMapTransformedSourceType(), list);
        return object;
    }

    public boolean isUniqueTransformationOutputName(String string) {
        return AttributeTypeHelper.isUniqueTransformationOutputName(string, this._combinedAttrList, this._cachedTransformationNodeType.getTransformedAttributes().getMapTransformedSourceType());
    }

    public boolean isGenerateStatsOnFinish() {
        return this.transformSettings.isGenerateStatsOnFinish();
    }

    public void setGenerateStatsOnFinish(boolean bl) {
        this.transformSettings.setGenerateStatsOnFinish(bl);
    }

    public void setResultTransformationType(TransformationType transformationType) {
        this.resultTransformationType = transformationType;
    }

    public TransformationType getResultTransformationType() {
        return this.resultTransformationType;
    }

    List<MapTransformedSource> getAllXformedColumns() {
        ArrayList<MapTransformedSource> arrayList = new ArrayList<MapTransformedSource>();
        if (!this.editedXformedColumns.isEmpty()) {
            arrayList.addAll(this.editedXformedColumns);
        }
        if (!this.nonEditedXformedColumns.isEmpty()) {
            arrayList.addAll(this.nonEditedXformedColumns);
        }
        return arrayList;
    }

    void prepareResultColumnsList(AbstractAttributesTableModel abstractAttributesTableModel) {
        if (this.isEditingMode()) {
            if (abstractAttributesTableModel == null) {
                abstractAttributesTableModel = new EditAttributesTableModel(this);
            }
            List list = this.getNodeType().getTransformedAttributes().getMapTransformedSourceType();
            for (MapTransformedSource mapTransformedSource : list) {
                BinLabels binLabels;
                TransformationType.Binning binning;
                String string;
                TransformationType transformationType;
                TransformationType transformationType2;
                String string2 = mapTransformedSource.getKey().getName();
                String string3 = ((EditAttributesTableModel)abstractAttributesTableModel).getNewName(string2);
                MapTransformedSource mapTransformedSource2 = new MapTransformedSource();
                mapTransformedSource2.setKey(new TransformationOutputAttribute());
                mapTransformedSource2.getKey().setTransformationElementType(new TransformationType());
                mapTransformedSource2.setStringCollectionNames(new StringCollection());
                AttributeTypeHelper.copyMapTransformedSource(mapTransformedSource2, mapTransformedSource);
                if (string3 == null) {
                    this.nonEditedXformedColumns.add(mapTransformedSource2);
                    continue;
                }
                TransformationOutputAttribute transformationOutputAttribute = mapTransformedSource2.getKey();
                boolean bl = false;
                if (0 != string2.compareTo(string3)) {
                    transformationOutputAttribute.setName(string3);
                    bl = true;
                }
                if (!TransformationTypes.areEqual(transformationType2 = this.getResultTransformationType(), transformationType = transformationOutputAttribute.getTransformationElementType())) {
                    transformationOutputAttribute.setTransformationElementType(transformationType2);
                    if (!bl) {
                        bl = true;
                    }
                }
                if (!transformationOutputAttribute.isModified()) {
                    transformationOutputAttribute.setModified(bl);
                }
                if ("NUMBER".equals(string = transformationOutputAttribute.getDataType()) || "FLOAT".equals(string) || "BINARY_DOUBLE".equals(string) || "BINARY_FLOAT".equals(string)) {
                    if (TransformationTypes.isBinning(transformationType2)) {
                        binning = transformationType2.getBinning();
                        binLabels = null;
                        if (null != binning.getEqualWidth()) {
                            binLabels = binning.getEqualWidth().getBinLabels();
                        } else if (null != binning.getQuantile()) {
                            binLabels = binning.getQuantile().getBinLabels();
                        } else if (null != binning.getCustomNumeric()) {
                            binLabels = binning.getCustomNumeric().getBinLabels();
                        }
                        if (binLabels != null && null != binLabels.getRange()) {
                            string = "VARCHAR2";
                            transformationOutputAttribute.setDataType(string);
                            transformationOutputAttribute.setModified(true);
                        }
                    }
                } else if (string.equals("DATE") || DatabaseMetadataUtils.isTimestamp(string) || DatabaseMetadataUtils.isTimestampWithLocalTimeZone(string)) {
                    String string4;
                    if (TransformationTypes.isBinning(transformationType2)) {
                        binning = transformationType2.getBinning();
                        binLabels = null;
                        if (null != binning.getDateEqualWidth()) {
                            binLabels = binning.getDateEqualWidth().getBinLabels();
                        }
                        if (binLabels != null) {
                            string4 = null;
                            if (null != binLabels.getNumberSequence()) {
                                string4 = "NUMBER";
                            } else if (null != binLabels.getRange()) {
                                string4 = "VARCHAR2";
                            }
                            if (string4 != null) {
                                transformationOutputAttribute.setDataType(string4);
                                transformationOutputAttribute.setModified(true);
                            }
                        }
                    } else if (DatabaseMetadataUtils.isTimestampWithTimeZone(string) && TransformationTypes.isBinning(transformationType2)) {
                        binning = transformationType2.getBinning();
                        binLabels = null;
                        if (null != binning.getTimestampEqualWidth()) {
                            binLabels = binning.getTimestampEqualWidth().getBinLabels();
                        } else if (null != binning.getCustomTimestamp()) {
                            binLabels = binning.getCustomTimestamp().getBinLabels();
                        }
                        if (binLabels != null) {
                            string4 = null;
                            if (null != binLabels.getNumberSequence()) {
                                string4 = "NUMBER";
                            } else if (null != binLabels.getRange()) {
                                string4 = "VARCHAR2";
                            }
                            if (string4 != null) {
                                transformationOutputAttribute.setDataType(string4);
                                transformationOutputAttribute.setModified(true);
                            }
                        }
                    }
                }
                this.editedXformedColumns.add(mapTransformedSource2);
            }
        } else {
            if (abstractAttributesTableModel == null) {
                abstractAttributesTableModel = new AddAttributesTableModel(this);
            }
            List<String> list = abstractAttributesTableModel.getOutputColumns();
            for (String string : list) {
                TransformationOutputAttribute transformationOutputAttribute;
                TransformationSourceAttribute transformationSourceAttribute;
                String string5 = abstractAttributesTableModel.getInputColumnName(string);
                TransformationType transformationType = this.getResultTransformationType();
                TransformationSourceAttribute transformationSourceAttribute2 = null;
                Object object = this.getNodeType().getTransformationSourceAttributes().getTransformationSourceAttributeType().iterator();
                while (object.hasNext()) {
                    transformationSourceAttribute = (TransformationSourceAttribute)object.next();
                    if (!string5.equals(transformationSourceAttribute.getName())) continue;
                    transformationSourceAttribute2 = transformationSourceAttribute;
                    break;
                }
                if ("NUMBER".equals(object = transformationSourceAttribute2.getDataType()) || "FLOAT".equals(object) || "BINARY_DOUBLE".equals(object) || "BINARY_FLOAT".equals(object)) {
                    if (TransformationTypes.isBinning(transformationType)) {
                        transformationSourceAttribute = transformationType.getBinning();
                        transformationOutputAttribute = null;
                        if (null != transformationSourceAttribute.getEqualWidth()) {
                            transformationOutputAttribute = transformationSourceAttribute.getEqualWidth().getBinLabels();
                        } else if (null != transformationSourceAttribute.getQuantile()) {
                            transformationOutputAttribute = transformationSourceAttribute.getQuantile().getBinLabels();
                        } else if (null != transformationSourceAttribute.getCustomNumeric()) {
                            transformationOutputAttribute = transformationSourceAttribute.getCustomNumeric().getBinLabels();
                        }
                        if (transformationOutputAttribute != null && null != transformationOutputAttribute.getRange()) {
                            object = "VARCHAR2";
                        }
                    }
                } else if (((String)object).equals("DATE") || DatabaseMetadataUtils.isTimestampWithLocalTimeZone((String)object) || DatabaseMetadataUtils.isTimestamp((String)object)) {
                    if (TransformationTypes.isBinning(transformationType)) {
                        transformationSourceAttribute = transformationType.getBinning();
                        transformationOutputAttribute = null;
                        if (null != transformationSourceAttribute.getDateEqualWidth()) {
                            transformationOutputAttribute = transformationSourceAttribute.getDateEqualWidth().getBinLabels();
                        }
                        if (transformationOutputAttribute != null) {
                            if (null != transformationOutputAttribute.getRange()) {
                                object = "VARCHAR2";
                            } else if (null != transformationOutputAttribute.getNumberSequence()) {
                                object = "NUMBER";
                            }
                        }
                    }
                } else if (DatabaseMetadataUtils.isTimestampWithTimeZone((String)object) && TransformationTypes.isBinning(transformationType)) {
                    transformationSourceAttribute = transformationType.getBinning();
                    transformationOutputAttribute = null;
                    if (null != transformationSourceAttribute.getTimestampEqualWidth()) {
                        transformationOutputAttribute = transformationSourceAttribute.getTimestampEqualWidth().getBinLabels();
                    } else if (null != transformationSourceAttribute.getCustomTimestamp()) {
                        transformationOutputAttribute = transformationSourceAttribute.getCustomTimestamp().getBinLabels();
                    }
                    if (transformationOutputAttribute != null) {
                        if (null != transformationOutputAttribute.getRange()) {
                            object = "VARCHAR2";
                        } else if (null != transformationOutputAttribute.getNumberSequence()) {
                            object = "NUMBER";
                        }
                    }
                }
                transformationSourceAttribute = new MapTransformedSource();
                transformationOutputAttribute = new TransformationOutputAttribute();
                transformationOutputAttribute.setModified(true);
                transformationOutputAttribute.setName(string);
                transformationOutputAttribute.setDataType((String)object);
                transformationOutputAttribute.setIsOutput(true);
                transformationOutputAttribute.setStatus(AttributeStatus.VALID);
                transformationOutputAttribute.setTransformationElementType(transformationType);
                transformationSourceAttribute.setKey(transformationOutputAttribute);
                StringCollection stringCollection = new StringCollection();
                stringCollection.getValue().add(transformationSourceAttribute2.getName());
                transformationSourceAttribute.setStringCollectionNames(stringCollection);
                this.editedXformedColumns.add((MapTransformedSource)transformationSourceAttribute);
            }
        }
    }

    public boolean isCheckBoxVisible() {
        return this.checkBoxVisible;
    }

    public List<MapTransformedSource> getNonEditedXformedColumns() {
        return this.nonEditedXformedColumns;
    }

    public List<MapTransformedSource> getEditedXformedColumns() {
        return this.editedXformedColumns;
    }

    public void setMissValuesPanel(MissingValuesPanel missingValuesPanel) {
        this.missValuesPanel = missingValuesPanel;
    }

    public MissingValuesPanel getMissValuesPanel() {
        return this.missValuesPanel;
    }

    public void setOutlierPanel(OutlierPanel outlierPanel) {
        this.outlierPanel = outlierPanel;
    }

    public OutlierPanel getOutlierPanel() {
        return this.outlierPanel;
    }

    public void setNormalizationPanel(NormalizationPanel normalizationPanel) {
        this.normalizationPanel = normalizationPanel;
    }

    public NormalizationPanel getNormalizationPanel() {
        return this.normalizationPanel;
    }

    public void setUseExistingColumnPanel(UseExistingColumnPanel useExistingColumnPanel) {
        this.useExistingColumnPanel = useExistingColumnPanel;
    }

    public UseExistingColumnPanel getUseExistingColumnPanel() {
        return this.useExistingColumnPanel;
    }
}

