/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.NameValuePair;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.ConverterHelper;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.dataminer.utils.comparator.NameValuePairComparator;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.transformations.AddEditCategoricalBinAssignmentDlg;
import oracle.dmt.dataminer.workflow.dialog.transformations.BinningDetailsNumeric;
import oracle.dmt.dataminer.workflow.dialog.transformations.DatePickerDialog;
import oracle.dmt.dataminer.workflow.dialog.transformations.GenerateDefaultBinsDialog;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.BinLabels;
import oracle.dmt.dataminer.workflow.xmlschema.CategoricalBin;
import oracle.dmt.dataminer.workflow.xmlschema.DateBin;
import oracle.dmt.dataminer.workflow.xmlschema.NumericBin;
import oracle.dmt.dataminer.workflow.xmlschema.StringCollection;
import oracle.dmt.dataminer.workflow.xmlschema.TimestampTimezoneBin;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.ide.Ide;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;

public abstract class BinningCustomBase
extends JPanel
implements BinningDetailsNumeric {
    private static final Logger theLogger = Logger.getLogger(BinningCustomBase.class.getName());
    protected Object customBinning;
    private String binningType;
    protected int dataType;
    private TransformationStatisticsState _state;
    private String srcColumnName;
    private String srcColumnType;
    protected DataMinerTable _jAttributesTable = new DataMinerTable();
    protected JButton resetBtn;
    protected JButton removeBtn;
    protected JButton editBtn;
    protected JButton addBtn;
    protected static Icon _editIcon;
    protected static String _default_other;
    static String _status;
    static String _loading;
    static String _bin_names;
    static String _bin_values;
    static String _bin_Lower_bound;
    static int _BIN_NAME;
    static int _BIN_VALUE;
    private String[] _columnNames;

    public BinningCustomBase(String string, String string2, TransformationStatisticsState transformationStatisticsState, String string3, Object object, int n) {
        this.srcColumnName = StringUtils.addDoubleQuotes(string);
        this.srcColumnType = string2;
        this._state = transformationStatisticsState;
        this.binningType = string3;
        this.dataType = n;
        if (object != null) {
            this.customBinning = object;
        } else if (n == 2) {
            this.customBinning = new TransformationType.Binning.CustomCategorical();
        } else if (n == 1) {
            TransformationType.Binning.CustomNumeric customNumeric = new TransformationType.Binning.CustomNumeric();
            BinLabels binLabels = new BinLabels();
            binLabels.setRange(new BinLabels.Range());
            customNumeric.setBinLabels(binLabels);
            this.customBinning = customNumeric;
        } else if (n == 3 || n == 4 || n == 5) {
            this.customBinning = new TransformationType.Binning.CustomDate();
        } else if (n == 6) {
            this.customBinning = new TransformationType.Binning.CustomTimestamp();
        }
    }

    protected void loadComponents() {
        this.initRes();
        this.initUI();
    }

    public boolean isInvalidRange() {
        return false;
    }

    protected abstract JLabel getJLabelOther();

    public abstract JTextField getJTextFieldOther();

    protected abstract ComponentWithTitlebar<JComponent> getComponentWithTitlebar();

    public void initRes() {
        if (this.customBinning instanceof TransformationType.Binning.CustomDate || this.customBinning instanceof TransformationType.Binning.CustomTimestamp) {
            this.getJLabelOther().setVisible(false);
            this.getJTextFieldOther().setVisible(false);
        } else if (this.customBinning instanceof TransformationType.Binning.CustomCategorical) {
            this.getJLabelOther().setText(XformDialogsLrb.get("CUSTOM_BINNING_PANEL_OTHER"));
            this.getJLabelOther().setLabelFor(this.getJTextFieldOther());
        }
        if (_editIcon == null) {
            _editIcon = InspectorArb.getIcon((int)24);
        }
    }

    protected String getOther(TransformationType.Binning.CustomCategorical customCategorical) {
        String string = null;
        for (CategoricalBin categoricalBin : customCategorical.getCategoricalBin()) {
            if (!categoricalBin.isIsOther()) continue;
            string = categoricalBin.getName();
            break;
        }
        return string != null ? string : _default_other;
    }

    public void initUI() {
        this._jAttributesTable.setTooltipEnable(true);
        BinsTableModel binsTableModel = null;
        if (this.isCustomCategoricalBinning()) {
            binsTableModel = new BinsTableModel(BinningCustomBase.fromCustomCategoricaltoNameValuePairs(this.customBinning), false);
            if (null != this.getJTextFieldOther()) {
                this.getJTextFieldOther().setText(this.getOther((TransformationType.Binning.CustomCategorical)this.customBinning));
            }
        } else if (this.customBinning instanceof TransformationType.Binning.CustomNumeric) {
            binsTableModel = new BinsTableModel(BinningCustomBase.fromCustomNumerictoNameValuePairs(this.customBinning), true);
        } else if (this.customBinning instanceof TransformationType.Binning.CustomDate) {
            binsTableModel = new BinsTableModel(BinningCustomBase.fromCustomDatetoNameValuePairs(this.customBinning), false);
        } else if (this.customBinning instanceof TransformationType.Binning.CustomTimestamp) {
            binsTableModel = new BinsTableModel(BinningCustomBase.fromCustomTimestamptoNameValuePairs(this.customBinning), false);
        }
        this.resetBtn = new JButton(XformDialogsLrb.get("CUSTOM_RESET_BUTTON"));
        this.resetBtn.setToolTipText(XformDialogsLrb.get("TOOLTIP_CUSTOM_RESET_BUTTON"));
        this.removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this.removeBtn.setToolTipText(XformDialogsLrb.get("TOOLTIP_REMOVE_BIN_DEFINITION"));
        this.editBtn = new JButton(_editIcon);
        this.editBtn.setToolTipText(XformDialogsLrb.get("TOOLTIP_EDIT_BIN_DEFINITION"));
        this.addBtn = new JButton(DataMinerIcons.get(Icons.ADD));
        this.addBtn.setToolTipText(XformDialogsLrb.get("TOOLTIP_ADD_BIN_DEFINITION"));
        this.editBtn.setEnabled(false);
        this.removeBtn.setEnabled(false);
        this.addBtn.setEnabled(false);
        ControlBar controlBar = new ControlBar();
        controlBar.add((Component)this.resetBtn);
        controlBar.add((Component)this.editBtn);
        controlBar.add((Component)this.removeBtn);
        controlBar.add((Component)this.addBtn);
        this.setupItemsTable(binsTableModel, this._jAttributesTable);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this._jAttributesTable));
        this.getComponentWithTitlebar().setComponent((JComponent)jScrollPane);
        this.getComponentWithTitlebar().setLabel(new JLabel(XformDialogsLrb.get("CUSTOM_BINNING_PANEL_BIN_VALUES_TABLE")));
        if (this.customBinning instanceof TransformationType.Binning.CustomDate || this.customBinning instanceof TransformationType.Binning.CustomTimestamp) {
            this._jAttributesTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    ListSelectionModel listSelectionModel;
                    if (mouseEvent.getClickCount() == 2 && !(listSelectionModel = BinningCustomBase.this._jAttributesTable.getSelectionModel()).isSelectionEmpty() && listSelectionModel.getMinSelectionIndex() == listSelectionModel.getMaxSelectionIndex()) {
                        BinsTableModel binsTableModel;
                        Vector<NameValuePair> vector;
                        NameValuePair nameValuePair;
                        String string;
                        int[] nArray = BinningCustomBase.this._jAttributesTable.getSelectedRowsInModel();
                        if (nArray[0] == 0) {
                            return;
                        }
                        boolean bl = BinningCustomBase.this.customBinning instanceof TransformationType.Binning.CustomTimestamp;
                        SimpleDateFormat simpleDateFormat = bl ? TimeUtils.getShortSimpleDateFormatZoneRFC() : TimeUtils.getShortSimpleDateFormatRFC();
                        GregorianCalendar gregorianCalendar = BinningCustomBase.toDate(simpleDateFormat, string = (nameValuePair = (vector = (binsTableModel = (BinsTableModel)((Object)BinningCustomBase.this._jAttributesTable.getModel())).getDataVector()).get(nArray[0])).getValue().toString(), bl);
                        if (gregorianCalendar == null) {
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_DIALOG_OUT_OF_BOUNDS_BOUNDS"), (String)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                            return;
                        }
                        DatePickerDialog datePickerDialog = new DatePickerDialog();
                        if (datePickerDialog.invoke(gregorianCalendar, bl)) {
                            Calendar calendar = datePickerDialog.getCalendar();
                            Date date = calendar.getTime();
                            TimeZone timeZone = calendar.getTimeZone();
                            simpleDateFormat.setTimeZone(timeZone);
                            StringBuffer stringBuffer = new StringBuffer();
                            simpleDateFormat.format(date, stringBuffer, new FieldPosition(0));
                            binsTableModel.setValueAt(TimeUtils.removeGMT(stringBuffer.toString()), nArray[0], _BIN_VALUE);
                        }
                    }
                }
            });
        } else if (this.customBinning instanceof TransformationType.Binning.CustomCategorical) {
            this._jAttributesTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    ListSelectionModel listSelectionModel;
                    if (mouseEvent.getClickCount() == 2 && !(listSelectionModel = BinningCustomBase.this._jAttributesTable.getSelectionModel()).isSelectionEmpty() && listSelectionModel.getMinSelectionIndex() == listSelectionModel.getMaxSelectionIndex()) {
                        int[] nArray = BinningCustomBase.this._jAttributesTable.getSelectedRowsInModel();
                        BinsTableModel binsTableModel = (BinsTableModel)((Object)BinningCustomBase.this._jAttributesTable.getModel());
                        Vector<NameValuePair> vector = binsTableModel.getDataVector();
                        String string = BinningCustomBase.this.getJTextFieldOther().getText();
                        NameValuePair nameValuePair = vector.get(nArray[0]);
                        AddEditCategoricalBinAssignmentDlg addEditCategoricalBinAssignmentDlg = new AddEditCategoricalBinAssignmentDlg(BinningCustomBase.this._state.getContext());
                        if (addEditCategoricalBinAssignmentDlg.invoke(vector, BinningCustomBase.this._state.getDistinctValues(BinningCustomBase.this.srcColumnName), BinningCustomBase.this._state.getFrequencies(BinningCustomBase.this.srcColumnName), nameValuePair.getName(), string)) {
                            binsTableModel = new BinsTableModel(addEditCategoricalBinAssignmentDlg.getResults(), false);
                            BinningCustomBase.this.setupItemsTable(binsTableModel, BinningCustomBase.this._jAttributesTable);
                            BinningCustomBase.this.loadCustomCategoricBinning(addEditCategoricalBinAssignmentDlg.getResults());
                        }
                    }
                }
            });
        }
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Vector<NameValuePair> vector;
                int[] nArray = BinningCustomBase.this._jAttributesTable.getSelectedRowsInModel();
                BinsTableModel binsTableModel = (BinsTableModel)((Object)BinningCustomBase.this._jAttributesTable.getModel());
                Vector<NameValuePair> vector2 = binsTableModel.getDataVector();
                Vector<NameValuePair> vector3 = new Vector<NameValuePair>();
                for (int i = 0; i < nArray.length; ++i) {
                    vector3.add(vector2.get(nArray[i]));
                }
                Vector<NameValuePair> vector4 = new Vector<NameValuePair>();
                vector4.addAll(vector2);
                for (NameValuePair nameValuePair : vector3) {
                    vector4.remove(nameValuePair);
                }
                if (BinningCustomBase.this.isCustomNumericBinning()) {
                    vector = BinningCustomBase.this.adjustCustomNumericBinning(vector4);
                    BinningCustomBase.this.loadCustomNumericBinning(vector);
                    binsTableModel = new BinsTableModel(vector, true);
                } else if (BinningCustomBase.this.isCustomCategoricalBinning()) {
                    BinningCustomBase.this.loadCustomCategoricBinning(vector4);
                    binsTableModel = new BinsTableModel(vector4, false);
                } else if (BinningCustomBase.this.isCustomDateBinning()) {
                    vector = BinningCustomBase.this.adjustCustomDateBinning(vector4);
                    BinningCustomBase.this.loadCustomDateBinning(vector);
                    binsTableModel = new BinsTableModel(vector, false);
                } else if (BinningCustomBase.this.isCustomTimestampBinning()) {
                    vector = BinningCustomBase.this.adjustCustomDateBinning(vector4);
                    BinningCustomBase.this.loadCustomTimestampBinning(vector);
                    binsTableModel = new BinsTableModel(vector, false);
                }
                BinningCustomBase.this.setupItemsTable(binsTableModel, BinningCustomBase.this._jAttributesTable);
            }
        });
        this.editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NameValuePair nameValuePair;
                Object object;
                Object object2;
                Object object3;
                int[] nArray = BinningCustomBase.this._jAttributesTable.getSelectedRowsInModel();
                if (BinningCustomBase.this.isCustomNumericBinning()) {
                    BinningCustomBase.this._jAttributesTable.editCellAt(nArray[0], _BIN_VALUE, new EventObject((Object)BinningCustomBase.this._jAttributesTable));
                    object3 = (AbstractCellEditor)((Object)BinningCustomBase.this._jAttributesTable.getCellEditor(nArray[0], _BIN_VALUE));
                    ((AbstractCellEditor)object3).shouldSelectCell(new ListSelectionEvent((Object)BinningCustomBase.this._jAttributesTable, nArray[0], nArray[0], true));
                    object2 = BinningCustomBase.this._jAttributesTable.getEditorComponent();
                    WorkflowUtils.compositeRequestFocus((Component)object2);
                }
                if (BinningCustomBase.this.isCustomCategoricalBinning()) {
                    object3 = (BinsTableModel)((Object)BinningCustomBase.this._jAttributesTable.getModel());
                    object2 = object3.getDataVector();
                    object = BinningCustomBase.this.getJTextFieldOther().getText();
                    nameValuePair = ((Vector)object2).get(nArray[0]);
                    AddEditCategoricalBinAssignmentDlg addEditCategoricalBinAssignmentDlg = new AddEditCategoricalBinAssignmentDlg(BinningCustomBase.this._state.getContext());
                    if (addEditCategoricalBinAssignmentDlg.invoke((Vector<NameValuePair>)object2, BinningCustomBase.this._state.getDistinctValues(BinningCustomBase.this.srcColumnName), BinningCustomBase.this._state.getFrequencies(BinningCustomBase.this.srcColumnName), nameValuePair.getName(), (String)object)) {
                        object3 = new BinsTableModel(addEditCategoricalBinAssignmentDlg.getResults(), false);
                        BinningCustomBase.this.setupItemsTable((BinsTableModel)((Object)object3), BinningCustomBase.this._jAttributesTable);
                        BinningCustomBase.this.loadCustomCategoricBinning(addEditCategoricalBinAssignmentDlg.getResults());
                    }
                }
                if (!BinningCustomBase.this.isCustomDateBinning() && !BinningCustomBase.this.isCustomTimestampBinning()) {
                    return;
                }
                object3 = BinningCustomBase.this._jAttributesTable.getSelectionModel();
                if (!object3.isSelectionEmpty() && object3.getMinSelectionIndex() == object3.getMaxSelectionIndex()) {
                    String string;
                    boolean bl = BinningCustomBase.this.customBinning instanceof TransformationType.Binning.CustomTimestamp;
                    SimpleDateFormat simpleDateFormat = bl ? TimeUtils.getShortSimpleDateFormatZoneRFC() : TimeUtils.getShortSimpleDateFormatRFC();
                    GregorianCalendar gregorianCalendar = BinningCustomBase.toDate(simpleDateFormat, string = (nameValuePair = (NameValuePair)((Vector)(object = ((BinsTableModel)((Object)(object2 = (BinsTableModel)((Object)BinningCustomBase.this._jAttributesTable.getModel())))).getDataVector())).get(nArray[0])).getValue().toString(), bl);
                    if (gregorianCalendar == null) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_DIALOG_OUT_OF_BOUNDS_BOUNDS"), (String)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                        return;
                    }
                    DatePickerDialog datePickerDialog = new DatePickerDialog();
                    if (datePickerDialog.invoke(gregorianCalendar, bl)) {
                        Calendar calendar = datePickerDialog.getCalendar();
                        Date date = calendar.getTime();
                        TimeZone timeZone = calendar.getTimeZone();
                        simpleDateFormat.setTimeZone(timeZone);
                        StringBuffer stringBuffer = new StringBuffer();
                        simpleDateFormat.format(date, stringBuffer, new FieldPosition(0));
                        ((BinsTableModel)((Object)object2)).setValueAt(TimeUtils.removeGMT(stringBuffer.toString()), nArray[0], _BIN_VALUE);
                    }
                }
            }
        });
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = BinningCustomBase.this._jAttributesTable.getSelectedRowsInModel();
                BinsTableModel binsTableModel = (BinsTableModel)((Object)BinningCustomBase.this._jAttributesTable.getModel());
                Vector<NameValuePair> vector = binsTableModel.getDataVector();
                if (BinningCustomBase.this.isCustomNumericBinning()) {
                    NameValuePair nameValuePair = vector.get(nArray[0]);
                    NameValuePair nameValuePair2 = vector.get(nArray[0] - 1);
                    Object object = nameValuePair.getValue();
                    Object object2 = nameValuePair2.getValue();
                    Vector<NameValuePair> vector2 = new Vector<NameValuePair>();
                    vector2.addAll(vector);
                    Double d = (Double.valueOf(object.toString()) + Double.valueOf(object2.toString())) / 2.0;
                    NameValuePair nameValuePair3 = new NameValuePair(d + " - " + object, (Object)d.toString(), 0);
                    int n = vector2.indexOf(nameValuePair2);
                    vector2.add(n + 1, nameValuePair3);
                    Vector<NameValuePair> vector3 = BinningCustomBase.this.adjustCustomNumericBinning(vector2);
                    BinningCustomBase.this.loadCustomNumericBinning(vector3);
                    binsTableModel = new BinsTableModel(vector3, true);
                    BinningCustomBase.this.setupItemsTable(binsTableModel, BinningCustomBase.this._jAttributesTable);
                    vector = binsTableModel.getDataVector();
                    int n2 = -1;
                    for (int i = 0; i < vector.size(); ++i) {
                        NameValuePair nameValuePair4 = vector.get(i);
                        if (!nameValuePair4.getName().equals(nameValuePair3.getName()) || !nameValuePair4.getValue().equals(nameValuePair3.getValue())) continue;
                        n2 = i;
                        break;
                    }
                    if (n2 != -1) {
                        BinningCustomBase.this._jAttributesTable.setSelectedRowInModel(n2);
                    }
                } else if (BinningCustomBase.this.isCustomDateBinning() || BinningCustomBase.this.isCustomTimestampBinning()) {
                    NameValuePair nameValuePair = vector.get(nArray[0]);
                    NameValuePair nameValuePair5 = vector.get(nArray[0] - 1);
                    Object object = nameValuePair.getValue();
                    Object object3 = nameValuePair5.getValue();
                    Vector<NameValuePair> vector4 = new Vector<NameValuePair>();
                    vector4.addAll(vector);
                    boolean bl = BinningCustomBase.this.customBinning instanceof TransformationType.Binning.CustomTimestamp;
                    SimpleDateFormat simpleDateFormat = bl ? TimeUtils.getShortSimpleDateFormatZone() : TimeUtils.getShortSimpleDateFormat();
                    GregorianCalendar gregorianCalendar = BinningCustomBase.toDate(simpleDateFormat, object, BinningCustomBase.this.isCustomTimestampBinning());
                    GregorianCalendar gregorianCalendar2 = BinningCustomBase.toDate(simpleDateFormat, object3, BinningCustomBase.this.isCustomTimestampBinning());
                    Date date = new Date((gregorianCalendar.getTimeInMillis() + gregorianCalendar2.getTimeInMillis()) / 2L);
                    StringBuffer stringBuffer = new StringBuffer();
                    simpleDateFormat.format(date, stringBuffer, new FieldPosition(0));
                    String string = stringBuffer.toString();
                    NameValuePair nameValuePair6 = new NameValuePair(string + " - " + object, (Object)string.toString(), 0);
                    int n = vector4.indexOf(nameValuePair5);
                    vector4.add(n + 1, nameValuePair6);
                    Vector<NameValuePair> vector5 = BinningCustomBase.this.adjustCustomDateBinning(vector4);
                    if (bl) {
                        BinningCustomBase.this.loadCustomTimestampBinning(vector5);
                    } else {
                        BinningCustomBase.this.loadCustomDateBinning(vector5);
                    }
                    binsTableModel = new BinsTableModel(vector5, true);
                    BinningCustomBase.this.setupItemsTable(binsTableModel, BinningCustomBase.this._jAttributesTable);
                    vector = binsTableModel.getDataVector();
                    int n3 = -1;
                    for (int i = 0; i < vector.size(); ++i) {
                        NameValuePair nameValuePair7 = vector.get(i);
                        if (!nameValuePair7.getName().equals(nameValuePair6.getName()) || !nameValuePair7.getValue().equals(nameValuePair6.getValue())) continue;
                        n3 = i;
                        break;
                    }
                    if (n3 != -1) {
                        BinningCustomBase.this._jAttributesTable.setSelectedRowInModel(n3);
                    }
                } else if (BinningCustomBase.this.isCustomCategoricalBinning()) {
                    String string = BinningCustomBase.this.getJTextFieldOther().getText();
                    AddEditCategoricalBinAssignmentDlg addEditCategoricalBinAssignmentDlg = new AddEditCategoricalBinAssignmentDlg(BinningCustomBase.this._state.getContext());
                    if (addEditCategoricalBinAssignmentDlg.invoke(vector, BinningCustomBase.this._state.getDistinctValues(BinningCustomBase.this.srcColumnName), null, string)) {
                        binsTableModel = new BinsTableModel(addEditCategoricalBinAssignmentDlg.getResults(), false);
                        BinningCustomBase.this.setupItemsTable(binsTableModel, BinningCustomBase.this._jAttributesTable);
                        BinningCustomBase.this.loadCustomCategoricBinning(addEditCategoricalBinAssignmentDlg.getResults());
                    }
                }
            }
        });
        this.getComponentWithTitlebar().setControlBar(controlBar);
        this._jAttributesTable.setFillsViewportHeight(true);
        this.resetBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenerateDefaultBinsDialog generateDefaultBinsDialog = new GenerateDefaultBinsDialog(BinningCustomBase.this.dataType);
                int n = BinningCustomBase.this.getBinCount();
                if (n <= 0) {
                    n = 10;
                }
                if (generateDefaultBinsDialog.invoke(BinningCustomBase.this.srcColumnName, BinningCustomBase.this.srcColumnType, BinningCustomBase.this._state, n)) {
                    TransformationType transformationType = generateDefaultBinsDialog.getResultTransformationType();
                    LoadingBinsTableModel loadingBinsTableModel = new LoadingBinsTableModel();
                    BinningCustomBase.this.setupItemsTable(loadingBinsTableModel, BinningCustomBase.this._jAttributesTable);
                    LoadDefaultBins loadDefaultBins = new LoadDefaultBins(transformationType);
                    loadDefaultBins.execute();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activateDlg() {
        block40: {
            if (this.isCustomCategoricalBinning() ? this.customBinning != null && null != ((TransformationType.Binning.CustomCategorical)this.customBinning).getCategoricalBin() && !((TransformationType.Binning.CustomCategorical)this.customBinning).getCategoricalBin().isEmpty() : (this.isCustomNumericBinning() ? this.customBinning != null && null != ((TransformationType.Binning.CustomNumeric)this.customBinning).getNumericBin() && !((TransformationType.Binning.CustomNumeric)this.customBinning).getNumericBin().isEmpty() : (this.isCustomDateBinning() ? this.customBinning != null && null != ((TransformationType.Binning.CustomDate)this.customBinning).getDateBin() && !((TransformationType.Binning.CustomDate)this.customBinning).getDateBin().isEmpty() : this.isCustomTimestampBinning() && this.customBinning != null && null != ((TransformationType.Binning.CustomTimestamp)this.customBinning).getTimestampTimezoneBin() && !((TransformationType.Binning.CustomTimestamp)this.customBinning).getTimestampTimezoneBin().isEmpty()))) {
                return;
            }
            GenerateDefaultBinsDialog generateDefaultBinsDialog = new GenerateDefaultBinsDialog(this.dataType);
            int n = this.getBinCount();
            if (n <= 0) {
                n = 10;
            }
            if (!generateDefaultBinsDialog.invoke(this.srcColumnName, this.srcColumnType, this._state, n)) break block40;
            TransformationType transformationType = generateDefaultBinsDialog.getResultTransformationType();
            String string = null;
            Vector<NameValuePair> vector = null;
            Cursor cursor = this.getCursor();
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                vector = this._state.generateDefaultBinsXform(this.srcColumnName, this.srcColumnType, transformationType.getBinning());
                if (vector == null || vector.isEmpty()) {
                    string = XformDialogsLrb.get("CUSTOM_BINNING_PANEL_NO_BINS");
                } else {
                    Object object;
                    BinsTableModel binsTableModel = null;
                    if (null != transformationType.getBinning().getEqualWidth() || null != transformationType.getBinning().getQuantile()) {
                        binsTableModel = new BinsTableModel(vector, true);
                        this.loadCustomNumericBinning(vector);
                        object = null != transformationType.getBinning().getEqualWidth() ? transformationType.getBinning().getEqualWidth().getBinLabels() : transformationType.getBinning().getQuantile().getBinLabels();
                        TransformationType.Binning.CustomNumeric customNumeric = (TransformationType.Binning.CustomNumeric)this.customBinning;
                        BinLabels binLabels = new BinLabels();
                        if (null != object.getNumberSequence()) {
                            binLabels.setNumberSequence(new BinLabels.NumberSequence());
                        } else {
                            binLabels.setRange(new BinLabels.Range());
                        }
                        customNumeric.setBinLabels(binLabels);
                    } else if (null != transformationType.getBinning().getTopN()) {
                        int n2 = -1;
                        for (int i = 0; i < vector.size(); ++i) {
                            if (!vector.get(i).getName().equals(TransformationStatisticsState.LIST_OF_DISTINCT_VALUES)) continue;
                            n2 = i;
                            break;
                        }
                        if (n2 != -1) {
                            this._state.setDistinctValuesFrequencies(this.srcColumnName, ConverterHelper.objectToNameValuePairList(vector.get(n2).getValue()));
                            vector.remove(n2);
                        }
                        binsTableModel = new BinsTableModel(vector, false);
                        this.loadCustomCategoricBinning(vector);
                    } else if (null != transformationType.getBinning().getDateEqualWidth()) {
                        TransformationType.Binning.CustomDate customDate;
                        binsTableModel = new BinsTableModel(vector, false);
                        BinLabels binLabels = transformationType.getBinning().getDateEqualWidth().getBinLabels();
                        if (this.customBinning instanceof TransformationType.Binning.CustomDate) {
                            this.loadCustomDateBinning(vector);
                            customDate = (TransformationType.Binning.CustomDate)this.customBinning;
                            BinLabels binLabels2 = new BinLabels();
                            if (null != binLabels.getNumberSequence()) {
                                binLabels2.setNumberSequence(new BinLabels.NumberSequence());
                            } else {
                                binLabels2.setRange(new BinLabels.Range());
                            }
                            customDate.setBinLabels(binLabels2);
                        } else if (this.customBinning instanceof TransformationType.Binning.CustomTimestamp) {
                            this.loadCustomTimestampBinning(vector);
                            customDate = (TransformationType.Binning.CustomTimestamp)this.customBinning;
                            BinLabels binLabels3 = new BinLabels();
                            if (null != binLabels.getNumberSequence()) {
                                binLabels3.setNumberSequence(new BinLabels.NumberSequence());
                            } else {
                                binLabels3.setRange(new BinLabels.Range());
                            }
                            customDate.setBinLabels(binLabels3);
                        }
                    } else if (null != transformationType.getBinning().getTimestampEqualWidth()) {
                        TransformationType.Binning.CustomDate customDate;
                        binsTableModel = new BinsTableModel(vector, false);
                        BinLabels binLabels = transformationType.getBinning().getTimestampEqualWidth().getBinLabels();
                        if (this.customBinning instanceof TransformationType.Binning.CustomDate) {
                            this.loadCustomDateBinning(vector);
                            customDate = (TransformationType.Binning.CustomDate)this.customBinning;
                            BinLabels binLabels4 = new BinLabels();
                            if (null != binLabels.getNumberSequence()) {
                                binLabels4.setNumberSequence(new BinLabels.NumberSequence());
                            } else {
                                binLabels4.setRange(new BinLabels.Range());
                            }
                            customDate.setBinLabels(binLabels4);
                        } else if (this.customBinning instanceof TransformationType.Binning.CustomTimestamp) {
                            this.loadCustomTimestampBinning(vector);
                            customDate = (TransformationType.Binning.CustomTimestamp)this.customBinning;
                            BinLabels binLabels5 = new BinLabels();
                            if (null != binLabels.getNumberSequence()) {
                                binLabels5.setNumberSequence(new BinLabels.NumberSequence());
                            } else {
                                binLabels5.setRange(new BinLabels.Range());
                            }
                            customDate.setBinLabels(binLabels5);
                        }
                    } else if (null != transformationType.getBinning().getCustomTimestamp()) {
                        binsTableModel = new BinsTableModel(vector, false);
                        this.loadCustomTimestampBinning(vector);
                        BinLabels binLabels = transformationType.getBinning().getDateEqualWidth().getBinLabels();
                        TransformationType.Binning.CustomTimestamp customTimestamp = (TransformationType.Binning.CustomTimestamp)this.customBinning;
                        BinLabels binLabels6 = new BinLabels();
                        if (null != binLabels.getNumberSequence()) {
                            binLabels6.setNumberSequence(new BinLabels.NumberSequence());
                        } else {
                            binLabels6.setRange(new BinLabels.Range());
                        }
                        customTimestamp.setBinLabels(binLabels6);
                    }
                    if (binsTableModel != null) {
                        this.setupItemsTable(binsTableModel, this._jAttributesTable);
                    }
                    if (this.isCustomCategoricalBinning()) {
                        object = this._jAttributesTable.getSelectedRowsInModel();
                        boolean bl = object != null && ((BinLabels)object).length > 0;
                        this.editBtn.setEnabled(bl);
                    }
                }
                this.setCursor(cursor != null ? cursor : Cursor.getPredefinedCursor(0));
            }
            catch (Exception exception) {
                try {
                    string = exception.getMessage();
                    this.setCursor(cursor != null ? cursor : Cursor.getPredefinedCursor(0));
                }
                catch (Throwable throwable) {
                    this.setCursor(cursor != null ? cursor : Cursor.getPredefinedCursor(0));
                    throw throwable;
                }
            }
            if (string != null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                return;
            }
        }
    }

    protected void setupItemsTable(BinsTableModel binsTableModel, GenericTable genericTable) {
        genericTable.setModel((TableModel)((Object)binsTableModel));
        genericTable.setSorted(true);
        genericTable.setSortColumn(_BIN_NAME, true);
        genericTable.getSelectionModel().addListSelectionListener(new SelectedItemSelectionHandler(genericTable));
        if (this.isCustomCategoricalBinning()) {
            boolean bl = false;
            int[] nArray = this._jAttributesTable.getSelectedRowsInModel();
            if (nArray != null && nArray.length > 0 && nArray.length == 1) {
                bl = nArray[0] != 0;
            }
            this.editBtn.setEnabled(bl);
        }
    }

    @Override
    public boolean isAuto() {
        return false;
    }

    @Override
    public void setAuto(boolean bl) {
    }

    @Override
    public boolean isLabels() {
        TransformationType.Binning.CustomNumeric customNumeric;
        return !(this.customBinning instanceof TransformationType.Binning.CustomNumeric) || null == (customNumeric = (TransformationType.Binning.CustomNumeric)this.customBinning).getBinLabels().getNumberSequence();
    }

    @Override
    public void setLabels(boolean bl) {
        if (this.customBinning instanceof TransformationType.Binning.CustomNumeric) {
            TransformationType.Binning.CustomNumeric customNumeric = (TransformationType.Binning.CustomNumeric)this.customBinning;
            if (bl) {
                customNumeric.getBinLabels().setRange(new BinLabels.Range());
            } else {
                customNumeric.getBinLabels().setNumberSequence(new BinLabels.NumberSequence());
            }
        }
    }

    @Override
    public Integer getBinCount() {
        if (this.customBinning != null) {
            Integer n;
            BinsTableModel binsTableModel = (BinsTableModel)((Object)this._jAttributesTable.getModel());
            Vector<NameValuePair> vector = binsTableModel.getDataVector();
            Integer n2 = n = vector != null && vector.size() > 0 ? Integer.valueOf(vector.size()) : Integer.valueOf(0);
            if (n > 0 && this.isCustomCategoricalBinning()) {
                n = n + 1;
            }
            return n;
        }
        return 0;
    }

    @Override
    public void setBinCount(Integer n) {
    }

    public boolean isCustomBinning() {
        return this.customBinning != null;
    }

    public boolean isCustomNumericBinning() {
        if (this.isCustomBinning()) {
            return this.customBinning instanceof TransformationType.Binning.CustomNumeric;
        }
        return false;
    }

    public boolean isCustomCategoricalBinning() {
        if (this.isCustomBinning()) {
            return this.customBinning instanceof TransformationType.Binning.CustomCategorical;
        }
        return false;
    }

    public boolean isCustomDateBinning() {
        if (this.isCustomBinning()) {
            return this.customBinning instanceof TransformationType.Binning.CustomDate;
        }
        return false;
    }

    public boolean isCustomTimestampBinning() {
        if (this.isCustomBinning()) {
            return this.customBinning instanceof TransformationType.Binning.CustomTimestamp;
        }
        return false;
    }

    public Object getCustomBinning() {
        if (this.isCustomCategoricalBinning()) {
            CategoricalBin categoricalBin2;
            TransformationType.Binning.CustomCategorical customCategorical = (TransformationType.Binning.CustomCategorical)this.customBinning;
            List list = customCategorical.getCategoricalBin();
            String string = this.getJTextFieldOther().getText();
            if (string == null) {
                string = _default_other;
            }
            boolean bl = false;
            for (CategoricalBin categoricalBin2 : list) {
                if (!categoricalBin2.isIsOther()) continue;
                categoricalBin2.setName(string);
                bl = true;
                break;
            }
            if (bl) {
                return this.customBinning;
            }
            CategoricalBin categoricalBin3 = new CategoricalBin();
            categoricalBin3.setName(string);
            categoricalBin2 = new StringCollection();
            categoricalBin2.getValue().add(string);
            categoricalBin3.setStringCollectionValues((StringCollection)categoricalBin2);
            categoricalBin3.setIsOther(true);
            list.add(categoricalBin3);
        }
        return this.customBinning;
    }

    protected void loadCustomNumericBinning(List<NameValuePair> list) {
        Vector<NameValuePair> vector = new Vector<NameValuePair>();
        vector.addAll(list);
        this.loadCustomNumericBinning(vector);
    }

    protected void loadCustomNumericBinning(Vector<NameValuePair> vector) {
        if (!this.isCustomNumericBinning()) {
            return;
        }
        TransformationType.Binning.CustomNumeric customNumeric = (TransformationType.Binning.CustomNumeric)this.customBinning;
        List list = customNumeric.getNumericBin();
        list.clear();
        for (int i = 0; i < vector.size(); ++i) {
            NameValuePair nameValuePair = vector.get(i);
            NumericBin numericBin = new NumericBin();
            numericBin.setBinName(nameValuePair.getName());
            Object object = nameValuePair.getValue();
            if (object.equals(TransformationStatisticsState.NO_LOWER_BOUND)) continue;
            try {
                Double d = Double.valueOf(object.toString());
                numericBin.setLowerBound(d.doubleValue());
            }
            catch (Exception exception) {
                continue;
            }
            list.add(numericBin);
        }
    }

    protected Vector<NameValuePair> adjustCustomNumericBinning(Vector<NameValuePair> vector) {
        if (!this.isCustomNumericBinning()) {
            return null;
        }
        boolean bl = null != ((TransformationType.Binning.CustomNumeric)this.customBinning).getBinLabels().getNumberSequence();
        Vector<NameValuePair> vector2 = new Vector<NameValuePair>();
        Object object = null;
        int n = 1;
        for (int i = 0; i < vector.size(); ++i) {
            NameValuePair nameValuePair = vector.get(i);
            Object object2 = nameValuePair.getValue();
            NameValuePair nameValuePair2 = null;
            if (bl) {
                nameValuePair2 = new NameValuePair(String.valueOf(n), object2, n++);
            } else {
                if (TransformationStatisticsState.NO_LOWER_BOUND.equals(object2)) continue;
                if (object == null) {
                    object = object2;
                }
                if (i < vector.size() - 1) {
                    NameValuePair nameValuePair3 = vector.get(i + 1);
                    nameValuePair2 = new NameValuePair(object2.toString() + " - " + nameValuePair3.getValue().toString(), object2, n++);
                } else {
                    nameValuePair2 = new NameValuePair(object2.toString() + " - " + TransformationStatisticsState.UNBOUNDED, object2, n++);
                }
            }
            vector2.add(nameValuePair2);
        }
        if (!bl) {
            vector2.add(0, new NameValuePair(TransformationStatisticsState.UNBOUNDED + " - " + object, (Object)TransformationStatisticsState.NO_LOWER_BOUND, 0));
        }
        return vector2;
    }

    private void loadCustomCategoricBinning(Vector<NameValuePair> vector) {
        if (!this.isCustomCategoricalBinning()) {
            return;
        }
        TransformationType.Binning.CustomCategorical customCategorical = (TransformationType.Binning.CustomCategorical)this.customBinning;
        List list = customCategorical.getCategoricalBin();
        list.clear();
        for (int i = 0; i < vector.size(); ++i) {
            NameValuePair nameValuePair = vector.get(i);
            CategoricalBin categoricalBin = new CategoricalBin();
            categoricalBin.setName(nameValuePair.getName());
            StringCollection stringCollection = new StringCollection();
            List<String> list2 = ConverterHelper.objectToStringList(nameValuePair.getValue());
            for (String string : list2) {
                stringCollection.getValue().add(string);
            }
            categoricalBin.setStringCollectionValues(stringCollection);
            categoricalBin.setIsOther(false);
            list.add(categoricalBin);
        }
    }

    protected void loadCustomTimestampBinning(List<NameValuePair> list) {
        Vector<NameValuePair> vector = new Vector<NameValuePair>();
        vector.addAll(list);
        this.loadCustomTimestampBinning(vector);
    }

    private void loadCustomTimestampBinning(Vector<NameValuePair> vector) {
        if (!this.isCustomTimestampBinning()) {
            return;
        }
        TransformationType.Binning.CustomTimestamp customTimestamp = (TransformationType.Binning.CustomTimestamp)this.customBinning;
        List list = customTimestamp.getTimestampTimezoneBin();
        list.clear();
        for (int i = 0; i < vector.size(); ++i) {
            NameValuePair nameValuePair = vector.get(i);
            TimestampTimezoneBin timestampTimezoneBin = new TimestampTimezoneBin();
            timestampTimezoneBin.setName(nameValuePair.getName());
            TimestampTimezoneBin.LowerBound lowerBound = new TimestampTimezoneBin.LowerBound();
            try {
                if (nameValuePair.getValue().equals(TransformationStatisticsState.NO_LOWER_BOUND)) {
                    lowerBound.setValue(null);
                } else {
                    if (nameValuePair.getValue() == null) continue;
                    GregorianCalendar gregorianCalendar = BinningCustomBase.toDate(TimeUtils.getShortSimpleDateFormatZoneRFC(), nameValuePair.getValue().toString(), true);
                    lowerBound.setValue(TimeUtils.Date2XMLDate(gregorianCalendar));
                }
                timestampTimezoneBin.setLowerBound(lowerBound);
                list.add(timestampTimezoneBin);
                continue;
            }
            catch (Exception exception) {
                theLogger.log(Level.FINEST, exception.getLocalizedMessage(), exception);
            }
        }
    }

    protected void loadCustomDateBinning(List<NameValuePair> list) {
        Vector<NameValuePair> vector = new Vector<NameValuePair>();
        vector.addAll(list);
        this.loadCustomDateBinning(vector);
    }

    private void loadCustomDateBinning(Vector<NameValuePair> vector) {
        if (!this.isCustomDateBinning()) {
            return;
        }
        TransformationType.Binning.CustomDate customDate = (TransformationType.Binning.CustomDate)this.customBinning;
        List list = customDate.getDateBin();
        list.clear();
        for (int i = 0; i < vector.size(); ++i) {
            NameValuePair nameValuePair = vector.get(i);
            DateBin dateBin = new DateBin();
            dateBin.setName(nameValuePair.getName());
            DateBin.LowerBound lowerBound = new DateBin.LowerBound();
            try {
                if (nameValuePair.getValue().equals(TransformationStatisticsState.NO_LOWER_BOUND)) {
                    lowerBound.setValue(null);
                } else {
                    Date date = TimeUtils.getShortSimpleDateFormat().parse(nameValuePair.getValue().toString(), new ParsePosition(0));
                    if (date == null) continue;
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setTimeInMillis(date.getTime());
                    lowerBound.setValue(TimeUtils.Date2XMLDate(gregorianCalendar));
                }
                dateBin.setLowerBound(lowerBound);
                list.add(dateBin);
                continue;
            }
            catch (Exception exception) {
                theLogger.log(Level.FINEST, exception.getLocalizedMessage(), exception);
            }
        }
    }

    protected Vector<NameValuePair> adjustCustomDateBinning(Vector<NameValuePair> vector) {
        if (!this.isCustomDateBinning() && this.isCustomTimestampBinning()) {
            return null;
        }
        boolean bl = this.isCustomDateBinning() ? null != ((TransformationType.Binning.CustomDate)this.customBinning).getBinLabels().getNumberSequence() : null != ((TransformationType.Binning.CustomTimestamp)this.customBinning).getBinLabels().getNumberSequence();
        Vector<NameValuePair> vector2 = new Vector<NameValuePair>();
        Object object = null;
        int n = 1;
        for (int i = 0; i < vector.size(); ++i) {
            NameValuePair nameValuePair = vector.get(i);
            Object object2 = nameValuePair.getValue();
            NameValuePair nameValuePair2 = null;
            if (bl) {
                nameValuePair2 = new NameValuePair(String.valueOf(n), object2, n++);
            } else {
                if (TransformationStatisticsState.NO_LOWER_BOUND.equals(object2)) continue;
                if (object == null) {
                    object = object2;
                }
                if (i < vector.size() - 1) {
                    NameValuePair nameValuePair3 = vector.get(i + 1);
                    nameValuePair2 = new NameValuePair(object2.toString() + " - " + nameValuePair3.getValue().toString(), object2, n++);
                } else {
                    nameValuePair2 = new NameValuePair(object2.toString() + " - " + TransformationStatisticsState.UNBOUNDED, object2, n++);
                }
            }
            vector2.add(nameValuePair2);
        }
        if (!bl) {
            vector2.add(0, new NameValuePair(TransformationStatisticsState.UNBOUNDED + " - " + object, (Object)TransformationStatisticsState.NO_LOWER_BOUND, 0));
        }
        return vector2;
    }

    @Override
    public String getSelectedBinngType() {
        return this.binningType;
    }

    private static Vector<NameValuePair> fromCustomTimestamptoNameValuePairs(Object object) {
        assert (object instanceof TransformationType.Binning.CustomTimestamp);
        TransformationType.Binning.CustomTimestamp customTimestamp = (TransformationType.Binning.CustomTimestamp)object;
        Vector<NameValuePair> vector = new Vector<NameValuePair>();
        int n = 1;
        for (TimestampTimezoneBin timestampTimezoneBin : customTimestamp.getTimestampTimezoneBin()) {
            SimpleDateFormat simpleDateFormat = TimeUtils.getShortSimpleDateFormatZone();
            StringBuffer stringBuffer = new StringBuffer();
            if (null == timestampTimezoneBin.getLowerBound().getValue() && n == 1) {
                vector.add(0, new NameValuePair(timestampTimezoneBin.getName(), (Object)TransformationStatisticsState.NO_LOWER_BOUND, 0));
                continue;
            }
            GregorianCalendar gregorianCalendar = timestampTimezoneBin.getLowerBound().getValue().toGregorianCalendar();
            simpleDateFormat.setTimeZone(gregorianCalendar.getTimeZone());
            Date date = gregorianCalendar.getTime();
            simpleDateFormat.format(date, stringBuffer, new FieldPosition(0));
            String string = TimeUtils.removeGMT(stringBuffer.toString());
            NameValuePair nameValuePair = new NameValuePair(timestampTimezoneBin.getName(), (Object)string, n++);
            vector.add(nameValuePair);
        }
        return vector;
    }

    private static Vector<NameValuePair> fromCustomDatetoNameValuePairs(Object object) {
        assert (object instanceof TransformationType.Binning.CustomDate);
        TransformationType.Binning.CustomDate customDate = (TransformationType.Binning.CustomDate)object;
        Vector<NameValuePair> vector = new Vector<NameValuePair>();
        int n = 1;
        for (DateBin dateBin : customDate.getDateBin()) {
            SimpleDateFormat simpleDateFormat = TimeUtils.getShortSimpleDateFormat();
            StringBuffer stringBuffer = new StringBuffer();
            if (null == dateBin.getLowerBound().getValue() && n == 1) {
                vector.add(0, new NameValuePair(dateBin.getName(), (Object)TransformationStatisticsState.NO_LOWER_BOUND, 0));
                continue;
            }
            Date date = dateBin.getLowerBound().getValue().toGregorianCalendar().getTime();
            StringBuffer stringBuffer2 = simpleDateFormat.format(date, stringBuffer, new FieldPosition(0));
            NameValuePair nameValuePair = new NameValuePair(dateBin.getName(), (Object)stringBuffer2.toString(), n++);
            vector.add(nameValuePair);
        }
        return vector;
    }

    private static Vector<NameValuePair> fromCustomCategoricaltoNameValuePairs(Object object) {
        assert (object instanceof TransformationType.Binning.CustomCategorical);
        TransformationType.Binning.CustomCategorical customCategorical = (TransformationType.Binning.CustomCategorical)object;
        Vector<NameValuePair> vector = new Vector<NameValuePair>();
        int n = 1;
        for (CategoricalBin categoricalBin : customCategorical.getCategoricalBin()) {
            if (categoricalBin.isIsOther()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : categoricalBin.getStringCollectionValues().getValue()) {
                arrayList.add(string);
            }
            NameValuePair nameValuePair = new NameValuePair(categoricalBin.getName(), arrayList, n++);
            vector.add(nameValuePair);
        }
        return vector;
    }

    private static Vector<NameValuePair> fromCustomNumerictoNameValuePairs(Object object) {
        assert (object instanceof TransformationType.Binning.CustomNumeric);
        TransformationType.Binning.CustomNumeric customNumeric = (TransformationType.Binning.CustomNumeric)object;
        Vector<NameValuePair> vector = new Vector<NameValuePair>();
        int n = 1;
        for (NumericBin numericBin : customNumeric.getNumericBin()) {
            if (n == 1) {
                if (null != customNumeric.getBinLabels().getRange()) {
                    vector.add(0, new NameValuePair(TransformationStatisticsState.UNBOUNDED + " - " + numericBin.getLowerBound(), (Object)TransformationStatisticsState.NO_LOWER_BOUND, 0));
                } else {
                    vector.add(0, new NameValuePair("1", (Object)TransformationStatisticsState.NO_LOWER_BOUND, 0));
                }
            }
            NameValuePair nameValuePair = new NameValuePair(numericBin.getBinName(), (Object)numericBin.getLowerBound(), n++);
            vector.add(nameValuePair);
        }
        return vector;
    }

    private static String gettzString(String string) {
        String string2 = TimeUtils.GMT;
        int n = string.indexOf(string2);
        if (n == -1 && (n = string.lastIndexOf(string2 = "+")) == -1) {
            string2 = "-";
            n = string.lastIndexOf(string2);
        }
        if (n == -1) {
            return null;
        }
        String string3 = string.substring(n + string2.length(), string.length());
        string3 = !string2.equals(TimeUtils.GMT) ? TimeUtils.GMT + string2 + string3 : TimeUtils.GMT + string3;
        return string3;
    }

    private static String getGMTString(String string) {
        String string2 = TimeUtils.GMT;
        int n = string.indexOf(string2);
        if (n == -1) {
            string2 = "+";
            n = string.lastIndexOf(string2);
            if (n == -1) {
                string2 = "-";
                n = string.lastIndexOf(string2);
            }
        } else {
            return string;
        }
        if (n == -1) {
            return null;
        }
        String string3 = string.substring(n + string2.length(), string.length());
        string3 = !string2.equals(TimeUtils.GMT) ? TimeUtils.GMT + string2 + string3 : TimeUtils.GMT + string3;
        String string4 = string.substring(0, n) + string3;
        return string4;
    }

    public static GregorianCalendar toDate(DateFormat dateFormat, Object object, boolean bl) {
        Object object2;
        String string = object.toString();
        String string2 = null;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        if (bl) {
            object2 = BinningCustomBase.gettzString(string);
            TimeZone timeZone = null;
            timeZone = object2 != null ? TimeZone.getTimeZone((String)object2) : TimeZone.getDefault();
            dateFormat.setTimeZone(timeZone);
            gregorianCalendar.setTimeZone(timeZone);
            string2 = BinningCustomBase.getGMTString(string);
        } else {
            string2 = string;
        }
        try {
            object2 = dateFormat.parse(string2);
            gregorianCalendar.setTime((Date)object2);
        }
        catch (Exception exception) {
            gregorianCalendar = null;
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return gregorianCalendar;
    }

    static /* synthetic */ String[] access$702(BinningCustomBase binningCustomBase, String[] stringArray) {
        binningCustomBase._columnNames = stringArray;
        return stringArray;
    }

    static {
        _default_other = XformDialogsLrb.get("CUSTOM_BINNING_PANEL_OTHER_DEFAULT");
        _status = XformDialogsLrb.get("CUSTOM_BINNING_PANEL_STATUS");
        _loading = XformDialogsLrb.get("CUSTOM_BINNING_PANEL_STATUS_LOADING");
        _bin_names = XformDialogsLrb.get("CUSTOM_BINNING_PANEL_BIN_NAMES");
        _bin_values = XformDialogsLrb.get("CUSTOM_BINNING_PANEL_BIN_VALUES");
        _bin_Lower_bound = XformDialogsLrb.get("CUSTOM_BINNING_PANEL_LOWER_BOUND");
        _BIN_NAME = 0;
        _BIN_VALUE = 1;
    }

    class SelectedItemSelectionHandler
    implements ListSelectionListener {
        GenericTable jAttributesTable;

        SelectedItemSelectionHandler(GenericTable genericTable) {
            this.jAttributesTable = genericTable;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            BinsTableModel binsTableModel = (BinsTableModel)((Object)this.jAttributesTable.getModel());
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            if (listSelectionModel.isSelectionEmpty()) {
                bl = false;
                bl2 = false;
                bl3 = false;
            } else {
                int n = binsTableModel.getRowCount();
                int[] nArray = this.jAttributesTable.getSelectedRowsInModel();
                if (nArray != null && nArray.length > 0) {
                    if (nArray.length == 1) {
                        boolean bl4 = bl3 = nArray[0] != 0;
                        if (!BinningCustomBase.this.isCustomCategoricalBinning()) {
                            bl2 = nArray[0] > 1 && nArray[0] < n;
                        } else {
                            bl2 = true;
                            bl3 = true;
                        }
                    }
                    if (BinningCustomBase.this.isCustomCategoricalBinning()) {
                        bl = true;
                    } else if (nArray.length < n - 2) {
                        bl = true;
                        for (int i = 0; i < nArray.length; ++i) {
                            if (nArray[i] != 0) continue;
                            bl = false;
                            break;
                        }
                    }
                }
            }
            BinningCustomBase.this.removeBtn.setEnabled(bl);
            BinningCustomBase.this.addBtn.setEnabled(bl2);
            BinningCustomBase.this.editBtn.setEnabled(bl3);
        }
    }

    class BinsTableModel
    extends GenericBaseTableModel {
        protected List<NameValuePair> _data = new ArrayList<NameValuePair>();
        protected Map<String, Integer> _map = new HashMap<String, Integer>();

        BinsTableModel() {
            this(new Vector<NameValuePair>(), false);
        }

        BinsTableModel(Vector<NameValuePair> vector, boolean bl) {
            String[] stringArray;
            if (vector != null && !vector.isEmpty()) {
                for (NameValuePair nameValuePair : vector) {
                    ArrayList<String> arrayList = null;
                    if (nameValuePair.getValue() instanceof List) {
                        arrayList = (ArrayList<String>)nameValuePair.getValue();
                    } else {
                        arrayList = new ArrayList<String>();
                        arrayList.add(nameValuePair.getValue().toString());
                    }
                    if (arrayList == null || arrayList.isEmpty()) continue;
                    NameValuePair nameValuePair2 = new NameValuePair(nameValuePair.getName(), nameValuePair.getValue());
                    this._data.add(nameValuePair2);
                    this._map.put(nameValuePair.getName(), nameValuePair.getCount());
                }
            }
            this.setRowCount(this._data.size());
            if (bl) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = _bin_names;
                stringArray = stringArray2;
                stringArray2[1] = _bin_Lower_bound;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = _bin_names;
                stringArray = stringArray3;
                stringArray3[1] = _bin_values;
            }
            BinningCustomBase.access$702(BinningCustomBase.this, stringArray);
            this.setColumnIdentifiers(BinningCustomBase.this._columnNames);
        }

        public String getColumnName(int n) {
            if (BinningCustomBase.this._columnNames != null && n <= BinningCustomBase.this._columnNames.length) {
                return BinningCustomBase.this._columnNames[n];
            }
            return "";
        }

        protected String[] getColumnNames() {
            return BinningCustomBase.this._columnNames;
        }

        public int getRowCount() {
            return this._data != null ? this._data.size() : 0;
        }

        public Comparator getColumnSortComparator(int n) {
            if (n == _BIN_NAME) {
                return NameValuePairComparator.getComparator(this._map);
            }
            return super.getColumnSortComparator(n);
        }

        public Vector<NameValuePair> getDataVector() {
            Vector<NameValuePair> vector = new Vector<NameValuePair>();
            vector.addAll(this._data);
            return vector;
        }

        public int getRow(String string) {
            for (int i = 0; i < this._data.size(); ++i) {
                if (!this._data.get(i).getName().equals(string)) continue;
                return i;
            }
            return -1;
        }

        public void clearRows() {
            this._data.clear();
            this._map.clear();
            this.setRowCount(0);
            this.fireTableDataChanged();
        }

        public void setValueAt(Object object, int n, int n2) {
            Object object2;
            if (n2 != _BIN_VALUE) {
                return;
            }
            NameValuePair nameValuePair = this._data.get(n);
            NameValuePair nameValuePair2 = this._data.get(n - 1);
            NameValuePair nameValuePair3 = n == this._data.size() - 1 ? null : this._data.get(n + 1);
            Object object3 = nameValuePair2.getValue();
            Object object4 = object2 = nameValuePair3 != null ? nameValuePair3.getValue() : TransformationStatisticsState.UNBOUNDED;
            if (BinningCustomBase.this.isCustomNumericBinning()) {
                boolean bl;
                Double d;
                Double d2 = null;
                if (object instanceof Double) {
                    d2 = (Double)object;
                } else if (object instanceof String) {
                    d2 = Double.valueOf(object.toString());
                }
                Double d3 = object3.equals(TransformationStatisticsState.NO_LOWER_BOUND) ? null : (d = object3 instanceof String ? Double.valueOf(object3.toString()) : (Double)object3);
                Double d4 = object2.equals(TransformationStatisticsState.UNBOUNDED) ? null : (object2 instanceof String ? Double.valueOf(object2.toString()) : (Double)object2);
                boolean bl2 = false;
                if (d != null && d4 != null) {
                    if (d2 <= d || d2 >= d4) {
                        bl2 = true;
                    }
                } else if (d == null && d4 != null) {
                    if (d2 >= d4) {
                        bl2 = true;
                    }
                } else if (d != null && d4 == null && d2 <= d) {
                    bl2 = true;
                }
                if (bl2) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_DIALOG_OUT_OF_BOUNDS_BOUNDS"), (String)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                    return;
                }
                boolean bl3 = bl = null != ((TransformationType.Binning.CustomNumeric)BinningCustomBase.this.customBinning).getBinLabels().getNumberSequence();
                if (!bl) {
                    nameValuePair.setName(d2 + " - " + (d4 != null ? d4 : TransformationStatisticsState.UNBOUNDED));
                    if (object3.equals(TransformationStatisticsState.NO_LOWER_BOUND)) {
                        object3 = TransformationStatisticsState.UNBOUNDED;
                    }
                    nameValuePair2.setName(object3 + " - " + d2);
                }
                nameValuePair.setValue(object.toString());
                BinningCustomBase.this.loadCustomNumericBinning(this._data);
            } else if (BinningCustomBase.this.isCustomDateBinning() || BinningCustomBase.this.isCustomTimestampBinning()) {
                boolean bl;
                boolean bl4 = BinningCustomBase.this.isCustomTimestampBinning();
                SimpleDateFormat simpleDateFormat = bl4 ? TimeUtils.getShortSimpleDateFormatZoneRFC() : TimeUtils.getShortSimpleDateFormatRFC();
                GregorianCalendar gregorianCalendar = BinningCustomBase.toDate(simpleDateFormat, object, bl4);
                GregorianCalendar gregorianCalendar2 = object3.equals(TransformationStatisticsState.NO_LOWER_BOUND) ? null : BinningCustomBase.toDate(simpleDateFormat, object3, bl4);
                GregorianCalendar gregorianCalendar3 = object2.equals(TransformationStatisticsState.UNBOUNDED) ? null : BinningCustomBase.toDate(simpleDateFormat, object2, bl4);
                boolean bl5 = false;
                if (gregorianCalendar2 != null && gregorianCalendar3 != null) {
                    if (gregorianCalendar.before(gregorianCalendar2) || gregorianCalendar.after(gregorianCalendar3)) {
                        bl5 = true;
                    }
                } else if (gregorianCalendar2 == null && gregorianCalendar3 != null) {
                    if (gregorianCalendar.after(gregorianCalendar3)) {
                        bl5 = true;
                    }
                } else if (gregorianCalendar2 != null && gregorianCalendar3 == null && gregorianCalendar.before(gregorianCalendar2)) {
                    bl5 = true;
                }
                if (bl5) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_DIALOG_OUT_OF_BOUNDS_BOUNDS"), (String)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                    return;
                }
                boolean bl6 = BinningCustomBase.this.isCustomDateBinning() ? null != ((TransformationType.Binning.CustomDate)BinningCustomBase.this.customBinning).getBinLabels().getNumberSequence() : (bl = null != ((TransformationType.Binning.CustomTimestamp)BinningCustomBase.this.customBinning).getBinLabels().getNumberSequence());
                if (!bl) {
                    nameValuePair.setName(object + " - " + object2);
                    if (object3.equals(TransformationStatisticsState.NO_LOWER_BOUND)) {
                        object3 = TransformationStatisticsState.UNBOUNDED;
                    }
                    nameValuePair2.setName(object3 + " - " + object);
                }
                nameValuePair.setValue(object.toString());
                if (BinningCustomBase.this.isCustomDateBinning()) {
                    BinningCustomBase.this.loadCustomDateBinning(this._data);
                } else if (BinningCustomBase.this.isCustomTimestampBinning()) {
                    BinningCustomBase.this.loadCustomTimestampBinning(this._data);
                }
            }
            this.fireTableRowsUpdated(n - 1, n);
        }

        public Object getValueAt(int n, int n2) {
            if (this._data.isEmpty()) {
                return "";
            }
            if (n >= this._data.size()) {
                return "";
            }
            String string = null;
            NameValuePair nameValuePair = this._data.get(n);
            if (n2 == _BIN_NAME) {
                string = nameValuePair.getName();
            } else if (n2 == _BIN_VALUE) {
                if (BinningCustomBase.this.isCustomCategoricalBinning()) {
                    List<String> list = ConverterHelper.objectToStringList(nameValuePair.getValue());
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < list.size(); ++i) {
                        String string2 = list.get(i);
                        if (i > 0) {
                            stringBuilder.append(",");
                        }
                        stringBuilder.append(string2);
                    }
                    string = stringBuilder.toString();
                } else {
                    string = nameValuePair.getValue().toString();
                }
            }
            return string != null ? string : "";
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public TableModel getModel() {
            return this;
        }

        public boolean isCellEditable(int n, int n2) {
            if (BinningCustomBase.this.isCustomNumericBinning()) {
                NameValuePair nameValuePair = this._data.get(n);
                Object object = nameValuePair.getValue();
                if (object.equals(TransformationStatisticsState.NO_LOWER_BOUND)) {
                    return false;
                }
                if (n2 == _BIN_VALUE) {
                    return true;
                }
            }
            return false;
        }
    }

    class EmptyBinsTableModel
    extends BinsTableModel {
        EmptyBinsTableModel() {
            this.setRowCount(0);
            BinningCustomBase.access$702(BinningCustomBase.this, new String[]{_status});
            this.setColumnIdentifiers(BinningCustomBase.this._columnNames);
            this.setColumnCount(BinningCustomBase.this._columnNames.length);
        }
    }

    class LoadingBinsTableModel
    extends BinsTableModel {
        LoadingBinsTableModel() {
            this._data.add(new NameValuePair(_loading, (Object)"", 0));
            this.setRowCount(1);
            BinningCustomBase.access$702(BinningCustomBase.this, new String[]{_status});
            this.setColumnIdentifiers(BinningCustomBase.this._columnNames);
            this.setColumnCount(BinningCustomBase.this._columnNames.length);
        }
    }

    class LoadDefaultBins
    extends SwingWorker {
        private Exception _ex;
        private boolean _success = false;
        private String _explanation;
        TransformationType resultType;
        Vector<NameValuePair> pairs;

        LoadDefaultBins(TransformationType transformationType) {
            this.resultType = transformationType;
        }

        protected Object doInBackground() throws Exception {
            try {
                BinningCustomBase.this.editBtn.setEnabled(false);
                this.pairs = BinningCustomBase.this._state.generateDefaultBinsXform(BinningCustomBase.this.srcColumnName, BinningCustomBase.this.srcColumnType, this.resultType.getBinning());
                if (this.pairs != null && !this.pairs.isEmpty()) {
                    this._success = true;
                } else {
                    this._explanation = XformDialogsLrb.get("CUSTOM_BINNING_PANEL_NO_BINS");
                    this._success = false;
                }
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
            return this;
        }

        @Override
        protected void done() {
            super.done();
            if (this._success && this._ex == null) {
                Object object;
                BinsTableModel binsTableModel = null;
                if (null != this.resultType.getBinning().getEqualWidth() || null != this.resultType.getBinning().getQuantile()) {
                    binsTableModel = new BinsTableModel(this.pairs, true);
                    BinningCustomBase.this.loadCustomNumericBinning(this.pairs);
                    object = null != this.resultType.getBinning().getEqualWidth() ? this.resultType.getBinning().getEqualWidth().getBinLabels() : this.resultType.getBinning().getQuantile().getBinLabels();
                    TransformationType.Binning.CustomNumeric customNumeric = (TransformationType.Binning.CustomNumeric)BinningCustomBase.this.customBinning;
                    BinLabels binLabels = new BinLabels();
                    if (null != object.getNumberSequence()) {
                        binLabels.setNumberSequence(new BinLabels.NumberSequence());
                    } else {
                        binLabels.setRange(new BinLabels.Range());
                    }
                    customNumeric.setBinLabels(binLabels);
                } else if (null != this.resultType.getBinning().getTopN()) {
                    int n = -1;
                    for (int i = 0; i < this.pairs.size(); ++i) {
                        if (!this.pairs.get(i).getName().equals(TransformationStatisticsState.LIST_OF_DISTINCT_VALUES)) continue;
                        n = i;
                        break;
                    }
                    if (n != -1) {
                        BinningCustomBase.this._state.setDistinctValuesFrequencies(BinningCustomBase.this.srcColumnName, ConverterHelper.objectToNameValuePairList(this.pairs.get(n).getValue()));
                        this.pairs.remove(n);
                    }
                    binsTableModel = new BinsTableModel(this.pairs, false);
                    BinningCustomBase.this.loadCustomCategoricBinning(this.pairs);
                } else if (null != this.resultType.getBinning().getDateEqualWidth()) {
                    TransformationType.Binning.CustomDate customDate;
                    binsTableModel = new BinsTableModel(this.pairs, false);
                    BinLabels binLabels = this.resultType.getBinning().getDateEqualWidth().getBinLabels();
                    if (BinningCustomBase.this.customBinning instanceof TransformationType.Binning.CustomDate) {
                        BinningCustomBase.this.loadCustomDateBinning(this.pairs);
                        customDate = (TransformationType.Binning.CustomDate)BinningCustomBase.this.customBinning;
                        BinLabels binLabels2 = new BinLabels();
                        if (null != binLabels.getNumberSequence()) {
                            binLabels2.setNumberSequence(new BinLabels.NumberSequence());
                        } else {
                            binLabels2.setRange(new BinLabels.Range());
                        }
                        customDate.setBinLabels(binLabels2);
                    } else if (BinningCustomBase.this.customBinning instanceof TransformationType.Binning.CustomTimestamp) {
                        BinningCustomBase.this.loadCustomTimestampBinning(this.pairs);
                        customDate = (TransformationType.Binning.CustomTimestamp)BinningCustomBase.this.customBinning;
                        BinLabels binLabels3 = new BinLabels();
                        if (null != binLabels.getNumberSequence()) {
                            binLabels3.setNumberSequence(new BinLabels.NumberSequence());
                        } else {
                            binLabels3.setRange(new BinLabels.Range());
                        }
                        customDate.setBinLabels(binLabels3);
                    }
                } else if (null != this.resultType.getBinning().getTimestampEqualWidth()) {
                    TransformationType.Binning.CustomDate customDate;
                    binsTableModel = new BinsTableModel(this.pairs, false);
                    BinLabels binLabels = this.resultType.getBinning().getTimestampEqualWidth().getBinLabels();
                    if (BinningCustomBase.this.customBinning instanceof TransformationType.Binning.CustomDate) {
                        BinningCustomBase.this.loadCustomDateBinning(this.pairs);
                        customDate = (TransformationType.Binning.CustomDate)BinningCustomBase.this.customBinning;
                        BinLabels binLabels4 = new BinLabels();
                        if (null != binLabels.getNumberSequence()) {
                            binLabels4.setNumberSequence(new BinLabels.NumberSequence());
                        } else {
                            binLabels4.setRange(new BinLabels.Range());
                        }
                        customDate.setBinLabels(binLabels4);
                    } else if (BinningCustomBase.this.customBinning instanceof TransformationType.Binning.CustomTimestamp) {
                        BinningCustomBase.this.loadCustomTimestampBinning(this.pairs);
                        customDate = (TransformationType.Binning.CustomTimestamp)BinningCustomBase.this.customBinning;
                        BinLabels binLabels5 = new BinLabels();
                        if (null != binLabels.getNumberSequence()) {
                            binLabels5.setNumberSequence(new BinLabels.NumberSequence());
                        } else {
                            binLabels5.setRange(new BinLabels.Range());
                        }
                        customDate.setBinLabels(binLabels5);
                    }
                } else if (null != this.resultType.getBinning().getCustomTimestamp()) {
                    binsTableModel = new BinsTableModel(this.pairs, false);
                    BinningCustomBase.this.loadCustomTimestampBinning(this.pairs);
                    BinLabels binLabels = this.resultType.getBinning().getDateEqualWidth().getBinLabels();
                    TransformationType.Binning.CustomTimestamp customTimestamp = (TransformationType.Binning.CustomTimestamp)BinningCustomBase.this.customBinning;
                    BinLabels binLabels6 = new BinLabels();
                    if (null != binLabels.getNumberSequence()) {
                        binLabels6.setNumberSequence(new BinLabels.NumberSequence());
                    } else {
                        binLabels6.setRange(new BinLabels.Range());
                    }
                    customTimestamp.setBinLabels(binLabels6);
                }
                if (binsTableModel != null) {
                    BinningCustomBase.this.setupItemsTable(binsTableModel, BinningCustomBase.this._jAttributesTable);
                }
                if (BinningCustomBase.this.isCustomCategoricalBinning()) {
                    object = BinningCustomBase.this._jAttributesTable.getSelectedRowsInModel();
                    boolean bl = object != null && ((BinLabels)object).length > 0;
                    BinningCustomBase.this.editBtn.setEnabled(bl);
                }
            } else if (this._explanation != null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)this._explanation, (String)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                EmptyBinsTableModel emptyBinsTableModel = new EmptyBinsTableModel();
                BinningCustomBase.this.setupItemsTable(emptyBinsTableModel, BinningCustomBase.this._jAttributesTable);
            }
        }
    }
}

