/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.controls.NameValuePair;
import oracle.dmt.dataminer.workflow.dialog.transformations.BinningCustomBase;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.table.GenericTable;

public class BinningCustomNumeric
extends BinningCustomBase {
    private boolean invalidRange = false;
    private ComponentWithTitlebar<JComponent> jBinsTableComponent;

    @Override
    public boolean isInvalidRange() {
        return this.invalidRange;
    }

    public BinningCustomNumeric(String string, String string2, TransformationStatisticsState transformationStatisticsState, String string3, Object object, int n) {
        super(string, string2, transformationStatisticsState, string3, object, n);
        this.initComponents();
        this.loadComponents();
    }

    private void initComponents() {
        this.jBinsTableComponent = new ComponentWithTitlebar();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jBinsTableComponent, -1, 336, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jBinsTableComponent, -1, 250, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    protected JLabel getJLabelOther() {
        return null;
    }

    @Override
    public JTextField getJTextFieldOther() {
        return null;
    }

    @Override
    protected ComponentWithTitlebar<JComponent> getComponentWithTitlebar() {
        return this.jBinsTableComponent;
    }

    @Override
    protected void setupItemsTable(final BinningCustomBase.BinsTableModel binsTableModel, GenericTable genericTable) {
        super.setupItemsTable(binsTableModel, genericTable);
        final NumberTextField numberTextField = new NumberTextField();
        numberTextField.setDecimal(true);
        numberTextField.setSigned(true);
        numberTextField.setGroupingEnabled(true);
        numberTextField.setDataType(Double.class);
        numberTextField.addFocusListener((FocusListener)new FocusAdapter(){
            private int editedRow = -1;

            @Override
            public void focusGained(FocusEvent focusEvent) {
                Double d = numberTextField.getNumber().doubleValue();
                Vector<NameValuePair> vector = binsTableModel.getDataVector();
                for (int i = 0; i < vector.size(); ++i) {
                    NameValuePair nameValuePair = vector.get(i);
                    if (nameValuePair.getValue() == null || d == null || !nameValuePair.getValue().toString().equals(d.toString())) continue;
                    this.editedRow = i;
                    break;
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                BinningCustomNumeric.this.invalidRange = false;
                Double d = numberTextField.getNumber().doubleValue();
                if (this.editedRow != -1) {
                    boolean bl;
                    Double d2;
                    Double d3;
                    Object object;
                    Vector<NameValuePair> vector = binsTableModel.getDataVector();
                    NameValuePair nameValuePair = vector.get(this.editedRow);
                    NameValuePair nameValuePair2 = vector.get(this.editedRow - 1);
                    NameValuePair nameValuePair3 = this.editedRow == vector.size() - 1 ? null : vector.get(this.editedRow + 1);
                    Object object2 = nameValuePair2.getValue();
                    Object object3 = object = nameValuePair3 != null ? nameValuePair3.getValue() : TransformationStatisticsState.UNBOUNDED;
                    Double d4 = object2.equals(TransformationStatisticsState.NO_LOWER_BOUND) ? null : (d3 = object2 instanceof String ? Double.valueOf(object2.toString()) : (Double)object2);
                    Double d5 = object.equals(TransformationStatisticsState.UNBOUNDED) ? null : (d2 = object instanceof String ? Double.valueOf(object.toString()) : (Double)object);
                    if (d3 != null && d2 != null) {
                        if (d <= d3 || d >= d2) {
                            BinningCustomNumeric.this.invalidRange = true;
                        }
                    } else if (d3 == null && d2 != null) {
                        if (d >= d2) {
                            BinningCustomNumeric.this.invalidRange = true;
                        }
                    } else if (d3 != null && d2 == null && d <= d3) {
                        BinningCustomNumeric.this.invalidRange = true;
                    }
                    if (BinningCustomNumeric.this.invalidRange) {
                        TableColumn tableColumn = BinningCustomNumeric.this._jAttributesTable.getColumnModel().getColumn(BinningCustomBase._BIN_VALUE);
                        AbstractCellEditor abstractCellEditor = (AbstractCellEditor)((Object)tableColumn.getCellEditor());
                        abstractCellEditor.cancelCellEditing();
                        return;
                    }
                    boolean bl2 = bl = null != ((TransformationType.Binning.CustomNumeric)BinningCustomNumeric.this.customBinning).getBinLabels().getNumberSequence();
                    if (!bl) {
                        nameValuePair.setName(d + " - " + (d2 != null ? d2 : TransformationStatisticsState.UNBOUNDED));
                        if (object2.equals(TransformationStatisticsState.NO_LOWER_BOUND)) {
                            object2 = TransformationStatisticsState.UNBOUNDED;
                        }
                        nameValuePair2.setName(object2 + " - " + d);
                    }
                    nameValuePair.setValue(d.toString());
                    BinningCustomNumeric.this.loadCustomNumericBinning(vector);
                }
            }
        });
        NumberCellEditor numberCellEditor = new NumberCellEditor(numberTextField);
        if (this._jAttributesTable.getColumnModel().getColumnCount() > _BIN_VALUE) {
            TableColumn tableColumn = this._jAttributesTable.getColumnModel().getColumn(_BIN_VALUE);
            tableColumn.setCellEditor(numberCellEditor);
        }
    }

    class NumberCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        NumberTextField component;

        NumberCellEditor(NumberTextField numberTextField) {
            this.component = numberTextField;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object instanceof String) {
                Double d = Double.parseDouble((String)object);
                this.component.setNumber((Number)d);
            } else if (object instanceof Number) {
                this.component.setNumber((Number)object);
            }
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            return this.component.getNumber();
        }
    }
}

