/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.dialog.transformations.AbstractAttributesTableModel;
import oracle.dmt.dataminer.workflow.dialog.transformations.ApplyTransformWizardModel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationTypes;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.MapTransformedSource;
import oracle.dmt.dataminer.workflow.xmlschema.StringCollection;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationOutputAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.javatools.ui.search.SearchMatcher;

public class EditAttributesTableModel
extends AbstractAttributesTableModel {
    private final int ORIGINAL_NAME = 1;
    private final int NEW_NAME = 2;
    protected List<String> _orgColumns;
    protected Map<String, String> _outNewMap;
    private Vector<String> _columnNames;

    EditAttributesTableModel(ApplyTransformWizardModel applyTransformWizardModel) {
        super(applyTransformWizardModel);
    }

    EditAttributesTableModel(ApplyTransformWizardModel applyTransformWizardModel, String string, int n) throws Exception {
        super(applyTransformWizardModel, string, n);
    }

    List<String> getOriginalColumns() {
        return this._orgColumns;
    }

    String getNewName(String string) {
        return this._outNewMap.get(string);
    }

    @Override
    protected Vector getColumnNames() {
        if (this._columnNames == null) {
            this._columnNames = new Vector();
            this._columnNames.add(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_SOURCE_COLUMN"));
            this._columnNames.add(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ORIGINAL_COLUMN"));
            this._columnNames.add(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_OUTPUT_COLUMN"));
        }
        return this._columnNames;
    }

    @Override
    protected int getNewName() {
        return 2;
    }

    @Override
    protected void populateColumns() {
        List<TransformationSourceAttribute> list = this._model.getSelectedSourceColumns();
        this._srcColumns = new ArrayList(list.size());
        this._orgColumns = new ArrayList<String>(list.size());
        this._outColumns = new ArrayList(list.size());
        this._outSrcMap = new HashMap(list.size());
        this._outNewMap = new HashMap<String, String>(list.size());
        for (TransformationSourceAttribute transformationSourceAttribute : list) {
            assert (transformationSourceAttribute instanceof TransformationOutputAttribute);
            TransformationOutputAttribute transformationOutputAttribute = (TransformationOutputAttribute)transformationSourceAttribute;
            MapTransformedSource mapTransformedSource = AttributeTypeHelper.findMapTransformedSource(this._model.getNodeType().getTransformedAttributes(), transformationOutputAttribute.getName());
            StringCollection stringCollection = mapTransformedSource.getStringCollectionNames();
            String string = (String)stringCollection.getValue().get(0);
            this._srcColumns.add(string);
            String string2 = mapTransformedSource.getKey().getName();
            this._orgColumns.add(string2);
            String string3 = this._model.getSelectedTransformation();
            String string4 = TransformationTypes.transformationTypeToString(transformationOutputAttribute.getTransformationElementType());
            String string5 = string4.equals(string3) ? string2 : this._model.generateUniqueName(string, this._outColumns);
            this._outColumns.add(string5);
            this._outSrcMap.put(string2, string);
            this._outNewMap.put(string2, string5);
        }
    }

    @Override
    protected void populateFilteredColumns(String string, int n) throws Exception {
        SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
        boolean bl = string.length() <= 0;
        boolean bl2 = false;
        List<TransformationSourceAttribute> list = this._model.getSelectedSourceColumns();
        this._srcColumns = new ArrayList(list.size());
        this._orgColumns = new ArrayList<String>(list.size());
        this._outColumns = new ArrayList(list.size());
        this._outSrcMap = new HashMap(list.size());
        this._outNewMap = new HashMap<String, String>(list.size());
        for (TransformationSourceAttribute transformationSourceAttribute : list) {
            String string2;
            assert (transformationSourceAttribute instanceof TransformationOutputAttribute);
            TransformationOutputAttribute transformationOutputAttribute = (TransformationOutputAttribute)transformationSourceAttribute;
            MapTransformedSource mapTransformedSource = AttributeTypeHelper.findMapTransformedSource(this._model.getNodeType().getTransformedAttributes(), transformationOutputAttribute.getName());
            StringCollection stringCollection = mapTransformedSource.getStringCollectionNames();
            String string3 = (String)stringCollection.getValue().get(0);
            String string4 = mapTransformedSource.getKey().getName();
            String string5 = this._model.getSelectedTransformation();
            String string6 = TransformationTypes.transformationTypeToString(transformationOutputAttribute.getTransformationElementType());
            String string7 = string2 = string6.equals(string5) ? string4 : this._model.generateUniqueName(string3, this._outColumns);
            if (bl) {
                bl2 = true;
            } else {
                String string8 = "";
                switch (n) {
                    case 0: {
                        string8 = string3;
                        break;
                    }
                    case 1: {
                        string8 = string4;
                        break;
                    }
                    case 2: {
                        string8 = string2;
                        break;
                    }
                    default: {
                        string8 = string3;
                    }
                }
                bl2 = string8 == null ? false : searchMatcher.matches((CharSequence)string8);
            }
            if (!bl2) continue;
            this._srcColumns.add(string3);
            this._orgColumns.add(string4);
            this._outColumns.add(string2);
            this._outSrcMap.put(string4, string3);
            this._outNewMap.put(string4, string2);
        }
    }

    @Override
    public void clearRows() {
        super.clearRows();
        this._outNewMap.clear();
        this._orgColumns.clear();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        if (this._outColumns.isEmpty()) {
            return "";
        }
        String string = this._orgColumns.get(n);
        String string2 = null;
        if (n2 == 0) {
            string2 = (String)this._outSrcMap.get(string);
        } else if (n2 == this.getNewName()) {
            string2 = this._outNewMap.get(string);
        } else if (n2 == 1) {
            string2 = string;
        } else assert (false) : "Out of bounds column when accessing items";
        return string2 != null ? string2 : "";
    }

    @Override
    protected void replaceName(String string, int n) {
        String string2 = this._orgColumns.get(n);
        this._outColumns.set(n, string);
        this._outNewMap.put(string2, string);
    }

    public void revertNames() {
        this._outColumns.clear();
        for (String string : this._orgColumns) {
            this._outColumns.add(string);
            this._outNewMap.put(string, string);
        }
    }
}

