/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Color;
import java.awt.Window;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.controls.GraphModelProvider;
import oracle.dmt.dataminer.controls.GraphicalPreferencesSettings;
import oracle.dmt.dataminer.controls.NameValuePair;
import oracle.dmt.dataminer.controls.TransformationPreferencesSettings;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsData;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsLrb;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.ConverterHelper;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.dataminer.workflow.dialog.WorkflowDialogLrb;
import oracle.dmt.dataminer.workflow.dialog.data.StatisticsSelectionObject;
import oracle.dmt.dataminer.workflow.dialog.transformations.ExtendedTransformationSettingsTableModel;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.transformations.TransformationSettingsTableModel;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.TransformationNode;
import oracle.dmt.dataminer.workflow.xmlschema.BinLabels;
import oracle.dmt.dataminer.workflow.xmlschema.CategoricalBin;
import oracle.dmt.dataminer.workflow.xmlschema.DateBin;
import oracle.dmt.dataminer.workflow.xmlschema.MapTransformedSource;
import oracle.dmt.dataminer.workflow.xmlschema.NumericBin;
import oracle.dmt.dataminer.workflow.xmlschema.ResultType;
import oracle.dmt.dataminer.workflow.xmlschema.StatsSelection;
import oracle.dmt.dataminer.workflow.xmlschema.StringCollection;
import oracle.dmt.dataminer.workflow.xmlschema.TimestampTimezoneBin;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationOutputAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributes;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleDriver;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.TIMESTAMPTZ;

public class TransformationStatisticsState
implements GraphModelProvider {
    private static final Logger theLogger = Logger.getLogger(TransformationStatisticsState.class.getName());
    public static String NULLS = "Nulls";
    public static String EDGES = "EdgeValues";
    public static int DEFAULT_BIN_COUNT = 10;
    private boolean _loaded;
    private Context _context;
    private TransformationNode _transformationNode;
    private TransformedAttributes _transformedAttributes;
    private Vector<TransformationSourceAttribute> _transformationSourceAttributes;
    private TransformationSettingsTableModel _tableModel;
    private static Preferences _p = Preferences.getPreferences();
    private TransformationPreferencesSettings transformSettings = TransformationPreferencesSettings.getInstance((PropertyStorage)_p);
    public static String RANGE = XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_BIN_LABELS_RANGE");
    public static String SEQUENCE = XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_BIN_LABELS_NUMBER");
    private String styleSelection = DefaultGraphDataModel.DEFAULT_GRAPH_STYLE;
    private int depthRadius = _DEPTH_RADIUS;
    private static int _DEPTH_RADIUS = 50;
    public static final Color _BASE_CHART_COLOR = new Color(255, 255, 153);
    static String _NONE_ATTRIBUTE = DataProfileStatisticsLrb.get("ATTRIBUTE_NONE");
    private static Color[] _RESERVED_COLORS = new Color[]{Color.yellow, Color.red, Color.green, Color.blue, Color.cyan, Color.magenta, Color.orange, Color.pink, Color.black, Color.gray};
    private static Color[][] _EXTRA_COLORS = new Color[][]{{new Color(255, 226, 122), new Color(255, 122, 122), new Color(122, 255, 122), new Color(122, 122, 255), new Color(122, 255, 255), new Color(255, 122, 255), new Color(255, 226, 122), new Color(255, 51, 51), new Color(51, 26, 0), Color.lightGray}, {new Color(255, 213, 61), new Color(255, 61, 61), new Color(61, 255, 61), new Color(61, 61, 255), new Color(61, 255, 255), new Color(255, 61, 255), new Color(255, 213, 61), new Color(255, 112, 112), new Color(112, 112, 0), Color.darkGray}};
    private static String ATTR = "ATTR";
    private static String DATA_TYPE = "DATA_TYPE";
    private static String NULL_PERCENT = "NULL_PERCENT";
    private static String DISTINCT_CNT = "DISTINCT_CNT";
    private static String DISTINCT_PERCENT = "DISTINCT_PERCENT";
    private static String MODE_VALUE = "MODE_VALUE";
    private static String AVG = "AVG";
    private static String AVG_DATE = "AVG_DATE";
    private static String AVG_TS_TZ = "AVG_TS_TZ";
    private static String MEDIAN_VAL = "MEDIAN_VAL";
    private static String MEDIAN_DATE = "MEDIAN_DATE";
    private static String MEDIAN_TS_TZ = "MEDIAN_TS_TZ";
    private static String MIN = "MIN";
    private static String MAX = "MAX";
    private static String STD = "STD";
    private static String VAR = "VAR";
    private static String SKEWNESS = "SKEWNESS";
    private static String KURTOSIS = "KURTOSIS";
    private static String ATTRIBUTE_VALUE = "ATTRIBUTE_VALUE";
    private static String ATTRIBUTE_PERCENT = "ATTRIBUTE_PERCENT";
    private static String _comma = ", ";
    private static String _where_clause = "<where_clause>";
    private static String _where_clause_template = " where ATTR IN(";
    private static String _attr_list_token = "<attribute_list>";
    private static String _table_name_token = "<table_name>";
    private static String _QUERY = "SELECT <attribute_list> from <table_name>, table (HISTOGRAMS) <where_clause>";
    private static String _QUERY_NO_HISTOGRAM = "SELECT <attribute_list> from <table_name> <where_clause>";
    private HashMap<String, AttributeHistogramArray> _serverHistograms = new HashMap();
    private Map<String, Boolean> _mapModified = new HashMap<String, Boolean>();
    private HashMap<String, DataProfileStatisticsData> _refreshDataPoints;
    private HashMap<String, AttributeHistogramArray> _refreshHistograms = new HashMap();
    private String _refreshStatsTable;
    private String _refreshSingleColumnStatsTable;
    private HashMap<String, DataProfileStatisticsData> _serverDataPoints;
    static String LIST_OF_DISTINCT_VALUES = "LIST_OF_DISTINCT_VALUES";
    private Map<String, List<String>> distinctValues = new HashMap<String, List<String>>();
    private Map<String, List<Integer>> frequencies = new HashMap<String, List<Integer>>();
    private static String EQWIDTH = "EQWIDTH";
    private static String QTILE = "QTILE";
    private static String TOPN = "TOPN";
    static String UNBOUNDED = XformDialogsLrb.get("CUSTOM_BINNING_PANEL_UNBOUNDED");
    static String NO_LOWER_BOUND = XformDialogsLrb.get("CUSTOM_BINNING_PANEL_NO_LOWER_BOUND");
    private static final String ODMR_OBJECT_NAMES = "ODMR_OBJECT_NAMES";
    private static final String ODMR_OBJECT_IDS = "ODMR_OBJECT_IDS";
    private static final String ODMR_OBJECT_VALUES = "ODMR_OBJECT_VALUES";
    private static String xformToSql = "{? = call ODMR_UTIL.CLIENT_TRANSFORM(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}";
    static String sql_distincts = "SELECT COUNT (<column_name>) frequency,  <column_name>  from (<table_name>) where <column_name> is not null group by <column_name>";
    private static String queryDateTemplate_no_with = "  <stacked_sql_view>,    ALL_DATA_VIEW as (      select * from(        select \"Attribute Name\", \"Attribute Value\"        from         (select \"Attribute Name\", \"Attribute Value\"         FROM  (select <column> from (<table_name>))             UNPIVOT INCLUDE NULLS (               \"Attribute Value\"                FOR \"Attribute Name\" IN ( <column> ))          group by (\"Attribute Name\", \"Attribute Value\") ) ) ),    STATS_VIEW as (     select \"Attribute Name\", CAST(MAX(\"Attribute Value\") AS TIMESTAMP) max_value,                                CAST(MIN(\"Attribute Value\") AS TIMESTAMP) min_value     from ALL_DATA_VIEW     group by (\"Attribute Name\") )     select        \"Attribute Name\" ATTRIBUTE_NAME, min_value, max_value from STATS_VIEW";
    private static String queryDateTemplate = "WITH    ALL_DATA_VIEW as (      select * from(        select \"Attribute Name\", \"Attribute Value\"        from         (select \"Attribute Name\", \"Attribute Value\"         FROM  (select <column> from (<table_name>))             UNPIVOT INCLUDE NULLS (               \"Attribute Value\"                FOR \"Attribute Name\" IN ( <column> ))          group by (\"Attribute Name\", \"Attribute Value\") ) ) ),    STATS_VIEW as (     select \"Attribute Name\", CAST(MAX(\"Attribute Value\") AS TIMESTAMP) max_value,                                CAST(MIN(\"Attribute Value\") AS TIMESTAMP) min_value     from ALL_DATA_VIEW     group by (\"Attribute Name\") )     select        \"Attribute Name\" ATTRIBUTE_NAME, min_value, max_value from STATS_VIEW";

    private static String getAttributeList(StatsSelection statsSelection) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ATTR);
        stringBuffer.append(_comma);
        stringBuffer.append(DATA_TYPE);
        if (statsSelection.isPercentnull()) {
            stringBuffer.append(_comma);
            stringBuffer.append(NULL_PERCENT);
        }
        if (statsSelection.isPercentdistinct()) {
            stringBuffer.append(_comma);
            stringBuffer.append(DISTINCT_CNT);
            stringBuffer.append(_comma);
            stringBuffer.append(DISTINCT_PERCENT);
        }
        if (statsSelection.isMode()) {
            stringBuffer.append(_comma);
            stringBuffer.append(MODE_VALUE);
        }
        if (statsSelection.isAvg()) {
            stringBuffer.append(_comma);
            stringBuffer.append(AVG);
            stringBuffer.append(_comma);
            stringBuffer.append(AVG_DATE);
            stringBuffer.append(_comma);
            stringBuffer.append(AVG_TS_TZ);
        }
        if (statsSelection.isMedian()) {
            stringBuffer.append(_comma);
            stringBuffer.append(MEDIAN_VAL);
            stringBuffer.append(_comma);
            stringBuffer.append(MEDIAN_DATE);
            stringBuffer.append(_comma);
            stringBuffer.append(MEDIAN_TS_TZ);
        }
        if (statsSelection.isMin()) {
            stringBuffer.append(_comma);
            stringBuffer.append(MIN);
        }
        if (statsSelection.isMax()) {
            stringBuffer.append(_comma);
            stringBuffer.append(MAX);
        }
        if (statsSelection.isStd()) {
            stringBuffer.append(_comma);
            stringBuffer.append(STD);
        }
        if (statsSelection.isVar()) {
            stringBuffer.append(_comma);
            stringBuffer.append(VAR);
        }
        if (statsSelection.isSkewness()) {
            stringBuffer.append(_comma);
            stringBuffer.append(SKEWNESS);
        }
        if (statsSelection.isKurtosis()) {
            stringBuffer.append(_comma);
            stringBuffer.append(KURTOSIS);
        }
        if (statsSelection.isHistogram()) {
            stringBuffer.append(_comma);
            stringBuffer.append(ATTRIBUTE_VALUE);
            stringBuffer.append(_comma);
            stringBuffer.append(ATTRIBUTE_PERCENT);
        }
        return stringBuffer.toString();
    }

    boolean isUpToDate() {
        boolean bl = true;
        Collection<Boolean> collection = this._mapModified.values();
        for (Boolean bl2 : collection) {
            if (!bl2.booleanValue()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void addToModifiedList(MapTransformedSource mapTransformedSource) {
        this._mapModified.put(mapTransformedSource.getKey().getName(), Boolean.TRUE);
    }

    public boolean isModified(String string) {
        return null != this._mapModified.get(string);
    }

    public boolean needsRefresh(String string) {
        Boolean bl = this._mapModified.get(string);
        if (null == bl) {
            return false;
        }
        return bl;
    }

    private void resetModifiedList() {
        Set<String> set = this._mapModified.keySet();
        for (String string : set) {
            this._mapModified.put(string, Boolean.FALSE);
        }
    }

    private void resetModifiedState(String string) {
        this._mapModified.put(string, Boolean.FALSE);
    }

    public void setTransformationSourceAttributes(Vector<TransformationSourceAttribute> vector) {
        this._transformationSourceAttributes = vector;
    }

    public TransformationSourceAttribute findTransformationSourceColumn(String string) {
        for (TransformationSourceAttribute transformationSourceAttribute : this._transformationSourceAttributes) {
            if (!transformationSourceAttribute.getName().equals(string)) continue;
            return transformationSourceAttribute;
        }
        return null;
    }

    public TransformationOutputAttribute findTransformedColumn(String string) {
        List list = this._transformedAttributes.getMapTransformedSourceType();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (MapTransformedSource mapTransformedSource : list) {
            if (!mapTransformedSource.getKey().getName().equals(string)) continue;
            return mapTransformedSource.getKey();
        }
        return null;
    }

    public Context getContext() {
        return this._context;
    }

    public void setRefreshSingleColumnStatsTable(String string) {
        this._refreshSingleColumnStatsTable = string;
    }

    public String getRefreshSingleColumnStatsTable() {
        return this._refreshSingleColumnStatsTable;
    }

    public void setTransformationNode(TransformationNode transformationNode) {
        this._transformationNode = transformationNode;
    }

    public TransformationNode getTransformationNode() {
        return this._transformationNode;
    }

    public TransformedAttributes getTransformedAttributes() {
        return this._transformedAttributes;
    }

    public boolean isShowNulls() {
        return this.transformSettings.isShowNulls();
    }

    public TransformationStatisticsState(Context context, GraphicalPreferencesSettings graphicalPreferencesSettings, TransformationNode transformationNode, TransformedAttributes transformedAttributes, Vector<TransformationSourceAttribute> vector) {
        assert (context != null) : "Context cannot be passed into constructor as a null.";
        this._loaded = false;
        this._context = context;
        this.styleSelection = graphicalPreferencesSettings.getGraphStyle();
        this.depthRadius = graphicalPreferencesSettings.getRadiusDepthValue();
        this._transformationNode = transformationNode;
        this._transformedAttributes = transformedAttributes;
        this._transformationSourceAttributes = vector;
    }

    GraphDataModel initGraphModel() {
        DefaultGraphDataModel defaultGraphDataModel = new DefaultGraphDataModel(null, 18, null, null, null);
        defaultGraphDataModel.setX1(DataProfileStatisticsLrb.get("HISTOGRAM_X_AXIS"), null);
        defaultGraphDataModel.setY1(DataProfileStatisticsLrb.get("HISTOGRAM_Y_AXIS"), 100.0);
        return defaultGraphDataModel;
    }

    public String getServerStatisticalTable() {
        ResultType resultType = ((TransformationNodeType)this._transformationNode.getData()).getInputStatisticTable();
        return resultType != null ? resultType.getName() : null;
    }

    public boolean hasInputStatisticTable() {
        ResultType resultType = ((TransformationNodeType)this._transformationNode.getData()).getInputStatisticTable();
        return resultType != null;
    }

    public static String getTransformationSourceAttributeDataType(TransformationNode transformationNode, String string) {
        String string2 = null;
        TransformationSourceAttributes transformationSourceAttributes = ((TransformationNodeType)transformationNode.getData()).getTransformationSourceAttributes();
        for (TransformationSourceAttribute transformationSourceAttribute : transformationSourceAttributes.getTransformationSourceAttributeType()) {
            if (!transformationSourceAttribute.getName().equals(string)) continue;
            string2 = transformationSourceAttribute.getDataType();
            break;
        }
        return string2;
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void close() {
    }

    public StatsSelection getStatsSelection() {
        TransformationNodeType transformationNodeType = (TransformationNodeType)this._transformationNode.getData();
        StatsSelection statsSelection = transformationNodeType.getStatsSelection();
        if (statsSelection == null) {
            statsSelection = StatisticsSelectionObject.createDefaultStatsSelection();
        }
        return statsSelection;
    }

    public void setTableModel(TransformationSettingsTableModel transformationSettingsTableModel) {
        this._tableModel = transformationSettingsTableModel;
        this.createAllGraphDataModelsTotalPopulation();
    }

    public void loadExtendedModel(String string, int n) throws Exception {
        String string2 = this.getServerStatisticalTable();
        if (string2 == null) {
            this._loaded = false;
            return;
        }
        TransformationNodeType transformationNodeType = (TransformationNodeType)this._transformationNode.getData();
        StatsSelection statsSelection = transformationNodeType.getStatsSelection();
        this._tableModel = new ExtendedTransformationSettingsTableModel(statsSelection, this._transformedAttributes, this._transformationSourceAttributes, this.loadAllStatistics(string2), string, n);
        this.createAllGraphDataModelsTotalPopulation();
        this._loaded = true;
    }

    public void loadBaseModel(String string, int n) throws Exception {
        String string2 = this.getServerStatisticalTable();
        if (string2 == null) {
            this._loaded = false;
            return;
        }
        TransformationNodeType transformationNodeType = (TransformationNodeType)this._transformationNode.getData();
        StatsSelection statsSelection = transformationNodeType.getStatsSelection();
        this._tableModel = new TransformationSettingsTableModel(statsSelection, this._transformedAttributes, this._transformationSourceAttributes, this.loadAllStatistics(string2), string, n);
        this.createAllGraphDataModelsTotalPopulation();
        this._loaded = true;
    }

    public List<DataProfileStatisticsData> loadAllStatistics(String string) throws Exception {
        List<DataProfileStatisticsData> list;
        ArrayList<DataProfileStatisticsData> arrayList = new ArrayList<DataProfileStatisticsData>();
        List<DataProfileStatisticsData> list2 = this.loadServerStatistics(string);
        if (list2 != null && !list2.isEmpty()) {
            arrayList.addAll(list2);
        }
        if (this._refreshStatsTable != null && (list = this.loadRefreshedStatistics(this._refreshStatsTable)) != null && !list.isEmpty()) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private List<DataProfileStatisticsData> loadRefreshedStatistics(String string) throws Exception {
        if (this._refreshDataPoints == null) {
            this._refreshDataPoints = new HashMap();
            this.resetModifiedList();
            TransformationNodeType transformationNodeType = (TransformationNodeType)this._transformationNode.getData();
            StatsSelection statsSelection = transformationNodeType.getStatsSelection();
            if (statsSelection == null) {
                statsSelection = StatisticsSelectionObject.createDefaultStatsSelection();
            }
            return TransformationStatisticsState.loadStatistics(this._context, string, statsSelection, null, this._refreshDataPoints, this._refreshHistograms, null);
        }
        return TransformationStatisticsState.getDataPoints(this._refreshDataPoints);
    }

    public List<DataProfileStatisticsData> loadColumnRefreshedStatistics(HashMap<String, DataProfileStatisticsData> hashMap, HashMap<String, AttributeHistogramArray> hashMap2, List<String> list) throws Exception {
        TransformationNodeType transformationNodeType = (TransformationNodeType)this._transformationNode.getData();
        StatsSelection statsSelection = transformationNodeType.getStatsSelection();
        if (statsSelection == null) {
            statsSelection = StatisticsSelectionObject.createDefaultStatsSelection();
        }
        return TransformationStatisticsState.loadStatistics(this._context, this._refreshSingleColumnStatsTable, statsSelection, list, hashMap, hashMap2, null);
    }

    private List<DataProfileStatisticsData> loadServerStatistics(String string) throws Exception {
        if (this._serverDataPoints == null) {
            this._serverDataPoints = new HashMap();
            TransformationNodeType transformationNodeType = (TransformationNodeType)this._transformationNode.getData();
            StatsSelection statsSelection = transformationNodeType.getStatsSelection();
            if (statsSelection == null) {
                statsSelection = StatisticsSelectionObject.createDefaultStatsSelection();
            }
            return TransformationStatisticsState.loadStatistics(this._context, string, statsSelection, null, this._serverDataPoints, this._serverHistograms, this._mapModified);
        }
        return TransformationStatisticsState.getDataPoints(this._serverDataPoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<DataProfileStatisticsData> loadStatistics(Context context, String string, StatsSelection statsSelection, List<String> list, HashMap<String, DataProfileStatisticsData> hashMap, HashMap<String, AttributeHistogramArray> hashMap2, Map<String, Boolean> map) throws Exception {
        List<DataProfileStatisticsData> list2 = null;
        if (!(statsSelection.isPercentdistinct() || statsSelection.isPercentnull() || statsSelection.isMax() || statsSelection.isMin() || statsSelection.isAvg() || statsSelection.isStd() || statsSelection.isVar() || statsSelection.isKurtosis() || statsSelection.isMedian() || statsSelection.isSkewness() || statsSelection.isMode() || statsSelection.isHistogram())) {
            list2 = new ArrayList<DataProfileStatisticsData>();
            return list2;
        }
        String string2 = null;
        Connection connection = null;
        SQLHelper sQLHelper = new SQLHelper();
        try {
            Object object;
            String string3;
            CharSequence charSequence;
            connection = Connections.getUniqueConnection(context);
            ConnectionFolder.setConnectionAlterSessionFixes(connection);
            string2 = StringUtils.getReplacedString(statsSelection.isHistogram() ? _QUERY : _QUERY_NO_HISTOGRAM, _attr_list_token, TransformationStatisticsState.getAttributeList(statsSelection));
            if (list == null || list.isEmpty()) {
                string2 = StringUtils.getReplacedString(string2, _where_clause, "");
            } else {
                charSequence = new StringBuilder();
                for (String string4 : list) {
                    if (charSequence.length() > 0) {
                        charSequence.append(",");
                    }
                    string3 = StringUtils.addSingleQuotes(TransformationStatisticsState.getQuotedName(StringUtils.escapeSingleQuotesForSQL(string4)));
                    charSequence.append(string3);
                }
                charSequence.append(")");
                object = new StringBuilder(_where_clause_template);
                ((StringBuilder)object).append(charSequence.toString());
                string2 = StringUtils.getReplacedString(string2, _where_clause, ((StringBuilder)object).toString());
            }
            string2 = StringUtils.getReplacedString(string2, _table_name_token, string);
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string2);
            sQLHelper.ors = (OracleResultSet)sQLHelper.opstmt.executeQuery();
            while (sQLHelper.ors.next()) {
                Object object2;
                GregorianCalendar gregorianCalendar;
                Cloneable cloneable;
                Object object3;
                Object object4;
                Date date;
                byte[] byArray;
                String string4;
                charSequence = sQLHelper.ors.getString(ATTR);
                object = StringUtils.trimDoubleQuotes((String)charSequence);
                if (map != null && null != map.get(object)) continue;
                string4 = sQLHelper.ors.getString(DATA_TYPE);
                string3 = statsSelection.isPercentnull() ? sQLHelper.ors.getObject(NULL_PERCENT) : null;
                Object object5 = statsSelection.isPercentdistinct() ? sQLHelper.ors.getObject(DISTINCT_CNT) : null;
                Object object6 = statsSelection.isPercentdistinct() ? sQLHelper.ors.getObject(DISTINCT_PERCENT) : null;
                String string5 = statsSelection.isMode() ? sQLHelper.ors.getString(MODE_VALUE) : null;
                Object object7 = statsSelection.isAvg() ? sQLHelper.ors.getObject(AVG) : null;
                java.sql.Date date2 = statsSelection.isAvg() ? sQLHelper.ors.getDate(AVG_DATE) : null;
                TIMESTAMPTZ tIMESTAMPTZ = statsSelection.isAvg() ? sQLHelper.ors.getTIMESTAMPTZ(AVG_TS_TZ) : null;
                Object object8 = statsSelection.isMedian() ? sQLHelper.ors.getObject(MEDIAN_VAL) : null;
                java.sql.Date date3 = statsSelection.isMedian() ? sQLHelper.ors.getDate(MEDIAN_DATE) : null;
                TIMESTAMPTZ tIMESTAMPTZ2 = statsSelection.isMedian() ? sQLHelper.ors.getTIMESTAMPTZ(MEDIAN_TS_TZ) : null;
                String string6 = statsSelection.isMin() ? sQLHelper.ors.getString(MIN) : null;
                String string7 = statsSelection.isMax() ? sQLHelper.ors.getString(MAX) : null;
                Object object9 = statsSelection.isStd() ? sQLHelper.ors.getObject(STD) : null;
                Object object10 = statsSelection.isVar() ? sQLHelper.ors.getObject(VAR) : null;
                Object object11 = statsSelection.isSkewness() ? sQLHelper.ors.getObject(SKEWNESS) : null;
                Object object12 = statsSelection.isKurtosis() ? sQLHelper.ors.getObject(KURTOSIS) : null;
                Object object13 = statsSelection.isHistogram() ? sQLHelper.ors.getObject(ATTRIBUTE_VALUE) : null;
                Double d = statsSelection.isHistogram() ? Double.valueOf(sQLHelper.ors.getDouble(ATTRIBUTE_PERCENT)) : null;
                Double d2 = string3 == null ? null : Double.valueOf(((BigDecimal)((Object)string3)).doubleValue());
                Integer n = object5 == null ? null : Integer.valueOf(((BigDecimal)object5).intValue());
                Double d3 = object6 == null ? null : Double.valueOf(((BigDecimal)object6).doubleValue());
                Double d4 = object7 == null ? null : Double.valueOf(((BigDecimal)object7).doubleValue());
                Date date4 = date2 == null ? null : new Date(date2.getTime());
                Object object14 = null;
                if (d4 != null) {
                    object14 = d4;
                } else if (date4 != null) {
                    object14 = date4;
                } else if (tIMESTAMPTZ != null) {
                    byArray = tIMESTAMPTZ.toBytes();
                    date = tIMESTAMPTZ.timestampValue(connection);
                    object4 = new GregorianCalendar();
                    ((Calendar)object4).setTime(date);
                    object3 = TimeUtils.GMT + TimeUtils.getRegionName(byArray);
                    cloneable = TimeUtils.toTimeZoneFromZoneId((String)object3);
                    ((GregorianCalendar)object4).setTimeZone((TimeZone)cloneable);
                    object14 = object4;
                }
                byArray = object8 == null ? null : Double.valueOf(((BigDecimal)object8).doubleValue());
                date = date3 == null ? null : new Date(date3.getTime());
                object4 = null;
                if (byArray != null) {
                    object4 = byArray;
                } else if (date != null) {
                    object4 = date;
                } else if (tIMESTAMPTZ2 != null) {
                    object3 = tIMESTAMPTZ2.toBytes();
                    cloneable = tIMESTAMPTZ2.timestampValue(connection);
                    gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setTime((Date)cloneable);
                    object2 = TimeUtils.GMT + TimeUtils.getRegionName(object3);
                    TimeZone timeZone = TimeUtils.toTimeZoneFromZoneId((String)object2);
                    gregorianCalendar.setTimeZone(timeZone);
                    object4 = gregorianCalendar;
                }
                object3 = object9 == null ? null : Double.valueOf(((BigDecimal)object9).doubleValue());
                cloneable = object10 == null ? null : Double.valueOf(((BigDecimal)object10).doubleValue());
                gregorianCalendar = object11 == null ? null : Double.valueOf(((BigDecimal)object11).doubleValue());
                object2 = object12 == null ? null : Double.valueOf(((BigDecimal)object12).doubleValue());
                TransformationStatisticsState.addPoint(hashMap, hashMap2, (String)charSequence, string4, d2, n, d3, string5, object14, object4, string6, string7, (Double)object3, (Double)((Object)cloneable), (Double)((Object)gregorianCalendar), (Double)object2, object13, null, d, statsSelection.isHistogram());
            }
            list2 = TransformationStatisticsState.getDataPoints(hashMap);
        }
        finally {
            sQLHelper.close();
            SQLHelper.close(connection);
        }
        return list2;
    }

    public TransformationSettingsTableModel getTableModel() {
        return this._tableModel;
    }

    @Override
    public GraphDataModel getGraphDataModel(int n) {
        if (this._tableModel == null) {
            return null;
        }
        DataProfileStatisticsData dataProfileStatisticsData = this._tableModel.getDataProfileStatisticsData(n);
        if (dataProfileStatisticsData == null) {
            return null;
        }
        GraphDataModel graphDataModel = dataProfileStatisticsData.getGraphDataModel();
        return graphDataModel;
    }

    public DataProfileStatisticsData getDataProfileStatisticsData(String string) {
        if (this._tableModel == null) {
            return null;
        }
        return this._tableModel.getDataProfileStatisticsData(string);
    }

    public void setDataProfileStatisticsData(DataProfileStatisticsData dataProfileStatisticsData) {
        if (this._tableModel == null) {
            return;
        }
        this._tableModel.addDataItem(dataProfileStatisticsData);
        String string = StringUtils.trimDoubleQuotes(dataProfileStatisticsData.getName());
        int n = this._tableModel.getRow(string);
        this._tableModel.fireTableRowsUpdated(n, n);
    }

    public void setDataProfileStatisticsData(List<DataProfileStatisticsData> list) {
        if (this._tableModel == null) {
            return;
        }
        for (DataProfileStatisticsData dataProfileStatisticsData : list) {
            this._tableModel.addDataItem(dataProfileStatisticsData);
            String string = StringUtils.trimDoubleQuotes(dataProfileStatisticsData.getName());
            int n = this._tableModel.getRow(string);
            this._tableModel.fireTableRowsUpdated(n, n);
        }
    }

    @Override
    public String getStyleSelection() {
        return this.styleSelection;
    }

    public boolean isValidAttribute(String string) {
        return true;
    }

    public int getDepthRadius() {
        return this.depthRadius;
    }

    public GraphDataModel createDetailedGraphModel(String string) {
        GraphDataModel graphDataModel = this.createGraphDataModelTotalPopulation(string);
        return graphDataModel;
    }

    private void createAllGraphDataModelsTotalPopulation() {
        Vector<TransformationSourceAttribute> vector = this._tableModel.getDataVector();
        for (TransformationSourceAttribute transformationSourceAttribute : vector) {
            String string = transformationSourceAttribute.getName();
            GraphDataModel graphDataModel = this.createGraphDataModelTotalPopulationGeneric(string);
            if (graphDataModel == null) {
                return;
            }
            graphDataModel.setTitle(null);
            graphDataModel.setLegendVisible(false);
            graphDataModel.setDepthRadius(0);
            graphDataModel.setLineDataLineDisplayed(false);
            DataProfileStatisticsData dataProfileStatisticsData = this._tableModel.getDataProfileStatisticsData(string);
            if (dataProfileStatisticsData == null) continue;
            dataProfileStatisticsData.setGraphDataModel(graphDataModel);
        }
    }

    GraphDataModel createGraphDataModelTotalPopulation(String string) {
        return this.createGraphDataModelTotalPopulationGeneric(string);
    }

    GraphDataModel createGraphDataModelTotalPopulationGeneric(String string) {
        boolean bl = true;
        GraphDataModel graphDataModel = this.initGraphModel();
        AttributeHistogramArray attributeHistogramArray = this.getHistogram(string);
        if (attributeHistogramArray == null || attributeHistogramArray.isEmpty()) {
            return graphDataModel;
        }
        ArrayList<String> arrayList = attributeHistogramArray.getBarTitles();
        if (arrayList == null || arrayList.isEmpty()) {
            return graphDataModel;
        }
        int n = arrayList.size();
        int n2 = 1;
        Object[][] objectArray = new Object[n][n2];
        Object[] objectArray2 = new Object[n];
        Object[] objectArray3 = new String[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray3[i] = bl ? DataProfileStatisticsLrb.get("HISTOGRAM_Y_AXIS") : "";
            for (int j = 0; j < n; ++j) {
                String string2 = arrayList.get(j);
                ArrayList<NameValuePair> arrayList2 = attributeHistogramArray.getBarArray(string2.toString());
                NameValuePair nameValuePair = arrayList2.get(0);
                Object object = nameValuePair.getValue();
                assert (object instanceof Double) : "Wrong data for this graph";
                objectArray[j][i] = nameValuePair.getValue();
                objectArray2[j] = bl ? StringUtils.trimSingleQuotes(string2.toString()) : "";
            }
        }
        graphDataModel.addColumnLabels(objectArray2);
        graphDataModel.addRowLabels(objectArray3);
        graphDataModel.addRowColors(new Color[]{_BASE_CHART_COLOR});
        graphDataModel.addGraphData(objectArray);
        if (bl) {
            graphDataModel.setTitle(string);
            graphDataModel.setDepthRadius(this.depthRadius);
        }
        graphDataModel.setLegendVisible(false);
        return graphDataModel;
    }

    GraphDataModel createDetailedRefreshedGraphModel(String string, AttributeHistogramArray attributeHistogramArray) {
        boolean bl = true;
        GraphDataModel graphDataModel = this.initGraphModel();
        ArrayList<String> arrayList = attributeHistogramArray.getBarTitles();
        if (arrayList == null || arrayList.isEmpty()) {
            return graphDataModel;
        }
        int n = arrayList.size();
        int n2 = 1;
        Object[][] objectArray = new Object[n][n2];
        Object[] objectArray2 = new Object[n];
        Object[] objectArray3 = new String[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray3[i] = bl ? DataProfileStatisticsLrb.get("HISTOGRAM_Y_AXIS") : "";
            for (int j = 0; j < n; ++j) {
                String string2 = arrayList.get(j);
                ArrayList<NameValuePair> arrayList2 = attributeHistogramArray.getBarArray(string2.toString());
                NameValuePair nameValuePair = arrayList2.get(0);
                Object object = nameValuePair.getValue();
                assert (object instanceof Double) : "Wrong data for this graph";
                objectArray[j][i] = nameValuePair.getValue();
                objectArray2[j] = bl ? string2 : "";
            }
        }
        graphDataModel.addColumnLabels(objectArray2);
        graphDataModel.addRowLabels(objectArray3);
        graphDataModel.addRowColors(new Color[]{_BASE_CHART_COLOR});
        graphDataModel.addGraphData(objectArray);
        if (bl) {
            graphDataModel.setTitle(string);
            graphDataModel.setDepthRadius(this.depthRadius);
        }
        graphDataModel.setLegendVisible(false);
        return graphDataModel;
    }

    GraphDataModel createBriefRefreshedGraphModel(String string, AttributeHistogramArray attributeHistogramArray) {
        boolean bl = true;
        GraphDataModel graphDataModel = this.initGraphModel();
        ArrayList<String> arrayList = attributeHistogramArray.getBarTitles();
        if (arrayList == null || arrayList.isEmpty()) {
            return graphDataModel;
        }
        int n = arrayList.size();
        int n2 = 1;
        Object[][] objectArray = new Object[n][n2];
        Object[] objectArray2 = new Object[n];
        Object[] objectArray3 = new String[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray3[i] = bl ? DataProfileStatisticsLrb.get("HISTOGRAM_Y_AXIS") : "";
            for (int j = 0; j < n; ++j) {
                String string2 = arrayList.get(j);
                ArrayList<NameValuePair> arrayList2 = attributeHistogramArray.getBarArray(string2.toString());
                NameValuePair nameValuePair = arrayList2.get(0);
                Object object = nameValuePair.getValue();
                assert (object instanceof Double) : "Wrong data for this graph";
                objectArray[j][i] = nameValuePair.getValue();
                objectArray2[j] = bl ? string2 : "";
            }
        }
        graphDataModel.addColumnLabels(objectArray2);
        graphDataModel.addRowLabels(objectArray3);
        graphDataModel.addRowColors(new Color[]{_BASE_CHART_COLOR});
        graphDataModel.addGraphData(objectArray);
        graphDataModel.setTitle(null);
        graphDataModel.setLegendVisible(false);
        graphDataModel.setDepthRadius(0);
        graphDataModel.setLineDataLineDisplayed(false);
        return graphDataModel;
    }

    private void clearServerResults() {
        if (this._serverHistograms != null) {
            this._serverHistograms.clear();
        }
        if (this._serverDataPoints != null) {
            this._serverDataPoints.clear();
        }
    }

    private void clearRefreshedResults() {
        if (this._refreshHistograms != null) {
            this._refreshHistograms.clear();
            if (this._refreshDataPoints != null) {
                this._refreshDataPoints.clear();
                this._refreshDataPoints = null;
            }
        }
    }

    private static List<DataProfileStatisticsData> getDataPoints(HashMap<String, DataProfileStatisticsData> hashMap) {
        ArrayList<DataProfileStatisticsData> arrayList = new ArrayList<DataProfileStatisticsData>();
        arrayList.addAll(hashMap.values());
        return arrayList;
    }

    private static void addPoint(HashMap<String, DataProfileStatisticsData> hashMap, HashMap<String, AttributeHistogramArray> hashMap2, String string, String string2, Double d, Integer n, Double d2, String string3, Object object, Object object2, String string4, String string5, Double d3, Double d4, Double d5, Double d6, Object object3, String string6, Double d7, boolean bl) {
        AttributeHistogramArray attributeHistogramArray;
        if (null == hashMap.get(string)) {
            hashMap.put(string, new DataProfileStatisticsData(string, string2, d, n, d2, string3, object, object2, string4, string5, d3, d4, d5, d6));
        }
        if ((attributeHistogramArray = hashMap2.get(string)) == null) {
            attributeHistogramArray = new AttributeHistogramArray();
            hashMap2.put(string, attributeHistogramArray);
        }
        if (bl) {
            attributeHistogramArray.addPoint(object3, string6, d7);
        }
    }

    public void updateRefreshedData(String string, AttributeHistogramArray attributeHistogramArray, DataProfileStatisticsData dataProfileStatisticsData) throws Exception {
        if (this._refreshDataPoints == null) {
            this._refreshDataPoints = new HashMap();
            this._refreshStatsTable = this._refreshSingleColumnStatsTable;
            this._refreshSingleColumnStatsTable = null;
        }
        String string2 = TransformationStatisticsState.getQuotedName(string);
        this._refreshHistograms.put(string2, attributeHistogramArray);
        this._refreshDataPoints.put(string2, dataProfileStatisticsData);
        this.resetModifiedState(string);
    }

    public void updateRefreshedDataWiz(List<String> list, HashMap<String, AttributeHistogramArray> hashMap, Map<String, DataProfileStatisticsData> map) throws Exception {
        if (this._refreshDataPoints == null) {
            this._refreshDataPoints = new HashMap();
            this._refreshStatsTable = this._refreshSingleColumnStatsTable;
            this._refreshSingleColumnStatsTable = null;
        }
        for (String string : list) {
            String string2 = TransformationStatisticsState.getQuotedName(string);
            this._refreshHistograms.put(string2, hashMap.get(string2));
            this._refreshDataPoints.put(string2, map.get(string2));
        }
        for (String string : list) {
            this.resetModifiedState(string);
        }
    }

    private AttributeHistogramArray getHistogram(String string) {
        AttributeHistogramArray attributeHistogramArray = null;
        if (!this.isModified(string)) {
            if (this._serverHistograms != null) {
                attributeHistogramArray = this._serverHistograms.get(TransformationStatisticsState.getQuotedName(string));
            }
        } else if (!this.needsRefresh(string) && this._refreshHistograms != null) {
            attributeHistogramArray = this._refreshHistograms.get(TransformationStatisticsState.getQuotedName(string));
        }
        if (this.isShowNulls() || attributeHistogramArray == null) {
            return attributeHistogramArray;
        }
        return this.getNullsFilteredHistogram(attributeHistogramArray);
    }

    public AttributeHistogramArray getNullsFilteredHistogram(AttributeHistogramArray attributeHistogramArray) {
        AttributeHistogramArray attributeHistogramArray2 = new AttributeHistogramArray();
        ArrayList<NameValuePair> arrayList = attributeHistogramArray.getAttributeValuesBars();
        for (NameValuePair nameValuePair : arrayList) {
            if (nameValuePair.getName().equals("'Null bin'")) continue;
            ArrayList<NameValuePair> arrayList2 = new ArrayList<NameValuePair>();
            List list = (List)nameValuePair.getValue();
            for (NameValuePair nameValuePair2 : list) {
                NameValuePair nameValuePair3 = new NameValuePair(nameValuePair2 != null ? nameValuePair2.getName() : null, nameValuePair2.getValue());
                arrayList2.add(nameValuePair3);
            }
            NameValuePair nameValuePair4 = new NameValuePair(nameValuePair.getName(), arrayList2);
            attributeHistogramArray2.addPoint(nameValuePair4);
        }
        return attributeHistogramArray2;
    }

    void removeAllData(String string) {
        if (this._serverHistograms != null) {
            this._serverHistograms.remove(TransformationStatisticsState.getQuotedName(string));
        }
        if (this._serverDataPoints != null) {
            this._serverDataPoints.remove(TransformationStatisticsState.getQuotedName(string));
        }
        if (this._refreshHistograms != null) {
            this._refreshHistograms.remove(TransformationStatisticsState.getQuotedName(string));
        }
        if (this._refreshDataPoints != null) {
            this._refreshDataPoints.remove(TransformationStatisticsState.getQuotedName(string));
        }
    }

    public static String getQuotedName(String string) {
        if (StringUtils.isDoubleQuotedString(string)) {
            return string;
        }
        return StringUtils.addDoubleQuotes(string);
    }

    public Object getMissingValuesDefaultReplacementValue(TransformationSourceAttribute transformationSourceAttribute) {
        if (this._tableModel == null) {
            return null;
        }
        return this._tableModel.getMissingValuesReplacementValue(transformationSourceAttribute);
    }

    public Double getStd(TransformationSourceAttribute transformationSourceAttribute) {
        if (this._tableModel == null) {
            return null;
        }
        return this._tableModel.getStd(transformationSourceAttribute);
    }

    public Object getAvg(TransformationSourceAttribute transformationSourceAttribute) {
        if (this._tableModel == null) {
            return null;
        }
        return this._tableModel.getAvg(transformationSourceAttribute);
    }

    public Double getMin(String string) {
        if (this._tableModel == null) {
            return null;
        }
        return this._tableModel.getMin(string);
    }

    public Double getMax(String string) {
        if (this._tableModel == null) {
            return null;
        }
        return this._tableModel.getMax(string);
    }

    private Color[] generateColors(int n) {
        int n2 = _RESERVED_COLORS.length + _EXTRA_COLORS[0].length * 2;
        if (n > n2) {
            return this.generateRandomColors(n);
        }
        Color[] colorArray = new Color[n];
        if (n <= _RESERVED_COLORS.length) {
            System.arraycopy(_RESERVED_COLORS, 0, colorArray, 0, n);
            return colorArray;
        }
        System.arraycopy(_RESERVED_COLORS, 0, colorArray, 0, _RESERVED_COLORS.length);
        int n3 = _RESERVED_COLORS.length;
        int n4 = n - n3;
        if (n4 < _EXTRA_COLORS[0].length) {
            System.arraycopy(_EXTRA_COLORS[0], 0, colorArray, n3, n4);
            return colorArray;
        }
        System.arraycopy(_EXTRA_COLORS[0], 0, colorArray, n3, _EXTRA_COLORS[0].length);
        n4 = n - (n3 += _EXTRA_COLORS[0].length);
        System.arraycopy(_EXTRA_COLORS[1], 0, colorArray, n3, n4);
        return colorArray;
    }

    private Color[] generateRandomColors(int n) {
        Color[] colorArray = new Color[n];
        int n2 = 2;
        while (!(Math.pow(++n2, 3.0) >= (double)n)) {
        }
        int n3 = 255 / n2;
        int n4 = 0;
        block1: for (int i = 255; i >= 0; i -= n3) {
            for (int j = 0; j <= 255; j += n3) {
                for (int k = 255; k >= 0; k -= n3) {
                    colorArray[n4++] = new Color(i, j, k);
                    if (n4 == n - 1) break block1;
                }
            }
        }
        return colorArray;
    }

    private static String getStackedSQL(TransformationNode transformationNode) {
        AbstractNode abstractNode = transformationNode.findParentNode();
        assert (abstractNode instanceof DataProvider);
        DataProvider dataProvider = (DataProvider)((Object)abstractNode);
        return dataProvider.getInputSQL();
    }

    public void setDistinctValues(String string, List<String> list) {
        this.distinctValues.remove(string);
        this.distinctValues.put(string, new ArrayList<String>(list));
    }

    public void setDistinctValuesFrequencies(String string, List<NameValuePair> list) {
        this.distinctValues.remove(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (NameValuePair nameValuePair : list) {
            arrayList.add(nameValuePair.getName());
            arrayList2.add((Integer)nameValuePair.getValue());
        }
        this.distinctValues.put(string, new ArrayList(arrayList));
        this.frequencies.put(string, new ArrayList(arrayList2));
    }

    public List<String> getDistinctValues(String string) {
        if (this.distinctValues.isEmpty()) {
            this.getDistinctValuesAndFrequenciesFromDB(string);
        }
        return this.distinctValues.get(string);
    }

    public List<Integer> getFrequencies(String string) {
        if (this.frequencies.isEmpty()) {
            this.getDistinctValuesAndFrequenciesFromDB(string);
        }
        return this.frequencies.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Vector<NameValuePair> generateDefaultBinsXform(String string, String string2, TransformationType.Binning binning) throws Exception {
        Vector<NameValuePair> vector = null;
        Connection connection = null;
        try {
            connection = Connections.getUniqueConnection(this._context);
            ConnectionFolder.setConnectionAlterSessionFixes(connection);
            vector = string2.equals("DATE") || DatabaseMetadataUtils.isTimestamp(string2) || DatabaseMetadataUtils.isTimestampWithLocalTimeZone(string2) ? TransformationStatisticsState._generateDefaultDateBins1(connection, this._transformationNode, string, binning, false) : (DatabaseMetadataUtils.isTimestampWithTimeZone(string2) ? TransformationStatisticsState._generateDefaultDateBins1(connection, this._transformationNode, string, binning, true) : TransformationStatisticsState._generateDefaultBins1(connection, this._transformationNode, string, string2, binning));
        }
        finally {
            SQLHelper.close(connection);
        }
        return vector;
    }

    public static Vector<NameValuePair> generateDefaultBins(Connection connection, String string, String string2, String string3, TransformationType.Binning binning) throws Exception {
        if (string3.equals("DATE") || DatabaseMetadataUtils.isTimestamp(string3) || DatabaseMetadataUtils.isTimestampWithLocalTimeZone(string3)) {
            return TransformationStatisticsState._generateDefaultDateBins2(connection, string, string2, binning, false);
        }
        if (DatabaseMetadataUtils.isTimestampWithTimeZone(string3)) {
            return TransformationStatisticsState._generateDefaultDateBins2(connection, string, string2, binning, true);
        }
        return TransformationStatisticsState._generateDefaultBins2(connection, string, string2, string3, binning);
    }

    private static Vector<NameValuePair> _generateDefaultBins1(Connection connection, TransformationNode transformationNode, String string, String string2, TransformationType.Binning binning) throws Exception {
        String string3 = TransformationStatisticsState.getStackedSQL(transformationNode);
        if (binning.getTopN() != null) {
            return TransformationStatisticsState._generateDefaultBinsTopN(connection, string3, string, binning);
        }
        return TransformationStatisticsState._generateDefaultBinsCommon(connection, string3, string, string2, binning);
    }

    private static Vector<NameValuePair> _generateDefaultBins2(Connection connection, String string, String string2, String string3, TransformationType.Binning binning) throws Exception {
        return TransformationStatisticsState._generateDefaultBinsCommon(connection, string, string2, string3, binning);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector<NameValuePair> _generateDefaultBinsCommon(Connection connection, String string, String string2, String string3, TransformationType.Binning binning) throws Exception {
        int n;
        String string4;
        Vector<NameValuePair> vector = new Vector<NameValuePair>();
        if (string == null) {
            return vector;
        }
        int n2 = 0;
        BigInteger bigInteger = null;
        BinLabels binLabels = null;
        boolean bl = false;
        if (null != binning.getEqualWidth()) {
            string4 = EQWIDTH;
            n2 = null != binning.getEqualWidth().getBinGeneration().getAuto() ? 1 : 0;
            bigInteger = binning.getEqualWidth().getBinCount();
            binLabels = binning.getEqualWidth().getBinLabels();
        } else if (null != binning.getDateEqualWidth()) {
            string4 = EQWIDTH;
            n2 = null != binning.getDateEqualWidth().getBinGeneration().getAuto() ? 1 : 0;
            bigInteger = binning.getDateEqualWidth().getBinCount();
            binLabels = binning.getDateEqualWidth().getBinLabels();
        } else if (null != binning.getTimestampEqualWidth()) {
            string4 = EQWIDTH;
            n2 = null != binning.getTimestampEqualWidth().getBinGeneration().getAuto() ? 1 : 0;
            bigInteger = binning.getTimestampEqualWidth().getBinCount();
            binLabels = binning.getTimestampEqualWidth().getBinLabels();
        } else if (null != binning.getQuantile()) {
            string4 = QTILE;
            n2 = null != binning.getQuantile().getBinGeneration().getAuto() ? 1 : 0;
            bigInteger = binning.getQuantile().getBinCount();
            binLabels = binning.getQuantile().getBinLabels();
        } else {
            string4 = TOPN;
            bigInteger = BigInteger.valueOf(binning.getTopN().getBinCount().intValue() - 1);
        }
        int n3 = n = bigInteger != null ? bigInteger.intValue() : 0;
        if (binLabels != null) {
            bl = null != binLabels.getNumberSequence();
        }
        OracleCallableStatement oracleCallableStatement = null;
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            int n4;
            String[] stringArray;
            int n5;
            ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)ODMR_OBJECT_NAMES, (Connection)connection);
            ArrayDescriptor arrayDescriptor2 = ArrayDescriptor.createDescriptor((String)ODMR_OBJECT_IDS, (Connection)connection);
            ArrayDescriptor arrayDescriptor3 = ArrayDescriptor.createDescriptor((String)ODMR_OBJECT_VALUES, (Connection)connection);
            ARRAY aRRAY = new ARRAY(arrayDescriptor, connection, (Object)new String[0]);
            ARRAY aRRAY2 = new ARRAY(arrayDescriptor2, connection, (Object)new String[0]);
            ARRAY aRRAY3 = new ARRAY(arrayDescriptor3, connection, (Object)new String[0]);
            ARRAY aRRAY4 = new ARRAY(arrayDescriptor3, connection, (Object)new String[0]);
            ARRAY aRRAY5 = new ARRAY(arrayDescriptor3, connection, (Object)new String[0]);
            String string5 = StringUtils.isDoubleQuotedString(string2) ? string2 : StringUtils.addDoubleQuotes(string2);
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("{call ODMR_UTIL.GENERATE_DEFAULT_BINS(?,?,?,?,?,?,?,?,?,?,?)}");
            int n6 = 1;
            oracleCallableStatement.setCharacterStream(n6++, (Reader)new StringReader(string), string.length());
            oracleCallableStatement.setArray(n6++, (Array)aRRAY);
            oracleCallableStatement.setArray(n6++, (Array)aRRAY2);
            oracleCallableStatement.setArray(n6++, (Array)aRRAY3);
            oracleCallableStatement.setArray(n6++, (Array)aRRAY4);
            oracleCallableStatement.setArray(n6++, (Array)aRRAY5);
            oracleCallableStatement.setString(n6++, string5);
            oracleCallableStatement.setString(n6++, string3);
            oracleCallableStatement.setString(n6++, string4);
            oracleCallableStatement.setInt(n6++, n2);
            oracleCallableStatement.setInt(n6++, n);
            n6 = 2;
            oracleCallableStatement.registerOutParameter(n6++, 2003, ODMR_OBJECT_NAMES);
            oracleCallableStatement.registerOutParameter(n6++, 2003, ODMR_OBJECT_IDS);
            oracleCallableStatement.registerOutParameter(n6++, 2003, ODMR_OBJECT_VALUES);
            oracleCallableStatement.registerOutParameter(n6++, 2003, ODMR_OBJECT_VALUES);
            oracleCallableStatement.registerOutParameter(n6++, 2003, ODMR_OBJECT_VALUES);
            oracleCallableStatement.execute();
            n6 = 2;
            ARRAY aRRAY6 = oracleCallableStatement.getARRAY(n6++);
            ARRAY aRRAY7 = oracleCallableStatement.getARRAY(n6++);
            BigDecimal[] bigDecimalArray = (BigDecimal[])aRRAY7.getArray();
            Double[] doubleArray = new Double[bigDecimalArray.length];
            for (int i = 0; i < bigDecimalArray.length; ++i) {
                doubleArray[i] = bigDecimalArray[i].doubleValue();
            }
            ARRAY aRRAY8 = oracleCallableStatement.getARRAY(n6++);
            String[] stringArray2 = (String[])aRRAY8.getArray();
            ARRAY aRRAY9 = oracleCallableStatement.getARRAY(n6++);
            String[] stringArray3 = (String[])aRRAY9.getArray();
            ARRAY aRRAY10 = oracleCallableStatement.getARRAY(n6++);
            String[] stringArray4 = (String[])aRRAY10.getArray();
            if (stringArray3 != null && stringArray3.length > 0 && stringArray3[0] == null) {
                n5 = 0;
                stringArray = new String[stringArray3.length + 1];
                stringArray[n5] = "1";
                for (n4 = 1; n4 < stringArray3.length - 1; ++n4) {
                    ++n5;
                    try {
                        stringArray[n5] = String.valueOf(Integer.valueOf(stringArray3[n4]) + 1);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        stringArray[n5] = stringArray3[n4];
                    }
                }
                stringArray[n5 + 1] = String.valueOf(Integer.valueOf(stringArray[n5]) + 1);
            } else {
                stringArray = stringArray3;
            }
            if (string4.equals(TOPN)) {
                HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
                for (n4 = 0; n4 < stringArray2.length; ++n4) {
                    object4 = stringArray2[n4];
                    object3 = stringArray2[n4];
                    if (object3 == null || null != hashMap.get(object3)) continue;
                    object2 = new ArrayList();
                    object2.add(object4);
                    object = new NameValuePair((String)object3, object2, n4);
                    vector.add((NameValuePair)object);
                    hashMap.put(object3, object);
                }
            } else {
                n5 = 0;
                for (n4 = 1; n4 < doubleArray.length - 2; ++n4) {
                    object4 = null;
                    object3 = doubleArray[n4];
                    Object object5 = object2 = object3 != null ? ((Double)object3).toString() : "0";
                    if (n4 == 1) {
                        object4 = !bl ? new NameValuePair(UNBOUNDED + " - " + (String)object2, (Object)NO_LOWER_BOUND, n5) : new NameValuePair(stringArray[n5], (Object)NO_LOWER_BOUND, n5);
                        ++n5;
                        vector.add((NameValuePair)object4);
                    }
                    if (!bl) {
                        object = doubleArray[n4] + " - " + doubleArray[n4 + 1];
                        object4 = new NameValuePair((String)object, (Object)doubleArray[n4].toString(), n5);
                    } else {
                        object4 = new NameValuePair(stringArray[n5], (Object)doubleArray[n4].toString(), n5);
                    }
                    ++n5;
                    vector.add((NameValuePair)object4);
                }
                NameValuePair nameValuePair = null;
                if (doubleArray != null && doubleArray.length > 0) {
                    object4 = doubleArray[doubleArray.length - 2] + "";
                    nameValuePair = !bl ? new NameValuePair((String)object4 + " - " + UNBOUNDED, object4, n5) : new NameValuePair(stringArray[n5], object4, n5);
                    vector.add(nameValuePair);
                }
            }
            if (string4.equals(TOPN) && !vector.isEmpty()) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (int i = 0; i < stringArray4.length; ++i) {
                    object4 = stringArray4[i];
                    if (object4 == null || ((String)object4).isEmpty()) continue;
                    object4 = stringArray4[i];
                    if (object4 == null || ((String)object4).isEmpty()) {
                        object4 = XformDialogsLrb.get("TRANSFORM_NULL_VALUE");
                    }
                    arrayList.add(object4);
                }
                vector.add(new NameValuePair(LIST_OF_DISTINCT_VALUES, arrayList));
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)WorkflowDialogLrb.get("UNEXPECTED_ERROR_TITLE"), (String)WorkflowDialogLrb.get("UNEXPECTED_ERROR_MESG"));
            vector.clear();
        }
        finally {
            if (oracleCallableStatement != null) {
                oracleCallableStatement.close();
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector<NameValuePair> _generateDefaultBinsTopN(Connection connection, String string, String string2, TransformationType.Binning binning) throws Exception {
        Vector<NameValuePair> vector = new Vector<NameValuePair>();
        if (string == null) {
            return vector;
        }
        BigInteger bigInteger = BigInteger.valueOf(binning.getTopN().getBinCount().intValue() - 1);
        int n = bigInteger != null ? bigInteger.intValue() : 0;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            String string3;
            int n2;
            String[] stringArray;
            ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)ODMR_OBJECT_NAMES, (Connection)connection);
            ArrayDescriptor arrayDescriptor2 = ArrayDescriptor.createDescriptor((String)ODMR_OBJECT_IDS, (Connection)connection);
            ArrayDescriptor arrayDescriptor3 = ArrayDescriptor.createDescriptor((String)ODMR_OBJECT_VALUES, (Connection)connection);
            ARRAY aRRAY = new ARRAY(arrayDescriptor, connection, (Object)new String[0]);
            ARRAY aRRAY2 = new ARRAY(arrayDescriptor3, connection, (Object)new String[0]);
            ARRAY aRRAY3 = new ARRAY(arrayDescriptor3, connection, (Object)new String[0]);
            ARRAY aRRAY4 = new ARRAY(arrayDescriptor3, connection, (Object)new String[0]);
            ARRAY aRRAY5 = new ARRAY(arrayDescriptor2, connection, (Object)new Integer[0]);
            String string4 = StringUtils.isDoubleQuotedString(string2) ? string2 : StringUtils.addDoubleQuotes(string2);
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("{call ODMR_UTIL.GENERATE_DEFAULT_BINS_TOPN(?,?,?,?,?,?,?,?)}");
            int n3 = 1;
            oracleCallableStatement.setCharacterStream(n3++, (Reader)new StringReader(string), string.length());
            oracleCallableStatement.setArray(n3++, (Array)aRRAY);
            oracleCallableStatement.setArray(n3++, (Array)aRRAY2);
            oracleCallableStatement.setArray(n3++, (Array)aRRAY3);
            oracleCallableStatement.setArray(n3++, (Array)aRRAY4);
            oracleCallableStatement.setArray(n3++, (Array)aRRAY5);
            oracleCallableStatement.setString(n3++, string4);
            oracleCallableStatement.setInt(n3++, n);
            n3 = 2;
            oracleCallableStatement.registerOutParameter(n3++, 2003, ODMR_OBJECT_NAMES);
            oracleCallableStatement.registerOutParameter(n3++, 2003, ODMR_OBJECT_VALUES);
            oracleCallableStatement.registerOutParameter(n3++, 2003, ODMR_OBJECT_VALUES);
            oracleCallableStatement.registerOutParameter(n3++, 2003, ODMR_OBJECT_VALUES);
            oracleCallableStatement.registerOutParameter(n3++, 2003, ODMR_OBJECT_IDS);
            oracleCallableStatement.execute();
            n3 = 2;
            ARRAY aRRAY6 = oracleCallableStatement.getARRAY(n3++);
            ARRAY aRRAY7 = oracleCallableStatement.getARRAY(n3++);
            String[] stringArray2 = (String[])aRRAY7.getArray();
            ARRAY aRRAY8 = oracleCallableStatement.getARRAY(n3++);
            String[] stringArray3 = (String[])aRRAY8.getArray();
            ARRAY aRRAY9 = oracleCallableStatement.getARRAY(n3++);
            String[] stringArray4 = (String[])aRRAY9.getArray();
            ARRAY aRRAY10 = oracleCallableStatement.getARRAY(n3++);
            BigDecimal[] bigDecimalArray = (BigDecimal[])aRRAY10.getArray();
            if (stringArray3 != null && stringArray3.length > 0 && stringArray3[0] == null) {
                int n4 = 0;
                stringArray = new String[stringArray3.length + 1];
                stringArray[n4] = "1";
                for (n2 = 1; n2 < stringArray3.length - 1; ++n2) {
                    ++n4;
                    try {
                        stringArray[n4] = String.valueOf(Integer.valueOf(stringArray3[n2]) + 1);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        stringArray[n4] = stringArray3[n2];
                    }
                }
                stringArray[n4 + 1] = String.valueOf(Integer.valueOf(stringArray[n4]) + 1);
            } else {
                stringArray = stringArray3;
            }
            HashMap<String, NameValuePair> hashMap = new HashMap<String, NameValuePair>();
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                String string5 = stringArray2[n2];
                string3 = stringArray2[n2];
                if (string3 == null || null != hashMap.get(string3)) continue;
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string5);
                NameValuePair nameValuePair = new NameValuePair(string3, arrayList, n2);
                vector.add(nameValuePair);
                hashMap.put(string3, nameValuePair);
            }
            if (!vector.isEmpty()) {
                ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
                for (int i = 0; i < stringArray4.length; ++i) {
                    string3 = stringArray4[i];
                    if (string3 == null || string3.isEmpty()) continue;
                    int n5 = bigDecimalArray[i].intValue();
                    string3 = stringArray4[i];
                    if (string3 == null || string3.isEmpty()) {
                        string3 = XformDialogsLrb.get("TRANSFORM_NULL_VALUE");
                    }
                    arrayList.add(new NameValuePair(string3, n5));
                }
                vector.add(new NameValuePair(LIST_OF_DISTINCT_VALUES, arrayList));
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)WorkflowDialogLrb.get("UNEXPECTED_ERROR_TITLE"), (String)WorkflowDialogLrb.get("UNEXPECTED_ERROR_MESG"));
            vector.clear();
        }
        finally {
            if (oracleCallableStatement != null) {
                oracleCallableStatement.close();
            }
        }
        return vector;
    }

    private static String removeWithClause(String string, String string2) {
        int n = string.indexOf("WITH");
        if (n == -1) {
            String string3 = queryDateTemplate;
            string3 = StringUtils.getReplacedString(string3, "<column>", string2);
            string3 = StringUtils.getReplacedString(string3, "<table_name>", string);
            return string3;
        }
        int n2 = string.indexOf("*/");
        int n3 = string.indexOf(" as ");
        if (n3 == -1) {
            n3 = string.indexOf(" AS ");
        }
        String string4 = string.substring(n2 + 2, n3);
        n3 = string.toLowerCase().indexOf("/* END OF SQL FOR NODE:".toLowerCase());
        String string5 = string.substring(0, n3);
        String string6 = queryDateTemplate_no_with;
        string6 = StringUtils.getReplacedString(string6, "<column>", string2);
        string6 = StringUtils.getReplacedString(string6, "<stacked_sql_view>", string5);
        string6 = StringUtils.getReplacedString(string6, "<table_name>", string4);
        return string6;
    }

    private static Vector<NameValuePair> _generateDefaultDateBins1(Connection connection, TransformationNode transformationNode, String string, TransformationType.Binning binning, boolean bl) throws Exception {
        String string2 = TransformationStatisticsState.getStackedSQL(transformationNode);
        return TransformationStatisticsState._generateDefaultDateBinsCommon(connection, string2, string, binning, bl);
    }

    private static Vector<NameValuePair> _generateDefaultDateBins2(Connection connection, String string, String string2, TransformationType.Binning binning, boolean bl) throws Exception {
        return TransformationStatisticsState._generateDefaultDateBinsCommon(connection, string, string2, binning, bl);
    }

    private static Vector<NameValuePair> _generateDefaultDateBinsCommon(Connection connection, String string, String string2, TransformationType.Binning binning, boolean bl) throws Exception {
        int n;
        if (bl) {
            return TransformationStatisticsState._generateDefaultTZBins(connection, string, string2, binning);
        }
        Vector<NameValuePair> vector = new Vector<NameValuePair>();
        if (string == null) {
            return vector;
        }
        boolean bl2 = false;
        BigInteger bigInteger = null;
        BinLabels binLabels = null;
        boolean bl3 = false;
        if (null == binning.getDateEqualWidth()) {
            return vector;
        }
        bl2 = null != binning.getDateEqualWidth().getBinGeneration().getAuto();
        bigInteger = binning.getDateEqualWidth().getBinCount();
        binLabels = binning.getDateEqualWidth().getBinLabels();
        int n2 = n = bigInteger != null ? bigInteger.intValue() : 0;
        if (binLabels != null) {
            bl3 = null != binLabels.getNumberSequence();
        }
        Date date = null;
        Timestamp timestamp = null;
        OraclePreparedStatement oraclePreparedStatement = null;
        try {
            Comparable<Integer> comparable;
            String string3 = StringUtils.isDoubleQuotedString(string2) ? string2 : StringUtils.addDoubleQuotes(string2);
            String string4 = TransformationStatisticsState.removeWithClause(string, string3);
            oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement(string4);
            OracleResultSet oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
            String string5 = NO_LOWER_BOUND;
            SimpleDateFormat simpleDateFormat = null;
            long l = 0L;
            if (oracleResultSet.next()) {
                date = oracleResultSet.getTimestamp("min_value");
                timestamp = oracleResultSet.getTimestamp("max_value");
                l = (((Date)timestamp).getTime() - date.getTime()) / (long)n;
                simpleDateFormat = TimeUtils.getShortSimpleDateFormat();
            }
            StringBuffer stringBuffer = new StringBuffer();
            date = new Date(date.getTime() + l);
            StringBuffer stringBuffer2 = simpleDateFormat.format(date, stringBuffer, new FieldPosition(0));
            NameValuePair nameValuePair = null;
            Integer n3 = 1;
            String string6 = n3.toString();
            nameValuePair = !bl3 ? new NameValuePair(UNBOUNDED + " - " + stringBuffer2.toString(), (Object)NO_LOWER_BOUND, (int)n3) : new NameValuePair(string6, (Object)NO_LOWER_BOUND, (int)n3);
            string5 = stringBuffer2.toString();
            vector.add(nameValuePair);
            for (int i = 1; i < n - 1; ++i) {
                comparable = n3;
                n3 = n3 + 1;
                Comparable<Integer> comparable2 = n3;
                string6 = n3.toString();
                comparable = new Date(date.getTime() + l * (long)i);
                stringBuffer = new StringBuffer();
                comparable2 = simpleDateFormat.format((Date)comparable, stringBuffer, new FieldPosition(0));
                if (!bl3) {
                    String string7 = string5 + " - " + ((StringBuffer)comparable2).toString();
                    nameValuePair = new NameValuePair(string7, (Object)string5, (int)n3);
                } else {
                    nameValuePair = new NameValuePair(string6, (Object)string5, (int)n3);
                }
                string5 = ((StringBuffer)comparable2).toString();
                vector.add(nameValuePair);
            }
            if (!vector.isEmpty()) {
                if (!bl3) {
                    nameValuePair = new NameValuePair(string5 + " - " + UNBOUNDED, (Object)string5, vector.size() + 1);
                    vector.add(nameValuePair);
                } else {
                    Integer n4 = n3;
                    comparable = n3 = Integer.valueOf(n3 + 1);
                    string6 = n3.toString();
                    nameValuePair = new NameValuePair(string6, (Object)string5, (int)n3);
                    vector.add(nameValuePair);
                }
            }
        }
        catch (Exception exception) {
            vector.clear();
            throw exception;
        }
        finally {
            if (oraclePreparedStatement != null) {
                oraclePreparedStatement.close();
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector<NameValuePair> _generateDefaultTZBins(Connection connection, String string, String string2, TransformationType.Binning binning) throws Exception {
        int n;
        Vector<NameValuePair> vector = new Vector<NameValuePair>();
        if (string == null) {
            return vector;
        }
        boolean bl = false;
        BigInteger bigInteger = null;
        BinLabels binLabels = null;
        boolean bl2 = false;
        if (null == binning.getTimestampEqualWidth()) {
            return vector;
        }
        bl = null != binning.getTimestampEqualWidth().getBinGeneration().getAuto();
        bigInteger = binning.getTimestampEqualWidth().getBinCount();
        binLabels = binning.getTimestampEqualWidth().getBinLabels();
        int n2 = n = bigInteger != null ? bigInteger.intValue() : 0;
        if (binLabels != null) {
            bl2 = null != binLabels.getNumberSequence();
        }
        OraclePreparedStatement oraclePreparedStatement = null;
        Statement statement = null;
        try {
            Object object;
            String string3 = StringUtils.isDoubleQuotedString(string2) ? string2 : StringUtils.addDoubleQuotes(string2);
            statement = connection.prepareCall("{ ? = call ODMR_UTIL.GENERATE_DEFAULT_TS_TZ_BINS(?,?,?)}");
            int n3 = 1;
            statement.registerOutParameter(n3++, 12);
            statement.setCharacterStream(n3++, new StringReader(string), string.length());
            statement.setString(n3++, string3);
            statement.setInt(n3++, n);
            statement.execute();
            n3 = 1;
            String string4 = statement.getString(n3);
            if (statement != null) {
                statement.close();
                statement = null;
            }
            String string5 = "select to_char(to_timestamp_tz(lower_bound,'dd.mm.yyyy hh24:mi:ss tzh:tzm'),'YYYY-MM-DD HH24:MI:SS TZH:TZM') lower_bound,to_char(to_timestamp_tz(upper_bound,'dd.mm.yyyy hh24:mi:ss tzh:tzm'),'YYYY-MM-DD HH24:MI:SS TZH:TZM') upper_bound from " + string4;
            oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement(string5);
            OracleResultSet oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
            Integer n4 = 0;
            String string6 = null;
            while (oracleResultSet.next()) {
                Integer n5;
                Integer n6;
                Object object2;
                if (n4 >= n) continue;
                object = oracleResultSet.getString("lower_bound");
                String string7 = oracleResultSet.getString("upper_bound");
                if (n4 == 0) {
                    object2 = n4;
                    n6 = n4 = Integer.valueOf(n4 + 1);
                    continue;
                }
                object2 = null;
                if (!bl2) {
                    if (n4 == 1) {
                        n6 = n4;
                        n5 = n4 = Integer.valueOf(n4 + 1);
                        object2 = new NameValuePair(UNBOUNDED + " - " + (String)object, (Object)NO_LOWER_BOUND, (int)n6);
                        vector.add((NameValuePair)object2);
                    }
                    n6 = n4;
                    n5 = n4 = Integer.valueOf(n4 + 1);
                    object2 = new NameValuePair((String)object + " - " + string7, object, (int)n6);
                } else {
                    if (n4 == 1) {
                        String string8 = n4.toString();
                        n6 = n4;
                        n5 = n4 = Integer.valueOf(n4 + 1);
                        object2 = new NameValuePair(string8, (Object)NO_LOWER_BOUND, (int)n6);
                        vector.add((NameValuePair)object2);
                    }
                    String string9 = n4.toString();
                    n6 = n4;
                    n5 = n4 = Integer.valueOf(n4 + 1);
                    object2 = new NameValuePair(string9, object, (int)n6);
                }
                string6 = string7;
                vector.add((NameValuePair)object2);
            }
            object = null;
            if (!vector.isEmpty()) {
                object = !bl2 ? new NameValuePair(string6 + " - " + UNBOUNDED, string6, (int)n4) : new NameValuePair(n4.toString(), string6, (int)n4);
                vector.add((NameValuePair)object);
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            vector.clear();
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (oraclePreparedStatement != null) {
                oraclePreparedStatement.close();
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refreshAllStatistics() throws Exception {
        if (this.isUpToDate()) {
            return false;
        }
        try {
            ArrayList<String> arrayList = null;
            ArrayList<String> arrayList2 = null;
            for (TransformationSourceAttribute transformationSourceAttribute : this._transformationSourceAttributes) {
                DataProfileStatisticsData dataProfileStatisticsData;
                if (null != this.findTransformedColumn(transformationSourceAttribute.getName()) || (dataProfileStatisticsData = this._tableModel.getDataProfileStatisticsData(transformationSourceAttribute.getName())) != null) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    arrayList2 = new ArrayList<String>();
                }
                arrayList.add(transformationSourceAttribute.getName());
                arrayList2.add(transformationSourceAttribute.getDataType());
            }
            this._refreshStatsTable = TransformationStatisticsState.refreshStatistics(this._context, arrayList, arrayList2, this._transformedAttributes, this._transformationNode, this._refreshStatsTable, this.getServerStatisticalTable());
            boolean bl = true;
            return bl;
        }
        finally {
            this.clearRefreshedResults();
        }
    }

    public void refreshSingleColumnStatistics(String string) throws Exception {
        Object object;
        Object object22;
        if (!this.isModified(string)) {
            return;
        }
        TransformedAttributes transformedAttributes = new TransformedAttributes();
        List list = transformedAttributes.getMapTransformedSourceType();
        if (null != this._transformedAttributes && !this._transformedAttributes.getMapTransformedSourceType().isEmpty()) {
            for (Object object22 : this._transformedAttributes.getMapTransformedSourceType()) {
                object = object22.getKey();
                if (!object.getName().equals(string)) continue;
                list.add(object22);
                break;
            }
        }
        Object object3 = null;
        object22 = null;
        for (TransformationSourceAttribute transformationSourceAttribute : this._transformationSourceAttributes) {
            DataProfileStatisticsData dataProfileStatisticsData;
            if (null != this.findTransformedColumn(transformationSourceAttribute.getName()) || DatabaseMetadataUtils.isACustomDataType(this._context, transformationSourceAttribute.getDataType()) || (dataProfileStatisticsData = this._tableModel.getDataProfileStatisticsData(transformationSourceAttribute.getName())) != null) continue;
            if (object3 == null) {
                object3 = new ArrayList();
                object22 = new ArrayList();
            }
            object3.add((String)transformationSourceAttribute.getName());
            object22.add(transformationSourceAttribute.getDataType());
        }
        object = this.getServerStatisticalTable();
        if (object != null) {
            this._refreshSingleColumnStatsTable = TransformationStatisticsState.refreshStatistics(this._context, object3, (List<String>)object22, transformedAttributes, this._transformationNode, this._refreshSingleColumnStatsTable, (String)object);
        }
    }

    public void refreshSelectedColumnsStatistics(List<String> list) throws Exception {
        Object object2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String object22 : list) {
            if (!this.isModified(object22)) continue;
            hashMap.put(object22, object22);
        }
        TransformedAttributes transformedAttributes = new TransformedAttributes();
        List list2 = transformedAttributes.getMapTransformedSourceType();
        if (null != this._transformedAttributes && !this._transformedAttributes.getMapTransformedSourceType().isEmpty()) {
            for (Object object2 : this._transformedAttributes.getMapTransformedSourceType()) {
                TransformationOutputAttribute transformationOutputAttribute = object2.getKey();
                if (null == hashMap.get(transformationOutputAttribute.getName())) continue;
                list2.add(object2);
            }
        }
        Object object3 = null;
        object2 = null;
        for (TransformationSourceAttribute transformationSourceAttribute : this._transformationSourceAttributes) {
            DataProfileStatisticsData dataProfileStatisticsData;
            if (null != this.findTransformedColumn(transformationSourceAttribute.getName()) || (dataProfileStatisticsData = this._tableModel.getDataProfileStatisticsData(transformationSourceAttribute.getName())) != null) continue;
            if (object3 == null) {
                object3 = new ArrayList();
                object2 = new ArrayList();
            }
            object3.add((String)transformationSourceAttribute.getName());
            object2.add(transformationSourceAttribute.getDataType());
        }
        this._refreshSingleColumnStatsTable = TransformationStatisticsState.refreshStatistics(this._context, object3, (List<String>)object2, transformedAttributes, this._transformationNode, this._refreshSingleColumnStatsTable, this.getServerStatisticalTable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String refreshStatistics(Context context, List<String> list, List<String> list2, TransformedAttributes transformedAttributes, TransformationNode transformationNode, String string, String string2) throws Exception {
        StringBuffer stringBuffer;
        Comparable<StringBuffer> comparable;
        Comparable<StringBuffer> comparable2;
        Object object;
        Object object2;
        TransformationType.Binning.CustomCategorical customCategorical;
        TransformationType transformationType;
        String string32;
        StringBuilder stringBuilder;
        Object object3;
        StringCollection stringCollection;
        Object object4;
        Object object5;
        Object object62;
        Object object7;
        Object object8;
        ResultType resultType = ((TransformationNodeType)transformationNode.getData()).getSampleSettings().getOutputTable();
        String string4 = resultType.getName();
        assert (string4 != null);
        if (list != null && !list.isEmpty() && !TransformationStatisticsState.areColumnsPresentInSampleTable(context, string4, list) && (object8 = transformationNode.findParentNode()) != null && object8 instanceof DataProvider && null != (object7 = (DataProvider)object8).getInputSQL()) {
            string4 = "(" + object7.getInputSQL() + ")";
        }
        object8 = new ArrayList();
        object7 = new ArrayList();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        ArrayList<Integer> arrayList6 = new ArrayList<Integer>();
        ArrayList<String> arrayList7 = new ArrayList<String>();
        ArrayList<Double> arrayList8 = new ArrayList<Double>();
        ArrayList<String> arrayList9 = new ArrayList<String>();
        ArrayList<String> arrayList10 = new ArrayList<String>();
        ArrayList<Integer> arrayList11 = new ArrayList<Integer>();
        ArrayList<String> arrayList12 = new ArrayList<String>();
        ArrayList<String> arrayList13 = new ArrayList<String>();
        ArrayList<String> arrayList14 = new ArrayList<String>();
        ArrayList<String> arrayList15 = new ArrayList<String>();
        ArrayList<Integer> arrayList16 = new ArrayList<Integer>();
        ArrayList<String> arrayList17 = new ArrayList<String>();
        ArrayList<String> arrayList18 = new ArrayList<String>();
        ArrayList<String> arrayList19 = new ArrayList<String>();
        ArrayList<String> arrayList20 = new ArrayList<String>();
        ArrayList<String> arrayList21 = new ArrayList<String>();
        ArrayList<Integer> arrayList22 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList23 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList24 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList25 = new ArrayList<Integer>();
        ArrayList<String> arrayList26 = new ArrayList<String>();
        ArrayList<String> arrayList27 = new ArrayList<String>();
        ArrayList<Integer> arrayList28 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList29 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList30 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList31 = new ArrayList<Integer>();
        ArrayList<String> arrayList32 = new ArrayList<String>();
        ArrayList<String> arrayList33 = new ArrayList<String>();
        ArrayList<Integer> arrayList34 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList35 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList36 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList37 = new ArrayList<Integer>();
        ArrayList<String> arrayList38 = new ArrayList<String>();
        ArrayList<String> arrayList39 = new ArrayList<String>();
        ArrayList<Integer> arrayList40 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList41 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList42 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList43 = new ArrayList<Integer>();
        ArrayList<String> arrayList44 = new ArrayList<String>();
        ArrayList<String> arrayList45 = new ArrayList<String>();
        ArrayList<Integer> arrayList46 = new ArrayList<Integer>();
        ArrayList<String> arrayList47 = new ArrayList<String>();
        ArrayList<String> arrayList48 = new ArrayList<String>();
        ArrayList<String> arrayList49 = new ArrayList<String>();
        ArrayList<Integer> arrayList50 = new ArrayList<Integer>();
        ArrayList<String> arrayList51 = new ArrayList<String>();
        ArrayList<String> arrayList52 = new ArrayList<String>();
        ArrayList<String> arrayList53 = new ArrayList<String>();
        ArrayList<String> arrayList54 = new ArrayList<String>();
        ArrayList<String> arrayList55 = new ArrayList<String>();
        ArrayList<String> arrayList56 = new ArrayList<String>();
        ArrayList<String> arrayList57 = new ArrayList<String>();
        ArrayList<String> arrayList58 = new ArrayList<String>();
        ArrayList<String> arrayList59 = new ArrayList<String>();
        ArrayList<Double> arrayList60 = new ArrayList<Double>();
        ArrayList<String> arrayList61 = new ArrayList<String>();
        ArrayList<String> arrayList62 = new ArrayList<String>();
        ArrayList<String> arrayList63 = new ArrayList<String>();
        ArrayList<String> arrayList64 = new ArrayList<String>();
        ArrayList<String> arrayList65 = new ArrayList<String>();
        ArrayList<String> arrayList66 = new ArrayList<String>();
        ArrayList<String> arrayList67 = new ArrayList<String>();
        ArrayList<String> arrayList68 = new ArrayList<String>();
        ArrayList<String> arrayList69 = new ArrayList<String>();
        ArrayList<String> arrayList70 = new ArrayList<String>();
        ArrayList<String> arrayList71 = new ArrayList<String>();
        ArrayList<String> arrayList72 = new ArrayList<String>();
        ArrayList<Double> arrayList73 = new ArrayList<Double>();
        ArrayList<Double> arrayList74 = new ArrayList<Double>();
        ArrayList<Double> arrayList75 = new ArrayList<Double>();
        ArrayList<Double> arrayList76 = new ArrayList<Double>();
        ArrayList<Double> arrayList77 = new ArrayList<Double>();
        ArrayList<String> arrayList78 = new ArrayList<String>();
        ArrayList<String> arrayList79 = new ArrayList<String>();
        ArrayList<String> arrayList80 = new ArrayList<String>();
        ArrayList<Double> arrayList81 = new ArrayList<Double>();
        ArrayList<Double> arrayList82 = new ArrayList<Double>();
        ArrayList<String> arrayList83 = new ArrayList<String>();
        ArrayList<String> arrayList84 = new ArrayList<String>();
        ArrayList<String> arrayList85 = new ArrayList<String>();
        TransformationNodeType transformationNodeType = (TransformationNodeType)transformationNode.getData();
        TransformationSourceAttributes transformationSourceAttributes = transformationNodeType.getTransformationSourceAttributes();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Object object62 : transformationSourceAttributes.getTransformationSourceAttributeType()) {
            hashMap.put(object62.getName(), object62);
        }
        List list3 = transformedAttributes.getMapTransformedSourceType();
        object62 = list3.iterator();
        while (object62.hasNext()) {
            Object object9;
            Object object10;
            Object object11;
            Object object12;
            object5 = (MapTransformedSource)object62.next();
            object4 = object5.getKey();
            stringCollection = object5.getStringCollectionNames();
            object3 = new StringBuilder();
            stringBuilder = new StringBuilder();
            for (String string32 : stringCollection.getValue()) {
                if (((StringBuilder)object3).length() > 0) {
                    ((StringBuilder)object3).append(", ");
                    stringBuilder.append(", ");
                }
                ((StringBuilder)object3).append(string32);
                stringBuilder.append(((TransformationSourceAttribute)hashMap.get(string32)).getDataType());
            }
            if (!object4.isModified()) continue;
            transformationType = object4.getTransformationElementType();
            string32 = transformationType.getBinning();
            if (null != string32) {
                if (null != string32.getCustomCategorical()) {
                    customCategorical = string32.getCustomCategorical();
                    object12 = customCategorical.getCategoricalBin();
                    object11 = object12.iterator();
                    while (object11.hasNext()) {
                        object10 = (CategoricalBin)object11.next();
                        object9 = object10.getStringCollectionValues().getValue();
                        object2 = object9.iterator();
                        while (object2.hasNext()) {
                            object = (String)object2.next();
                            object8.add(object4.getName());
                            object7.add(((StringBuilder)object3).toString());
                            arrayList.add(object10.getName());
                            arrayList2.add(object10.isIsOther() ? 1 : 0);
                            arrayList3.add((String)object);
                        }
                    }
                    continue;
                }
                if (null != string32.getCustomDate()) {
                    customCategorical = string32.getCustomDate();
                    object12 = customCategorical.getBinLabels();
                    object11 = customCategorical.getDateBin();
                    object10 = object11.iterator();
                    while (object10.hasNext()) {
                        object9 = (DateBin)object10.next();
                        arrayList9.add(object4.getName());
                        arrayList10.add(((StringBuilder)object3).toString());
                        arrayList11.add(null != object12.getNumberSequence() ? 1 : 0);
                        arrayList12.add(object9.getName());
                        object2 = TimeUtils.getShortSimpleDateFormatZoneRFC2();
                        object = new StringBuffer();
                        if (null != object9.getLowerBound().getValue()) {
                            comparable2 = object9.getLowerBound().getValue().toGregorianCalendar().getTime();
                            comparable = ((SimpleDateFormat)object2).format((Date)comparable2, (StringBuffer)object, new FieldPosition(0));
                            arrayList13.add(comparable.toString());
                            continue;
                        }
                        arrayList13.add(null);
                    }
                    continue;
                }
                if (null != string32.getCustomTimestamp()) {
                    customCategorical = string32.getCustomTimestamp();
                    object12 = customCategorical.getBinLabels();
                    object11 = customCategorical.getTimestampTimezoneBin();
                    object10 = object11.iterator();
                    while (object10.hasNext()) {
                        object9 = (TimestampTimezoneBin)object10.next();
                        arrayList14.add(object4.getName());
                        arrayList15.add(((StringBuilder)object3).toString());
                        arrayList16.add(null != object12.getNumberSequence() ? 1 : 0);
                        arrayList17.add(object9.getName());
                        object2 = TimeUtils.getShortSimpleDateFormatZoneRFCTZ();
                        object = new StringBuffer();
                        if (null != object9.getLowerBound().getValue()) {
                            comparable2 = object9.getLowerBound().getValue().toGregorianCalendar();
                            ((DateFormat)object2).setTimeZone(((GregorianCalendar)comparable2).getTimeZone());
                            comparable = object9.getLowerBound().getValue().toGregorianCalendar().getTime();
                            stringBuffer = ((SimpleDateFormat)object2).format((Date)comparable, (StringBuffer)object, new FieldPosition(0));
                            arrayList18.add(stringBuffer.toString());
                            continue;
                        }
                        arrayList18.add(null);
                    }
                    continue;
                }
                if (null != string32.getCustomNumeric()) {
                    customCategorical = string32.getCustomNumeric();
                    object12 = customCategorical.getBinLabels();
                    object11 = customCategorical.getNumericBin();
                    object10 = object11.iterator();
                    while (object10.hasNext()) {
                        object9 = (NumericBin)object10.next();
                        arrayList4.add(object4.getName());
                        arrayList5.add(((StringBuilder)object3).toString());
                        arrayList6.add(null != object12.getNumberSequence() ? 1 : 0);
                        arrayList7.add(object9.getBinName());
                        arrayList8.add(object9.getLowerBound());
                    }
                    continue;
                }
                if (null != string32.getEqualWidth()) {
                    customCategorical = string32.getEqualWidth();
                    arrayList19.add(object4.getName());
                    arrayList20.add(((StringBuilder)object3).toString());
                    arrayList21.add(stringBuilder.toString());
                    arrayList22.add(customCategorical.getBinCount().intValue());
                    object12 = customCategorical.getBinGeneration();
                    arrayList23.add(null != object12.getAuto() ? 1 : 0);
                    arrayList24.add(null != object12.getManual() ? 1 : 0);
                    object11 = customCategorical.getBinLabels();
                    arrayList25.add(null != object11.getNumberSequence() ? 1 : 0);
                    continue;
                }
                if (null != string32.getDateEqualWidth()) {
                    customCategorical = string32.getDateEqualWidth();
                    object12 = customCategorical.getBinGeneration();
                    object11 = customCategorical.getBinLabels();
                    object10 = TransformationStatisticsState.getTransformationSourceAttributeDataType(transformationNode, ((StringBuilder)object3).toString());
                    if (!DatabaseMetadataUtils.isTimestampWithTimeZone((String)object10)) {
                        arrayList26.add(object4.getName());
                        arrayList27.add(((StringBuilder)object3).toString());
                        arrayList28.add(customCategorical.getBinCount().intValue());
                        arrayList29.add(null != object12.getAuto() ? 1 : 0);
                        arrayList30.add(null != object12.getManual() ? 1 : 0);
                        arrayList31.add(null != object11.getNumberSequence() ? 1 : 0);
                        continue;
                    }
                    arrayList32.add(object4.getName());
                    arrayList33.add(((StringBuilder)object3).toString());
                    arrayList34.add(customCategorical.getBinCount().intValue());
                    arrayList35.add(null != object12.getAuto() ? 1 : 0);
                    arrayList36.add(null != object12.getManual() ? 1 : 0);
                    arrayList37.add(null != object11.getNumberSequence() ? 1 : 0);
                    continue;
                }
                if (null != string32.getTimestampEqualWidth()) {
                    customCategorical = string32.getTimestampEqualWidth();
                    object12 = customCategorical.getBinGeneration();
                    object11 = customCategorical.getBinLabels();
                    object10 = TransformationStatisticsState.getTransformationSourceAttributeDataType(transformationNode, ((StringBuilder)object3).toString());
                    if (!DatabaseMetadataUtils.isTimestampWithTimeZone((String)object10)) continue;
                    arrayList32.add(object4.getName());
                    arrayList33.add(((StringBuilder)object3).toString());
                    arrayList34.add(customCategorical.getBinCount().intValue());
                    arrayList35.add(null != object12.getAuto() ? 1 : 0);
                    arrayList36.add(null != object12.getManual() ? 1 : 0);
                    arrayList37.add(null != object11.getNumberSequence() ? 1 : 0);
                    continue;
                }
                if (null != string32.getQuantile()) {
                    customCategorical = string32.getQuantile();
                    arrayList38.add(object4.getName());
                    arrayList39.add(((StringBuilder)object3).toString());
                    arrayList40.add(customCategorical.getBinCount().intValue());
                    object12 = customCategorical.getBinGeneration();
                    arrayList41.add(null != object12.getAuto() ? 1 : 0);
                    arrayList42.add(null != object12.getManual() ? 1 : 0);
                    object11 = customCategorical.getBinLabels();
                    arrayList43.add(null != object11.getNumberSequence() ? 1 : 0);
                    continue;
                }
                if (null == string32.getTopN()) continue;
                customCategorical = string32.getTopN();
                object12 = stringBuilder.toString();
                if (((String)object12).equals("NVARCHAR2") || ((String)object12).equals("NCHAR")) {
                    arrayList48.add(object4.getName());
                    arrayList49.add(((StringBuilder)object3).toString());
                    arrayList50.add(customCategorical.getBinCount().intValue());
                    arrayList51.add(customCategorical.getOther());
                    continue;
                }
                arrayList44.add(object4.getName());
                arrayList45.add(((StringBuilder)object3).toString());
                arrayList46.add(customCategorical.getBinCount().intValue());
                arrayList47.add(customCategorical.getOther());
                continue;
            }
            if (null != transformationType.getMissingValuesCategorical()) {
                customCategorical = transformationType.getMissingValuesCategorical();
                arrayList52.add(object4.getName());
                arrayList53.add(((StringBuilder)object3).toString());
                arrayList54.add(stringBuilder.toString());
                object12 = customCategorical.getCategoricalStatistic();
                object11 = customCategorical.getValue();
                if (object12 != null) {
                    arrayList55.add(object12.getReplaceNullsWith());
                    arrayList56.add("");
                    continue;
                }
                if (object11 == null) continue;
                arrayList55.add("");
                arrayList56.add(object11.getReplaceNullsWith());
                continue;
            }
            if (null != transformationType.getMissingValuesNumeric()) {
                customCategorical = transformationType.getMissingValuesNumeric();
                arrayList57.add(object4.getName());
                arrayList58.add(((StringBuilder)object3).toString());
                object12 = customCategorical.getNumericStatistic();
                object11 = customCategorical.getValue();
                if (object12 != null) {
                    arrayList59.add(object12.getReplaceNullsWith());
                    arrayList60.add(0.0);
                    continue;
                }
                if (object11 == null) continue;
                arrayList59.add("");
                arrayList60.add(object11.getReplaceNullsWith());
                continue;
            }
            if (null != transformationType.getMissingValuesDate()) {
                customCategorical = transformationType.getMissingValuesDate();
                object12 = TransformationStatisticsState.getTransformationSourceAttributeDataType(transformationNode, ((StringBuilder)object3).toString());
                if (!DatabaseMetadataUtils.isTimestampWithTimeZone((String)object12)) {
                    arrayList61.add(object4.getName());
                    arrayList62.add(((StringBuilder)object3).toString());
                    object11 = customCategorical.getDateStatistic();
                    object10 = customCategorical.getValue();
                    if (object11 != null) {
                        arrayList63.add(object11.getReplaceNullsWith());
                        arrayList64.add("");
                        continue;
                    }
                    if (object10 == null) continue;
                    arrayList63.add("");
                    object9 = object10.getReplaceNullsWith().toGregorianCalendar().getTime();
                    object2 = TimeUtils.getShortSimpleDateFormatZone();
                    object = new StringBuffer();
                    comparable2 = ((SimpleDateFormat)object2).format((Date)object9, (StringBuffer)object, new FieldPosition(0));
                    arrayList64.add(((StringBuffer)comparable2).toString());
                    continue;
                }
                arrayList65.add(object4.getName());
                arrayList66.add(((StringBuilder)object3).toString());
                object11 = customCategorical.getDateStatistic();
                object10 = customCategorical.getValue();
                if (object11 != null) {
                    arrayList67.add(object11.getReplaceNullsWith());
                    arrayList68.add("");
                    continue;
                }
                if (object10 == null) continue;
                arrayList67.add("");
                object9 = object10.getReplaceNullsWith().toGregorianCalendar().getTime();
                object2 = TimeUtils.getShortSimpleDateFormatZone();
                object = new StringBuffer();
                comparable2 = ((SimpleDateFormat)object2).format((Date)object9, (StringBuffer)object, new FieldPosition(0));
                arrayList68.add(((StringBuffer)comparable2).toString());
                continue;
            }
            if (null != transformationType.getNormalization()) {
                customCategorical = transformationType.getNormalization();
                arrayList78.add(object4.getName());
                arrayList79.add(((StringBuilder)object3).toString());
                if (null != customCategorical.getMinMax()) {
                    arrayList80.add("MinMax");
                    arrayList81.add(null);
                    arrayList82.add(null);
                    continue;
                }
                if (null != customCategorical.getZScore()) {
                    arrayList80.add("ZScore");
                    arrayList81.add(null);
                    arrayList82.add(null);
                    continue;
                }
                if (null != customCategorical.getLinearScale()) {
                    arrayList80.add("LinearScale");
                    arrayList81.add(null);
                    arrayList82.add(null);
                    continue;
                }
                arrayList80.add("Manual");
                arrayList81.add(customCategorical.getManual().getShift());
                arrayList82.add(customCategorical.getManual().getScale());
                continue;
            }
            if (null != transformationType.getOutlier()) {
                customCategorical = transformationType.getOutlier();
                arrayList69.add(object4.getName());
                arrayList70.add(((StringBuilder)object3).toString());
                if (NULLS.equals(customCategorical.getReplaceWith())) {
                    arrayList72.add(NULLS);
                } else {
                    arrayList72.add(EDGES);
                }
                if (null != customCategorical.getStandardDeviation()) {
                    arrayList71.add("StandardDeviation");
                    arrayList73.add(customCategorical.getStandardDeviation().getMultiplesSigma());
                    arrayList74.add(null);
                    arrayList75.add(null);
                    arrayList76.add(null);
                    arrayList77.add(null);
                    continue;
                }
                if (null != customCategorical.getValue()) {
                    arrayList71.add("Value");
                    arrayList73.add(null);
                    arrayList74.add(customCategorical.getValue().getLowerValue());
                    arrayList75.add(customCategorical.getValue().getUpperValue());
                    arrayList76.add(null);
                    arrayList77.add(null);
                    continue;
                }
                arrayList71.add("Percent");
                arrayList73.add(null);
                arrayList74.add(null);
                arrayList75.add(null);
                arrayList76.add(customCategorical.getPercent().getLowerPercent());
                arrayList77.add(customCategorical.getPercent().getUpperPercent());
                continue;
            }
            if (null == transformationType.getCustomTransformation()) continue;
            customCategorical = transformationType.getCustomTransformation();
            arrayList83.add(object4.getName());
            arrayList84.add(((StringBuilder)object3).toString());
            arrayList85.add(customCategorical.getValue());
        }
        object62 = transformationNode.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_TABLE, true);
        object5 = transformationNode.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, true);
        object4 = transformationNode.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_INSERT, true);
        stringCollection = ((TransformationNodeType)transformationNode.getData()).getStatsSelection();
        if (stringCollection == null) {
            stringCollection = StatisticsSelectionObject.createDefaultStatsSelection();
        }
        object3 = null;
        stringBuilder = null;
        try {
            ARRAY aRRAY;
            ARRAY aRRAY2;
            object3 = Connections.getUniqueConnection(context);
            ConnectionFolder.setConnectionAlterSessionFixes((Connection)object3);
            transformationType = ArrayDescriptor.createDescriptor((String)ODMR_OBJECT_NAMES, (Connection)object3);
            string32 = ArrayDescriptor.createDescriptor((String)ODMR_OBJECT_IDS, (Connection)object3);
            customCategorical = ArrayDescriptor.createDescriptor((String)ODMR_OBJECT_VALUES, (Connection)object3);
            stringBuilder = (OracleCallableStatement)object3.prepareCall(xformToSql);
            int n = 1;
            stringBuilder.registerOutParameter(n++, 12);
            stringBuilder.setString(n++, string4);
            if (string != null) {
                stringBuilder.setString(n++, string);
            } else {
                stringBuilder.setNull(n++, 12);
            }
            int n2 = ((TransformationNodeType)transformationNode.getData()).getDataProfileSettings().getNumericalBins();
            int n3 = ((TransformationNodeType)transformationNode.getData()).getDataProfileSettings().getCategoricalBins();
            int n4 = ((TransformationNodeType)transformationNode.getData()).getDataProfileSettings().getDateBins();
            stringBuilder.setInt(n++, n3);
            stringBuilder.setInt(n++, n2);
            stringBuilder.setInt(n++, n4);
            if (list != null && !list.isEmpty()) {
                object2 = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)list.toArray(new String[list.size()]));
                object = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)list2.toArray(new String[list2.size()]));
                stringBuilder.setArray(n++, (Array)object2);
                stringBuilder.setArray(n++, (Array)object);
            } else {
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
            }
            if (arrayList44.size() > 0) {
                object2 = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList44.toArray(new String[arrayList44.size()]));
                object = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList45.toArray(new String[arrayList45.size()]));
                comparable2 = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList46.toArray(new Integer[arrayList46.size()]));
                comparable = new ARRAY((ArrayDescriptor)customCategorical, (Connection)object3, (Object)arrayList47.toArray(new String[arrayList47.size()]));
                stringBuilder.setArray(n++, (Array)object2);
                stringBuilder.setArray(n++, (Array)object);
                stringBuilder.setArray(n++, (Array)((Object)comparable2));
                stringBuilder.setArray(n++, (Array)((Object)comparable));
            } else {
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_VALUES);
            }
            if (arrayList48.size() > 0) {
                object2 = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList48.toArray(new String[arrayList48.size()]));
                object = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList49.toArray(new String[arrayList49.size()]));
                comparable2 = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList50.toArray(new Integer[arrayList50.size()]));
                comparable = new ARRAY((ArrayDescriptor)customCategorical, (Connection)object3, (Object)arrayList51.toArray(new String[arrayList51.size()]));
                stringBuilder.setArray(n++, (Array)object2);
                stringBuilder.setArray(n++, (Array)object);
                stringBuilder.setArray(n++, (Array)((Object)comparable2));
                stringBuilder.setArray(n++, (Array)((Object)comparable));
            } else {
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_VALUES);
            }
            if (arrayList19.size() > 0) {
                object2 = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList19.toArray(new String[arrayList19.size()]));
                object = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList20.toArray(new String[arrayList20.size()]));
                comparable2 = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList21.toArray(new String[arrayList21.size()]));
                comparable = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList22.toArray(new Integer[arrayList22.size()]));
                stringBuffer = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList23.toArray(new Integer[arrayList23.size()]));
                aRRAY2 = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList24.toArray(new Integer[arrayList24.size()]));
                aRRAY = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList25.toArray(new Integer[arrayList25.size()]));
                stringBuilder.setArray(n++, (Array)object2);
                stringBuilder.setArray(n++, (Array)object);
                stringBuilder.setArray(n++, (Array)((Object)comparable2));
                stringBuilder.setArray(n++, (Array)((Object)comparable));
                stringBuilder.setArray(n++, (Array)((Object)stringBuffer));
                stringBuilder.setArray(n++, (Array)aRRAY2);
                stringBuilder.setArray(n++, (Array)aRRAY);
            } else {
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
            }
            if (arrayList26.size() > 0) {
                object2 = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList26.toArray(new String[arrayList26.size()]));
                object = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList27.toArray(new String[arrayList27.size()]));
                comparable2 = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList28.toArray(new Integer[arrayList28.size()]));
                comparable = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList29.toArray(new Integer[arrayList29.size()]));
                stringBuffer = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList30.toArray(new Integer[arrayList30.size()]));
                aRRAY2 = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList31.toArray(new Integer[arrayList31.size()]));
                stringBuilder.setArray(n++, (Array)object2);
                stringBuilder.setArray(n++, (Array)object);
                stringBuilder.setArray(n++, (Array)((Object)comparable2));
                stringBuilder.setArray(n++, (Array)((Object)comparable));
                stringBuilder.setArray(n++, (Array)((Object)stringBuffer));
                stringBuilder.setArray(n++, (Array)aRRAY2);
            } else {
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
            }
            if (arrayList32.size() > 0) {
                object2 = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList32.toArray(new String[arrayList32.size()]));
                object = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList33.toArray(new String[arrayList33.size()]));
                comparable2 = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList34.toArray(new Integer[arrayList34.size()]));
                comparable = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList35.toArray(new Integer[arrayList35.size()]));
                stringBuffer = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList36.toArray(new Integer[arrayList36.size()]));
                aRRAY2 = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList37.toArray(new Integer[arrayList37.size()]));
                stringBuilder.setArray(n++, (Array)object2);
                stringBuilder.setArray(n++, (Array)object);
                stringBuilder.setArray(n++, (Array)((Object)comparable2));
                stringBuilder.setArray(n++, (Array)((Object)comparable));
                stringBuilder.setArray(n++, (Array)((Object)stringBuffer));
                stringBuilder.setArray(n++, (Array)aRRAY2);
            } else {
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
            }
            if (arrayList38.size() > 0) {
                object2 = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList38.toArray(new String[arrayList38.size()]));
                object = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList39.toArray(new String[arrayList39.size()]));
                comparable2 = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList40.toArray(new Integer[arrayList40.size()]));
                comparable = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList41.toArray(new Integer[arrayList41.size()]));
                stringBuffer = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList42.toArray(new Integer[arrayList42.size()]));
                aRRAY2 = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList43.toArray(new Integer[arrayList43.size()]));
                stringBuilder.setArray(n++, (Array)object2);
                stringBuilder.setArray(n++, (Array)object);
                stringBuilder.setArray(n++, (Array)((Object)comparable2));
                stringBuilder.setArray(n++, (Array)((Object)comparable));
                stringBuilder.setArray(n++, (Array)((Object)stringBuffer));
                stringBuilder.setArray(n++, (Array)aRRAY2);
            } else {
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
            }
            if (arrayList9.size() > 0) {
                object2 = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList9.toArray(new String[arrayList9.size()]));
                object = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList10.toArray(new String[arrayList10.size()]));
                comparable2 = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList11.toArray(new Integer[arrayList11.size()]));
                comparable = new ARRAY((ArrayDescriptor)customCategorical, (Connection)object3, (Object)arrayList12.toArray(new String[arrayList12.size()]));
                stringBuffer = new ARRAY((ArrayDescriptor)customCategorical, (Connection)object3, (Object)arrayList13.toArray(new String[arrayList13.size()]));
                stringBuilder.setArray(n++, (Array)object2);
                stringBuilder.setArray(n++, (Array)object);
                stringBuilder.setArray(n++, (Array)((Object)comparable2));
                stringBuilder.setArray(n++, (Array)((Object)comparable));
                stringBuilder.setArray(n++, (Array)((Object)stringBuffer));
            } else {
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_VALUES);
            }
            if (arrayList14.size() > 0) {
                object2 = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList14.toArray(new String[arrayList14.size()]));
                object = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList15.toArray(new String[arrayList15.size()]));
                comparable2 = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList16.toArray(new Integer[arrayList16.size()]));
                comparable = new ARRAY((ArrayDescriptor)customCategorical, (Connection)object3, (Object)arrayList17.toArray(new String[arrayList17.size()]));
                stringBuffer = new ARRAY((ArrayDescriptor)customCategorical, (Connection)object3, (Object)arrayList18.toArray(new String[arrayList18.size()]));
                stringBuilder.setArray(n++, (Array)object2);
                stringBuilder.setArray(n++, (Array)object);
                stringBuilder.setArray(n++, (Array)((Object)comparable2));
                stringBuilder.setArray(n++, (Array)((Object)comparable));
                stringBuilder.setArray(n++, (Array)((Object)stringBuffer));
            } else {
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_VALUES);
            }
            if (arrayList4.size() > 0) {
                object2 = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList4.toArray(new String[arrayList4.size()]));
                object = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList5.toArray(new String[arrayList5.size()]));
                comparable2 = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList6.toArray(new Integer[arrayList6.size()]));
                comparable = new ARRAY((ArrayDescriptor)customCategorical, (Connection)object3, (Object)arrayList7.toArray(new String[arrayList7.size()]));
                stringBuffer = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList8.toArray(new Double[arrayList8.size()]));
                stringBuilder.setArray(n++, (Array)object2);
                stringBuilder.setArray(n++, (Array)object);
                stringBuilder.setArray(n++, (Array)((Object)comparable2));
                stringBuilder.setArray(n++, (Array)((Object)comparable));
                stringBuilder.setArray(n++, (Array)((Object)stringBuffer));
            } else {
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
            }
            if (object8.size() > 0) {
                object2 = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)object8.toArray(new String[object8.size()]));
                object = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)object7.toArray(new String[object7.size()]));
                comparable2 = new ARRAY((ArrayDescriptor)customCategorical, (Connection)object3, (Object)arrayList.toArray(new String[arrayList.size()]));
                comparable = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList2.toArray(new Integer[arrayList2.size()]));
                stringBuffer = new ARRAY((ArrayDescriptor)customCategorical, (Connection)object3, (Object)arrayList3.toArray(new String[arrayList3.size()]));
                stringBuilder.setArray(n++, (Array)object2);
                stringBuilder.setArray(n++, (Array)object);
                stringBuilder.setArray(n++, (Array)((Object)comparable2));
                stringBuilder.setArray(n++, (Array)((Object)comparable));
                stringBuilder.setArray(n++, (Array)((Object)stringBuffer));
            } else {
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_VALUES);
            }
            if (arrayList52.size() > 0) {
                object2 = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList52.toArray(new String[arrayList52.size()]));
                object = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList53.toArray(new String[arrayList53.size()]));
                comparable2 = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList54.toArray(new String[arrayList54.size()]));
                comparable = new ARRAY((ArrayDescriptor)customCategorical, (Connection)object3, (Object)arrayList55.toArray(new String[arrayList55.size()]));
                stringBuffer = new ARRAY((ArrayDescriptor)customCategorical, (Connection)object3, (Object)arrayList56.toArray(new String[arrayList56.size()]));
                stringBuilder.setArray(n++, (Array)object2);
                stringBuilder.setArray(n++, (Array)object);
                stringBuilder.setArray(n++, (Array)((Object)comparable2));
                stringBuilder.setArray(n++, (Array)((Object)comparable));
                stringBuilder.setArray(n++, (Array)((Object)stringBuffer));
            } else {
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_VALUES);
            }
            if (arrayList57.size() > 0) {
                object2 = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList57.toArray(new String[arrayList57.size()]));
                object = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList58.toArray(new String[arrayList58.size()]));
                comparable2 = new ARRAY((ArrayDescriptor)customCategorical, (Connection)object3, (Object)arrayList59.toArray(new String[arrayList59.size()]));
                comparable = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList60.toArray(new Double[arrayList60.size()]));
                stringBuilder.setArray(n++, (Array)object2);
                stringBuilder.setArray(n++, (Array)object);
                stringBuilder.setArray(n++, (Array)((Object)comparable2));
                stringBuilder.setArray(n++, (Array)((Object)comparable));
            } else {
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
            }
            if (arrayList61.size() > 0) {
                object2 = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList61.toArray(new String[arrayList61.size()]));
                object = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList62.toArray(new String[arrayList62.size()]));
                comparable2 = new ARRAY((ArrayDescriptor)customCategorical, (Connection)object3, (Object)arrayList63.toArray(new String[arrayList63.size()]));
                comparable = new ARRAY((ArrayDescriptor)customCategorical, (Connection)object3, (Object)arrayList64.toArray(new String[arrayList64.size()]));
                stringBuilder.setArray(n++, (Array)object2);
                stringBuilder.setArray(n++, (Array)object);
                stringBuilder.setArray(n++, (Array)((Object)comparable2));
                stringBuilder.setArray(n++, (Array)((Object)comparable));
            } else {
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_VALUES);
            }
            if (arrayList65.size() > 0) {
                object2 = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList65.toArray(new String[arrayList65.size()]));
                object = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList66.toArray(new String[arrayList66.size()]));
                comparable2 = new ARRAY((ArrayDescriptor)customCategorical, (Connection)object3, (Object)arrayList67.toArray(new String[arrayList67.size()]));
                comparable = new ARRAY((ArrayDescriptor)customCategorical, (Connection)object3, (Object)arrayList68.toArray(new String[arrayList68.size()]));
                stringBuilder.setArray(n++, (Array)object2);
                stringBuilder.setArray(n++, (Array)object);
                stringBuilder.setArray(n++, (Array)((Object)comparable2));
                stringBuilder.setArray(n++, (Array)((Object)comparable));
            } else {
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_VALUES);
            }
            if (arrayList69.size() > 0) {
                object2 = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList69.toArray(new String[arrayList69.size()]));
                object = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList70.toArray(new String[arrayList70.size()]));
                comparable2 = new ARRAY((ArrayDescriptor)customCategorical, (Connection)object3, (Object)arrayList71.toArray(new String[arrayList71.size()]));
                comparable = new ARRAY((ArrayDescriptor)customCategorical, (Connection)object3, (Object)arrayList72.toArray(new String[arrayList72.size()]));
                stringBuffer = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList73.toArray(new Double[arrayList73.size()]));
                aRRAY2 = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList74.toArray(new Double[arrayList74.size()]));
                aRRAY = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList75.toArray(new Double[arrayList75.size()]));
                ARRAY aRRAY3 = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList76.toArray(new Double[arrayList76.size()]));
                ARRAY aRRAY4 = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList77.toArray(new Double[arrayList77.size()]));
                if (string2 != null) {
                    stringBuilder.setString(n++, string2);
                } else {
                    stringBuilder.setNull(n++, 12);
                }
                stringBuilder.setArray(n++, (Array)object2);
                stringBuilder.setArray(n++, (Array)object);
                stringBuilder.setArray(n++, (Array)((Object)comparable2));
                stringBuilder.setArray(n++, (Array)((Object)comparable));
                stringBuilder.setArray(n++, (Array)((Object)stringBuffer));
                stringBuilder.setArray(n++, (Array)aRRAY2);
                stringBuilder.setArray(n++, (Array)aRRAY);
                stringBuilder.setArray(n++, (Array)aRRAY3);
                stringBuilder.setArray(n++, (Array)aRRAY4);
            } else {
                stringBuilder.setNull(n++, 12);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
            }
            if (arrayList78.size() > 0) {
                object2 = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList78.toArray(new String[arrayList78.size()]));
                object = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList79.toArray(new String[arrayList79.size()]));
                comparable2 = new ARRAY((ArrayDescriptor)customCategorical, (Connection)object3, (Object)arrayList80.toArray(new String[arrayList80.size()]));
                comparable = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList81.toArray(new Double[arrayList81.size()]));
                stringBuffer = new ARRAY((ArrayDescriptor)string32, (Connection)object3, (Object)arrayList82.toArray(new Double[arrayList82.size()]));
                stringBuilder.setArray(n++, (Array)object2);
                stringBuilder.setArray(n++, (Array)object);
                stringBuilder.setArray(n++, (Array)((Object)comparable2));
                stringBuilder.setArray(n++, (Array)((Object)comparable));
                stringBuilder.setArray(n++, (Array)((Object)stringBuffer));
            } else {
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_IDS);
            }
            if (arrayList83.size() > 0) {
                object2 = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList83.toArray(new String[arrayList83.size()]));
                object = new ARRAY((ArrayDescriptor)transformationType, (Connection)object3, (Object)arrayList84.toArray(new String[arrayList84.size()]));
                comparable2 = new ARRAY((ArrayDescriptor)customCategorical, (Connection)object3, (Object)arrayList85.toArray(new String[arrayList85.size()]));
                stringBuilder.setArray(n++, (Array)object2);
                stringBuilder.setArray(n++, (Array)object);
                stringBuilder.setArray(n++, (Array)((Object)comparable2));
            } else {
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                stringBuilder.setNull(n++, 2003, ODMR_OBJECT_VALUES);
            }
            stringBuilder.setString(n++, (String)object5);
            stringBuilder.setString(n++, (String)object4);
            stringBuilder.setString(n++, (String)object62);
            stringBuilder.setInt(n++, stringCollection.isPercentdistinct() ? 1 : 0);
            stringBuilder.setInt(n++, stringCollection.isPercentnull() ? 1 : 0);
            stringBuilder.setInt(n++, stringCollection.isMax() ? 1 : 0);
            stringBuilder.setInt(n++, stringCollection.isMin() ? 1 : 0);
            stringBuilder.setInt(n++, stringCollection.isAvg() ? 1 : 0);
            stringBuilder.setInt(n++, stringCollection.isStd() ? 1 : 0);
            stringBuilder.setInt(n++, stringCollection.isVar() ? 1 : 0);
            stringBuilder.setInt(n++, stringCollection.isKurtosis() ? 1 : 0);
            stringBuilder.setInt(n++, stringCollection.isMedian() ? 1 : 0);
            stringBuilder.setInt(n++, stringCollection.isSkewness() ? 1 : 0);
            stringBuilder.setInt(n++, stringCollection.isMode() ? 1 : 0);
            stringBuilder.setInt(n++, stringCollection.isModeall() ? 1 : 0);
            stringBuilder.setInt(n++, stringCollection.isHistogram() ? 1 : 0);
            stringBuilder.executeQuery();
            object = object2 = stringBuilder.getString(1);
            return object;
        }
        finally {
            if (stringBuilder != null) {
                stringBuilder.close();
            }
            SQLHelper.close((Connection)object3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDistinctValuesAndFrequenciesFromDB(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        String string2 = TransformationStatisticsState.getStackedSQL(this._transformationNode);
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = Connections.getUniqueConnection(this._context);
            ConnectionFolder.setConnectionAlterSessionFixes(connection);
            String string3 = StringUtils.getReplacedString(sql_distincts, "<column_name>", string);
            string3 = StringUtils.getReplacedString(string3, "<table_name>", string2);
            preparedStatement = connection.prepareStatement(string3);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Integer n = resultSet.getInt(1);
                String string4 = resultSet.getString(2);
                arrayList2.add(n);
                arrayList.add(string4);
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        finally {
            SQLHelper.close(connection);
        }
        this.distinctValues.put(string, arrayList);
        this.frequencies.put(string, arrayList2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean areColumnsPresentInSampleTable(Context context, String string, List<String> list) {
        boolean bl = false;
        Connection connection = null;
        SQLHelper sQLHelper = new SQLHelper();
        try {
            connection = Connections.getUniqueConnection(context);
            ConnectionFolder.setConnectionAlterSessionFixes(connection);
            StringBuffer stringBuffer = new StringBuffer("SELECT ");
            int n = 0;
            for (String string2 : list) {
                if (++n > 1) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(string2);
            }
            Object object = Connections.getUserAccountName(context);
            object = StringUtils.isDoubleQuotedString((String)object) ? StringUtils.trimDoubleQuotes((String)object) : ((String)object).toUpperCase();
            stringBuffer.append(" from " + (String)object + "." + string + " where ROWNUM < 2");
            sQLHelper.pstmt = connection.prepareStatement(stringBuffer.toString());
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                bl = true;
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        finally {
            sQLHelper.close();
            SQLHelper.close(connection);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanUp() {
        if (this._refreshStatsTable == null && this._refreshSingleColumnStatsTable == null) {
            return;
        }
        Connection connection = null;
        try {
            connection = Connections.getUniqueConnection(this._context);
            ConnectionFolder.setConnectionAlterSessionFixes(connection);
            String string = Connections.getUserAccountName(this._context);
            String string2 = string = StringUtils.isDoubleQuotedString(string) ? StringUtils.trimDoubleQuotes(string) : string.toUpperCase();
            if (null != this._refreshSingleColumnStatsTable) {
                try {
                    DatabaseMetadataUtils.dropTable(connection, string, this._refreshSingleColumnStatsTable);
                    this._refreshSingleColumnStatsTable = null;
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
            if (null != this._refreshStatsTable) {
                DatabaseMetadataUtils.dropTable(connection, string, this._refreshStatsTable);
                this._refreshStatsTable = null;
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        finally {
            this.clearRefreshedResults();
            this.clearServerResults();
            SQLHelper.close(connection);
        }
    }

    public static Map<String, List<NameValuePair>> generateGraphBins(Connection connection, String string, List<String> list, List<String> list2, List<Integer> list3) throws Exception {
        HashMap<String, List<NameValuePair>> hashMap = new HashMap<String, List<NameValuePair>>();
        if (string == null) {
            return hashMap;
        }
        Vector vector = new Vector();
        OracleCallableStatement oracleCallableStatement = null;
        try {
            String string2;
            String string32;
            ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)ODMR_OBJECT_NAMES, (Connection)connection);
            ArrayDescriptor arrayDescriptor2 = ArrayDescriptor.createDescriptor((String)ODMR_OBJECT_IDS, (Connection)connection);
            ArrayDescriptor arrayDescriptor3 = ArrayDescriptor.createDescriptor((String)ODMR_OBJECT_VALUES, (Connection)connection);
            String[] stringArray = new String[list.size()];
            String[] stringArray2 = new String[list.size()];
            Integer[] integerArray = new Integer[list.size()];
            int n = 0;
            for (String string32 : list) {
                stringArray[n] = string2 = StringUtils.isDoubleQuotedString(string32) ? string32 : StringUtils.addDoubleQuotes(string32);
                stringArray2[n] = list2.get(n);
                integerArray[n] = list3.get(n);
                ++n;
            }
            ARRAY aRRAY = new ARRAY(arrayDescriptor, connection, (Object)stringArray);
            string32 = new ARRAY(arrayDescriptor, connection, (Object)stringArray2);
            string2 = new ARRAY(arrayDescriptor2, connection, (Object)integerArray);
            ARRAY aRRAY2 = new ARRAY(arrayDescriptor, connection, (Object)new String[0]);
            ARRAY aRRAY3 = new ARRAY(arrayDescriptor3, connection, (Object)new String[0]);
            ARRAY aRRAY4 = new ARRAY(arrayDescriptor3, connection, (Object)new String[0]);
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("{call ODMR_ENGINE.BIN_MULTIPLE_COLUMNS(?,?,?,?,?,?,?)}");
            int n2 = 1;
            oracleCallableStatement.setCharacterStream(n2++, (Reader)new StringReader(string), string.length());
            oracleCallableStatement.setArray(n2++, (Array)aRRAY);
            oracleCallableStatement.setArray(n2++, (Array)((Object)string32));
            oracleCallableStatement.setArray(n2++, (Array)((Object)string2));
            oracleCallableStatement.setArray(n2++, (Array)aRRAY2);
            oracleCallableStatement.setArray(n2++, (Array)aRRAY3);
            oracleCallableStatement.setArray(n2++, (Array)aRRAY4);
            n2 = 5;
            oracleCallableStatement.registerOutParameter(n2++, 2003, ODMR_OBJECT_NAMES);
            oracleCallableStatement.registerOutParameter(n2++, 2003, ODMR_OBJECT_VALUES);
            oracleCallableStatement.registerOutParameter(n2++, 2003, ODMR_OBJECT_VALUES);
            oracleCallableStatement.execute();
            n2 = 5;
            ARRAY aRRAY5 = oracleCallableStatement.getARRAY(n2++);
            String[] stringArray3 = (String[])aRRAY5.getArray();
            ARRAY aRRAY6 = oracleCallableStatement.getARRAY(n2++);
            String[] stringArray4 = (String[])aRRAY6.getArray();
            ARRAY aRRAY7 = oracleCallableStatement.getARRAY(n2++);
            String[] stringArray5 = (String[])aRRAY7.getArray();
            for (int i = 0; i < stringArray3.length; ++i) {
                ArrayList<NameValuePair> arrayList = (ArrayList<NameValuePair>)hashMap.get(stringArray3[i]);
                if (arrayList == null) {
                    arrayList = new ArrayList<NameValuePair>();
                    hashMap.put(stringArray3[i], arrayList);
                }
                NameValuePair nameValuePair = new NameValuePair(stringArray4[i], stringArray5[i]);
                arrayList.add(nameValuePair);
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            vector.clear();
            throw exception;
        }
        finally {
            if (oracleCallableStatement != null) {
                oracleCallableStatement.close();
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        DriverManager.registerDriver((Driver)new OracleDriver());
        Connection connection = null;
        String string = "adc6180283";
        String string2 = "1521";
        String string3 = "jdmjdk6";
        String string4 = "dmuser";
        String string5 = "dmuser";
        String string6 = "SELECT * FROM BINNING_REVISITED_2";
        String[] stringArray2 = new String[]{"EDUCATION", "OCCUPATION", "\"# dt \"", "\"# ts \"", "BULK_PACK_DISKETTES", "FLAT_PANEL_MONITOR", "Y_BOX_GAMES", "AGE", "CUST_ID", "YRS_RESIDENCE"};
        String[] stringArray3 = new String[]{"VARCHAR2", "VARCHAR2", "DATE", "DATE", "INTEGER", "INTEGER", "INTEGER", "INTEGER", "INTEGER", "INTEGER"};
        Integer[] integerArray = new Integer[]{10, 20, 8, 8, 10, 10, 10, 20, 30, 15};
        ArrayList<String> arrayList = new ArrayList<String>(integerArray.length);
        ArrayList<String> arrayList2 = new ArrayList<String>(integerArray.length);
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>(integerArray.length);
        for (int i = 0; i < stringArray2.length; ++i) {
            arrayList.add(stringArray2[i]);
            arrayList2.add(stringArray3[i]);
            arrayList3.add(integerArray[i]);
        }
        try {
            connection = DriverManager.getConnection("jdbc:oracle:thin:@" + string + ":" + string2 + ":" + string3, string4, string5);
            Map<String, List<NameValuePair>> map = TransformationStatisticsState.generateGraphBins(connection, string6, arrayList, arrayList2, arrayList3);
            for (String string7 : map.keySet()) {
                List<NameValuePair> list = map.get(string7);
                for (NameValuePair nameValuePair : list) {
                    theLogger.log(Level.FINEST, string7 + " : " + nameValuePair.getName() + " : " + nameValuePair.getValue());
                }
            }
        }
        catch (Throwable throwable) {
            SQLHelper.close(connection);
            throw throwable;
        }
        SQLHelper.close(connection);
    }

    public static class AttributeHistogramArray {
        ArrayList<NameValuePair> attributeValuesBars = new ArrayList();

        boolean isEmpty() {
            return this.attributeValuesBars.isEmpty();
        }

        ArrayList<String> getBarTitles() {
            ArrayList<String> arrayList = new ArrayList<String>(this.attributeValuesBars.size());
            for (int i = 0; i < this.attributeValuesBars.size(); ++i) {
                NameValuePair nameValuePair = this.attributeValuesBars.get(i);
                arrayList.add(nameValuePair.getName());
            }
            return arrayList;
        }

        ArrayList<NameValuePair> getBarArray(String string) {
            ArrayList<NameValuePair> arrayList = null;
            for (int i = 0; i < this.attributeValuesBars.size(); ++i) {
                NameValuePair nameValuePair = this.attributeValuesBars.get(i);
                if (!string.equals(nameValuePair.getName())) continue;
                arrayList = ConverterHelper.objectToNameValuePairList(nameValuePair.getValue());
            }
            return arrayList;
        }

        void addPoint(NameValuePair nameValuePair) {
            this.attributeValuesBars.add(nameValuePair);
        }

        void addPoint(Object object, String string, Double d) {
            boolean bl = false;
            for (int i = 0; i < this.attributeValuesBars.size(); ++i) {
                NameValuePair nameValuePair = this.attributeValuesBars.get(i);
                if (!object.toString().equals(nameValuePair.getName())) continue;
                ArrayList<NameValuePair> arrayList = ConverterHelper.objectToNameValuePairList(nameValuePair.getValue());
                arrayList.add(new NameValuePair(string, d));
                bl = true;
            }
            if (!bl) {
                ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
                arrayList.add(new NameValuePair(string, d));
                this.attributeValuesBars.add(new NameValuePair(object.toString(), arrayList));
            }
        }

        public ArrayList<NameValuePair> getAttributeValuesBars() {
            return this.attributeValuesBars;
        }
    }
}

