/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.math.BigInteger;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.BinGeneration;
import oracle.dmt.dataminer.workflow.xmlschema.BinLabels;
import oracle.dmt.dataminer.workflow.xmlschema.CategoricalBin;
import oracle.dmt.dataminer.workflow.xmlschema.CategoricalStatistic;
import oracle.dmt.dataminer.workflow.xmlschema.DateBin;
import oracle.dmt.dataminer.workflow.xmlschema.DateStatistic;
import oracle.dmt.dataminer.workflow.xmlschema.NumericBin;
import oracle.dmt.dataminer.workflow.xmlschema.NumericStatistic;
import oracle.dmt.dataminer.workflow.xmlschema.StringCollection;
import oracle.dmt.dataminer.workflow.xmlschema.TimestampTimezoneBin;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;

public class TransformationTypes {
    protected static final int DATA_TYPE_UNDEFINED = 0;
    protected static final int DATA_TYPE_NUMERIC = 1;
    protected static final int DATA_TYPE_CATEGORIC = 2;
    protected static final int DATA_TYPE_DATE = 3;
    protected static final int DATA_TYPE_TIMESTAMP = 4;
    protected static final int DATA_TYPE_TIMESTAMP_WITH_LOCAL_TIME_ZONE = 5;
    protected static final int DATA_TYPE_TIMESTAMP_WITH_TIME_ZONE = 6;
    private static String TRANSFORMATION_TYPE_BINNING = XformDialogsLrb.get("TRANSFORMATION_TYPE_BINNING");
    private static String TRANSFORMATION_TYPE_CUSTOM = XformDialogsLrb.get("TRANSFORMATION_TYPE_CUSTOM");
    private static String TRANSFORMATION_TYPE_CUSTOM_CATEGORICAL = XformDialogsLrb.get("TRANSFORMATION_TYPE_CUSTOM_CATEGORICAL");
    private static String TRANSFORMATION_TYPE_CUSTOM_NUMERRICAL = XformDialogsLrb.get("TRANSFORMATION_TYPE_CUSTOM_NUMERRICAL");
    private static String TRANSFORMATION_TYPE_MISS_VALUES = XformDialogsLrb.get("TRANSFORMATION_TYPE_MISS_VALUES");
    private static String TRANSFORMATION_TYPE_NORM = XformDialogsLrb.get("TRANSFORMATION_TYPE_NORM");
    private static String TRANSFORMATION_TYPE_OUTLIER = XformDialogsLrb.get("TRANSFORMATION_TYPE_OUTLIER");
    private static String TRANSFORMATION_TYPE_EXISTNG_COLUMN = XformDialogsLrb.get("TRANSFORMATION_TYPE_EXISTNG_COLUMN");
    private static String TRANSFORMATION_TYPE_CUSTOM_TIMESTAMP = XformDialogsLrb.get("TRANSFORMATION_TYPE_CUSTOM_TIMESTAMP");
    private static String TRANSFORMATION_TYPE_CUSTOM_TIMESTAMP_WITH_TIME_ZONE = XformDialogsLrb.get("TRANSFORMATION_TYPE_CUSTOM_TIMESTAMP_WITH_TIME_ZONE");
    private static String TRANSFORMATION_TYPE_BINNING_EQW_NUMBER = XformDialogsLrb.get("TRANSFORMATION_TYPE_BINNING_EQW_NUMBER");
    private static String TRANSFORMATION_TYPE_BINNING_EQW_RANGE = XformDialogsLrb.get("TRANSFORMATION_TYPE_BINNING_EQW_RANGE");
    private static String TRANSFORMATION_TYPE_BINNING_EQW_DATE = XformDialogsLrb.get("TRANSFORMATION_TYPE_BINNING_EQW_DATE");
    private static String TRANSFORMATION_TYPE_BINNING_TS_TZ = XformDialogsLrb.get("TRANSFORMATION_TYPE_BINNING_TS_TZ");
    private static String TRANSFORMATION_TYPE_BINNING_TOPN = XformDialogsLrb.get("TRANSFORMATION_TYPE_BINNING_TOPN");
    private static String TRANSFORMATION_TYPE_BINNING_QUANTILE = XformDialogsLrb.get("TRANSFORMATION_TYPE_BINNING_QUANTILE");
    private static String TRANSFORMATION_TYPE_BINNING_BINS = XformDialogsLrb.get("TRANSFORMATION_TYPE_BINNING_BINS");
    private static String TRANSFORMATION_TYPE_BINNING_AUTO = XformDialogsLrb.get("TRANSFORMATION_TYPE_BINNING_AUTO");
    private static String TRANSFORMATION_TYPE_MISS_VALUES_STATS = XformDialogsLrb.get("TRANSFORMATION_TYPE_MISS_VALUES_STATS");
    private static String TRANSFORMATION_TYPE_MISS_VALUES_VALUE = XformDialogsLrb.get("TRANSFORMATION_TYPE_MISS_VALUES_VALUE");
    private static String TRANSFORMATION_TYPE_MISS_VALUES_CATEGORICAL = XformDialogsLrb.get("TRANSFORMATION_TYPE_MISS_VALUES_CATEGORICAL");
    private static String TRANSFORMATION_TYPE_MISS_VALUES_NUMERICAL = XformDialogsLrb.get("TRANSFORMATION_TYPE_MISS_VALUES_NUMERICAL");
    private static String TRANSFORMATION_TYPE_MISS_VALUES_DATE = XformDialogsLrb.get("TRANSFORMATION_TYPE_MISS_VALUES_DATE");
    private static String TRANSFORMATION_TYPE_OUTLIER_ST_DEV = XformDialogsLrb.get("TRANSFORMATION_TYPE_OUTLIER_ST_DEV");
    private static String TRANSFORMATION_TYPE_OUTLIER_PERCENT = XformDialogsLrb.get("TRANSFORMATION_TYPE_OUTLIER_PERCENT");
    private static String TRANSFORMATION_TYPE_OUTLIER_VALUE = XformDialogsLrb.get("TRANSFORMATION_TYPE_OUTLIER_VALUE");
    private static String TRANSFORMATION_TYPE_OUTLIER_ST_DEV_ABBR = XformDialogsLrb.get("TRANSFORMATION_TYPE_OUTLIER_ST_DEV_ABBR");
    private static String TRANSFORMATION_TYPE_OUTLIER_PERCENT_ABBR = XformDialogsLrb.get("TRANSFORMATION_TYPE_OUTLIER_PERCENT_ABBR");
    private static String TRANSFORMATION_TYPE_OUTLIER_VALUE_ABBR = XformDialogsLrb.get("TRANSFORMATION_TYPE_OUTLIER_VALUE_ABBR");
    private static String TRANSFORMATION_TYPE_NORMALIZATION_MIN_MAX = XformDialogsLrb.get("TRANSFORMATION_TYPE_NORMALIZATION_MIN_MAX");
    private static String TRANSFORMATION_TYPE_NORMALIZATION_Z_SCORE = XformDialogsLrb.get("TRANSFORMATION_TYPE_NORMALIZATION_Z_SCORE");
    private static String TRANSFORMATION_TYPE_NORMALIZATION_LINEAR_SCALE = XformDialogsLrb.get("TRANSFORMATION_TYPE_NORMALIZATION_LINEAR_SCALE");
    private static String TRANSFORMATION_TYPE_NORMALIZATION_MANUAL = XformDialogsLrb.get("TRANSFORMATION_TYPE_NORMALIZATION_MANUAL");
    private static String TRANSFORMATION_TYPE_NORMALIZATION_MIN_MAX_ABBR = XformDialogsLrb.get("TRANSFORMATION_TYPE_NORMALIZATION_MIN_MAX_ABBR");
    private static String TRANSFORMATION_TYPE_NORMALIZATION_Z_SCORE_ABBR = XformDialogsLrb.get("TRANSFORMATION_TYPE_NORMALIZATION_Z_SCORE_ABBR");
    private static String TRANSFORMATION_TYPE_NORMALIZATION_LINEAR_SCALE_ABBR = XformDialogsLrb.get("TRANSFORMATION_TYPE_NORMALIZATION_LINEAR_SCALE_ABBR");
    private static String TRANSFORMATION_TYPE_NORMALIZATION_MANUAL_ABBR = XformDialogsLrb.get("TRANSFORMATION_TYPE_NORMALIZATION_MANUAL_ABBR");
    private static String TRANSFORMATION_TYPE_MISS_VALUES_NUMERIC_MEAN = XformDialogsLrb.get("TRANSFORMATION_TYPE_MISS_VALUES_NUMERIC_MEAN");
    private static String TRANSFORMATION_TYPE_MISS_VALUES_NUMERIC_MIN = XformDialogsLrb.get("TRANSFORMATION_TYPE_MISS_VALUES_NUMERIC_MIN");
    private static String TRANSFORMATION_TYPE_MISS_VALUES_NUMERIC_MAX = XformDialogsLrb.get("TRANSFORMATION_TYPE_MISS_VALUES_NUMERIC_MAX");
    private static String TRANSFORMATION_TYPE_MISS_VALUES_CATEGORIC_MODE = XformDialogsLrb.get("TRANSFORMATION_TYPE_MISS_VALUES_CATEGORIC_MODE");
    private static final String TRANSFORMATION_TYPE_CUSTOM_EXPRESSION_SELECTION = XformDialogsLrb.get("TRANSFORMATION_TYPE_CUSTOM_EXPRESSION_SELECTION");
    private static final String TRANSFORMATION_TYPE_CUSTOM_EXPRESSION = XformDialogsLrb.get("TRANSFORMATION_TYPE_CUSTOM_EXPRESSION");
    public static final String BINNING_PANEL = TransformationTypes.getTRANSFORMATION_TYPE_BINNING();
    public static final String MISS_VALUES_PANEL = TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES();
    public static final String CUSTOM_PANEL = TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM();
    public static final String NORMALIZATION_PANEL = TransformationTypes.getTRANSFORMATION_TYPE_NORM();
    public static final String OUTLIER_PANEL = TransformationTypes.getTRANSFORMATION_TYPE_OUTLIER();
    public static final String EXISTING_PANEL = TransformationTypes.getTRANSFORMATION_TYPE_EXISTNG_COLUMN();
    private static Map<String, String> _abbreviations = new HashMap<String, String>();
    private static String CUSTOM_ABBREVIATION = "CUS";
    private static String[] _customXformsvalues;
    private static String[] _numericXformsvalues;
    private static String[] _numericWizardXformsvalues;
    private static String[] _categoricXformsvalues;
    private static String[] _categoricWizardXformsvalues;
    private static String[] _dateWizardXformsvalues;
    private static String[] _dateXformsvalues;
    private static String[] _binningNumericTypes;
    private static String[] _binningNumericTypesNoCustom;
    private static String[] _binningDateTypes;
    private static String[] _binningTimestampTZTypes;
    private static String[] _binningDateTypesNoCustom;
    private static String[] _binningTimestampTimeZoneTypesNoCustom;
    private static String[] _binningCategoricTypes;
    private static String[] _binningCategoricTypesNoCustom;
    private static String[] _missValuesNumericStats;
    private static String[] _missValuesCategoricStats;

    public static boolean isDateOrTimestampDerived(int n) {
        return n == 3 || n == 4 || n == 5 || n == 6;
    }

    public static boolean isBinning(String string) {
        return string.equals(TRANSFORMATION_TYPE_BINNING);
    }

    public static boolean isBinning(TransformationType transformationType) {
        return null != transformationType.getBinning();
    }

    public static boolean isCustomNumericBinning(TransformationType transformationType) {
        return null != transformationType.getBinning() && null != transformationType.getBinning().getCustomNumeric();
    }

    public static boolean isCustomCategoricalBinning(TransformationType transformationType) {
        return null != transformationType.getBinning() && null != transformationType.getBinning().getCustomCategorical();
    }

    public static boolean isCustomDateBinning(TransformationType transformationType) {
        return null != transformationType.getBinning() && null != transformationType.getBinning().getCustomDate();
    }

    public static boolean isCustomTimestampBinning(TransformationType transformationType) {
        return null != transformationType.getBinning() && null != transformationType.getBinning().getCustomTimestamp();
    }

    public static boolean isMissingValues(String string) {
        return string.equals(TRANSFORMATION_TYPE_MISS_VALUES);
    }

    public static boolean isMissingValuesCategorical(TransformationType transformationType) {
        return null != transformationType.getMissingValuesCategorical();
    }

    public static boolean isMissingValuesDate(TransformationType transformationType) {
        return null != transformationType.getMissingValuesDate();
    }

    public static boolean isMissingValuesNumeric(TransformationType transformationType) {
        return null != transformationType.getMissingValuesNumeric();
    }

    public static boolean isNormalization(String string) {
        return string.equals(TRANSFORMATION_TYPE_NORM);
    }

    public static boolean isNormalization(TransformationType transformationType) {
        return null != transformationType.getNormalization();
    }

    public static boolean isOutlier(String string) {
        return string.equals(TRANSFORMATION_TYPE_OUTLIER);
    }

    public static boolean isOutlier(TransformationType transformationType) {
        return null != transformationType.getOutlier();
    }

    public static boolean isCustomXform(String string) {
        return string.equals(TRANSFORMATION_TYPE_CUSTOM);
    }

    public static boolean isCustomXform(TransformationType transformationType) {
        return null != transformationType.getCustomTransformation();
    }

    public static boolean isExistingColumn(String string) {
        return string.equals(TRANSFORMATION_TYPE_EXISTNG_COLUMN);
    }

    public static String[] customTransformationValues() {
        String[] stringArray = new String[_customXformsvalues.length];
        System.arraycopy(_customXformsvalues, 0, stringArray, 0, _customXformsvalues.length);
        stringArray[TransformationTypes._customXformsvalues.length - 1] = TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM();
        return stringArray;
    }

    public static String[] numericTransformationValues(boolean bl) {
        if (!bl) {
            return _numericXformsvalues;
        }
        String[] stringArray = new String[_numericXformsvalues.length + 1];
        System.arraycopy(_numericXformsvalues, 0, stringArray, 0, _numericXformsvalues.length);
        stringArray[TransformationTypes._numericXformsvalues.length] = TransformationTypes.getTRANSFORMATION_TYPE_EXISTNG_COLUMN();
        return stringArray;
    }

    public static String[] numericWizardTransformationValues(boolean bl) {
        if (!bl) {
            return _numericWizardXformsvalues;
        }
        String[] stringArray = new String[_numericWizardXformsvalues.length + 1];
        System.arraycopy(_numericWizardXformsvalues, 0, stringArray, 0, _numericWizardXformsvalues.length);
        stringArray[TransformationTypes._numericWizardXformsvalues.length] = TransformationTypes.getTRANSFORMATION_TYPE_EXISTNG_COLUMN();
        return stringArray;
    }

    public static String[] categoricTransformationValues(boolean bl) {
        if (!bl) {
            return _categoricXformsvalues;
        }
        String[] stringArray = new String[_categoricXformsvalues.length + 1];
        System.arraycopy(_categoricXformsvalues, 0, stringArray, 0, _categoricXformsvalues.length);
        stringArray[TransformationTypes._categoricXformsvalues.length] = TransformationTypes.getTRANSFORMATION_TYPE_EXISTNG_COLUMN();
        return stringArray;
    }

    public static String[] categoricWizardTransformationValues(boolean bl) {
        if (!bl) {
            return _categoricWizardXformsvalues;
        }
        String[] stringArray = new String[_categoricWizardXformsvalues.length + 1];
        System.arraycopy(_categoricWizardXformsvalues, 0, stringArray, 0, _categoricWizardXformsvalues.length);
        stringArray[TransformationTypes._categoricWizardXformsvalues.length] = TransformationTypes.getTRANSFORMATION_TYPE_EXISTNG_COLUMN();
        return stringArray;
    }

    public static String[] dateWizardTransformationValues(boolean bl) {
        if (!bl) {
            return _dateWizardXformsvalues;
        }
        String[] stringArray = new String[_dateWizardXformsvalues.length + 1];
        System.arraycopy(_dateWizardXformsvalues, 0, stringArray, 0, _dateWizardXformsvalues.length);
        stringArray[TransformationTypes._dateWizardXformsvalues.length] = TransformationTypes.getTRANSFORMATION_TYPE_EXISTNG_COLUMN();
        return stringArray;
    }

    public static String[] dateTransformationValues(boolean bl) {
        if (!bl) {
            return _dateXformsvalues;
        }
        String[] stringArray = new String[_dateXformsvalues.length + 1];
        System.arraycopy(_dateXformsvalues, 0, stringArray, 0, _dateXformsvalues.length);
        stringArray[TransformationTypes._dateXformsvalues.length] = TransformationTypes.getTRANSFORMATION_TYPE_EXISTNG_COLUMN();
        return stringArray;
    }

    public static String getXformAbbreviatedName(String string) {
        return _abbreviations.get(string);
    }

    protected static String getTRANSFORMATION_TYPE_BINNING() {
        return TRANSFORMATION_TYPE_BINNING;
    }

    public static String getTRANSFORMATION_TYPE_CUSTOM() {
        return TRANSFORMATION_TYPE_CUSTOM;
    }

    public static String getCUSTOM_ABBREVIATION() {
        return CUSTOM_ABBREVIATION;
    }

    public static String getTRANSFORMATION_TYPE_MISS_VALUES() {
        return TRANSFORMATION_TYPE_MISS_VALUES;
    }

    public static String getTRANSFORMATION_TYPE_NORM() {
        return TRANSFORMATION_TYPE_NORM;
    }

    public static String getTRANSFORMATION_TYPE_OUTLIER() {
        return TRANSFORMATION_TYPE_OUTLIER;
    }

    public static String getTRANSFORMATION_TYPE_EXISTNG_COLUMN() {
        return TRANSFORMATION_TYPE_EXISTNG_COLUMN;
    }

    public static String getTRANSFORMATION_TYPE_BINNING_EQW_NUMBER() {
        return TRANSFORMATION_TYPE_BINNING_EQW_NUMBER;
    }

    public static String getTRANSFORMATION_TYPE_BINNING_EQW_DATE() {
        return TRANSFORMATION_TYPE_BINNING_EQW_DATE;
    }

    public static String getTRANSFORMATION_TYPE_BINNING_EQW_TIMESTAMP_WITH_TIMEZONE() {
        return TRANSFORMATION_TYPE_BINNING_TS_TZ;
    }

    public static String getTRANSFORMATION_TYPE_BINNING_TOPN() {
        return TRANSFORMATION_TYPE_BINNING_TOPN;
    }

    public static String getTRANSFORMATION_TYPE_BINNING_CUSTOM_NUMERIC() {
        return TRANSFORMATION_TYPE_CUSTOM_NUMERRICAL;
    }

    public static String getTRANSFORMATION_TYPE_BINNING_CUSTOM_CATEGORIC() {
        return TRANSFORMATION_TYPE_CUSTOM_CATEGORICAL;
    }

    public static String getTRANSFORMATION_TYPE_BINNING_CUSTOM_TIMESTAMP() {
        return TRANSFORMATION_TYPE_CUSTOM_TIMESTAMP;
    }

    public static String getTRANSFORMATION_TYPE_BINNING_CUSTOM_TIMESTAMP_WITH_TIME_ZONE() {
        return TRANSFORMATION_TYPE_CUSTOM_TIMESTAMP_WITH_TIME_ZONE;
    }

    public static String getTRANSFORMATION_TYPE_BINNING_QUANTILE() {
        return TRANSFORMATION_TYPE_BINNING_QUANTILE;
    }

    public static String getTRANSFORMATION_TYPE_CUSTOM_EXPRESSION_SELECTION() {
        return TRANSFORMATION_TYPE_CUSTOM_EXPRESSION_SELECTION;
    }

    public static String getTRANSFORMATION_TYPE_CUSTOM_EXPRESSION() {
        return TRANSFORMATION_TYPE_CUSTOM_EXPRESSION;
    }

    public static String[] getBinningNumericTypes() {
        return _binningNumericTypes;
    }

    public static String[] getBinningCategoricTypes() {
        return _binningCategoricTypes;
    }

    public static String[] getBinningNumericTypesNoCustom() {
        return _binningNumericTypesNoCustom;
    }

    public static String[] getBinningCategoricTypesNoCustom() {
        return _binningCategoricTypesNoCustom;
    }

    public static String[] getBinningDateTypes() {
        return _binningDateTypes;
    }

    public static String[] getBinningTimestampTZTypes() {
        return _binningTimestampTZTypes;
    }

    public static String[] getBinningDateTypesNoCustom() {
        return _binningDateTypesNoCustom;
    }

    public static String[] getBinningTimestampTimeZoneTypesNoCustom() {
        return _binningTimestampTimeZoneTypesNoCustom;
    }

    public static String[] getMissValuesNumericStats() {
        return _missValuesNumericStats;
    }

    public static String[] getMissValuesCategoricStats() {
        return _missValuesCategoricStats;
    }

    public static String getTRANSFORMATION_TYPE_MISS_VALUES_STATS() {
        return TRANSFORMATION_TYPE_MISS_VALUES_STATS;
    }

    public static String getTRANSFORMATION_TYPE_MISS_VALUES_VALUE() {
        return TRANSFORMATION_TYPE_MISS_VALUES_VALUE;
    }

    public static String binningToString(TransformationType transformationType) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (TransformationTypes.isBinning(transformationType)) {
            if (null != transformationType.getBinning().getCustomCategorical()) {
                stringBuilder.append(TRANSFORMATION_TYPE_CUSTOM_CATEGORICAL);
            } else if (null != transformationType.getBinning().getCustomNumeric()) {
                stringBuilder.append(TRANSFORMATION_TYPE_CUSTOM_NUMERRICAL);
            } else if (null != transformationType.getBinning().getCustomTimestamp()) {
                stringBuilder.append(TRANSFORMATION_TYPE_CUSTOM_TIMESTAMP_WITH_TIME_ZONE);
            } else if (null != transformationType.getBinning().getEqualWidth()) {
                stringBuilder.append(TRANSFORMATION_TYPE_BINNING_EQW_NUMBER);
            } else if (null != transformationType.getBinning().getDateEqualWidth()) {
                stringBuilder.append(TRANSFORMATION_TYPE_BINNING_EQW_DATE);
            } else if (null != transformationType.getBinning().getTimestampEqualWidth()) {
                stringBuilder.append(TRANSFORMATION_TYPE_BINNING_TS_TZ);
            } else if (null != transformationType.getBinning().getQuantile()) {
                stringBuilder.append(TRANSFORMATION_TYPE_BINNING_QUANTILE);
            } else if (null != transformationType.getBinning().getTopN()) {
                stringBuilder.append(TRANSFORMATION_TYPE_BINNING_TOPN);
            } else if (null != transformationType.getBinning().getCustomDate()) {
                stringBuilder.append(TRANSFORMATION_TYPE_CUSTOM_TIMESTAMP);
            } else if (null != transformationType.getBinning().getCustomTimestamp()) {
                stringBuilder.append(TRANSFORMATION_TYPE_CUSTOM_TIMESTAMP_WITH_TIME_ZONE);
            }
        }
        return stringBuilder.toString();
    }

    public static int getBinCount(TransformationType transformationType) {
        BigInteger bigInteger = null;
        if (TransformationTypes.isBinning(transformationType)) {
            if (null != transformationType.getBinning().getCustomCategorical()) {
                bigInteger = BigInteger.valueOf(transformationType.getBinning().getCustomCategorical().getCategoricalBin().size());
            } else if (null != transformationType.getBinning().getCustomDate()) {
                bigInteger = BigInteger.valueOf(transformationType.getBinning().getCustomDate().getDateBin().size());
            } else if (null != transformationType.getBinning().getCustomTimestamp()) {
                bigInteger = BigInteger.valueOf(transformationType.getBinning().getCustomTimestamp().getTimestampTimezoneBin().size());
            } else if (null != transformationType.getBinning().getCustomNumeric()) {
                bigInteger = BigInteger.valueOf(transformationType.getBinning().getCustomNumeric().getNumericBin().size());
            } else if (null != transformationType.getBinning().getEqualWidth()) {
                bigInteger = transformationType.getBinning().getEqualWidth().getBinCount();
            } else if (null != transformationType.getBinning().getDateEqualWidth()) {
                bigInteger = transformationType.getBinning().getDateEqualWidth().getBinCount();
            } else if (null != transformationType.getBinning().getTimestampEqualWidth()) {
                bigInteger = transformationType.getBinning().getTimestampEqualWidth().getBinCount();
            } else if (null != transformationType.getBinning().getQuantile()) {
                bigInteger = transformationType.getBinning().getQuantile().getBinCount();
            } else if (null != transformationType.getBinning().getTopN()) {
                bigInteger = transformationType.getBinning().getTopN().getBinCount();
            }
        }
        return bigInteger != null ? bigInteger.intValue() : -1;
    }

    public static BinLabels getBinLabels(TransformationType transformationType) {
        BinLabels binLabels = null;
        if (TransformationTypes.isBinning(transformationType)) {
            if (null != transformationType.getBinning().getEqualWidth()) {
                binLabels = transformationType.getBinning().getEqualWidth().getBinLabels();
            } else if (null != transformationType.getBinning().getDateEqualWidth()) {
                binLabels = transformationType.getBinning().getDateEqualWidth().getBinLabels();
            } else if (null != transformationType.getBinning().getTimestampEqualWidth()) {
                binLabels = transformationType.getBinning().getTimestampEqualWidth().getBinLabels();
            } else if (null != transformationType.getBinning().getQuantile()) {
                binLabels = transformationType.getBinning().getQuantile().getBinLabels();
            } else {
                binLabels = new BinLabels();
                binLabels.setRange(new BinLabels.Range());
            }
        }
        return binLabels;
    }

    public static BinGeneration getBinGeneration(TransformationType transformationType) {
        BinGeneration binGeneration = null;
        if (TransformationTypes.isBinning(transformationType)) {
            if (null != transformationType.getBinning().getEqualWidth()) {
                binGeneration = transformationType.getBinning().getEqualWidth().getBinGeneration();
            } else if (null != transformationType.getBinning().getDateEqualWidth()) {
                binGeneration = transformationType.getBinning().getDateEqualWidth().getBinGeneration();
            } else if (null != transformationType.getBinning().getTimestampEqualWidth()) {
                binGeneration = transformationType.getBinning().getTimestampEqualWidth().getBinGeneration();
            } else if (null != transformationType.getBinning().getQuantile()) {
                binGeneration = transformationType.getBinning().getQuantile().getBinGeneration();
            } else {
                binGeneration = new BinGeneration();
                binGeneration.setManual(new BinGeneration.Manual());
            }
        }
        return binGeneration;
    }

    public static Object getCustomBinningSpec(TransformationType transformationType) {
        TransformationType.Binning.CustomCategorical customCategorical = null;
        if (TransformationTypes.isBinning(transformationType)) {
            if (null != transformationType.getBinning().getCustomCategorical()) {
                customCategorical = transformationType.getBinning().getCustomCategorical();
            } else if (null != transformationType.getBinning().getCustomNumeric()) {
                customCategorical = transformationType.getBinning().getCustomNumeric();
            } else if (null != transformationType.getBinning().getCustomDate()) {
                customCategorical = transformationType.getBinning().getCustomDate();
            } else if (null != transformationType.getBinning().getCustomTimestamp()) {
                customCategorical = transformationType.getBinning().getCustomTimestamp();
            }
        }
        return customCategorical;
    }

    public static Object getCustomBinningSpecOfExistingColumn(TransformationType transformationType) {
        TransformationType.Binning.CustomCategorical customCategorical = null;
        if (TransformationTypes.isBinning(transformationType)) {
            if (null != transformationType.getBinning().getCustomCategorical()) {
                customCategorical = new TransformationType.Binning.CustomCategorical();
            } else if (null != transformationType.getBinning().getCustomNumeric()) {
                customCategorical = new TransformationType.Binning.CustomNumeric();
            } else if (null != transformationType.getBinning().getCustomDate()) {
                customCategorical = new TransformationType.Binning.CustomDate();
            } else if (null != transformationType.getBinning().getCustomTimestamp()) {
                customCategorical = new TransformationType.Binning.CustomTimestamp();
            }
        }
        return customCategorical;
    }

    public static String xformToString(TransformationType transformationType) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (TransformationTypes.isBinning(transformationType)) {
            if (null != transformationType.getBinning().getCustomCategorical()) {
                stringBuilder.append(TRANSFORMATION_TYPE_CUSTOM_CATEGORICAL);
            } else if (null != transformationType.getBinning().getCustomNumeric()) {
                stringBuilder.append(TRANSFORMATION_TYPE_CUSTOM_NUMERRICAL);
            } else if (null != transformationType.getBinning().getCustomDate()) {
                stringBuilder.append(TRANSFORMATION_TYPE_CUSTOM_TIMESTAMP);
            } else if (null != transformationType.getBinning().getCustomTimestamp()) {
                stringBuilder.append(TRANSFORMATION_TYPE_CUSTOM_TIMESTAMP_WITH_TIME_ZONE);
            } else if (null != transformationType.getBinning().getEqualWidth()) {
                BigInteger bigInteger = transformationType.getBinning().getEqualWidth().getBinCount();
                if (transformationType.getBinning().getEqualWidth().getBinLabels().getNumberSequence() != null) {
                    stringBuilder.append(TRANSFORMATION_TYPE_BINNING_EQW_NUMBER);
                } else {
                    stringBuilder.append(TRANSFORMATION_TYPE_BINNING_EQW_RANGE);
                }
                if (bigInteger != null) {
                    stringBuilder.append("(");
                    stringBuilder.append(bigInteger.toString());
                    stringBuilder.append(" ");
                    stringBuilder.append(TRANSFORMATION_TYPE_BINNING_BINS);
                    stringBuilder.append(")");
                }
            } else if (null != transformationType.getBinning().getDateEqualWidth()) {
                stringBuilder.append(TRANSFORMATION_TYPE_BINNING_EQW_DATE);
                BigInteger bigInteger = transformationType.getBinning().getDateEqualWidth().getBinCount();
                if (bigInteger != null) {
                    stringBuilder.append("(");
                    stringBuilder.append(bigInteger.toString());
                    stringBuilder.append(" ");
                    stringBuilder.append(TRANSFORMATION_TYPE_BINNING_BINS);
                    stringBuilder.append(")");
                }
            } else if (null != transformationType.getBinning().getTimestampEqualWidth()) {
                stringBuilder.append(TRANSFORMATION_TYPE_BINNING_TS_TZ);
                BigInteger bigInteger = transformationType.getBinning().getTimestampEqualWidth().getBinCount();
                if (bigInteger != null) {
                    stringBuilder.append("(");
                    stringBuilder.append(bigInteger.toString());
                    stringBuilder.append(" ");
                    stringBuilder.append(TRANSFORMATION_TYPE_BINNING_BINS);
                    stringBuilder.append(")");
                }
            } else if (null != transformationType.getBinning().getQuantile()) {
                stringBuilder.append(TRANSFORMATION_TYPE_BINNING_QUANTILE);
                BigInteger bigInteger = transformationType.getBinning().getQuantile().getBinCount();
                if (bigInteger != null) {
                    stringBuilder.append("(");
                    stringBuilder.append(bigInteger.toString());
                    stringBuilder.append(" ");
                    stringBuilder.append(TRANSFORMATION_TYPE_BINNING_BINS);
                    stringBuilder.append(")");
                }
            } else if (null != transformationType.getBinning().getTopN()) {
                stringBuilder.append(TRANSFORMATION_TYPE_BINNING_TOPN);
                BigInteger bigInteger = transformationType.getBinning().getTopN().getBinCount();
                if (bigInteger != null) {
                    stringBuilder.append("(");
                    stringBuilder.append(bigInteger.toString());
                    stringBuilder.append(" ");
                    stringBuilder.append(TRANSFORMATION_TYPE_BINNING_BINS);
                    stringBuilder.append(")");
                }
            }
        } else if (TransformationTypes.isMissingValuesCategorical(transformationType)) {
            stringBuilder.append(TRANSFORMATION_TYPE_MISS_VALUES_CATEGORICAL);
        } else if (TransformationTypes.isMissingValuesNumeric(transformationType)) {
            stringBuilder.append(TRANSFORMATION_TYPE_MISS_VALUES_NUMERICAL);
        } else if (TransformationTypes.isMissingValuesDate(transformationType)) {
            stringBuilder.append(TRANSFORMATION_TYPE_MISS_VALUES_DATE);
        } else if (TransformationTypes.isOutlier(transformationType)) {
            if (null != transformationType.getOutlier().getPercent()) {
                stringBuilder.append(TRANSFORMATION_TYPE_OUTLIER_PERCENT_ABBR);
            } else if (null != transformationType.getOutlier().getValue()) {
                stringBuilder.append(TRANSFORMATION_TYPE_OUTLIER_VALUE_ABBR);
            } else {
                stringBuilder.append(TRANSFORMATION_TYPE_OUTLIER_ST_DEV_ABBR);
            }
        } else if (TransformationTypes.isNormalization(transformationType)) {
            if (null != transformationType.getNormalization().getMinMax()) {
                stringBuilder.append(TRANSFORMATION_TYPE_NORMALIZATION_MIN_MAX_ABBR);
            } else if (null != transformationType.getNormalization().getZScore()) {
                stringBuilder.append(TRANSFORMATION_TYPE_NORMALIZATION_Z_SCORE_ABBR);
            } else if (null != transformationType.getNormalization().getLinearScale()) {
                stringBuilder.append(TRANSFORMATION_TYPE_NORMALIZATION_LINEAR_SCALE_ABBR);
            } else {
                stringBuilder.append(TRANSFORMATION_TYPE_NORMALIZATION_MANUAL_ABBR);
            }
        } else if (TransformationTypes.isCustomXform(transformationType)) {
            stringBuilder.append(TRANSFORMATION_TYPE_CUSTOM);
        }
        return stringBuilder.toString();
    }

    public static String transformationTypeToString(TransformationType transformationType) {
        String string = "";
        if (null != transformationType.getBinning()) {
            string = TransformationTypes.getTRANSFORMATION_TYPE_BINNING();
        } else if (null != transformationType.getMissingValuesNumeric()) {
            string = TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES();
        } else if (null != transformationType.getMissingValuesCategorical()) {
            string = TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES();
        } else if (null != transformationType.getMissingValuesDate()) {
            string = TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES();
        } else if (null != transformationType.getNormalization()) {
            string = TransformationTypes.getTRANSFORMATION_TYPE_NORM();
        } else if (null != transformationType.getOutlier()) {
            string = TransformationTypes.getTRANSFORMATION_TYPE_OUTLIER();
        } else if (null != transformationType.getCustomTransformation()) {
            string = TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM();
        }
        return string;
    }

    public static TransformationType initBinning(String string, Integer n, boolean bl, boolean bl2) {
        TransformationType transformationType = new TransformationType();
        TransformationType.Binning binning = new TransformationType.Binning();
        if (string.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_EQW_NUMBER())) {
            TransformationType.Binning.EqualWidth equalWidth = new TransformationType.Binning.EqualWidth();
            equalWidth.setBinCount(BigInteger.valueOf(n.intValue()));
            BinGeneration binGeneration = new BinGeneration();
            if (bl) {
                binGeneration.setAuto(new BinGeneration.Auto());
            } else {
                binGeneration.setManual(new BinGeneration.Manual());
            }
            equalWidth.setBinGeneration(binGeneration);
            BinLabels binLabels = new BinLabels();
            if (bl2) {
                binLabels.setRange(new BinLabels.Range());
            } else {
                binLabels.setNumberSequence(new BinLabels.NumberSequence());
            }
            equalWidth.setBinLabels(binLabels);
            binning.setEqualWidth(equalWidth);
        } else if (string.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_EQW_DATE())) {
            TransformationType.Binning.DateEqualWidth dateEqualWidth = new TransformationType.Binning.DateEqualWidth();
            dateEqualWidth.setBinCount(BigInteger.valueOf(n.intValue()));
            BinGeneration binGeneration = new BinGeneration();
            if (bl) {
                binGeneration.setAuto(new BinGeneration.Auto());
            } else {
                binGeneration.setManual(new BinGeneration.Manual());
            }
            dateEqualWidth.setBinGeneration(binGeneration);
            BinLabels binLabels = new BinLabels();
            if (bl2) {
                binLabels.setRange(new BinLabels.Range());
            } else {
                binLabels.setNumberSequence(new BinLabels.NumberSequence());
            }
            dateEqualWidth.setBinLabels(binLabels);
            binning.setDateEqualWidth(dateEqualWidth);
        } else if (string.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_EQW_TIMESTAMP_WITH_TIMEZONE())) {
            TransformationType.Binning.TimestampEqualWidth timestampEqualWidth = new TransformationType.Binning.TimestampEqualWidth();
            timestampEqualWidth.setBinCount(BigInteger.valueOf(n.intValue()));
            BinGeneration binGeneration = new BinGeneration();
            if (bl) {
                binGeneration.setAuto(new BinGeneration.Auto());
            } else {
                binGeneration.setManual(new BinGeneration.Manual());
            }
            timestampEqualWidth.setBinGeneration(binGeneration);
            BinLabels binLabels = new BinLabels();
            if (bl2) {
                binLabels.setRange(new BinLabels.Range());
            } else {
                binLabels.setNumberSequence(new BinLabels.NumberSequence());
            }
            timestampEqualWidth.setBinLabels(binLabels);
            binning.setTimestampEqualWidth(timestampEqualWidth);
        } else if (string.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_QUANTILE())) {
            TransformationType.Binning.Quantile quantile = new TransformationType.Binning.Quantile();
            quantile.setBinCount(BigInteger.valueOf(n.intValue()));
            BinGeneration binGeneration = new BinGeneration();
            if (bl) {
                binGeneration.setAuto(new BinGeneration.Auto());
            } else {
                binGeneration.setManual(new BinGeneration.Manual());
            }
            quantile.setBinGeneration(binGeneration);
            BinLabels binLabels = new BinLabels();
            if (bl2) {
                binLabels.setRange(new BinLabels.Range());
            } else {
                binLabels.setNumberSequence(new BinLabels.NumberSequence());
            }
            quantile.setBinLabels(binLabels);
            binning.setQuantile(quantile);
        } else if (string.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_TOPN())) {
            TransformationType.Binning.TopN topN = new TransformationType.Binning.TopN();
            topN.setBinCount(BigInteger.valueOf(n.intValue()));
            topN.setOther(XformDialogsLrb.get("TOP_N_OTHER"));
            binning.setTopN(topN);
        }
        transformationType.setBinning(binning);
        return transformationType;
    }

    public static TransformationType initCustomBinning(String string, Object object) {
        if (object == null) {
            return null;
        }
        TransformationType transformationType = new TransformationType();
        TransformationType.Binning binning = new TransformationType.Binning();
        transformationType.setBinning(binning);
        if (string.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_NUMERIC())) {
            TransformationType.Binning.CustomNumeric customNumeric = (TransformationType.Binning.CustomNumeric)object;
            binning.setCustomNumeric(customNumeric);
        } else if (string.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_CATEGORIC())) {
            TransformationType.Binning.CustomCategorical customCategorical = (TransformationType.Binning.CustomCategorical)object;
            binning.setCustomCategorical(customCategorical);
        } else if (string.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_TIMESTAMP())) {
            TransformationType.Binning.CustomDate customDate = (TransformationType.Binning.CustomDate)object;
            binning.setCustomDate(customDate);
        } else if (string.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_TIMESTAMP_WITH_TIME_ZONE())) {
            TransformationType.Binning.CustomTimestamp customTimestamp = (TransformationType.Binning.CustomTimestamp)object;
            binning.setCustomTimestamp(customTimestamp);
        }
        return transformationType;
    }

    public static TransformationType initMissValues(int n, String string, Object object) {
        TransformationType transformationType = new TransformationType();
        if (n == 2) {
            CategoricalStatistic categoricalStatistic = null;
            if (string.equals(TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES_STATS())) {
                categoricalStatistic = new CategoricalStatistic();
                categoricalStatistic.setReplaceNullsWith(object.toString());
            }
            TransformationType.MissingValuesCategorical missingValuesCategorical = new TransformationType.MissingValuesCategorical();
            transformationType.setMissingValuesCategorical(missingValuesCategorical);
            if (null != categoricalStatistic) {
                missingValuesCategorical.setCategoricalStatistic(categoricalStatistic);
            } else {
                TransformationType.MissingValuesCategorical.Value value = new TransformationType.MissingValuesCategorical.Value();
                value.setReplaceNullsWith(object.toString());
                missingValuesCategorical.setValue(value);
            }
        } else if (n == 1) {
            NumericStatistic numericStatistic = null;
            if (string.equals(TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES_STATS())) {
                numericStatistic = new NumericStatistic();
                numericStatistic.setReplaceNullsWith(object.toString());
            }
            TransformationType.MissingValuesNumeric missingValuesNumeric = new TransformationType.MissingValuesNumeric();
            transformationType.setMissingValuesNumeric(missingValuesNumeric);
            if (null != numericStatistic) {
                missingValuesNumeric.setNumericStatistic(numericStatistic);
            } else {
                TransformationType.MissingValuesNumeric.Value value = new TransformationType.MissingValuesNumeric.Value();
                value.setReplaceNullsWith((Double)object);
                missingValuesNumeric.setValue(value);
            }
        } else {
            DateStatistic dateStatistic = null;
            if (string.equals(TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES_STATS())) {
                dateStatistic = new DateStatistic();
                dateStatistic.setReplaceNullsWith(object.toString());
            }
            TransformationType.MissingValuesDate missingValuesDate = new TransformationType.MissingValuesDate();
            transformationType.setMissingValuesDate(missingValuesDate);
            if (null != dateStatistic) {
                missingValuesDate.setDateStatistic(dateStatistic);
            } else {
                TransformationType.MissingValuesDate.Value value = new TransformationType.MissingValuesDate.Value();
                value.setReplaceNullsWith(TimeUtils.Date2XMLDate((Calendar)object));
                missingValuesDate.setValue(value);
            }
        }
        return transformationType;
    }

    public static boolean isComparabelDataTypes(String string, String string2) {
        assert (string != null && string2 != null);
        if (!(string.equals("VARCHAR2") || string.equals("CHAR") || string.equals("NUMBER") || string.equals("FLOAT") || string.equals("BINARY_DOUBLE") || string.equals("BINARY_FLOAT") || DatabaseMetadataUtils.isTimestampDerived(string) || string.equals("DATE"))) {
            return false;
        }
        if (!(string2.equals("VARCHAR2") || string2.equals("CHAR") || string2.equals("NUMBER") || string2.equals("FLOAT") || string2.equals("BINARY_DOUBLE") || string2.equals("BINARY_FLOAT") || DatabaseMetadataUtils.isTimestampDerived(string2) || string2.equals("DATE"))) {
            return false;
        }
        if ((string.equals("VARCHAR2") || string.equals("CHAR")) && (string2.equals("VARCHAR2") || string2.equals("CHAR"))) {
            return true;
        }
        if (string.equals("FLOAT") && string2.equals("FLOAT")) {
            return true;
        }
        if (string.equals("NUMBER") && string2.equals("NUMBER")) {
            return true;
        }
        if (string.equals("BINARY_DOUBLE") && string2.equals("BINARY_DOUBLE")) {
            return true;
        }
        if (string.equals("BINARY_FLOAT") && string2.equals("BINARY_FLOAT")) {
            return true;
        }
        if ((string.equals("DATE") || DatabaseMetadataUtils.isTimestamp(string) || DatabaseMetadataUtils.isTimestampWithLocalTimeZone(string)) && (string2.equals("DATE") || DatabaseMetadataUtils.isTimestamp(string2) || DatabaseMetadataUtils.isTimestampWithLocalTimeZone(string2))) {
            return true;
        }
        return DatabaseMetadataUtils.isTimestampWithTimeZone(string) && DatabaseMetadataUtils.isTimestampWithTimeZone(string2);
    }

    public static boolean areEqual(TransformationType transformationType, TransformationType transformationType2) {
        boolean bl = false;
        if (transformationType.getBinning() != null && transformationType2.getBinning() != null) {
            TransformationType.Binning binning = transformationType.getBinning();
            TransformationType.Binning binning2 = transformationType2.getBinning();
            if (binning.getEqualWidth() != null && binning2.getEqualWidth() != null) {
                if (binning.getEqualWidth().getBinCount().equals(binning2.getEqualWidth().getBinCount()) && (binning.getEqualWidth().getBinLabels().getRange() != null && binning2.getEqualWidth().getBinLabels().getRange() != null || binning.getEqualWidth().getBinLabels().getNumberSequence() != null && binning2.getEqualWidth().getBinLabels().getNumberSequence() != null)) {
                    bl = true;
                }
            } else if (binning.getDateEqualWidth() != null && binning2.getDateEqualWidth() != null) {
                if (binning.getDateEqualWidth().getBinCount().equals(binning2.getDateEqualWidth().getBinCount()) && (binning.getDateEqualWidth().getBinLabels().getRange() != null && binning2.getDateEqualWidth().getBinLabels().getRange() != null || binning.getDateEqualWidth().getBinLabels().getNumberSequence() != null && binning2.getDateEqualWidth().getBinLabels().getNumberSequence() != null)) {
                    bl = true;
                }
            } else if (binning.getTimestampEqualWidth() != null && binning2.getTimestampEqualWidth() != null) {
                if (binning.getTimestampEqualWidth().getBinCount().equals(binning2.getTimestampEqualWidth().getBinCount()) && (binning.getTimestampEqualWidth().getBinLabels().getRange() != null && binning2.getTimestampEqualWidth().getBinLabels().getRange() != null || binning.getTimestampEqualWidth().getBinLabels().getNumberSequence() != null && binning2.getTimestampEqualWidth().getBinLabels().getNumberSequence() != null)) {
                    bl = true;
                }
            } else if (binning.getQuantile() != null && binning2.getQuantile() != null) {
                if (binning.getQuantile().getBinCount().equals(binning2.getQuantile().getBinCount()) && (binning.getQuantile().getBinLabels().getRange() != null && binning2.getQuantile().getBinLabels().getRange() != null || binning.getQuantile().getBinLabels().getNumberSequence() != null && binning2.getQuantile().getBinLabels().getNumberSequence() != null)) {
                    bl = true;
                }
            } else if (binning.getTopN() != null && binning2.getTopN() != null) {
                if (binning.getTopN().getBinCount().equals(binning2.getTopN().getBinCount())) {
                    bl = true;
                }
            } else if (binning.getCustomCategorical() != null && binning2.getCustomCategorical() != null) {
                List list = binning.getCustomCategorical().getCategoricalBin();
                List list2 = binning2.getCustomCategorical().getCategoricalBin();
                if (list != null && list2 != null && list.size() == list2.size()) {
                    bl = true;
                    block0: for (int i = 0; i < list.size(); ++i) {
                        CategoricalBin categoricalBin = (CategoricalBin)list.get(i);
                        CategoricalBin categoricalBin2 = (CategoricalBin)list2.get(i);
                        if (!categoricalBin.getName().equals(categoricalBin2.getName())) {
                            bl = false;
                            break;
                        }
                        StringCollection stringCollection = categoricalBin.getStringCollectionValues();
                        StringCollection stringCollection2 = categoricalBin2.getStringCollectionValues();
                        List list3 = stringCollection.getValue();
                        List list4 = stringCollection2.getValue();
                        if (list3.size() != list4.size()) {
                            bl = false;
                            break;
                        }
                        for (int j = 0; j < list3.size(); ++j) {
                            if (((String)list3.get(j)).equals(list4.get(j))) continue;
                            bl = false;
                            continue block0;
                        }
                    }
                }
            } else if (binning.getCustomNumeric() != null && binning2.getCustomNumeric() != null) {
                if (binning.getCustomNumeric().getBinLabels().getRange() != null && binning2.getCustomNumeric().getBinLabels().getRange() != null || binning.getCustomNumeric().getBinLabels().getNumberSequence() != null && binning2.getCustomNumeric().getBinLabels().getNumberSequence() != null) {
                    List list = binning.getCustomNumeric().getNumericBin();
                    List list5 = binning2.getCustomNumeric().getNumericBin();
                    if (list != null && list5 != null && list.size() == list5.size()) {
                        bl = true;
                        for (int i = 0; i < list.size(); ++i) {
                            NumericBin numericBin = (NumericBin)list.get(i);
                            NumericBin numericBin2 = (NumericBin)list5.get(i);
                            if (!numericBin.getBinName().equals(numericBin2.getBinName())) {
                                bl = false;
                            } else {
                                if (numericBin.getLowerBound() == numericBin2.getLowerBound()) continue;
                                bl = false;
                            }
                            break;
                        }
                    }
                }
            } else if (binning.getCustomDate() != null && binning2.getCustomDate() != null) {
                List list = binning.getCustomDate().getDateBin();
                List list6 = binning2.getCustomDate().getDateBin();
                if (list != null && list6 != null && list.size() == list6.size()) {
                    bl = true;
                    for (int i = 0; i < list.size(); ++i) {
                        DateBin dateBin = (DateBin)list.get(i);
                        DateBin dateBin2 = (DateBin)list6.get(i);
                        if (!dateBin.getName().equals(dateBin2.getName())) {
                            bl = false;
                        } else {
                            DateBin.LowerBound lowerBound = dateBin.getLowerBound();
                            DateBin.LowerBound lowerBound2 = dateBin2.getLowerBound();
                            if (lowerBound.getValue() != null && lowerBound2.getValue() != null) {
                                if (lowerBound.getValue().equals(lowerBound2.getValue())) continue;
                                bl = false;
                            } else {
                                if (lowerBound.getValue() == null && lowerBound2.getValue() == null) continue;
                                bl = false;
                            }
                        }
                        break;
                    }
                }
            } else if (binning.getCustomTimestamp() != null && binning2.getCustomTimestamp() != null) {
                List list = binning.getCustomTimestamp().getTimestampTimezoneBin();
                List list7 = binning2.getCustomTimestamp().getTimestampTimezoneBin();
                if (list != null && list7 != null && list.size() == list7.size()) {
                    bl = true;
                    for (int i = 0; i < list.size(); ++i) {
                        TimestampTimezoneBin timestampTimezoneBin = (TimestampTimezoneBin)list.get(i);
                        TimestampTimezoneBin timestampTimezoneBin2 = (TimestampTimezoneBin)list7.get(i);
                        if (!timestampTimezoneBin.getName().equals(timestampTimezoneBin2.getName())) {
                            bl = false;
                        } else {
                            TimestampTimezoneBin.LowerBound lowerBound = timestampTimezoneBin.getLowerBound();
                            TimestampTimezoneBin.LowerBound lowerBound3 = timestampTimezoneBin2.getLowerBound();
                            if (lowerBound.getValue() != null && lowerBound3.getValue() != null) {
                                if (lowerBound.getValue().equals(lowerBound3.getValue())) continue;
                                bl = false;
                            } else {
                                if (lowerBound.getValue() == null && lowerBound3.getValue() == null) continue;
                                bl = false;
                            }
                        }
                        break;
                    }
                }
            }
        } else if (null != transformationType.getMissingValuesCategorical() && null != transformationType2.getMissingValuesCategorical()) {
            TransformationType.MissingValuesCategorical missingValuesCategorical = transformationType.getMissingValuesCategorical();
            TransformationType.MissingValuesCategorical missingValuesCategorical2 = transformationType2.getMissingValuesCategorical();
            if (null != missingValuesCategorical.getCategoricalStatistic() && null != missingValuesCategorical2.getCategoricalStatistic()) {
                if (missingValuesCategorical.getCategoricalStatistic().getReplaceNullsWith().equals(missingValuesCategorical2.getCategoricalStatistic().getReplaceNullsWith())) {
                    bl = true;
                }
            } else if (null != missingValuesCategorical.getValue() && null != missingValuesCategorical2.getValue() && missingValuesCategorical.getValue().getReplaceNullsWith().equals(missingValuesCategorical2.getValue().getReplaceNullsWith())) {
                bl = true;
            }
        } else if (null != transformationType.getMissingValuesNumeric() && null != transformationType2.getMissingValuesNumeric()) {
            TransformationType.MissingValuesNumeric missingValuesNumeric = transformationType.getMissingValuesNumeric();
            TransformationType.MissingValuesNumeric missingValuesNumeric2 = transformationType2.getMissingValuesNumeric();
            if (null != missingValuesNumeric.getNumericStatistic() && null != missingValuesNumeric2.getNumericStatistic()) {
                if (missingValuesNumeric.getNumericStatistic().getReplaceNullsWith().equals(missingValuesNumeric2.getNumericStatistic().getReplaceNullsWith())) {
                    bl = true;
                }
            } else if (null != missingValuesNumeric.getValue() && null != missingValuesNumeric2.getValue() && missingValuesNumeric.getValue().getReplaceNullsWith() == missingValuesNumeric2.getValue().getReplaceNullsWith()) {
                bl = true;
            }
        } else if (null != transformationType.getMissingValuesDate() && null != transformationType2.getMissingValuesDate()) {
            TransformationType.MissingValuesDate missingValuesDate = transformationType.getMissingValuesDate();
            TransformationType.MissingValuesDate missingValuesDate2 = transformationType2.getMissingValuesDate();
            if (null != missingValuesDate.getDateStatistic() && null != missingValuesDate2.getDateStatistic()) {
                if (missingValuesDate.getDateStatistic().getReplaceNullsWith().equals(missingValuesDate2.getDateStatistic().getReplaceNullsWith())) {
                    bl = true;
                }
            } else if (null != missingValuesDate.getValue() && null != missingValuesDate2.getValue() && missingValuesDate.getValue().getReplaceNullsWith() == missingValuesDate2.getValue().getReplaceNullsWith()) {
                bl = true;
            }
        } else if (null != transformationType.getOutlier() && null != transformationType2.getOutlier()) {
            TransformationType.Outlier outlier = transformationType.getOutlier();
            TransformationType.Outlier outlier2 = transformationType2.getOutlier();
            if (outlier.getReplaceWith().equals(outlier2.getReplaceWith())) {
                if (null != outlier.getPercent() && null != outlier2.getPercent()) {
                    if (outlier.getPercent().getLowerPercent() == outlier2.getPercent().getLowerPercent() && outlier.getPercent().getUpperPercent() == outlier2.getPercent().getUpperPercent()) {
                        bl = true;
                    }
                } else if (null != outlier.getValue() && null != outlier2.getValue()) {
                    if (outlier.getValue().getLowerValue() == outlier2.getValue().getLowerValue() && outlier.getValue().getUpperValue() == outlier2.getValue().getUpperValue()) {
                        bl = true;
                    }
                } else if (null != outlier.getStandardDeviation() && null != outlier2.getStandardDeviation() && outlier.getStandardDeviation().getMultiplesSigma() == outlier2.getStandardDeviation().getMultiplesSigma()) {
                    bl = true;
                }
            }
        } else if (null != transformationType.getNormalization() && null != transformationType2.getNormalization()) {
            TransformationType.Normalization normalization = transformationType.getNormalization();
            TransformationType.Normalization normalization2 = transformationType2.getNormalization();
            if (null != normalization.getManual() && null != normalization2.getManual()) {
                if (normalization.getManual().getShift() == normalization2.getManual().getShift() && normalization.getManual().getScale() == normalization2.getManual().getScale()) {
                    bl = true;
                } else if (null != normalization.getZScore() && null != normalization2.getZScore()) {
                    bl = true;
                } else if (null != normalization.getLinearScale() && null != normalization2.getLinearScale()) {
                    bl = true;
                } else if (null != normalization.getMinMax() && null != normalization2.getMinMax()) {
                    bl = true;
                }
            }
        } else if (null != transformationType.getCustomTransformation() && null != transformationType2.getCustomTransformation()) {
            TransformationType.CustomTransformation customTransformation = transformationType.getCustomTransformation();
            TransformationType.CustomTransformation customTransformation2 = transformationType2.getCustomTransformation();
            bl = customTransformation.getValue().equals(customTransformation2.getValue());
        }
        return bl;
    }

    public static String getTRANSFORMATION_TYPE_MISS_VALUES_NUMERIC_MEAN() {
        return TRANSFORMATION_TYPE_MISS_VALUES_NUMERIC_MEAN;
    }

    public static String getTRANSFORMATION_TYPE_MISS_VALUES_CATEGORIC_MODE() {
        return TRANSFORMATION_TYPE_MISS_VALUES_CATEGORIC_MODE;
    }

    public static String getTRANSFORMATION_TYPE_OUTLIER_ST_DEV() {
        return TRANSFORMATION_TYPE_OUTLIER_ST_DEV;
    }

    public static String getTRANSFORMATION_TYPE_OUTLIER_PERCENT() {
        return TRANSFORMATION_TYPE_OUTLIER_PERCENT;
    }

    public static String getTRANSFORMATION_TYPE_OUTLIER_VALUE() {
        return TRANSFORMATION_TYPE_OUTLIER_VALUE;
    }

    public static String getTRANSFORMATION_TYPE_OUTLIER_ST_DEV_ABBR() {
        return TRANSFORMATION_TYPE_OUTLIER_ST_DEV_ABBR;
    }

    public static String getTRANSFORMATION_TYPE_OUTLIER_PERCENT_ABBR() {
        return TRANSFORMATION_TYPE_OUTLIER_PERCENT_ABBR;
    }

    public static String getTRANSFORMATION_TYPE_OUTLIER_VALUE_ABBR() {
        return TRANSFORMATION_TYPE_OUTLIER_VALUE_ABBR;
    }

    public static String getTRANSFORMATION_TYPE_NORMALIZATION_MIN_MAX() {
        return TRANSFORMATION_TYPE_NORMALIZATION_MIN_MAX;
    }

    public static String getTRANSFORMATION_TYPE_NORMALIZATION_Z_SCORE() {
        return TRANSFORMATION_TYPE_NORMALIZATION_Z_SCORE;
    }

    public static String getTRANSFORMATION_TYPE_NORMALIZATION_MANUAL() {
        return TRANSFORMATION_TYPE_NORMALIZATION_MANUAL;
    }

    public static String getTRANSFORMATION_TYPE_NORMALIZATION_LINEAR_SCALE() {
        return TRANSFORMATION_TYPE_NORMALIZATION_LINEAR_SCALE;
    }

    static {
        _abbreviations.put(TRANSFORMATION_TYPE_BINNING, "BIN");
        _abbreviations.put(TRANSFORMATION_TYPE_CUSTOM, CUSTOM_ABBREVIATION);
        _abbreviations.put(TRANSFORMATION_TYPE_MISS_VALUES, "MIS");
        _abbreviations.put(TRANSFORMATION_TYPE_NORM, "NOR");
        _abbreviations.put(TRANSFORMATION_TYPE_OUTLIER, "OUT");
        _abbreviations.put(TRANSFORMATION_TYPE_EXISTNG_COLUMN, "EXS");
        _customXformsvalues = new String[]{TRANSFORMATION_TYPE_CUSTOM};
        _numericXformsvalues = new String[]{TRANSFORMATION_TYPE_BINNING, TRANSFORMATION_TYPE_MISS_VALUES, TRANSFORMATION_TYPE_NORM, TRANSFORMATION_TYPE_OUTLIER};
        _numericWizardXformsvalues = new String[]{TRANSFORMATION_TYPE_BINNING, TRANSFORMATION_TYPE_MISS_VALUES, TRANSFORMATION_TYPE_NORM, TRANSFORMATION_TYPE_OUTLIER};
        _categoricXformsvalues = new String[]{TRANSFORMATION_TYPE_BINNING, TRANSFORMATION_TYPE_MISS_VALUES};
        _categoricWizardXformsvalues = new String[]{TRANSFORMATION_TYPE_BINNING, TRANSFORMATION_TYPE_MISS_VALUES};
        _dateWizardXformsvalues = new String[]{TRANSFORMATION_TYPE_BINNING, TRANSFORMATION_TYPE_MISS_VALUES};
        _dateXformsvalues = new String[]{TRANSFORMATION_TYPE_BINNING, TRANSFORMATION_TYPE_MISS_VALUES};
        _binningNumericTypes = new String[]{TRANSFORMATION_TYPE_BINNING_EQW_NUMBER, TRANSFORMATION_TYPE_BINNING_QUANTILE, TRANSFORMATION_TYPE_CUSTOM};
        _binningNumericTypesNoCustom = new String[]{TRANSFORMATION_TYPE_BINNING_EQW_NUMBER, TRANSFORMATION_TYPE_BINNING_QUANTILE};
        _binningDateTypes = new String[]{TRANSFORMATION_TYPE_BINNING_EQW_DATE, TRANSFORMATION_TYPE_CUSTOM};
        _binningTimestampTZTypes = new String[]{TRANSFORMATION_TYPE_BINNING_TS_TZ, TRANSFORMATION_TYPE_CUSTOM};
        _binningDateTypesNoCustom = new String[]{TRANSFORMATION_TYPE_BINNING_EQW_DATE};
        _binningTimestampTimeZoneTypesNoCustom = new String[]{TRANSFORMATION_TYPE_BINNING_TS_TZ};
        _binningCategoricTypes = new String[]{TRANSFORMATION_TYPE_BINNING_TOPN, TRANSFORMATION_TYPE_CUSTOM};
        _binningCategoricTypesNoCustom = new String[]{TRANSFORMATION_TYPE_BINNING_TOPN};
        _missValuesNumericStats = new String[]{TRANSFORMATION_TYPE_MISS_VALUES_NUMERIC_MEAN, TRANSFORMATION_TYPE_MISS_VALUES_NUMERIC_MIN, TRANSFORMATION_TYPE_MISS_VALUES_NUMERIC_MAX};
        _missValuesCategoricStats = new String[]{TRANSFORMATION_TYPE_MISS_VALUES_CATEGORIC_MODE};
    }
}

