/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditorSupport;
import java.beans.VetoableChangeListener;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.controls.TableChooserModel;
import oracle.dmt.dataminer.controls.TableChooserPane;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.wizard.group.GroupLrb;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.inspect.AbstractNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyGroupImpl;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.inspector.IdePropertyModel;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.ExceptionDialog;

public class DataSourceNodePropertyModel
extends AbstractNodePropertyModel {
    private static int PROPERTY_START_INDEX = DataSourceNodePropertyModel.getInitialIndex();

    @Override
    protected int getRowIndexforNAME() {
        return RowIndex.NAME;
    }

    @Override
    protected int getRowIndexforCOMMENT() {
        return RowIndex.COMMENT;
    }

    public DataSourceNodePropertyModel(Context context) {
        super(context);
        Element[] elementArray = context.getSelection();
        if (elementArray != null && elementArray.length > 1) {
            return;
        }
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        List<Property> list = this.getRows();
        Property property = new Property("dataSourceTable", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_DS"), nodeType.getName(), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_DS_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.DATA_SOURCE_TABLE, property);
        property = new Property("dataSourceTableContentChanged", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_DS_CONTENT"), nodeType.getName(), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_DS_CONTENT_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.DATA_SOURCE_TABLE_CONTENTS, property);
        property = new Property("dataSourceTableAliasChange", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_DS_CONTENT_ALIAS"), nodeType.getName(), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_DS_CONTENT_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.DATA_SOURCE_TABLE_ALIAS_CHANGED, property);
        property = new Property("CACHE_SETTINGS", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_CACHE_SETTINGS"), nodeType.getName(), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_CACHE_SETTINGS_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.CACHE_SETTINGS, property);
        property = new Property("SQL_EXPRESSION", PropertyLrb.get("PI_SQL_EXPRESSION"), nodeType.getName(), PropertyLrb.get("PI_SQL_EXPRESSION_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.SQL_EXPRESSION, property);
        this.addCommonProperties(nodeType, list);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Property property = this.getRows().get(n);
        Object[] objectArray = this.getColumnMapping();
        Object object = null;
        if (n < 0 || n >= this.getRowCount() || n2 < 0 || n2 >= objectArray.length) {
            return PropertyModel.DOES_NOT_EXIST;
        }
        Object object2 = objectArray[n2];
        object = PropertyModel.COLUMN_ID.equals(object2) ? property.id : (PropertyModel.COLUMN_GROUP.equals(object2) ? property.group : (PropertyModel.COLUMN_DISPLAY_NAME.equals(object2) ? property.displayName : (PropertyModel.COLUMN_DISPLAY_VALUE.equals(object2) ? property.value : (PropertyModel.COLUMN_DESCRIPTION.equals(object2) ? property.description : (PropertyModel.COLUMN_NAME.equals(object2) ? property.id : (PropertyModel.COLUMN_VALUE.equals(object2) ? property.value : (PropertyModel.COLUMN_EDITOR_FACTORY_2.equals(object2) ? new AbstractNodePropertyModel.PropertyEditorFactory2(property, this.getContext()) : (PropertyModel.COLUMN_IS_WRITABLE.equals(object2) ? Boolean.valueOf(this.isCellEditable(n, n2)) : (PropertyModel.COLUMN_IS_HIDDEN.equals(object2) ? Boolean.valueOf(false) : (IdePropertyModel.COLUMN_HELP.equals(object2) ? "datasource_node_pi" : PropertyModel.DOES_NOT_EXIST))))))))));
        return object;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Object[] objectArray = this.getColumnMapping();
        Object object2 = objectArray[n2];
        List<Property> list = this.getRows();
        if (PropertyModel.COLUMN_ID.equals(object2)) {
            WorkflowNodeInspectorElement workflowNodeInspectorElement = this._workflowNodeInspectorElement;
            if (n == RowIndex.DATA_SOURCE_TABLE_CONTENTS || n == RowIndex.DATA_SOURCE_TABLE || n == RowIndex.DATA_SOURCE_TABLE_ALIAS_CHANGED || n == RowIndex.SQL_EXPRESSION || n == RowIndex.CACHE_SETTINGS) {
                ComplexProperty complexProperty = (ComplexProperty)object;
                list.get((int)n).value = complexProperty.getData();
                workflowNodeInspectorElement.updateNode(complexProperty);
            } else {
                super.setValueAt(object, n, n2);
            }
        } else {
            super.setValueAt(object, n, n2);
        }
    }

    static /* synthetic */ int access$008() {
        return PROPERTY_START_INDEX++;
    }

    class CustomEditor
    extends JPanel
    implements VetoableChangeListener {
        private AbstractNodePropertyModel.PropertyEditorFactory2 source;
        private TableChooserPane chooser;

        public CustomEditor(AbstractNodePropertyModel.PropertyEditorFactory2 propertyEditorFactory2) {
            this.source = propertyEditorFactory2;
            this.chooser = new TableChooserPane(DataSourceNodePropertyModel.this.getContext());
            this.chooser.initUI();
            this.add(this.chooser);
        }

        @Override
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("closed")) {
                TableChooserModel tableChooserModel = this.chooser.getModel();
                int n = this.chooser.getSelectedRow();
                TableChooserModel.TableRow tableRow = tableChooserModel.getRow(n);
                HashMap<String, AttributeType> hashMap = this.getTableColumns(tableRow.getSchema(), tableRow.getTableName());
                AbstractDataNode.TablePropertyValue tablePropertyValue = new AbstractDataNode.TablePropertyValue(tableRow.getSchema(), tableRow.getTableName(), hashMap);
                this.source.setValue(tablePropertyValue);
            }
        }

        private HashMap<String, AttributeType> getTableColumns(final String string, final String string2) {
            HashMap<String, AttributeType> hashMap = null;
            class Loader
            extends ProgressRunnable {
                private HashMap<String, AttributeType> _columns = new HashMap();

                Loader() {
                }

                public HashMap<String, AttributeType> getColumns() {
                    return this._columns;
                }

                protected Object doWork() throws Exception {
                    Connection connection = Connections.getSharedConnection(DataSourceNodePropertyModel.this.getContext());
                    Vector<Vector> vector = DatabaseMetadataUtils.getColumnDetails(connection, string, string2);
                    for (Vector vector2 : vector) {
                        AttributeType attributeType = new AttributeType();
                        attributeType.setName((String)vector2.get(0));
                        attributeType.setDataType((String)vector2.get(1));
                        this._columns.put(attributeType.getName(), attributeType);
                    }
                    return Boolean.TRUE;
                }
            }
            Loader loader = new Loader();
            loader.setTitle(GroupLrb.get("RETRIEVING_AVAILABLE_TABLES"));
            loader.setMessage(GroupLrb.get("RETRIEVING_AVAILABLE_TABLES_DETAILS"));
            try {
                loader.start(true);
                hashMap = loader.getColumns();
            }
            catch (ProgressException progressException) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)progressException, (String)"Application Error", (String)"Error getting table details", null);
            }
            return hashMap;
        }
    }

    class DataSourcePropertyEditor
    extends PropertyEditorSupport {
        public DataSourcePropertyEditor(Object object) {
            super(object);
        }

        @Override
        public Component getCustomEditor() {
            CustomEditor customEditor = new CustomEditor((AbstractNodePropertyModel.PropertyEditorFactory2)((Object)this.getSource()));
            return customEditor;
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }
    }

    protected static class Groups {
        public static final PropertyGroupImpl CUSTOM_BUILD = new PropertyGroupImpl(PreferencesLrb.get("PI_ATTRUBUTES_GROUP_TITLE"));

        protected Groups() {
        }
    }

    public static interface RowIndex {
        public static final int DATA_SOURCE_TABLE = DataSourceNodePropertyModel.access$008();
        public static final int DATA_SOURCE_TABLE_CONTENTS = DataSourceNodePropertyModel.access$008();
        public static final int DATA_SOURCE_TABLE_ALIAS_CHANGED = DataSourceNodePropertyModel.access$008();
        public static final int CACHE_SETTINGS = DataSourceNodePropertyModel.access$008();
        public static final int SQL_EXPRESSION = DataSourceNodePropertyModel.access$008();
        public static final int NAME = DataSourceNodePropertyModel.access$008();
        public static final int COMMENT = DataSourceNodePropertyModel.access$008();
    }
}

