/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.controls.DBObjectNameEditor;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.runner.RunManagerLrb;
import oracle.dmt.dataminer.utils.AttributeNameValidator;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceAttributesDialog;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceWizard;
import oracle.dmt.dataminer.workflow.inspect.DataSourceNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowDataSourceNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.DataSourceNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TableType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;

public class DataSourcePIComponentPanel
extends PIComponentPanel {
    private static final Logger theLogger = Logger.getLogger(DataSourcePIComponentPanel.class.getName());
    private static final int COLUMN_COUNT = 3;
    private static final int NAME = 0;
    private static final int ALIAS = 1;
    private static final int DATA_TYPE = 2;
    private String[] _columnNames = new String[]{PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_NAME_COLUMN"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_ALIAS_COLUMN"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_DATA_TYPE_COLUMN")};
    private DataMinerTable _jAttributesTable = new DataMinerTable();
    private Vector<AttributeType> _data = new Vector();
    private JButton _refreshBtn;
    private JButton _editBtn;
    private JButton _removeBtn;
    private SearchField _searchField;
    private Component _findPane;
    private static Icon _refreshIcon;
    private static Icon _editIcon;
    private WorkflowDataSourceNodePropertyProxyModel _model;
    public static final int FILTER_ATTRIBUTE_NAME = 0;
    public static final int FILTER_ATTRIBUTE_ALIAS = 1;
    public static final int FILTER_ATTRIBUTE_TYPE = 2;
    private int _currentSearchCategory = 0;
    private SearchCategory _defaultSearchCategory = new SearchCategory(PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_NAME_COLUMN"));
    private ComponentWithTitlebar<JComponent> jAttributesComponent;
    private JButton jButtonEditor;
    private JLabel jLabelTable;
    private JTextField jTextFieldTable;

    public DataSourcePIComponentPanel(PropertyModel propertyModel) {
        super(propertyModel);
        DataSourceNode dataSourceNode = (DataSourceNode)this.getTargetNode(propertyModel, DataSourceNodeType.class);
        if (dataSourceNode == null) {
            return;
        }
        DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)dataSourceNode.getData();
        List list = dataSourceNodeType.getAttributes().getAttribute();
        this._data.addAll(list);
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    private void initComponents() {
        this.jLabelTable = new JLabel();
        this.jTextFieldTable = new JTextField();
        this.jButtonEditor = new JButton();
        this.jAttributesComponent = new ComponentWithTitlebar();
        this.setPreferredSize(new Dimension(520, 200));
        this.jLabelTable.setText("Source Table:");
        this.jTextFieldTable.setEditable(false);
        this.jButtonEditor.setText("...");
        this.jAttributesComponent.setMinimumSize(new Dimension(500, 1000));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.jAttributesComponent, GroupLayout.Alignment.LEADING, -1, 500, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelTable, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldTable, -1, 388, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEditor, -2, 27, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(4, 4, 4).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelTable).addComponent(this.jButtonEditor).addComponent(this.jTextFieldTable, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jAttributesComponent, -2, 167, Short.MAX_VALUE)));
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLabelTable, (Component)this.jTextFieldTable, (String)PropertyLrb.get("PI_ATTRIBUTES_GROUP_SOURCE_TABLE"));
        if (_editIcon == null) {
            _editIcon = InspectorArb.getIcon((int)24);
            _refreshIcon = OracleIcons.getIcon((String)"refresh.png");
        }
    }

    public void initUI(final PropertyModel propertyModel) {
        Object object;
        this._jAttributesTable.setTooltipEnable(true);
        this._model = (WorkflowDataSourceNodePropertyProxyModel)propertyModel;
        Element[] elementArray = this.getContext(propertyModel).getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof DataSourceNodeType) {
            DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)nodeType;
            object = new AbstractDataNode.TablePropertyValue(dataSourceNodeType.getSourceTable().getSchema(), dataSourceNodeType.getSourceTable().getName());
            this.jTextFieldTable.setText(((AbstractDataNode.TablePropertyValue)object).toString());
        }
        boolean bl = this.isWritable();
        this.jButtonEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Context context = DataSourcePIComponentPanel.this.getContext(propertyModel);
                    DataSourceNode dataSourceNode = (DataSourceNode)DataSourcePIComponentPanel.this.getTargetNode(propertyModel, DataSourceNodeType.class);
                    DataSourceWizard dataSourceWizard = new DataSourceWizard();
                    dataSourceWizard.runWizard((Component)Ide.getMainWindow(), context, dataSourceNode);
                }
                catch (Exception exception) {
                    theLogger.log(Level.FINEST, exception.getMessage());
                }
            }
        });
        object = new AttributesTableModel(this._data);
        ((AttributesTableModel)((Object)object)).setWritable(bl);
        this.setupItemsTable((AttributesTableModel)((Object)object));
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this._jAttributesTable));
        this.jAttributesComponent.setComponent((JComponent)jScrollPane);
        this.jAttributesComponent.setLabel(new JLabel(PreferencesLrb.get("PI_ATTRUBUTES_GROUP_TITLE")));
        ControlBar controlBar = new ControlBar();
        this.installItemFilterActions(controlBar);
        this.jAttributesComponent.setControlBar(controlBar);
        this._jAttributesTable.setFillsViewportHeight(true);
        this.jButtonEditor.setEnabled(bl);
        this._editBtn.setEnabled(bl);
        this._removeBtn.setEnabled(bl);
    }

    protected Component createFindPane() {
        Box box = new Box(2);
        this._searchField = this.searchField();
        this.setupFilterCtl();
        box.setName("Find");
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        box.add((Component)this._searchField);
        Dimension dimension = box.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 250);
        Dimension dimension3 = this.derive(dimension, 120);
        box.setPreferredSize(dimension2);
        box.setMaximumSize(dimension2);
        box.setMinimumSize(dimension3);
        return box;
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    private SearchField searchField() {
        final SearchField searchField = new SearchField();
        searchField.setStyle(SearchField.Style.FILTER);
        searchField.setAutoFind(true);
        searchField.setPrompt(InspectorArb.getString((int)34));
        searchField.setNotifyOnEmptySearch(true);
        searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                DataSourcePIComponentPanel.this.translateSearchCategoryToConstant(searchField.getSelectedCategory());
                DataSourcePIComponentPanel.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                DataSourcePIComponentPanel.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
                DataSourcePIComponentPanel.this.processFilter(string);
            }
        });
        return searchField;
    }

    private void setupFilterCtl() {
        this._currentSearchCategory = 0;
        this._searchField.addCategory(this._defaultSearchCategory);
        this._searchField.addCategory(new SearchCategory(PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_ALIAS_COLUMN")));
        this._searchField.addCategory(new SearchCategory(PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_DATA_TYPE_COLUMN")));
        this._searchField.setSelectedCategory(this._defaultSearchCategory);
    }

    private void processFilter(String string) {
        try {
            AttributesTableModel attributesTableModel = (AttributesTableModel)((Object)this._jAttributesTable.getModel());
            if (attributesTableModel != null) {
                AttributesTableModel attributesTableModel2 = this.getFilteredAttributesTableModel(this._data, string, this._currentSearchCategory);
                this.setupItemsTable(attributesTableModel2);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)PropertyLrb.get("PI_ATTRIBUTES_GROUP_FAILURE_TITLE"), (String)PropertyLrb.get("PI_ATTRIBUTES_GROUP_FAILURE_MESSAGE"), null);
        }
    }

    private synchronized void translateSearchCategoryToConstant(SearchCategory searchCategory) {
        if (searchCategory.getLabel().equals(PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_NAME_COLUMN"))) {
            this._currentSearchCategory = 0;
        } else if (searchCategory.getLabel().equals(PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_ALIAS_COLUMN"))) {
            this._currentSearchCategory = 1;
        } else if (searchCategory.getLabel().equals(PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_DATA_TYPE_COLUMN"))) {
            this._currentSearchCategory = 2;
        } else assert (false) : "Invalid Search Category Code";
    }

    public void updateUI(PropertyModel propertyModel) {
        if (!(propertyModel instanceof WorkflowDataSourceNodePropertyProxyModel)) {
            return;
        }
        this._model = (WorkflowDataSourceNodePropertyProxyModel)propertyModel;
        DataSourceNode dataSourceNode = (DataSourceNode)this.getTargetNode(propertyModel, DataSourceNodeType.class);
        if (dataSourceNode == null) {
            return;
        }
        Element[] elementArray = this.getContext(propertyModel).getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof DataSourceNodeType) {
            DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)nodeType;
            AbstractDataNode.TablePropertyValue tablePropertyValue = new AbstractDataNode.TablePropertyValue(dataSourceNodeType.getSourceTable().getSchema(), dataSourceNodeType.getSourceTable().getName());
            this.jTextFieldTable.setText(tablePropertyValue.toString());
        }
        this.updateTable(dataSourceNode);
    }

    private void updateTable(DataSourceNode dataSourceNode) {
        int n;
        TableColumnModel tableColumnModel;
        Object object;
        int[] nArray = this._jAttributesTable.getSelectedRowsInModel();
        HashMap<String, TableColumnModel> hashMap = null;
        if (nArray != null && nArray.length > 0) {
            object = (AttributesTableModel)((Object)this._jAttributesTable.getModel());
            hashMap = new HashMap<String, TableColumnModel>(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                tableColumnModel = ((AttributesTableModel)((Object)object)).getDataVector().get(nArray[i]);
                hashMap.put(tableColumnModel.getName(), tableColumnModel);
            }
        }
        object = this._jAttributesTable.getVisibleRect();
        TableColumn tableColumn = null;
        tableColumnModel = this._jAttributesTable.getColumnModel();
        int n2 = tableColumnModel.getColumnCount();
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            tableColumn = tableColumnModel.getColumn(i);
            nArray2[i] = tableColumn.getPreferredWidth();
        }
        DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)dataSourceNode.getData();
        List list = dataSourceNodeType.getAttributes().getAttribute();
        this._data.clear();
        this._data.addAll(list);
        AttributesTableModel attributesTableModel = new AttributesTableModel(this._data);
        this.setupItemsTable(attributesTableModel);
        if (hashMap != null) {
            Object object2;
            Vector<Integer> vector = new Vector<Integer>();
            Vector<AttributeType> vector2 = attributesTableModel.getDataVector();
            for (int i = 0; i < vector2.size(); ++i) {
                object2 = vector2.get(i);
                if (null == hashMap.get(object2.getName())) continue;
                vector.add(i);
            }
            if (!vector.isEmpty()) {
                Integer[] integerArray = vector.toArray(new Integer[vector.size()]);
                object2 = new int[integerArray.length];
                for (int i = 0; i < integerArray.length; ++i) {
                    object2[i] = (AttributeType)integerArray[i];
                }
                this._jAttributesTable.setSelectedRowsInModel((int[])object2);
            }
        }
        if (!this._data.isEmpty()) {
            this._jAttributesTable.scrollRectToVisible((Rectangle)object);
        }
        if (n2 == (n = (tableColumnModel = this._jAttributesTable.getColumnModel()).getColumnCount())) {
            for (int i = 0; i < n; ++i) {
                tableColumn = tableColumnModel.getColumn(i);
                tableColumn.setPreferredWidth(nArray2[i]);
            }
        }
    }

    private void setupItemsTable(AttributesTableModel attributesTableModel) {
        this._jAttributesTable.setModel((TableModel)((Object)attributesTableModel));
        this._jAttributesTable.setSorted(true);
        this._jAttributesTable.setSortColumn(0, true);
        this._jAttributesTable.setAutoResizeMode(4);
        this._jAttributesTable.getSelectionModel().addListSelectionListener(new SelectedItemSelectionHandler());
        if (attributesTableModel.getRowCount() == 0) {
            return;
        }
        TableColumn tableColumn = this._jAttributesTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new CustomCellRenderer());
        DBObjectNameEditor dBObjectNameEditor = new DBObjectNameEditor(this.getContext((PropertyModel)this._model));
        TableColumn tableColumn2 = this._jAttributesTable.getColumnModel().getColumn(1);
        tableColumn2.setCellEditor(dBObjectNameEditor);
    }

    private void installItemFilterActions(ControlBar controlBar) {
        this._refreshBtn = new JButton(_refreshIcon);
        String string = RunManagerLrb.get("REFRESH_TIP");
        this._refreshBtn.setToolTipText(string);
        this._refreshBtn.getAccessibleContext().setAccessibleName(string);
        this._refreshBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Element[] elementArray = DataSourcePIComponentPanel.this.getContext((PropertyModel)DataSourcePIComponentPanel.this._model).getSelection();
                WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
                NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
                if (nodeType instanceof DataSourceNodeType) {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object42;
                    Object object5;
                    Object object6;
                    AttributeType attributeType2;
                    Attributes attributes = new Attributes();
                    List list = attributes.getAttribute();
                    for (AttributeType attributeType2 : DataSourcePIComponentPanel.this._data) {
                        object6 = new AttributeType();
                        AttributeTypeHelper.copyAttribute((AttributeType)object6, attributeType2);
                        list.add(object6);
                    }
                    DataSourceNode dataSourceNode = (DataSourceNode)DataSourcePIComponentPanel.this.getTargetNode((PropertyModel)DataSourcePIComponentPanel.this._model, DataSourceNodeType.class);
                    attributeType2 = (DataSourceNodeType)nodeType;
                    object6 = DataSourcePIComponentPanel.this.getAvailableAttributes((DataSourceNodeType)attributeType2);
                    if (object6 == null || object6.isEmpty()) {
                        object5 = attributeType2.getSourceTable();
                        object42 = object5.getSchema();
                        object3 = object5.getName();
                        object2 = MessageFormat.format(DataDialogsLrb.get("TABLE_VALIDATION_ERROR_MISSING"), (String)object42 + "." + (String)object3);
                        if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)object2, (String)DataDialogsLrb.get("TABLE_CHOOSER_FAILURE_TITLE"), null)) {
                            object = new DataSourceWizard();
                            ((DataSourceWizard)object).setTableExists(false);
                            if (((DataSourceWizard)object).runWizard((Component)Ide.getMainWindow(), DataSourcePIComponentPanel.this.getContext((PropertyModel)DataSourcePIComponentPanel.this._model), dataSourceNode)) {
                                return;
                            }
                        }
                        for (AttributeType attributeType3 : DataSourcePIComponentPanel.this._data) {
                            attributeType3.setStatus(AttributeStatus.MISSING);
                        }
                    } else {
                        for (Object object42 : DataSourcePIComponentPanel.this._data) {
                            object3 = (AttributeType)object6.get(object42.getName());
                            if (null == object3) {
                                object42.setStatus(AttributeStatus.MISSING);
                                continue;
                            }
                            object42.setStatus(object3.getStatus());
                        }
                    }
                    object5 = new Attributes();
                    object42 = object5.getAttribute();
                    object42.addAll(DataSourcePIComponentPanel.this._data);
                    object3 = new ArrayList();
                    object2 = new ComplexProperty("dataSourceAttributes", object5);
                    ((ComplexProperty)object2).setOldData(attributes);
                    object3.add(new Property(String.valueOf(DataSourceNodePropertyModel.RowIndex.DATA_SOURCE_TABLE_CONTENTS), null, object2, null, null));
                    object = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
                    ((ComplexProperty)object).setOldData(dataSourceNode.getSQLExpression());
                    object3.add(new Property(String.valueOf(DataSourceNodePropertyModel.RowIndex.SQL_EXPRESSION), null, object, null, null));
                    DataSourcePIComponentPanel.this._model.setValueAt(PropertyLrb.get("PI_DATA_SOURCE_NODE_ATTRIBUTES_REFRESHED"), dataSourceNode, (List<Property>)object3);
                }
            }
        });
        controlBar.add((Component)this._refreshBtn);
        this._editBtn = new JButton(_editIcon);
        string = InspectorArb.getString((int)25);
        this._editBtn.setToolTipText(string);
        this._editBtn.getAccessibleContext().setAccessibleName(InspectorArb.getString((int)23));
        this._editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Context context = DataSourcePIComponentPanel.this.getContext((PropertyModel)DataSourcePIComponentPanel.this._model);
                    DataSourceAttributesDialog dataSourceAttributesDialog = new DataSourceAttributesDialog();
                    dataSourceAttributesDialog.setCheckForUnderlyingTable(true);
                    DataSourceNode dataSourceNode = (DataSourceNode)DataSourcePIComponentPanel.this.getTargetNode((PropertyModel)DataSourcePIComponentPanel.this._model, DataSourceNodeType.class);
                    DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)dataSourceNode.getData();
                    if (!dataSourceAttributesDialog.invoke(context, dataSourceNode) && null != dataSourceAttributesDialog.getErrorMessage()) {
                        if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)dataSourceAttributesDialog.getErrorMessage(), (String)DataDialogsLrb.get("TABLE_CHOOSER_FAILURE_TITLE"), null)) {
                            DataSourceWizard dataSourceWizard = new DataSourceWizard();
                            dataSourceWizard.setTableExists(false);
                            dataSourceWizard.runWizard((Component)Ide.getMainWindow(), context, dataSourceNode);
                        } else {
                            dataSourceAttributesDialog = new DataSourceAttributesDialog();
                            dataSourceAttributesDialog.setCheckForUnderlyingTable(false);
                            dataSourceAttributesDialog.invoke(context, dataSourceNode);
                        }
                    }
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        });
        controlBar.add((Component)this._editBtn);
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = DataSourcePIComponentPanel.this._jAttributesTable.getSelectedRowsInModel();
                if (nArray.length > 0) {
                    AttributesTableModel attributesTableModel = (AttributesTableModel)((Object)DataSourcePIComponentPanel.this._jAttributesTable.getModel());
                    Vector<AttributeType> vector = new Vector<AttributeType>();
                    for (int i = 0; i < nArray.length; ++i) {
                        vector.add(attributesTableModel.getDataVector().get(nArray[i]));
                    }
                    DataSourceNode dataSourceNode = (DataSourceNode)DataSourcePIComponentPanel.this.getTargetNode((PropertyModel)DataSourcePIComponentPanel.this._model, DataSourceNodeType.class);
                    ArrayList<Property> arrayList = new ArrayList<Property>();
                    ComplexProperty complexProperty = new ComplexProperty("dataSourceTableContentRemoved", "dataSourceTableContentAdded", vector);
                    arrayList.add(new Property(String.valueOf(DataSourceNodePropertyModel.RowIndex.DATA_SOURCE_TABLE_CONTENTS), null, complexProperty, null, null));
                    ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
                    complexProperty2.setOldData(dataSourceNode.getSQLExpression());
                    arrayList.add(new Property(String.valueOf(DataSourceNodePropertyModel.RowIndex.SQL_EXPRESSION), null, complexProperty2, null, null));
                    DataSourcePIComponentPanel.this._model.setValueAt(PropertyLrb.get("PI_DATA_SOURCE_NODE_ATTRIBUTES_REMOVED"), dataSourceNode, arrayList);
                }
            }
        });
        controlBar.add((Component)this._removeBtn);
        ListSelectionModel listSelectionModel = this._jAttributesTable.getSelectionModel();
        this._removeBtn.setEnabled(!listSelectionModel.isSelectionEmpty() && this.isWritable());
        this._findPane = this.createFindPane();
        controlBar.addSeparator();
        controlBar.add(this._findPane);
    }

    public AttributesTableModel getFilteredAttributesTableModel(Vector<AttributeType> vector, String string, int n) throws Exception {
        Vector<AttributeType> vector2 = new Vector<AttributeType>();
        SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
        Object object = vector.iterator();
        AttributeType attributeType = null;
        boolean bl = string.length() <= 0;
        boolean bl2 = false;
        while (object.hasNext()) {
            attributeType = object.next();
            if (bl) {
                bl2 = true;
            } else {
                String string2 = "";
                switch (n) {
                    case 0: {
                        string2 = attributeType.getName();
                        break;
                    }
                    case 1: {
                        string2 = attributeType.getAlias();
                        break;
                    }
                    case 2: {
                        string2 = attributeType.getDataType();
                        break;
                    }
                    default: {
                        assert (false) : "Invalid item filter category.";
                        string2 = null;
                    }
                }
                bl2 = string2 == null ? false : searchMatcher.matches((CharSequence)string2);
            }
            if (!bl2) continue;
            vector2.add(attributeType);
        }
        object = new AttributesTableModel(vector2);
        ((AttributesTableModel)((Object)object)).setWritable(this.isWritable());
        return object;
    }

    protected Map<String, AttributeType> getAvailableAttributes(DataSourceNodeType dataSourceNodeType) {
        TableType tableType = dataSourceNodeType.getSourceTable();
        String string = tableType.getSchema();
        String string2 = tableType.getName();
        return this.getAvailableAttributes(string, string2);
    }

    class AttributesTableModel
    extends GenericBaseTableModel {
        private Vector<AttributeType> _srcData;
        private boolean writable;

        AttributesTableModel(Vector<AttributeType> vector) {
            this._srcData = new Vector(vector.size());
            for (AttributeType attributeType : vector) {
                AttributeType attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType);
                this._srcData.add(attributeType2);
            }
            this.writable = true;
            this.setColumnIdentifiers(DataSourcePIComponentPanel.this._columnNames);
            this.setRowCount(this._srcData.size());
            this.setColumnCount(3);
        }

        AttributesTableModel(List<AttributeType> list) {
            this._srcData = new Vector(list.size());
            for (AttributeType attributeType : list) {
                AttributeType attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType);
                this._srcData.add(attributeType2);
            }
            this.writable = true;
            this.setColumnIdentifiers(DataSourcePIComponentPanel.this._columnNames);
            this.setRowCount(this._srcData.size());
            this.setColumnCount(3);
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.size() : 0;
        }

        public Vector<AttributeType> getDataVector() {
            return this._srcData;
        }

        public void clearRows() {
            this._srcData.clear();
            this.setRowCount(0);
            this.fireTableDataChanged();
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 != 1) {
                return;
            }
            DataSourceNode dataSourceNode = (DataSourceNode)DataSourcePIComponentPanel.this.getTargetNode((PropertyModel)DataSourcePIComponentPanel.this._model, DataSourceNodeType.class);
            if (dataSourceNode == null) {
                return;
            }
            if (this._srcData.isEmpty()) {
                return;
            }
            AttributeType attributeType = this._srcData.get(n);
            Vector<AttributeType> vector = new Vector<AttributeType>();
            vector.addAll(this._srcData);
            vector.remove(attributeType);
            String string = attributeType.getName();
            String string2 = null;
            String string3 = attributeType.getAlias();
            if (object != null) {
                string2 = ((String)object).trim();
            }
            if (string3 != null && StringUtils.isDoubleQuotedString(string2)) {
                string3 = StringUtils.addDoubleQuotes(string3);
            }
            if (string2.length() != 0) {
                if (!StringUtils.isDoubleQuotedString(string2)) {
                    string2 = string2.toUpperCase();
                }
                if (string3 != null && string3.compareTo(string2) == 0) {
                    return;
                }
                if (!AttributeNameValidator.validateAttributeName(string2, vector, DataSourcePIComponentPanel.this.getContext((PropertyModel)DataSourcePIComponentPanel.this._model), true)) {
                    return;
                }
            } else if (string3 != null && string3.length() != 0 && !AttributeNameValidator.validateAttributeName(string, vector, DataSourcePIComponentPanel.this.getContext((PropertyModel)DataSourcePIComponentPanel.this._model), true)) {
                return;
            }
            if (string3 != null && string3.compareTo(string2) == 0) {
                return;
            }
            string2 = StringUtils.trimDoubleQuotes(string2);
            attributeType.setAlias(string2);
            DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)dataSourceNode.getData();
            List list = dataSourceNodeType.getAttributes().getAttribute();
            AttributeType attributeType2 = null;
            AttributeType attributeType3 = null;
            for (Object object2 : list) {
                if (!object2.getName().equals(attributeType.getName()) || !object2.getDataType().equals(attributeType.getDataType())) continue;
                attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(object2);
                attributeType3 = (AttributeType)MetaDataHelper.copyMetadataObject(object2);
                attributeType2.setAlias(string2);
                break;
            }
            if (attributeType2 != null) {
                Object object2;
                ArrayList arrayList = new ArrayList();
                object2 = new ComplexProperty("dataSourceTableAliasChange", attributeType2);
                ((ComplexProperty)object2).setOldData(attributeType3);
                arrayList.add(new Property(String.valueOf(DataSourceNodePropertyModel.RowIndex.DATA_SOURCE_TABLE_ALIAS_CHANGED), null, object2, null, null));
                ComplexProperty complexProperty = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
                complexProperty.setOldData(dataSourceNode.getSQLExpression());
                arrayList.add(new Property(String.valueOf(DataSourceNodePropertyModel.RowIndex.SQL_EXPRESSION), null, complexProperty, null, null));
                DataSourcePIComponentPanel.this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_DS_CONTENT_ALIAS"), dataSourceNode, arrayList);
            }
        }

        public Object getValueAt(int n, int n2) {
            if (this.getRowCount() == 0) {
                return null;
            }
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            AttributeType attributeType = this._srcData.get(n);
            String string = null;
            switch (n2) {
                case 0: {
                    string = attributeType.getName();
                    break;
                }
                case 1: {
                    string = attributeType.getAlias();
                    break;
                }
                case 2: {
                    string = attributeType.getDataType();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column when accessing items";
                    break;
                }
            }
            return string != null ? string : "";
        }

        public void removeSelectedRows(int[] nArray) {
            Vector<AttributeType> vector = new Vector<AttributeType>();
            AttributeType attributeType = null;
            for (int i = 0; i < nArray.length; ++i) {
                attributeType = this._srcData.elementAt(nArray[i]);
                vector.add(attributeType);
            }
            this._srcData.removeAll(vector);
            this.setRowCount(this._srcData.size());
            this.fireTableDataChanged();
        }

        public TableModel getModel() {
            return this;
        }

        public void setWritable(boolean bl) {
            this.writable = bl;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 1) {
                return this.writable;
            }
            return false;
        }
    }

    class SelectedItemSelectionHandler
    implements ListSelectionListener {
        SelectedItemSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            DataSourcePIComponentPanel.this._removeBtn.setEnabled(!listSelectionModel.isSelectionEmpty() && DataSourcePIComponentPanel.this.isWritable());
        }
    }

    private class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            boolean bl3 = false;
            DataSourceNode dataSourceNode = (DataSourceNode)DataSourcePIComponentPanel.this.getTargetNode((PropertyModel)DataSourcePIComponentPanel.this._model, DataSourceNodeType.class);
            DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)dataSourceNode.getData();
            List list = dataSourceNodeType.getAttributes().getAttribute();
            if (!list.isEmpty()) {
                GenericTable genericTable = (GenericTable)jTable;
                int n3 = genericTable.convertRowIndexToModel(n);
                AttributesTableModel attributesTableModel = (AttributesTableModel)((Object)DataSourcePIComponentPanel.this._jAttributesTable.getModel());
                AttributeType attributeType = attributesTableModel.getDataVector().get(n3);
                if (attributeType.getStatus() == AttributeStatus.VALID) {
                    bl3 = true;
                }
                this.setIcon(bl3 ? DataMinerIcons.get(Icons.ATTRIBUTE) : DataMinerIcons.get(Icons.WARNING_STATUS));
                this.setIcon(bl3 ? null : DataMinerIcons.get(Icons.WARNING_STATUS));
            }
            return component;
        }
    }
}

