/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.util.HashMap;
import java.util.List;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.inspect.AbstractNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyGroupImpl;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseBuildNodeType;
import oracle.ide.Context;
import oracle.ide.inspector.IdePropertyModel;
import oracle.ide.model.Element;
import oracle.javatools.util.Pair;

public class ModelBuildNodePropertyModel
extends AbstractNodePropertyModel {
    private static int PROPERTY_START_INDEX = ModelBuildNodePropertyModel.getInitialIndex();

    @Override
    protected int getRowIndexforNAME() {
        return RowIndex.NAME;
    }

    @Override
    protected int getRowIndexforCOMMENT() {
        return RowIndex.COMMENT;
    }

    public ModelBuildNodePropertyModel(Context context) {
        super(context);
        Element[] elementArray = context.getSelection();
        if (elementArray != null && elementArray.length > 1) {
            return;
        }
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        List<Property> list = this.getRows();
        Property property = new Property("targetAttribute", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_TARGET"), nodeType.getName(), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_TARGET_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.TARGET, property);
        property = new Property("modelAddedorRemoved", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_VIEW_PROPERTY_MODEL"), nodeType.getName(), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_VIEW_PROPERTY_MODEL_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.MODEL_ADDED_REMOVED, property);
        property = new Property("tuningChanged", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE"), nodeType.getName(), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.TUNING, property);
        property = new Property("algTreeSettings", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_ALGORITHM"), nodeType.getName(), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_ALGORITHM_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.ALGORITHM_SETTINGS, property);
        property = new Property("splitValueChanged", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TEST_SPLIT"), nodeType.getName(), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TEST_SPLIT_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.SPLIT_VALUE, property);
        property = new Property("splitDataFormat", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TEST_SPLIT_FORMAT"), nodeType.getName(), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TEST_SPLIT_FORMAT_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.SPLIT_DATA_FORMAT, property);
        property = new Property("genAccuracyMetrics", PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_ACCURACY_METRICS"), nodeType.getName(), PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_ACCURACY_METRICS_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.GEN_ACCURACY_METRICS, property);
        property = new Property("genConfusionMatrix", PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_CONFUSION_MATRIX"), nodeType.getName(), PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_CONFUSION_MATRIX_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.GEN_CONFUSION_MATRIX, property);
        property = new Property("genROC", PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_ROC_CURVE"), nodeType.getName(), PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_ROC_CURVE_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.GEN_ROC_CURVE, property);
        property = new Property("genLiftProfit", PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_LIFT_AND_PROFIT"), nodeType.getName(), PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_LIFT_AND_PROFIT_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.GEN_LIFT_AND_PROFIT, property);
        property = new Property("genTuning", PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_TUNING"), nodeType.getName(), PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_TUNING_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.GEN_FOR_TUNING, property);
        property = new Property("caseAttributes", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_CASE_ID"), nodeType.getName(), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_CASE_ID_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.CASE_IDS, property);
        property = new Property("testOptionsChanged", PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_OPTIONS_CHANGED"), nodeType.getName(), PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_OPTIONS_CHANGED_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.TEST_OPTIONS_CHANGED, property);
        property = new Property("testSettingsChanged", PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_SETTINGS_CHANGED"), nodeType.getName(), PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_SETTINGS_CHANGED_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.TEST_SETTINGS_CHANGED, property);
        property = new Property("modelsRerun", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_BUILD"), nodeType.getName(), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_BUILD"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.MODELS_RERUN, property);
        property = new Property("testsRerun", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_TEST"), nodeType.getName(), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_TEST"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.TESTS_RERUN, property);
        property = new Property("testsRemoved", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_TEST"), nodeType.getName(), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_TEST"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.TESTS_ADDED_REMOVED, property);
        property = new Property("testsForTuningRemoved", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_TEST"), nodeType.getName(), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_TEST"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.TESTS_FOR_TUNING_ADDED_REMOVED, property);
        property = new Property("costBenefit", PropertyLrb.get("PI_CLASS_BUILD_GROUP_TUNE_OPTIONS_CHANGED"), nodeType.getName(), PropertyLrb.get("PI_CLASS_BUILD_GROUP_TUNE_OPTIONS_CHANGED_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.COST_BENEFIT, property);
        property = new Property("modelAnnotation", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ANNOTATION"), nodeType.getName(), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ANNOTATION_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.MODEL_ANNOTATION, property);
        property = new Property("modelName", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NAME"), nodeType.getName(), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NAME_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.MODEL_NAME, property);
        property = new Property("modelUseForOutput", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_USEFOR_OUTPUT"), nodeType.getName(), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_USEFOR_OUTPUT_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.MODEL_USEFOROUTPUT, property);
        property = new Property("miningAttributeSettings", PropertyLrb.get("PI_BUILD_GROUP_BUILD_ATTRIBUTE_USAGE"), nodeType.getName(), PropertyLrb.get("PI_BUILD_GROUP_BUILD_ATTRIBUTE_USAGE_DESCRIPTION"), Groups.CUSTOM_BUILD);
        list.add(RowIndex.MINING_ATTRIBUTE_SETTINGS, property);
        this.addCommonProperties(nodeType, list);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Property property = this.getRows().get(n);
        Object[] objectArray = this.getColumnMapping();
        Object object = null;
        if (n < 0 || n >= this.getRowCount() || n2 < 0 || n2 >= objectArray.length) {
            return PropertyModel.DOES_NOT_EXIST;
        }
        Object object2 = objectArray[n2];
        object = PropertyModel.COLUMN_ID.equals(object2) ? property.id : (PropertyModel.COLUMN_GROUP.equals(object2) ? property.group : (PropertyModel.COLUMN_DISPLAY_NAME.equals(object2) ? property.displayName : (PropertyModel.COLUMN_DISPLAY_VALUE.equals(object2) ? property.value : (PropertyModel.COLUMN_DESCRIPTION.equals(object2) ? property.description : (PropertyModel.COLUMN_NAME.equals(object2) ? property.id : (PropertyModel.COLUMN_VALUE.equals(object2) ? property.value : (PropertyModel.COLUMN_EDITOR_FACTORY_2.equals(object2) ? new AbstractNodePropertyModel.PropertyEditorFactory2(property, this.getContext()) : (PropertyModel.COLUMN_IS_WRITABLE.equals(object2) ? Boolean.valueOf(this.isCellEditable(n, n2)) : (PropertyModel.COLUMN_IS_HIDDEN.equals(object2) ? Boolean.valueOf(false) : (IdePropertyModel.COLUMN_HELP.equals(object2) ? "classification_build_node_pi" : PropertyModel.DOES_NOT_EXIST))))))))));
        return object;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Object[] objectArray = this.getColumnMapping();
        Object object2 = objectArray[n2];
        List<Property> list = this.getRows();
        if (PropertyModel.COLUMN_ID.equals(object2)) {
            WorkflowNodeInspectorElement workflowNodeInspectorElement = this._workflowNodeInspectorElement;
            if (n == RowIndex.TARGET || n == RowIndex.MINING_ATTRIBUTE_SETTINGS || n == RowIndex.MODEL_ADDED_REMOVED || n == RowIndex.TUNING || n == RowIndex.ALGORITHM_SETTINGS || n == RowIndex.MODELS_RERUN || n == RowIndex.TESTS_RERUN || n == RowIndex.TESTS_ADDED_REMOVED || n == RowIndex.TESTS_FOR_TUNING_ADDED_REMOVED || n == RowIndex.MODEL_ANNOTATION || n == RowIndex.COST_BENEFIT || n == RowIndex.TEST_SETTINGS_CHANGED || n == RowIndex.MODEL_NAME || n == RowIndex.SPLIT_VALUE || n == RowIndex.MODEL_USEFOROUTPUT || n == RowIndex.SPLIT_DATA_FORMAT || n == RowIndex.GEN_ACCURACY_METRICS || n == RowIndex.GEN_CONFUSION_MATRIX || n == RowIndex.GEN_ROC_CURVE || n == RowIndex.GEN_LIFT_AND_PROFIT || n == RowIndex.GEN_FOR_TUNING || n == RowIndex.TEST_OPTIONS_CHANGED || n == RowIndex.CASE_IDS) {
                ComplexProperty complexProperty = (ComplexProperty)object;
                list.get((int)n).value = object;
                workflowNodeInspectorElement.updateNode(complexProperty);
            } else {
                super.setValueAt(object, n, n2);
            }
        } else {
            super.setValueAt(object, n, n2);
        }
    }

    public static void updateTargetModelAttributes(SuperviseBuildNodeType superviseBuildNodeType, List<Property> list, int n, AttributeType attributeType) {
        MiningAttributeType miningAttributeType;
        AttributeType attributeType2 = superviseBuildNodeType.getTargetAttribute();
        MiningAttributeType miningAttributeType2 = miningAttributeType = attributeType2 != null ? MetaDataHelper.createMiningAttributeFrom(attributeType2) : null;
        if (miningAttributeType != null) {
            miningAttributeType.setInput("Yes");
            miningAttributeType.setAutoPrep("Yes");
        }
        List<ModelType> list2 = MetaDataHelper.getModelsCollection((BuildNodeType)superviseBuildNodeType);
        HashMap<String, MiningAttributeType> hashMap = new HashMap<String, MiningAttributeType>();
        HashMap<String, ComplexProperty> hashMap2 = new HashMap<String, ComplexProperty>();
        for (ModelType modelType : list2) {
            Object object;
            ComplexProperty complexProperty;
            MiningAttributeType miningAttributeType3;
            if (miningAttributeType != null) {
                miningAttributeType3 = new Pair((Object)miningAttributeType.getName(), (Object)miningAttributeType);
                hashMap.put(modelType.getId(), miningAttributeType3);
                complexProperty = new ComplexProperty("miningAttributeSettings", hashMap);
                object = new Property(String.valueOf(n), null, complexProperty, null, null);
                list.add((Property)object);
            }
            miningAttributeType3 = MetaDataHelper.createMiningAttributeFrom(attributeType);
            if (superviseBuildNodeType instanceof RegressionBuildNodeType && modelType instanceof RSupportVectorMachineModelType || superviseBuildNodeType instanceof ClassificationBuildNodeType) {
                miningAttributeType3.setAutoPrep("Yes");
            } else {
                miningAttributeType3.setAutoPrep("No");
            }
            miningAttributeType3.setInput("Yes");
            complexProperty = new Pair((Object)miningAttributeType3.getName(), (Object)miningAttributeType3);
            hashMap2.put(modelType.getId(), complexProperty);
            object = new ComplexProperty("miningAttributeSettings", hashMap2);
            Property property = new Property(String.valueOf(n), null, object, null, null);
            list.add(property);
        }
    }

    public static void updateCaseIdModelAttributes(BuildNodeType buildNodeType, List<Property> list, int n, CaseAttributes caseAttributes) {
        MiningAttributeType miningAttributeType;
        AttributeType attributeType = MetaDataHelper.getCaseId(buildNodeType);
        MiningAttributeType miningAttributeType2 = miningAttributeType = attributeType != null ? MetaDataHelper.createMiningAttributeFrom(attributeType) : null;
        if (miningAttributeType != null) {
            miningAttributeType.setInput("Yes");
            miningAttributeType.setAutoPrep("Yes");
        }
        List<ModelType> list2 = MetaDataHelper.getModelsCollection(buildNodeType);
        HashMap<String, Pair> hashMap = new HashMap<String, Pair>();
        HashMap<String, Pair> hashMap2 = new HashMap<String, Pair>();
        for (ModelType modelType : list2) {
            Object object;
            Object object2;
            Pair pair;
            if (miningAttributeType != null) {
                pair = new Pair((Object)miningAttributeType.getName(), (Object)miningAttributeType);
                hashMap.put(modelType.getId(), pair);
                object2 = new ComplexProperty("miningAttributeSettings", hashMap);
                object = new Property(String.valueOf(n), null, object2, null, null);
                list.add((Property)object);
            }
            if (caseAttributes.getAttribute().size() <= 0) continue;
            pair = (AttributeType)caseAttributes.getAttribute().get(0);
            object2 = MetaDataHelper.createMiningAttributeFrom((AttributeType)pair);
            object2.setAutoPrep("No");
            object2.setInput("No");
            object = new Pair((Object)object2.getName(), object2);
            hashMap2.put(modelType.getId(), (Pair)object);
            ComplexProperty complexProperty = new ComplexProperty("miningAttributeSettings", hashMap2);
            Property property = new Property(String.valueOf(n), null, complexProperty, null, null);
            list.add(property);
        }
    }

    static /* synthetic */ int access$008() {
        return PROPERTY_START_INDEX++;
    }

    protected static class Groups {
        public static final PropertyGroupImpl CUSTOM_BUILD = new PropertyGroupImpl(PreferencesLrb.get("PI_BUILD_NODE_GROUP_BUILD_TITLE"));

        protected Groups() {
        }
    }

    static interface RowIndex {
        public static final int TARGET = ModelBuildNodePropertyModel.access$008();
        public static final int MODEL_ADDED_REMOVED = ModelBuildNodePropertyModel.access$008();
        public static final int TUNING = ModelBuildNodePropertyModel.access$008();
        public static final int ALGORITHM_SETTINGS = ModelBuildNodePropertyModel.access$008();
        public static final int SPLIT_VALUE = ModelBuildNodePropertyModel.access$008();
        public static final int SPLIT_DATA_FORMAT = ModelBuildNodePropertyModel.access$008();
        public static final int GEN_ACCURACY_METRICS = ModelBuildNodePropertyModel.access$008();
        public static final int GEN_CONFUSION_MATRIX = ModelBuildNodePropertyModel.access$008();
        public static final int GEN_ROC_CURVE = ModelBuildNodePropertyModel.access$008();
        public static final int GEN_LIFT_AND_PROFIT = ModelBuildNodePropertyModel.access$008();
        public static final int GEN_FOR_TUNING = ModelBuildNodePropertyModel.access$008();
        public static final int CASE_IDS = ModelBuildNodePropertyModel.access$008();
        public static final int TEST_OPTIONS_CHANGED = ModelBuildNodePropertyModel.access$008();
        public static final int TEST_SETTINGS_CHANGED = ModelBuildNodePropertyModel.access$008();
        public static final int MODELS_RERUN = ModelBuildNodePropertyModel.access$008();
        public static final int TESTS_RERUN = ModelBuildNodePropertyModel.access$008();
        public static final int TESTS_ADDED_REMOVED = ModelBuildNodePropertyModel.access$008();
        public static final int TESTS_FOR_TUNING_ADDED_REMOVED = ModelBuildNodePropertyModel.access$008();
        public static final int COST_BENEFIT = ModelBuildNodePropertyModel.access$008();
        public static final int MODEL_ANNOTATION = ModelBuildNodePropertyModel.access$008();
        public static final int MODEL_NAME = ModelBuildNodePropertyModel.access$008();
        public static final int MODEL_USEFOROUTPUT = ModelBuildNodePropertyModel.access$008();
        public static final int MINING_ATTRIBUTE_SETTINGS = ModelBuildNodePropertyModel.access$008();
        public static final int NAME = ModelBuildNodePropertyModel.access$008();
        public static final int COMMENT = ModelBuildNodePropertyModel.access$008();
    }
}

