/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.OutputAttributeType;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.mviewer.coefficients.LoadSVMModelViewer;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNodeUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.server.model.MiningAlgorithmOptions;
import oracle.dmt.dataminer.server.model.MiningDetailsOutputType;
import oracle.dmt.dataminer.server.model.MiningFunctions;
import oracle.dmt.dataminer.server.model.ModelDetailsExtract;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.AvailableRefModelType;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.EditModelDetailsAutoDialog;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.ModelDetailsLrb;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.ModelsTableModel;
import oracle.dmt.dataminer.workflow.inspect.ModelDetailsNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowModelDetailsNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ModelDetailsDataNode;
import oracle.dmt.dataminer.workflow.model.ModelProvider;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailsDataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailsOutputType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelInfoType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.editor.EditorUtil;
import oracle.ide.inspector.PropertyLabel;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.nulls.NullIcon;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.util.Version;

public class ModelDetailsPIComponentModelsPanel
extends PIComponentPanel {
    private static final Logger theLogger = Logger.getLogger(ModelDetailsPIComponentModelsPanel.class.getName());
    private PropertyModel _model;
    private Component _findPane;
    private static NullIcon _nullIcon;
    private SearchField _searchField;
    private JButton _removeBtn;
    private JButton _addBtn;
    private JButton _viewBtn;
    private final String UNDEFINED = ModelDetailsLrb.get("UNDEFINED_SELECTION");
    private Connection _dbConn;
    private String _ownerName;
    private ModelDetailsOutputType _modelOutputType;
    private List<RefModelType> _models;
    private ModelDetailType _modelDetailType;
    MiningDetailsOutputType _currentOutputType;
    MiningFunctions _currentFunction;
    MiningAlgorithmOptions _currentAlgorithm;
    private List<OutputAttributeType> _currentOutputColumns;
    private int _currentSearchCategory = 1;
    private GenericTable _jModelsTable = new DataMinerTable();
    private ModelsTableModel _modelsTblModel;
    private SearchCategory _defaultSearchCategory = new SearchCategory(PropertyLrb.get("PI_MODEL_DETAILS_MODEL_COLUMN_MODEL"));
    private boolean _automaticSetting = false;
    private Version dbVersion = null;
    private ComponentWithTitlebar<JComponent> ModelsComponentWithTitlebar;
    private JCheckBox jAutomaticSettingChkBox;
    private PropertyLabel jModelFunctionLabel;
    private JLabel jModelFunctionValue;
    private PropertyLabel jModelTypeLabel;
    private PropertyLabel jModelTypeValue;
    private JComboBox jOutputTypeCombo;
    private PropertyLabel jOutputTypeLabel;

    public ModelDetailsPIComponentModelsPanel(PropertyModel propertyModel) {
        super(propertyModel);
        assert (propertyModel != null) : "PropertyModel for  node is null.";
        ModelDetailsDataNode modelDetailsDataNode = this.getTargetNode(propertyModel);
        assert (modelDetailsDataNode != null) : "Model details node is null.";
        if (modelDetailsDataNode == null) {
            return;
        }
        try {
            Context context = this.getContext(propertyModel);
            this.dbVersion = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    private void initComponents() {
        this.jOutputTypeCombo = new JComboBox();
        this.ModelsComponentWithTitlebar = new ComponentWithTitlebar();
        this.jModelFunctionValue = new JLabel();
        this.jModelFunctionLabel = new PropertyLabel();
        this.jModelTypeLabel = new PropertyLabel();
        this.jOutputTypeLabel = new PropertyLabel();
        this.jModelTypeValue = new PropertyLabel();
        this.jAutomaticSettingChkBox = new JCheckBox();
        this.jOutputTypeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Full Tree", "Item 2", "Item 3", "Item 4"}));
        this.jModelFunctionValue.setText("Undefined");
        this.jModelFunctionLabel.setText("Function:");
        this.jModelTypeLabel.setText("Algorithm:");
        this.jOutputTypeLabel.setText("Output:");
        this.jModelTypeValue.setText("Undefined");
        this.jModelTypeValue.setPreferredSize(new Dimension(34, 14));
        this.jAutomaticSettingChkBox.setText("Automatic Settings");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent((Component)this.jOutputTypeLabel, -1, -1, Short.MAX_VALUE).addComponent((Component)this.jModelFunctionLabel, -2, 89, -2)).addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jOutputTypeCombo, -2, 169, -2).addGroup(groupLayout.createSequentialGroup().addComponent(this.jModelFunctionValue, -2, 169, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jModelTypeLabel, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.jModelTypeValue, -1, 146, Short.MAX_VALUE))).addGap(51, 51, 51)).addComponent((Component)this.ModelsComponentWithTitlebar, -1, -1, Short.MAX_VALUE).addComponent(this.jAutomaticSettingChkBox, -1, 581, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.linkSize(0, this.jModelFunctionValue, this.jOutputTypeCombo);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.jAutomaticSettingChkBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.jModelTypeLabel, -1, -1, Short.MAX_VALUE).addComponent((Component)this.jModelTypeValue, -2, -1, -2)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jModelFunctionValue, -1, -1, Short.MAX_VALUE).addComponent((Component)this.jModelFunctionLabel, -2, 20, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jOutputTypeCombo, -2, -1, -2).addComponent((Component)this.jOutputTypeLabel, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.ModelsComponentWithTitlebar, -1, 189, Short.MAX_VALUE)));
        groupLayout.linkSize(1, new Component[]{this.jModelFunctionLabel, this.jModelFunctionValue, this.jModelTypeLabel, this.jModelTypeValue, this.jOutputTypeCombo});
    }

    public void initRes() {
        if (_nullIcon == null) {
            _nullIcon = new NullIcon(DataMinerIcons.get(Icons.PI_BUILD_GROUP_MODEL_BUILT).getIconWidth(), DataMinerIcons.get(Icons.PI_BUILD_GROUP_MODEL_BUILT).getIconHeight());
        }
        ResourceUtils.resLabel((JLabel)this.jModelFunctionLabel, (Component)this.jModelFunctionValue, (String)PropertyLrb.get("PI_MODEL_DETAILS_GROUP_MODEL_TYPE_NO_MNEMONIC"));
        this.jModelFunctionValue.setText(this.UNDEFINED);
        ResourceUtils.resLabel((JLabel)this.jModelTypeLabel, (Component)this.jModelTypeValue, (String)PropertyLrb.get("PI_MODEL_DETAILS_MODEL_ALGORITHM"));
        this.jModelTypeValue.setText(this.UNDEFINED);
        ResourceUtils.resLabel((JLabel)this.jOutputTypeLabel, (Component)this.jOutputTypeCombo, (String)PropertyLrb.get("PI_MODEL_DETAILS_GROUP_OUTPUT_TYPE"));
        this.jOutputTypeCombo.getAccessibleContext().setAccessibleDescription(PropertyLrb.get("PI_MODEL_DETAILS_GROUP_OUTPUT_TYPE_ADA"));
        this.jOutputTypeCombo.setToolTipText(PropertyLrb.get("PI_MODEL_DETAILS_GROUP_OUTPUT_TYPE_ADA"));
        this.jOutputTypeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{this.UNDEFINED}));
        this.jOutputTypeCombo.setVisible(false);
        this.jOutputTypeLabel.setVisible(false);
        this.jAutomaticSettingChkBox.setText(PropertyLrb.get("PI_MODEL_DETAILS_AUTO_SETTING"));
    }

    public void initUI(PropertyModel propertyModel) {
        this._model = propertyModel;
        ModelDetailsDataNode modelDetailsDataNode = this.getTargetNode(propertyModel);
        if (modelDetailsDataNode == null) {
            return;
        }
        boolean bl = this.isWritable();
        this.jAutomaticSettingChkBox.setEnabled(bl);
        try {
            this._dbConn = Connections.getSharedConnection(this.getContext(this._model));
            this._ownerName = Connections.getUserAccountName(this.getContext(this._model));
            this._ownerName = StringUtils.isDoubleQuotedString(this._ownerName) ? StringUtils.trimDoubleQuotes(this._ownerName) : this._ownerName.toUpperCase();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)PropertyLrb.get("PI_MODEL_DETAILS_MODEL_PI_ERROR_TITLE"), (String)PropertyLrb.get("PI_MODEL_DETAILS_MODEL_PI_CONNECTION_ERROR_MESG"), null);
            return;
        }
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)modelDetailsDataNode.getData();
        this._viewBtn = new JButton(DataMinerIcons.get(Icons.PI_ATTR_GROUP_MODEL_VIEW_MODEL_ENA));
        this._viewBtn.setDisabledIcon(DataMinerIcons.get(Icons.PI_ATTR_GROUP_MODEL_VIEW_MODEL_DIS));
        this._viewBtn.setEnabled(false);
        this._viewBtn.setToolTipText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_VIEW"));
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.setEnabled(false);
        this._removeBtn.setToolTipText(PropertyLrb.get("PI_MODEL_GROUP_MODEL_REMOVE_MODEL"));
        this._addBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this._addBtn.setEnabled(bl);
        this._addBtn.setToolTipText(PropertyLrb.get("PI_MODEL_GROUP_MODEL_ADD_MODEL"));
        this.loadData(modelDetailsDataNodeType);
        this.initComboAndLabels();
        this._modelsTblModel = new ModelsTableModel(this._models, this._ownerName, modelDetailsDataNode);
        this.setupModelsTable(this._modelsTblModel);
        JScrollPane jScrollPane = new JScrollPane((Component)this._jModelsTable);
        this.ModelsComponentWithTitlebar.setComponent((JComponent)jScrollPane);
        this.ModelsComponentWithTitlebar.setLabel(new JLabel(PropertyLrb.get("PI_MODEL_DETAILS_MODEL_AVAILABLE_MODELS")));
        ControlBar controlBar = new ControlBar();
        this._findPane = this.createFindPane();
        controlBar.add((Component)this._addBtn);
        controlBar.add((Component)this._removeBtn);
        controlBar.add((Component)this._viewBtn);
        controlBar.addSeparator();
        controlBar.add(this._findPane);
        this.ModelsComponentWithTitlebar.setControlBar(controlBar);
        this.addListeners();
    }

    private void addListeners() {
        this._viewBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelDetailsPIComponentModelsPanel.this.viewModel();
            }
        });
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelDetailsPIComponentModelsPanel.this.removeButtonProcessing();
            }
        });
        this._addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelDetailsAutoDialog editModelDetailsAutoDialog = new EditModelDetailsAutoDialog();
                if (editModelDetailsAutoDialog.invoke(ModelDetailsPIComponentModelsPanel.this.getContext(ModelDetailsPIComponentModelsPanel.this._model), ModelDetailsPIComponentModelsPanel.this.getTargetNode(ModelDetailsPIComponentModelsPanel.this._model))) {
                    ModelDetailsPIComponentModelsPanel.this.updateWorkFlow();
                }
            }
        });
        this.jAutomaticSettingChkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ModelDetailsPIComponentModelsPanel.this.handleAutomaticSettingChange();
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)PropertyLrb.get("PI_MODEL_DETAILS_ERROR_TITLE"), (String)PropertyLrb.get("PI_MODEL_DETAILS_ERROR_MODEL_COMPATIBILITY"), null);
                }
            }
        });
        this._jModelsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ModelDetailsPIComponentModelsPanel.this.handleModelSelectionChanged();
            }
        });
        this.jOutputTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelDetailsPIComponentModelsPanel.this.processOutputTypeComboAction();
            }
        });
    }

    private void removeButtonProcessing() {
        int[] nArray = this._jModelsTable.getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this._jModelsTable.getModel());
        modelsTableModel.removeSelectedRows(nArray);
        this.updateNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNode() {
        ModelDetailsOutputType modelDetailsOutputType = new ModelDetailsOutputType();
        Attributes attributes = null;
        ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this._jModelsTable.getModel());
        if (this._currentOutputType != null) {
            modelDetailsOutputType.setMiningAlgorithm(MiningAlgorithmOptions.getMiningAlgorithmType(this._currentAlgorithm));
            modelDetailsOutputType.setMiningFunction(MiningFunctions.getMiningFunctionType(this._currentFunction));
            ModelDetailsOutputType.Models models = this._jModelsTable.getRowCount() == 0 ? new ModelDetailsOutputType.Models() : modelsTableModel.generateModelsCollection();
            modelDetailsOutputType.setModels(models);
            modelDetailsOutputType.setType(MiningDetailsOutputType.getMiningDetailType(this._currentOutputType, this._currentAlgorithm, this._currentFunction));
            modelDetailsOutputType.setAttributes(OutputAttributeType.convertAttributes(this._currentOutputColumns));
        } else {
            ModelDetailsOutputType.Models models = this._jModelsTable.getRowCount() == 0 ? new ModelDetailsOutputType.Models() : modelsTableModel.generateModelsCollection();
            modelDetailsOutputType.setModels(models);
            attributes = new Attributes();
            modelDetailsOutputType.setAttributes(attributes);
            modelDetailsOutputType.setType(null);
            modelDetailsOutputType.setMiningAlgorithm(null);
            modelDetailsOutputType.setMiningFunction(null);
        }
        modelDetailsOutputType.setAutoSpec(this._automaticSetting ? AutoSpecType.fromValue((String)"Yes") : AutoSpecType.fromValue((String)"No"));
        CommandProcessor.getInstance().beginTrans("Model Details Node: Edit Models");
        try {
            this._model.setValueAt((Object)modelDetailsOutputType, ModelDetailsNodePropertyModel.RowIndex.MODEL_DETAILS_MODELS, 0);
            Element[] elementArray = this.getContext(this._model).getSelection();
            WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
            workflowNodeInspectorElement.validate(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_MESG"), null);
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
    }

    private void handleModelSelectionChanged() {
        ModelsTableModel modelsTableModel;
        AvailableRefModelType availableRefModelType;
        boolean bl = false;
        int n = this._jModelsTable.getSelectedRowCount();
        if (n == 1 && (availableRefModelType = (modelsTableModel = (ModelsTableModel)((Object)this._jModelsTable.getModel())).getDataVector().get(this._jModelsTable.getSelectedRow())).isIsModelBuilt()) {
            bl = true;
        }
        this._viewBtn.setEnabled(bl);
        if (this.isWritable()) {
            this._removeBtn.setEnabled(n != 0 && !this._automaticSetting);
        }
    }

    private void handleAutomaticSettingChange() throws Exception {
        boolean bl = this.jAutomaticSettingChkBox.isSelected();
        if (bl) {
            if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)ModelDetailsLrb.get("MODEL_DETAILS_AUTO_SETTING_ON"), (String)ModelDetailsLrb.get("WARNING_TITLE"), null, (boolean)true)) {
                this.jAutomaticSettingChkBox.setSelected(false);
                return;
            }
            this.loadCompatibleModels();
            this._automaticSetting = true;
            this.updateNode();
        } else {
            this._automaticSetting = false;
            this.updateNode();
        }
        this.enableGridControls(!this._automaticSetting);
    }

    private void enableGridControls(boolean bl) {
        int n = this._jModelsTable.getSelectedRowCount();
        if (this.isWritable()) {
            this._removeBtn.setEnabled(bl && n > 0);
        }
    }

    private void loadCompatibleModels() throws Exception {
        ModelDetailsOutputType modelDetailsOutputType = this.generateModelOutputType();
        ModelDetailsOutputType modelDetailsOutputType2 = this.getTargetNode(this._model).addCompatibleModels(modelDetailsOutputType);
        this._modelsTblModel.reload(modelDetailsOutputType2.getModels().getModel());
    }

    private ModelDetailsOutputType generateModelOutputType() {
        ModelDetailsOutputType modelDetailsOutputType = new ModelDetailsOutputType();
        Attributes attributes = new Attributes();
        ModelDetailsOutputType.Models models = this._modelsTblModel.getRowCount() == 0 ? new ModelDetailsOutputType.Models() : this._modelsTblModel.generateModelsCollection();
        modelDetailsOutputType.setModels(models);
        modelDetailsOutputType.setAttributes(attributes);
        modelDetailsOutputType.setMiningAlgorithm(MiningAlgorithmOptions.getMiningAlgorithmType(this._currentAlgorithm));
        modelDetailsOutputType.setMiningFunction(MiningFunctions.getMiningFunctionType(this._currentFunction));
        modelDetailsOutputType.setType(MiningDetailsOutputType.getMiningDetailType(this._currentOutputType, this._currentAlgorithm, this._currentFunction));
        modelDetailsOutputType.setAttributes(OutputAttributeType.convertAttributes(this._currentOutputColumns));
        modelDetailsOutputType.setAutoSpec(this._automaticSetting ? AutoSpecType.fromValue((String)"Yes") : AutoSpecType.fromValue((String)"No"));
        return modelDetailsOutputType;
    }

    private void viewModel() {
        try {
            Object object;
            Object object2;
            ModelProvider modelProvider;
            ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this._jModelsTable.getModel());
            int n = this._jModelsTable.convertRowIndexToModel(this._jModelsTable.getSelectedRow());
            AvailableRefModelType availableRefModelType = modelsTableModel.getDataVector().get(n);
            MiningAlgorithmType miningAlgorithmType = availableRefModelType.getMiningAlgorithm();
            ModelDetailsDataNode modelDetailsDataNode = this.getTargetNode(this._model);
            AbstractNode object4 = null;
            List<AbstractNode> list = modelDetailsDataNode.findParentNodes();
            RefModelType refModelType = null;
            block2: for (AbstractNode object32 : list) {
                if (!(object32 instanceof ModelProvider)) continue;
                modelProvider = (ModelProvider)((Object)object32);
                object2 = modelProvider.getOutputModels();
                object = object2.iterator();
                while (object.hasNext()) {
                    RefModelType refModelType2 = object.next();
                    if (!refModelType2.getModelId().equals(availableRefModelType.getModelId())) continue;
                    refModelType = refModelType2;
                    object4 = object32;
                    continue block2;
                }
            }
            if (refModelType == null) {
                MessageDialog.error((Component)this, (Object)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_NODE_ERROR_MESG"), (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_VIEWER_ERROR_TITLE"), null);
            }
            String string = object4.getData().getName();
            if (miningAlgorithmType != MiningAlgorithmType.SUPPORT_VECTOR_MACHINES) {
                String string2 = availableRefModelType.getName();
                modelProvider = this.getContext(this._model);
                object2 = (WorkflowNode)modelProvider.getNode();
                if (object2 == null) {
                    return;
                }
                object = ModelNodeUtils.findModelNode((WorkflowNode)object2, string, string2);
                if (object != null) {
                    EditorUtil.openDefaultEditorInFrame((Node)object);
                } else {
                    MessageDialog.error((Component)this, (Object)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_NODE_ERROR_MESG"), (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_VIEWER_ERROR_TITLE"), null);
                }
                return;
            }
            LoadSVMModelViewer loadSVMModelViewer = new LoadSVMModelViewer((ModelInfoType)availableRefModelType, this.getContext(this._model), string);
            loadSVMModelViewer.execute();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)this, (Throwable)exception, (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_VIEWER_ERROR_TITLE"), (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_VIEWER_ERROR_MESG"), null);
        }
    }

    protected Component createFindPane() {
        Box box = new Box(2);
        this._searchField = this.searchField();
        this.setupFilterCtl();
        box.setName("Find");
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        box.add((Component)this._searchField);
        Dimension dimension = box.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 250);
        Dimension dimension3 = this.derive(dimension, 120);
        box.setPreferredSize(dimension2);
        box.setMaximumSize(dimension2);
        box.setMinimumSize(dimension3);
        return box;
    }

    private void setupFilterCtl() {
        this._currentSearchCategory = 1;
        this._searchField.addCategory(this._defaultSearchCategory);
        this._searchField.addCategory(new SearchCategory(PropertyLrb.get("PI_MODEL_DETAILS_MODEL_COLUMN_NODE")));
        this._searchField.addCategory(new SearchCategory(PropertyLrb.get("PI_MODEL_DETAILS_MODEL_COLUMN_ALGORITHM")));
        this._searchField.setSelectedCategory(this._defaultSearchCategory);
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    private SearchField searchField() {
        final SearchField searchField = new SearchField();
        searchField.setStyle(SearchField.Style.FILTER);
        searchField.setAutoFind(true);
        searchField.setPrompt(InspectorArb.getString((int)34));
        searchField.setNotifyOnEmptySearch(true);
        searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                ModelDetailsPIComponentModelsPanel.this.translateSearchCategoryToConstant(searchField.getSelectedCategory());
                ModelDetailsPIComponentModelsPanel.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                ModelDetailsPIComponentModelsPanel.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
                ModelDetailsPIComponentModelsPanel.this.processFilter(string);
            }
        });
        return searchField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFilter(String string) {
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        try {
            ideMainWindow.setCursor(new Cursor(3));
            ModelsTableModel modelsTableModel = this._modelsTblModel.getfilteredCopy(string, this._currentSearchCategory, null, null, null);
            this.setupModelsTable(modelsTableModel);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)PropertyLrb.get("PI_MODEL_DETAILS_MODEL_PI_ERROR_TITLE"), (String)PropertyLrb.get("PI_MODEL_DETAILS_MODEL_PI_NODE_LOAD_ERROR_MESG"), null);
        }
        finally {
            ideMainWindow.setCursor(new Cursor(0));
        }
    }

    private synchronized int translateSearchCategoryToConstant(SearchCategory searchCategory) {
        int n = -1;
        if (searchCategory.getLabel().equals(PropertyLrb.get("PI_MODEL_GROUP_FILTER_MODEL_NAME"))) {
            this._currentSearchCategory = 1;
        } else if (searchCategory.getLabel().equals(PropertyLrb.get("PI_MODEL_DETAILS_MODEL_COLUMN_ALGORITHM"))) {
            this._currentSearchCategory = 3;
        } else if (searchCategory.getLabel().equals(PropertyLrb.get("PI_MODEL_DETAILS_MODEL_COLUMN_NODE"))) {
            this._currentSearchCategory = 2;
        } else assert (false) : "Invalid Search Category Code";
        return n;
    }

    private void setupModelsTable(ModelsTableModel modelsTableModel) {
        this._jModelsTable.setModel((TableModel)((Object)modelsTableModel));
        this._jModelsTable.setSorted(true);
        this._jModelsTable.setSortColumn(0, true);
        this._jModelsTable.setUpdateSelectionOnSort(true);
        this._jModelsTable.getTableHeader().setReorderingAllowed(false);
        IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                GenericTable genericTable = (GenericTable)jTable;
                int n3 = genericTable.convertRowIndexToModel(n);
                ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)ModelDetailsPIComponentModelsPanel.this._jModelsTable.getModel());
                RefModelType refModelType = modelsTableModel.getDataVector().get(n3);
                if (refModelType.getStatus() == RefModelStatusType.VALID && modelsTableModel.isModelBuilt(n)) {
                    return DataMinerIcons.get(Icons.PI_BUILD_GROUP_MODEL_BUILT);
                }
                if (refModelType.getStatus() == RefModelStatusType.VALID && !modelsTableModel.isModelBuilt(n)) {
                    return _nullIcon;
                }
                return DataMinerIcons.get(Icons.PI_BUILD_GROUP_MODEL_INVALID);
            }
        });
        TableColumn tableColumn = this._jModelsTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(iconCellRenderer);
    }

    public void initComboAndLabels() {
        this.jAutomaticSettingChkBox.setSelected(this._automaticSetting);
        this.enableGridControls(!this.jAutomaticSettingChkBox.isSelected());
        if (this._modelDetailType == null) {
            this.jOutputTypeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{this.UNDEFINED}));
            this.jModelTypeValue.setText(this.UNDEFINED);
            this.jModelFunctionValue.setText(this.UNDEFINED);
            this.jOutputTypeCombo.setEnabled(false);
        } else {
            this.jOutputTypeCombo.setModel(new DefaultComboBoxModel<MiningDetailsOutputType>(MiningDetailsOutputType.getMiningDetailsOutputType(this._currentFunction, this._currentAlgorithm)));
            this.jModelFunctionValue.setText(this._currentFunction.toString());
            this.jModelTypeValue.setText(this._currentAlgorithm.toString());
            this.jOutputTypeCombo.setSelectedItem((Object)this._currentOutputType);
            this.jOutputTypeCombo.setEnabled(this.isWritable());
        }
    }

    public void loadData(ModelDetailsDataNodeType modelDetailsDataNodeType) {
        this._modelOutputType = modelDetailsDataNodeType.getModelDetailsOutput();
        if (this._modelOutputType != null) {
            this._models = this._modelOutputType.getModels().getModel();
            this._modelDetailType = this._modelOutputType.getType();
            this._currentOutputType = MiningDetailsOutputType.getMiningDetailsOutputType(this._modelDetailType);
            this._currentFunction = MiningFunctions.getMiningFunctionsFromType(this._modelOutputType.getMiningFunction());
            this._currentAlgorithm = MiningAlgorithmOptions.getMiningAlgorithmOption(this._modelOutputType.getMiningAlgorithm());
            this._currentOutputColumns = OutputAttributeType.convertAttributes(this._modelOutputType.getAttributes());
            String string = this._modelOutputType.getAutoSpec().value();
            if (string != null) {
                this._automaticSetting = this._modelOutputType.getAutoSpec().value().compareTo("Yes") == 0;
            }
        } else {
            this._modelDetailType = null;
            this._currentOutputType = null;
            this._currentFunction = null;
            this._currentAlgorithm = null;
            this._currentOutputColumns = null;
            this._models = null;
        }
    }

    private void processOutputTypeComboAction() {
        MiningDetailsOutputType miningDetailsOutputType = (MiningDetailsOutputType)((Object)this.jOutputTypeCombo.getSelectedItem());
        if (this._currentOutputType != miningDetailsOutputType) {
            this._currentOutputType = miningDetailsOutputType;
            this.jOutputTypeCombo.setSelectedItem((Object)this._currentOutputType);
            this.initOutputColumns();
        }
    }

    private void initOutputColumns() {
        if (this._currentOutputColumns == null) {
            this._currentOutputColumns = ModelDetailsExtract.getOutputColumnList(MiningDetailsOutputType.getMiningDetailType(this._currentOutputType, this._currentAlgorithm, this._currentFunction), this.dbVersion);
        }
    }

    public void updatePI(PropertyModel propertyModel) {
        this._model = propertyModel;
        ModelDetailsDataNode modelDetailsDataNode = this.getTargetNode(propertyModel);
        if (modelDetailsDataNode == null) {
            return;
        }
        try {
            this._dbConn = Connections.getSharedConnection(this.getContext(this._model));
            this._ownerName = Connections.getUserAccountName(this.getContext(this._model));
            this._ownerName = StringUtils.isDoubleQuotedString(this._ownerName) ? StringUtils.trimDoubleQuotes(this._ownerName) : this._ownerName.toUpperCase();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)PropertyLrb.get("PI_MODEL_DETAILS_MODEL_PI_ERROR_TITLE"), (String)PropertyLrb.get("PI_MODEL_DETAILS_MODEL_PI_CONNECTION_ERROR_MESG"), null);
            return;
        }
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)modelDetailsDataNode.getData();
        this.loadData(modelDetailsDataNodeType);
        this.initComboAndLabels();
        this._modelsTblModel = new ModelsTableModel(this._models, this._ownerName, modelDetailsDataNode);
        this.setupModelsTable(this._modelsTblModel);
    }

    @Override
    protected ModelDetailsDataNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowModelDetailsNodePropertyProxyModel)) {
            return null;
        }
        WorkflowModelDetailsNodePropertyProxyModel workflowModelDetailsNodePropertyProxyModel = (WorkflowModelDetailsNodePropertyProxyModel)propertyModel;
        Context context = workflowModelDetailsNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof ModelDetailsDataNodeType) {
            return (ModelDetailsDataNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }
}

