/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.awt.Component;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.ODMrValidationIssue;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.PIAncestorListener;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.javatools.status.Issue;
import oracle.javatools.ui.Borders;
import oracle.javatools.util.ModelUtil;

public class PIComponentPanel<T extends Node>
extends JPanel {
    private static final Logger theLogger = Logger.getLogger(PIComponentPanel.class.getName());
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected WorkflowNodePropertyProxyModel _model;

    public PIComponentPanel(PropertyModel propertyModel) {
        assert (propertyModel instanceof WorkflowNodePropertyProxyModel);
        this._model = (WorkflowNodePropertyProxyModel)propertyModel;
        this.addAncestorListener(new PIAncestorListener(this));
    }

    public final boolean isWritable() {
        oracle.ide.model.Node node = EditorManager.getEditorManager().getCurrentEditor().getContext().getNode();
        if (!(node instanceof WorkflowNode)) {
            return false;
        }
        WorkflowNode workflowNode = (WorkflowNode)node;
        return !workflowNode.isReadOnly();
    }

    protected void updateWorkFlow() {
        Context context = this.getContext((PropertyModel)this._model);
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor instanceof WorkflowEditor) {
            WorkflowEditor workflowEditor = (WorkflowEditor)editor;
            WorkflowNode workflowNode = workflowEditor.getWorkflowNode();
            try {
                Node node = workflowEditor.getSelectedDiagramNode();
                WorkflowNode workflowNode2 = (WorkflowNode)context.getNode();
                WorkflowModel workflowModel = WorkflowUtils.getWorkflowModel(workflowNode2);
                if (node != null) {
                    workflowEditor.setSelected(workflowNode.getEngine(), node);
                }
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
    }

    protected Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        assert (propertyModel instanceof WorkflowNodePropertyProxyModel);
        WorkflowNodePropertyProxyModel workflowNodePropertyProxyModel = (WorkflowNodePropertyProxyModel)propertyModel;
        Context context = workflowNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    protected T getTargetNode(PropertyModel propertyModel, Class clazz) {
        Node node = null;
        if (propertyModel == null) {
            return (T)node;
        }
        if (!(propertyModel instanceof WorkflowNodePropertyProxyModel)) {
            return (T)node;
        }
        WorkflowNodePropertyProxyModel workflowNodePropertyProxyModel = (WorkflowNodePropertyProxyModel)propertyModel;
        Context context = workflowNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        try {
            if (nodeType.getClass().isAssignableFrom(clazz)) {
                node = workflowNodeInspectorElement.getNode();
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            node = null;
        }
        return (T)node;
    }

    protected Node getTargetNode(PropertyModel propertyModel) {
        Node node = null;
        if (propertyModel == null) {
            return node;
        }
        if (!(propertyModel instanceof WorkflowNodePropertyProxyModel)) {
            return node;
        }
        WorkflowNodePropertyProxyModel workflowNodePropertyProxyModel = (WorkflowNodePropertyProxyModel)propertyModel;
        Context context = workflowNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        node = workflowNodeInspectorElement.getNode();
        return node;
    }

    protected void restoreBorder(JComponent jComponent) {
        Borders.restoreBorder((JComponent)jComponent);
    }

    protected void addWarningBorderAndTooltip(Component component, Collection<? extends Issue> collection) {
        if (!(component instanceof JComponent)) {
            return;
        }
        JComponent jComponent = (JComponent)component;
        Borders.attachErrorBorder((JComponent)jComponent);
        jComponent.setToolTipText(this.toolTip(collection));
    }

    protected String toolTip(Collection<? extends Issue> collection) {
        StringBuilder stringBuilder = new StringBuilder("<html><pre>");
        Iterator<? extends Issue> iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().getMessage();
            if (!ModelUtil.hasLength((String)string)) continue;
            stringBuilder.append(string);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(LINE_SEPARATOR);
        }
        stringBuilder.append("</pre></html>");
        return stringBuilder.toString();
    }

    protected List<Issue> openIssues(Collection<String> collection) {
        ArrayList<Issue> arrayList = new ArrayList<Issue>();
        for (String string : collection) {
            ODMrValidationIssue oDMrValidationIssue = new ODMrValidationIssue((PropertyModel)this._model, string);
            arrayList.add(oDMrValidationIssue);
        }
        return arrayList;
    }

    protected List<Issue> openIssue(String string) {
        ArrayList<Issue> arrayList = new ArrayList<Issue>();
        ODMrValidationIssue oDMrValidationIssue = new ODMrValidationIssue((PropertyModel)this._model, string);
        arrayList.add(oDMrValidationIssue);
        return arrayList;
    }

    protected Map<String, AttributeType> getAvailableAttributes(final String string, final String string2) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        class GetAttrs
        extends ProgressRunnable {
            private Vector<Vector> cols;

            GetAttrs() {
            }

            public Vector<Vector> getColumns() {
                return this.cols;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doWork() throws Exception {
                Boolean bl = Boolean.FALSE;
                Connection connection = null;
                try {
                    Context context = PIComponentPanel.this.getContext((PropertyModel)PIComponentPanel.this._model);
                    connection = Connections.getUniqueConnection(context);
                    this.cols = DatabaseMetadataUtils.getColumnDetails(connection, string == null ? Connections.getUserAccountName(PIComponentPanel.this.getContext((PropertyModel)PIComponentPanel.this._model)) : string, string2);
                    bl = Boolean.TRUE;
                }
                catch (Throwable throwable) {
                    SQLHelper.close(connection);
                    throw throwable;
                }
                SQLHelper.close(connection);
                return bl;
            }
        }
        GetAttrs getAttrs = new GetAttrs();
        getAttrs.setTitle(WorkflowEditorLrb.get("LOAD_AVAIL_ATTRS"));
        getAttrs.setMessage(WorkflowEditorLrb.get("LOAD_AVAIL_ATTRS_DESCR"));
        getAttrs.setCancelable(false);
        try {
            getAttrs.start(true);
            Vector<Vector> vector = getAttrs.getColumns();
            if (vector != null && !vector.isEmpty()) {
                for (Vector vector2 : vector) {
                    AttributeType attributeType = new AttributeType();
                    attributeType.setName((String)vector2.get(0));
                    attributeType.setDataType((String)vector2.get(1));
                    attributeType.setStatus(AttributeStatus.VALID);
                    hashMap.put(attributeType.getName(), attributeType);
                }
            }
        }
        catch (ProgressException progressException) {
            theLogger.log(Level.SEVERE, progressException.getMessage(), progressException);
        }
        return hashMap;
    }
}

