/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.dynamic.feature;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicApplyHelper;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicApplyOutputDialog;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicNodesLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.feature.FeaturePredictionLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.feature.FeaturePredictionsTableModel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.prediction.PredictionEditorState;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.dynamic.DynamicLrb;
import oracle.dmt.dataminer.workflow.inspect.dynamic.DynamicNodePredictionPanel;
import oracle.dmt.dataminer.workflow.inspect.dynamic.feature.DynamicFeatureInspectorState;
import oracle.dmt.dataminer.workflow.inspect.dynamic.feature.FeaturePredictLrb;
import oracle.dmt.dataminer.workflow.inspect.dynamic.feature.WorkflowDynamicFeatureNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.DynamicFeatureNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicApplyOutputColumnType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicApplyOutputColumns;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicFeatureNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicNodeBaseSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureIdType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class DynamicFeatureNodePredictionPanel
extends DynamicNodePredictionPanel {
    private JComboBox jComboBoxCaseId;
    private ComponentWithTitlebar<JComponent> jComponentFeatures;
    private JTextField jFeatureTextField;
    private JLabel jLabelCaseId;
    private JLabel jLabelFeatures;
    private DynamicFeatureNode _targetNode;

    public DynamicFeatureNodePredictionPanel(PropertyModel propertyModel) {
        super(propertyModel);
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    private void initComponents() {
        this.jLabelCaseId = new JLabel();
        this.jComboBoxCaseId = new JComboBox();
        this.jLabelFeatures = new JLabel();
        this.jFeatureTextField = new NumberTextField();
        this.jComponentFeatures = new ComponentWithTitlebar();
        this.jLabelCaseId.setText("Case ID:");
        this.jComboBoxCaseId.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabelFeatures.setText("Number of Features to Extract:");
        ((NumberTextField)this.jFeatureTextField).setDataType(Integer.class);
        ((NumberTextField)this.jFeatureTextField).setSigned(false);
        this.jFeatureTextField.setLocale(Locale.getDefault());
        this.jFeatureTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicFeatureNodePredictionPanel.this.jFeatureTextFieldActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelCaseId, -2, 60, -2).addGap(12, 12, 12).addComponent(this.jComboBoxCaseId, -2, 121, -2).addGap(0, 243, Short.MAX_VALUE)).addComponent(this.jLabelFeatures, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jFeatureTextField, -2, 59, -2)).addComponent((Component)this.jComponentFeatures, -1, 499, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(4, 4, 4).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelCaseId).addComponent(this.jComboBoxCaseId, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jFeatureTextField, -2, -1, -2).addComponent(this.jLabelFeatures)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jComponentFeatures, -1, 271, Short.MAX_VALUE)));
    }

    private void jFeatureTextFieldActionPerformed(ActionEvent actionEvent) {
        JTextField jTextField = this.jFeatureTextField;
        Number number = ((NumberTextField)jTextField).getNumber();
        Integer n = number.intValue();
        this.setFeatureNumber(n);
    }

    @Override
    protected JComboBox getComboCaseID() {
        return this.jComboBoxCaseId;
    }

    @Override
    protected JLabel getLabelCaseID() {
        return this.jLabelCaseId;
    }

    public void updateUI(PropertyModel propertyModel) {
        Object object;
        if (!(propertyModel instanceof WorkflowDynamicFeatureNodePropertyProxyModel)) {
            return;
        }
        this._model = (WorkflowDynamicFeatureNodePropertyProxyModel)propertyModel;
        this._targetNode = (DynamicFeatureNode)this.getTargetNode((PropertyModel)this._model);
        this.createNameGenerator();
        NodeType nodeType = this._targetNode.getData();
        DynamicFeatureNodeType dynamicFeatureNodeType = (DynamicFeatureNodeType)nodeType;
        DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this._jPredictionOutputsTable));
        this.jComponentFeatures.setComponent((JComponent)jScrollPane);
        this.jComponentFeatures.setLabel(new JLabel(FeaturePredictionLrb.get("FEATURE_PREDICTION_EDITOR_PANEL_PREDICTION_OUTPUT_TITLE")));
        ControlBar controlBar = new ControlBar();
        this.addPredOutputBtn = new JButton(DataMinerIcons.get(Icons.ADD));
        this.addPredOutputBtn.setToolTipText(FeaturePredictionLrb.get("FEATURE_PREDICTION_EDITOR_TOOLTIP_ADD_PREDICTION_OUTPUT"));
        this.addPredOutputBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicFeatureNodePredictionPanel.this.hanldeAddFeaturePredictionOutput();
            }
        });
        controlBar.add((Component)this.addPredOutputBtn);
        this.removePredOutputBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this.removePredOutputBtn.setToolTipText(FeaturePredictionLrb.get("FEATURE_PREDICTION_EDITOR_TOOLTIP_REMOVE_PREDICTION_OUTPUT"));
        this.removePredOutputBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicFeatureNodePredictionPanel.this.removeSelectedPredictionOutputs();
            }
        });
        controlBar.add((Component)this.removePredOutputBtn);
        this.editPredOutputBtn = new JButton(_editIcon);
        this.editPredOutputBtn.setToolTipText(FeaturePredictionLrb.get("FEATURE_PREDICTION_EDITOR_TOOLTIP_EDIT_PREDICTION_OUTPUT"));
        this.editPredOutputBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicFeatureNodePredictionPanel.this.hanldeEditFeaturePredictionOutput();
            }
        });
        controlBar.add((Component)this.editPredOutputBtn);
        this.jComponentFeatures.setControlBar(controlBar);
        this._jPredictionOutputsTable.setFillsViewportHeight(true);
        this.addPredOutputBtn.setEnabled(true);
        this.removePredOutputBtn.setEnabled(false);
        this.editPredOutputBtn.setEnabled(false);
        this.buildCaseIDCombo(dynamicFeatureNodeType);
        this.jComboBoxCaseId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicFeatureNodePredictionPanel.this.handleCaseIDChange();
            }
        });
        FeatureIdType featureIdType = dynamicFeatureNodeType.getFeatureId();
        if (null == featureIdType) {
            featureIdType = new FeatureIdType();
            object = new FeatureIdType.Column();
            object.setName(String.valueOf(10));
            featureIdType.setColumn(object);
        }
        ((NumberTextField)this.jFeatureTextField).setNumber((Number)Integer.parseInt(featureIdType.getColumn().getName()));
        object = new FeatureNumberInputVerifier();
        FeatureNumberValidator featureNumberValidator = new FeatureNumberValidator((FeatureNumberInputVerifier)object);
        this.jFeatureTextField.addFocusListener(featureNumberValidator);
        this.jFeatureTextField.addKeyListener(featureNumberValidator);
        this.jFeatureTextField.setInputVerifier((InputVerifier)object);
        this.setupFeaturePredictionOutputTable(dynamicNodeBaseSettingsType);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = DynamicFeatureNodePredictionPanel.this._jPredictionOutputsTable.getSelectedRowInModel();
                if (n != -1 && mouseEvent.getClickCount() == 2) {
                    DynamicFeatureNodePredictionPanel.this.hanldeEditFeaturePredictionOutput();
                }
            }
        };
        this._jPredictionOutputsTable.addMouseListener(mouseAdapter);
        this.jLabelFeatures.setText(FeaturePredictLrb.get("PI_TOTAL_FEATURE_NUMBER"));
    }

    private void buildCaseIDCombo(DynamicFeatureNodeType dynamicFeatureNodeType) {
        Object object;
        Object object22;
        Object object3;
        PartitionExpressionType partitionExpressionType2;
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (PartitionExpressionType partitionExpressionType2 : dynamicFeatureNodeType.getDynamicNodeBaseSettings().getPartitionExpressions().getPartitionExpression()) {
            if (null != partitionExpressionType2.getSQLExpression()) continue;
            object3 = partitionExpressionType2.getPartitionAttribute();
            hashMap.put(object3.getName(), (AttributeType)object3);
        }
        Vector vector = new Vector();
        vector.add(PredictionEditorState._none);
        partitionExpressionType2 = dynamicFeatureNodeType.getDynamicNodeBaseSettings();
        if (!partitionExpressionType2.getMiningAttributes().getMiningAttribute().isEmpty()) {
            for (Object object22 : partitionExpressionType2.getMiningAttributes().getMiningAttribute()) {
                if (!DatabaseMetadataUtils.isDynamicCaseIdDataTypeSupported(object22.getDataType()) || null != hashMap.get(object = object22.getAlias() != null ? object22.getAlias() : object22.getName())) continue;
                vector.add(object);
            }
            Collections.sort(vector);
        }
        object3 = new DefaultComboBoxModel(vector);
        object22 = null;
        object = partitionExpressionType2.getCaseAttributes().getAttribute();
        if (!object.isEmpty()) {
            object22 = ((AttributeType)object.get(0)).getName();
        }
        ((DefaultComboBoxModel)object3).setSelectedItem(object22 != null ? object22 : PredictionEditorState._none);
        this.jComboBoxCaseId.setModel(object3);
    }

    public void initUI(PropertyModel propertyModel) {
        Object object;
        this._model = (WorkflowDynamicFeatureNodePropertyProxyModel)propertyModel;
        this._targetNode = (DynamicFeatureNode)this.getTargetNode((PropertyModel)this._model);
        this.createNameGenerator();
        NodeType nodeType = this._targetNode.getData();
        DynamicFeatureNodeType dynamicFeatureNodeType = (DynamicFeatureNodeType)nodeType;
        DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this._jPredictionOutputsTable));
        this.jComponentFeatures.setComponent((JComponent)jScrollPane);
        this.jComponentFeatures.setLabel(new JLabel(FeaturePredictionLrb.get("FEATURE_PREDICTION_EDITOR_PANEL_PREDICTION_OUTPUT_TITLE")));
        ControlBar controlBar = new ControlBar();
        this.addPredOutputBtn = new JButton(DataMinerIcons.get(Icons.ADD));
        this.addPredOutputBtn.setToolTipText(FeaturePredictionLrb.get("FEATURE_PREDICTION_EDITOR_TOOLTIP_ADD_PREDICTION_OUTPUT"));
        this.addPredOutputBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicFeatureNodePredictionPanel.this.hanldeAddFeaturePredictionOutput();
            }
        });
        controlBar.add((Component)this.addPredOutputBtn);
        this.removePredOutputBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this.removePredOutputBtn.setToolTipText(FeaturePredictionLrb.get("FEATURE_PREDICTION_EDITOR_TOOLTIP_REMOVE_PREDICTION_OUTPUT"));
        this.removePredOutputBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicFeatureNodePredictionPanel.this.removeSelectedPredictionOutputs();
            }
        });
        controlBar.add((Component)this.removePredOutputBtn);
        this.editPredOutputBtn = new JButton(_editIcon);
        this.editPredOutputBtn.setToolTipText(FeaturePredictionLrb.get("FEATURE_PREDICTION_EDITOR_TOOLTIP_EDIT_PREDICTION_OUTPUT"));
        this.editPredOutputBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicFeatureNodePredictionPanel.this.hanldeEditFeaturePredictionOutput();
            }
        });
        controlBar.add((Component)this.editPredOutputBtn);
        this.jComponentFeatures.setControlBar(controlBar);
        this._jPredictionOutputsTable.setFillsViewportHeight(true);
        this.addPredOutputBtn.setEnabled(true);
        this.removePredOutputBtn.setEnabled(false);
        this.editPredOutputBtn.setEnabled(false);
        this.buildCaseIDCombo(dynamicFeatureNodeType);
        this.jComboBoxCaseId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicFeatureNodePredictionPanel.this.handleCaseIDChange();
            }
        });
        FeatureIdType featureIdType = dynamicFeatureNodeType.getFeatureId();
        if (null == featureIdType) {
            featureIdType = new FeatureIdType();
            object = new FeatureIdType.Column();
            object.setName(String.valueOf(10));
            featureIdType.setColumn(object);
        }
        ((NumberTextField)this.jFeatureTextField).setNumber((Number)Integer.parseInt(featureIdType.getColumn().getName()));
        object = new FeatureNumberInputVerifier();
        FeatureNumberValidator featureNumberValidator = new FeatureNumberValidator((FeatureNumberInputVerifier)object);
        this.jFeatureTextField.addFocusListener(featureNumberValidator);
        this.jFeatureTextField.addKeyListener(featureNumberValidator);
        this.jFeatureTextField.setInputVerifier((InputVerifier)object);
        this.setupFeaturePredictionOutputTable(dynamicNodeBaseSettingsType);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = DynamicFeatureNodePredictionPanel.this._jPredictionOutputsTable.getSelectedRowInModel();
                if (n != -1 && mouseEvent.getClickCount() == 2) {
                    DynamicFeatureNodePredictionPanel.this.hanldeEditFeaturePredictionOutput();
                }
            }
        };
        this._jPredictionOutputsTable.addMouseListener(mouseAdapter);
        this.jLabelFeatures.setText(FeaturePredictLrb.get("PI_TOTAL_FEATURE_NUMBER"));
    }

    private void setupFeaturePredictionOutputTable(DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType) {
        DynamicApplyOutputColumns dynamicApplyOutputColumns = dynamicNodeBaseSettingsType.getDynamicApplyOutputColumns();
        DynamicFeatureInspectorState dynamicFeatureInspectorState = new DynamicFeatureInspectorState(this._targetNode, this._outputColumnNameGenerator);
        FeaturePredictionsTableModel featurePredictionsTableModel = new FeaturePredictionsTableModel(dynamicApplyOutputColumns, dynamicFeatureInspectorState.getNodeSpecificTargetValues(null));
        this._jPredictionOutputsTable.setModel((TableModel)((Object)featurePredictionsTableModel));
        this._jPredictionOutputsTable.setShowGrid(true);
        this._jPredictionOutputsTable.setSorted(true);
        this._jPredictionOutputsTable.setSortColumn(FeaturePredictionsTableModel.FUNCTION, true);
        this._jPredictionOutputsTable.getSelectionModel().addListSelectionListener(new DynamicNodePredictionPanel.PredictionOutputsSelectionHandler());
    }

    @Override
    protected DynamicNodeBaseSettingsType getDynamicNodeBaseSettingsType() {
        NodeType nodeType = this._targetNode.getData();
        DynamicFeatureNodeType dynamicFeatureNodeType = (DynamicFeatureNodeType)nodeType;
        DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = dynamicFeatureNodeType.getDynamicNodeBaseSettings();
        return dynamicNodeBaseSettingsType;
    }

    private void hanldeAddFeaturePredictionOutput() {
        String string = DynamicNodesLrb.get("DYNAMIC_FEATURE_APPLY_OUTPUT_ADD_DIALOG_TITLE");
        DynamicApplyOutputDialog dynamicApplyOutputDialog = new DynamicApplyOutputDialog(string);
        DynamicFeatureInspectorState dynamicFeatureInspectorState = new DynamicFeatureInspectorState(this._targetNode, this._outputColumnNameGenerator);
        if (dynamicApplyOutputDialog.invoke(this.getContext((PropertyModel)this._model), dynamicFeatureInspectorState, null)) {
            DynamicApplyOutputColumnType dynamicApplyOutputColumnType = dynamicApplyOutputDialog.getApplyOutputColumn();
            DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
            DynamicApplyOutputColumns dynamicApplyOutputColumns = dynamicNodeBaseSettingsType.getDynamicApplyOutputColumns();
            DynamicApplyOutputColumns dynamicApplyOutputColumns2 = new DynamicApplyOutputColumns();
            DynamicApplyOutputColumns dynamicApplyOutputColumns3 = new DynamicApplyOutputColumns();
            List list = _helper.makeListCopies(dynamicApplyOutputColumns.getDynamicApplyOutputColumn(), 2);
            dynamicApplyOutputColumns3.getDynamicApplyOutputColumn().addAll(list.get(0));
            dynamicApplyOutputColumns2.getDynamicApplyOutputColumn().addAll(list.get(1));
            dynamicApplyOutputColumns2.getDynamicApplyOutputColumn().add(dynamicApplyOutputColumnType);
            ArrayList<Property> arrayList = new ArrayList<Property>();
            ComplexProperty complexProperty = new ComplexProperty("Predictions Only", dynamicApplyOutputColumns2);
            complexProperty.setOldData(dynamicApplyOutputColumns3);
            arrayList.add(new Property(String.valueOf(this._model.getRowMapping("PREDICTIONS_ONLY")), null, complexProperty, null, null));
            String string2 = DynamicLrb.get("PI_ADD_PREDICTION");
            this._model.setValueAt(string2, this._targetNode, arrayList);
        }
    }

    @Override
    protected Vector<DynamicApplyOutputColumnType> getDataVector() {
        FeaturePredictionsTableModel featurePredictionsTableModel = (FeaturePredictionsTableModel)((Object)this._jPredictionOutputsTable.getModel());
        Vector<DynamicApplyOutputColumnType> vector = featurePredictionsTableModel.getDataVector();
        return vector;
    }

    private void hanldeEditFeaturePredictionOutput() {
        int[] nArray = this._jPredictionOutputsTable.getSelectedRowsInModel();
        if (nArray == null || nArray.length != 1) {
            return;
        }
        NodeType nodeType = this._targetNode.getData();
        DynamicFeatureNodeType dynamicFeatureNodeType = (DynamicFeatureNodeType)nodeType;
        FeaturePredictionsTableModel featurePredictionsTableModel = (FeaturePredictionsTableModel)((Object)this._jPredictionOutputsTable.getModel());
        Vector<DynamicApplyOutputColumnType> vector = featurePredictionsTableModel.getDataVector();
        DynamicApplyOutputColumnType dynamicApplyOutputColumnType = vector.get(nArray[0]);
        DynamicApplyOutputColumnType dynamicApplyOutputColumnType2 = (DynamicApplyOutputColumnType)MetaDataHelper.copyMetadataObject(dynamicApplyOutputColumnType);
        DynamicFeatureInspectorState dynamicFeatureInspectorState = new DynamicFeatureInspectorState(this._targetNode, this._outputColumnNameGenerator);
        String string = DynamicNodesLrb.get("DYNAMIC_PREDICTION_APPLY_OUTPUT_EDIT_DIALOG_TITLE");
        DynamicApplyOutputDialog dynamicApplyOutputDialog = new DynamicApplyOutputDialog(string);
        if (dynamicApplyOutputDialog.invoke(this.getContext((PropertyModel)this._model), dynamicFeatureInspectorState, dynamicApplyOutputColumnType2, null)) {
            String string2;
            DynamicApplyOutputColumnType dynamicApplyOutputColumnType3 = dynamicApplyOutputDialog.getApplyOutputColumn();
            DynamicApplyOutputColumns dynamicApplyOutputColumns = new DynamicApplyOutputColumns();
            DynamicApplyOutputColumns dynamicApplyOutputColumns2 = new DynamicApplyOutputColumns();
            List list = _helper.makeListCopies(dynamicFeatureNodeType.getDynamicNodeBaseSettings().getDynamicApplyOutputColumns().getDynamicApplyOutputColumn(), 2);
            dynamicApplyOutputColumns2.getDynamicApplyOutputColumn().addAll(list.get(0));
            dynamicApplyOutputColumns.getDynamicApplyOutputColumn().addAll(list.get(1));
            String string3 = DynamicApplyHelper.getColumnName(dynamicApplyOutputColumnType);
            DynamicApplyOutputColumnType dynamicApplyOutputColumnType4 = null;
            for (Object object : dynamicApplyOutputColumns.getDynamicApplyOutputColumn()) {
                string2 = DynamicApplyHelper.getColumnName((DynamicApplyOutputColumnType)object);
                if (!string2.equals(string3)) continue;
                dynamicApplyOutputColumnType4 = object;
                break;
            }
            if (dynamicApplyOutputColumnType4 != null) {
                Object object;
                dynamicApplyOutputColumns.getDynamicApplyOutputColumn().remove(dynamicApplyOutputColumnType4);
                dynamicApplyOutputColumns.getDynamicApplyOutputColumn().add(dynamicApplyOutputColumnType3);
                ArrayList arrayList = new ArrayList();
                object = new ComplexProperty("Predictions Only", dynamicApplyOutputColumns);
                ((ComplexProperty)object).setOldData(dynamicApplyOutputColumns2);
                arrayList.add(new Property(String.valueOf(this._model.getRowMapping("PREDICTIONS_ONLY")), null, object, null, null));
                string2 = DynamicLrb.get("PI_EDIT_PREDICTION");
                this._model.setValueAt(string2, this._targetNode, arrayList);
            }
        }
    }

    @Override
    public DynamicFeatureNode getTargetNode() {
        return this._targetNode;
    }

    private void setFeatureNumber(int n) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        FeatureIdType featureIdType = new FeatureIdType();
        FeatureIdType.Column column = new FeatureIdType.Column();
        column.setName(String.valueOf(n));
        featureIdType.setColumn(column);
        NodeType nodeType = this._targetNode.getData();
        DynamicFeatureNodeType dynamicFeatureNodeType = (DynamicFeatureNodeType)nodeType;
        ComplexProperty complexProperty = new ComplexProperty("NUMBER_OF_FEATURES", featureIdType);
        complexProperty.setOldData(dynamicFeatureNodeType.getFeatureId());
        arrayList.add(new Property(String.valueOf(this._model.getRowMapping("NUMBER_OF_FEATURES")), null, complexProperty, null, null));
        String string = FeaturePredictLrb.get("PI_NUMBER_OF_FEATURES");
        this._model.setValueAt(string, this._targetNode, arrayList);
    }

    class FeatureNumberValidator
    extends KeyAdapter
    implements FocusListener {
        boolean busy = false;
        FeatureNumberInputVerifier _verifier;

        public FeatureNumberValidator(FeatureNumberInputVerifier featureNumberInputVerifier) {
            this._verifier = featureNumberInputVerifier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void validateFeatureNumber() {
            if (this.busy) {
                return;
            }
            try {
                this.busy = true;
                this._verifier.verify(DynamicFeatureNodePredictionPanel.this.jFeatureTextField);
            }
            finally {
                this.busy = false;
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                this.validateFeatureNumber();
            }
        }
    }

    class FeatureNumberInputVerifier
    extends InputVerifier {
        FeatureNumberInputVerifier() {
        }

        @Override
        public boolean verify(JComponent jComponent) {
            boolean bl = true;
            if (jComponent instanceof JTextField) {
                JTextField jTextField = (JTextField)jComponent;
                Number number = ((NumberTextField)jTextField).getNumber();
                if (number == null) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)FeaturePredictLrb.get("PI_FEATURE_NUMBER_INCORRECT"), (String)FeaturePredictLrb.get("PI_FEATURE_NUMBER_VALIDATION_ERROR_TITLE"), null);
                    bl = false;
                }
                if (!bl) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            NodeType nodeType = DynamicFeatureNodePredictionPanel.this._targetNode.getData();
                            DynamicFeatureNodeType dynamicFeatureNodeType = (DynamicFeatureNodeType)nodeType;
                            FeatureIdType featureIdType = dynamicFeatureNodeType.getFeatureId();
                            if (null == featureIdType) {
                                featureIdType = new FeatureIdType();
                                FeatureIdType.Column column = new FeatureIdType.Column();
                                column.setName(String.valueOf(10));
                                featureIdType.setColumn(column);
                            }
                            ((NumberTextField)DynamicFeatureNodePredictionPanel.this.jFeatureTextField).setNumber((Number)Integer.parseInt(featureIdType.getColumn().getName()));
                        }
                    });
                } else {
                    Integer n = number.intValue();
                    DynamicFeatureNodePredictionPanel.this.setFeatureNumber(n);
                }
            }
            return bl;
        }
    }
}

