/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.profile;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.teditor.graph.GraphLrb;
import oracle.dmt.dataminer.utils.TableNameValidator;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.profile.DataProfileNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.profile.ProfileGroupPIPropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.profile.WorkflowDataProfileNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.table.TablePIPropertyLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.DataProfileNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.DataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileOutputType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Element;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.status.Issue;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class OuputProfileColumnsPanel
extends PIComponentPanel {
    private static final int COLUMN_COUNT = 2;
    private static final int NAME = 0;
    private static final int DATA_TYPE = 1;
    private String[] _columnNames = new String[]{PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_NAME_COLUMN"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_DATA_TYPE_COLUMN")};
    private DataMinerTable _jAttributesTable = new DataMinerTable();
    private Vector<AttributeType> _profiledAttributes = new Vector();
    private Vector<AttributeType> _allAttributes = new Vector();
    private HashMap<String, AttributeType> _allAttributesMap = new HashMap();
    private List<String> _allowedAttributes = new ArrayList<String>();
    private SearchField _searchField;
    private Component _findPane;
    public static final int FILTER_ATTRIBUTE_NAME = 0;
    public static final int FILTER_ATTRIBUTE_TYPE = 1;
    private int _currentSearchCategory = 0;
    private SearchCategory _defaultSearchCategory = new SearchCategory(PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_NAME_COLUMN"));
    private AbstractDataNode _targetNode;
    private ComponentWithTitlebar<JComponent> jAttributesComponent;
    private JLabel jLabelName;
    private JTextField jTextFieldName;

    public OuputProfileColumnsPanel(PropertyModel propertyModel) {
        super(propertyModel);
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    private void initComponents() {
        this.jAttributesComponent = new ComponentWithTitlebar();
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabelName.setText("Name:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jAttributesComponent, -1, 448, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelName, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextFieldName, -2, 192, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(4, 4, 4).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelName, -2, 14, -2).addComponent(this.jTextFieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jAttributesComponent, -1, 270, Short.MAX_VALUE)));
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLabelName, (Component)this.jTextFieldName, (String)ProfileGroupPIPropertyLrb.get("PI_PROFILE_OUTPUT_TABLE_NAME"));
    }

    public void initUI(PropertyModel propertyModel) {
        Object object;
        Object object2;
        DataProfileOutputType dataProfileOutputType;
        Object object3;
        this._jAttributesTable.setTooltipEnable(true);
        this._model = (WorkflowDataProfileNodePropertyProxyModel)propertyModel;
        this._targetNode = (AbstractDataNode)this.getTargetNode((PropertyModel)this._model);
        DataNodeType dataNodeType = (DataNodeType)this._targetNode.getData();
        if (!(dataNodeType instanceof DataProfileNodeType)) {
            return;
        }
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)dataNodeType;
        String string = dataProfileNodeType.getStatisticTable().getName();
        this.jTextFieldName.setDocument(new TextFieldLimit(32));
        TableNameInputVerifier tableNameInputVerifier = new TableNameInputVerifier(this.jTextFieldName, this.getContext((PropertyModel)this._model));
        this.jTextFieldName.setInputVerifier(tableNameInputVerifier);
        if (!StringUtils.isValidNonQuotedDBObjectName(string)) {
            string = StringUtils.addDoubleQuotes(string);
        }
        this.jTextFieldName.setText(string);
        CustomTableNameValidator customTableNameValidator = new CustomTableNameValidator(tableNameInputVerifier, this.getContext((PropertyModel)this._model));
        this.jTextFieldName.addFocusListener(customTableNameValidator);
        this.jTextFieldName.addKeyListener(customTableNameValidator);
        List<AttributeType> list = this.getOutputAttributes();
        if (list != null) {
            this._allAttributes.addAll(list);
            object3 = list.iterator();
            while (object3.hasNext()) {
                dataProfileOutputType = (AttributeType)object3.next();
                this._allAttributesMap.put(dataProfileOutputType.getName(), (AttributeType)dataProfileOutputType);
                object2 = DatabaseMetadataUtils.getDefaultMiningType(dataProfileOutputType.getDataType());
                if (!((String)object2).equals("Numerical") && !((String)object2).equals("Categorical")) continue;
                this._allowedAttributes.add(dataProfileOutputType.getName());
            }
        }
        if ((object2 = (dataProfileOutputType = (object3 = (DataProfileNodeType)dataNodeType).getDataProfileOutput()).getAttributes()) != null && (object = object2.getAttribute()) != null && !object.isEmpty()) {
            this._profiledAttributes.addAll((Collection<AttributeType>)object);
        }
        object = Collator.getInstance();
        Collections.sort(this._allowedAttributes, object);
        AttributesTableModel attributesTableModel = new AttributesTableModel(this._profiledAttributes);
        this.setupItemsTable(attributesTableModel);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this._jAttributesTable));
        this.jAttributesComponent.setComponent((JComponent)jScrollPane);
        this.jAttributesComponent.setLabel(new JLabel(PreferencesLrb.get("PI_ATTRUBUTES_GROUP_TITLE")));
        ControlBar controlBar = new ControlBar();
        this.installItemFilterActions(controlBar);
        this.jAttributesComponent.setControlBar(controlBar);
        this._jAttributesTable.setFillsViewportHeight(true);
        this.setWritableControls();
    }

    private void setWritableControls() {
        boolean bl = this.isWritable();
        ((AttributesTableModel)((Object)this._jAttributesTable.getModel())).setWritable(bl);
        this.jTextFieldName.setEnabled(bl);
    }

    public void updateUI(PropertyModel propertyModel) {
        Object object;
        Object object2;
        if (!(propertyModel instanceof WorkflowDataProfileNodePropertyProxyModel)) {
            return;
        }
        this._model = (WorkflowDataProfileNodePropertyProxyModel)propertyModel;
        this._targetNode = (AbstractDataNode)this.getTargetNode((PropertyModel)this._model);
        NodeType nodeType = this._targetNode.getData();
        if (!(nodeType instanceof DataProfileNodeType)) {
            return;
        }
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)nodeType;
        this._allAttributes.clear();
        this._allAttributesMap.clear();
        this._allowedAttributes.clear();
        List<AttributeType> list = this.getOutputAttributes();
        if (list != null) {
            this._allAttributes.addAll(list);
            for (AttributeType dataProfileOutputType2 : list) {
                this._allAttributesMap.put(dataProfileOutputType2.getName(), dataProfileOutputType2);
                object2 = DatabaseMetadataUtils.getDefaultMiningType(dataProfileOutputType2.getDataType());
                if (!((String)object2).equals("Numerical") && !((String)object2).equals("Categorical")) continue;
                this._allowedAttributes.add(dataProfileOutputType2.getName());
            }
        }
        this._profiledAttributes.clear();
        DataProfileNodeType dataProfileNodeType2 = (DataProfileNodeType)nodeType;
        DataProfileOutputType dataProfileOutputType = dataProfileNodeType2.getDataProfileOutput();
        object2 = dataProfileOutputType.getAttributes();
        if (object2 != null && (object = object2.getAttribute()) != null && !object.isEmpty()) {
            this._profiledAttributes.addAll((Collection<AttributeType>)object);
        }
        object = new AttributesTableModel(this._profiledAttributes);
        this.setupItemsTable((AttributesTableModel)((Object)object));
        String string = dataProfileNodeType.getStatisticTable().getName();
        if (!StringUtils.isValidNonQuotedDBObjectName(string)) {
            string = StringUtils.addDoubleQuotes(string);
        }
        this.jTextFieldName.setText(string);
        this.validateTableName(string);
        this.setWritableControls();
    }

    private void setupItemsTable(AttributesTableModel attributesTableModel) {
        this._jAttributesTable.setModel((TableModel)((Object)attributesTableModel));
        this._jAttributesTable.setSorted(true);
        this._jAttributesTable.setSortColumn(0, true);
        this._jAttributesTable.setAutoResizeMode(4);
        IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                return IconCellRenderer.getIconForAttrStatus(OuputProfileColumnsPanel.this._profiledAttributes, object);
            }
        });
        TableColumn tableColumn = this._jAttributesTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(iconCellRenderer);
    }

    private void validateTableName(String string) {
        String string2 = null;
        if ((string = StringUtils.trimDoubleQuotes(string)).length() > 30) {
            string2 = TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_ERROR");
        } else if (!StringUtils.isDoubleQuotedString(string) && !StringUtils.containsNoDot(string)) {
            string2 = TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_TABLE_NAME_ERROR");
        }
        if (string2 != null) {
            List<Issue> list = this.openIssue(string2);
            this.addWarningBorderAndTooltip(this.jTextFieldName, list);
        } else {
            this.restoreBorder(this.jTextFieldName);
        }
    }

    private void installItemFilterActions(ControlBar controlBar) {
        this._findPane = this.createFindPane();
        controlBar.addSeparator();
        controlBar.add(this._findPane);
    }

    private void updateProfile(Object object, Object object2, String string) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        ComplexProperty complexProperty = new ComplexProperty(string, object);
        complexProperty.setOldData(object2);
        arrayList.add(new Property(String.valueOf(DataProfileNodePropertyModel.RowIndex.DATAPROFILE_INPUT), null, complexProperty, null, null));
        ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        complexProperty2.setOldData(this._targetNode.getSQLExpression());
        arrayList.add(new Property(String.valueOf(DataProfileNodePropertyModel.RowIndex.SQL_EXPRESSION), null, complexProperty2, null, null));
        if (this._model instanceof WorkflowNodePropertyProxyModel) {
            WorkflowNodePropertyProxyModel workflowNodePropertyProxyModel = this._model;
            workflowNodePropertyProxyModel.setValueAt(string, this._targetNode, arrayList);
        }
    }

    protected Component createFindPane() {
        Box box = new Box(2);
        this._searchField = this.searchField();
        this.setupFilterCtl();
        box.setName("Find");
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        box.add((Component)this._searchField);
        Dimension dimension = box.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 250);
        Dimension dimension3 = this.derive(dimension, 120);
        box.setPreferredSize(dimension2);
        box.setMaximumSize(dimension2);
        box.setMinimumSize(dimension3);
        return box;
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    private SearchField searchField() {
        final SearchField searchField = new SearchField();
        searchField.setStyle(SearchField.Style.FILTER);
        searchField.setAutoFind(true);
        searchField.setPrompt(InspectorArb.getString((int)34));
        searchField.setNotifyOnEmptySearch(true);
        searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                OuputProfileColumnsPanel.this.translateSearchCategoryToConstant(searchField.getSelectedCategory());
                OuputProfileColumnsPanel.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                OuputProfileColumnsPanel.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
                OuputProfileColumnsPanel.this.processFilter(string);
            }
        });
        return searchField;
    }

    private void setupFilterCtl() {
        this._currentSearchCategory = 0;
        this._searchField.addCategory(this._defaultSearchCategory);
        this._searchField.addCategory(new SearchCategory(PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_DATA_TYPE_COLUMN")));
        this._searchField.setSelectedCategory(this._defaultSearchCategory);
    }

    private void processFilter(String string) {
        try {
            AttributesTableModel attributesTableModel = (AttributesTableModel)((Object)this._jAttributesTable.getModel());
            if (attributesTableModel != null) {
                AttributesTableModel attributesTableModel2 = this.getFilteredAttributesTableModel(this._profiledAttributes, string, this._currentSearchCategory);
                this.setupItemsTable(attributesTableModel2);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)PropertyLrb.get("PI_ATTRIBUTES_GROUP_FAILURE_TITLE"), (String)PropertyLrb.get("PI_ATTRIBUTES_GROUP_FAILURE_MESSAGE"), null);
        }
    }

    private synchronized void translateSearchCategoryToConstant(SearchCategory searchCategory) {
        if (searchCategory.getLabel().equals(PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_NAME_COLUMN"))) {
            this._currentSearchCategory = 0;
        } else if (searchCategory.getLabel().equals(PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_DATA_TYPE_COLUMN"))) {
            this._currentSearchCategory = 1;
        } else assert (false) : "Invalid Search Category Code";
    }

    public AttributesTableModel getFilteredAttributesTableModel(Vector<AttributeType> vector, String string, int n) throws Exception {
        Vector<AttributeType> vector2 = new Vector<AttributeType>();
        SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
        Iterator<AttributeType> iterator = vector.iterator();
        AttributeType attributeType = null;
        boolean bl = string.length() <= 0;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            attributeType = iterator.next();
            if (bl) {
                bl2 = true;
            } else {
                String string2 = "";
                switch (n) {
                    case 0: {
                        string2 = attributeType.getName();
                        break;
                    }
                    case 1: {
                        string2 = attributeType.getDataType();
                        break;
                    }
                    default: {
                        assert (false) : "Invalid item filter category.";
                        string2 = null;
                    }
                }
                bl2 = string2 == null ? false : searchMatcher.matches((CharSequence)string2);
            }
            if (!bl2) continue;
            vector2.add(attributeType);
        }
        return new AttributesTableModel(vector2);
    }

    protected List<AttributeType> getOutputAttributes() {
        List list = null;
        Attributes attributes = null;
        DataProfileNode dataProfileNode = (DataProfileNode)this.getNode((PropertyModel)this._model);
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)dataProfileNode.getData();
        if (dataProfileNodeType != null && null != dataProfileNodeType.getDataProfileOutput()) {
            attributes = dataProfileNodeType.getDataProfileOutput().getAttributes();
        }
        if (attributes != null) {
            list = attributes.getAttribute();
        }
        return list;
    }

    private AbstractDataNode getNode(PropertyModel propertyModel) {
        Node node = this.getTargetNode(propertyModel);
        if (node == null || !(node instanceof AbstractDataNode)) {
            return null;
        }
        AbstractDataNode abstractDataNode = (AbstractDataNode)node;
        return abstractDataNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTableName(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        DataProfileNode dataProfileNode = (DataProfileNode)this.getTargetNode((PropertyModel)this._model, DataProfileNodeType.class);
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)dataProfileNode.getData();
        String string2 = dataProfileNodeType.getStatisticTable().getName();
        if (string2 != null && string2.trim().length() > 0 && string2.equals(StringUtils.trimDoubleQuotes(string))) {
            return;
        }
        string = StringUtils.trimDoubleQuotes(string);
        Context context = this.getContext((PropertyModel)this._model);
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        ComplexProperty complexProperty = new ComplexProperty("tableName", string);
        CommandProcessor.getInstance().beginTrans(TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_TABLE_NAME_TXN"));
        try {
            this._model.setValueAt(TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_TABLE_NAME"), dataProfileNode, complexProperty, DataProfileNodePropertyModel.RowIndex.TABLE_NAME);
            workflowNodeInspectorElement.validate(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_SYSTEM_ERROR_TITLE"), (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_SYSTEM_ERROR_MESG"), null);
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
    }

    class TableNameInputVerifier
    extends InputVerifier {
        JTextField _textField;
        String _currentValue;
        Context _context;

        public TableNameInputVerifier(JTextField jTextField, Context context) {
            this._textField = jTextField;
            this._context = context;
        }

        @Override
        public boolean verify(JComponent jComponent) {
            boolean bl = true;
            if (jComponent instanceof JTextField) {
                DataProfileNode dataProfileNode = (DataProfileNode)OuputProfileColumnsPanel.this.getTargetNode((PropertyModel)OuputProfileColumnsPanel.this._model, DataProfileNodeType.class);
                DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)dataProfileNode.getData();
                this._currentValue = dataProfileNodeType.getStatisticTable().getName();
                JTextField jTextField = (JTextField)jComponent;
                String string = jTextField.getText().trim();
                if (string.length() == 0) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_NAME_MISSING"), (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_ERROR_TITLE"), null);
                    bl = false;
                }
                if (bl && !StringUtils.isDoubleQuotedString(string)) {
                    string = string.toUpperCase();
                }
                if (bl && !TableNameValidator.validateTableName(string, null, this._context, true)) {
                    bl = false;
                }
                try {
                    if (this._currentValue != null && this._currentValue.compareTo(string) != 0 && !TableNameValidator.isTableNameUnique(this._context, string)) {
                        String string2 = MessageFormat.format(DataDialogsLrb.get("TABLE_VALIDATION_ERROR_DUPLICATE"), string);
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)DataDialogsLrb.get("TABLE_VALIDATION_ERROR_TITLE"), null);
                        bl = false;
                    }
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DataDialogsLrb.get("TABLE_VALIDATION_ERROR_TITLE"), (String)DataDialogsLrb.get("TABLE_VALIDATION_ERROR_SYSTEM_ERROR"), null);
                    bl = false;
                }
                if (!bl) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TableNameInputVerifier.this._textField.setText(TableNameInputVerifier.this._currentValue);
                        }
                    });
                } else {
                    OuputProfileColumnsPanel.this.setTableName(string);
                }
            }
            return bl;
        }
    }

    class CustomTableNameValidator
    extends KeyAdapter
    implements FocusListener {
        Context _context;
        boolean busy = false;
        TableNameInputVerifier _verifier;
        String oldName = "";

        public CustomTableNameValidator(TableNameInputVerifier tableNameInputVerifier, Context context) {
            this._context = context;
            this._verifier = tableNameInputVerifier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void validateName() {
            if (this.busy) {
                return;
            }
            try {
                this.busy = true;
                this._verifier.verify(OuputProfileColumnsPanel.this.jTextFieldName);
            }
            finally {
                this.busy = false;
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.oldName = OuputProfileColumnsPanel.this.jTextFieldName.getText();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (StringUtils.checkDataLossWithMsg(this._context, OuputProfileColumnsPanel.this.jTextFieldName.getText(), GraphLrb.get("VALIDATION_ISSUES_TITLE"))) {
                OuputProfileColumnsPanel.this.jTextFieldName.setText(this.oldName);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                this.validateName();
            }
        }
    }

    class AttributesTableModel
    extends GenericBaseTableModel {
        private Vector<AttributeType> _srcData;
        private boolean _writable = true;

        AttributesTableModel(Vector<AttributeType> vector) {
            this._srcData = new Vector(vector.size());
            this._srcData.addAll(vector);
            this.setColumnIdentifiers(OuputProfileColumnsPanel.this._columnNames);
            this.setRowCount(this._srcData.size());
            this.setColumnCount(2);
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.size() : 0;
        }

        public void setWritable(boolean bl) {
            this._writable = bl;
        }

        public Vector<AttributeType> getDataVector() {
            return this._srcData;
        }

        public void clearRows() {
            this._srcData.clear();
            this.setRowCount(0);
            this.fireTableDataChanged();
        }

        public void setValueAt(Object object, int n, int n2) {
        }

        public Object getValueAt(int n, int n2) {
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            AttributeType attributeType = this._srcData.get(n);
            String string = null;
            switch (n2) {
                case 0: {
                    string = attributeType.getName();
                    break;
                }
                case 1: {
                    string = attributeType.getDataType();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column when accessing items";
                    break;
                }
            }
            return string != null ? string : "";
        }

        public void removeSelectedRows(int[] nArray) {
            Vector<AttributeType> vector = new Vector<AttributeType>();
            AttributeType attributeType = null;
            for (int i = 0; i < nArray.length; ++i) {
                attributeType = this._srcData.elementAt(nArray[i]);
                vector.add(attributeType);
            }
            this._srcData.removeAll(vector);
            this.setRowCount(this._srcData.size());
            this.fireTableDataChanged();
        }

        public TableModel getModel() {
            return this;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

