/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.migration;

import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dmt.dataminer.navigator.DataminerNavigatorLrb;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.workflow.workflowImport.WorkflowImportException;
import oracle.dmt.dataminer.workflow.workflowImport.WorkflowLrb;
import oracle.dmt.dataminer.workflow.xmlschema.WorkflowProcess;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Version;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Migration {
    private static JAXBContext jaxbContext;
    private static Unmarshaller unmarshaller;
    private static Marshaller marshaller;
    private static Migration _instance;

    public static Migration getInstance() {
        if (_instance == null) {
            _instance = new Migration();
        }
        return _instance;
    }

    public WorkflowProcess migrate(Context context, String string) throws Exception {
        WorkflowProcess workflowProcess;
        block3: {
            String string2;
            ByteArrayInputStream byteArrayInputStream;
            workflowProcess = null;
            Document document = null;
            NodeList nodeList = null;
            NamedNodeMap namedNodeMap = null;
            Node node = null;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(byteArrayInputStream = new ByteArrayInputStream((string2 = string).getBytes("UTF-8")));
            nodeList = document.getElementsByTagName("WorkflowProcess");
            Node node2 = nodeList.item(0);
            namedNodeMap = node2.getAttributes();
            node = namedNodeMap.getNamedItem("Version");
            String string3 = node.getNodeValue();
            Version version = new Version(string3);
            if (!ConfigUtils.isCompatibleXmlSchemaVersion(context, version)) {
                String string4 = MessageFormat.format(WorkflowLrb.get("IMPORT_VERSION_INCOMPATIBLE_ERROR"), version);
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string4, (String)WorkflowLrb.get("CREATE_WORKFLOW_DIALOG_TITLE"), null);
                throw new WorkflowImportException(WorkflowLrb.get("IMPORT_VERSION_INCOMPATIBLE_ERROR"));
            }
            String string5 = string;
            try {
                Workflow.validateWorkflowXML(string5);
                StringReader stringReader = new StringReader(string5);
                Unmarshaller unmarshaller = this.createUnmarshaller();
                workflowProcess = (WorkflowProcess)unmarshaller.unmarshal((Reader)stringReader);
            }
            catch (SAXException sAXException) {
                String string6 = MessageFormat.format(DataminerNavigatorLrb.get("WORKFLOW_IMPORT_INVALID_CONFIRM"), sAXException.getLocalizedMessage());
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string6, (String)DataminerNavigatorLrb.get("WORKFLOW_IMPORT_TITLE"), null, (boolean)true)) break block3;
                StringReader stringReader = new StringReader(string5);
                Unmarshaller unmarshaller = this.createUnmarshaller();
                workflowProcess = (WorkflowProcess)unmarshaller.unmarshal((Reader)stringReader);
            }
        }
        return workflowProcess;
    }

    private Unmarshaller createUnmarshaller() throws JAXBException {
        if (unmarshaller == null) {
            unmarshaller = this.getJAXBContextInstance().createUnmarshaller();
        }
        return unmarshaller;
    }

    private Marshaller createMarshaller() throws JAXBException {
        if (marshaller == null) {
            marshaller = this.getJAXBContextInstance().createMarshaller();
        }
        return marshaller;
    }

    private JAXBContext getJAXBContextInstance() throws JAXBException {
        if (jaxbContext == null) {
            jaxbContext = JAXBContext.newInstance((String)"oracle.dmt.dataminer.workflow.xmlschema");
        }
        return jaxbContext;
    }

    static {
        _instance = null;
    }
}

