/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.math.BigInteger;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.MiningAlgorithms;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.codegen.CodeTemplate;
import oracle.dmt.dataminer.workflow.codegen.DatabaseObjectType;
import oracle.dmt.dataminer.workflow.codegen.ParameterizedSourceDefinitions;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.UnsupervisedBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionModelType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.ide.Context;
import oracle.javatools.util.Pair;
import oracle.javatools.util.Version;

public final class AnomalyDetectionBuildNode
extends UnsupervisedBuildNode {
    public static final String SVMSETTINGS = "svmSettings";
    public static final String SVMS_KERNEL_FUNCTION = "SVMS_KERNEL_FUNCTION";
    public static final String SVMS_CONV_TOLERANCE = "SVMS_CONV_TOLERANCE";
    public static final String SVMS_COMPLEXITY_FACTOR = "SVMS_COMPLEXITY_FACTOR";
    public static final String SVMS_ACTIVE_LEARNING = "SVMS_ACTIVE_LEARNING";
    public static final String SVMS_STD_DEV = "SVMS_STD_DEV";
    public static final String SVMS_KERNEL_CACHE_SIZE = "SVMS_KERNEL_CACHE_SIZE";
    public static final String SVMS_OUTLIER_RATE = "SVMS_OUTLIER_RATE";

    public AnomalyDetectionBuildNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public void initNewInstance(Context context) {
        super.initNewInstance(context);
        AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType = (AnomalyDetectionBuildNodeType)this.getData();
        AnomalyDetectionBuildNodeType.Models models = new AnomalyDetectionBuildNodeType.Models();
        anomalyDetectionBuildNodeType.setModels(models);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("ALGO_SUPPORT_VECTOR_MACHINES");
        List<String> list = WorkflowUtils.getNewModelNames(context, "ANOMALY_DETECTION", arrayList);
        int n = 0;
        ModelType modelType = null;
        modelType = this.createNewAnomalyModel(list.get(n), "", (String)arrayList.get(n++));
        modelType.setUseForOutput(true);
        this.addSVMOModel((AnomalyDetectionModelType)modelType);
        anomalyDetectionBuildNodeType.setStatus(NodeStatusType.INVALID);
    }

    public void addSVMOModel(AnomalyDetectionModelType anomalyDetectionModelType) {
        AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType = (AnomalyDetectionBuildNodeType)this.getData();
        AnomalyDetectionBuildNodeType.Models models = anomalyDetectionBuildNodeType.getModels();
        List list = models.getAnomalyDetectionModel();
        list.add(anomalyDetectionModelType);
    }

    public ModelType createNewAnomalyModel(String string, String string2, String string3) {
        ModelType modelType = super.createNewModel(string, string2, "ANOMALY_DETECTION", string3);
        return modelType;
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_ANOM_BUILD_NODE_NAME");
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    @Override
    protected boolean validateImpl(boolean bl, boolean bl2) {
        boolean bl3 = super.validate(bl);
        AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType = (AnomalyDetectionBuildNodeType)this.getData();
        if (anomalyDetectionBuildNodeType.getModels().getAnomalyDetectionModel().isEmpty()) {
            this.addMessage("BUILD_MISSING_MODELS", MessageEnumType.INCOMPLETE, new String[0]);
            bl3 = false;
        } else {
            AnomalyDetectionBuildNodeType.Models models;
            if (bl2) {
                this.setNodeReady();
            }
            if (!this.validateModels((models = anomalyDetectionBuildNodeType.getModels()).getAnomalyDetectionModel())) {
                bl3 = false;
            }
        }
        this.setState(bl3);
        if (bl) {
            this.validateChildren();
        }
        return bl3;
    }

    @Override
    public boolean validate(boolean bl) {
        return this.validateImpl(bl, true);
    }

    @Override
    public void setProperty(String string, Object object) {
        AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType = (AnomalyDetectionBuildNodeType)this.getData();
        if (string.equals(SVMSETTINGS)) {
            AnomalyDetectionBuildNodeType.Models models = anomalyDetectionBuildNodeType.getModels();
            List list = models.getAnomalyDetectionModel();
            if (object == null || !(object instanceof List)) {
                return;
            }
            List list2 = (List)object;
            if (list2.isEmpty()) {
                return;
            }
            String string2 = ((Property)list2.get(0)).getId();
            for (AnomalyDetectionModelType anomalyDetectionModelType : list) {
                if (!anomalyDetectionModelType.getId().equals(string2)) continue;
                AnomalyDetectionAlgoType anomalyDetectionAlgoType = anomalyDetectionModelType.getAnomalyDetectionAlgo();
                for (Property property : list2) {
                    if (property.getDescription().equals(SVMS_KERNEL_FUNCTION)) {
                        anomalyDetectionAlgoType.setSVMSKERNELFUNCTION((String)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_CONV_TOLERANCE)) {
                        anomalyDetectionAlgoType.setSVMSCONVTOLERANCE(((Double)property.getValue()).doubleValue());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_COMPLEXITY_FACTOR)) {
                        anomalyDetectionAlgoType.setSVMSCOMPLEXITYFACTOR((Double)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_ACTIVE_LEARNING)) {
                        anomalyDetectionAlgoType.setSVMSACTIVELEARNING((String)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_STD_DEV)) {
                        anomalyDetectionAlgoType.setSVMSSTDDEV((Double)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_KERNEL_CACHE_SIZE)) {
                        Object object2 = property.getValue();
                        if (object2 == null) {
                            anomalyDetectionAlgoType.setSVMSKERNELCACHESIZE(null);
                            continue;
                        }
                        BigInteger bigInteger = new BigInteger(object2.toString());
                        anomalyDetectionAlgoType.setSVMSKERNELCACHESIZE(bigInteger);
                        continue;
                    }
                    if (!property.getDescription().equals(SVMS_OUTLIER_RATE)) continue;
                    anomalyDetectionAlgoType.setSVMSOUTLIERRATE((Double)property.getValue());
                }
                break;
            }
        } else if (string.equals("modelAdded")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list3 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)anomalyDetectionBuildNodeType, modelType);
                if (list3.contains(modelType)) continue;
                MetaDataHelper.addModel((BuildNodeType)anomalyDetectionBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelRemoved")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list4 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)anomalyDetectionBuildNodeType, modelType);
                if (!list4.contains(modelType)) continue;
                MetaDataHelper.removeModel((BuildNodeType)anomalyDetectionBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelsRerun")) {
            Map map = (Map)object;
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType2 = (AnomalyDetectionBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)anomalyDetectionBuildNodeType2, string3);
                modelType.setStatus((ModelStatusType)map.get(string3));
            }
        } else if (string.equals("modelUseForOutput")) {
            if (object == null || !(object instanceof ArrayList)) {
                return;
            }
            List list = (List)object;
            AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType3 = (AnomalyDetectionBuildNodeType)this.getData();
            for (Pair pair : list) {
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)anomalyDetectionBuildNodeType3, (String)pair.getFirst());
                modelType.setUseForOutput(((Boolean)pair.getSecond()).booleanValue());
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(SVMSETTINGS)) {
            List list = (List)complexProperty.getData();
            ArrayList<Property> arrayList = new ArrayList<Property>(list.size());
            for (Property property : list) {
                String string = property.getId();
                String string2 = property.getDescription();
                Object object = this.getOldPropertyValue(string, string2);
                Property property2 = new Property(string, null, object, string2, null);
                arrayList.add(property2);
            }
            return arrayList;
        }
        if (complexProperty.getPropertyName().equals("modelsRerun")) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>(map.size());
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType = (AnomalyDetectionBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)anomalyDetectionBuildNodeType, string);
                hashMap.put(string, modelType.getStatus());
            }
            return hashMap;
        }
        if (complexProperty.getPropertyName().equals("modelUseForOutput")) {
            List list = (List)complexProperty.getData();
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            for (Pair pair : list) {
                String string = (String)pair.getFirst();
                AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType = (AnomalyDetectionBuildNodeType)this.getData();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)anomalyDetectionBuildNodeType, string);
                boolean bl = modelType.isUseForOutput();
                Pair pair2 = new Pair((Object)string, (Object)bl);
                arrayList.add(pair2);
            }
            return arrayList;
        }
        return super.getProperty(complexProperty);
    }

    private Object getOldPropertyValue(String string, String string2) {
        AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType = (AnomalyDetectionBuildNodeType)this.getData();
        ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)anomalyDetectionBuildNodeType, string);
        if (modelType == null) {
            return null;
        }
        if (modelType instanceof AnomalyDetectionModelType) {
            AnomalyDetectionAlgoType anomalyDetectionAlgoType = ((AnomalyDetectionModelType)modelType).getAnomalyDetectionAlgo();
            if (string2.equals(SVMS_KERNEL_FUNCTION)) {
                return anomalyDetectionAlgoType.getSVMSKERNELFUNCTION();
            }
            if (string2.equals(SVMS_CONV_TOLERANCE)) {
                return anomalyDetectionAlgoType.getSVMSCONVTOLERANCE();
            }
            if (string2.equals(SVMS_COMPLEXITY_FACTOR)) {
                return anomalyDetectionAlgoType.getSVMSCOMPLEXITYFACTOR();
            }
            if (string2.equals(SVMS_ACTIVE_LEARNING)) {
                return anomalyDetectionAlgoType.getSVMSACTIVELEARNING();
            }
            if (string2.equals(SVMS_STD_DEV)) {
                return anomalyDetectionAlgoType.getSVMSSTDDEV();
            }
            if (string2.equals(SVMS_KERNEL_CACHE_SIZE)) {
                return anomalyDetectionAlgoType.getSVMSKERNELCACHESIZE();
            }
            if (string2.equals(SVMS_OUTLIER_RATE)) {
                return anomalyDetectionAlgoType.getSVMSOUTLIERRATE();
            }
        }
        return null;
    }

    @Override
    public Object getProperty(String string) {
        return super.getProperty(string);
    }

    @Override
    public MiningFunctionType getMiningFunctionTypeSupported() {
        return MiningFunctionType.ANOMALY_DETECTION;
    }

    @Override
    public MiningFunctionType getMiningFunctionType() {
        return MiningFunctionType.ANOMALY_DETECTION;
    }

    @Override
    public AttributeType getTargetAttribute() {
        return null;
    }

    @Override
    public List<RefModelType> getSVMLinearModels() throws Exception {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType = (AnomalyDetectionBuildNodeType)this.getData();
        List list = anomalyDetectionBuildNodeType.getModels().getAnomalyDetectionModel();
        MiningFunctionType miningFunctionType = MiningFunctionType.ANOMALY_DETECTION;
        String string = anomalyDetectionBuildNodeType.getId();
        Connection connection = Connections.getSharedConnection(this.getContext());
        String string2 = Connections.getUserAccountName(this.getContext());
        string2 = StringUtils.isDoubleQuotedString(string2) ? StringUtils.trimDoubleQuotes(string2) : string2.toUpperCase();
        List<RefModelType> list2 = MetaDataHelper.createRefModelTypeCollection(miningFunctionType, list, string, string2);
        for (AnomalyDetectionModelType anomalyDetectionModelType : list) {
            String string3 = anomalyDetectionModelType.getAnomalyDetectionAlgo().getSVMSKERNELFUNCTION();
            if (string3 == null || string3.compareTo("SVMS_LINEAR") != 0) continue;
            for (RefModelType refModelType : list2) {
                if (refModelType.getName().compareTo(anomalyDetectionModelType.getName()) != 0 || refModelType.getSchema().compareTo(string2) != 0) continue;
                arrayList.add(refModelType);
            }
        }
        return arrayList;
    }

    @Override
    public String getHelpTopic() {
        return "anomaly_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_ANOMALY_DETECTION_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_ANOMALY_DETECTION_ICON"));
    }

    private String generateBuildSettingsCode(Context context, AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType, AnomalyDetectionModelType anomalyDetectionModelType, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  execSQL('CREATE TABLE '||v_build_setting||' (SETTING_NAME VARCHAR2(30), SETTING_VALUE VARCHAR2(128))'); \n");
        AnomalyDetectionModelType anomalyDetectionModelType2 = anomalyDetectionModelType;
        if (anomalyDetectionModelType2.getAnomalyDetectionAlgo().getSVMSACTIVELEARNING() != null) {
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_ACTIVE_LEARNING||''', ''" + anomalyDetectionModelType2.getAnomalyDetectionAlgo().getSVMSACTIVELEARNING() + "'')'); \n");
        }
        if (anomalyDetectionModelType2.getAnomalyDetectionAlgo().getSVMSCOMPLEXITYFACTOR() != null) {
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_COMPLEXITY_FACTOR||''', ''" + anomalyDetectionModelType2.getAnomalyDetectionAlgo().getSVMSCOMPLEXITYFACTOR() + "'')'); \n");
        }
        stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_CONV_TOLERANCE||''', ''" + anomalyDetectionModelType2.getAnomalyDetectionAlgo().getSVMSCONVTOLERANCE() + "'')'); \n");
        if (anomalyDetectionModelType2.getAnomalyDetectionAlgo().getSVMSKERNELCACHESIZE() != null) {
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_KERNEL_CACHE_SIZE||''', ''" + anomalyDetectionModelType2.getAnomalyDetectionAlgo().getSVMSKERNELCACHESIZE() + "'')'); \n");
        }
        if (anomalyDetectionModelType2.getAnomalyDetectionAlgo().getSVMSKERNELFUNCTION() != null) {
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_KERNEL_FUNCTION||''', ''" + anomalyDetectionModelType2.getAnomalyDetectionAlgo().getSVMSKERNELFUNCTION() + "'')'); \n");
        }
        if (anomalyDetectionModelType2.getAnomalyDetectionAlgo().getSVMSOUTLIERRATE() != null) {
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_OUTLIER_RATE||''', ''" + anomalyDetectionModelType2.getAnomalyDetectionAlgo().getSVMSOUTLIERRATE() + "'')'); \n");
        }
        if (anomalyDetectionModelType2.getAnomalyDetectionAlgo().getSVMSSTDDEV() != null) {
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_STD_DEV||''', ''" + anomalyDetectionModelType2.getAnomalyDetectionAlgo().getSVMSSTDDEV() + "'')'); \n");
        }
        stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ALGO_NAME||''', '''||DBMS_DATA_MINING.ALGO_SUPPORT_VECTOR_MACHINES||''')'); \n");
        if (bl) {
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.PREP_AUTO||''', '''||DBMS_DATA_MINING.PREP_AUTO_ON||''')'); \n");
        } else {
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.PREP_AUTO||''', '''||DBMS_DATA_MINING.PREP_AUTO_OFF||''')'); \n");
        }
        return stringBuffer.toString();
    }

    private String generateBuildCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, AnomalyDetectionModelType anomalyDetectionModelType) throws Exception {
        AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType = (AnomalyDetectionBuildNodeType)this.getData();
        Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
        String string = CodeTemplate.getInstance().getTemplate("workflow_generic_build_model.sql");
        string = CodeTemplate.updateBodyTemplate(string, "<MINING_FUNCTION>", "DBMS_DATA_MINING.CLASSIFICATION");
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = this.generateDataUsageCode(version, (BuildNodeType)anomalyDetectionBuildNodeType, (ModelType)anomalyDetectionModelType, null, stringBuffer, stringBuffer2);
        String string2 = this.generateBuildSettingsCode(context, anomalyDetectionBuildNodeType, anomalyDetectionModelType, bl);
        String string3 = Connections.getUserAccountName(this.getContext());
        String string4 = anomalyDetectionModelType.getName();
        parameterizedSourceDefinitions.addParameterizedSourceDefinition(this, string3, string4, DatabaseObjectType.MODEL);
        String string5 = parameterizedSourceDefinitions.getParmNameWithAmpersand(this, string3, string4, DatabaseObjectType.MODEL);
        String string6 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, true);
        string = CodeTemplate.updateBodyTemplate(string, "<PARALLEL_HINT>", string6);
        string = CodeTemplate.updateBodyTemplate(string, "<DATA_USAGE_ATTRIBUTES>", stringBuffer.toString());
        string = CodeTemplate.updateBodyTemplate(string, "<DATA_USAGE_TRANSFORMATIONS>", stringBuffer2.toString());
        string = CodeTemplate.updateBodyTemplate(string, "<BUILD_SETTING>", string2);
        string = CodeTemplate.updateBodyTemplate(string, "<MODEL_NAME_PARAM>", string5);
        string = CodeTemplate.updateBodyTemplate(string, "<BUILD_MODEL_ID>", anomalyDetectionModelType.getId());
        string = CodeTemplate.updateBodyTemplate(string, "<BUILD_MODEL_TYPE>", MiningAlgorithms.SUPPORT_VECTOR_MACHINE.toString());
        return string;
    }

    @Override
    public String generateCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, String string) throws Exception {
        String string2 = super.generateCode(context, parameterizedSourceDefinitions, string);
        AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType = (AnomalyDetectionBuildNodeType)this.getData();
        StringBuffer stringBuffer = new StringBuffer();
        for (AnomalyDetectionModelType anomalyDetectionModelType : anomalyDetectionBuildNodeType.getModels().getAnomalyDetectionModel()) {
            stringBuffer.append(this.generateBuildCode(context, parameterizedSourceDefinitions, anomalyDetectionModelType));
        }
        string2 = CodeTemplate.updateBodyTemplate(string2, "<BUILD_MODELS>", stringBuffer.toString());
        return string2;
    }
}

