/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import ilog.views.sdm.model.IlvSDMNode;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.MiningAlgorithms;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.codegen.CodeTemplate;
import oracle.dmt.dataminer.workflow.codegen.DatabaseObjectType;
import oracle.dmt.dataminer.workflow.codegen.ParameterizedSourceDefinitions;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.GeneralLink;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.UnsupervisedBuildNode;
import oracle.dmt.dataminer.workflow.preferences.AssociationModelBuildPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.AprioriAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.AprioriModelType;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.BuildDataSource;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.InputMiningDataType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Pair;
import oracle.javatools.util.Version;

public final class AssociationBuildNode
extends UnsupervisedBuildNode {
    public static final String SETTINGS = "settings";
    public static final String ASSO_MAX_RULE_LENGTH = "ASSO_MAX_RULE_LENGTH";
    public static final String ASSO_MIN_CONFIDENCE = "ASSO_MIN_CONFIDENCE";
    public static final String ASSO_MIN_SUPPORT = "ASSO_MIN_SUPPORT";
    public static final String ITEM_ID = "ITEM_ID";
    public static final String ITEM_VALUE = "ITEM_VALUE";
    private static final String CASE_ID_ATTRIBUTES = "CASE_ID_ATTRIBUTES";
    private static final String ITEM_ID_INVALID = "ITEM_ID_INVALID";
    private static final String ITEM_VALUE_INVALID = "ITEM_VALUE_INVALID";
    private static Preferences _p = Preferences.getPreferences();
    private AssociationModelBuildPreferencesPanelSettings AssocBuildPref = AssociationModelBuildPreferencesPanelSettings.getInstance((PropertyStorage)_p);

    public AssociationBuildNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public void initNewInstance(Context context) {
        super.initNewInstance(context);
        AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.getData();
        AssociationBuildNodeType.Models models = new AssociationBuildNodeType.Models();
        associationBuildNodeType.setModels(models);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("ALGO_APRIORI_ASSOCIATION_RULES");
        List<String> list = WorkflowUtils.getNewModelNames(context, "ASSOCIATION", arrayList);
        int n = 0;
        ModelType modelType = null;
        modelType = this.createNewAprioriModel(list.get(n), "", (String)arrayList.get(n));
        modelType.setUseForOutput(true);
        this.addModel((AprioriModelType)modelType);
        associationBuildNodeType.setMaxDistinctItemValue(BigInteger.valueOf(this.AssocBuildPref.getMaxDistinctItemValue()));
        associationBuildNodeType.setStatus(NodeStatusType.INVALID);
    }

    public void addModel(AprioriModelType aprioriModelType) {
        AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.getData();
        AssociationBuildNodeType.Models models = associationBuildNodeType.getModels();
        List list = models.getAprioriModel();
        list.add(aprioriModelType);
    }

    public ModelType createNewAprioriModel(String string, String string2, String string3) {
        ModelType modelType = super.createNewModel(string, string2, "ASSOCIATION", string3);
        modelType.getInputMiningData().setDataUsage(InputMiningDataType.MANUAL);
        modelType.getInputMiningData().setMiningUsage(InputMiningDataType.MANUAL);
        return modelType;
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_ASSOC_BUILD_NODE_NAME");
    }

    private void handleBuildDataSourceConnected(Node node) {
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        BuildDataSource buildDataSource = buildNodeType.getBuildDataSource();
        if (buildDataSource == null) {
            buildDataSource = new BuildDataSource();
            buildDataSource.setSourceId(node.getMetadataId());
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "buildDataSource", buildDataSource);
        }
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        List<GeneralLink> list = this.getModel().findLinksToNode((IlvSDMNode)this);
        for (GeneralLink generalLink : list) {
            String string = GeneralLink.generateLinkName(generalLink.getFrom(), generalLink.getTo());
            odmrSDMUndoFilter.prepareUndo(generalLink, this.getContext(), "label", string);
        }
        this.handleBuildDataSourceConnected(node);
        this.validate(false);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    private boolean validateCaseAttributes(List<AttributeType> list) {
        AttributeType attributeType;
        boolean bl = true;
        boolean bl2 = true;
        CaseAttributes caseAttributes = ((BuildNodeType)this.getData()).getCaseAttributes();
        List list2 = caseAttributes.getAttribute();
        if (list2.size() == 0) {
            this.addMessage("BUILD_NO_TRANSACTION_ID", MessageEnumType.WARNING, new String[0]);
            return false;
        }
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>(list2.size());
        ArrayList<AttributeType> arrayList2 = new ArrayList<AttributeType>(list2.size());
        for (AttributeType object : list2) {
            attributeType = (AttributeType)MetaDataHelper.copyMetadataObject(object);
            arrayList.add(attributeType);
            AttributeType attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(object);
            arrayList2.add(attributeType2);
            if (!attributeType2.getStatus().equals((Object)AttributeStatus.INVALID)) continue;
            bl = false;
        }
        for (AttributeType attributeType3 : arrayList) {
            attributeType = null;
            if (list != null) {
                attributeType = this.findCompatibleAttribute(attributeType3, list);
            }
            if (null == attributeType) {
                attributeType3.setStatus(AttributeStatus.INVALID);
                this.addMessage("BUILD_INVALID_CASEIDS", MessageEnumType.INCOMPLETE, new String[0]);
                bl2 = false;
                continue;
            }
            attributeType3.setStatus(AttributeStatus.VALID);
        }
        if (bl2 != bl) {
            ComplexProperty complexProperty = new ComplexProperty(CASE_ID_ATTRIBUTES, arrayList);
            complexProperty.setOldData(arrayList2);
            complexProperty.setForceUpdate(true);
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), complexProperty);
        }
        return bl2;
    }

    protected boolean validateItemId(List<AttributeType> list) {
        Object object;
        AttributeStatus attributeStatus;
        boolean bl = true;
        AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.getData();
        AttributeType attributeType = associationBuildNodeType.getItemID();
        AttributeStatus attributeStatus2 = attributeStatus = attributeType == null ? null : attributeType.getStatus();
        if (attributeType != null) {
            object = null;
            if (list != null) {
                object = this.findCompatibleAttribute(attributeType, list);
            }
            if (null == object) {
                attributeType.setStatus(AttributeStatus.INVALID);
                this.addMessage("BUILD_INVALID_ITEM_ID", MessageEnumType.WARNING, new String[0]);
                bl = false;
            } else {
                attributeType.setStatus(AttributeStatus.VALID);
            }
        } else {
            this.addMessage("BUILD_NO_ITEM_ID", MessageEnumType.INCOMPLETE, new String[0]);
            bl = false;
        }
        if (attributeType != null && !attributeType.getStatus().equals((Object)attributeStatus)) {
            object = new ComplexProperty(ITEM_ID_INVALID, attributeType.getStatus());
            ((ComplexProperty)object).setOldData(attributeStatus);
            ((ComplexProperty)object).setForceUpdate(true);
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), (ComplexProperty)object);
        }
        return bl;
    }

    protected boolean validateItemValue(List<AttributeType> list) {
        Object object;
        AttributeStatus attributeStatus;
        boolean bl = true;
        AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.getData();
        AttributeType attributeType = associationBuildNodeType.getItemValue();
        AttributeStatus attributeStatus2 = attributeStatus = attributeType == null ? null : attributeType.getStatus();
        if (attributeType != null) {
            object = null;
            if (list != null) {
                object = this.findCompatibleAttribute(attributeType, list);
            }
            if (null == object) {
                attributeType.setStatus(AttributeStatus.INVALID);
                this.addMessage("BUILD_INVALID_ITEM_VALUE", MessageEnumType.WARNING, new String[0]);
                bl = false;
            } else {
                attributeType.setStatus(AttributeStatus.VALID);
            }
        }
        if (attributeType != null && !attributeType.getStatus().equals((Object)attributeStatus)) {
            object = new ComplexProperty(ITEM_VALUE_INVALID, attributeType.getStatus());
            ((ComplexProperty)object).setOldData(attributeStatus);
            ((ComplexProperty)object).setForceUpdate(true);
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), (ComplexProperty)object);
        }
        return bl;
    }

    @Override
    protected boolean validateImpl(boolean bl, boolean bl2) {
        super.clearMessages();
        boolean bl3 = true;
        AbstractDataNode abstractDataNode = this.findBuildDataNode(this.getModel());
        AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.getData();
        if (associationBuildNodeType.getModels().getAprioriModel().isEmpty()) {
            this.addMessage("BUILD_MISSING_MODELS", MessageEnumType.INCOMPLETE, new String[0]);
            bl3 = false;
        } else {
            Attributes attributes;
            if (bl2) {
                this.setNodeReady();
            }
            List list = null;
            if (abstractDataNode != null) {
                attributes = ((DataProvider)abstractDataNode).getAttributes();
                list = attributes.getAttribute();
            }
            if (!this.validateCaseAttributes(list)) {
                bl3 = false;
            }
            if (!this.validateItemId(list)) {
                bl3 = false;
            }
            if (!this.validateItemValue(list)) {
                bl3 = false;
            }
            if (!bl3) {
                attributes = associationBuildNodeType.getModels();
                for (ModelType modelType : attributes.getAprioriModel()) {
                    this.addMessage("BUILD_INVALID_MODEL", MessageEnumType.WARNING, modelType.getName());
                }
            }
        }
        this.setState(bl3);
        if (bl) {
            this.validateChildren();
        }
        return bl3;
    }

    @Override
    public boolean validate(boolean bl) {
        return this.validateImpl(bl, true);
    }

    @Override
    public void setProperty(String string, Object object) {
        AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.getData();
        if (string.equals(ITEM_ID)) {
            associationBuildNodeType.setItemID((AttributeType)object);
        } else if (string.equals(ITEM_VALUE)) {
            associationBuildNodeType.setItemValue((AttributeType)object);
        }
        if (string.equals(SETTINGS)) {
            AssociationBuildNodeType.Models models = associationBuildNodeType.getModels();
            List list = models.getAprioriModel();
            if (object == null || !(object instanceof List)) {
                return;
            }
            List list2 = (List)object;
            if (list2.isEmpty()) {
                return;
            }
            String string2 = ((Property)list2.get(0)).getId();
            for (AprioriModelType aprioriModelType : list) {
                if (!aprioriModelType.getId().equals(string2)) continue;
                for (Property property : list2) {
                    AprioriAlgoType aprioriAlgoType = aprioriModelType.getAprioriAlgo();
                    if (aprioriAlgoType == null) continue;
                    if (property.getDescription().equals(ASSO_MAX_RULE_LENGTH)) {
                        aprioriAlgoType.setASSOMAXRULELENGTH(((Integer)property.getValue()).intValue());
                        continue;
                    }
                    if (property.getDescription().equals(ASSO_MIN_CONFIDENCE)) {
                        aprioriAlgoType.setASSOMINCONFIDENCE(((Double)property.getValue()).doubleValue());
                        continue;
                    }
                    if (!property.getDescription().equals(ASSO_MIN_SUPPORT)) continue;
                    aprioriAlgoType.setASSOMINSUPPORT(((Double)property.getValue()).doubleValue());
                }
                break;
            }
        } else if (string.equals("modelAdded")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list3 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)associationBuildNodeType, modelType);
                if (list3.contains(modelType)) continue;
                MetaDataHelper.addModel((BuildNodeType)associationBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelRemoved")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list4 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)associationBuildNodeType, modelType);
                if (!list4.contains(modelType)) continue;
                MetaDataHelper.removeModel((BuildNodeType)associationBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelsRerun")) {
            Map map = (Map)object;
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            AssociationBuildNodeType associationBuildNodeType2 = (AssociationBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)associationBuildNodeType2, string3);
                modelType.setStatus((ModelStatusType)map.get(string3));
            }
        } else if (string.equals("modelUseForOutput")) {
            if (object == null || !(object instanceof ArrayList)) {
                return;
            }
            List list = (List)object;
            AssociationBuildNodeType associationBuildNodeType3 = (AssociationBuildNodeType)this.getData();
            for (Pair pair : list) {
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)associationBuildNodeType3, (String)pair.getFirst());
                modelType.setUseForOutput(((Boolean)pair.getSecond()).booleanValue());
            }
        } else if (string.equals(CASE_ID_ATTRIBUTES)) {
            List list = (List)object;
            CaseAttributes caseAttributes = associationBuildNodeType.getCaseAttributes();
            List list5 = caseAttributes.getAttribute();
            list5.clear();
            list5.addAll(list);
        } else if (string.equals(ITEM_ID_INVALID)) {
            AttributeType attributeType = associationBuildNodeType.getItemID();
            if (attributeType != null) {
                attributeType.setStatus((AttributeStatus)object);
            }
        } else if (string.equals(ITEM_VALUE_INVALID)) {
            AttributeType attributeType = associationBuildNodeType.getItemValue();
            if (attributeType != null) {
                attributeType.setStatus((AttributeStatus)object);
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(CASE_ID_ATTRIBUTES)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(ITEM_ID_INVALID)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(ITEM_VALUE_INVALID)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(SETTINGS)) {
            List list = (List)complexProperty.getData();
            ArrayList<Property> arrayList = new ArrayList<Property>(list.size());
            for (Property property : list) {
                String string = property.getId();
                String string2 = property.getDescription();
                Object object = this.getOldPropertyValue(string, string2);
                Property property2 = new Property(string, null, object, string2, null);
                arrayList.add(property2);
            }
            return arrayList;
        }
        if (complexProperty.getPropertyName().equals("modelsRerun")) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>(map.size());
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)associationBuildNodeType, string);
                hashMap.put(string, modelType.getStatus());
            }
            return hashMap;
        }
        if (complexProperty.getPropertyName().equals("modelUseForOutput")) {
            List list = (List)complexProperty.getData();
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            for (Pair pair : list) {
                String string = (String)pair.getFirst();
                AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.getData();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)associationBuildNodeType, string);
                boolean bl = modelType.isUseForOutput();
                Pair pair2 = new Pair((Object)string, (Object)bl);
                arrayList.add(pair2);
            }
            return arrayList;
        }
        return super.getProperty(complexProperty);
    }

    private Object getOldPropertyValue(String string, String string2) {
        AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.getData();
        ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)associationBuildNodeType, string);
        if (modelType == null) {
            return null;
        }
        if (modelType instanceof AprioriModelType) {
            AprioriAlgoType aprioriAlgoType = ((AprioriModelType)modelType).getAprioriAlgo();
            if (string2.equals(ASSO_MAX_RULE_LENGTH)) {
                return aprioriAlgoType.getASSOMAXRULELENGTH();
            }
            if (string2.equals(ASSO_MIN_CONFIDENCE)) {
                return aprioriAlgoType.getASSOMINCONFIDENCE();
            }
            if (string2.equals(ASSO_MIN_SUPPORT)) {
                return aprioriAlgoType.getASSOMINSUPPORT();
            }
        }
        return null;
    }

    @Override
    public Object getProperty(String string) {
        AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.getData();
        if (string.equals(ITEM_ID)) {
            return associationBuildNodeType.getItemID();
        }
        if (string.equals(ITEM_VALUE)) {
            return associationBuildNodeType.getItemValue();
        }
        if (string.equals(ITEM_ID_INVALID)) {
            AttributeType attributeType = associationBuildNodeType.getItemID();
            return attributeType == null ? null : attributeType.getStatus();
        }
        if (string.equals(ITEM_VALUE_INVALID)) {
            AttributeType attributeType = associationBuildNodeType.getItemValue();
            return attributeType == null ? null : attributeType.getStatus();
        }
        return super.getProperty(string);
    }

    @Override
    public MiningFunctionType getMiningFunctionTypeSupported() {
        return MiningFunctionType.ASSOCIATION;
    }

    @Override
    public MiningFunctionType getMiningFunctionType() {
        return MiningFunctionType.ASSOCIATION;
    }

    @Override
    public AttributeType getTargetAttribute() {
        return null;
    }

    @Override
    public List<RefModelType> getSVMLinearModels() throws Exception {
        return null;
    }

    @Override
    public String getHelpTopic() {
        return "association_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_ASSOCIATION_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_ASSOCIATION_ICON"));
    }

    @Override
    public void refactorAttributes(Node node, Map<String, AttributeType> map) {
        if (!map.isEmpty()) {
            AttributeType attributeType;
            CaseAttributes caseAttributes;
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.getData();
            AttributeType attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(associationBuildNodeType.getItemID());
            AttributeType attributeType3 = map.get(attributeType2.getName());
            if (attributeType3 != null) {
                attributeType2.setName(attributeType3.getName());
                attributeType2.setDataType(attributeType3.getDataType());
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), ITEM_ID, attributeType2);
            }
            if (associationBuildNodeType.getItemValue() != null && (caseAttributes = map.get((attributeType = (AttributeType)MetaDataHelper.copyMetadataObject(associationBuildNodeType.getItemValue())).getName())) != null) {
                attributeType.setName(caseAttributes.getName());
                attributeType.setDataType(caseAttributes.getDataType());
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), ITEM_VALUE, attributeType);
            }
            boolean bl = false;
            caseAttributes = MetaDataHelper.copyCaseAttributes(associationBuildNodeType.getCaseAttributes());
            List list = caseAttributes.getAttribute();
            for (AttributeType attributeType4 : list) {
                AttributeType attributeType5 = map.get(attributeType4.getName());
                if (attributeType5 == null) continue;
                bl = true;
                attributeType4.setName(attributeType5.getName());
                attributeType4.setDataType(attributeType5.getDataType());
            }
            if (bl) {
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "caseAttributes", caseAttributes);
            }
        }
    }

    private String generateBuildSettingsCode(Context context, AssociationBuildNodeType associationBuildNodeType, AprioriModelType aprioriModelType, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  execSQL('CREATE TABLE '||v_build_setting||' (SETTING_NAME VARCHAR2(30), SETTING_VALUE VARCHAR2(128))'); \n");
        AprioriModelType aprioriModelType2 = aprioriModelType;
        stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ASSO_MAX_RULE_LENGTH||''', ''" + aprioriModelType2.getAprioriAlgo().getASSOMAXRULELENGTH() + "'')'); \n");
        stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ASSO_MIN_CONFIDENCE||''', ''" + aprioriModelType2.getAprioriAlgo().getASSOMINCONFIDENCE() + "'')'); \n");
        stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ASSO_MIN_SUPPORT||''', ''" + aprioriModelType2.getAprioriAlgo().getASSOMINSUPPORT() + "'')'); \n");
        AttributeType attributeType = associationBuildNodeType.getItemID();
        stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ODMS_ITEM_ID_COLUMN_NAME||''', ''" + StringUtils.addDoubleQuotes(StringUtils.trimDoubleQuotes(attributeType.getName())) + "'')'); \n");
        AttributeType attributeType2 = associationBuildNodeType.getItemValue();
        if (attributeType2 != null) {
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ODMS_ITEM_VALUE_COLUMN_NAME||''', ''" + StringUtils.addDoubleQuotes(StringUtils.trimDoubleQuotes(attributeType2.getName())) + "'')'); \n");
        }
        if (bl) {
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.PREP_AUTO||''', '''||DBMS_DATA_MINING.PREP_AUTO_ON||''')'); \n");
        } else {
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.PREP_AUTO||''', '''||DBMS_DATA_MINING.PREP_AUTO_OFF||''')'); \n");
        }
        return stringBuffer.toString();
    }

    private String generateBuildCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, AprioriModelType aprioriModelType) throws Exception {
        AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.getData();
        Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
        String string = CodeTemplate.getInstance().getTemplate("workflow_generic_build_model.sql");
        string = CodeTemplate.updateBodyTemplate(string, "<MINING_FUNCTION>", "DBMS_DATA_MINING.ASSOCIATION");
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = this.generateDataUsageCode(version, associationBuildNodeType, (ModelType)aprioriModelType, null, stringBuffer, stringBuffer2);
        String string2 = this.generateBuildSettingsCode(context, associationBuildNodeType, aprioriModelType, bl);
        String string3 = Connections.getUserAccountName(this.getContext());
        String string4 = aprioriModelType.getName();
        parameterizedSourceDefinitions.addParameterizedSourceDefinition(this, string3, string4, DatabaseObjectType.MODEL);
        String string5 = parameterizedSourceDefinitions.getParmNameWithAmpersand(this, string3, string4, DatabaseObjectType.MODEL);
        String string6 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, true);
        string = CodeTemplate.updateBodyTemplate(string, "<PARALLEL_HINT>", string6);
        string = CodeTemplate.updateBodyTemplate(string, "<DATA_USAGE_ATTRIBUTES>", stringBuffer.toString());
        string = CodeTemplate.updateBodyTemplate(string, "<DATA_USAGE_TRANSFORMATIONS>", stringBuffer2.toString());
        string = CodeTemplate.updateBodyTemplate(string, "<BUILD_SETTING>", string2);
        string = CodeTemplate.updateBodyTemplate(string, "<MODEL_NAME_PARAM>", string5);
        string = CodeTemplate.updateBodyTemplate(string, "<BUILD_MODEL_ID>", aprioriModelType.getId());
        string = CodeTemplate.updateBodyTemplate(string, "<BUILD_MODEL_TYPE>", MiningAlgorithms.APRIORI.toString());
        return string;
    }

    protected boolean generateDataUsageCode(Version version, AssociationBuildNodeType associationBuildNodeType, ModelType modelType, AttributeType attributeType, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        stringBuffer.setLength(0);
        stringBuffer2.setLength(0);
        String string = "        ";
        AttributeType attributeType2 = associationBuildNodeType.getItemID();
        if (ConfigUtils.isDatabaseVersion(DBVersions.V11_2_0_3, version, true)) {
            stringBuffer.append(string + StringUtils.addDoubleQuotes(attributeType2.getName()));
        } else {
            stringBuffer.append(string + "TO_CHAR(" + StringUtils.addDoubleQuotes(attributeType2.getName()) + ") " + StringUtils.addDoubleQuotes(attributeType2.getName()));
        }
        AttributeType attributeType3 = associationBuildNodeType.getItemValue();
        if (attributeType3 != null) {
            stringBuffer.append(",\n");
            stringBuffer.append(string + StringUtils.addDoubleQuotes(attributeType3.getName()));
        }
        return false;
    }

    @Override
    public String generateCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, String string) throws Exception {
        String string2 = super.generateCode(context, parameterizedSourceDefinitions, string);
        AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.getData();
        StringBuffer stringBuffer = new StringBuffer();
        for (AprioriModelType aprioriModelType : associationBuildNodeType.getModels().getAprioriModel()) {
            stringBuffer.append(this.generateBuildCode(context, parameterizedSourceDefinitions, aprioriModelType));
        }
        string2 = CodeTemplate.updateBodyTemplate(string2, "<BUILD_MODELS>", stringBuffer.toString());
        return string2;
    }
}

