/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeGenLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeTemplate;
import oracle.dmt.dataminer.workflow.codegen.ParameterizedSourceDefinitions;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTextNode;
import oracle.dmt.dataminer.workflow.model.ApplyChainNode;
import oracle.dmt.dataminer.workflow.model.DataConsumer;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.model.SampleSettingsProperties;
import oracle.dmt.dataminer.workflow.preferences.BuildTextPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.preferences.CacheSettingsPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.LexerType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTextTransformedSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ResultType;
import oracle.dmt.dataminer.workflow.xmlschema.SampleSettings;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.dmt.dataminer.workflow.xmlschema.TextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationOutputAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationTokenType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributesType;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Version;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public final class BuildTextNode
extends AbstractTextNode
implements SampleSettingsProperties,
ApplyChainNode,
DataConsumer {
    public static final String SAMPLE_SETTINGS = "sampleSize";
    public static final String SOURCE_COLUMNS = "sourceColumns";
    public static final String ADD_COLUMNS = "addColumns";
    public static final String REMOVE_COLUMNS = "removeColumns";
    public static final String EDIT_STOPLISTS = "editStoplists";
    public static final String ADD_STOPLIST = "addStoplist";
    public static final String EDIT_STOPLIST = "editStoplist";
    public static final String REMOVE_STOPLIST = "removeStoplist";
    public static final String ALL_TRANSFORMATION_NODE_COLUMNS = "allXfomNodeColumns";
    public static final String EDIT_COLUMN = "editColumn";
    public static final String EDIT_COLUMNS = "editColumns";
    public static final String TEXT_TABLE = "TextTable";

    @Override
    public void refactorForApply() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refactor(Node node, boolean bl) throws Exception {
        List list;
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        BuildTextNodeType buildTextNodeType = (BuildTextNodeType)this.getData();
        TransformedAttributesType transformedAttributesType = null;
        if (buildTextNodeType.getTransformedAttributes() != null && (list = (transformedAttributesType = (TransformedAttributesType)MetaDataHelper.copyMetadataObject(buildTextNodeType.getTransformedAttributes())).getMapTextTransformedSource()) != null && !list.isEmpty()) {
            Connection connection = null;
            try {
                connection = Connections.getSharedConnection(this.getContext());
                for (MapTextTransformedSourceType mapTextTransformedSourceType : list) {
                    TextTransformationType.Theme theme;
                    String string = DatabaseMetadataUtils.createUniqueTableName("ODMR$", connection, "_PL");
                    String string2 = DatabaseMetadataUtils.createUniqueTableName("ODMR$", connection, "_FT");
                    TransformationTokenType transformationTokenType = mapTextTransformedSourceType.getKey().getTransformationElement().getToken();
                    if (transformationTokenType != null) {
                        transformationTokenType.getToken().setPolicy(string);
                        theme = new ResultType();
                        theme.setCreationDate(null);
                        theme.setName(string2);
                        transformationTokenType.getToken().setStatisticTable((ResultType)theme);
                        transformationTokenType.getToken().setFeatureTable(null);
                        transformationTokenType.getToken().getLexer().setName(null);
                        continue;
                    }
                    theme = mapTextTransformedSourceType.getKey().getTransformationElement().getTheme();
                    if (theme == null) continue;
                    theme.getToken().setPolicy(string);
                    ResultType resultType = new ResultType();
                    resultType.setCreationDate(null);
                    resultType.setName(string2);
                    theme.getToken().setStatisticTable(resultType);
                    theme.getToken().setFeatureTable(null);
                    theme.getToken().getLexer().setName(null);
                }
            }
            catch (Exception exception) {
                Logger.getLogger(BuildTextNode.class.getName()).log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
        if (transformedAttributesType != null) {
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), EDIT_COLUMNS, transformedAttributesType);
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        }
        super.refactor(node, bl);
    }

    @Override
    public void refactorAttributes(Node node, Map<String, AttributeType> map) {
        Object object;
        TransformationSourceAttributes transformationSourceAttributes;
        List list;
        TransformationSourceAttributes transformationSourceAttributes2;
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        BuildTextNodeType buildTextNodeType = (BuildTextNodeType)this.getData();
        CaseAttributes caseAttributes = null;
        if (!buildTextNodeType.getCaseAttributes().getAttribute().isEmpty()) {
            transformationSourceAttributes2 = null;
            list = (AttributeType)buildTextNodeType.getCaseAttributes().getAttribute().get(0);
            transformationSourceAttributes = map.get(list.getName());
            if (!(transformationSourceAttributes == null || list.getName().equals(transformationSourceAttributes.getName()) && list.getDataType().equals(transformationSourceAttributes.getDataType()))) {
                object = list.getName();
                transformationSourceAttributes2 = (AttributeType)MetaDataHelper.copyMetadataObject(list);
                transformationSourceAttributes2.setName(transformationSourceAttributes.getName());
                transformationSourceAttributes2.setDataType(transformationSourceAttributes.getDataType());
                hashMap.put((String)object, (AttributeType)transformationSourceAttributes2);
            }
            if (transformationSourceAttributes2 != null) {
                caseAttributes = new CaseAttributes();
                caseAttributes.getAttribute().add(transformationSourceAttributes2);
            }
        }
        transformationSourceAttributes2 = new TransformationSourceAttributes();
        list = transformationSourceAttributes2.getTransformationSourceAttributeType();
        transformationSourceAttributes = buildTextNodeType.getTransformationSourceAttributes();
        object = buildTextNodeType.getTransformedAttributes();
        TransformedAttributesType transformedAttributesType = (TransformedAttributesType)MetaDataHelper.copyMetadataObject(object);
        for (TransformationSourceAttribute transformationSourceAttribute : transformationSourceAttributes.getTransformationSourceAttributeType()) {
            TransformationSourceAttribute transformationSourceAttribute2 = (TransformationSourceAttribute)MetaDataHelper.copyMetadataObject(transformationSourceAttribute);
            AttributeType attributeType = map.get(transformationSourceAttribute.getName());
            if (!(attributeType == null || transformationSourceAttribute.getName().equals(attributeType.getName()) && transformationSourceAttribute.getDataType().equals(attributeType.getDataType()))) {
                String string = transformationSourceAttribute.getName();
                transformationSourceAttribute2.setName(attributeType.getName());
                transformationSourceAttribute2.setDataType(attributeType.getDataType());
                AttributeType attributeType2 = new AttributeType();
                attributeType2.setDataType(attributeType.getDataType());
                attributeType2.setName(attributeType.getName());
                attributeType2.setStatus(AttributeStatus.VALID);
                hashMap.put(string, attributeType2);
                if (!string.equals(attributeType.getName())) {
                    for (MapTextTransformedSourceType mapTextTransformedSourceType : transformedAttributesType.getMapTextTransformedSource()) {
                        TextTransformationOutputAttributeType textTransformationOutputAttributeType = mapTextTransformedSourceType.getKey();
                        String string2 = textTransformationOutputAttributeType.getSource();
                        if (!string2.equals(string)) continue;
                        textTransformationOutputAttributeType.setSource(attributeType.getName());
                    }
                }
            }
            list.add(transformationSourceAttribute2);
        }
        if (!hashMap.isEmpty()) {
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), ALL_TRANSFORMATION_NODE_COLUMNS, AttributeTypeHelper.getAllColumns(transformedAttributesType, transformationSourceAttributes2));
            if (caseAttributes != null) {
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "caseAttribute", caseAttributes);
            }
            this.refactorChildrenAttributes(this, hashMap);
        }
    }

    public BuildTextNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_BUILD_TEXT_NODE_NAME");
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_BUILD_TEXT_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_BUILD_TEXT_ICON"));
    }

    @Override
    public void initNewInstance(Context context) {
        Number number;
        super.initNewInstance(context);
        BuildTextNodeType buildTextNodeType = (BuildTextNodeType)this.getData();
        Preferences preferences = Preferences.getPreferences();
        CacheSettingsPanelSettings cacheSettingsPanelSettings = CacheSettingsPanelSettings.getInstance((PropertyStorage)preferences);
        BuildTextPreferencesPanelSettings buildTextPreferencesPanelSettings = BuildTextPreferencesPanelSettings.getInstance((PropertyStorage)preferences);
        CaseAttributes caseAttributes = new CaseAttributes();
        buildTextNodeType.setCaseAttributes(caseAttributes);
        ArrayList<String> arrayList = buildTextPreferencesPanelSettings.getTokenLanguages();
        StoplistType stoplistType = BuildTextNode.generateDefaultStoplist(context, arrayList);
        TextNodeType.Stoplists stoplists = new TextNodeType.Stoplists();
        stoplists.getStoplist().add(stoplistType);
        buildTextNodeType.setStoplists(stoplists);
        TransformationSourceAttributes transformationSourceAttributes = new TransformationSourceAttributes();
        buildTextNodeType.setTransformationSourceAttributes(transformationSourceAttributes);
        TransformedAttributesType transformedAttributesType = new TransformedAttributesType();
        buildTextNodeType.setTransformedAttributes(transformedAttributesType);
        SampleSettings sampleSettings = new SampleSettings();
        if (cacheSettingsPanelSettings.isPercent()) {
            number = cacheSettingsPanelSettings.getPercentValue();
            sampleSettings.setPercentOfTotal(number);
        } else {
            number = cacheSettingsPanelSettings.getNumberOfRows();
            sampleSettings.setNumberOfRows((Long)number);
        }
        number = new SampleSettings.Method();
        SampleSettings.Method.Random random = new SampleSettings.Method.Random();
        random.setSeed(BigInteger.valueOf(cacheSettingsPanelSettings.getSeed()));
        number.setRandom(random);
        sampleSettings.setMethod((SampleSettings.Method)number);
        sampleSettings.setUseFullData(false);
        sampleSettings.setGenerateCache(Boolean.valueOf(true));
        buildTextNodeType.setSampleSettings(sampleSettings);
        buildTextNodeType.getCacheSettings().setUseFullData(Boolean.valueOf(false));
        buildTextNodeType.setStatus(NodeStatusType.INVALID);
    }

    @Override
    public String getHelpTopic() {
        return "build_text_node";
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        if (!(node instanceof DataProvider)) {
            return;
        }
        super.handleNewConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    public List<AttributeType> getCaseAttributes() {
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof DataProvider)) continue;
            DataProvider dataProvider = (DataProvider)((Object)abstractNode);
            for (AttributeType attributeType : dataProvider.getAttributes().getAttribute()) {
                if (!DatabaseMetadataUtils.isKeyDataTypeSupported(attributeType.getDataType())) continue;
                arrayList.add(attributeType);
            }
        }
        return arrayList;
    }

    @Override
    public Object getProperty(String string) {
        BuildTextNodeType buildTextNodeType = (BuildTextNodeType)this.getData();
        Object object = null;
        if (string.equals(EDIT_STOPLISTS)) {
            object = buildTextNodeType.getStoplists();
        } else if (string.equals(EDIT_COLUMNS)) {
            object = buildTextNodeType.getTransformedAttributes();
        } else if (string.equals("SQL_EXPRESSION")) {
            object = this.getSQLExpression();
        } else if (string.equals(SAMPLE_SETTINGS_PERCENT) || string.equals(SAMPLE_SETTINGS_NUMBER_OF_ROWS) || string.equals(SAMPLE_SETTINGS_SEED) || string.equals(SAMPLE_SETTINGS_TARGET) || string.equals(SAMPLE_SETTINGS_RANDOM) || string.equals(SAMPLE_SETTINGS_STRATIFIED) || string.equals(SAMPLE_SETTINGS_TOPN)) {
            SampleSettings sampleSettings = buildTextNodeType.getSampleSettings();
            object = sampleSettings;
        } else {
            return super.getProperty(string);
        }
        return object;
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(EDIT_COLUMN)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(ALL_TRANSFORMATION_NODE_COLUMNS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(SOURCE_COLUMNS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(EDIT_COLUMNS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(ADD_COLUMNS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(REMOVE_COLUMNS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(EDIT_STOPLISTS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(ADD_STOPLIST)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(EDIT_STOPLIST)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(REMOVE_STOPLIST)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(TEXT_TABLE)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_PERCENT) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_NUMBER_OF_ROWS) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_SEED) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_TARGET) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_RANDOM) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_STRATIFIED) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_TOPN) || complexProperty.getPropertyName().equals("SQL_EXPRESSION")) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public void setProperty(String string, Object object) {
        BuildTextNodeType buildTextNodeType = (BuildTextNodeType)this.getData();
        if (string.equals(SOURCE_COLUMNS)) {
            TransformationSourceAttributes transformationSourceAttributes = (TransformationSourceAttributes)object;
            buildTextNodeType.setTransformationSourceAttributes(transformationSourceAttributes);
        } else if (string.equals(EDIT_COLUMN)) {
            List list;
            MapTextTransformedSourceType mapTextTransformedSourceType = (MapTextTransformedSourceType)object;
            TransformedAttributesType transformedAttributesType = buildTextNodeType.getTransformedAttributes();
            if (transformedAttributesType != null && (list = transformedAttributesType.getMapTextTransformedSource()) != null && !list.isEmpty()) {
                for (MapTextTransformedSourceType mapTextTransformedSourceType2 : list) {
                    if (!mapTextTransformedSourceType2.getKey().getName().equals(mapTextTransformedSourceType.getKey().getName())) continue;
                    AttributeTypeHelper.copyMapTextTransformedSource(mapTextTransformedSourceType2, mapTextTransformedSourceType);
                    break;
                }
            }
        } else if (string.equals(EDIT_COLUMNS)) {
            TransformedAttributesType transformedAttributesType = (TransformedAttributesType)object;
            buildTextNodeType.setTransformedAttributes(transformedAttributesType);
        } else if (string.equals(REMOVE_COLUMNS) || string.equals(ADD_COLUMNS)) {
            TransformedAttributesType transformedAttributesType = (TransformedAttributesType)object;
            buildTextNodeType.setTransformedAttributes(transformedAttributesType);
        } else if (string.equals(EDIT_STOPLISTS)) {
            Object object22;
            TextNodeType.Stoplists stoplists = (TextNodeType.Stoplists)object;
            buildTextNodeType.setStoplists(stoplists);
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            for (Object object22 : stoplists.getStoplist()) {
                hashMap.put(object22.getId(), Boolean.TRUE);
            }
            TransformedAttributesType transformedAttributesType = buildTextNodeType.getTransformedAttributes();
            if (transformedAttributesType != null && (object22 = transformedAttributesType.getMapTextTransformedSource()) != null && !object22.isEmpty()) {
                Iterator iterator = object22.iterator();
                while (iterator.hasNext()) {
                    String string2;
                    MapTextTransformedSourceType mapTextTransformedSourceType = (MapTextTransformedSourceType)iterator.next();
                    TransformationTokenType transformationTokenType = mapTextTransformedSourceType.getKey().getTransformationElement().getToken();
                    if (transformationTokenType == null) {
                        transformationTokenType = mapTextTransformedSourceType.getKey().getTransformationElement().getTheme();
                    }
                    if ((string2 = transformationTokenType.getToken().getStoplistId()) == null || hashMap.containsKey(string2)) continue;
                    transformationTokenType.getToken().setStoplistId(null);
                }
            }
        } else if (string.equals(ADD_STOPLIST)) {
            StoplistType stoplistType = (StoplistType)object;
            buildTextNodeType.getStoplists().getStoplist().add(stoplistType);
        } else if (string.equals(EDIT_STOPLIST)) {
            StoplistType stoplistType = (StoplistType)object;
            for (int i = 0; i < buildTextNodeType.getStoplists().getStoplist().size(); ++i) {
                if (!((StoplistType)buildTextNodeType.getStoplists().getStoplist().get(i)).getId().equals(stoplistType.getId())) continue;
                buildTextNodeType.getStoplists().getStoplist().set(i, stoplistType);
                break;
            }
        } else if (string.equals(REMOVE_STOPLIST)) {
            List list;
            TransformedAttributesType transformedAttributesType;
            StoplistType stoplistType = (StoplistType)object;
            for (int i = 0; i < buildTextNodeType.getStoplists().getStoplist().size(); ++i) {
                if (!((StoplistType)buildTextNodeType.getStoplists().getStoplist().get(i)).getId().equals(stoplistType.getId())) continue;
                buildTextNodeType.getStoplists().getStoplist().remove(i);
                break;
            }
            if ((transformedAttributesType = buildTextNodeType.getTransformedAttributes()) != null && (list = transformedAttributesType.getMapTextTransformedSource()) != null && !list.isEmpty()) {
                for (MapTextTransformedSourceType mapTextTransformedSourceType : list) {
                    String string3;
                    TransformationTokenType transformationTokenType = mapTextTransformedSourceType.getKey().getTransformationElement().getToken();
                    if (transformationTokenType == null) {
                        transformationTokenType = mapTextTransformedSourceType.getKey().getTransformationElement().getTheme();
                    }
                    if ((string3 = transformationTokenType.getToken().getStoplistId()) == null || !string3.equals(stoplistType.getId())) continue;
                    transformationTokenType.getToken().setStoplistId(null);
                }
            }
        } else if (string.equals("SQL_EXPRESSION")) {
            if (object != null && object.equals("SQL_EXPRESSION_GENERATE")) {
                this.setSQLExpression(this.generateSQLExpression());
            } else {
                this.setSQLExpression((String)object);
            }
        } else if (string.equals(SAMPLE_SETTINGS_PERCENT) || string.equals(SAMPLE_SETTINGS_NUMBER_OF_ROWS) || string.equals(SAMPLE_SETTINGS_SEED) || string.equals(SAMPLE_SETTINGS_TARGET) || string.equals(SAMPLE_SETTINGS_RANDOM) || string.equals(SAMPLE_SETTINGS_STRATIFIED) || string.equals(SAMPLE_SETTINGS_TOPN)) {
            if (object instanceof SampleSettings) {
                buildTextNodeType.setSampleSettings((SampleSettings)object);
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public String generateSQLExpression() {
        List list;
        List list2;
        TransformationSourceAttributes transformationSourceAttributes;
        BuildTextNodeType buildTextNodeType = (BuildTextNodeType)this.getData();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT " + (BuildTextNode.generateSQLInlineHint() ? "/*+ inline */" : "") + "\n");
        AttributeType attributeType = null;
        boolean bl = false;
        if (buildTextNodeType.getCaseAttributes().getAttribute().size() > 0) {
            attributeType = (AttributeType)buildTextNodeType.getCaseAttributes().getAttribute().get(0);
        }
        if (attributeType != null) {
            stringBuilder.append("\"" + attributeType.getName() + "\"");
            bl = true;
        }
        if ((transformationSourceAttributes = buildTextNodeType.getTransformationSourceAttributes()) != null && (list2 = transformationSourceAttributes.getTransformationSourceAttributeType()) != null && list2.size() > 0) {
            for (int i = 0; i < list2.size(); ++i) {
                if (!((TransformationSourceAttribute)list2.get(i)).isIsOutput() || attributeType != null && ((TransformationSourceAttribute)list2.get(i)).getName().compareTo(attributeType.getName()) == 0) continue;
                if (bl) {
                    stringBuilder.append(",\n");
                }
                Object object = null;
                object = !StringUtils.isDoubleQuotedString(((TransformationSourceAttribute)list2.get(i)).getName()) ? "\"" + ((TransformationSourceAttribute)list2.get(i)).getName() + "\"" : ((TransformationSourceAttribute)list2.get(i)).getName();
                stringBuilder.append((String)object);
                bl = true;
                Object object2 = ((TransformationSourceAttribute)list2.get(i)).getAlias();
                if (object2 == null || ((String)object2).isEmpty()) continue;
                if (!StringUtils.isDoubleQuotedString((String)object2)) {
                    object2 = "\"" + (String)object2 + "\"";
                }
                stringBuilder.append(" AS ");
                stringBuilder.append((String)object2);
            }
        }
        if ((list2 = buildTextNodeType.getTransformedAttributes()) != null && (list = list2.getMapTextTransformedSource()) != null && !list.isEmpty()) {
            for (Object object2 : list) {
                String string;
                String string2;
                TextTransformationOutputAttributeType textTransformationOutputAttributeType = object2.getKey();
                if (!textTransformationOutputAttributeType.isIsOutput()) continue;
                String string3 = null;
                String string4 = null;
                boolean bl2 = true;
                String string5 = null;
                TransformationTokenType transformationTokenType = textTransformationOutputAttributeType.getTransformationElement().getToken();
                if (transformationTokenType == null) {
                    bl2 = false;
                    transformationTokenType = textTransformationOutputAttributeType.getTransformationElement().getTheme();
                    string5 = ((TextTransformationType.Theme)transformationTokenType).getType().equals("Full") ? "1" : "0";
                }
                string4 = transformationTokenType.getToken().getPolicy();
                if (transformationTokenType.getToken().getStatisticTable() != null) {
                    string3 = transformationTokenType.getToken().getStatisticTable().getName();
                }
                String string6 = transformationTokenType.getToken().getMaxNumberPerDoc().toString();
                String string7 = transformationTokenType.getToken().getFrequency();
                if (string3 == null || "".equals(string4)) continue;
                if (bl) {
                    stringBuilder.append(",\n");
                }
                if (!StringUtils.isDoubleQuotedString(string2 = textTransformationOutputAttributeType.getSource())) {
                    string2 = "\"" + string2 + "\"";
                }
                String string8 = string = (string = textTransformationOutputAttributeType.getAlias()) == null ? textTransformationOutputAttributeType.getName() : string;
                if (!StringUtils.isDoubleQuotedString(string)) {
                    string = "\"" + string + "\"";
                }
                String string9 = null;
                string9 = bl2 ? "ODMR_ENGINE_TEXT.dm_text_token_features('" + StringUtils.escapeSingleQuotesForSQL(string4) + "', " + string2 + ", '" + StringUtils.escapeSingleQuotesForSQL(string3) + "', NULL, " + string6 + ", '" + string7 + "') " + string : "ODMR_ENGINE_TEXT.dm_text_theme_features('" + StringUtils.escapeSingleQuotesForSQL(string4) + "', " + string2 + ", '" + StringUtils.escapeSingleQuotesForSQL(string3) + "', NULL, " + string5 + ", " + string6 + ", '" + string7 + "') " + string;
                stringBuilder.append(string9);
                bl = true;
            }
        }
        stringBuilder.append(" FROM {INPUT_SOURCE}");
        return this.wrapExpressionInWithClause(stringBuilder.toString());
    }

    protected String generateTextSettingsCode(Context context) {
        Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
        BuildTextNodeType buildTextNodeType = (BuildTextNodeType)this.getData();
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        TransformedAttributesType transformedAttributesType = buildTextNodeType.getTransformedAttributes();
        if (transformedAttributesType != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Object object : buildTextNodeType.getStoplists().getStoplist()) {
                hashMap.put(object.getId(), object.getDBName());
            }
            HashMap hashMap2 = new HashMap();
            for (TransformationSourceAttribute transformationSourceAttribute : buildTextNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType()) {
                if (transformationSourceAttribute.getDataType().equals("BFILE") || transformationSourceAttribute.getDataType().equals("BLOB")) {
                    hashMap2.put(transformationSourceAttribute.getName(), Boolean.TRUE);
                    continue;
                }
                hashMap2.put(transformationSourceAttribute.getName(), Boolean.FALSE);
            }
            for (TransformationSourceAttribute transformationSourceAttribute : buildTextNodeType.getTransformedAttributes().getMapTextTransformedSource()) {
                Object object3;
                boolean bl;
                Object object22;
                List list;
                List list2;
                String string2;
                BigInteger bigInteger;
                TextTransformationOutputAttributeType textTransformationOutputAttributeType = transformationSourceAttribute.getKey();
                if (!textTransformationOutputAttributeType.isIsOutput()) continue;
                TextTransformationType textTransformationType = textTransformationOutputAttributeType.getTransformationElement();
                boolean bl2 = false;
                String string3 = null;
                String string4 = null;
                boolean bl3 = (Boolean)hashMap2.get(textTransformationOutputAttributeType.getSource());
                String string5 = null;
                String string6 = null;
                if (textTransformationType.getToken() != null) {
                    bigInteger = textTransformationType.getToken().getToken().getMaxNumberAllDocs();
                    string2 = textTransformationType.getToken().getToken().getStoplistId();
                    list2 = textTransformationType.getToken().getToken().getLanguages().getLanguage();
                    list = textTransformationType.getToken().getToken().getLexer().getSettings().getAttribute();
                    for (Object object22 : list) {
                        if (!object22.getName().equals("index_stems")) continue;
                        bl2 = true;
                        break;
                    }
                    string3 = textTransformationType.getToken().getToken().getPolicy();
                    string4 = textTransformationType.getToken().getToken().getLexer().getName();
                    if (textTransformationType.getToken().getToken().getStoplistId() != null) {
                        string5 = (String)hashMap.get(textTransformationType.getToken().getToken().getStoplistId());
                    }
                    string6 = textTransformationType.getToken().getToken().getStatisticTable().getName();
                } else {
                    bigInteger = textTransformationType.getTheme().getToken().getMaxNumberAllDocs();
                    string2 = textTransformationType.getTheme().getToken().getStoplistId();
                    list2 = textTransformationType.getTheme().getToken().getLanguages().getLanguage();
                    list = textTransformationType.getTheme().getToken().getLexer().getSettings().getAttribute();
                    string = textTransformationType.getTheme().getType().equals("Full") ? "1" : "0";
                    string3 = textTransformationType.getTheme().getToken().getPolicy();
                    string4 = textTransformationType.getTheme().getToken().getLexer().getName();
                    if (textTransformationType.getTheme().getToken().getStoplistId() != null) {
                        string5 = (String)hashMap.get(textTransformationType.getTheme().getToken().getStoplistId());
                    }
                    string6 = textTransformationType.getTheme().getToken().getStatisticTable().getName();
                }
                bl2 = bl2 && ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, version, true);
                stringBuffer.append("  v_policy_name := '" + string3 + "'; \n");
                stringBuffer.append("  v_lexer_name := generateUniqueName; \n");
                if (bl3) {
                    stringBuffer.append("  v_auto_filter_name := generateUniqueName; \n");
                }
                if (string2 != null) {
                    stringBuffer.append("  v_stoplist_name := generateUniqueName; \n");
                }
                stringBuffer.append("  v_feature_name := '" + string6 + "'; \n");
                stringBuffer.append("  IF (v_drop = 'TRUE') THEN -- delete existing policy? \n");
                stringBuffer.append("    BEGIN \n");
                stringBuffer.append("      ctx_ddl.DROP_POLICY(policy_name => v_policy_name); \n");
                stringBuffer.append("    EXCEPTION WHEN OTHERS THEN \n");
                stringBuffer.append("      NULL; \n");
                stringBuffer.append("    END; \n");
                stringBuffer.append("    BEGIN \n");
                stringBuffer.append("      v_sql := 'DROP TABLE '||v_feature_name||' PURGE'; \n");
                stringBuffer.append("      execSQL(v_sql); \n");
                stringBuffer.append("    EXCEPTION WHEN OTHERS THEN \n");
                stringBuffer.append("      NULL; \n");
                stringBuffer.append("    END; \n");
                stringBuffer.append("  END IF; \n");
                boolean bl4 = bl = (list2.size() > 1 || bl2) && ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, version, true);
                if (bl) {
                    stringBuffer.append("  ctx_ddl.create_preference(v_lexer_name, 'AUTO_LEXER'); \n");
                } else if (((TransformationTokenType.Token.Languages.Language)list2.get(0)).getName().equals("TRADITIONAL CHINESE") || ((TransformationTokenType.Token.Languages.Language)list2.get(0)).getName().equals("SIMPLIFIED CHINESE")) {
                    stringBuffer.append("  ctx_ddl.create_preference(v_lexer_name, 'CHINESE_LEXER'); \n");
                } else if (((TransformationTokenType.Token.Languages.Language)list2.get(0)).getName().equals("JAPANESE")) {
                    stringBuffer.append("  ctx_ddl.create_preference(v_lexer_name, 'JAPANESE_LEXER'); \n");
                } else if (((TransformationTokenType.Token.Languages.Language)list2.get(0)).getName().equals("KOREAN")) {
                    stringBuffer.append("  ctx_ddl.create_preference(v_lexer_name, 'KOREAN_MORPH_LEXER'); \n");
                } else {
                    stringBuffer.append("  ctx_ddl.create_preference(v_lexer_name, 'BASIC_LEXER'); \n");
                }
                stringBuffer.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_lexer_name, 'LEXER', 'Policy='||v_policy_name, 'Lexer'); \n");
                if (bl3) {
                    stringBuffer.append("  ctx_ddl.create_preference(v_auto_filter_name, 'AUTO_FILTER'); \n");
                    stringBuffer.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_auto_filter_name, 'AUTOFILTER', 'Policy='||v_policy_name, 'Auto Filter'); \n");
                }
                for (Object object3 : list) {
                    if (object3.getName().equals("index_stems")) {
                        if (bl) {
                            stringBuffer.append("  ctx_ddl.set_attribute(v_lexer_name, '" + object3.getName() + "', 'YES'); \n");
                            continue;
                        }
                        stringBuffer.append("  ctx_ddl.set_attribute(v_lexer_name, '" + object3.getName() + "', '" + ((TransformationTokenType.Token.Languages.Language)list2.get(0)).getName() + "'); \n");
                        continue;
                    }
                    if (object3.getType().equals("String")) {
                        stringBuffer.append("  ctx_ddl.set_attribute(v_lexer_name, '" + object3.getName() + "', '" + object3.getValueString() + "'); \n");
                        continue;
                    }
                    stringBuffer.append("  ctx_ddl.set_attribute(v_lexer_name, '" + object3.getName() + "', " + object3.getValueNumber() + "); \n");
                }
                if (string2 != null) {
                    if (bl) {
                        stringBuffer.append("  ctx_ddl.create_stoplist(v_stoplist_name, 'MULTI_STOPLIST'); \n");
                    } else {
                        stringBuffer.append("  ctx_ddl.create_stoplist(v_stoplist_name, 'BASIC_STOPLIST'); \n");
                    }
                    object22 = new HashMap();
                    for (TransformationTokenType.Token.Languages.Language language : list2) {
                        object22.put(language.getName().toUpperCase(), Boolean.TRUE);
                    }
                    stringBuffer.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_stoplist_name, 'STOPLIST', 'Policy='||v_policy_name, 'Stoplist'); \n");
                    for (TransformationTokenType.Token.Languages.Language language : buildTextNodeType.getStoplists().getStoplist()) {
                        if (!language.getId().equals(string2)) continue;
                        for (StoplistType.StopTokens.Token token : language.getStopTokens().getToken()) {
                            if (!object22.containsKey(token.getLanguage().toUpperCase()) && !token.getLanguage().toUpperCase().equals("ALL")) continue;
                            if (textTransformationType.getToken() != null && token.getType().equals("Word")) {
                                if (bl) {
                                    stringBuffer.append("  ctx_ddl.add_stopword(v_stoplist_name, '" + StringUtils.escapeSingleQuotesForSQL(token.getItem()) + "', '" + token.getLanguage() + "'); \n");
                                } else {
                                    stringBuffer.append("  ctx_ddl.add_stopword(v_stoplist_name, '" + StringUtils.escapeSingleQuotesForSQL(token.getItem()) + "'); \n");
                                }
                            }
                            if (textTransformationType.getToken() != null || !token.getType().equals("Theme")) continue;
                            stringBuffer.append("  ctx_ddl.add_stoptheme(v_stoplist_name, '" + StringUtils.escapeSingleQuotesForSQL(token.getItem()) + "'); \n");
                        }
                    }
                    if (bl3) {
                        stringBuffer.append("  ctx_ddl.create_policy(policy_name => v_policy_name, filter => v_auto_filter_name, lexer => v_lexer_name, stoplist => v_stoplist_name); \n");
                    } else {
                        stringBuffer.append("  ctx_ddl.create_policy(policy_name => v_policy_name, lexer => v_lexer_name, stoplist => v_stoplist_name); \n");
                    }
                } else if (bl3) {
                    stringBuffer.append("  ctx_ddl.create_policy(policy_name => v_policy_name, filter => v_auto_filter_name, lexer => v_lexer_name); \n");
                } else {
                    stringBuffer.append("  ctx_ddl.create_policy(policy_name => v_policy_name, lexer => v_lexer_name); \n");
                }
                stringBuffer.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_policy_name, 'POLICY', 'Column=" + textTransformationOutputAttributeType.getName() + "', 'Policy'); \n");
                object22 = null;
                stringBuffer.append("\n");
                object3 = this.findDataNodes().get(0);
                object22 = textTransformationType.getToken() != null ? "  v_sql := ' \n    CREATE TABLE '|| SYS.DBMS_ASSERT.SIMPLE_SQL_NAME('\"'||v_feature_name||'\"') ||' AS \n    with \n    d as \n    ( \n      select column_value, DOC_FREQ, RANK() OVER (ORDER BY DOC_FREQ DESC, column_value) rank \n      from ( \n        select column_value, count(*) DOC_FREQ \n        from ( \n          select DOC_NUM, s.column_value \n          from (select rownum DOC_NUM, ODMR_ENGINE_TEXT.dm_policy_tokens('''||getTextPolicy('" + buildTextNodeType.getId() + "', '" + textTransformationOutputAttributeType.getName() + "')||''', \"" + textTransformationOutputAttributeType.getSource() + "\") \"TOKENS\" \n" + "                from '||getInputSource('" + ((AbstractNode)object3).getMetadataId() + "')||') r, TABLE(r.TOKENS) s \n" + "          group by DOC_NUM, s.column_value \n" + "        ) \n" + "        group by column_value \n" + "      ) \n" + "    ), \n" + "    tot as \n" + "    ( \n" + "      select count(*) NUM_DOCS from '||getInputSource('" + ((AbstractNode)object3).getMetadataId() + "')||' \n" + "    ) \n" + "    select ''" + textTransformationOutputAttributeType.getSource() + "'' \"COLUMN_NAME\", d.column_value \"TOKEN\", LOG(10, (tot.NUM_DOCS/(d.DOC_FREQ))) \"VALUE\", d.rank \"RANK\", d.DOC_FREQ \"COUNT\" \n" + "    from d, tot WHERE d.rank <= " + bigInteger + "'; \n" : "  v_sql := ' \n    CREATE TABLE '|| SYS.DBMS_ASSERT.SIMPLE_SQL_NAME('\"'||v_feature_name||'\"') ||' AS \n    with \n    d as \n    ( \n      select column_value, DOC_FREQ, RANK() OVER (ORDER BY DOC_FREQ DESC, column_value) rank \n      from ( \n        select column_value, count(*) DOC_FREQ \n        from ( \n          select DOC_NUM, s.column_value \n          from (select rownum DOC_NUM, ODMR_ENGINE_TEXT.dm_policy_themes('''||getTextPolicy('" + buildTextNodeType.getId() + "', '" + textTransformationOutputAttributeType.getName() + "')||''', \"" + textTransformationOutputAttributeType.getSource() + "\", " + string + ") \"TOKENS\" \n" + "                from '||getInputSource('" + ((AbstractNode)object3).getMetadataId() + "')||') r, TABLE(r.TOKENS) s \n" + "          group by DOC_NUM, s.column_value \n" + "        ) \n" + "        group by column_value \n" + "      ) \n" + "    ), \n" + "    tot as \n" + "    ( \n" + "      select count(*) NUM_DOCS from '||getInputSource('" + ((AbstractNode)object3).getMetadataId() + "')||' \n" + "    ) \n" + "    select ''" + textTransformationOutputAttributeType.getSource() + "'' \"COLUMN_NAME\", d.column_value \"TOKEN\", LOG(10, (tot.NUM_DOCS/(d.DOC_FREQ))) \"VALUE\", d.rank \"RANK\", d.DOC_FREQ \"COUNT\" \n" + "    from d, tot WHERE d.rank <= " + bigInteger + "'; \n";
                stringBuffer.append((String)object22);
                stringBuffer.append("  execSQL(v_sql); \n");
                stringBuffer.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_feature_name, 'TABLE', 'Column=" + textTransformationOutputAttributeType.getName() + "', 'Feature Table'); \n");
                stringBuffer.append("  \n");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public String generateCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, String string) throws Exception {
        Object object;
        String string2 = super.generateCode(context, parameterizedSourceDefinitions, string);
        BuildTextNodeType buildTextNodeType = (BuildTextNodeType)this.getData();
        TransformedAttributesType transformedAttributesType = buildTextNodeType.getTransformedAttributes();
        if (transformedAttributesType != null && (object = transformedAttributesType.getMapTextTransformedSource()) != null && !object.isEmpty()) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                MapTextTransformedSourceType mapTextTransformedSourceType = (MapTextTransformedSourceType)iterator.next();
                TextTransformationOutputAttributeType textTransformationOutputAttributeType = mapTextTransformedSourceType.getKey();
                if (!textTransformationOutputAttributeType.isIsOutput()) continue;
                String string3 = null;
                String string4 = null;
                boolean bl = true;
                TransformationTokenType transformationTokenType = textTransformationOutputAttributeType.getTransformationElement().getToken();
                if (transformationTokenType == null) {
                    bl = false;
                    transformationTokenType = textTransformationOutputAttributeType.getTransformationElement().getTheme();
                }
                string4 = transformationTokenType.getToken().getPolicy();
                if (transformationTokenType.getToken().getStatisticTable() != null) {
                    string3 = transformationTokenType.getToken().getStatisticTable().getName();
                }
                String string5 = textTransformationOutputAttributeType.getName();
                string2 = string2.replace(string4, "'||getTextPolicy('" + buildTextNodeType.getId() + "', '" + string5 + "')||'");
                string2 = string2.replace(string3, "'||getFeatureTable('" + buildTextNodeType.getId() + "', '" + string5 + "')||'");
            }
        }
        object = this.generateTextSettingsCode(context);
        return CodeTemplate.updateBodyTemplate(string2, "<BUILD_TEXT_SETTING>", (String)object);
    }

    @Override
    public boolean isVersionSupported(Context context, StringBuffer stringBuffer) {
        TransformedAttributesType transformedAttributesType;
        Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
        BuildTextNodeType buildTextNodeType = (BuildTextNodeType)this.getData();
        if (!ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, version, true) && (transformedAttributesType = buildTextNodeType.getTransformedAttributes()) != null) {
            for (MapTextTransformedSourceType mapTextTransformedSourceType : buildTextNodeType.getTransformedAttributes().getMapTextTransformedSource()) {
                TextTransformationType textTransformationType;
                TextTransformationOutputAttributeType textTransformationOutputAttributeType = mapTextTransformedSourceType.getKey();
                if (!textTransformationOutputAttributeType.isIsOutput() || (textTransformationType = textTransformationOutputAttributeType.getTransformationElement()).getToken() == null) continue;
                List list = textTransformationType.getToken().getToken().getLexer().getSettings().getAttribute();
                for (LexerType.Settings.Attribute attribute : list) {
                    if (!attribute.getName().equals("index_stems")) continue;
                    stringBuffer.append(CodeGenLrb.get("VALIDATE_BUILD_TEXT_STEMMING_NOT_SUPPORTED"));
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean validate(boolean bl) {
        boolean bl2 = super.validate(bl);
        if (bl2) {
            bl2 = this.validateInputAttributes();
        }
        if (bl2) {
            bl2 = this.validateNode();
        }
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
        return bl2;
    }

    public List<AbstractNode> findDataNodes() {
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof DataProvider) || abstractNode instanceof AbstractTextNode) continue;
            arrayList.add(abstractNode);
        }
        return arrayList;
    }

    public boolean validateNode() {
        List<AbstractNode> list;
        boolean bl = true;
        BuildTextNodeType buildTextNodeType = (BuildTextNodeType)this.getData();
        if (null == buildTextNodeType.getTransformationSourceAttributes() || null == buildTextNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType() || buildTextNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType().isEmpty()) {
            this.addMessage("TRANSFORM_NODE_SOURCE_COLUMNS_MISSING", MessageEnumType.INCOMPLETE, new String[0]);
            bl = false;
        }
        if ((list = this.findDataNodes()).size() < 1) {
            this.addMessage("BUILD_TEXT_NO_DATA", MessageEnumType.WARNING, new String[0]);
            bl = false;
        }
        return bl;
    }

    private Map<String, AttributeStatus> buildDependentObjectStatusMap() {
        BuildTextNodeType buildTextNodeType = (BuildTextNodeType)this.getData();
        HashMap<String, AttributeStatus> hashMap = new HashMap<String, AttributeStatus>();
        for (MapTextTransformedSourceType mapTextTransformedSourceType : buildTextNodeType.getTransformedAttributes().getMapTextTransformedSource()) {
            hashMap.put(mapTextTransformedSourceType.getKey().getName(), mapTextTransformedSourceType.getKey().getStatus());
        }
        return hashMap;
    }

    private boolean validateInputAttributes() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        AttributeType attributeType2;
        Object object52;
        AbstractNode abstractNode = this.findParentNode();
        BuildTextNodeType buildTextNodeType = (BuildTextNodeType)this.getData();
        CaseAttributes caseAttributes = new CaseAttributes();
        if (!buildTextNodeType.getCaseAttributes().getAttribute().isEmpty()) {
            for (Object object52 : buildTextNodeType.getCaseAttributes().getAttribute()) {
                attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(object52);
                caseAttributes.getAttribute().add(attributeType2);
            }
        }
        TransformationSourceAttributes transformationSourceAttributes = new TransformationSourceAttributes();
        for (AttributeType attributeType2 : buildTextNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType()) {
            object4 = (TransformationSourceAttribute)MetaDataHelper.copyMetadataObject(attributeType2);
            transformationSourceAttributes.getTransformationSourceAttributeType().add(object4);
        }
        object52 = transformationSourceAttributes.getTransformationSourceAttributeType();
        attributeType2 = null;
        object4 = (DataProvider)((Object)abstractNode);
        if (object4 != null) {
            attributeType2 = object4.getAttributes();
        }
        List list = attributeType2 != null ? attributeType2.getAttribute() : new ArrayList();
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType3 : list) {
            String string = attributeType3.getAlias();
            String string2 = (string != null && string.trim().length() > 0 ? string : attributeType3.getName()) + "." + attributeType3.getDataType();
            hashMap.put(string2, attributeType3);
        }
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        TransformedAttributesType transformedAttributesType = (TransformedAttributesType)MetaDataHelper.copyMetadataObject(buildTextNodeType.getTransformedAttributes());
        ArrayList<TransformationSourceAttribute> arrayList = new ArrayList<TransformationSourceAttribute>();
        Object object6 = object52.iterator();
        while (object6.hasNext()) {
            object3 = (TransformationSourceAttribute)object6.next();
            object2 = object3.getName() + "." + object3.getDataType();
            object = (AttributeType)hashMap.get(object2);
            if (null == object) {
                if (abstractNode != null) {
                    if (!this.isColumnUsedForCaseId(caseAttributes, (TransformationSourceAttribute)object3) && !this.isColumnUsedForTransformations(transformedAttributesType, (TransformationSourceAttribute)object3)) {
                        arrayList.add((TransformationSourceAttribute)object3);
                        continue;
                    }
                    object3.setStatus(AttributeStatus.INVALID);
                    bl4 = true;
                    if (this.isColumnUsedForCaseId(caseAttributes, (TransformationSourceAttribute)object3)) {
                        bl5 = true;
                        bl = false;
                    }
                    if (!this.isColumnUsedForTransformations(transformedAttributesType, (TransformationSourceAttribute)object3)) continue;
                    bl3 = true;
                    bl2 = false;
                    continue;
                }
                object3.setStatus(AttributeStatus.INVALID);
                bl4 = true;
                if (this.isColumnUsedForCaseId(caseAttributes, (TransformationSourceAttribute)object3)) {
                    bl5 = true;
                    bl = false;
                }
                if (!this.isColumnUsedForTransformations(transformedAttributesType, (TransformationSourceAttribute)object3)) continue;
                bl3 = true;
                bl2 = false;
                continue;
            }
            if (object3.getStatus().equals((Object)AttributeStatus.INVALID)) {
                object3.setStatus(AttributeStatus.VALID);
                bl4 = true;
                if (this.isColumnUsedForTransformations(transformedAttributesType, (TransformationSourceAttribute)object3)) {
                    bl3 = true;
                }
                if (this.isColumnUsedForCaseId(caseAttributes, (TransformationSourceAttribute)object3)) {
                    bl5 = true;
                }
            }
            hashMap.remove(object2);
        }
        if (!bl) {
            this.addMessage("SAMPLE_INVAL_CASEID", MessageEnumType.WARNING, new String[0]);
        }
        if (!bl2) {
            this.addMessage("TRANSFORM_NODE_INVALID_ATTR", MessageEnumType.WARNING, new String[0]);
        }
        if (!arrayList.isEmpty()) {
            this.removeMissingColumns(transformationSourceAttributes.getTransformationSourceAttributeType(), arrayList);
            bl4 = true;
        }
        if (!(object6 = new ArrayList(hashMap.values())).isEmpty()) {
            BuildTextNode.copyAttributes(transformationSourceAttributes.getTransformationSourceAttributeType(), (List<AttributeType>)object6);
            bl4 = true;
        }
        object3 = new ArrayList();
        object2 = (OdmrSDMUndoFilter)this.getUndoFilter();
        if (bl4) {
            object = new ComplexProperty(SOURCE_COLUMNS, transformationSourceAttributes);
            ((ComplexProperty)object).setOldData(buildTextNodeType.getTransformationSourceAttributes());
            object3.add(object);
        }
        if (bl3) {
            object = new ComplexProperty(EDIT_COLUMNS, transformedAttributesType);
            ((ComplexProperty)object).setOldData(buildTextNodeType.getTransformedAttributes());
            object3.add(object);
        }
        if (bl5) {
            object = new ComplexProperty("caseAttribute", caseAttributes);
            ((ComplexProperty)object).setOldData(buildTextNodeType.getCaseAttributes());
            object3.add(object);
        }
        object = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        ((ComplexProperty)object).setOldData(this.getSQLExpression());
        object3.add(object);
        ((OdmrSDMUndoFilter)((Object)object2)).prepareUndoComplexPropertyList(this, this.getContext(), (List<ComplexProperty>)object3);
        return bl && bl2;
    }

    @Override
    protected boolean canGenerateLineageSQL() {
        boolean bl;
        boolean bl2 = bl = this.getData().getStatus() == NodeStatusType.COMPLETE || this.getData().getStatus() == NodeStatusType.WARNING;
        return bl;
    }

    private boolean isColumnUsedForCaseId(CaseAttributes caseAttributes, TransformationSourceAttribute transformationSourceAttribute) {
        boolean bl = false;
        AttributeType attributeType = null;
        if (caseAttributes.getAttribute().size() > 0 && (attributeType = (AttributeType)caseAttributes.getAttribute().get(0)).getName().compareTo(transformationSourceAttribute.getName()) == 0 && attributeType.getDataType().equals(transformationSourceAttribute.getDataType())) {
            bl = true;
            attributeType.setStatus(transformationSourceAttribute.getStatus());
        }
        return bl;
    }

    private boolean isColumnUsedForTransformations(TransformedAttributesType transformedAttributesType, TransformationSourceAttribute transformationSourceAttribute) {
        boolean bl = false;
        for (MapTextTransformedSourceType mapTextTransformedSourceType : transformedAttributesType.getMapTextTransformedSource()) {
            String string = mapTextTransformedSourceType.getKey().getSource();
            if (!string.equals(transformationSourceAttribute.getName())) continue;
            bl = true;
            mapTextTransformedSourceType.getKey().setStatus(transformationSourceAttribute.getStatus());
        }
        return bl;
    }

    private void removeMissingColumns(List<TransformationSourceAttribute> list, List<TransformationSourceAttribute> list2) {
        HashMap<String, TransformationSourceAttribute> hashMap = new HashMap<String, TransformationSourceAttribute>(list.size());
        for (TransformationSourceAttribute transformationSourceAttribute : list) {
            hashMap.put(transformationSourceAttribute.getName(), transformationSourceAttribute);
        }
        for (TransformationSourceAttribute transformationSourceAttribute : list2) {
            TransformationSourceAttribute transformationSourceAttribute2 = (TransformationSourceAttribute)hashMap.get(transformationSourceAttribute.getName());
            list.remove(transformationSourceAttribute2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Features> loadFeatures(Context context, TextTransformationOutputAttributeType textTransformationOutputAttributeType) {
        ArrayList<Features> arrayList;
        block11: {
            arrayList = new ArrayList<Features>();
            Connection connection = null;
            SQLHelper sQLHelper = new SQLHelper();
            try {
                ResultType resultType;
                if (textTransformationOutputAttributeType == null) break block11;
                TransformationTokenType transformationTokenType = textTransformationOutputAttributeType.getTransformationElement().getToken();
                if (transformationTokenType == null) {
                    transformationTokenType = textTransformationOutputAttributeType.getTransformationElement().getTheme();
                }
                if ((resultType = transformationTokenType.getToken().getFeatureTable()) == null) break block11;
                Connection connection2 = connection = Connections.getSharedConnection(context);
                synchronized (connection2) {
                    String string = resultType.getName();
                    if (string != null) {
                        String string2 = "select CASE_COLUMN from " + string;
                        sQLHelper.pstmt = connection.prepareStatement(string2);
                        sQLHelper.pstmt.setFetchSize(2000);
                        sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                        while (sQLHelper.rs.next()) {
                            Object object = sQLHelper.rs.getObject("CASE_COLUMN");
                            arrayList.add(new Features(object, null, null));
                        }
                    }
                }
            }
            catch (Exception exception) {
                Logger.getLogger(BuildTextNode.class.getName()).log(Level.SEVERE, exception.getMessage(), exception);
            }
            finally {
                sQLHelper.close();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Features loadFeature(Context context, Object object, TextTransformationOutputAttributeType textTransformationOutputAttributeType) {
        Features features;
        block13: {
            features = null;
            Connection connection = null;
            SQLHelper sQLHelper = new SQLHelper();
            try {
                ResultType resultType;
                if (textTransformationOutputAttributeType == null) break block13;
                boolean bl = true;
                boolean bl2 = false;
                TransformationTokenType transformationTokenType = textTransformationOutputAttributeType.getTransformationElement().getToken();
                if (transformationTokenType == null) {
                    transformationTokenType = textTransformationOutputAttributeType.getTransformationElement().getTheme();
                    bl = false;
                    boolean bl3 = bl2 = textTransformationOutputAttributeType.getTransformationElement().getTheme().getType().compareTo("Full") == 0;
                }
                if ((resultType = transformationTokenType.getToken().getFeatureTable()) == null) break block13;
                Connection connection2 = connection = Connections.getUniqueConnection(context);
                synchronized (connection2) {
                    String string = resultType.getName();
                    if (string != null) {
                        String string2 = "select TEXT_COLUMN from " + string + " where CASE_COLUMN = ?";
                        sQLHelper.pstmt = connection.prepareStatement(string2);
                        sQLHelper.pstmt.setObject(1, object);
                        sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                        Object object2 = null;
                        if (sQLHelper.rs.next()) {
                            object2 = sQLHelper.rs.getObject("TEXT_COLUMN");
                        }
                        ArrayList<AbstractTextNode.Statistics> arrayList = new ArrayList<AbstractTextNode.Statistics>();
                        String string3 = transformationTokenType.getToken().getPolicy();
                        String string4 = null;
                        string4 = bl ? "WITH doc AS (SELECT TEXT_COLUMN FROM " + string + " WHERE CASE_COLUMN=:1), " + "TOKENS AS (SELECT TEXT_COLUMN, ODMR_ENGINE_TEXT.dm_policy_tokens2(:2, TEXT_COLUMN, :3) \"FEATURES\" FROM doc) " + "SELECT s.ATTRIBUTE_NAME, s.VALUE FROM doc, TOKENS t, TABLE(t.FEATURES) s" : "WITH doc AS (SELECT TEXT_COLUMN FROM " + string + " WHERE CASE_COLUMN=:1), " + "TOKENS AS (SELECT TEXT_COLUMN, ODMR_ENGINE_TEXT.dm_policy_themes2(:2, TEXT_COLUMN, :3, :4) \"FEATURES\" FROM doc) " + "SELECT s.ATTRIBUTE_NAME, s.VALUE FROM doc, TOKENS t, TABLE(t.FEATURES) s";
                        sQLHelper.pstmt = connection.prepareStatement(string4);
                        sQLHelper.pstmt.setFetchSize(50);
                        int n = 1;
                        sQLHelper.pstmt.setObject(n++, object);
                        sQLHelper.pstmt.setString(n++, string3);
                        if (!bl) {
                            sQLHelper.pstmt.setInt(n++, bl2 ? 1 : 0);
                        }
                        sQLHelper.pstmt.setString(n, null);
                        sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                        String string5 = null;
                        Integer n2 = null;
                        while (sQLHelper.rs.next()) {
                            string5 = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                            n2 = sQLHelper.rs.getInt("VALUE");
                            arrayList.add(new AbstractTextNode.Statistics(string5, n2));
                        }
                        String string6 = "";
                        string6 = object2 instanceof BLOB ? BuildTextNode.readBLOBData((BLOB)object2) : (object2 instanceof CLOB ? ((CLOB)object2).getSubString(1L, (int)((CLOB)object2).length()) : (object2 instanceof BFILE ? NodeMessagesLrb.get("BUILD_TEXT_BFILE_NOT_SUPPORTED") : object2.toString()));
                        features = new Features(object, string6, arrayList);
                    }
                }
            }
            catch (Exception exception) {
                Logger.getLogger(BuildTextNode.class.getName()).log(Level.SEVERE, exception.getMessage(), exception);
            }
            finally {
                sQLHelper.close();
                SQLHelper.close(connection);
            }
        }
        return features;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readBLOBData(BLOB bLOB) throws Exception {
        InputStream inputStream = bLOB.getBinaryStream();
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        if (inputStream != null) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            try {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)bufferedInputStream, IdeUtil.getIdeEncoding()));
                if (bufferedReader != null) {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        stringBuilder.append(string + "\n");
                    }
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(BuildTextNode.class.getName()).log(Level.SEVERE, iOException.getMessage(), iOException);
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger(BuildTextNode.class.getName()).log(Level.SEVERE, iOException.getMessage(), iOException);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static class UniqueNameGenerator {
        private Map<String, Boolean> _columnNames = new HashMap<String, Boolean>();
        private int MAX_COLUMN_LEN = 30;

        public UniqueNameGenerator(List<TransformationSourceAttribute> list, List<MapTextTransformedSourceType> list2) {
            if (list != null) {
                for (TransformationSourceAttribute transformationSourceAttribute : list) {
                    this._columnNames.put(transformationSourceAttribute.getName(), Boolean.TRUE);
                }
            }
            if (list2 != null) {
                for (MapTextTransformedSourceType mapTextTransformedSourceType : list2) {
                    this._columnNames.put(mapTextTransformedSourceType.getKey().getName(), Boolean.TRUE);
                }
            }
        }

        public void addNames(List<MapTextTransformedSourceType> list) {
            if (list != null) {
                for (MapTextTransformedSourceType mapTextTransformedSourceType : list) {
                    this._columnNames.put(mapTextTransformedSourceType.getKey().getName(), Boolean.TRUE);
                }
            }
        }

        public String generateUniqueName(String string, String string2) {
            String string3 = null;
            string3 = string + "_" + string2;
            int n = 0;
            while (this._columnNames.containsKey(string3)) {
                string3 = string + "_" + string2 + "_" + ++n;
                int n2 = string3.length();
                if (n2 <= this.MAX_COLUMN_LEN) continue;
                int n3 = n2 - this.MAX_COLUMN_LEN;
                string3 = string.substring(0, string.length() - n3) + "_" + string2 + "_" + n;
            }
            this._columnNames.put(string3, Boolean.TRUE);
            return string3;
        }
    }

    public static class Features {
        Object _caseId;
        String _column;
        List<AbstractTextNode.Statistics> _features;

        public Features(Object object, String string, List<AbstractTextNode.Statistics> list) {
            this._caseId = object;
            this._column = string;
            this._features = list;
        }

        public Object getCaseId() {
            return this._caseId;
        }

        public String getColumn() {
            return this._column;
        }

        public List<AbstractTextNode.Statistics> getFeatures() {
            return this._features;
        }
    }

    private class Helper {
        TransformationSourceAttributes newAttributes;
        Map<String, AttributeStatus> dependentObjectStatusMap;

        Helper() {
            this.newAttributes = new TransformationSourceAttributes();
            this.dependentObjectStatusMap = new HashMap<String, AttributeStatus>();
        }

        Helper(TransformationSourceAttributes transformationSourceAttributes, Map<String, AttributeStatus> map) {
            this.newAttributes = transformationSourceAttributes;
            this.dependentObjectStatusMap = map;
        }
    }
}

