/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeTemplate;
import oracle.dmt.dataminer.workflow.codegen.ParameterizedSourceDefinitions;
import oracle.dmt.dataminer.workflow.model.AbstractTextNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeRefType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.MapTextTransformedSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeReference;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.dmt.dataminer.workflow.xmlschema.TextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationOutputAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationTokenType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributesType;
import oracle.ide.Context;

public final class BuildTextNodeRef
extends AbstractTextNode {
    public static final String ADD_BUILD_TEXT_REFERENCE = "addBuildTextReference";
    public static final String NODE_REFERENCE = "nodeReference";
    public static final String ADD_ALL_STOPLISTS = "addAllStoplists";

    public BuildTextNodeRef(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public String getHelpTopic() {
        return "build_text_ref_node";
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_TEXT_NODE_NAME");
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_TEXT_SETTINGS_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_TEXT_SETTINGS_ICON"));
    }

    @Override
    public boolean isAllowedConnectionFrom(Node node) {
        return false;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        throw new RuntimeException("This is not allowed");
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        throw new RuntimeException("This is not allowed");
    }

    @Override
    public void initNewInstance(Context context) {
        super.initNewInstance(context);
        BuildTextNodeRefType buildTextNodeRefType = (BuildTextNodeRefType)this.getData();
        NodeReference nodeReference = buildTextNodeRefType.getNodeReference();
        CaseAttributes caseAttributes = new CaseAttributes();
        buildTextNodeRefType.setCaseAttributes(caseAttributes);
        TextNodeType.Stoplists stoplists = new TextNodeType.Stoplists();
        buildTextNodeRefType.setStoplists(stoplists);
        TransformationSourceAttributes transformationSourceAttributes = new TransformationSourceAttributes();
        buildTextNodeRefType.setTransformationSourceAttributes(transformationSourceAttributes);
        TransformedAttributesType transformedAttributesType = new TransformedAttributesType();
        buildTextNodeRefType.setTransformedAttributes(transformedAttributesType);
        buildTextNodeRefType.setStatus(NodeStatusType.INVALID);
    }

    @Override
    public String generateCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, String string) throws Exception {
        List list;
        String string2 = super.generateCode(context, parameterizedSourceDefinitions, string);
        BuildTextNodeRefType buildTextNodeRefType = (BuildTextNodeRefType)this.getData();
        StringBuffer stringBuffer = new StringBuffer();
        TransformedAttributesType transformedAttributesType = buildTextNodeRefType.getTransformedAttributes();
        if (transformedAttributesType != null && (list = transformedAttributesType.getMapTextTransformedSource()) != null && !list.isEmpty()) {
            for (MapTextTransformedSourceType mapTextTransformedSourceType : list) {
                TextTransformationOutputAttributeType textTransformationOutputAttributeType = mapTextTransformedSourceType.getKey();
                if (!textTransformationOutputAttributeType.isIsOutput()) continue;
                String string3 = null;
                String string4 = null;
                boolean bl = true;
                TransformationTokenType transformationTokenType = textTransformationOutputAttributeType.getTransformationElement().getToken();
                if (transformationTokenType == null) {
                    bl = false;
                    transformationTokenType = textTransformationOutputAttributeType.getTransformationElement().getTheme();
                }
                string4 = transformationTokenType.getToken().getPolicy();
                if (transformationTokenType.getToken().getStatisticTable() != null) {
                    string3 = transformationTokenType.getToken().getStatisticTable().getName();
                }
                String string5 = textTransformationOutputAttributeType.getName();
                stringBuffer.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, '" + string4 + "', 'REF_POLICY', '" + string5 + "', 'Referenced Policy'); \n");
                stringBuffer.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, '" + string3 + "', 'REF_TABLE', '" + string5 + "', 'Referenced Feature Table'); \n");
            }
        }
        return CodeTemplate.updateBodyTemplate(string2, "<BUILD_TEXT_SETTING>", stringBuffer.toString());
    }

    @Override
    public boolean validate(boolean bl) {
        boolean bl2 = super.validate(bl);
        if (bl2) {
            bl2 = this.validateNodeReference();
        }
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
        return bl2;
    }

    public boolean validateNodeReference() {
        boolean bl = false;
        BuildTextNodeRefType buildTextNodeRefType = (BuildTextNodeRefType)this.getData();
        NodeReference nodeReference = buildTextNodeRefType.getNodeReference();
        if (nodeReference != null && nodeReference.getNodeId() != null && nodeReference.getNodeId().intValue() > 0 && nodeReference.getNodeName() != null && nodeReference.getNodeName().length() > 0 && nodeReference.getProjectId() != null && nodeReference.getProjectId().intValue() > 0 && nodeReference.getProjectName() != null && nodeReference.getProjectName().length() > 0 && nodeReference.getWorkflowId() != null && nodeReference.getWorkflowId().intValue() > 0 && nodeReference.getWorkflowName() != null && nodeReference.getWorkflowName().length() > 0) {
            bl = true;
        }
        if (!bl) {
            this.addMessage("BUILD_TEXT_REF_NO_REFERENCE", MessageEnumType.INCOMPLETE, new String[0]);
        }
        return bl;
    }

    public static void copyNodeDetails(BuildTextNodeType buildTextNodeType, BuildTextNodeRefType buildTextNodeRefType) {
        AttributeType attributeType;
        int n;
        buildTextNodeRefType.getCaseAttributes().getAttribute().clear();
        for (n = 0; n < buildTextNodeType.getCaseAttributes().getAttribute().size(); ++n) {
            attributeType = (AttributeType)MetaDataHelper.copyMetadataObject(buildTextNodeType.getCaseAttributes().getAttribute().get(n));
            buildTextNodeRefType.getCaseAttributes().getAttribute().add(attributeType);
        }
        buildTextNodeRefType.getStoplists().getStoplist().clear();
        for (n = 0; n < buildTextNodeType.getStoplists().getStoplist().size(); ++n) {
            attributeType = (StoplistType)MetaDataHelper.copyMetadataObject(buildTextNodeType.getStoplists().getStoplist().get(n));
            buildTextNodeRefType.getStoplists().getStoplist().add(attributeType);
        }
        buildTextNodeRefType.getTransformationSourceAttributes().getTransformationSourceAttributeType().clear();
        for (n = 0; n < buildTextNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType().size(); ++n) {
            attributeType = (TransformationSourceAttribute)buildTextNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType().get(n);
            TransformationSourceAttribute transformationSourceAttribute = (TransformationSourceAttribute)MetaDataHelper.copyMetadataObject(attributeType);
            buildTextNodeRefType.getTransformationSourceAttributes().getTransformationSourceAttributeType().add(transformationSourceAttribute);
        }
        buildTextNodeRefType.getTransformedAttributes().getMapTextTransformedSource().clear();
        TransformedAttributesType transformedAttributesType = (TransformedAttributesType)MetaDataHelper.copyMetadataObject(buildTextNodeType.getTransformedAttributes());
        buildTextNodeRefType.setTransformedAttributes(transformedAttributesType);
    }

    @Override
    public Object getProperty(String string) {
        BuildTextNodeRefType buildTextNodeRefType = (BuildTextNodeRefType)this.getData();
        Object object = null;
        if (string.equals(NODE_REFERENCE)) {
            NodeReference nodeReference;
            object = nodeReference = buildTextNodeRefType.getNodeReference();
        } else if (string.equals("allXfomNodeColumns")) {
            object = AttributeTypeHelper.getAllColumns((TextNodeType)buildTextNodeRefType);
        } else if (string.equals(ADD_ALL_STOPLISTS)) {
            object = buildTextNodeRefType.getStoplists();
        } else {
            return super.getProperty(string);
        }
        return object;
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(NODE_REFERENCE)) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public void setProperty(String string, Object object) {
        BuildTextNodeRefType buildTextNodeRefType = (BuildTextNodeRefType)this.getData();
        if (string.equals(NODE_REFERENCE)) {
            if (object instanceof NodeReference) {
                buildTextNodeRefType.setNodeReference((NodeReference)object);
            } else {
                buildTextNodeRefType.setNodeReference(null);
            }
        } else if (string.equals("allXfomNodeColumns")) {
            AttributeTypeHelper.TextTransformationNodeColumns textTransformationNodeColumns = (AttributeTypeHelper.TextTransformationNodeColumns)object;
            AttributeTypeHelper.copyTransformedAttributesType(buildTextNodeRefType.getTransformedAttributes(), textTransformationNodeColumns.getXformedAttributes());
            AttributeTypeHelper.copyTransformationSourceAttributes(buildTextNodeRefType.getTransformationSourceAttributes().getTransformationSourceAttributeType(), textTransformationNodeColumns.getXformSourceAttributes().getTransformationSourceAttributeType());
        } else if (string.equals(ADD_ALL_STOPLISTS)) {
            TextNodeType.Stoplists stoplists = (TextNodeType.Stoplists)object;
            buildTextNodeRefType.setStoplists((TextNodeType.Stoplists)object);
        } else {
            super.setProperty(string, object);
        }
    }
}

