/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import ilog.views.sdm.model.IlvSDMNode;
import java.awt.Component;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.MiningAlgorithms;
import oracle.dmt.dataminer.server.model.RowDiagnosticTableDetails;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.codegen.CodeGenLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeTemplate;
import oracle.dmt.dataminer.workflow.codegen.DatabaseObjectType;
import oracle.dmt.dataminer.workflow.codegen.ParameterizedSourceDefinitions;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.GeneralLink;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.model.RowDiagnosticsProvider;
import oracle.dmt.dataminer.workflow.model.SupervisedBuildNode;
import oracle.dmt.dataminer.workflow.preferences.ClassificationModelBuildPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CGeneralizedLinearAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.CGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.CSupportVectorMachineAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.CSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationTestSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.CostMatrixType;
import oracle.dmt.dataminer.workflow.xmlschema.DecisionTreeAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.DecisionTreeModelType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NaiveBayesAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.NaiveBayesModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.PerformanceType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestDataSource;
import oracle.dmt.dataminer.workflow.xmlschema.TuningType;
import oracle.dmt.dataminer.workflow.xmlschema.WeightsType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.Pair;
import oracle.javatools.util.Version;

public final class ClassificationBuildNode
extends SupervisedBuildNode
implements RowDiagnosticsProvider {
    private static final Logger theLogger = Logger.getLogger(ClassificationBuildNode.class.getName());
    public static final String PERFORMANCE = "BUILD_SETTING_PERFORM_OPTION";
    public static final String NBSETTINGS = "naiveBayesSettings";
    public static final String PAIRWISETHRESHOLD = "PAIRWISETHRESHOLD";
    public static final String SINGLETONTHRESHOLD = "SINGLETONTHRESHOLD";
    public static final String DTSETTINGS = "decisionTreeSettings";
    public static final String TREE_IMPURITY_METRIC = "TREE_IMPURITY_METRIC";
    public static final String TREE_TERM_MAX_DEPTH = "TREE_TERM_MAX_DEPTH";
    public static final String TREE_TERM_MINREC_NODE = "TREE_TERM_MINREC_NODE";
    public static final String TREE_TERM_MINPCT_NODE = "TREE_TERM_MINPCT_NODE";
    public static final String TREE_TERM_MINREC_SPLIT = "TREE_TERM_MINREC_SPLIT";
    public static final String TREE_TERM_MINPCT_SPLIT = "TREE_TERM_MINPCT_SPLIT";
    public static final String SVMSETTINGS = "svmSettings";
    public static final String SVMS_KERNEL_FUNCTION = "SVMS_KERNEL_FUNCTION";
    public static final String SVMS_CONV_TOLERANCE = "SVMS_CONV_TOLERANCE";
    public static final String SVMS_COMPLEXITY_FACTOR = "SVMS_COMPLEXITY_FACTOR";
    public static final String SVMS_ACTIVE_LEARNING = "SVMS_ACTIVE_LEARNING";
    public static final String SVMS_STD_DEV = "SVMS_STD_DEV";
    public static final String SVMS_KERNEL_CACHE_SIZE = "SVMS_KERNEL_CACHE_SIZE";
    public static final String GLMSETTINGS = "glmSettings";
    public static final String GLMS_CONF_LEVEL = "GLMS_CONF_LEVEL";
    public static final String GLMS_DIAGNOSTICS_TABLE_NAME = "GLMS_DIAGNOSTICS_TABLE_NAME";
    public static final String GLMS_REFERENCE_CLASS_NAME = "GLMS_REFERENCE_CLASS_NAME";
    public static final String GLMS_RIDGE_REGRESSION = "GLMS_RIDGE_REGRESSION";
    public static final String GLMS_RIDGE_VALUE = "GLMS_RIDGE_VALUE";
    public static final String GLMS_VIF_FOR_RIDGE = "GLMS_VIF_FOR_RIDGE";
    public static final String GLMS_MISSING_VALUE_TREATMENT = "GLMS_MISSING_VALUE_TREATMENT";
    public static final String GLMS_ROW_WEIGHT_COLUMN_NAME = "GLMS_ROW_WEIGHT_COLUMN_NAME";
    public static final String COST_BENEFIT = "costBenefit";
    public static final String TUNING_CHANGED = "tuningChanged";
    public static final String TEST_RESULTS = "classTestResults";
    public static final String GEN_ACCURACY_METRICS = "genAccuracyMetrics";
    public static final String GEN_CONFUSION_MATRIX = "genConfusionMatrix";
    public static final String GEN_ROC_CURVE = "genROC";
    public static final String GEN_LIFT_AND_PROFIT = "genLiftProfit";
    public static final String GEN_FOR_TUNING = "genTuning";
    public static final String ALL_WEIGHT_TABLES_REMOVED = "allweightsRemoved";
    public static final String ALL_WEIGHT_TABLES_RESTORED = "allweightsRestored";
    private static Preferences _p = Preferences.getPreferences();
    private ClassificationModelBuildPreferencesPanelSettings classBuildPref = ClassificationModelBuildPreferencesPanelSettings.getInstance((PropertyStorage)_p);

    public ClassificationBuildNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public void initNewInstance(Context context) {
        String string;
        TestDataSource.SplitData splitData;
        Object object;
        super.initNewInstance(context);
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        Preferences preferences = Preferences.getPreferences();
        ClassificationModelBuildPreferencesPanelSettings classificationModelBuildPreferencesPanelSettings = ClassificationModelBuildPreferencesPanelSettings.getInstance((PropertyStorage)preferences);
        if (classificationModelBuildPreferencesPanelSettings.getTestDataOption().equals("TEST_DATA_OPTION_ALL")) {
            object = new TestDataSource.BuildData();
            classificationBuildNodeType.getTestDataSource().setBuildData((TestDataSource.BuildData)object);
        } else if (classificationModelBuildPreferencesPanelSettings.getTestDataOption().equals("TEST_DATA_OPTION_SPLIT")) {
            object = (double)classificationModelBuildPreferencesPanelSettings.getTestSplitPercent();
            splitData = new TestDataSource.SplitData();
            splitData.setTestPercent(((Double)object).doubleValue());
            string = classificationModelBuildPreferencesPanelSettings.createSplitAsTable() ? "Table" : "View";
            splitData.setDataFormat(string);
            classificationBuildNodeType.getTestDataSource().setSplitData(splitData);
        } else {
            object = new TestDataSource.TestData();
            classificationBuildNodeType.getTestDataSource().setTestData((TestDataSource.TestData)object);
        }
        object = new ClassificationTestSettingsType();
        if (classificationModelBuildPreferencesPanelSettings.isTOPN()) {
            splitData = new ClassificationTestSettingsType.TopNTargets();
            splitData.setValue(BigInteger.valueOf(classificationModelBuildPreferencesPanelSettings.getNTarget()));
            object.setTopNTargets((ClassificationTestSettingsType.TopNTargets)splitData);
        } else {
            splitData = new ClassificationTestSettingsType.BottomNTargets();
            splitData.setValue(BigInteger.valueOf(classificationModelBuildPreferencesPanelSettings.getNTarget()));
            object.setBottomNTargets((ClassificationTestSettingsType.BottomNTargets)splitData);
        }
        classificationBuildNodeType.setTestSettings((ClassificationTestSettingsType)object);
        splitData = new ClassificationBuildNodeType.Models();
        string = new ClassificationBuildNodeType.Results();
        classificationBuildNodeType.setModels((ClassificationBuildNodeType.Models)splitData);
        string.setGenAccuracyMetrics(Boolean.valueOf(classificationModelBuildPreferencesPanelSettings.isAccuracyMetrics()));
        string.setGenConfusionMatrix(Boolean.valueOf(classificationModelBuildPreferencesPanelSettings.isConfusionMatrix()));
        string.setGenROC(Boolean.valueOf(classificationModelBuildPreferencesPanelSettings.isROC()));
        string.setGenLift(Boolean.valueOf(classificationModelBuildPreferencesPanelSettings.isLift()));
        string.setGenTuning(Boolean.valueOf(classificationModelBuildPreferencesPanelSettings.isTune()));
        classificationBuildNodeType.setResults((ClassificationBuildNodeType.Results)string);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.classBuildPref.isNb()) {
            arrayList.add("ALGO_NAIVE_BAYES");
        }
        if (this.classBuildPref.isDt()) {
            arrayList.add("ALGO_DECISION_TREE");
        }
        if (this.classBuildPref.isSvm()) {
            arrayList.add("ALGO_SUPPORT_VECTOR_MACHINES");
        }
        if (this.classBuildPref.isGlm()) {
            arrayList.add("ALGO_GENERALIZED_LINEAR_MODEL");
        }
        List<String> list = WorkflowUtils.getNewModelNames(context, "CLASSIFICATION", arrayList);
        int n = 0;
        ModelType modelType = null;
        if (this.classBuildPref.isNb()) {
            modelType = this.createNewClassificationModel(list.get(n), "", (String)arrayList.get(n++));
            modelType.setUseForOutput(true);
            this.addNewNaiveBayesModel((NaiveBayesModelType)modelType);
        }
        if (this.classBuildPref.isDt()) {
            modelType = this.createNewClassificationModel(list.get(n), "", (String)arrayList.get(n++));
            modelType.setUseForOutput(true);
            this.addNewDecisionTreeModel((DecisionTreeModelType)modelType);
        }
        if (this.classBuildPref.isSvm()) {
            modelType = this.createNewClassificationModel(list.get(n), "", (String)arrayList.get(n++));
            modelType.setUseForOutput(true);
            this.addNewSVMModel((CSupportVectorMachineModelType)modelType);
        }
        if (this.classBuildPref.isGlm()) {
            modelType = this.createNewClassificationModel(list.get(n), "", (String)arrayList.get(n));
            modelType.setUseForOutput(true);
            this.addNewGLMModel((CGeneralizedLinearModelType)modelType);
        }
        classificationBuildNodeType.setStatus(NodeStatusType.INVALID);
    }

    public void addNewNaiveBayesModel(NaiveBayesModelType naiveBayesModelType) {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
        List list = models.getNaiveBayesModel();
        list.add(naiveBayesModelType);
    }

    public void addNewDecisionTreeModel(DecisionTreeModelType decisionTreeModelType) {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
        List list = models.getDecisionTreeModel();
        list.add(decisionTreeModelType);
    }

    public void addNewSVMModel(CSupportVectorMachineModelType cSupportVectorMachineModelType) {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
        List list = models.getCSupportVectorMachineModel();
        list.add(cSupportVectorMachineModelType);
    }

    public void addNewGLMModel(CGeneralizedLinearModelType cGeneralizedLinearModelType) {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
        List list = models.getCGeneralizedLinearModel();
        list.add(cGeneralizedLinearModelType);
    }

    public ModelType createNewClassificationModel(String string, String string2, String string3) {
        return this.createNewModel(string, string2, "CLASSIFICATION", string3);
    }

    @Override
    public ModelType createNewModel(String string, String string2, String string3, String string4) {
        ClassificationModelType classificationModelType = (ClassificationModelType)super.createNewModel(string, string2, string3, string4);
        PerformanceType performanceType = new PerformanceType();
        PerformanceType.Balanced balanced = new PerformanceType.Balanced();
        performanceType.setBalanced(balanced);
        TuningType tuningType = new TuningType();
        tuningType.setNone(new TuningType.None());
        classificationModelType.setPerformance(performanceType);
        classificationModelType.setTuning(tuningType);
        return classificationModelType;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void refactor(Node node, boolean bl) throws Exception {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        if (!classificationBuildNodeType.getResults().getClassificationResult().isEmpty()) {
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            ClassificationBuildNodeType.Results results = new ClassificationBuildNodeType.Results();
            results.setGenAccuracyMetrics(classificationBuildNodeType.getResults().isGenAccuracyMetrics());
            results.setGenConfusionMatrix(classificationBuildNodeType.getResults().isGenConfusionMatrix());
            results.setGenLift(classificationBuildNodeType.getResults().isGenLift());
            results.setGenROC(classificationBuildNodeType.getResults().isGenROC());
            results.setGenTuning(classificationBuildNodeType.getResults().isGenTuning());
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), TEST_RESULTS, results);
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), new ComplexProperty(ALL_WEIGHT_TABLES_REMOVED, ALL_WEIGHT_TABLES_RESTORED, MetaDataHelper.getWeightTablesCollection((BuildNodeType)classificationBuildNodeType)));
        }
        super.refactor(node, bl);
    }

    @Override
    protected boolean validateImpl(boolean bl, boolean bl2) {
        boolean bl3 = super.validate(bl);
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
        if (models.getNaiveBayesModel().isEmpty() && models.getDecisionTreeModel().isEmpty() && models.getCSupportVectorMachineModel().isEmpty() && models.getCGeneralizedLinearModel().isEmpty()) {
            this.addMessage("BUILD_MISSING_MODELS", MessageEnumType.INCOMPLETE, new String[0]);
            bl3 = false;
        } else {
            boolean bl4;
            Object object;
            if (bl2) {
                this.setNodeReady();
            }
            if (!this.validateModels(models.getNaiveBayesModel())) {
                bl3 = false;
            }
            if (!this.validateModels(models.getDecisionTreeModel())) {
                bl3 = false;
            }
            if (!this.validateModels(models.getCSupportVectorMachineModel())) {
                bl3 = false;
            }
            if (!this.validateModels(models.getCGeneralizedLinearModel())) {
                bl3 = false;
            }
            HashMap<String, NaiveBayesModelType> hashMap = new HashMap<String, NaiveBayesModelType>();
            for (Object object2 : models.getNaiveBayesModel()) {
                hashMap.put(object2.getId(), (NaiveBayesModelType)object2);
            }
            for (Object object2 : models.getDecisionTreeModel()) {
                hashMap.put(object2.getId(), (NaiveBayesModelType)object2);
            }
            for (Object object2 : models.getCSupportVectorMachineModel()) {
                hashMap.put(object2.getId(), (NaiveBayesModelType)object2);
            }
            for (Object object2 : models.getCGeneralizedLinearModel()) {
                hashMap.put(object2.getId(), (NaiveBayesModelType)object2);
            }
            ClassificationBuildNodeType.Results results = new ClassificationBuildNodeType.Results();
            results.setGenAccuracyMetrics(classificationBuildNodeType.getResults().isGenAccuracyMetrics());
            results.setGenConfusionMatrix(classificationBuildNodeType.getResults().isGenConfusionMatrix());
            results.setGenLift(classificationBuildNodeType.getResults().isGenLift());
            results.setGenROC(classificationBuildNodeType.getResults().isGenROC());
            results.setGenTuning(classificationBuildNodeType.getResults().isGenTuning());
            for (Object object3 : classificationBuildNodeType.getResults().getClassificationResult()) {
                if (!hashMap.containsKey(object3.getModelId())) continue;
                object = (ClassificationResultType)MetaDataHelper.copyMetadataObject(object3);
                results.getClassificationResult().add(object);
            }
            boolean bl5 = bl4 = results.getClassificationResult().size() != classificationBuildNodeType.getResults().getClassificationResult().size();
            if (bl4) {
                Object object3;
                object3 = new ArrayList();
                object = (OdmrSDMUndoFilter)this.getUndoFilter();
                ComplexProperty complexProperty = new ComplexProperty(TEST_RESULTS, results);
                complexProperty.setOldData(classificationBuildNodeType.getResults());
                object3.add(complexProperty);
                ((OdmrSDMUndoFilter)((Object)object)).prepareUndoComplexPropertyList(this, this.getContext(), (List<ComplexProperty>)object3);
            }
        }
        this.setState(bl3);
        if (bl) {
            this.validateChildren();
        }
        return bl3;
    }

    @Override
    public boolean validate(boolean bl) {
        return this.validateImpl(bl, true);
    }

    @Override
    public void setProperty(String string, Object object) {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        if (string.equals(NBSETTINGS)) {
            ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
            List list = models.getNaiveBayesModel();
            if (object == null || !(object instanceof List)) {
                return;
            }
            List list2 = (List)object;
            if (list2.isEmpty()) {
                return;
            }
            String string2 = ((Property)list2.get(0)).getId();
            for (NaiveBayesModelType naiveBayesModelType : list) {
                if (!naiveBayesModelType.getId().equals(string2)) continue;
                NaiveBayesAlgoType naiveBayesAlgoType = naiveBayesModelType.getNaiveBayesAlgo();
                for (Property property : list2) {
                    if (property.getDescription().equals(PAIRWISETHRESHOLD)) {
                        naiveBayesAlgoType.setNABSPAIRWISETHRESHOLD(((Double)property.getValue()).doubleValue());
                        continue;
                    }
                    if (property.getDescription().equals(SINGLETONTHRESHOLD)) {
                        naiveBayesAlgoType.setNABSSINGLETONTHRESHOLD(((Double)property.getValue()).doubleValue());
                        continue;
                    }
                    if (!property.getDescription().equals(PERFORMANCE)) continue;
                    naiveBayesModelType.setPerformance((PerformanceType)property.getValue());
                }
                break;
            }
        } else if (string.equals(DTSETTINGS)) {
            ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
            List list = models.getDecisionTreeModel();
            if (object == null || !(object instanceof List)) {
                return;
            }
            List list3 = (List)object;
            if (list3.isEmpty()) {
                return;
            }
            String string3 = ((Property)list3.get(0)).getId();
            for (DecisionTreeModelType decisionTreeModelType : list) {
                if (!decisionTreeModelType.getId().equals(string3)) continue;
                for (Property property : list3) {
                    BigInteger bigInteger;
                    DecisionTreeAlgoType decisionTreeAlgoType = decisionTreeModelType.getDecisionTreeAlgo();
                    if (decisionTreeAlgoType == null) continue;
                    if (property.getDescription().equals(TREE_IMPURITY_METRIC)) {
                        decisionTreeAlgoType.setTREEIMPURITYMETRIC((String)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(TREE_TERM_MAX_DEPTH)) {
                        decisionTreeAlgoType.setTREETERMMAXDEPTH(((Integer)property.getValue()).intValue());
                        continue;
                    }
                    if (property.getDescription().equals(TREE_TERM_MINREC_NODE)) {
                        bigInteger = new BigInteger(property.getValue().toString());
                        decisionTreeAlgoType.setTREETERMMINRECNODE(bigInteger);
                        continue;
                    }
                    if (property.getDescription().equals(TREE_TERM_MINPCT_NODE)) {
                        decisionTreeAlgoType.setTREETERMMINPCTNODE(((Double)property.getValue()).doubleValue());
                        continue;
                    }
                    if (property.getDescription().equals(TREE_TERM_MINREC_SPLIT)) {
                        bigInteger = new BigInteger(property.getValue().toString());
                        decisionTreeAlgoType.setTREETERMMINRECSPLIT(bigInteger);
                        continue;
                    }
                    if (property.getDescription().equals(TREE_TERM_MINPCT_SPLIT)) {
                        decisionTreeAlgoType.setTREETERMMINPCTSPLIT((double)((Integer)property.getValue()).intValue());
                        continue;
                    }
                    if (!property.getDescription().equals(PERFORMANCE)) continue;
                    decisionTreeModelType.setPerformance((PerformanceType)property.getValue());
                }
                break;
            }
        } else if (string.equals(SVMSETTINGS)) {
            ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
            List list = models.getCSupportVectorMachineModel();
            if (object == null || !(object instanceof List)) {
                return;
            }
            List list4 = (List)object;
            if (list4.isEmpty()) {
                return;
            }
            String string4 = ((Property)list4.get(0)).getId();
            for (CSupportVectorMachineModelType cSupportVectorMachineModelType : list) {
                if (!cSupportVectorMachineModelType.getId().equals(string4)) continue;
                for (Property property : list4) {
                    CSupportVectorMachineAlgoType cSupportVectorMachineAlgoType = cSupportVectorMachineModelType.getCSupportVectorMachineAlgo();
                    if (property.getDescription().equals(SVMS_KERNEL_FUNCTION)) {
                        cSupportVectorMachineAlgoType.setSVMSKERNELFUNCTION((String)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_CONV_TOLERANCE)) {
                        cSupportVectorMachineAlgoType.setSVMSCONVTOLERANCE(((Double)property.getValue()).doubleValue());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_COMPLEXITY_FACTOR)) {
                        cSupportVectorMachineAlgoType.setSVMSCOMPLEXITYFACTOR((Double)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_ACTIVE_LEARNING)) {
                        cSupportVectorMachineAlgoType.setSVMSACTIVELEARNING((String)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_STD_DEV)) {
                        cSupportVectorMachineAlgoType.setSVMSSTDDEV((Double)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_KERNEL_CACHE_SIZE)) {
                        Object object2 = property.getValue();
                        if (object2 == null) {
                            cSupportVectorMachineAlgoType.setSVMSKERNELCACHESIZE(null);
                            continue;
                        }
                        BigInteger bigInteger = new BigInteger(object2.toString());
                        cSupportVectorMachineAlgoType.setSVMSKERNELCACHESIZE(bigInteger);
                        continue;
                    }
                    if (!property.getDescription().equals(PERFORMANCE)) continue;
                    cSupportVectorMachineModelType.setPerformance((PerformanceType)property.getValue());
                }
                break;
            }
        } else if (string.equals(GLMSETTINGS)) {
            ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
            List list = models.getCGeneralizedLinearModel();
            if (object == null || !(object instanceof List)) {
                return;
            }
            List list5 = (List)object;
            if (list5.isEmpty()) {
                return;
            }
            String string5 = ((Property)list5.get(0)).getId();
            for (CGeneralizedLinearModelType cGeneralizedLinearModelType : list) {
                if (!cGeneralizedLinearModelType.getId().equals(string5)) continue;
                for (Property property : list5) {
                    CGeneralizedLinearAlgoType cGeneralizedLinearAlgoType = cGeneralizedLinearModelType.getCGeneralizedLinearAlgo();
                    if (property.getDescription().equals(GLMS_CONF_LEVEL)) {
                        cGeneralizedLinearAlgoType.setGLMSCONFLEVEL(((Double)property.getValue()).doubleValue());
                        continue;
                    }
                    if (property.getDescription().equals(GLMS_DIAGNOSTICS_TABLE_NAME)) {
                        cGeneralizedLinearAlgoType.setGLMSDIAGNOSTICSTABLENAME((String)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(GLMS_REFERENCE_CLASS_NAME)) {
                        cGeneralizedLinearAlgoType.setGLMSREFERENCECLASSNAME((String)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(GLMS_RIDGE_REGRESSION)) {
                        cGeneralizedLinearAlgoType.setGLMSRIDGEREGRESSION((String)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(GLMS_RIDGE_VALUE)) {
                        cGeneralizedLinearAlgoType.setGLMSRIDGEVALUE((Double)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(GLMS_VIF_FOR_RIDGE)) {
                        cGeneralizedLinearAlgoType.setGLMSVIFFORRIDGE((String)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(GLMS_MISSING_VALUE_TREATMENT)) {
                        cGeneralizedLinearAlgoType.setODMSMISSINGVALUETREATMENT((String)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(GLMS_ROW_WEIGHT_COLUMN_NAME)) {
                        cGeneralizedLinearAlgoType.setODMSROWWEIGHTCOLUMNNAME((String)property.getValue());
                        continue;
                    }
                    if (!property.getDescription().equals(PERFORMANCE)) continue;
                    cGeneralizedLinearModelType.setPerformance((PerformanceType)property.getValue());
                }
                break;
            }
        } else if (string.equals("modelAdded")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list6 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)classificationBuildNodeType, modelType);
                if (list6.contains(modelType)) continue;
                MetaDataHelper.addModel((BuildNodeType)classificationBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelRemoved")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list7 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)classificationBuildNodeType, modelType);
                if (!list7.contains(modelType)) continue;
                MetaDataHelper.removeModel((BuildNodeType)classificationBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("splitValueChanged")) {
            if (object == null || !(object instanceof Double)) {
                return;
            }
            Double d = (Double)object;
            TestDataSource testDataSource = classificationBuildNodeType.getTestDataSource();
            if (testDataSource.getSplitData().getTestPercent() != d.doubleValue()) {
                testDataSource.getSplitData().setTestPercent(d.doubleValue());
            }
        } else if (string.equals("splitDataFormat")) {
            String string6 = (String)object;
            TestDataSource testDataSource = classificationBuildNodeType.getTestDataSource();
            if (string6 == null || testDataSource.getSplitData().getDataFormat() == null || !testDataSource.getSplitData().getDataFormat().equals(string6)) {
                testDataSource.getSplitData().setDataFormat(string6);
            }
        } else if (string.equals("testOptionsChanged")) {
            if (object == null || !(object instanceof TestDataSource)) {
                return;
            }
            TestDataSource testDataSource = (TestDataSource)object;
            classificationBuildNodeType.setTestDataSource(testDataSource);
        } else if (string.equals("alltestsForTuningRemoved")) {
            ClassificationBuildNodeType classificationBuildNodeType2 = (ClassificationBuildNodeType)this.getData();
            if (classificationBuildNodeType2.getResults() != null && !classificationBuildNodeType2.getResults().getClassificationResultForTuning().isEmpty()) {
                classificationBuildNodeType2.getResults().getClassificationResultForTuning().clear();
            }
        } else if (string.equals("testsForTuningRemoved")) {
            List list = (List)object;
            ClassificationBuildNodeType classificationBuildNodeType3 = (ClassificationBuildNodeType)this.getData();
            List list8 = classificationBuildNodeType3.getResults().getClassificationResultForTuning();
            block10: for (MiningResultType miningResultType : list) {
                for (ClassificationResultType classificationResultType : list8) {
                    if (!classificationResultType.getModelId().equals(miningResultType.getModelId())) continue;
                    list8.remove(classificationResultType);
                    continue block10;
                }
            }
        } else if (string.equals("alltestsForTuningRestored")) {
            List list = (List)object;
            ClassificationBuildNodeType classificationBuildNodeType4 = (ClassificationBuildNodeType)this.getData();
            classificationBuildNodeType4.getResults().getClassificationResultForTuning().clear();
            classificationBuildNodeType4.getResults().getClassificationResultForTuning().addAll(list);
        } else if (string.equals("testsForTuningRestored")) {
            Object object32;
            ClassificationBuildNodeType classificationBuildNodeType5 = (ClassificationBuildNodeType)this.getData();
            List list = classificationBuildNodeType5.getResults().getClassificationResultForTuning();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (Object object32 : list) {
                hashMap.put(object32.getModelId(), object32);
            }
            List list9 = (List)object;
            object32 = list9.iterator();
            while (object32.hasNext()) {
                ClassificationResultType classificationResultType = (ClassificationResultType)object32.next();
                if (null != hashMap.get(classificationResultType.getModelId())) continue;
                list.add(classificationResultType);
            }
        } else if (string.equals("alltestsRemoved")) {
            ClassificationBuildNodeType classificationBuildNodeType6 = (ClassificationBuildNodeType)this.getData();
            if (classificationBuildNodeType6.getResults() != null && !classificationBuildNodeType6.getResults().getClassificationResult().isEmpty()) {
                classificationBuildNodeType6.getResults().getClassificationResult().clear();
            }
        } else if (string.equals("testsRemoved")) {
            List list = (List)object;
            ClassificationBuildNodeType classificationBuildNodeType7 = (ClassificationBuildNodeType)this.getData();
            List list10 = classificationBuildNodeType7.getResults().getClassificationResult();
            block14: for (MiningResultType miningResultType : list) {
                for (ClassificationResultType classificationResultType : list10) {
                    if (!classificationResultType.getModelId().equals(miningResultType.getModelId())) continue;
                    list10.remove(classificationResultType);
                    continue block14;
                }
            }
        } else if (string.equals("alltestsRestored")) {
            List list = (List)object;
            ClassificationBuildNodeType classificationBuildNodeType8 = (ClassificationBuildNodeType)this.getData();
            classificationBuildNodeType8.getResults().getClassificationResult().clear();
            classificationBuildNodeType8.getResults().getClassificationResult().addAll(list);
        } else if (string.equals("testsRestored")) {
            Object object42;
            ClassificationBuildNodeType classificationBuildNodeType9 = (ClassificationBuildNodeType)this.getData();
            List list = classificationBuildNodeType9.getResults().getClassificationResult();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (Object object42 : list) {
                hashMap.put(object42.getModelId(), object42);
            }
            List list11 = (List)object;
            object42 = list11.iterator();
            while (object42.hasNext()) {
                ClassificationResultType classificationResultType = (ClassificationResultType)object42.next();
                if (null != hashMap.get(classificationResultType.getModelId())) continue;
                list.add(classificationResultType);
            }
        } else if (string.equals(ALL_WEIGHT_TABLES_REMOVED)) {
            PerformanceType.Balanced balanced;
            Object object5;
            Object object6;
            Object object72;
            ClassificationBuildNodeType classificationBuildNodeType10 = (ClassificationBuildNodeType)this.getData();
            List list = classificationBuildNodeType10.getModels().getCGeneralizedLinearModel();
            for (Object object72 : list) {
                object6 = object72.getPerformance().getBalanced();
                if (object6 == null) continue;
                object6.setWeightsTable(null);
            }
            List list12 = classificationBuildNodeType10.getModels().getCSupportVectorMachineModel();
            object72 = list12.iterator();
            while (object72.hasNext()) {
                object6 = (CSupportVectorMachineModelType)object72.next();
                object5 = object6.getPerformance().getBalanced();
                if (object5 == null) continue;
                object5.setWeightsTable(null);
            }
            object72 = classificationBuildNodeType10.getModels().getDecisionTreeModel();
            object6 = object72.iterator();
            while (object6.hasNext()) {
                object5 = (DecisionTreeModelType)object6.next();
                balanced = object5.getPerformance().getBalanced();
                if (balanced == null) continue;
                balanced.setWeightsTable(null);
            }
            object6 = classificationBuildNodeType10.getModels().getNaiveBayesModel();
            object5 = object6.iterator();
            while (object5.hasNext()) {
                balanced = (NaiveBayesModelType)object5.next();
                PerformanceType.Balanced balanced2 = balanced.getPerformance().getBalanced();
                if (balanced2 == null) continue;
                balanced2.setWeightsTable(null);
            }
        } else if (string.equals(ALL_WEIGHT_TABLES_RESTORED)) {
            Object object8;
            Object object9;
            Object object10;
            Object object11;
            Object object122;
            HashMap hashMap = (HashMap)object;
            ClassificationBuildNodeType classificationBuildNodeType11 = (ClassificationBuildNodeType)this.getData();
            List list = classificationBuildNodeType11.getModels().getCGeneralizedLinearModel();
            for (Object object122 : list) {
                object11 = (String)hashMap.get(object122.getId());
                if (object11 == null || (object10 = object122.getPerformance().getBalanced()) == null) continue;
                object10.setWeightsTable((String)object11);
            }
            List list13 = classificationBuildNodeType11.getModels().getCSupportVectorMachineModel();
            object122 = list13.iterator();
            while (object122.hasNext()) {
                object11 = (CSupportVectorMachineModelType)object122.next();
                object10 = (String)hashMap.get(object11.getId());
                if (object10 == null || (object9 = object11.getPerformance().getBalanced()) == null) continue;
                object9.setWeightsTable((String)object10);
            }
            object122 = classificationBuildNodeType11.getModels().getDecisionTreeModel();
            object11 = object122.iterator();
            while (object11.hasNext()) {
                object10 = (DecisionTreeModelType)object11.next();
                object9 = (String)hashMap.get(object10.getId());
                if (object9 == null || (object8 = object10.getPerformance().getBalanced()) == null) continue;
                object8.setWeightsTable((String)object9);
            }
            object11 = classificationBuildNodeType11.getModels().getNaiveBayesModel();
            object10 = object11.iterator();
            while (object10.hasNext()) {
                PerformanceType.Balanced balanced;
                object9 = (NaiveBayesModelType)object10.next();
                object8 = (String)hashMap.get(object9.getId());
                if (object8 == null || (balanced = object9.getPerformance().getBalanced()) == null) continue;
                balanced.setWeightsTable((String)object8);
            }
        } else if (string.equals(GEN_ACCURACY_METRICS)) {
            Boolean bl = (Boolean)object;
            ClassificationBuildNodeType.Results results = classificationBuildNodeType.getResults();
            if (bl == null || !bl.equals(results.isGenAccuracyMetrics())) {
                results.setGenAccuracyMetrics(bl);
            }
        } else if (string.equals(GEN_CONFUSION_MATRIX)) {
            Boolean bl = (Boolean)object;
            ClassificationBuildNodeType.Results results = classificationBuildNodeType.getResults();
            if (bl == null || !bl.equals(results.isGenConfusionMatrix())) {
                results.setGenConfusionMatrix(bl);
            }
        } else if (string.equals(GEN_ROC_CURVE)) {
            Boolean bl = (Boolean)object;
            ClassificationBuildNodeType.Results results = classificationBuildNodeType.getResults();
            if (bl == null || !bl.equals(results.isGenROC())) {
                results.setGenROC(bl);
            }
        } else if (string.equals(GEN_LIFT_AND_PROFIT)) {
            Boolean bl = (Boolean)object;
            ClassificationBuildNodeType.Results results = classificationBuildNodeType.getResults();
            if (bl == null || !bl.equals(results.isGenLift())) {
                results.setGenLift(bl);
            }
        } else if (string.equals(GEN_FOR_TUNING)) {
            Boolean bl = (Boolean)object;
            ClassificationBuildNodeType.Results results = classificationBuildNodeType.getResults();
            if (bl == null || !bl.equals(results.isGenTuning())) {
                results.setGenTuning(bl);
            }
        } else if (string.equals("testSettingsChanged")) {
            if (object == null || !(object instanceof ClassificationTestSettingsType)) {
                return;
            }
            ClassificationTestSettingsType classificationTestSettingsType = (ClassificationTestSettingsType)object;
            classificationBuildNodeType.setTestSettings(classificationTestSettingsType);
        } else if (string.equals(TUNING_CHANGED)) {
            if (object == null || !(object instanceof Map)) {
                return;
            }
            Map map = (Map)object;
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            ClassificationBuildNodeType classificationBuildNodeType12 = (ClassificationBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string7 = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)classificationBuildNodeType12, string7);
                ((ClassificationModelType)modelType).setTuning((TuningType)map.get(string7));
            }
        } else if (string.equals("testsRerun")) {
            List<ClassificationResultType> list = MetaDataHelper.getClassResultsCollection(this);
            Map map = (Map)object;
            for (ClassificationResultType classificationResultType : list) {
                ModelStatusType modelStatusType = (ModelStatusType)map.get(classificationResultType.getModelId());
                if (null == modelStatusType) continue;
                classificationResultType.setStatus(modelStatusType);
            }
        } else if (string.equals("modelsRerun")) {
            Map map = (Map)object;
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            ClassificationBuildNodeType classificationBuildNodeType13 = (ClassificationBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string8 = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)classificationBuildNodeType13, string8);
                modelType.setStatus((ModelStatusType)map.get(string8));
            }
        } else if (string.equals("modelUseForOutput")) {
            if (object == null || !(object instanceof ArrayList)) {
                return;
            }
            List list = (List)object;
            ClassificationBuildNodeType classificationBuildNodeType14 = (ClassificationBuildNodeType)this.getData();
            for (Pair pair : list) {
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)classificationBuildNodeType14, (String)pair.getFirst());
                modelType.setUseForOutput(((Boolean)pair.getSecond()).booleanValue());
            }
        } else if (string.equals(TEST_RESULTS)) {
            classificationBuildNodeType.setResults((ClassificationBuildNodeType.Results)object);
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(SVMSETTINGS) || complexProperty.getPropertyName().equals(NBSETTINGS) || complexProperty.getPropertyName().equals(GLMSETTINGS) || complexProperty.getPropertyName().equals(DTSETTINGS)) {
            List list = (List)complexProperty.getData();
            ArrayList<Property> arrayList = new ArrayList<Property>(list.size());
            for (Property property : list) {
                String string = property.getId();
                String string2 = property.getDescription();
                Object object = this.getOldPropertyValue(string, string2);
                Property property2 = new Property(string, null, object, string2, null);
                arrayList.add(property2);
            }
            return arrayList;
        }
        if (complexProperty.getPropertyName().equals(TUNING_CHANGED)) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, TuningType> hashMap = new HashMap<String, TuningType>(map.size());
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)classificationBuildNodeType, string);
                hashMap.put(string, ((ClassificationModelType)modelType).getTuning());
            }
            return hashMap;
        }
        if (complexProperty.getPropertyName().equals("modelsRerun")) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>(map.size());
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)classificationBuildNodeType, string);
                hashMap.put(string, modelType.getStatus());
            }
            return hashMap;
        }
        if (complexProperty.getPropertyName().equals("modelUseForOutput")) {
            List list = (List)complexProperty.getData();
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            for (Pair pair : list) {
                String string = (String)pair.getFirst();
                ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)classificationBuildNodeType, string);
                boolean bl = modelType.isUseForOutput();
                Pair pair2 = new Pair((Object)string, (Object)bl);
                arrayList.add(pair2);
            }
            return arrayList;
        }
        if (complexProperty.getPropertyName().equals("testsRerun")) {
            List<ClassificationResultType> list = MetaDataHelper.getClassResultsCollection(this);
            Map map = (Map)complexProperty.getData();
            HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>(map.size());
            for (ClassificationResultType classificationResultType : list) {
                if (null == map.get(classificationResultType.getModelId())) continue;
                hashMap.put(classificationResultType.getModelId(), classificationResultType.getStatus());
            }
            return hashMap;
        }
        return super.getProperty(complexProperty);
    }

    private Object getOldPropertyValue(String string, String string2) {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)classificationBuildNodeType, string);
        if (modelType == null) {
            return null;
        }
        if (modelType instanceof CSupportVectorMachineModelType) {
            CSupportVectorMachineAlgoType cSupportVectorMachineAlgoType = ((CSupportVectorMachineModelType)modelType).getCSupportVectorMachineAlgo();
            if (string2.equals(SVMS_KERNEL_FUNCTION)) {
                return cSupportVectorMachineAlgoType.getSVMSKERNELFUNCTION();
            }
            if (string2.equals(SVMS_CONV_TOLERANCE)) {
                return cSupportVectorMachineAlgoType.getSVMSCONVTOLERANCE();
            }
            if (string2.equals(SVMS_COMPLEXITY_FACTOR)) {
                return cSupportVectorMachineAlgoType.getSVMSCOMPLEXITYFACTOR();
            }
            if (string2.equals(SVMS_ACTIVE_LEARNING)) {
                return cSupportVectorMachineAlgoType.getSVMSACTIVELEARNING();
            }
            if (string2.equals(SVMS_STD_DEV)) {
                return cSupportVectorMachineAlgoType.getSVMSSTDDEV();
            }
            if (string2.equals(SVMS_KERNEL_CACHE_SIZE)) {
                return cSupportVectorMachineAlgoType.getSVMSKERNELCACHESIZE();
            }
            if (string2.equals(PERFORMANCE)) {
                return ((CSupportVectorMachineModelType)modelType).getPerformance();
            }
        } else if (modelType instanceof NaiveBayesModelType) {
            NaiveBayesAlgoType naiveBayesAlgoType = ((NaiveBayesModelType)modelType).getNaiveBayesAlgo();
            if (string2.equals("NABS_PAIRWISE_THRESHOLD")) {
                return naiveBayesAlgoType.getNABSPAIRWISETHRESHOLD();
            }
            if (string2.equals("NABS_SINGLETON_THRESHOLD")) {
                return naiveBayesAlgoType.getNABSSINGLETONTHRESHOLD();
            }
            if (string2.equals(PERFORMANCE)) {
                return ((NaiveBayesModelType)modelType).getPerformance();
            }
        } else if (modelType instanceof DecisionTreeModelType) {
            DecisionTreeAlgoType decisionTreeAlgoType = ((DecisionTreeModelType)modelType).getDecisionTreeAlgo();
            if (string2.equals(TREE_IMPURITY_METRIC)) {
                return decisionTreeAlgoType.getTREEIMPURITYMETRIC();
            }
            if (string2.equals(TREE_TERM_MAX_DEPTH)) {
                return decisionTreeAlgoType.getTREETERMMAXDEPTH();
            }
            if (string2.equals(TREE_TERM_MINREC_NODE)) {
                return decisionTreeAlgoType.getTREETERMMINRECNODE();
            }
            if (string2.equals(TREE_TERM_MINPCT_NODE)) {
                return decisionTreeAlgoType.getTREETERMMINPCTNODE();
            }
            if (string2.equals(TREE_TERM_MINREC_SPLIT)) {
                return decisionTreeAlgoType.getTREETERMMINRECSPLIT();
            }
            if (string2.equals(TREE_TERM_MINPCT_SPLIT)) {
                return decisionTreeAlgoType.getTREETERMMINPCTSPLIT();
            }
            if (string2.equals(PERFORMANCE)) {
                return ((DecisionTreeModelType)modelType).getPerformance();
            }
        } else if (modelType instanceof CGeneralizedLinearModelType) {
            CGeneralizedLinearAlgoType cGeneralizedLinearAlgoType = ((CGeneralizedLinearModelType)modelType).getCGeneralizedLinearAlgo();
            if (string2.equals(GLMS_DIAGNOSTICS_TABLE_NAME)) {
                return cGeneralizedLinearAlgoType.getGLMSDIAGNOSTICSTABLENAME();
            }
            if (string2.equals(GLMS_CONF_LEVEL)) {
                return cGeneralizedLinearAlgoType.getGLMSCONFLEVEL();
            }
            if (string2.equals(GLMS_RIDGE_REGRESSION)) {
                return cGeneralizedLinearAlgoType.getGLMSRIDGEREGRESSION();
            }
            if (string2.equals(GLMS_REFERENCE_CLASS_NAME)) {
                return cGeneralizedLinearAlgoType.getGLMSREFERENCECLASSNAME();
            }
            if (string2.equals(GLMS_RIDGE_VALUE)) {
                return cGeneralizedLinearAlgoType.getGLMSRIDGEVALUE();
            }
            if (string2.equals(GLMS_VIF_FOR_RIDGE)) {
                return cGeneralizedLinearAlgoType.getGLMSVIFFORRIDGE();
            }
            if (string2.equals(PERFORMANCE)) {
                return ((CGeneralizedLinearModelType)modelType).getPerformance();
            }
        }
        return null;
    }

    @Override
    public Object getProperty(String string) {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        if (string.equals("splitValueChanged")) {
            TestDataSource testDataSource = classificationBuildNodeType.getTestDataSource();
            double d = testDataSource.getSplitData().getTestPercent();
            return d;
        }
        if (string.equals("splitDataFormat")) {
            TestDataSource testDataSource = classificationBuildNodeType.getTestDataSource();
            String string2 = testDataSource.getSplitData().getDataFormat();
            return string2;
        }
        if (string.equals("testOptionsChanged")) {
            return classificationBuildNodeType.getTestDataSource();
        }
        if (string.equals(GEN_ACCURACY_METRICS)) {
            ClassificationBuildNodeType.Results results = classificationBuildNodeType.getResults();
            return results.isGenAccuracyMetrics();
        }
        if (string.equals(GEN_CONFUSION_MATRIX)) {
            ClassificationBuildNodeType.Results results = classificationBuildNodeType.getResults();
            return results.isGenConfusionMatrix();
        }
        if (string.equals(GEN_ROC_CURVE)) {
            ClassificationBuildNodeType.Results results = classificationBuildNodeType.getResults();
            return results.isGenROC();
        }
        if (string.equals(GEN_LIFT_AND_PROFIT)) {
            ClassificationBuildNodeType.Results results = classificationBuildNodeType.getResults();
            return results.isGenLift();
        }
        if (string.equals(GEN_FOR_TUNING)) {
            ClassificationBuildNodeType.Results results = classificationBuildNodeType.getResults();
            return results.isGenTuning();
        }
        if (string.equals("testSettingsChanged")) {
            return classificationBuildNodeType.getTestSettings();
        }
        if (string.equals(TEST_RESULTS)) {
            return classificationBuildNodeType.getResults();
        }
        return super.getProperty(string);
    }

    @Override
    public MiningFunctionType getMiningFunctionType() {
        return MiningFunctionType.CLASSIFICATION;
    }

    @Override
    public List<RefModelType> getGLMRowDiagnosticModels() throws Exception {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        List list = classificationBuildNodeType.getModels().getCGeneralizedLinearModel();
        MiningFunctionType miningFunctionType = MiningFunctionType.CLASSIFICATION;
        String string = classificationBuildNodeType.getId();
        Connection connection = Connections.getSharedConnection(this.getContext());
        String string2 = Connections.getUserAccountName(this.getContext());
        string2 = StringUtils.isDoubleQuotedString(string2) ? StringUtils.trimDoubleQuotes(string2) : string2.toUpperCase();
        List<RefModelType> list2 = MetaDataHelper.createRefModelTypeCollection(miningFunctionType, list, string, string2);
        for (CGeneralizedLinearModelType cGeneralizedLinearModelType : list) {
            String string3 = cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSDIAGNOSTICSTABLENAME();
            if (string3 == null || string3.length() <= 0) continue;
            for (RefModelType refModelType : list2) {
                if (refModelType.getName().compareTo(cGeneralizedLinearModelType.getName()) != 0 || refModelType.getSchema().compareTo(string2) != 0) continue;
                arrayList.add(refModelType);
            }
        }
        return arrayList;
    }

    @Override
    public List<RefModelType> getSVMLinearModels() throws Exception {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        List list = classificationBuildNodeType.getModels().getCSupportVectorMachineModel();
        MiningFunctionType miningFunctionType = MiningFunctionType.CLASSIFICATION;
        String string = classificationBuildNodeType.getId();
        Connection connection = Connections.getSharedConnection(this.getContext());
        String string2 = Connections.getUserAccountName(this.getContext());
        string2 = StringUtils.isDoubleQuotedString(string2) ? StringUtils.trimDoubleQuotes(string2) : string2.toUpperCase();
        List<RefModelType> list2 = MetaDataHelper.createRefModelTypeCollection(miningFunctionType, list, string, string2);
        for (CSupportVectorMachineModelType cSupportVectorMachineModelType : list) {
            String string3 = cSupportVectorMachineModelType.getCSupportVectorMachineAlgo().getSVMSKERNELFUNCTION();
            if (string3 == null || string3.compareTo("SVMS_LINEAR") != 0) continue;
            for (RefModelType refModelType : list2) {
                if (refModelType.getName().compareTo(cSupportVectorMachineModelType.getName()) != 0 || refModelType.getSchema().compareTo(string2) != 0) continue;
                arrayList.add(refModelType);
            }
        }
        return arrayList;
    }

    @Override
    public List<RefModelType> getModelsContainingCostMatrix() throws Exception {
        RefModelType refModelType;
        Object object;
        Object object2;
        Object object32;
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        List list = classificationBuildNodeType.getModels().getDecisionTreeModel();
        MiningFunctionType miningFunctionType = MiningFunctionType.CLASSIFICATION;
        String string = classificationBuildNodeType.getId();
        Connection connection = Connections.getSharedConnection(this.getContext());
        String string2 = Connections.getUserAccountName(this.getContext());
        string2 = StringUtils.isDoubleQuotedString(string2) ? StringUtils.trimDoubleQuotes(string2) : string2.toUpperCase();
        for (Object object32 : list) {
            if (object32.getPerformance().getBalanced() != null || object32.getPerformance().getCustom() != null) {
                object2 = MetaDataHelper.createRefModelType((ModelType)object32, miningFunctionType, string2, string);
                arrayList.add((RefModelType)object2);
                continue;
            }
            if (object32.getTuning().getBenefit() == null && object32.getTuning().getCost() == null && object32.getTuning().getCustom() == null) continue;
            object2 = MetaDataHelper.createRefModelType((ModelType)object32, miningFunctionType, string2, string);
            arrayList.add((RefModelType)object2);
        }
        List list2 = classificationBuildNodeType.getModels().getNaiveBayesModel();
        object32 = list2.iterator();
        while (object32.hasNext()) {
            object2 = (NaiveBayesModelType)object32.next();
            if (object2.getTuning().getBenefit() == null && object2.getTuning().getCost() == null && object2.getTuning().getCustom() == null) continue;
            object = MetaDataHelper.createRefModelType((ModelType)object2, miningFunctionType, string2, string);
            arrayList.add((RefModelType)object);
        }
        object32 = classificationBuildNodeType.getModels().getCSupportVectorMachineModel();
        object2 = object32.iterator();
        while (object2.hasNext()) {
            object = (CSupportVectorMachineModelType)object2.next();
            if (object.getTuning().getBenefit() == null && object.getTuning().getCost() == null && object.getTuning().getCustom() == null) continue;
            refModelType = MetaDataHelper.createRefModelType((ModelType)object, miningFunctionType, string2, string);
            arrayList.add(refModelType);
        }
        object2 = classificationBuildNodeType.getModels().getCGeneralizedLinearModel();
        object = object2.iterator();
        while (object.hasNext()) {
            refModelType = (CGeneralizedLinearModelType)object.next();
            if (refModelType.getTuning().getBenefit() == null && refModelType.getTuning().getCost() == null && refModelType.getTuning().getCustom() == null) continue;
            RefModelType refModelType2 = MetaDataHelper.createRefModelType((ModelType)refModelType, miningFunctionType, string2, string);
            arrayList.add(refModelType2);
        }
        return arrayList;
    }

    @Override
    public HashMap<String, RowDiagnosticTableDetails> getRowDiagnosticTables() {
        HashMap<String, RowDiagnosticTableDetails> hashMap = new HashMap<String, RowDiagnosticTableDetails>();
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        List list = classificationBuildNodeType.getModels().getCGeneralizedLinearModel();
        for (CGeneralizedLinearModelType cGeneralizedLinearModelType : list) {
            String string = cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSDIAGNOSTICSTABLENAME();
            if (string == null) continue;
            RowDiagnosticTableDetails rowDiagnosticTableDetails = new RowDiagnosticTableDetails(this.getMetadataId(), string);
            hashMap.put(cGeneralizedLinearModelType.getId(), rowDiagnosticTableDetails);
        }
        return hashMap;
    }

    public TuningType getModelTuning(String string) {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        try {
            if (classificationBuildNodeType != null) {
                Object object;
                Object object2;
                Object object32;
                List list = classificationBuildNodeType.getModels().getNaiveBayesModel();
                for (Object object32 : list) {
                    if (!object32.getId().equals(string)) continue;
                    return object32.getTuning();
                }
                List list2 = classificationBuildNodeType.getModels().getDecisionTreeModel();
                object32 = list2.iterator();
                while (object32.hasNext()) {
                    object2 = (DecisionTreeModelType)object32.next();
                    if (!object2.getId().equals(string)) continue;
                    return object2.getTuning();
                }
                object32 = classificationBuildNodeType.getModels().getCSupportVectorMachineModel();
                object2 = object32.iterator();
                while (object2.hasNext()) {
                    object = (CSupportVectorMachineModelType)object2.next();
                    if (!object.getId().equals(string)) continue;
                    return object.getTuning();
                }
                object2 = classificationBuildNodeType.getModels().getCGeneralizedLinearModel();
                object = object2.iterator();
                while (object.hasNext()) {
                    CGeneralizedLinearModelType cGeneralizedLinearModelType = (CGeneralizedLinearModelType)object.next();
                    if (!cGeneralizedLinearModelType.getId().equals(string)) continue;
                    return cGeneralizedLinearModelType.getTuning();
                }
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)NodeMessagesLrb.get("ERROR_TITLE"), (String)NodeMessagesLrb.get("ERROR_MODEL_LOADING_UNEXPECTED"), null);
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return null;
    }

    @Override
    public MiningFunctionType getMiningFunctionTypeSupported() {
        return MiningFunctionType.CLASSIFICATION;
    }

    @Override
    public AttributeType getTargetAttribute() {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        return classificationBuildNodeType.getTargetAttribute();
    }

    @Override
    public String getHelpTopic() {
        return "classification_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_CLASSIFICATION_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_CLASSIFICATION_ICON"));
    }

    private String generateWeightsCode(Context context, ClassificationBuildNodeType classificationBuildNodeType, ClassificationModelType classificationModelType) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        String string = classificationBuildNodeType.getTargetAttribute().getDataType();
        if (classificationModelType.getPerformance().getBalanced() != null || classificationModelType.getPerformance().getCustom() != null) {
            stringBuffer.append("  v_weights_setting := generateUniqueName; \n");
            if (classificationModelType instanceof NaiveBayesModelType) {
                if (string.indexOf("CHAR") > -1) {
                    stringBuffer.append("  execSQL('CREATE TABLE '||v_weights_setting||' (TARGET_VALUE VARCHAR2(4000), PRIOR_PROBABILITY NUMBER)'); \n");
                } else {
                    stringBuffer.append("  execSQL('CREATE TABLE '||v_weights_setting||' (TARGET_VALUE NUMBER, PRIOR_PROBABILITY NUMBER)'); \n");
                }
                if (classificationModelType.getPerformance().getBalanced() != null) {
                    String string2 = classificationModelType.getPerformance().getBalanced().getWeightsTable();
                    String string3 = "SELECT TARGET_VALUE, PRIOR_PROBABILITY FROM " + string2;
                    Connection connection = Connections.getSharedConnection(context);
                    SQLHelper sQLHelper = new SQLHelper();
                    sQLHelper.pstmt = connection.prepareStatement(string3);
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    while (sQLHelper.rs.next()) {
                        Object object;
                        Double d = sQLHelper.rs.getDouble("PRIOR_PROBABILITY");
                        if (string.indexOf("CHAR") > -1) {
                            object = sQLHelper.rs.getString("TARGET_VALUE");
                            stringBuffer.append("  execSQL('INSERT INTO '||v_weights_setting||' VALUES (''" + (String)object + "'', " + d + ")'); \n");
                            continue;
                        }
                        object = sQLHelper.rs.getBigDecimal("TARGET_VALUE");
                        stringBuffer.append("  execSQL('INSERT INTO '||v_weights_setting||' VALUES (" + object + ", " + d + ")'); \n");
                    }
                    sQLHelper.close();
                } else if (classificationModelType.getPerformance().getCustom() != null) {
                    for (WeightsType.Item item : classificationModelType.getPerformance().getCustom().getWeights().getItem()) {
                        if (string.indexOf("CHAR") > -1) {
                            stringBuffer.append("  execSQL('INSERT INTO '||v_weights_setting||' VALUES (''" + item.getTargetValue() + "'', " + item.getWeight() + ")'); \n");
                            continue;
                        }
                        stringBuffer.append("  execSQL('INSERT INTO '||v_weights_setting||' VALUES (" + item.getTargetValue() + ", " + item.getWeight() + ")'); \n");
                    }
                }
            } else if (classificationModelType instanceof DecisionTreeModelType) {
                if (string.indexOf("CHAR") > -1) {
                    stringBuffer.append("  execSQL('CREATE TABLE '||v_weights_setting||' (ACTUAL_TARGET_VALUE VARCHAR2(4000), PREDICTED_TARGET_VALUE VARCHAR2(4000), COST NUMBER)'); \n");
                } else {
                    stringBuffer.append("  execSQL('CREATE TABLE '||v_weights_setting||' (ACTUAL_TARGET_VALUE NUMBER, PREDICTED_TARGET_VALUE NUMBER, COST NUMBER)'); \n");
                }
                if (classificationModelType.getPerformance().getBalanced() != null) {
                    String string4 = classificationModelType.getPerformance().getBalanced().getWeightsTable();
                    String string5 = "SELECT actual_target_value, predicted_target_value, cost FROM " + string4;
                    Connection connection = Connections.getSharedConnection(context);
                    SQLHelper sQLHelper = new SQLHelper();
                    sQLHelper.pstmt = connection.prepareStatement(string5);
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    while (sQLHelper.rs.next()) {
                        Object object;
                        Object object2;
                        Double d = sQLHelper.rs.getDouble("COST");
                        if (string.indexOf("CHAR") > -1) {
                            object2 = sQLHelper.rs.getString("ACTUAL_TARGET_VALUE");
                            object = sQLHelper.rs.getString("PREDICTED_TARGET_VALUE");
                            stringBuffer.append("  execSQL('INSERT INTO '||v_weights_setting||' VALUES (''" + (String)object2 + "'', ''" + (String)object + "'', " + d + ")'); \n");
                            continue;
                        }
                        object2 = sQLHelper.rs.getBigDecimal("ACTUAL_TARGET_VALUE");
                        object = sQLHelper.rs.getBigDecimal("PREDICTED_TARGET_VALUE");
                        stringBuffer.append("  execSQL('INSERT INTO '||v_weights_setting||' VALUES (" + object2 + ", " + object + ", " + d + ")'); \n");
                    }
                    sQLHelper.close();
                } else if (classificationModelType.getPerformance().getCustom() != null) {
                    List list = classificationModelType.getPerformance().getCustom().getWeights().getItem();
                    for (int i = 0; i < list.size(); ++i) {
                        for (int j = 0; j < list.size(); ++j) {
                            double d = i == j ? 0.0 : ((WeightsType.Item)list.get(i)).getWeight();
                            if (string.indexOf("CHAR") > -1) {
                                stringBuffer.append("  execSQL('INSERT INTO '||v_weights_setting||' VALUES (''" + ((WeightsType.Item)list.get(i)).getTargetValue() + "'', ''" + ((WeightsType.Item)list.get(j)).getTargetValue() + "'', " + d + ")'); \n");
                                continue;
                            }
                            stringBuffer.append("  execSQL('INSERT INTO '||v_weights_setting||' VALUES (" + ((WeightsType.Item)list.get(i)).getTargetValue() + ", " + ((WeightsType.Item)list.get(j)).getTargetValue() + ", " + d + ")'); \n");
                        }
                    }
                }
            } else if (classificationModelType instanceof CSupportVectorMachineModelType || classificationModelType instanceof CGeneralizedLinearModelType) {
                if (string.indexOf("CHAR") > -1) {
                    stringBuffer.append("  execSQL('CREATE TABLE '||v_weights_setting||' (TARGET_VALUE VARCHAR2(4000), CLASS_WEIGHT NUMBER)'); \n");
                } else {
                    stringBuffer.append("  execSQL('CREATE TABLE '||v_weights_setting||' (TARGET_VALUE NUMBER, CLASS_WEIGHT NUMBER)'); \n");
                }
                if (classificationModelType.getPerformance().getBalanced() != null) {
                    String string6 = classificationModelType.getPerformance().getBalanced().getWeightsTable();
                    String string7 = "SELECT TARGET_VALUE, CLASS_WEIGHT FROM " + string6;
                    Connection connection = Connections.getSharedConnection(context);
                    SQLHelper sQLHelper = new SQLHelper();
                    sQLHelper.pstmt = connection.prepareStatement(string7);
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    while (sQLHelper.rs.next()) {
                        Object object;
                        Double d = sQLHelper.rs.getDouble("CLASS_WEIGHT");
                        if (string.indexOf("CHAR") > -1) {
                            object = sQLHelper.rs.getString("TARGET_VALUE");
                            stringBuffer.append("  execSQL('INSERT INTO '||v_weights_setting||' VALUES (''" + (String)object + "'', " + d + ")'); \n");
                            continue;
                        }
                        object = sQLHelper.rs.getBigDecimal("TARGET_VALUE");
                        stringBuffer.append("  execSQL('INSERT INTO '||v_weights_setting||' VALUES (" + object + ", " + d + ")'); \n");
                    }
                    sQLHelper.close();
                } else if (classificationModelType.getPerformance().getCustom() != null) {
                    for (WeightsType.Item item : classificationModelType.getPerformance().getCustom().getWeights().getItem()) {
                        if (string.indexOf("CHAR") > -1) {
                            stringBuffer.append("  execSQL('INSERT INTO '||v_weights_setting||' VALUES (''" + item.getTargetValue() + "'', " + item.getWeight() + ")'); \n");
                            continue;
                        }
                        stringBuffer.append("  execSQL('INSERT INTO '||v_weights_setting||' VALUES (" + item.getTargetValue() + ", " + item.getWeight() + ")'); \n");
                    }
                }
            }
            stringBuffer.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_weights_setting, 'TABLE', NULL, 'Weights Setting'); \n");
        }
        return stringBuffer.toString();
    }

    private String generateBuildSettingsCode(Context context, ClassificationBuildNodeType classificationBuildNodeType, ClassificationModelType classificationModelType, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  execSQL('CREATE TABLE '||v_build_setting||' (SETTING_NAME VARCHAR2(30), SETTING_VALUE VARCHAR2(128))'); \n");
        if (classificationModelType instanceof NaiveBayesModelType) {
            NaiveBayesModelType naiveBayesModelType = (NaiveBayesModelType)classificationModelType;
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.NABS_PAIRWISE_THRESHOLD||''', " + naiveBayesModelType.getNaiveBayesAlgo().getNABSPAIRWISETHRESHOLD() + ")'); \n");
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.NABS_SINGLETON_THRESHOLD||''', " + naiveBayesModelType.getNaiveBayesAlgo().getNABSSINGLETONTHRESHOLD() + ")'); \n");
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ALGO_NAME||''', '''||DBMS_DATA_MINING.ALGO_NAIVE_BAYES||''')'); \n");
            if (bl) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.CLAS_PRIORS_TABLE_NAME||''', '''||v_weights_setting||''')'); \n");
            }
        } else if (classificationModelType instanceof DecisionTreeModelType) {
            DecisionTreeModelType decisionTreeModelType = (DecisionTreeModelType)classificationModelType;
            if (decisionTreeModelType.getDecisionTreeAlgo().getTREEIMPURITYMETRIC() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.TREE_IMPURITY_METRIC||''', ''" + decisionTreeModelType.getDecisionTreeAlgo().getTREEIMPURITYMETRIC() + "'')'); \n");
            }
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.TREE_TERM_MAX_DEPTH||''', " + decisionTreeModelType.getDecisionTreeAlgo().getTREETERMMAXDEPTH() + ")'); \n");
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.TREE_TERM_MINPCT_NODE||''', " + decisionTreeModelType.getDecisionTreeAlgo().getTREETERMMINPCTNODE() + ")'); \n");
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.TREE_TERM_MINPCT_SPLIT||''', " + decisionTreeModelType.getDecisionTreeAlgo().getTREETERMMINPCTSPLIT() + ")'); \n");
            if (decisionTreeModelType.getDecisionTreeAlgo().getTREETERMMINRECNODE() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.TREE_TERM_MINREC_NODE||''', " + decisionTreeModelType.getDecisionTreeAlgo().getTREETERMMINRECNODE() + ")'); \n");
            }
            if (decisionTreeModelType.getDecisionTreeAlgo().getTREETERMMINRECSPLIT() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.TREE_TERM_MINREC_SPLIT||''', " + decisionTreeModelType.getDecisionTreeAlgo().getTREETERMMINRECSPLIT() + ")'); \n");
            }
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ALGO_NAME||''', '''||DBMS_DATA_MINING.ALGO_DECISION_TREE||''')'); \n");
            if (bl) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.CLAS_COST_TABLE_NAME||''', '''||v_weights_setting||''')'); \n");
            }
        } else if (classificationModelType instanceof CSupportVectorMachineModelType) {
            CSupportVectorMachineModelType cSupportVectorMachineModelType = (CSupportVectorMachineModelType)classificationModelType;
            if (cSupportVectorMachineModelType.getCSupportVectorMachineAlgo().getSVMSACTIVELEARNING() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_ACTIVE_LEARNING||''', ''" + cSupportVectorMachineModelType.getCSupportVectorMachineAlgo().getSVMSACTIVELEARNING() + "'')'); \n");
            }
            if (cSupportVectorMachineModelType.getCSupportVectorMachineAlgo().getSVMSCOMPLEXITYFACTOR() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_COMPLEXITY_FACTOR||''', " + cSupportVectorMachineModelType.getCSupportVectorMachineAlgo().getSVMSCOMPLEXITYFACTOR() + ")'); \n");
            }
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_CONV_TOLERANCE||''', " + cSupportVectorMachineModelType.getCSupportVectorMachineAlgo().getSVMSCONVTOLERANCE() + ")'); \n");
            if (cSupportVectorMachineModelType.getCSupportVectorMachineAlgo().getSVMSKERNELCACHESIZE() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_KERNEL_CACHE_SIZE||''', " + cSupportVectorMachineModelType.getCSupportVectorMachineAlgo().getSVMSKERNELCACHESIZE() + ")'); \n");
            }
            if (cSupportVectorMachineModelType.getCSupportVectorMachineAlgo().getSVMSKERNELFUNCTION() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_KERNEL_FUNCTION||''', ''" + cSupportVectorMachineModelType.getCSupportVectorMachineAlgo().getSVMSKERNELFUNCTION() + "'')'); \n");
            }
            if (cSupportVectorMachineModelType.getCSupportVectorMachineAlgo().getSVMSSTDDEV() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_STD_DEV||''', " + cSupportVectorMachineModelType.getCSupportVectorMachineAlgo().getSVMSSTDDEV() + ")'); \n");
            }
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ALGO_NAME||''', '''||DBMS_DATA_MINING.ALGO_SUPPORT_VECTOR_MACHINES||''')'); \n");
            if (bl) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.CLAS_WEIGHTS_TABLE_NAME||''', '''||v_weights_setting||''')'); \n");
            }
        } else if (classificationModelType instanceof CGeneralizedLinearModelType) {
            CGeneralizedLinearModelType cGeneralizedLinearModelType = (CGeneralizedLinearModelType)classificationModelType;
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_CONF_LEVEL||''', " + cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSCONFLEVEL() + ")'); \n");
            if (cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSDIAGNOSTICSTABLENAME() != null) {
                stringBuffer.append("  v_row_diag_table := generateUniqueName; \n");
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_DIAGNOSTICS_TABLE_NAME||''', '''||v_row_diag_table||''')'); \n");
                stringBuffer.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_row_diag_table, 'TABLE', NULL,'GLM Diagnostics Table'); \n");
            }
            if (cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSREFERENCECLASSNAME() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_REFERENCE_CLASS_NAME||''', ''" + StringUtils.addDoubleQuotes(StringUtils.trimDoubleQuotes(cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSREFERENCECLASSNAME())) + "'')'); \n");
            }
            if (cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSRIDGEREGRESSION() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_RIDGE_REGRESSION||''', ''" + cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSRIDGEREGRESSION() + "'')'); \n");
            }
            if (cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSRIDGEVALUE() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_RIDGE_VALUE||''', " + cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSRIDGEVALUE() + ")'); \n");
            }
            if (cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getODMSMISSINGVALUETREATMENT() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ODMS_MISSING_VALUE_TREATMENT||''', ''" + cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getODMSMISSINGVALUETREATMENT() + "'')'); \n");
            }
            if (cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getODMSROWWEIGHTCOLUMNNAME() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ODMS_ROW_WEIGHT_COLUMN_NAME||''', ''" + StringUtils.addDoubleQuotes(StringUtils.trimDoubleQuotes(cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getODMSROWWEIGHTCOLUMNNAME())) + "'')'); \n");
            }
            if (cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSFTRSELCRIT() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_FTR_SEL_CRIT||''', ''" + cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSFTRSELCRIT() + "'')'); \n");
            }
            if (cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSMAXFEATURES() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_MAX_FEATURES||''', " + cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSMAXFEATURES() + ")'); \n");
            }
            if (cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSSELECTBLOCK() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_SELECT_BLOCK||''', ''" + cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSSELECTBLOCK() + "'')'); \n");
            }
            if (cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getODMSAPPROXIMATECOMPUTATION() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ODMS_APPROXIMATE_COMPUTATION||''', ''" + cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getODMSAPPROXIMATECOMPUTATION() + "'')'); \n");
            }
            if (cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSPRUNEMODEL() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_PRUNE_MODEL||''', ''" + cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSPRUNEMODEL() + "'')'); \n");
            }
            if (cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSFTRACCEPTANCE() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_FTR_ACCEPTANCE||''', ''" + cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSFTRACCEPTANCE() + "'')'); \n");
            }
            if (cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSFTRSELECTION() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_FTR_SELECTION||''', ''" + cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSFTRSELECTION() + "'')'); \n");
            }
            if (cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSFTRGENERATION() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_FTR_GENERATION||''', ''" + cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSFTRGENERATION() + "'')'); \n");
            }
            if (cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSFTRGENMETHOD() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_FTR_GEN_METHOD||''', ''" + cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSFTRGENMETHOD() + "'')'); \n");
            }
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ALGO_NAME||''', '''||DBMS_DATA_MINING.ALGO_GENERALIZED_LINEAR_MODEL||''')'); \n");
            if (bl) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.CLAS_WEIGHTS_TABLE_NAME||''', '''||v_weights_setting||''')'); \n");
            }
        }
        if (bl2) {
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.PREP_AUTO||''', '''||DBMS_DATA_MINING.PREP_AUTO_ON||''')'); \n");
        } else {
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.PREP_AUTO||''', '''||DBMS_DATA_MINING.PREP_AUTO_OFF||''')'); \n");
        }
        return stringBuffer.toString();
    }

    private String generateCostMatrixCode(ClassificationBuildNodeType classificationBuildNodeType, ClassificationModelType classificationModelType) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        String string = classificationBuildNodeType.getTargetAttribute().getDataType();
        boolean bl2 = bl = classificationModelType.getTuning().getBenefit() != null || classificationModelType.getTuning().getCost() != null || classificationModelType.getTuning().getCustom() != null;
        if (bl) {
            stringBuffer.append("  v_cost_setting := generateUniqueName; \n");
            if (string.indexOf("CHAR") > -1) {
                stringBuffer.append("  execSQL('CREATE TABLE '||v_cost_setting||' (actual_target_value VARCHAR2(4000), predicted_target_value VARCHAR2(4000), cost NUMBER)'); \n");
            } else {
                stringBuffer.append("  execSQL('CREATE TABLE '||v_cost_setting||' (actual_target_value NUMBER, predicted_target_value NUMBER, cost NUMBER)'); \n");
            }
            if (classificationModelType.getTuning().getCost() != null) {
                for (CostMatrixType.Item item : classificationModelType.getTuning().getCost().getCostMatrix().getItem()) {
                    if (string.indexOf("CHAR") > -1) {
                        stringBuffer.append("  execSQL('INSERT INTO '||v_cost_setting||' VALUES (''" + item.getActual() + "'', ''" + item.getPredict() + "'', " + item.getCost() + ")'); \n");
                        continue;
                    }
                    stringBuffer.append("  execSQL('INSERT INTO '||v_cost_setting||' VALUES (" + item.getActual() + ", " + item.getPredict() + ", " + item.getCost() + ")'); \n");
                }
            } else if (classificationModelType.getTuning().getCustom() != null) {
                for (CostMatrixType.Item item : classificationModelType.getTuning().getCustom().getCostMatrix().getItem()) {
                    if (string.indexOf("CHAR") > -1) {
                        stringBuffer.append("  execSQL('INSERT INTO '||v_cost_setting||' VALUES (''" + item.getActual() + "'', ''" + item.getPredict() + "'', " + item.getCost() + ")'); \n");
                        continue;
                    }
                    stringBuffer.append("  execSQL('INSERT INTO '||v_cost_setting||' VALUES (" + item.getActual() + ", " + item.getPredict() + ", " + item.getCost() + ")'); \n");
                }
            } else if (classificationModelType.getTuning().getBenefit() != null) {
                List list = classificationModelType.getTuning().getBenefit().getBenefitWeights().getItem();
                for (int i = 0; i < list.size(); ++i) {
                    for (int j = 0; j < list.size(); ++j) {
                        double d = i == j ? -1.0 * ((WeightsType.Item)list.get(i)).getWeight() : 0.0;
                        if (string.indexOf("CHAR") > -1) {
                            stringBuffer.append("  execSQL('INSERT INTO '||v_cost_setting||' VALUES (''" + ((WeightsType.Item)list.get(i)).getTargetValue() + "'', ''" + ((WeightsType.Item)list.get(j)).getTargetValue() + "'', " + d + ")'); \n");
                            continue;
                        }
                        stringBuffer.append("  execSQL('INSERT INTO '||v_cost_setting||' VALUES (" + ((WeightsType.Item)list.get(i)).getTargetValue() + ", " + ((WeightsType.Item)list.get(j)).getTargetValue() + ", " + d + ")'); \n");
                    }
                }
            }
            stringBuffer.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_cost_setting, 'TABLE', NULL, 'Cost Setting'); \n");
        }
        return stringBuffer.toString();
    }

    private String generateBuildTestCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, ClassificationModelType classificationModelType) throws Exception {
        CharSequence charSequence;
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
        String string = null;
        String string2 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_TABLE, false);
        String string3 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, true);
        String string4 = CodeTemplate.getInstance().getTemplate("workflow_class_build_model.sql");
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = this.generateDataUsageCode(version, (BuildNodeType)classificationBuildNodeType, (ModelType)classificationModelType, classificationBuildNodeType.getTargetAttribute(), stringBuffer, stringBuffer2);
        String string5 = this.generateWeightsCode(context, classificationBuildNodeType, classificationModelType);
        String string6 = this.generateBuildSettingsCode(context, classificationBuildNodeType, classificationModelType, !string5.isEmpty(), bl);
        String string7 = Connections.getUserAccountName(this.getContext());
        String string8 = classificationModelType.getName();
        parameterizedSourceDefinitions.addParameterizedSourceDefinition(this, string7, string8, DatabaseObjectType.MODEL);
        String string9 = parameterizedSourceDefinitions.getParmNameWithAmpersand(this, string7, string8, DatabaseObjectType.MODEL);
        string = classificationModelType.getPerformance().getBalanced() != null ? "  execSQL('COMMENT ON MINING MODEL " + string9 + " IS ''BALANCED'''); \n" : (classificationModelType.getPerformance().getCustom() != null ? "  execSQL('COMMENT ON MINING MODEL " + string9 + " IS ''CUSTOM'''); \n" : "  execSQL('COMMENT ON MINING MODEL " + string9 + " IS ''NATURAL'''); \n");
        string4 = CodeTemplate.updateBodyTemplate(string4, "<COMMENT_MODEL>", string);
        String string10 = "";
        if (classificationBuildNodeType.getTestDataSource().getNone() == null) {
            String string11;
            string10 = CodeTemplate.getInstance().getTemplate("workflow_class_test_model.sql");
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(this.generateCostMatrixCode(classificationBuildNodeType, classificationModelType));
            boolean bl2 = false;
            boolean bl3 = false;
            String string12 = null;
            if (((StringBuffer)charSequence).length() > 0) {
                ((StringBuffer)charSequence).append("  BEGIN \n");
                ((StringBuffer)charSequence).append("    DBMS_DATA_MINING.REMOVE_COST_MATRIX('<MODEL_NAME_PARAM>'); \n");
                ((StringBuffer)charSequence).append("  EXCEPTION WHEN OTHERS THEN \n");
                ((StringBuffer)charSequence).append("    NULL; -- ignore if no existing cost matrix to drop \n");
                ((StringBuffer)charSequence).append("  END; \n");
                ((StringBuffer)charSequence).append("  DBMS_DATA_MINING.ADD_COST_MATRIX('<MODEL_NAME_PARAM>', v_cost_setting); \n");
                ((StringBuffer)charSequence).append("  execSQL('COMMENT ON MINING MODEL " + string9 + " IS ''TUNED'''); \n");
                bl2 = true;
                bl3 = true;
            } else if (classificationModelType instanceof DecisionTreeModelType && (classificationModelType.getPerformance().getBalanced() != null || classificationModelType.getPerformance().getCustom() != null)) {
                bl2 = true;
                bl3 = true;
            }
            if (bl2) {
                string11 = "COST MODEL AUTO USING *";
                string12 = "COST";
            } else {
                string11 = "USING *";
                string12 = "PROBABILITY";
            }
            StringBuffer stringBuffer3 = new StringBuffer();
            if (bl2 && bl3) {
                string = "  v_sql := \n    'WITH \n    tr_cost AS \n      ( \n        select ACTUAL actual_target_value, PREDICTED predicted_target_value, COST \n        from TABLE(DBMS_DATA_MINING.GET_MODEL_COST_MATRIX(''<MODEL_NAME_PARAM>'')) \n      ), \n    total_actuals AS \n      (SELECT nvl(a.actual_target_value, b.actual_target_value) actual_target_value, \n         SUM(a.VALUE * b.cost) actuals_cost, \n         SUM(a.VALUE) total_actuals \n       FROM '||v_confusion_matrix||' a, \n         tr_cost b \n       WHERE a.actual_target_value(+) = b.actual_target_value \n       AND a.predicted_target_value(+) = b.predicted_target_value \n       GROUP BY nvl(a.actual_target_value, b.actual_target_value)), \n    total_predicted AS \n      (SELECT nvl(a.predicted_target_value, b.predicted_target_value) predicted_target_value, \n         SUM(a.VALUE * b.cost) predicted_cost, \n         SUM(a.VALUE) total_predicted \n       FROM '||v_confusion_matrix||' a, \n         tr_cost b \n       WHERE a.actual_target_value(+) = b.actual_target_value \n       AND a.predicted_target_value(+) = b.predicted_target_value \n       GROUP BY nvl(a.predicted_target_value, b.predicted_target_value)), \n    right_predictions AS \n      (SELECT actual_target_value, \n         VALUE AS correct \n       FROM '||v_confusion_matrix||' \n       WHERE actual_target_value = predicted_target_value), \n    actuals_total_cost as \n      (SELECT SUM(a.VALUE * b.cost) actuals_total_cost \n       FROM '||v_confusion_matrix||' a, \n         tr_cost b \n       WHERE a.actual_target_value = b.actual_target_value \n       AND a.predicted_target_value = b.predicted_target_value) \n    SELECT \n      SUM(actuals_cost) COST \n    FROM total_actuals a, \n      total_predicted p, \n      right_predictions c, \n      actuals_total_cost tc \n    WHERE a.actual_target_value(+) = p.predicted_target_value AND p.predicted_target_value = c.actual_target_value(+)'; \n  EXECUTE IMMEDIATE v_sql INTO v_tot_cost; \n";
                stringBuffer3.append(string);
                stringBuffer3.append("  execSQL('INSERT INTO '||v_test_metric||' (METRIC_NAME, METRIC_NUM_VALUE) VALUES (''COST'', NVL('||v_tot_cost||', 0))'); \n");
            }
            boolean bl4 = classificationBuildNodeType.getResults().isGenLift() == null ? true : classificationBuildNodeType.getResults().isGenLift();
            boolean bl5 = classificationBuildNodeType.getResults().isGenROC() == null ? true : classificationBuildNodeType.getResults().isGenROC();
            StringBuffer stringBuffer4 = new StringBuffer("");
            StringBuffer stringBuffer5 = new StringBuffer("");
            StringBuffer stringBuffer6 = new StringBuffer("");
            if (bl4 || bl5) {
                ClassificationTestSettingsType.TopNTargets topNTargets = classificationBuildNodeType.getTestSettings().getTopNTargets();
                ClassificationTestSettingsType.BottomNTargets bottomNTargets = classificationBuildNodeType.getTestSettings().getBottomNTargets();
                String string13 = "DESC";
                int n = 5;
                if (topNTargets != null || bottomNTargets != null) {
                    if (bottomNTargets != null) {
                        string13 = "ASC";
                        n = bottomNTargets.getValue().intValue();
                    } else {
                        n = topNTargets.getValue().intValue();
                    }
                    string = "  -- targets for test results \n  v_sql := \n    'SELECT <PARALLEL_HINT> \"'||v_target||'\" as prediction FROM \n    ( \n      SELECT \"'||v_target||'\", \n      RANK() OVER (ORDER BY count(\"'||v_target||'\") " + string13 + ") \"Rank\" \n" + "      FROM '||v_test_data||'  \n" + "      GROUP BY \"'||v_target||'\" \n" + "    ) \n" + "    WHERE rownum <= " + n + "'; \n" + "  EXECUTE IMMEDIATE v_sql BULK COLLECT INTO v_targets; \n";
                    string = StringUtils.getReplacedString(string, "<PARALLEL_HINT>", string3);
                } else {
                    StringBuffer stringBuffer7 = new StringBuffer();
                    int n2 = 0;
                    for (ClassificationTestSettingsType.SpecificTargets.TargetValue targetValue : classificationBuildNodeType.getTestSettings().getSpecificTargets().getTargetValue()) {
                        if (n2 > 0) {
                            stringBuffer7.append(", ");
                        }
                        stringBuffer7.append("'" + StringUtils.escapeSingleQuotesForSQL(targetValue.getValue()) + "'");
                        ++n2;
                    }
                    string = "  -- targets for test results \n  v_targets := ODMR_OBJECT_VALUES(" + stringBuffer7.toString() + "); \n";
                }
                stringBuffer6.append(string);
                if (bl4) {
                    string = "  FOR i IN 1..v_targets.COUNT LOOP \n    -- lift for each target \n    v_lift := generateUniqueName; \n    DBMS_DATA_MINING.COMPUTE_LIFT ( \n      apply_result_table_name   => v_apply_data, \n      target_table_name         => v_test_data, \n      case_id_column_name       => v_caseid, \n      target_column_name        => '\"'||v_target||'\"', \n      lift_table_name           => v_lift, \n      positive_target_value     => v_targets(i), \n      score_column_name         => 'PREDICTION', \n      score_criterion_column_name => '<SCORE_CRITERION>', \n      num_quantiles             => 100, \n      score_criterion_type      => '<SCORE_CRITERION>'); \n    recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_lift, 'TABLE', v_target||'='||v_targets(i), 'Lift Result'); \n  END LOOP; \n";
                    stringBuffer4.append(string);
                }
                if (bl5) {
                    string = "  -- roc for each target (only binary target support) \n  IF (v_targets.COUNT <= 2) THEN \n    FOR i IN 1..v_targets.COUNT LOOP \n      v_roc := generateUniqueName; \n      DBMS_DATA_MINING.COMPUTE_ROC ( \n        roc_area_under_curve        => v_area_under_curve, \n        apply_result_table_name     => v_apply_data, \n        target_table_name           => v_test_data, \n        case_id_column_name         => v_caseid, \n        target_column_name          => '\"'||v_target||'\"', \n        roc_table_name              => v_roc, \n        positive_target_value       => v_targets(i), \n        score_column_name           => 'PREDICTION', \n        score_criterion_column_name => 'PROBABILITY'); \n      recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_roc, 'TABLE', v_target||'='||v_targets(i), 'ROC Result'); \n      recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_area_under_curve, 'SCALAR', v_target||'='||v_targets(i), 'ROC Area Under Curve'); \n    END LOOP; \n  END IF; \n";
                    stringBuffer5.append(string);
                }
            }
            string10 = CodeTemplate.updateBodyTemplate(string10, "<TABLE_PARALLEL_HINT>", string2);
            string10 = CodeTemplate.updateBodyTemplate(string10, "<PARALLEL_HINT>", string3);
            string10 = CodeTemplate.updateBodyTemplate(string10, "<TEST_APPLY_COST_OPTION>", string11);
            string10 = CodeTemplate.updateBodyTemplate(string10, "<COST_SETTING>", ((StringBuffer)charSequence).toString());
            string10 = CodeTemplate.updateBodyTemplate(string10, "<COMPUTE_TOTAL_COST>", stringBuffer3.toString());
            string10 = CodeTemplate.updateBodyTemplate(string10, "<TEST_TARGET_VALUES>", stringBuffer6.toString());
            string10 = CodeTemplate.updateBodyTemplate(string10, "<GEN_LIFT_RESULT>", stringBuffer4.toString());
            string10 = CodeTemplate.updateBodyTemplate(string10, "<GEN_ROC_RESULT>", stringBuffer5.toString());
            string10 = CodeTemplate.updateBodyTemplate(string10, "<SCORE_CRITERION>", string12);
        }
        string4 = CodeTemplate.updateBodyTemplate(string4, "<TEST_MODELS>", string10);
        string4 = CodeTemplate.updateBodyTemplate(string4, "<PARALLEL_HINT>", string3);
        string4 = CodeTemplate.updateBodyTemplate(string4, "<DATA_USAGE_ATTRIBUTES>", stringBuffer.toString());
        string4 = CodeTemplate.updateBodyTemplate(string4, "<DATA_USAGE_TRANSFORMATIONS>", stringBuffer2.toString());
        string4 = CodeTemplate.updateBodyTemplate(string4, "<WEIGHTS_SETTING>", string5);
        string4 = CodeTemplate.updateBodyTemplate(string4, "<BUILD_SETTING>", string6);
        string4 = CodeTemplate.updateBodyTemplate(string4, "<MODEL_NAME_PARAM>", string9);
        string4 = CodeTemplate.updateBodyTemplate(string4, "<BUILD_MODEL_ID>", classificationModelType.getId());
        charSequence = null;
        if (classificationModelType instanceof DecisionTreeModelType) {
            charSequence = MiningAlgorithms.DECISION_TREE.toString();
        } else if (classificationModelType instanceof NaiveBayesModelType) {
            charSequence = MiningAlgorithms.NAIVE_BAYES.toString();
        } else if (classificationModelType instanceof CGeneralizedLinearModelType) {
            charSequence = MiningAlgorithms.GENERALIZED_LINEAR_MODEL.toString();
        } else if (classificationModelType instanceof CSupportVectorMachineModelType) {
            charSequence = MiningAlgorithms.SUPPORT_VECTOR_MACHINE.toString();
        }
        string4 = CodeTemplate.updateBodyTemplate(string4, "<BUILD_MODEL_TYPE>", (String)charSequence);
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateBuildTestDataCode(Context context) {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        if (classificationBuildNodeType.getCaseAttributes() != null && !classificationBuildNodeType.getCaseAttributes().getAttribute().isEmpty()) {
            string = ((AttributeType)classificationBuildNodeType.getCaseAttributes().getAttribute().get(0)).getName();
        }
        String string2 = null;
        String string3 = null;
        String string4 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, true);
        String string5 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_TABLE, false);
        String string6 = "        ";
        String string7 = null;
        boolean bl = false;
        if (classificationBuildNodeType.getTestDataSource().getSplitData() != null) {
            double d = 100.0 - classificationBuildNodeType.getTestDataSource().getSplitData().getTestPercent();
            String string8 = "    ( \n      SELECT \"'||v_caseid||'\", \n        <ATTR_LIST> \n        FROM ( \n          WITH  \n          \"A\" as (SELECT /*+ inline */ * FROM '||v_input_data||'), \n          \"B.1\" as (SELECT /*+ inline */ row_number() OVER(partition by \"'||v_target||'\" ORDER BY ORA_HASH(\"'||v_caseid||'\")) '||v_caseid_alias||', \"'||v_caseid||'\" FROM \"A\" t), \n          \"B.2\" as (SELECT /*+ inline */ t.*, p.'||v_caseid_alias||' FROM \"A\" t, \"B.1\" p WHERE t.\"'||v_caseid||'\" = p.\"'||v_caseid||'\"), \n          \"B.3\" as (SELECT \"'||v_target||'\", COUNT(*) '||v_num_row_alias||' FROM \"A\" GROUP BY \"'||v_target||'\"), \n          \"B\" as ( \n            SELECT /*+ inline */ v1.* FROM \"B.2\" v1 ,\"B.3\" v2 \n            WHERE v1.\"'||v_target||'\" = v2.\"'||v_target||'\" \n            AND ORA_HASH(v1.'||v_caseid_alias||', v2.'||v_num_row_alias||'-1, 0) <= (v2.'||v_num_row_alias||' * " + d + " / 100) \n" + "          ) \n" + "          SELECT * from \"B\" \n" + "        ) \n" + "    )'; \n";
            String string9 = "    ( \n      SELECT \"'||v_caseid||'\", \n        <ATTR_LIST> \n        FROM ( \n          WITH \n          \"A\" as (SELECT /*+ inline */ * FROM '||v_input_data||'), \n          \"B.1\" as (SELECT /*+ inline */ row_number() OVER(partition by \"'||v_target||'\" ORDER BY ORA_HASH(\"'||v_caseid||'\")) '||v_caseid_alias||', \"'||v_caseid||'\" FROM \"A\" t), \n          \"B.2\" as (SELECT /*+ inline */ t.*, p.'||v_caseid_alias||' FROM \"A\" t, \"B.1\" p WHERE t.\"'||v_caseid||'\" = p.\"'||v_caseid||'\"),  \n          \"B.3\" as (SELECT \"'||v_target||'\", COUNT(*) '||v_num_row_alias||' FROM \"A\" GROUP BY \"'||v_target||'\"),  \n          \"B\" as ( \n            SELECT /*+ inline */ v1.* FROM \"B.2\" v1 ,\"B.3\" v2 \n            WHERE v1.\"'||v_target||'\" = v2.\"'||v_target||'\" \n            AND ORA_HASH(v1.'||v_caseid_alias||', v2.'||v_num_row_alias||'-1, 0) > (v2.'||v_num_row_alias||' * " + d + " / 100) \n" + "          ) \n" + "          SELECT * from \"B\" \n" + "        ) \n" + "    )'; \n";
            string7 = "\n";
            string7 = string7 + "  v_caseid_alias := generateUniqueName; \n";
            string7 = string7 + "  v_num_row_alias := generateUniqueName; \n";
            boolean bl2 = true;
            StringBuffer stringBuffer2 = new StringBuffer();
            if (bl2) {
                string2 = "TABLE";
                string3 = "TABLE";
                try {
                    for (Object object : classificationBuildNodeType.getMiningAttributes().getMiningAttribute()) {
                        if (object.getInput().compareToIgnoreCase("Yes") != 0 || string != null && object.getName().compareTo(string) == 0) continue;
                        if (stringBuffer2.length() > 0) {
                            stringBuffer2.append(",\n" + string6);
                        }
                        stringBuffer2.append(StringUtils.addDoubleQuotes(object.getName()));
                    }
                    StringBuffer stringBuffer3 = new StringBuffer("");
                    for (MiningAttributeType miningAttributeType : classificationBuildNodeType.getMiningAttributes().getMiningAttribute()) {
                        if (miningAttributeType.getInput().compareToIgnoreCase("Yes") != 0 && miningAttributeType.getInput().compareToIgnoreCase("Maybe") != 0) continue;
                        if (miningAttributeType.getDataType().compareToIgnoreCase("CLOB") == 0 || miningAttributeType.getDataType().compareToIgnoreCase("NCLOB") == 0) {
                            if (stringBuffer3.length() > 0) {
                                stringBuffer3.append(",\n" + string6);
                            }
                            stringBuffer3.append("LOB(" + StringUtils.addDoubleQuotes(miningAttributeType.getName()) + ") STORE AS BASICFILE");
                            continue;
                        }
                        if (miningAttributeType.getDataType().contains("NESTED")) {
                            if (stringBuffer3.length() > 0) {
                                stringBuffer3.append(",\n" + string6);
                            }
                            stringBuffer3.append("NESTED TABLE " + StringUtils.addDoubleQuotes(miningAttributeType.getName()) + " STORE AS '||generateUniqueName||'");
                            continue;
                        }
                        if (miningAttributeType.getDataType().compareToIgnoreCase("XMLTYPE") != 0) continue;
                        if (stringBuffer3.length() > 0) {
                            stringBuffer3.append(",\n" + string6);
                        }
                        stringBuffer3.append("XMLTYPE COLUMN " + StringUtils.addDoubleQuotes(miningAttributeType.getName()) + " STORE AS BASICFILE CLOB");
                    }
                    string7 = string7 + "  v_build_data := generateUniqueName; \n";
                    string7 = string7 + "  v_test_data := generateUniqueName; \n";
                    string7 = string7 + "\n";
                    string7 = string7 + "  _START_CHECK_SQL_SIZE_ \n";
                    string7 = string7 + "  v_sql := \n";
                    string7 = string7 + "    'CREATE TABLE '||v_build_data||' \n";
                    string7 = string7 + "        <STORAGE_CLAUSE> <TABLE_PARALLEL_HINT> COMPRESS \n";
                    string7 = string7 + "    AS SELECT <PARALLEL_HINT> * FROM \n" + string8;
                    string7 = string7 + "  execSQL(v_sql); \n";
                    string7 = string7 + "  _END_CHECK_SQL_SIZE_ \n";
                    string7 = StringUtils.getReplacedString(string7, "<STORAGE_CLAUSE>", stringBuffer3.toString());
                    string7 = StringUtils.getReplacedString(string7, "<TABLE_PARALLEL_HINT>", string5);
                    string7 = StringUtils.getReplacedString(string7, "<PARALLEL_HINT>", string4);
                    string7 = StringUtils.getReplacedString(string7, "<ATTR_LIST>", stringBuffer2.toString());
                    string7 = string7 + "\n";
                    string7 = string7 + "  _START_CHECK_SQL_SIZE_ \n";
                    string7 = string7 + "  v_sql := \n";
                    string7 = string7 + "    'CREATE TABLE '||v_test_data||' \n";
                    string7 = string7 + "        <STORAGE_CLAUSE> <TABLE_PARALLEL_HINT> COMPRESS \n";
                    string7 = string7 + "    AS SELECT <PARALLEL_HINT> * FROM \n" + string9;
                    string7 = string7 + "  execSQL(v_sql); \n";
                    string7 = string7 + "  _END_CHECK_SQL_SIZE_ \n";
                    string7 = StringUtils.getReplacedString(string7, "<STORAGE_CLAUSE>", stringBuffer3.toString());
                    string7 = StringUtils.getReplacedString(string7, "<TABLE_PARALLEL_HINT>", string5);
                    string7 = StringUtils.getReplacedString(string7, "<PARALLEL_HINT>", string4);
                    string7 = StringUtils.getReplacedString(string7, "<ATTR_LIST>", stringBuffer2.toString());
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            } else {
                for (MiningAttributeType miningAttributeType : classificationBuildNodeType.getMiningAttributes().getMiningAttribute()) {
                    if (miningAttributeType.getInput().compareToIgnoreCase("Yes") != 0) continue;
                    if (stringBuffer2.length() > 0) {
                        stringBuffer2.append(",\n" + string6);
                    }
                    stringBuffer2.append(StringUtils.addDoubleQuotes(miningAttributeType.getName()));
                }
                Object object = StringUtils.getReplacedString(string8, "<ATTR_LIST>", stringBuffer2.toString());
                string7 = string7 + "  v_build_data := generateUniqueName; \n";
                string7 = string7 + "  v_test_data := generateUniqueName; \n";
                string7 = string7 + "\n";
                string7 = string7 + "  _START_CHECK_SQL_SIZE_ \n";
                string7 = string7 + "  v_sql := \n";
                string7 = string7 + "    'CREATE VIEW '||v_build_data||' AS SELECT <PARALLEL_HINT> * FROM \n" + (String)object;
                string7 = string7 + "  execSQL(v_sql); \n";
                string7 = string7 + "  _END_CHECK_SQL_SIZE_ \n";
                object = StringUtils.getReplacedString(string9, "<ATTR_LIST>", stringBuffer2.toString());
                string7 = string7 + "\n";
                string7 = string7 + "  _START_CHECK_SQL_SIZE_ \n";
                string7 = string7 + "  v_sql := \n";
                string7 = string7 + "    'CREATE VIEW '||v_test_data||' AS SELECT <PARALLEL_HINT> * FROM \n" + (String)object;
                string7 = string7 + "  execSQL(v_sql); \n";
                string7 = string7 + "  _END_CHECK_SQL_SIZE_ \n";
                string7 = StringUtils.getReplacedString(string7, "<PARALLEL_HINT>", string4);
            }
            bl = true;
        } else if (classificationBuildNodeType.getTestDataSource().getTestData() != null) {
            String string10 = classificationBuildNodeType.getTestDataSource().getTestData().getSourceId();
            if (string != null) {
                string2 = "VIEW";
                string3 = "VIEW";
                string7 = "  \n  v_build_data := v_input_data; \n  v_test_data := generateUniqueName; \n  v_sql := \n    'CREATE VIEW '||v_test_data||' AS SELECT <PARALLEL_HINT> * FROM \n    ( \n      SELECT t.*  \n      FROM '||getInputSource('" + string10 + "')||' t \n" + "    )'; \n" + "  execSQL(v_sql); \n";
                string7 = StringUtils.getReplacedString(string7, "<PARALLEL_HINT>", string4);
            } else {
                Object object;
                Object object2;
                Object object32;
                String string11 = null;
                List<Object> list = new ArrayList();
                list = this.getModel().findLinksToNode((IlvSDMNode)this);
                for (Object object32 : list) {
                    object2 = (AbstractNode)((GeneralLink)object32).getFrom();
                    if (!((AbstractNode)object2).getMetadataId().equals(string10)) continue;
                    object = (AbstractDataNode)object2;
                    string11 = ((AbstractDataNode)object).getInputSQL();
                    break;
                }
                Object object4 = null;
                object32 = null;
                object2 = null;
                object = new StringBuffer("");
                try {
                    object4 = Connections.getSharedConnection(context);
                    object32 = Connections.getUserAccountName(context);
                    object2 = DatabaseMetadataUtils.createUniqueTempTableName("ODMR$", (Connection)object4);
                    string11 = "SELECT * FROM (" + string11 + ")";
                    DatabaseMetadataUtils.createViewAs((Connection)object4, string11, (String)object32, (String)object2);
                    Map<String, DatabaseMetadataUtils.ColumnInfo> map = DatabaseMetadataUtils.getColumnInfo(context, (String)object2);
                    for (DatabaseMetadataUtils.ColumnInfo columnInfo : map.values()) {
                        if (columnInfo.getDataType().compareToIgnoreCase("CLOB") == 0 || columnInfo.getDataType().compareToIgnoreCase("NCLOB") == 0) {
                            if (((StringBuffer)object).length() > 0) {
                                ((StringBuffer)object).append(",\n" + string6);
                            }
                            ((StringBuffer)object).append("LOB(" + StringUtils.addDoubleQuotes(columnInfo.getColumnName()) + ") STORE AS BASICFILE");
                            continue;
                        }
                        if (columnInfo.getDataType().contains("NESTED")) {
                            if (((StringBuffer)object).length() > 0) {
                                ((StringBuffer)object).append(",\n" + string6);
                            }
                            ((StringBuffer)object).append("NESTED TABLE " + StringUtils.addDoubleQuotes(columnInfo.getColumnName()) + " STORE AS '||generateUniqueName||'");
                            continue;
                        }
                        if (columnInfo.getDataType().compareToIgnoreCase("XMLTYPE") != 0) continue;
                        if (((StringBuffer)object).length() > 0) {
                            ((StringBuffer)object).append(",\n" + string6);
                        }
                        ((StringBuffer)object).append("XMLTYPE COLUMN " + StringUtils.addDoubleQuotes(columnInfo.getColumnName()) + " STORE AS BASICFILE CLOB");
                    }
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
                finally {
                    try {
                        DatabaseMetadataUtils.dropView((Connection)object4, (String)object32, (String)object2);
                    }
                    catch (Exception exception) {
                        theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                    }
                }
                string2 = "TABLE";
                string3 = "TABLE";
                string7 = "  \n  v_build_data := v_input_data; \n  v_test_data := generateUniqueName; \n  v_sql := \n    'CREATE TABLE '||v_test_data||' \n        <STORAGE_CLAUSE> <TABLE_PARALLEL_HINT> COMPRESS \n    AS SELECT <PARALLEL_HINT> * FROM \n    ( \n      SELECT ROWNUM '||v_caseid||', t.*  \n      FROM '||getInputSource('" + string10 + "')||' t \n" + "    )'; \n" + "  execSQL(v_sql); \n";
                string7 = StringUtils.getReplacedString(string7, "<STORAGE_CLAUSE>", ((StringBuffer)object).toString());
                string7 = StringUtils.getReplacedString(string7, "<TABLE_PARALLEL_HINT>", string5);
                string7 = StringUtils.getReplacedString(string7, "<PARALLEL_HINT>", string4);
            }
            bl = true;
        } else if (classificationBuildNodeType.getTestDataSource().getBuildData() != null) {
            if (string != null) {
                string2 = "VIEW";
                string3 = "VIEW";
            } else {
                string2 = "TABLE";
                string3 = "TABLE";
            }
            string7 = "  \n  v_build_data := v_input_data; \n  v_test_data := v_build_data; \n";
            bl = true;
        } else {
            string2 = string != null ? "VIEW" : "TABLE";
            string7 = "  \n  v_build_data := v_input_data; \n";
            bl = false;
        }
        stringBuffer.append(string7);
        stringBuffer.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_build_data, '" + string2 + "', NULL, 'Build Data');\n");
        if (bl) {
            stringBuffer.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_test_data, '" + string3 + "', NULL, 'Test Data');\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean isVersionSupported(Context context, StringBuffer stringBuffer) {
        try {
            if (!super.isVersionSupported(context, stringBuffer)) {
                return false;
            }
            Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
            ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
            if (!ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, version, true)) {
                for (CGeneralizedLinearModelType cGeneralizedLinearModelType : classificationBuildNodeType.getModels().getCGeneralizedLinearModel()) {
                    if (cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSFTRSELECTION() == null && cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSFTRSELCRIT() == null && cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSMAXFEATURES() == null && cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSSELECTBLOCK() == null && cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getODMSAPPROXIMATECOMPUTATION() == null && cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSPRUNEMODEL() == null && cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSFTRACCEPTANCE() == null && cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSFTRGENERATION() == null && cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSFTRGENMETHOD() == null) continue;
                    stringBuffer.append(CodeGenLrb.get("VALIDATE_GLM_BUILD_SETTING_NOT_SUPPORTED"));
                    return false;
                }
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return true;
    }

    @Override
    public String generateCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, String string) throws Exception {
        String string2 = super.generateCode(context, parameterizedSourceDefinitions, string);
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        String string3 = this.generateBuildTestDataCode(context);
        string2 = CodeTemplate.updateBodyTemplate(string2, "<BUILD_TEST_DATA>", string3);
        StringBuffer stringBuffer = new StringBuffer();
        for (NaiveBayesModelType naiveBayesModelType : classificationBuildNodeType.getModels().getNaiveBayesModel()) {
            stringBuffer.append(this.generateBuildTestCode(context, parameterizedSourceDefinitions, (ClassificationModelType)naiveBayesModelType));
        }
        for (NaiveBayesModelType naiveBayesModelType : classificationBuildNodeType.getModels().getCGeneralizedLinearModel()) {
            stringBuffer.append(this.generateBuildTestCode(context, parameterizedSourceDefinitions, (ClassificationModelType)naiveBayesModelType));
        }
        for (NaiveBayesModelType naiveBayesModelType : classificationBuildNodeType.getModels().getCSupportVectorMachineModel()) {
            stringBuffer.append(this.generateBuildTestCode(context, parameterizedSourceDefinitions, (ClassificationModelType)naiveBayesModelType));
        }
        for (NaiveBayesModelType naiveBayesModelType : classificationBuildNodeType.getModels().getDecisionTreeModel()) {
            stringBuffer.append(this.generateBuildTestCode(context, parameterizedSourceDefinitions, (ClassificationModelType)naiveBayesModelType));
        }
        string2 = CodeTemplate.updateBodyTemplate(string2, "<BUILD_MODELS>", stringBuffer.toString());
        return string2;
    }
}

