/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.ConverterHelper;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.codegen.CodeTemplate;
import oracle.dmt.dataminer.workflow.codegen.DatabaseObjectType;
import oracle.dmt.dataminer.workflow.codegen.ParameterizedSourceDefinitions;
import oracle.dmt.dataminer.workflow.codegen.SQLDefinition;
import oracle.dmt.dataminer.workflow.codegen.SourceDefinition;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTransformNode;
import oracle.dmt.dataminer.workflow.model.DataConsumer;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.CreateTableNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DBAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.DBColumnType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;

public final class CreateTableNode
extends AbstractTransformNode
implements DataConsumer {
    private static final Logger theLogger = Logger.getLogger(CreateTableNode.class.getName());
    public static final String INPUT_COLUMNS = NodeMessagesLrb.get("CREATE_TABLE_INPUT");
    public static final String TABLE_SPEC = NodeMessagesLrb.get("CREATE_TABLE_SPEC");
    public static final String ATTR_ALIAS_CHANGED = "attrTableAliasChange";
    public static final String ATTR_INDEX = "attrIndex";
    public static final String ATTR_KEY = "attrKey";
    public static final String AUTO_SPEC = "autoSpec";
    public static final String IS_TABLE = "isTable";
    public static final String TABLE_NAME = "tableName";
    public static final String CREATE_TABLE_PROPERTIES = "createTableProperties";
    public static final String REFACTOR_DB_COLUMNS = "refactorDbColumns";

    public CreateTableNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public String getDefaultName() {
        return ((CreateTableNodeType)this.getData()).getTableName();
    }

    @Override
    public void initNewInstance(Context context) {
        super.initNewInstance(context);
        CreateTableNodeType createTableNodeType = (CreateTableNodeType)this.getData();
        DBAttributes dBAttributes = new DBAttributes();
        dBAttributes.getDBAttribute();
        createTableNodeType.setDBAttributes(dBAttributes);
        createTableNodeType.setTable(true);
        createTableNodeType.getCacheSettings().setUseFullData(Boolean.valueOf(false));
        createTableNodeType.setStatus(NodeStatusType.INVALID);
        String string = "";
        try {
            string = WorkflowUtils.getNewOutputTableNameWfid(context);
            createTableNodeType.setTableName(string);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    @Override
    public Attributes getAttributes() {
        Attributes attributes = new Attributes();
        CreateTableNodeType createTableNodeType = (CreateTableNodeType)this.getData();
        DBAttributes dBAttributes = createTableNodeType.getDBAttributes();
        for (DBColumnType dBColumnType : dBAttributes.getDBAttribute()) {
            AttributeType attributeType = new AttributeType();
            String string = dBColumnType.getAlias() == null ? dBColumnType.getName() : dBColumnType.getAlias();
            attributeType.setName(string);
            attributeType.setDataType(dBColumnType.getDataType());
            attributeType.setStatus(dBColumnType.getStatus());
            attributes.getAttribute().add(attributeType);
        }
        return attributes;
    }

    @Override
    public String generateSQLExpression() {
        List list;
        CreateTableNodeType createTableNodeType = (CreateTableNodeType)this.getData();
        DBAttributes dBAttributes = createTableNodeType.getDBAttributes();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT \n" + (CreateTableNode.generateSQLInlineHint() ? "/*+ inline */ " : ""));
        if (dBAttributes != null && (list = dBAttributes.getDBAttribute()) != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String string = null;
                string = !StringUtils.isDoubleQuotedString(((DBColumnType)list.get(i)).getName()) ? "\"" + ((DBColumnType)list.get(i)).getName() + "\"" : ((DBColumnType)list.get(i)).getName();
                stringBuilder.append(string);
                String string2 = ((DBColumnType)list.get(i)).getAlias();
                if (string2 != null && !string2.isEmpty()) {
                    if (!StringUtils.isDoubleQuotedString(string2)) {
                        string2 = "\"" + string2 + "\"";
                    }
                    stringBuilder.append(" AS ");
                    stringBuilder.append(string2);
                }
                if (i < list.size() - 1) {
                    stringBuilder.append(",\n");
                    continue;
                }
                stringBuilder.append("\n");
            }
        }
        stringBuilder.append(" FROM {INPUT_SOURCE}");
        return this.wrapExpressionInWithClause(stringBuilder.toString());
    }

    @Override
    public String generateCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, String string) {
        Object object;
        String string2;
        String string3;
        Object object22;
        String string4 = null;
        CreateTableNodeType createTableNodeType = (CreateTableNodeType)this.getData();
        String string5 = createTableNodeType.getTableName();
        String string6 = "";
        try {
            string6 = Connections.getUserAccountName(context);
        }
        catch (Exception exception) {
            string6 = "";
        }
        DatabaseObjectType databaseObjectType = createTableNodeType.isTable() ? DatabaseObjectType.CREATE_TABLE : DatabaseObjectType.CREATE_VIEW;
        parameterizedSourceDefinitions.addParameterizedSourceDefinition(this, string6, string5, databaseObjectType);
        Map<String, DatabaseMetadataUtils.ColumnInfo> map = DatabaseMetadataUtils.getColumnInfo(context, string5);
        DBAttributes dBAttributes = createTableNodeType.getDBAttributes();
        ArrayList<DatabaseMetadataUtils.ColumnInfo> arrayList = new ArrayList<DatabaseMetadataUtils.ColumnInfo>(map.size());
        for (Object object22 : dBAttributes.getDBAttribute()) {
            string3 = object22.getKey();
            string2 = object22.getIndex();
            object = map.get(object22.getName());
            if (object == null && object22.getAlias() != null && !object22.getAlias().equals("")) {
                object = map.get(object22.getAlias());
                ((DatabaseMetadataUtils.ColumnInfo)object).setColumnName(object22.getName());
                ((DatabaseMetadataUtils.ColumnInfo)object).setColumnAlias(object22.getAlias());
            }
            ((DatabaseMetadataUtils.ColumnInfo)object).setPrimaryKey(string3);
            ((DatabaseMetadataUtils.ColumnInfo)object).setIndex(string2);
            arrayList.add((DatabaseMetadataUtils.ColumnInfo)object);
        }
        String string7 = parameterizedSourceDefinitions.getParmNameWithAmpersand(this, string6, string5, databaseObjectType);
        object22 = this.findParentNode();
        string3 = "SELECT * FROM ' ||getInputSource('" + ((AbstractNode)object22).getMetadataId() + "')||'";
        string2 = null;
        if (createTableNodeType.isTable()) {
            object = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_TABLE, false);
            String string8 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_INSERT, true);
            String string9 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, false);
            Map<String, StringBuilder> map2 = SQLHelper.buildCreateTableSQL(context, arrayList, string7, (String)object);
            string4 = map2.get("CREATE_STATEMENT").toString();
            string2 = CodeTemplate.updateBodyTemplate(string, "<CREATE_TABLE_SQL_EXPRESSION>", StringUtils.escapeSingleQuotesForSQL(string4));
            string4 = map2.get("CREATE_INDEX").toString();
            string2 = CodeTemplate.updateBodyTemplate(string2, "<CREATE_INDEX_SQL_EXPRESSION>", string4);
            string4 = SQLHelper.populateCreatedTableSQL(arrayList, string7, string3, (AbstractNode)object22, string8, string9);
            string2 = CodeTemplate.updateBodyTemplate(string2, "<INSERT_SQL_EXPRESSION>", string4);
            string2 = CodeTemplate.updateBodyTemplate(string2, "<CREATE_TABLE_NAME>", string7);
        } else {
            object = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, false);
            string4 = SQLHelper.buildCreateViewSQL(arrayList, string7, string3, (String)object);
            string2 = CodeTemplate.updateBodyTemplate(string, "<CREATE_VIEW_SQL_EXPRESSION>", string4);
            string2 = CodeTemplate.updateBodyTemplate(string2, "<CREATE_VIEW_NAME>", string7);
        }
        return string2;
    }

    @Override
    public boolean validate(boolean bl) {
        Object object;
        boolean bl2 = super.validate(bl);
        CreateTableNodeType createTableNodeType = (CreateTableNodeType)this.getData();
        DBAttributes dBAttributes = new DBAttributes();
        List list = dBAttributes.getDBAttribute();
        if (createTableNodeType.getDBAttributes() != null) {
            CreateTableNode.copyDBColumnType(list, createTableNodeType.getDBAttributes().getDBAttribute());
        }
        this.validateAttributes();
        this.excecuteInputColumnsTxn(createTableNodeType.getDBAttributes(), dBAttributes);
        if (null == createTableNodeType.getDBAttributes() || null == createTableNodeType.getDBAttributes().getDBAttribute() || createTableNodeType.getDBAttributes().getDBAttribute().isEmpty()) {
            bl2 = false;
            this.addMessage("CREATE_TABLE_INCOMPLETE", MessageEnumType.INCOMPLETE, new String[0]);
        } else if (null != createTableNodeType.getDBAttributes() && null != createTableNodeType.getDBAttributes().getDBAttribute() && !(object = createTableNodeType.getDBAttributes().getDBAttribute()).isEmpty()) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                DBColumnType dBColumnType = (DBColumnType)iterator.next();
                if (dBColumnType.getStatus().equals((Object)AttributeStatus.VALID)) continue;
                bl2 = false;
                this.addMessage("DATASRC_INVALID_ATTR", MessageEnumType.WARNING, new String[0]);
                break;
            }
        }
        object = createTableNodeType.getTableName();
        if (!StringUtils.isDoubleQuotedString((String)object) && !StringUtils.containsNoDot((String)object)) {
            bl2 = false;
            this.addMessage("CREATE_TABLE_INVALID_OUPUT_TABLE_NAME", MessageEnumType.INCOMPLETE, new String[0]);
        }
        if (((String)object).length() > 30) {
            bl2 = false;
            this.addMessage("CREATE_TABLE_NAME_TOO_LONG", MessageEnumType.INCOMPLETE, new String[0]);
        }
        this.setState(bl2);
        if (CreateTableNode.isAutoSpec(createTableNodeType) || bl) {
            this.validateChildren();
        }
        return bl2;
    }

    @Override
    public Object getProperty(String string) {
        CreateTableNodeType createTableNodeType = (CreateTableNodeType)this.getData();
        Object object = null;
        if (string.equals(INPUT_COLUMNS)) {
            DBAttributes dBAttributes;
            object = dBAttributes = createTableNodeType.getDBAttributes();
        } else if (string.equals(CREATE_TABLE_PROPERTIES)) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(AUTO_SPEC, createTableNodeType.getAutoSpec());
            hashMap.put(IS_TABLE, createTableNodeType.isTable());
            hashMap.put(TABLE_NAME, createTableNodeType.getTableName());
            hashMap.put(INPUT_COLUMNS, createTableNodeType.getDBAttributes());
            object = hashMap;
        } else if (string.equals("SQL_EXPRESSION")) {
            object = this.getSQLExpression();
        } else if (string.equals(REFACTOR_DB_COLUMNS)) {
            DBAttributes dBAttributes;
            object = dBAttributes = createTableNodeType.getDBAttributes();
        } else {
            return super.getProperty(string);
        }
        return object;
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(AUTO_SPEC)) {
            CreateTableNodeType createTableNodeType = (CreateTableNodeType)this.getData();
            return createTableNodeType.getAutoSpec();
        }
        if (complexProperty.getPropertyName().equals(IS_TABLE)) {
            CreateTableNodeType createTableNodeType = (CreateTableNodeType)this.getData();
            return createTableNodeType.isTable();
        }
        if (complexProperty.getPropertyName().equals(TABLE_NAME)) {
            CreateTableNodeType createTableNodeType = (CreateTableNodeType)this.getData();
            return createTableNodeType.getTableName();
        }
        if (complexProperty.getPropertyName().equals(ATTR_ALIAS_CHANGED) || complexProperty.getPropertyName().equals(ATTR_INDEX) || complexProperty.getPropertyName().equals(ATTR_KEY)) {
            CreateTableNodeType createTableNodeType = (CreateTableNodeType)this.getData();
            DBColumnType dBColumnType = (DBColumnType)complexProperty.getOldData();
            boolean bl = false;
            List list = createTableNodeType.getDBAttributes().getDBAttribute();
            for (DBColumnType dBColumnType2 : list) {
                dBColumnType = (DBColumnType)complexProperty.getOldData();
                if (!dBColumnType2.getName().equals(dBColumnType.getName())) continue;
                bl = true;
                break;
            }
            return bl ? dBColumnType : null;
        }
        if (complexProperty.getPropertyName().equals(INPUT_COLUMNS) || complexProperty.getPropertyName().equals(REFACTOR_DB_COLUMNS) || complexProperty.getPropertyName().equals("SQL_EXPRESSION")) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public void setProperty(String string, Object object) {
        CreateTableNodeType createTableNodeType = (CreateTableNodeType)this.getData();
        String string2 = createTableNodeType.getTableName();
        String string3 = createTableNodeType.getName();
        if (string.equals(INPUT_COLUMNS)) {
            DBAttributes dBAttributes = (DBAttributes)object;
            createTableNodeType.setDBAttributes(dBAttributes);
        } else if (string.equals(REFACTOR_DB_COLUMNS)) {
            DBAttributes dBAttributes = (DBAttributes)object;
            createTableNodeType.setDBAttributes(dBAttributes);
        } else if (string.equals(AUTO_SPEC)) {
            createTableNodeType.setAutoSpec((AutoSpecType)object);
        } else if (string.equals(IS_TABLE)) {
            createTableNodeType.setTable(((Boolean)object).booleanValue());
        } else if (string.equals(TABLE_NAME)) {
            createTableNodeType.setTableName((String)object);
            if (string2.equals(string3) || string3 == null || "".equals(string3)) {
                createTableNodeType.setName((String)object);
            }
        } else if (string.equals(ATTR_ALIAS_CHANGED)) {
            List list = createTableNodeType.getDBAttributes().getDBAttribute();
            DBColumnType dBColumnType = (DBColumnType)object;
            for (DBColumnType dBColumnType2 : list) {
                if (!dBColumnType2.getName().equals(dBColumnType.getName())) continue;
                String string4 = dBColumnType.getAlias();
                if (string4 != null && string4.trim().isEmpty()) {
                    string4 = null;
                }
                dBColumnType2.setAlias(string4);
                break;
            }
        } else if (string.equals(ATTR_KEY)) {
            List list = createTableNodeType.getDBAttributes().getDBAttribute();
            DBColumnType dBColumnType = (DBColumnType)object;
            String string5 = dBColumnType.getKey();
            for (DBColumnType dBColumnType3 : list) {
                if (!dBColumnType3.getName().equals(dBColumnType.getName())) continue;
                dBColumnType3.setKey(string5);
                if (!string5.equals("Yes")) continue;
                dBColumnType3.setIndex("No");
            }
        } else if (string.equals(ATTR_INDEX)) {
            List list = createTableNodeType.getDBAttributes().getDBAttribute();
            DBColumnType dBColumnType = (DBColumnType)object;
            String string6 = dBColumnType.getIndex();
            for (DBColumnType dBColumnType4 : list) {
                if (!dBColumnType4.getName().equals(dBColumnType.getName())) continue;
                dBColumnType4.setIndex(string6);
                if (!string6.equals("Yes")) continue;
                dBColumnType4.setKey("No");
            }
        } else if (string.equals(CREATE_TABLE_PROPERTIES)) {
            Map<String, Object> map = ConverterHelper.objectToMapStringObject(object);
            Object object2 = map.get(AUTO_SPEC);
            AutoSpecType autoSpecType = (AutoSpecType)object2;
            createTableNodeType.setAutoSpec(autoSpecType);
            object2 = map.get(IS_TABLE);
            boolean bl = (Boolean)object2;
            createTableNodeType.setTable(bl);
            object2 = map.get(TABLE_NAME);
            String string7 = (String)object2;
            createTableNodeType.setTableName(string7);
            if (string2.equals(string3) || string3 == null || "".equals(string3)) {
                createTableNodeType.setName(string7);
            }
            object2 = map.get(INPUT_COLUMNS);
            DBAttributes dBAttributes = (DBAttributes)object2;
            createTableNodeType.setDBAttributes(dBAttributes);
        } else if (string.equals("SQL_EXPRESSION")) {
            if (object != null && object.equals("SQL_EXPRESSION_GENERATE")) {
                this.setSQLExpression(this.generateSQLExpression());
            } else {
                this.setSQLExpression((String)object);
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public void setNodeReady() {
        ((CreateTableNodeType)this.getData()).setSQLExpression(this.generateSQLExpression());
        super.setNodeReady();
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        List list;
        super.handleNewConnectionFrom(node);
        CreateTableNodeType createTableNodeType = (CreateTableNodeType)this.getData();
        DBAttributes dBAttributes = createTableNodeType.getDBAttributes();
        if (dBAttributes == null) {
            dBAttributes = new DBAttributes();
            createTableNodeType.setDBAttributes(dBAttributes);
        }
        if ((list = dBAttributes.getDBAttribute()).isEmpty() && node instanceof DataProvider) {
            Attributes attributes = ((DataProvider)((Object)node)).getAttributes();
            List list2 = attributes.getAttribute();
            CreateTableNode.copyAttributes(list, list2);
            this.excecuteInputColumnsTxn(dBAttributes, new DBAttributes());
        }
        this.validate(false);
    }

    public static void copyAttributes(List<DBColumnType> list, List<AttributeType> list2) {
        for (AttributeType attributeType : list2) {
            DBColumnType dBColumnType = new DBColumnType();
            dBColumnType.setName(attributeType.getAlias() != null && !attributeType.getAlias().trim().isEmpty() ? attributeType.getAlias() : attributeType.getName());
            dBColumnType.setDataType(attributeType.getDataType());
            dBColumnType.setStatus(AttributeStatus.VALID);
            dBColumnType.setAnnotation(attributeType.getAnnotation());
            dBColumnType.setIndex("No");
            dBColumnType.setKey("No");
            list.add(dBColumnType);
        }
    }

    private static boolean isColumnIncluded(List<DBColumnType> list, AttributeType attributeType) {
        boolean bl = false;
        for (DBColumnType dBColumnType : list) {
            if (!dBColumnType.getName().equals(attributeType.getName()) || dBColumnType.getAlias() == null || attributeType.getAlias() == null || !dBColumnType.getAlias().equals(attributeType.getAlias())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static void copyAliasedAttributes(List<DBColumnType> list, List<DBColumnType> list2) {
        for (AttributeType attributeType : list2) {
            if (CreateTableNode.isColumnIncluded(list, attributeType)) continue;
            DBColumnType dBColumnType = new DBColumnType();
            dBColumnType.setName(attributeType.getName());
            dBColumnType.setAlias(attributeType.getAlias());
            dBColumnType.setDataType(attributeType.getDataType());
            dBColumnType.setStatus(attributeType.getStatus());
            dBColumnType.setAnnotation(attributeType.getAnnotation());
            dBColumnType.setIndex("No");
            dBColumnType.setKey("No");
            list.add(dBColumnType);
        }
    }

    public static void copyDBColumnType(List<DBColumnType> list, List<DBColumnType> list2) {
        for (DBColumnType dBColumnType : list2) {
            DBColumnType dBColumnType2 = new DBColumnType();
            dBColumnType2.setName(dBColumnType.getName());
            dBColumnType2.setAlias(dBColumnType.getAlias());
            dBColumnType2.setDataType(dBColumnType.getDataType());
            dBColumnType2.setStatus(dBColumnType.getStatus());
            dBColumnType2.setAnnotation(dBColumnType.getAnnotation());
            dBColumnType2.setIndex(dBColumnType.getIndex());
            dBColumnType2.setKey(dBColumnType.getKey());
            list.add(dBColumnType2);
        }
    }

    private static DBColumnType copyColumn(DBColumnType dBColumnType) {
        DBColumnType dBColumnType2 = new DBColumnType();
        dBColumnType2.setName(dBColumnType.getName());
        dBColumnType2.setAlias(dBColumnType.getAlias());
        dBColumnType2.setDataType(dBColumnType.getDataType());
        dBColumnType2.setStatus(dBColumnType.getStatus());
        dBColumnType2.setAnnotation(dBColumnType.getAnnotation());
        dBColumnType2.setIndex(dBColumnType.getIndex());
        dBColumnType2.setKey(dBColumnType.getKey());
        return dBColumnType2;
    }

    public static void reloadAttributesFromDataProvider(List<DBColumnType> list, DataProvider dataProvider) {
        DBColumnType dBColumnType;
        Attributes attributes = dataProvider != null ? dataProvider.getAttributes() : null;
        List list2 = attributes != null ? attributes.getAttribute() : null;
        ArrayList<DBColumnType> arrayList = new ArrayList<DBColumnType>();
        HashMap<String, DBColumnType> hashMap = new HashMap<String, DBColumnType>();
        for (DBColumnType dBColumnType2 : list) {
            dBColumnType = CreateTableNode.copyColumn(dBColumnType2);
            if (dBColumnType2.getAlias() != null) {
                DBColumnType dBColumnType3 = CreateTableNode.copyColumn(dBColumnType2);
                dBColumnType3.setStatus(AttributeStatus.INVALID);
                if (!CreateTableNode.isColumnIncluded(arrayList, (AttributeType)dBColumnType3)) {
                    arrayList.add(dBColumnType3);
                }
            }
            hashMap.put(dBColumnType.getName(), dBColumnType);
        }
        list.clear();
        if (list2 != null) {
            CreateTableNode.copyAttributes(list, list2);
        }
        for (DBColumnType dBColumnType2 : list) {
            dBColumnType = (DBColumnType)hashMap.get(dBColumnType2.getName());
            if (dBColumnType == null) continue;
            dBColumnType2.setKey(dBColumnType.getKey());
            dBColumnType2.setIndex(dBColumnType.getIndex());
            dBColumnType2.setAlias(dBColumnType.getAlias());
        }
        if (!arrayList.isEmpty()) {
            CreateTableNode.copyAliasedAttributes(list, arrayList);
        }
    }

    private void validateAttributes() {
        CreateTableNodeType createTableNodeType = (CreateTableNodeType)this.getData();
        AbstractNode abstractNode = this.findParentNode();
        DataProvider dataProvider = (DataProvider)((Object)abstractNode);
        if (CreateTableNode.isAutoSpec(createTableNodeType)) {
            DBAttributes dBAttributes = createTableNodeType.getDBAttributes();
            List list = dBAttributes.getDBAttribute();
            CreateTableNode.reloadAttributesFromDataProvider(list, dataProvider);
        } else {
            List list3;
            Attributes attributes = dataProvider != null ? dataProvider.getAttributes() : null;
            List list2 = attributes != null ? attributes.getAttribute() : null;
            HashMap<DBColumnType, List> hashMap = new HashMap<DBColumnType, List>();
            if (list2 != null) {
                for (List list3 : list2) {
                    String string = list3.getAlias();
                    Object object = string != null && string.trim().length() > 0 ? string : list3.getName();
                    hashMap.put((DBColumnType)object, list3);
                }
            }
            DBAttributes dBAttributes = createTableNodeType.getDBAttributes();
            list3 = dBAttributes.getDBAttribute();
            for (Object object : list3) {
                String string = object.getName();
                AttributeType attributeType = (AttributeType)hashMap.get(string);
                if (null != attributeType) continue;
                object.setStatus(AttributeStatus.MISSING);
            }
        }
    }

    public static boolean isAutoSpec(CreateTableNodeType createTableNodeType) {
        AutoSpecType autoSpecType = createTableNodeType.getAutoSpec();
        if (autoSpecType == null) {
            return false;
        }
        return 0 == autoSpecType.value().compareTo("Yes");
    }

    private void excecuteInputColumnsTxn(DBAttributes dBAttributes, DBAttributes dBAttributes2) {
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        ComplexProperty complexProperty = new ComplexProperty(INPUT_COLUMNS, dBAttributes);
        complexProperty.setOldData(dBAttributes2);
        ArrayList<ComplexProperty> arrayList = new ArrayList<ComplexProperty>();
        arrayList.add(complexProperty);
        ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        complexProperty2.setOldData(this.getSQLExpression());
        arrayList.add(complexProperty2);
        odmrSDMUndoFilter.prepareUndoComplexPropertyList(this, this.getContext(), arrayList);
    }

    @Override
    protected void getInternalStackedSQL(AbstractDataNode abstractDataNode, StringBuffer stringBuffer) {
        boolean bl;
        boolean bl2 = bl = this.getState().equals((Object)NodeStatusType.COMPLETE) || this.getState().equals((Object)NodeStatusType.READY) || !this.getState().equals((Object)NodeStatusType.FAILURE) || !this.getState().equals((Object)NodeStatusType.INVALID);
        if (!bl) {
            return;
        }
        CreateTableNodeType createTableNodeType = (CreateTableNodeType)this.getData();
        String string = createTableNodeType.getTableName();
        if (stringBuffer.indexOf("{INPUT_SOURCE}") > 0) {
            int n = stringBuffer.indexOf("{INPUT_SOURCE}");
            int n2 = n + "{INPUT_SOURCE}".length();
            stringBuffer.replace(n, n2, "(\"" + string + "\")");
        } else {
            String string2 = "{INPUT_SOURCE:<NodeId>}".replace("<NodeId>", createTableNodeType.getId());
            if (stringBuffer.indexOf(string2) > 0) {
                int n = stringBuffer.indexOf(string2);
                int n3 = n + string2.length();
                stringBuffer.replace(n, n3, "(" + string + ")");
            }
        }
    }

    @Override
    public ArrayList<SourceDefinition> getLineageSources() throws Exception {
        ArrayList<SourceDefinition> arrayList = new ArrayList<SourceDefinition>();
        CreateTableNodeType createTableNodeType = (CreateTableNodeType)this.getData();
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.getContext());
        SourceDefinition sourceDefinition = new SourceDefinition(this, connectionFolder.getUserAccountName(), createTableNodeType.getTableName(), DatabaseObjectType.TABLE_OR_VIEW);
        arrayList.add(sourceDefinition);
        return arrayList;
    }

    @Override
    public SQLDefinition getLineageSQLDefinition(AbstractNode abstractNode, SQLDefinition sQLDefinition) throws Exception {
        if (!this.canGenerateLineageSQL()) {
            throw new Exception(NodeMessagesLrb.get("CODE_GEN_ERROR_NODE_STATE_INVALID"));
        }
        CreateTableNodeType createTableNodeType = (CreateTableNodeType)this.getData();
        StringBuffer stringBuffer = sQLDefinition.getSql();
        String string = sQLDefinition.getSourceDefinitionsForNode(this).get(0).getParmNameWithAmpersand();
        if (stringBuffer.indexOf("{INPUT_SOURCE}") > 0) {
            int n = stringBuffer.indexOf("{INPUT_SOURCE}");
            int n2 = n + "{INPUT_SOURCE}".length();
            stringBuffer.replace(n, n2, "(" + string + ")");
        } else {
            String string2 = "{INPUT_SOURCE:<NodeId>}".replace("<NodeId>", createTableNodeType.getId());
            if (stringBuffer.indexOf(string2) > 0) {
                int n = stringBuffer.indexOf(string2);
                int n3 = n + string2.length();
                stringBuffer.replace(n, n3, "(" + string + ")");
            }
        }
        return sQLDefinition;
    }

    @Override
    public String getHelpTopic() {
        return "createtable_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_CREATE_TABLE_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_CREATE_TABLE_ICON"));
    }

    @Override
    protected boolean canGenerateLineageSQL() {
        boolean bl;
        boolean bl2 = bl = this.getData().getStatus() == NodeStatusType.COMPLETE || this.getData().getStatus() == NodeStatusType.WARNING;
        return bl;
    }

    @Override
    public void refactor(Node node, boolean bl) throws Exception {
        if (!bl) {
            try {
                String string = ((CreateTableNodeType)this.getData()).getTableName();
                String string2 = this.getRefactorTableName(string, this.getContext());
                if (!string.equals(string2)) {
                    OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
                    odmrSDMUndoFilter.prepareUndo(this, this.getContext(), TABLE_NAME, string2);
                    this.getModel().addRefactoredTableName(string, string2);
                }
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
        super.refactor(node, bl);
    }

    @Override
    public void refactorAttributes(Node node, Map<String, AttributeType> map) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        DBAttributes dBAttributes = new DBAttributes();
        List list = dBAttributes.getDBAttribute();
        CreateTableNodeType createTableNodeType = (CreateTableNodeType)this.getData();
        DBAttributes dBAttributes2 = createTableNodeType.getDBAttributes();
        List list2 = dBAttributes2.getDBAttribute();
        for (DBColumnType dBColumnType : list2) {
            AttributeType attributeType = map.get(dBColumnType.getName());
            DBColumnType dBColumnType2 = (DBColumnType)MetaDataHelper.copyMetadataObject(dBColumnType);
            if (!(attributeType == null || dBColumnType.getName().equals(attributeType.getName()) && dBColumnType.getDataType().equals(attributeType.getDataType()))) {
                String string = dBColumnType.getName();
                dBColumnType2.setName(attributeType.getName());
                if (CreateTableNode.isAutoSpec(createTableNodeType)) {
                    dBColumnType2.setDataType(attributeType.getDataType());
                }
                hashMap.put(string, (AttributeType)dBColumnType2);
            }
            list.add(dBColumnType2);
        }
        if (!hashMap.isEmpty()) {
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), REFACTOR_DB_COLUMNS, dBAttributes);
            this.refactorChildrenAttributes(this, hashMap);
        }
    }
}

